//------------------------------------------------------------------------------------------
//Rev	date		name	description	
//------------------------------------------------------------------------------------------
//		09/23/08	marty	Libupnp initial version
//M01	10/23/08	marty	The presentationURL field in XML file needs http port.

#define state_null					0
#define state_run					1
#define state_stop					2

#define OS_VERSION					"linux-2.6.14"

typedef struct
{
	int state;							//upnp thread state
	int multicast_sock_fd;				//The socket file description of multicast 
	int ctrl_point_sock_fd;				//The socket file description of control point
	int send_xml_sock_fd1;				//The socket file description to send xml file
	int send_xml_sock_fd2;				//The socket file description to send xml file
	char friendlyName[32];				//short user-friendly title
	char manufacturer[32];				//manufacturer name
	char manufacturerURL[32];			//URL to manufacturer site
	char modelDescription[64];			//long user-friendly title
	char modelName[32];					//model name
	char modelNumber[32];				//model number
	char modelURL[32];					//URL to model site
	char serialNumber[32];				//manufacturer's serial number
	char UDN[64];						//Unique Device Name, the format must be "uuid:xxxxxxxxxxxxxxxxxx"
	char presentationURL[32];			//Wan ip of device
	int  http_port;				//M01	//The http port
	int  duration;						//The duration time of Adversetiment. The suggesting value is 1800 seconds
} UpnpConf;

int Upnp_Start(UpnpConf *);
int Upnp_Stop(UpnpConf *);
