/*
  libsmtp is a library to send mail via SMTP
   
Copyright ?2001 Kevin Read <obsidian@berlios.de>

This software is available under the GNU Lesser Public License as described
in the COPYING file.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Kevin Read <obsidian@berlios.de>
Thu Aug 16 2001 */

#include <glib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <stdlib.h>
#include <netdb.h>
#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#include "../config.h"
#include "libsmtp.h"
#include "digestmd5.h"


enum CODEC { BASE64, BASE64_NIL };

static char CAfile[]="/var/www/CAcertSrv.pem";
#ifdef MATRIXSSL
static int certChecker(sslCertInfo_t *cert, void *arg)
{
	sslCertInfo_t	*next;
	sslKeys_t		*keys;
/*
	Make sure we are checking the last cert in the chain
*/
	next = cert;
	keys = arg;
	while (next->next != NULL) {
		next = next->next;
	}
#if ENFORCE_CERT_VALIDATION
/*
	This case passes the true RSA authentication status through
*/
	return next->verified;
#else
/*
	This case passes an authenticated server through, but flags a
	non-authenticated server correctly.  The user can call the
	matrixSslGetAnonStatus later to see the status of this connection.
*/
	if (next->verified != 1) {
		return SSL_ALLOW_ANON_CONNECTION;
	}
	return next->verified;
#endif /* ENFORCE_CERT_VALIDATION */
}		
#endif /* MATRIXSSL */
static int _libsmtp_login(struct libsmtp_session_struct *libsmtp_session)
{
	GString *libsmtp_temp_gstring;	/* Temp gstring */
	gchar temp_buffer[255];	/* Temp string for reads and writes */
	int ret = LIBSMTP_ERRORSENDFATAL;
	char *encode;

	libsmtp_temp_gstring = g_string_new (NULL);

	g_string_sprintf (libsmtp_temp_gstring, "AUTH LOGIN\r\n");
	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		goto Failed;

	printf("send %s\n", libsmtp_temp_gstring->str);
	if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
	  goto Failed;

	printf("username: %s\n", (char *)libsmtp_session->username->str);
	encode = (char *)b64encode_alloc((char *)libsmtp_session->username->str, libsmtp_session->username->len);
	b64encode(libsmtp_session->username->str, libsmtp_session->username->len, encode);
	g_string_sprintf(libsmtp_temp_gstring, "%s\r\n", encode);
	b64_free(encode);

	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		goto Failed;
	
	if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
		goto Failed;


	printf("password: %s\n", (char *)libsmtp_session->password->str);
	encode = (char *)b64encode_alloc((char *)libsmtp_session->password->str, libsmtp_session->password->len);
	b64encode(libsmtp_session->password->str, libsmtp_session->password->len, encode);
	g_string_sprintf(libsmtp_temp_gstring, "%s\r\n", encode);
	b64_free(encode);

	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		goto Failed;
	
	if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
		goto Failed;

	if (libsmtp_session->LastResponseCode != 235){
		libsmtp_session->ErrorCode = LIBSMTP_AUTHFAILED;
		ret = libsmtp_session->ErrorCode;
		goto Failed;
	}
	ret = LIBSMTP_NOERR;

Failed:
	g_string_free(libsmtp_temp_gstring, 1);
	return ret;
	
}

static int _libsmtp_plain(struct libsmtp_session_struct *libsmtp_session)
{
	GString *up;
	int ret = LIBSMTP_ERRORSENDFATAL;
	char *encode;

	up = g_string_new(NULL);

	g_string_sprintf(up, "%s%s", (char *)libsmtp_session->username->str, (char *)libsmtp_session->password->str);
	g_string_insert_c(up, 0, '\0');
	g_string_insert_c(up, libsmtp_session->username->len+1, '\0');

	encode = (char *)b64encode_alloc((char *)up->str, up->len);
	b64encode(up->str, up->len, encode);
	g_string_assign(up, "AUTH PLAIN ");
	g_string_append(up, encode);
	g_string_append(up, "\r\n");
	b64_free(encode);

	if (libsmtp_int_send (up, libsmtp_session))
		goto Failed;

	if (libsmtp_int_read (up, libsmtp_session, 0))
	  goto Failed;

	if (libsmtp_session->LastResponseCode != 235) {
		libsmtp_session->ErrorCode = LIBSMTP_AUTHFAILED;
		ret = libsmtp_session->ErrorCode;
		goto Failed;
	}
	ret = LIBSMTP_NOERR;
Failed:
	g_string_free(up, 1);
	return ret;

}

static int _libsmtp_cram_md5(struct libsmtp_session_struct *libsmtp_session)
{
	GString *libsmtp_temp_gstring;	/* Temp gstring */
	gchar temp_buffer[255], temp_buff2[255];	/* Temp string for reads and writes */
	unsigned char *challenge, *decoded, *encoded;
	unsigned char digest[16];
	unsigned char digasc[33];
	char hextab[] = "0123456789abcdef";
	int i, ret = LIBSMTP_ERRORSENDFATAL;
    
	libsmtp_temp_gstring = g_string_new (NULL);
	g_string_sprintf (libsmtp_temp_gstring, "AUTH CRAM-MD5\r\n");
	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		goto Failed;

	if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
	  goto Failed;

	challenge = (char *)b64decode_alloc(libsmtp_session->LastResponse->str);
	b64decode(libsmtp_session->LastResponse->str, challenge);
	hmac_md5(challenge, strlen(challenge), libsmtp_session->password->str, \
			 libsmtp_session->password->len, digest);
	free(challenge);
	digasc[32] = 0;
	for (i = 0; i < 16; i++) {
	  digasc[2*i] = hextab[digest[i] >> 4];
	  digasc[2*i+1] = hextab[digest[i] & 0xf];
	}
	printf("digest: %s\n", digasc);

	decoded = (unsigned char *) malloc(libsmtp_session->username->len+strlen(digasc)+2);

	strcpy(decoded, libsmtp_session->username->str);
	decoded[libsmtp_session->username->len] = ' ';
	strcpy(decoded+libsmtp_session->username->len+1, digasc);
	decoded[libsmtp_session->username->len+strlen(digasc)+1] = 0;

	printf("base64 ready to encode: %s\n", decoded);

	encoded = (char *)b64encode_alloc(decoded, strlen(decoded));
	b64encode(decoded, strlen(decoded), encoded);
	b64_free(decoded);

	printf("base64 encoded: %s\n", encoded);

	g_string_assign(libsmtp_temp_gstring, encoded);
	g_string_append(libsmtp_temp_gstring, "\r\n");
	free(encoded);

	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		goto Failed;
    
	if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
	  goto Failed;

	if (libsmtp_session->LastResponseCode != 235) {//354
		libsmtp_session->ErrorCode = LIBSMTP_AUTHFAILED;
		ret = libsmtp_session->ErrorCode;
		goto Failed;
	}
	ret = LIBSMTP_NOERR;

Failed:
	g_string_free(libsmtp_temp_gstring, 1);
	return ret;

}

static int _libsmtp_digest_md5(struct libsmtp_session_struct *libsmtp_session)
{
	GString *libsmtp_temp_gstring;	/* Temp gstring */
    char **realms = NULL;
    int nrealm = 0;
	char *challenge;
	int ret = LIBSMTP_ERRORSENDFATAL;
	char *data, *encoded;
	int datalen;
	context_t ctext;

	memset(&ctext, 0, sizeof(context_t));

	libsmtp_temp_gstring = g_string_new (NULL);
	g_string_sprintf (libsmtp_temp_gstring, "AUTH DIGEST-MD5\r\n");
	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		goto Failed;

	//step 1
	if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
	  goto Failed;

	if (!(challenge = (char *)b64decode_alloc(libsmtp_session->LastResponse->str)))
		goto Failed;

	b64decode(libsmtp_session->LastResponse->str, challenge);
	printf("b64decode --> \n%s\n", challenge);

	//step 2
	ctext.serverFQDN = libsmtp_session->server;
	if (digestmd5_client_mech_step2(&ctext, challenge, strlen(challenge), \
							libsmtp_session->username->str, libsmtp_session->password->str, \
							&data, &datalen) == -1) {
		b64_free(challenge);
		goto Failed2;
	}
	b64_free(challenge);
	printf("data %s\n", data);

	encoded = (char *)b64encode_alloc(data, datalen);
	b64encode(data, datalen, encoded);

//	printf("base64 encoded: %s\n", encoded);

	g_string_assign(libsmtp_temp_gstring, encoded);
	g_string_append(libsmtp_temp_gstring, "\r\n");
	b64_free(encoded);

	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session)) 
		goto Failed2;

	if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0)) 
		goto Failed2;

	challenge = (char *)b64decode_alloc(libsmtp_session->LastResponse->str);
	b64decode(libsmtp_session->LastResponse->str, challenge);
//	printf("b64decode --> \n%s\n", challenge);

	if (digestmd5_client_mech_step3(&ctext, challenge, strlen(challenge))) {
		b64_free(challenge);
		goto Failed2;
	}

	b64_free(challenge);
	g_string_assign(libsmtp_temp_gstring, "\r\n");
	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		goto Failed2;
	if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
		goto Failed2;

	ret = LIBSMTP_NOERR;

Failed2:
	digestmd5_free(&ctext);
Failed:
	g_string_free(libsmtp_temp_gstring, 1);
	return ret;
}

static int _lib_smtp_authenticate(int libsmtp_flags, struct libsmtp_session_struct *libsmtp_session)
{
	//if (libsmtp_flags & libsmtp_session->server_auth || libsmtp_session->server_auth == NO_AUTH) {
		switch (libsmtp_flags) {
		case LOGIN:
			return _libsmtp_login(libsmtp_session);
		case PLAIN:
			return _libsmtp_plain(libsmtp_session);
		case CRAM_MD5:
			return _libsmtp_cram_md5(libsmtp_session);
		case DIGEST_MD5:
			return _libsmtp_digest_md5(libsmtp_session);
		case POP_RELAY:
			return LIBSMTP_NOERR;
		default:
			return LIBSMTP_ERRORSENDFATAL;
		}
	//}
	return LIBSMTP_ERRORSENDFATAL;
}

int pop_before_smtp_relay(struct libsmtp_session_struct *session)
{
	int pop3sock, ret = -1;
	struct hostent *libsmtp_mailhost;	/* We need this to convert the hostname to an IP */
	struct sockaddr_in libsmtp_sock;
	char rec_buffer[256];
	char snd_buffer[256];

	if ((pop3sock = socket (PF_INET, SOCK_STREAM, 0)) < 0)
		return ret;

//	g_string_assign(session->pop3server, "msa.hinet.net");//pop3.pchome.com.tw
	/* Now we need to get the IP from the hostname... */
	if ((libsmtp_mailhost=gethostbyname((const char *)session->pop3server->str))==NULL) {
	  close (pop3sock);
	  return ret;
	}

	/* This struct is needed for the connect call */
	libsmtp_sock.sin_family = AF_INET;
	libsmtp_sock.sin_addr = *(struct in_addr *)libsmtp_mailhost->h_addr;
	  libsmtp_sock.sin_port = htons (110); // pop3 default port

	if (connect (pop3sock, (struct sockaddr *) &libsmtp_sock, sizeof (libsmtp_sock) ) < 0) {
	  close (pop3sock);
	  return ret;
	}
	if (libsmtp_pop3_read(pop3sock, rec_buffer, sizeof(rec_buffer), 0) < 0) {
		close (pop3sock);
		return ret;
	}

	if (libsmtp_pop3_write(pop3sock, "AUTH\r\n", 6) < 0){
		close (pop3sock);
		return ret;
	}
	if (libsmtp_pop3_read(pop3sock, rec_buffer, sizeof(rec_buffer), 0) < 0) {
		close (pop3sock);
		return ret;
	}

	sprintf(snd_buffer, "USER %s\r\n", session->username->str);
	if (libsmtp_pop3_write(pop3sock, snd_buffer, strlen(snd_buffer)) < 0){
		close (pop3sock);
		return ret;
	}
	if (libsmtp_pop3_read(pop3sock, rec_buffer, sizeof(rec_buffer), 1) <= 0) {
		close (pop3sock);
		return ret;
	}

	sprintf(snd_buffer, "PASS %s\r\n", session->password->str);
	if (libsmtp_pop3_write(pop3sock, snd_buffer, strlen(snd_buffer)) < 0){
		close (pop3sock);
		return ret;
	}
	if (libsmtp_pop3_read(pop3sock, rec_buffer, sizeof(rec_buffer), 1) <= 0) {
		close (pop3sock);
		return ret;
	}

	if (libsmtp_pop3_write(pop3sock, "QUIT\r\n", 6) < 0){
		close (pop3sock);
		return ret;
	}
	if (libsmtp_pop3_read(pop3sock, rec_buffer, sizeof(rec_buffer), 1) <= 0) {
		close (pop3sock);
		return ret;
	}

	close (pop3sock);
	return 0;

}

int libsmtp_connect (char *libsmtp_server, unsigned int libsmtp_port, int wait_timeout, \
					 struct libsmtp_session_struct *libsmtp_session)
{
  int ret1;
  int libsmtp_socket; 		/* The temporary socket handle */
  int libsmtp_bytes_read=0, ret;     /* How many bytes read? */
  struct hostent *libsmtp_mailhost;	/* We need this to convert the hostname to an IP */
  struct sockaddr_in libsmtp_sock;	/* We need this for the connection */
  gchar libsmtp_temp_buffer[4096];	/* Temp string for reads and writes */
//  char *libsmtp_search_buffer;		/* Used for searching in strings */
  GString *libsmtp_temp_gstring;	/* Temp gstring */
  char *srh_auth;
  int flags;
  struct timeval tv;
  char *sender, *helloStr;
  fd_set writefds, readfds;
#ifdef OPENSSL
    libsmtp_session->method  = 0;
    libsmtp_session->ctx     = 0;
    libsmtp_session->ssl     = 0;
#endif

  ret = LIBSMTP_ERRORSENDFATAL;
  /* We clear up the variable space and instantiate the GStrings */
  if (libsmtp_session->auth_type == POP_RELAY) {
	  if (pop_before_smtp_relay(libsmtp_session) ) {
		  libsmtp_session->ErrorCode = LIBSMTP_AUTHFAILED;
		  return LIBSMTP_AUTHFAILED;
	  }
  }

  bzero (libsmtp_temp_buffer, sizeof(libsmtp_temp_buffer));
  
  libsmtp_temp_gstring = g_string_new (NULL);
  
  /* We enter the connect stage now */
  libsmtp_session->Stage = LIBSMTP_CONNECT_STAGE;

  /* We need a socket anyway :) */
  libsmtp_socket = socket (PF_INET, SOCK_STREAM, 0);
  
  /* Socket ok? */
  if (libsmtp_socket < 0) {
      libsmtp_session->ErrorCode = LIBSMTP_SOCKETNOCREATE;
	  ret = libsmtp_session->ErrorCode;
	  goto FATAL;
  }
  /* Now we need to get the IP from the hostname... */
  for(flags = 0 ; flags < 2 ; flags ++) {
     libsmtp_mailhost= gethostbyname(libsmtp_server);
     if(libsmtp_mailhost) break;
     printf("%s:Error. gethostbyname(). %d\n", __func__, flags);
     sleep(1);
  }
  if(libsmtp_mailhost == NULL) {
  //if ((libsmtp_mailhost=gethostbyname((const char *)libsmtp_server))==NULL) {
      libsmtp_session->ErrorCode = LIBSMTP_HOSTNOTFOUND;
	  ret = libsmtp_session->ErrorCode;
          printf("%s:Error. gethostbyname('%s'), %d,%s\n", __func__, libsmtp_server, h_errno, hstrerror(h_errno));
	  goto FATAL;
  }
  
  libsmtp_session->server = libsmtp_server;
  /* This struct is needed for the connect call */
  libsmtp_sock.sin_family = AF_INET;
  libsmtp_sock.sin_addr = *(struct in_addr *)libsmtp_mailhost->h_addr;
  if (!libsmtp_port)
      libsmtp_sock.sin_port = htons (25);
  else
      libsmtp_sock.sin_port = htons (libsmtp_port);

  flags = fcntl(libsmtp_socket, F_GETFL, 0);
  /* Now we make the connection to the smart host on the specified port */
  fcntl(libsmtp_socket, F_SETFL, flags | O_NONBLOCK);

  if(connect (libsmtp_socket, (struct sockaddr *) &libsmtp_sock, sizeof (libsmtp_sock)) == -1) {
	  if (errno == EINPROGRESS){// it is in the connect process
          tv.tv_sec = wait_timeout;
          tv.tv_usec = 0;
          FD_ZERO(&readfds);
          FD_SET(libsmtp_socket, &readfds);
          if(select(libsmtp_socket+1,&readfds,NULL,NULL,&tv)<=0){
			  printf("server no response!!!\n");
			  libsmtp_session->ErrorCode = LIBSMTP_CONNECTERR;
			  ret = libsmtp_session->ErrorCode;
			  goto FATAL;
		  }
          if ((connect (libsmtp_socket, (struct sockaddr *) &libsmtp_sock, sizeof(libsmtp_sock)) == -1) &&
              errno != EISCONN) {
			  libsmtp_session->ErrorCode = LIBSMTP_CONNECTERR;
			  ret = libsmtp_session->ErrorCode;
			  goto FATAL;
          }
      } else {
		  libsmtp_session->ErrorCode = LIBSMTP_CONNECTERR;
		  ret = libsmtp_session->ErrorCode;
		  goto FATAL;
	  }
  }

  fcntl(libsmtp_socket, F_SETFL, flags);

  /* Ok, lets set the session socket to the right handler */
  libsmtp_session->socket = libsmtp_socket;
  
  /* We enter the greet stage now */
  libsmtp_session->Stage = LIBSMTP_GREET_STAGE;

/* set recv/send timeout */
  memset(&tv, 0, sizeof(struct timeval));
  tv.tv_sec = 15;
//  ts = sizeof(struct timeval);
//  getsockopt(libsmtp_socket, SOL_SOCKET, SO_RCVTIMEO, &tv, &ts);
//  printf("SO_RCVTIMEO %d.%d\n", tv.tv_sec, tv.tv_usec);
  setsockopt(libsmtp_socket, SOL_SOCKET, SO_RCVTIMEO, &tv, sizeof(struct timeval));
  setsockopt(libsmtp_socket, SOL_SOCKET, SO_SNDTIMEO, &tv, sizeof(struct timeval));

  /* Now we should read the mail servers greeting */
  if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0)){
	  ret = LIBSMTP_ERRORREADFATAL;
	  goto FATAL;
  }
  
  if (libsmtp_session->LastResponseCode != 220) {
      libsmtp_session->ErrorCode = LIBSMTP_NOTWELCOME;
	  ret = libsmtp_session->ErrorCode;
	  goto FATAL;
  }
  
  /* Now we need to know our hostname */
  sender = libsmtp_session->From->str;
  helloStr = strchr(sender,'@');
  if (helloStr){
	  strncpy(libsmtp_temp_buffer, sender, helloStr-sender);
	  libsmtp_temp_buffer[helloStr-sender] = '\0';
  } else
	  strcpy(libsmtp_temp_buffer, sender);
  
  /* We enter the hello stage now */
  libsmtp_session->Stage = LIBSMTP_HELLO_STAGE;

  /* Ok, lets greet him back */
  if (libsmtp_session->auth_type == NO_AUTH) {
	  g_string_sprintf (libsmtp_temp_gstring, "HELO %s\r\n", libsmtp_temp_buffer);
	  if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		  goto FATAL;

	  if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
		  goto FATAL;
	  /* Lets see if he likes us now. */

	  if (libsmtp_session->LastResponseCode > 299) {
		  /* We are not welcome here it seems - I don't know if this is fatal
		     to SMTP transactions - FIXME */
		  ret = libsmtp_session->ErrorCode;
		  goto FATAL;
	  }
	  g_string_free(libsmtp_temp_gstring, 1);
	  return LIBSMTP_NOERR;
  }

  g_string_sprintf (libsmtp_temp_gstring, "EHLO %s\r\n", libsmtp_temp_buffer);

  if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
	  goto FATAL;
  
  /* After this he will send us his capabilities. He may not be able to
     recognize EHLO though, so we have to send HELO instead. */
  
  if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
	  goto FATAL;
  
	while (1){
		tv.tv_sec = 0;
		tv.tv_usec = 300*1000;
		FD_ZERO(&readfds);
		FD_SET(libsmtp_socket, &readfds);
		ret1 = select(libsmtp_socket+1, &readfds, NULL, NULL, &tv);
		if(ret1 <= 0) 
			break;
		if(libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 1))
	  goto FATAL;
	}
  printf("++++\n%s\n", libsmtp_temp_gstring->str);
  if (libsmtp_session->LastResponseCode < 300) {
      /* Ok, he loves us. Lets parse the response for the capabilities. */
      
      if (strstr (libsmtp_temp_gstring->str, "8BITMIME"))
        libsmtp_session->serverflags |= LIBSMTP_HAS_8BIT;
      
      if (strstr (libsmtp_temp_gstring->str, "PIPELINING"))
        libsmtp_session->serverflags |= LIBSMTP_HAS_PIPELINING;
      
      if (strstr (libsmtp_temp_gstring->str, "DSN"))
        libsmtp_session->serverflags |= LIBSMTP_HAS_DSN;
      
      if (strstr (libsmtp_temp_gstring->str, "STARTTLS"))
        libsmtp_session->serverflags |= LIBSMTP_HAS_TLS;
      
      if (strstr (libsmtp_temp_gstring->str, "SIZE"))
        libsmtp_session->serverflags |= LIBSMTP_HAS_SIZE;
      
      if (strstr (libsmtp_temp_gstring->str, "ETRN"))
        libsmtp_session->serverflags |= LIBSMTP_HAS_ETRN;
      
      if (strstr (libsmtp_temp_gstring->str, "ENHANCEDSTATUSCODES"))
        libsmtp_session->serverflags |= LIBSMTP_HAS_ENHANCEDSTATUSCODES;
      /* Ok, now we're ready for business */

	  if(libsmtp_session->serverflags&LIBSMTP_HAS_TLS){
	    g_string_sprintf(libsmtp_temp_gstring,"STARTTLS\r\n",libsmtp_temp_buffer);
		libsmtp_int_send(libsmtp_temp_gstring,libsmtp_session);
		libsmtp_int_read(libsmtp_temp_gstring,libsmtp_session,0);
	    if(libsmtp_session->LastResponseCode!=220)
		{
		   libsmtp_session->startTLS=0;
		   goto FATAL;
		}
#ifdef OPENSSL
  printf("%s OPENSSL\n", __func__);
		SSL_library_init();
		libsmtp_session->method = SSLv3_client_method();
		libsmtp_session->ctx = SSL_CTX_new(libsmtp_session->method);
		if (SSL_CTX_load_verify_locations(libsmtp_session->ctx, CAfile, 0) != 1)
		   goto FATAL;
		libsmtp_session->ssl = SSL_new(libsmtp_session->ctx);
		SSL_set_fd(libsmtp_session->ssl, libsmtp_session->socket);
		if (SSL_connect(libsmtp_session->ssl) != 1)
		  goto FATAL;
  printf("SSL_connect ok\n");

		libsmtp_session->startTLS=1;
		g_string_sprintf (libsmtp_temp_gstring, "EHLO %s\r\n", libsmtp_temp_buffer);
        	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		   goto FATAL;
		if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
		   goto FATAL;
#endif
#ifdef MATRIXSSL
  printf("%s MATRIXSSL\n", __func__);
		if(matrixSslOpen()<0)
		  goto FATAL;
		if(matrixSslReadKeys(&libsmtp_session->keys,NULL,NULL,NULL,CAfile)<0)
		  goto FATAL;
	    if(sslConnect(&libsmtp_session->conn,libsmtp_session->socket,libsmtp_session->keys,libsmtp_session->sessionId,\
								libsmtp_session->cipherSuite,certChecker)<0)
		  goto FATAL;

		libsmtp_session->startTLS=1;
		g_string_sprintf (libsmtp_temp_gstring, "EHLO %s\r\n", libsmtp_temp_buffer);
        	if (libsmtp_int_send (libsmtp_temp_gstring, libsmtp_session))
		   goto FATAL;
		if (libsmtp_int_read (libsmtp_temp_gstring, libsmtp_session, 0))
		   goto FATAL;

#endif
	  }
	printf("CONN OK\n");
        if(libsmtp_session->auth_type==AUTO_DET){
              if((srh_auth = strstr (libsmtp_temp_gstring->str,"AUTH"))){
		  libsmtp_session->serverflags |=LIBSMTP_HAS_AUTH;
			  printf("libsmtp_session->auth_type==AUTO_DET\n");
	  		if (strstr(srh_auth, "LOGIN")) {
	  			libsmtp_session->auth_type=LOGIN;
	  		} else if (strstr(srh_auth, "PLAIN")) {
	  			libsmtp_session->auth_type=PLAIN;
	  		} else if (strstr(srh_auth, "DIGEST-MD5")) {
	  			libsmtp_session->auth_type=DIGEST_MD5;
	  		} else if (strstr(srh_auth, "CRAM-MD5")) {
	  			libsmtp_session->auth_type=CRAM_MD5;
	  		} 
	  		
              }
        }
        printf("libsmtp_session->auth_type %d\n", libsmtp_session->auth_type);
        ret = _lib_smtp_authenticate(libsmtp_session->auth_type, libsmtp_session);
        g_string_free(libsmtp_temp_gstring, 1);
        return ret;
  }
FATAL:
  printf("SSL_connect fail\n");
  g_string_free(libsmtp_temp_gstring, 1);
#ifdef OPENSSL
	if(libsmtp_session->ctx)
		free(libsmtp_session->ctx);
	if(libsmtp_session->ssl)
		free(libsmtp_session->ssl);
#endif /* OPENSSL */
  return ret;

}

int libsmtp_close (struct libsmtp_session_struct *libsmtp_session)
{
  /* I just hope that there are no socket with fd 0 out there :) */
  if (libsmtp_session->socket)
  {
    close (libsmtp_session->socket);
    libsmtp_session->socket=0;
  }

  return LIBSMTP_NOERR;
}
