
#include <glib.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

/**
 * the base64 character table
 */
char cb64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"; 

/**
 * encode 3 8-bit binary bytes as 4 '6-bit' characters
**/

static void
mimeB64EncodeBlock(const char in[3], char out[4], int len)
{
	out[0] = cb64[in[0] >> 2];
	out[1] = cb64[((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4)];
	out[2] = (char) (len > 1 ? cb64[((in[1] & 0x0f) << 2) | 
		 ((in[2] & 0xc0) >> 6)] : '=');
	out[3] = (char) (len > 2 ? cb64[in[2] & 0x3f] : '=');
}

/**
 * Encode a string into base64.
 */
GString *
mimeB64EncodeString(const char *inbuf, size_t len)
{
	GString *retbuf = g_string_new(NULL);
	char encblock[5] = {0};

	while (len) {
		if (len > 3) {
			mimeB64EncodeBlock(inbuf, encblock, 3);
			inbuf += 3;
			len -= 3;
		}
		else {
			mimeB64EncodeBlock(inbuf, encblock, len);
			len -= len;
		}
		g_string_append(retbuf, (char *)encblock);
	}
	return retbuf;
}

#if 0
/**
 * Calculates the keyed md5sum. (rfc2104)
 *
 * @param text   The text that should be checksummed.
 * @param key    The key that should be used.
 * @param digest The checksum that is calculated out of key 
 *               and text will be stored at digest. digest
 *               needs to be at least 16 Bytes big.
 */
void Algorithm::hmac_md5 (const string &str, const string &key, unsigned char * digest)
{
#if 0
	unsigned int md_len;
	digest = HMAC
	( 
		EVP_md5 (), 
		(unsigned char*)key.c_str (), key.length (), 
		(unsigned char*)str.c_str (), str.length (), 
		digest, &md_len
	);
#endif
}

/**
 * Calculates the keyed sha1sum. (rfc2104)
 *
 * @param text   The text that should be checksummed.
 * @param key    The key that should be used.
 * @param digest The checksum that is calculated out of key 
 *               and text will be stored at digest. digest
 *               needs to be at least 20 Bytes big.
 */
void Algorithm::hmac_sha1 (const string &str, const string &key, unsigned char * digest)
{
#if 0
	unsigned int md_len;
	digest = HMAC
	( 
		EVP_sha1 (), 
		(unsigned char*)key.c_str (), key.length (), 
		(unsigned char*)str.c_str (), str.length (), 
		digest, &md_len
	);
#endif
}

/**
 * Calculates the keyed sha1sum and returns the digest as a 
 * string. (rfc2104)
 * Just for your convenience.
 *
 * @param str    The text that should be checksummed.
 * @param key    The key that should be used.
 * @returns      A string representation of the checksum 
 *               that was calculated using str and key.
 */
string Algorithm::hmac_sha1_str (const string &str, const string &key)
{
	unsigned char digest[20];
	Algorithm::hmac_sha1 (str, key, (unsigned char*)digest);

	char str_digest[41];
	unsigned int i;
	for (i = 0; i < 20; i++)
	{
		sprintf (str_digest+(i*2),"%02x", digest[i]);
	}
	str_digest[40] = '\0';

	return (str_digest);
}

/**
 * Calculates the keyed md5sum and returns the digest as a 
 * string. (rfc2104)
 * Just for your convenience.
 *
 * @param str    The text that should be checksummed.
 * @param key    The key that should be used.
 * @returns      A string representation of the checksum 
 *               that was calculated using str and key.
 */
string Algorithm::hmac_md5_str (const string &str, const string &key)
{
	unsigned char digest[16];
	Algorithm::hmac_md5 (str, key, (unsigned char *)digest);

	char str_digest[33];
	unsigned int i;
	for (i = 0; i < 16; i++)
	{
		sprintf (str_digest+(i*2),"%02x", digest[i]);
	}
	str_digest[32] = '\0';

	return (str_digest);
}
#endif
