#!/bin/sh
# Version : v1.0.01
# Firewall Share Library
# Default Firewall shell script
# Description :
# 		This script will setup default firewall rule on INPUT chain
# Input :
# 		/etc/DefaultRules.conf

. /etc/DefaultRules.conf
IPTABLES=/sbin/iptables

# Building chains first
# RATE_LIMIT
$IPTABLES -L RATE_LIMIT -n > /dev/null 2>&1
if [ $? -eq 1 ]; then
	$IPTABLES -N RATE_LIMIT
fi

#First clean up in case we have stale policies like default DROP
$IPTABLES -P INPUT DROP
$IPTABLES -F INPUT
$IPTABLES -F RATE_LIMIT
$IPTABLES -P OUTPUT ACCEPT
$IPTABLES -P FORWARD ACCEPT

#RATE_LIMIT
$IPTABLES -A RATE_LIMIT -p tcp -m limit --limit 35/sec \
--limit-burst 35 -j ACCEPT

# ICMP
$IPTABLES -A INPUT -p icmp -m limit --limit 35/sec --limit-burst 35 -j ACCEPT
# accept UPNP SSDP Discovery Service 
$IPTABLES -A INPUT -d 239.255.255.250/8 -j ACCEPT
# drop multicast
$IPTABLES -A INPUT -s 224.0.0.0/4 -j DROP

# drop port scan ...
# NMAP FIN/URG/PSH
$IPTABLES -A INPUT -p tcp --tcp-flags ALL FIN,URG,PSH -j DROP
# Xmas Tree
$IPTABLES -A INPUT -p tcp --tcp-flags ALL ALL -j DROP
# Another Xmas Tree
$IPTABLES -A INPUT -p tcp --tcp-flags ALL SYN,RST,ACK,FIN,URG -j DROP
# Null Scan(possibly)
$IPTABLES -A INPUT -p tcp --tcp-flags ALL NONE -j DROP
# SYN/RST
$IPTABLES -A INPUT -p tcp --tcp-flags SYN,RST SYN,RST -j DROP
# SYN/FIN -- Scan(possibly)
$IPTABLES -A INPUT -p tcp --tcp-flags SYN,FIN SYN,FIN -j DROP


$IPTABLES -A INPUT -i lo -j ACCEPT  
$IPTABLES -A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT

# Web server is running on port 80,443,6001,6002,7070
PORTS=`echo $SERVER_TCP_PORTS|sed "s/,/ /g"`
for port in $PORTS ;
do
	$IPTABLES -A INPUT -p tcp --dport $port -j RATE_LIMIT
done
# UPNP (SSDP protocol)
# UPNP (SSDP event notification protocol)
$IPTABLES -A INPUT -p udp --dport 1900 -m limit --limit 35/sec --limit-burst 35 -j ACCEPT
$IPTABLES -A INPUT -p tcp --dport 49152 -j RATE_LIMIT
# FTP
$IPTABLES -A INPUT -p tcp --dport 20 -j RATE_LIMIT
$IPTABLES -A INPUT -p tcp --dport 21 -j RATE_LIMIT
# SNMP
$IPTABLES -A INPUT -p udp --dport 161 -j ACCEPT
$IPTABLES -A INPUT -p udp --dport 162 -j ACCEPT
# DHCP
$IPTABLES -A INPUT -p udp --dport 68 -j ACCEPT
# Bonjour MDNS
$IPTABLES -A INPUT -p udp --dport 5353 -j ACCEPT
# Onvif device search 
$IPTABLES -A INPUT -p udp --dport 3702 -j ACCEPT


PORTS=`echo $SERVER_UDP_PORTS|sed "s/,/ /g"`
for port in $PORTS ;
do
	$IPTABLES -A INPUT -p udp --dport $port -j ACCEPT
done

# Being specific about who we allow to use ssh from the local subnet
LOCALNET=`ifconfig eth0|grep "inet addr"|sed "s/:/ /g"|sed "s/  */ /g"|cut -d ' ' -f 4`
LOCALMASK=`ifconfig eth0|grep "inet addr"|sed "s/:/ /g"|sed "s/  */ /g"|cut -d ' ' -f 8`
$IPTABLES -A INPUT -m state --state NEW -s $LOCALNET/$LOCALMASK  -p tcp --dport 22 -j RATE_LIMIT

