#define IEEE8021X_RUNTIME_PATH          "/var/run/"
#define IEEE8021X_DEFAULT_PATH          "/etc/config/"
#define IEEE8021X_CA_FILE               "8021x_ca.pem"
#define IEEE8021X_CLIENTCERT_FILE  	"clientCert.pem"
#define IEEE8021X_CLIENTPRIV_FILE  	"clientPriv.pem"
#define IEEE8021X_NONE_FILE	  	"none"

#define IEEE8021X_INPUTARGS_BUFSIZE 	512
#define IEEE8021X_RETMSG_BUFSIZE 	80
#define IEEE8021X_FILENAME_BUFSIZE	256

#define READ_SIZE 			1024
/*
 * Return Status
 */
enum {
        IEEE8021X_ERROR = -1,
        IEEE8021X_OK = 0
};

/*
 * Operation modes of 802.1x APIs
 */
enum {
	IEEE8021X_OP_QUERY	= 0,
	IEEE8021X_OP_UPLOAD,
	IEEE8021X_OP_REMOVE
}; 

/*
 * File types of certificate file
 */
enum {
	IEEE8021X_FTYPE_CA	= 0,
	IEEE8021X_FTYPE_USERCA,
	IEEE8021X_FTYPE_USERKEY,
	IEEE8021X_FTYPE_NONE
}; 

/*
 * structure for exchanging 802.1x data
 */
typedef struct {
	char inputArgs [IEEE8021X_INPUTARGS_BUFSIZE];  	// input arguments
	int argsLen;									// length of input arguments 
	char retMsg [IEEE8021X_RETMSG_BUFSIZE];			// retrun message 
	int retLen;										// length of return message 
} t8021xApiOp;

/*
 * 802.1x API
 */
/*
 * int ieee8021x_api (int ftype, int op, t8021xApiOp *api);
 *
 * == DESCRIPTION ==
 * This function supports three operations to remove, upload and query the three certificate and key files:
 * 		clientCert.pem
 * 		clientPriv.pem
 * 		8021x_ca.pem
 *
 * ftype: IEEE8021X_FTYPE_CA | IEEE8021X_FTYPE_USERCA | IEEE8021X_FTYPE_USERKEY
 *		This argument is assigned which certificate or key file to be operated.
 * 		  
 * op: IEEE8021X_OP_QUERY | IEEE8021X_OP_UPLOAD | IEEE8021X_OP_REMOVE
 * 		IEEE8021X_OP_QUERY: query the file name of certificate or key file
 * 		IEEE8021X_OP_UPLOAD: upload certificate or key file to the IP Camera
 * 		IEEE8021X_OP_REMOVE: remove certificate or key files from the IP Camera
 *
 * *api: 
 * 		ieee8021_api() must declares an pointer *api of struct t8021xApiOp that defined in 8021x_api.h .
 * 		api->inputArgs: char* | NULL
 * 						a string of file name for uploading
 * 						If operation mode is IEEE8021X_OP_QUERY or IEEE8021X_OP_REMOVE, api->inputArgs should not be assigned.
 * 		api->argsLen: integer
 * 						The length of api->in_args.
 * 						If operation mode is IEEE8021X_OP_QUERY or IEEE8021X_OP_REMOVE, api->argsLen should not be assigned.
 * 		api->retMsg: char*
 * 						Return message 
 * 		api->retLen: integer
 * 						The Length of api->retMsg.	
 *
 * == RETURN VALUE ==
 * On success, IEEE8021X_OK(0) is returned; on error, ieee8021x_api() returns IEEE8021X_ERROR(-1).
 *
 * == EXAMPLE ==
 * If you don't know how to use ieee8021x_api(), there are some examples below.
 * 1. To query(IEEE8021X_OP_QUERY) file name of CA certificate(IEEE8021X_FTYPE_CA)
 * 	t8021xApiOp ieee8021xapi;
 *	//
 * 	// Do Something	
 *	//
 * 	if (ieee8021x_api (IEEE8021X_FTYPE_CA, IEEE8021X_OP_QUERY, &ieee8021xapi) == IEEE8021X_OK) {
 * 		PrintFunction ("%s", ieee8021xapi.retMsg);
 *		total_retLen += ieee8021xapi.retLen; 
 *		//
 * 		// Do Something	
 *		//
 * 	} else{
 * 		// Handling Exception 
 * 	}
 * 2. To upload (IEEE8021X_OP_UPLOAD) file of user certificate (IEEE8021X_FTYPE_USERCA) 
 * 	t8021xApiOp ieee8021xapi;
 * 	int total_retLen = 0; 
 *	//
 * 	// Do Something	
 *	//
 *	strncpy (ieee8021xapi.inputArgs, fData->field[0].UploadFileName, strlen(fData->field[0].UploadFileName) + 1);
 *	ieee8021xapi.argsLen = strlen (ieee8021xapi.inputArgs);
 * 	if (ieee8021x_api (IEEE8021X_FTYPE_USERCA, IEEE8021X_OP_UPLOAD, &ieee8021xapi) == IEEE8021X_OK) {
 * 		PrintFunction ("%s", ieee8021xapi.retMsg);
 *		total_retLen += ieee8021xapi.retLen; 
 *		//
 * 		// Do Something	
 *		//
 *	} else {
 * 		// Handling Exception 
 * 	}
 * 3. To Remove (IEEE8021X_OP_REMOVE) file of user private key (IEEE8021X_FTYPE_USERKEY)
 * 	t8021xApiOp ieee8021xapi;
 * 	int total_retLen = 0; 
 *	//
 * 	// Do Something	
 *	//
 * 	if (ieee8021x_api (IEEE8021X_FTYPE_USERKEY, IEEE8021X_OP_REMOVE, &ieee8021xapi) == IEEE8021X_OK) {
 * 		PrintFunction ("%s", ieee8021xapi.retMsg);
 *		total_retLen += ieee8021xapi.retLen; 
 *		//
 * 		// Do Something	
 *		//
 * 	} else {
 * 		// Handling Exception 
 * 	}
 */
int ieee8021x_api (int ftype, int op, t8021xApiOp *api);
