/* ###### Definitions of SNMPD Configurations #################################### */
/* ##### Definitions in mask in tSnmpConf ##### */
#define SNMP_VERSION_CHG	0x0001
#define SNMP_READCOMM_CHG	0x0002
#define SNMP_WRITECOMM_CHG	0x0004
#define SNMP_TRAP_CHG		0x0008
#define SNMP_TRAPADDR_CHG	0x0010
#define SNMP_TRAPCOMM_CHG	0x0020
#define SNMP_V3USER_CHG		0x0040
#define SNMP_V3PWD_CHG		0x0080

/* Definitions of the SecVer in tSnmpConf */
#define SNMPVer1	0x01
#define SNMPVer2c	0x02
#define SNMPVer3	0x04

/* Definitions of the TrapsItem in tSnmpConf */
#define TrapColdStart	0x01
#define TrapWarmStart	0x02
#define TrapAuthFailed	0x04
#define TrapAll			(TrapColdStart|TrapWarmStart|TrapAuthFailed)

typedef struct {
	unsigned int mask;	/* mask to indicate which configurations were changed */
	unsigned char SecVer; /* snmp support version */
	char ReadCommunity[64]; /* read community string */
	char WriteCommunity[64]; /* write community string */
	unsigned char TrapsState; /* Trap enable/disable */
	char TrapAddr[64]; /* send trap to which destination addr*/
	char TrapCommunity[64]; /* send trap to needs community string */
	/* extend conf for version 3 */
	char v3user[32]; /* indicate username */
	char authpassphrase[64]; /* indicate authpassphrase , our snmpd only support authNoPriv mode at current.*/
} tSnmpConf;

#define SNMPDAEMON		"/usr/sbin/snmpd"
#define SNMPDCONF_FILE 	"/var/run/snmpd.conf"
#define SNMPD_PID_FILE	"/var/run/snmpd_pid"

#define NBObjectID		0
#define ACTiObjectID		34799

extern void SNMPDaemonStop(void);
extern void SNMPDaemonStart(tSnmpConf *, int , char *);
extern void SNMPDaemonReconfiguring(tSnmpConf *, int , char *);

