/* soapC.c
   Generated by gSOAP 2.7.16 from onvif.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.16 2011-12-05 08:22:34 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header))))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
//	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_tt__IANA_IfTypes:
		return soap_in_tt__IANA_IfTypes(soap, NULL, NULL, "tt:IANA-IfTypes");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_wsu__tTimestampFault:
		return soap_in_wsu__tTimestampFault(soap, NULL, NULL, "wsu:tTimestampFault");
	case SOAP_TYPE_wsse__FaultcodeEnum:
		return soap_in_wsse__FaultcodeEnum(soap, NULL, NULL, "wsse:FaultcodeEnum");
	case SOAP_TYPE_d__FaultCodeType:
		return soap_in_d__FaultCodeType(soap, NULL, NULL, "d:FaultCodeType");
	case SOAP_TYPE_wsa__RelationshipType:
		return soap_in_wsa__RelationshipType(soap, NULL, NULL, "wsa:RelationshipType");
	case SOAP_TYPE_tt__IrCutFilterMode:
		return soap_in_tt__IrCutFilterMode(soap, NULL, NULL, "tt:IrCutFilterMode");
	case SOAP_TYPE_tt__WhiteBalanceMode:
		return soap_in_tt__WhiteBalanceMode(soap, NULL, NULL, "tt:WhiteBalanceMode");
	case SOAP_TYPE_tt__Enabled:
		return soap_in_tt__Enabled(soap, NULL, NULL, "tt:Enabled");
	case SOAP_TYPE_tt__ExposureMode:
		return soap_in_tt__ExposureMode(soap, NULL, NULL, "tt:ExposureMode");
	case SOAP_TYPE_tt__ExposurePriority:
		return soap_in_tt__ExposurePriority(soap, NULL, NULL, "tt:ExposurePriority");
	case SOAP_TYPE_tt__BacklightCompensationMode:
		return soap_in_tt__BacklightCompensationMode(soap, NULL, NULL, "tt:BacklightCompensationMode");
	case SOAP_TYPE_tt__WideDynamicMode:
		return soap_in_tt__WideDynamicMode(soap, NULL, NULL, "tt:WideDynamicMode");
	case SOAP_TYPE_tt__AutoFocusMode:
		return soap_in_tt__AutoFocusMode(soap, NULL, NULL, "tt:AutoFocusMode");
	case SOAP_TYPE_tt__UserLevel:
		return soap_in_tt__UserLevel(soap, NULL, NULL, "tt:UserLevel");
	case SOAP_TYPE_tt__SetDateTimeType:
		return soap_in_tt__SetDateTimeType(soap, NULL, NULL, "tt:SetDateTimeType");
	case SOAP_TYPE_tt__FactoryDefaultType:
		return soap_in_tt__FactoryDefaultType(soap, NULL, NULL, "tt:FactoryDefaultType");
	case SOAP_TYPE_tt__CapabilityCategory:
		return soap_in_tt__CapabilityCategory(soap, NULL, NULL, "tt:CapabilityCategory");
	case SOAP_TYPE_tt__DynamicDNSType:
		return soap_in_tt__DynamicDNSType(soap, NULL, NULL, "tt:DynamicDNSType");
	case SOAP_TYPE_tt__IPType:
		return soap_in_tt__IPType(soap, NULL, NULL, "tt:IPType");
	case SOAP_TYPE_tt__NetworkHostType:
		return soap_in_tt__NetworkHostType(soap, NULL, NULL, "tt:NetworkHostType");
	case SOAP_TYPE_tt__NetworkProtocolType:
		return soap_in_tt__NetworkProtocolType(soap, NULL, NULL, "tt:NetworkProtocolType");
	case SOAP_TYPE_tt__Duplex:
		return soap_in_tt__Duplex(soap, NULL, NULL, "tt:Duplex");
	case SOAP_TYPE_tt__DiscoveryMode:
		return soap_in_tt__DiscoveryMode(soap, NULL, NULL, "tt:DiscoveryMode");
	case SOAP_TYPE_tt__ScopeDefinition:
		return soap_in_tt__ScopeDefinition(soap, NULL, NULL, "tt:ScopeDefinition");
	case SOAP_TYPE_tt__TransportProtocol:
		return soap_in_tt__TransportProtocol(soap, NULL, NULL, "tt:TransportProtocol");
	case SOAP_TYPE_tt__StreamType:
		return soap_in_tt__StreamType(soap, NULL, NULL, "tt:StreamType");
	case SOAP_TYPE_tt__AudioEncoding:
		return soap_in_tt__AudioEncoding(soap, NULL, NULL, "tt:AudioEncoding");
	case SOAP_TYPE_tt__H264Profile:
		return soap_in_tt__H264Profile(soap, NULL, NULL, "tt:H264Profile");
	case SOAP_TYPE_tt__Mpeg4Profile:
		return soap_in_tt__Mpeg4Profile(soap, NULL, NULL, "tt:Mpeg4Profile");
	case SOAP_TYPE_tt__VideoEncoding:
		return soap_in_tt__VideoEncoding(soap, NULL, NULL, "tt:VideoEncoding");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_wsu__TimestampType:
		return soap_in_wsu__TimestampType(soap, NULL, NULL, "wsu:TimestampType");
	case SOAP_TYPE_wsse__SecurityHeaderType:
		return soap_in_wsse__SecurityHeaderType(soap, NULL, NULL, "wsse:SecurityHeaderType");
	case SOAP_TYPE_wsse__UsernameTokenType:
		return soap_in_wsse__UsernameTokenType(soap, NULL, NULL, "wsse:UsernameTokenType");
	case SOAP_TYPE_wsse__PasswordString:
		return soap_in_wsse__PasswordString(soap, NULL, NULL, "wsse:PasswordString");
	case SOAP_TYPE_d__AppSequenceType:
		return soap_in_d__AppSequenceType(soap, NULL, NULL, "d:AppSequenceType");
	case SOAP_TYPE_d__ScopesType:
		return soap_in_d__ScopesType(soap, NULL, NULL, "d:ScopesType");
	case SOAP_TYPE_d__ResolveType:
		return soap_in_d__ResolveType(soap, NULL, NULL, "d:ResolveType");
	case SOAP_TYPE_d__ProbeMatchType:
		return soap_in_d__ProbeMatchType(soap, NULL, NULL, "d:ProbeMatchType");
	case SOAP_TYPE_d__ProbeMatchesType:
		return soap_in_d__ProbeMatchesType(soap, NULL, NULL, "d:ProbeMatchesType");
	case SOAP_TYPE_d__ProbeType:
		return soap_in_d__ProbeType(soap, NULL, NULL, "d:ProbeType");
	case SOAP_TYPE_d__ByeType:
		return soap_in_d__ByeType(soap, NULL, NULL, "d:ByeType");
	case SOAP_TYPE_d__HelloType:
		return soap_in_d__HelloType(soap, NULL, NULL, "d:HelloType");
	case SOAP_TYPE_trt__StreamingCapabilities:
		return soap_in_trt__StreamingCapabilities(soap, NULL, NULL, "trt:StreamingCapabilities");
	case SOAP_TYPE_trt__ProfileCapabilities:
		return soap_in_trt__ProfileCapabilities(soap, NULL, NULL, "trt:ProfileCapabilities");
	case SOAP_TYPE_trt__Capabilities:
		return soap_in_trt__Capabilities(soap, NULL, NULL, "trt:Capabilities");
	case SOAP_TYPE_wsa__AttributedURIType:
		return soap_in_wsa__AttributedURIType(soap, NULL, NULL, "wsa:AttributedURIType");
	case SOAP_TYPE_wsa__RelatesToType:
		return soap_in_wsa__RelatesToType(soap, NULL, NULL, "wsa:RelatesToType");
	case SOAP_TYPE_wsa__MetadataType:
		return soap_in_wsa__MetadataType(soap, NULL, NULL, "wsa:MetadataType");
	case SOAP_TYPE_wsa__ReferenceParametersType:
		return soap_in_wsa__ReferenceParametersType(soap, NULL, NULL, "wsa:ReferenceParametersType");
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return soap_in_wsa__EndpointReferenceType(soap, NULL, NULL, "wsa:EndpointReferenceType");
	case SOAP_TYPE_tt__Rectangle:
		return soap_in_tt__Rectangle(soap, NULL, NULL, "tt:Rectangle");
	case SOAP_TYPE_tt__WhiteBalance:
		return soap_in_tt__WhiteBalance(soap, NULL, NULL, "tt:WhiteBalance");
	case SOAP_TYPE_tt__WhiteBalanceOptions:
		return soap_in_tt__WhiteBalanceOptions(soap, NULL, NULL, "tt:WhiteBalanceOptions");
	case SOAP_TYPE_tt__ExposureOptions:
		return soap_in_tt__ExposureOptions(soap, NULL, NULL, "tt:ExposureOptions");
	case SOAP_TYPE_tt__FocusOptions:
		return soap_in_tt__FocusOptions(soap, NULL, NULL, "tt:FocusOptions");
	case SOAP_TYPE_tt__BacklightCompensationOptions:
		return soap_in_tt__BacklightCompensationOptions(soap, NULL, NULL, "tt:BacklightCompensationOptions");
	case SOAP_TYPE_tt__WideDynamicRangeOptions:
		return soap_in_tt__WideDynamicRangeOptions(soap, NULL, NULL, "tt:WideDynamicRangeOptions");
	case SOAP_TYPE_tt__ImagingOptions:
		return soap_in_tt__ImagingOptions(soap, NULL, NULL, "tt:ImagingOptions");
	case SOAP_TYPE_tt__BacklightCompensation:
		return soap_in_tt__BacklightCompensation(soap, NULL, NULL, "tt:BacklightCompensation");
	case SOAP_TYPE_tt__WideDynamicRange:
		return soap_in_tt__WideDynamicRange(soap, NULL, NULL, "tt:WideDynamicRange");
	case SOAP_TYPE_tt__Exposure:
		return soap_in_tt__Exposure(soap, NULL, NULL, "tt:Exposure");
	case SOAP_TYPE_tt__ImagingSettings:
		return soap_in_tt__ImagingSettings(soap, NULL, NULL, "tt:ImagingSettings");
	case SOAP_TYPE_tt__FocusConfiguration:
		return soap_in_tt__FocusConfiguration(soap, NULL, NULL, "tt:FocusConfiguration");
	case SOAP_TYPE_tt__User:
		return soap_in_tt__User(soap, NULL, NULL, "tt:User");
	case SOAP_TYPE_tt__TimeZone:
		return soap_in_tt__TimeZone(soap, NULL, NULL, "tt:TimeZone");
	case SOAP_TYPE_tt__Time:
		return soap_in_tt__Time(soap, NULL, NULL, "tt:Time");
	case SOAP_TYPE_tt__Date:
		return soap_in_tt__Date(soap, NULL, NULL, "tt:Date");
	case SOAP_TYPE_tt__DateTime:
		return soap_in_tt__DateTime(soap, NULL, NULL, "tt:DateTime");
	case SOAP_TYPE_tt__SystemDateTime:
		return soap_in_tt__SystemDateTime(soap, NULL, NULL, "tt:SystemDateTime");
	case SOAP_TYPE_tt__AnalyticsDeviceCapabilities:
		return soap_in_tt__AnalyticsDeviceCapabilities(soap, NULL, NULL, "tt:AnalyticsDeviceCapabilities");
	case SOAP_TYPE_tt__ReceiverCapabilities:
		return soap_in_tt__ReceiverCapabilities(soap, NULL, NULL, "tt:ReceiverCapabilities");
	case SOAP_TYPE_tt__ReplayCapabilities:
		return soap_in_tt__ReplayCapabilities(soap, NULL, NULL, "tt:ReplayCapabilities");
	case SOAP_TYPE_tt__SearchCapabilities:
		return soap_in_tt__SearchCapabilities(soap, NULL, NULL, "tt:SearchCapabilities");
	case SOAP_TYPE_tt__RecordingCapabilities:
		return soap_in_tt__RecordingCapabilities(soap, NULL, NULL, "tt:RecordingCapabilities");
	case SOAP_TYPE_tt__DisplayCapabilities:
		return soap_in_tt__DisplayCapabilities(soap, NULL, NULL, "tt:DisplayCapabilities");
	case SOAP_TYPE_tt__DeviceIOCapabilities:
		return soap_in_tt__DeviceIOCapabilities(soap, NULL, NULL, "tt:DeviceIOCapabilities");
	case SOAP_TYPE_tt__PTZCapabilities:
		return soap_in_tt__PTZCapabilities(soap, NULL, NULL, "tt:PTZCapabilities");
	case SOAP_TYPE_tt__ImagingCapabilities:
		return soap_in_tt__ImagingCapabilities(soap, NULL, NULL, "tt:ImagingCapabilities");
	case SOAP_TYPE_tt__OnvifVersion:
		return soap_in_tt__OnvifVersion(soap, NULL, NULL, "tt:OnvifVersion");
	case SOAP_TYPE_tt__SystemCapabilities:
		return soap_in_tt__SystemCapabilities(soap, NULL, NULL, "tt:SystemCapabilities");
	case SOAP_TYPE_tt__SecurityCapabilities:
		return soap_in_tt__SecurityCapabilities(soap, NULL, NULL, "tt:SecurityCapabilities");
	case SOAP_TYPE_tt__NetworkCapabilities:
		return soap_in_tt__NetworkCapabilities(soap, NULL, NULL, "tt:NetworkCapabilities");
	case SOAP_TYPE_tt__ProfileCapabilities:
		return soap_in_tt__ProfileCapabilities(soap, NULL, NULL, "tt:ProfileCapabilities");
	case SOAP_TYPE_tt__RealTimeStreamingCapabilities:
		return soap_in_tt__RealTimeStreamingCapabilities(soap, NULL, NULL, "tt:RealTimeStreamingCapabilities");
	case SOAP_TYPE_tt__MediaCapabilities:
		return soap_in_tt__MediaCapabilities(soap, NULL, NULL, "tt:MediaCapabilities");
	case SOAP_TYPE_tt__IOCapabilities:
		return soap_in_tt__IOCapabilities(soap, NULL, NULL, "tt:IOCapabilities");
	case SOAP_TYPE_tt__EventCapabilities:
		return soap_in_tt__EventCapabilities(soap, NULL, NULL, "tt:EventCapabilities");
	case SOAP_TYPE_tt__DeviceCapabilities:
		return soap_in_tt__DeviceCapabilities(soap, NULL, NULL, "tt:DeviceCapabilities");
	case SOAP_TYPE_tt__AnalyticsCapabilities:
		return soap_in_tt__AnalyticsCapabilities(soap, NULL, NULL, "tt:AnalyticsCapabilities");
	case SOAP_TYPE_tt__CapabilitiesExtension:
		return soap_in_tt__CapabilitiesExtension(soap, NULL, NULL, "tt:CapabilitiesExtension");
	case SOAP_TYPE_tt__Capabilities:
		return soap_in_tt__Capabilities(soap, NULL, NULL, "tt:Capabilities");
	case SOAP_TYPE_tt__NetworkZeroConfiguration:
		return soap_in_tt__NetworkZeroConfiguration(soap, NULL, NULL, "tt:NetworkZeroConfiguration");
	case SOAP_TYPE_tt__NetworkGateway:
		return soap_in_tt__NetworkGateway(soap, NULL, NULL, "tt:NetworkGateway");
	case SOAP_TYPE_tt__IPv4NetworkInterfaceSetConfiguration:
		return soap_in_tt__IPv4NetworkInterfaceSetConfiguration(soap, NULL, NULL, "tt:IPv4NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_tt__NetworkInterfaceSetConfigurationExtension:
		return soap_in_tt__NetworkInterfaceSetConfigurationExtension(soap, NULL, NULL, "tt:NetworkInterfaceSetConfigurationExtension");
	case SOAP_TYPE_tt__NetworkInterfaceSetConfiguration:
		return soap_in_tt__NetworkInterfaceSetConfiguration(soap, NULL, NULL, "tt:NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_tt__DynamicDNSInformation:
		return soap_in_tt__DynamicDNSInformation(soap, NULL, NULL, "tt:DynamicDNSInformation");
	case SOAP_TYPE_tt__NTPInformation:
		return soap_in_tt__NTPInformation(soap, NULL, NULL, "tt:NTPInformation");
	case SOAP_TYPE_tt__DNSInformation:
		return soap_in_tt__DNSInformation(soap, NULL, NULL, "tt:DNSInformation");
	case SOAP_TYPE_tt__HostnameInformation:
		return soap_in_tt__HostnameInformation(soap, NULL, NULL, "tt:HostnameInformation");
	case SOAP_TYPE_tt__PrefixedIPv4Address:
		return soap_in_tt__PrefixedIPv4Address(soap, NULL, NULL, "tt:PrefixedIPv4Address");
	case SOAP_TYPE_tt__IPAddress:
		return soap_in_tt__IPAddress(soap, NULL, NULL, "tt:IPAddress");
	case SOAP_TYPE_tt__NetworkHost:
		return soap_in_tt__NetworkHost(soap, NULL, NULL, "tt:NetworkHost");
	case SOAP_TYPE_tt__NetworkProtocol:
		return soap_in_tt__NetworkProtocol(soap, NULL, NULL, "tt:NetworkProtocol");
	case SOAP_TYPE_tt__IPv4Configuration:
		return soap_in_tt__IPv4Configuration(soap, NULL, NULL, "tt:IPv4Configuration");
	case SOAP_TYPE_tt__IPv4NetworkInterface:
		return soap_in_tt__IPv4NetworkInterface(soap, NULL, NULL, "tt:IPv4NetworkInterface");
	case SOAP_TYPE_tt__NetworkInterfaceInfo:
		return soap_in_tt__NetworkInterfaceInfo(soap, NULL, NULL, "tt:NetworkInterfaceInfo");
	case SOAP_TYPE_tt__NetworkInterfaceConnectionSetting:
		return soap_in_tt__NetworkInterfaceConnectionSetting(soap, NULL, NULL, "tt:NetworkInterfaceConnectionSetting");
	case SOAP_TYPE_tt__NetworkInterfaceLink:
		return soap_in_tt__NetworkInterfaceLink(soap, NULL, NULL, "tt:NetworkInterfaceLink");
	case SOAP_TYPE_tt__NetworkInterfaceExtension2:
		return soap_in_tt__NetworkInterfaceExtension2(soap, NULL, NULL, "tt:NetworkInterfaceExtension2");
	case SOAP_TYPE_tt__Dot3Configuration:
		return soap_in_tt__Dot3Configuration(soap, NULL, NULL, "tt:Dot3Configuration");
	case SOAP_TYPE_tt__NetworkInterfaceExtension:
		return soap_in_tt__NetworkInterfaceExtension(soap, NULL, NULL, "tt:NetworkInterfaceExtension");
	case SOAP_TYPE_tt__NetworkInterface:
		return soap_in_tt__NetworkInterface(soap, NULL, NULL, "tt:NetworkInterface");
	case SOAP_TYPE_tt__Scope:
		return soap_in_tt__Scope(soap, NULL, NULL, "tt:Scope");
	case SOAP_TYPE_tt__MediaUri:
		return soap_in_tt__MediaUri(soap, NULL, NULL, "tt:MediaUri");
	case SOAP_TYPE_tt__Transport:
		return soap_in_tt__Transport(soap, NULL, NULL, "tt:Transport");
	case SOAP_TYPE_tt__StreamSetup:
		return soap_in_tt__StreamSetup(soap, NULL, NULL, "tt:StreamSetup");
	case SOAP_TYPE_tt__MulticastConfiguration:
		return soap_in_tt__MulticastConfiguration(soap, NULL, NULL, "tt:MulticastConfiguration");
	case SOAP_TYPE_tt__AudioEncoderConfigurationOption:
		return soap_in_tt__AudioEncoderConfigurationOption(soap, NULL, NULL, "tt:AudioEncoderConfigurationOption");
	case SOAP_TYPE_tt__AudioEncoderConfigurationOptions:
		return soap_in_tt__AudioEncoderConfigurationOptions(soap, NULL, NULL, "tt:AudioEncoderConfigurationOptions");
	case SOAP_TYPE_tt__AudioEncoderConfiguration:
		return soap_in_tt__AudioEncoderConfiguration(soap, NULL, NULL, "tt:AudioEncoderConfiguration");
	case SOAP_TYPE_tt__AudioSourceConfigurationOptions:
		return soap_in_tt__AudioSourceConfigurationOptions(soap, NULL, NULL, "tt:AudioSourceConfigurationOptions");
	case SOAP_TYPE_tt__AudioSourceConfiguration:
		return soap_in_tt__AudioSourceConfiguration(soap, NULL, NULL, "tt:AudioSourceConfiguration");
	case SOAP_TYPE_tt__H264Options:
		return soap_in_tt__H264Options(soap, NULL, NULL, "tt:H264Options");
	case SOAP_TYPE_tt__Mpeg4Options:
		return soap_in_tt__Mpeg4Options(soap, NULL, NULL, "tt:Mpeg4Options");
	case SOAP_TYPE_tt__JpegOptions:
		return soap_in_tt__JpegOptions(soap, NULL, NULL, "tt:JpegOptions");
	case SOAP_TYPE_tt__VideoEncoderConfigurationOptions:
		return soap_in_tt__VideoEncoderConfigurationOptions(soap, NULL, NULL, "tt:VideoEncoderConfigurationOptions");
	case SOAP_TYPE_tt__H264Configuration:
		return soap_in_tt__H264Configuration(soap, NULL, NULL, "tt:H264Configuration");
	case SOAP_TYPE_tt__Mpeg4Configuration:
		return soap_in_tt__Mpeg4Configuration(soap, NULL, NULL, "tt:Mpeg4Configuration");
	case SOAP_TYPE_tt__VideoRateControl:
		return soap_in_tt__VideoRateControl(soap, NULL, NULL, "tt:VideoRateControl");
	case SOAP_TYPE_tt__VideoResolution:
		return soap_in_tt__VideoResolution(soap, NULL, NULL, "tt:VideoResolution");
	case SOAP_TYPE_tt__VideoEncoderConfiguration:
		return soap_in_tt__VideoEncoderConfiguration(soap, NULL, NULL, "tt:VideoEncoderConfiguration");
	case SOAP_TYPE_tt__VideoSourceConfigurationOptions:
		return soap_in_tt__VideoSourceConfigurationOptions(soap, NULL, NULL, "tt:VideoSourceConfigurationOptions");
	case SOAP_TYPE_tt__VideoSourceConfiguration:
		return soap_in_tt__VideoSourceConfiguration(soap, NULL, NULL, "tt:VideoSourceConfiguration");
	case SOAP_TYPE_tt__ConfigurationEntity:
		return soap_in_tt__ConfigurationEntity(soap, NULL, NULL, "tt:ConfigurationEntity");
	case SOAP_TYPE_tt__Profile:
		return soap_in_tt__Profile(soap, NULL, NULL, "tt:Profile");
	case SOAP_TYPE_tt__AudioSource:
		return soap_in_tt__AudioSource(soap, NULL, NULL, "tt:AudioSource");
	case SOAP_TYPE_tt__VideoSource:
		return soap_in_tt__VideoSource(soap, NULL, NULL, "tt:VideoSource");
	case SOAP_TYPE_tt__IntList:
		return soap_in_tt__IntList(soap, NULL, NULL, "tt:IntList");
	case SOAP_TYPE_tt__FloatRange:
		return soap_in_tt__FloatRange(soap, NULL, NULL, "tt:FloatRange");
	case SOAP_TYPE_tt__IntRange:
		return soap_in_tt__IntRange(soap, NULL, NULL, "tt:IntRange");
	case SOAP_TYPE_tt__IntRectangleRange:
		return soap_in_tt__IntRectangleRange(soap, NULL, NULL, "tt:IntRectangleRange");
	case SOAP_TYPE_tt__IntRectangle:
		return soap_in_tt__IntRectangle(soap, NULL, NULL, "tt:IntRectangle");
	case SOAP_TYPE_tt__DeviceEntity:
		return soap_in_tt__DeviceEntity(soap, NULL, NULL, "tt:DeviceEntity");
	case SOAP_TYPE_wsadis__AttributedURI:
		return soap_in_wsadis__AttributedURI(soap, NULL, NULL, "wsadis:AttributedURI");
	case SOAP_TYPE_wsadis__AttributedQName:
		return soap_in_wsadis__AttributedQName(soap, NULL, NULL, "wsadis:AttributedQName");
	case SOAP_TYPE_wsadis__Relationship:
		return soap_in_wsadis__Relationship(soap, NULL, NULL, "wsadis:Relationship");
	case SOAP_TYPE_wsadis__ServiceNameType:
		return soap_in_wsadis__ServiceNameType(soap, NULL, NULL, "wsadis:ServiceNameType");
	case SOAP_TYPE_wsadis__ReferenceParametersType:
		return soap_in_wsadis__ReferenceParametersType(soap, NULL, NULL, "wsadis:ReferenceParametersType");
	case SOAP_TYPE_wsadis__ReferencePropertiesType:
		return soap_in_wsadis__ReferencePropertiesType(soap, NULL, NULL, "wsadis:ReferencePropertiesType");
	case SOAP_TYPE_wsadis__EndpointReferenceType:
		return soap_in_wsadis__EndpointReferenceType(soap, NULL, NULL, "wsadis:EndpointReferenceType");
	case SOAP_TYPE_PointerTo_wsse__Security:
		return soap_in_PointerTo_wsse__Security(soap, NULL, NULL, "wsse:Security");
	case SOAP_TYPE_PointerTo_d__AppSequence:
		return soap_in_PointerTo_d__AppSequence(soap, NULL, NULL, "d:AppSequence");
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		return soap_in_PointerTo_wsa__FaultTo(soap, NULL, NULL, "wsa:FaultTo");
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		return soap_in_PointerTo_wsa__ReplyTo(soap, NULL, NULL, "wsa:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa__From:
		return soap_in_PointerTo_wsa__From(soap, NULL, NULL, "wsa:From");
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		return soap_in_PointerTo_wsa__RelatesTo(soap, NULL, NULL, "wsa:RelatesTo");
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUriResponse:
		return soap_in_PointerTo_trt__GetSnapshotUriResponse(soap, NULL, NULL, "trt:GetSnapshotUriResponse");
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUri:
		return soap_in_PointerTo_trt__GetSnapshotUri(soap, NULL, NULL, "trt:GetSnapshotUri");
	case SOAP_TYPE_PointerTo_trt__GetStreamUriResponse:
		return soap_in_PointerTo_trt__GetStreamUriResponse(soap, NULL, NULL, "trt:GetStreamUriResponse");
	case SOAP_TYPE_PointerTo_trt__GetStreamUri:
		return soap_in_PointerTo_trt__GetStreamUri(soap, NULL, NULL, "trt:GetStreamUri");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetAudioEncoderConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptions:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, NULL, NULL, "trt:GetAudioEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetAudioSourceConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptions:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, NULL, NULL, "trt:GetAudioSourceConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetVideoEncoderConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptions:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, NULL, NULL, "trt:GetVideoEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetVideoSourceConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptions:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, NULL, NULL, "trt:GetVideoSourceConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__SetAudioEncoderConfigurationResponse(soap, NULL, NULL, "trt:SetAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfiguration:
		return soap_in_PointerTo_trt__SetAudioEncoderConfiguration(soap, NULL, NULL, "trt:SetAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfigurationResponse:
		return soap_in_PointerTo_trt__SetAudioSourceConfigurationResponse(soap, NULL, NULL, "trt:SetAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfiguration:
		return soap_in_PointerTo_trt__SetAudioSourceConfiguration(soap, NULL, NULL, "trt:SetAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__SetVideoEncoderConfigurationResponse(soap, NULL, NULL, "trt:SetVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfiguration:
		return soap_in_PointerTo_trt__SetVideoEncoderConfiguration(soap, NULL, NULL, "trt:SetVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfigurationResponse:
		return soap_in_PointerTo_trt__SetVideoSourceConfigurationResponse(soap, NULL, NULL, "trt:SetVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfiguration:
		return soap_in_PointerTo_trt__SetVideoSourceConfiguration(soap, NULL, NULL, "trt:SetVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleAudioSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, NULL, NULL, "trt:GetCompatibleAudioSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleAudioEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, NULL, NULL, "trt:GetCompatibleAudioEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleVideoSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, NULL, NULL, "trt:GetCompatibleVideoSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleVideoEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, NULL, NULL, "trt:GetCompatibleVideoEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurationResponse(soap, NULL, NULL, "trt:GetAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfiguration:
		return soap_in_PointerTo_trt__GetAudioEncoderConfiguration(soap, NULL, NULL, "trt:GetAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationResponse:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurationResponse(soap, NULL, NULL, "trt:GetAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfiguration:
		return soap_in_PointerTo_trt__GetAudioSourceConfiguration(soap, NULL, NULL, "trt:GetAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurationResponse(soap, NULL, NULL, "trt:GetVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfiguration:
		return soap_in_PointerTo_trt__GetVideoEncoderConfiguration(soap, NULL, NULL, "trt:GetVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationResponse:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurationResponse(soap, NULL, NULL, "trt:GetVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfiguration:
		return soap_in_PointerTo_trt__GetVideoSourceConfiguration(soap, NULL, NULL, "trt:GetVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationsResponse:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurationsResponse(soap, NULL, NULL, "trt:GetAudioEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurations:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurations(soap, NULL, NULL, "trt:GetAudioEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationsResponse:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurationsResponse(soap, NULL, NULL, "trt:GetAudioSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurations:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurations(soap, NULL, NULL, "trt:GetAudioSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationsResponse:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurationsResponse(soap, NULL, NULL, "trt:GetVideoEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurations:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurations(soap, NULL, NULL, "trt:GetVideoEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationsResponse:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurationsResponse(soap, NULL, NULL, "trt:GetVideoSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurations:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurations(soap, NULL, NULL, "trt:GetVideoSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__DeleteProfileResponse:
		return soap_in_PointerTo_trt__DeleteProfileResponse(soap, NULL, NULL, "trt:DeleteProfileResponse");
	case SOAP_TYPE_PointerTo_trt__DeleteProfile:
		return soap_in_PointerTo_trt__DeleteProfile(soap, NULL, NULL, "trt:DeleteProfile");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveAudioSourceConfigurationResponse(soap, NULL, NULL, "trt:RemoveAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfiguration:
		return soap_in_PointerTo_trt__RemoveAudioSourceConfiguration(soap, NULL, NULL, "trt:RemoveAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveAudioEncoderConfigurationResponse(soap, NULL, NULL, "trt:RemoveAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfiguration:
		return soap_in_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, NULL, NULL, "trt:RemoveAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveVideoSourceConfigurationResponse(soap, NULL, NULL, "trt:RemoveVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfiguration:
		return soap_in_PointerTo_trt__RemoveVideoSourceConfiguration(soap, NULL, NULL, "trt:RemoveVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveVideoEncoderConfigurationResponse(soap, NULL, NULL, "trt:RemoveVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfiguration:
		return soap_in_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, NULL, NULL, "trt:RemoveVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfigurationResponse:
		return soap_in_PointerTo_trt__AddAudioSourceConfigurationResponse(soap, NULL, NULL, "trt:AddAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfiguration:
		return soap_in_PointerTo_trt__AddAudioSourceConfiguration(soap, NULL, NULL, "trt:AddAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__AddAudioEncoderConfigurationResponse(soap, NULL, NULL, "trt:AddAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfiguration:
		return soap_in_PointerTo_trt__AddAudioEncoderConfiguration(soap, NULL, NULL, "trt:AddAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfigurationResponse:
		return soap_in_PointerTo_trt__AddVideoSourceConfigurationResponse(soap, NULL, NULL, "trt:AddVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfiguration:
		return soap_in_PointerTo_trt__AddVideoSourceConfiguration(soap, NULL, NULL, "trt:AddVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__AddVideoEncoderConfigurationResponse(soap, NULL, NULL, "trt:AddVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfiguration:
		return soap_in_PointerTo_trt__AddVideoEncoderConfiguration(soap, NULL, NULL, "trt:AddVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetProfilesResponse:
		return soap_in_PointerTo_trt__GetProfilesResponse(soap, NULL, NULL, "trt:GetProfilesResponse");
	case SOAP_TYPE_PointerTo_trt__GetProfiles:
		return soap_in_PointerTo_trt__GetProfiles(soap, NULL, NULL, "trt:GetProfiles");
	case SOAP_TYPE_PointerTo_trt__GetProfileResponse:
		return soap_in_PointerTo_trt__GetProfileResponse(soap, NULL, NULL, "trt:GetProfileResponse");
	case SOAP_TYPE_PointerTo_trt__GetProfile:
		return soap_in_PointerTo_trt__GetProfile(soap, NULL, NULL, "trt:GetProfile");
	case SOAP_TYPE_PointerTo_trt__CreateProfileResponse:
		return soap_in_PointerTo_trt__CreateProfileResponse(soap, NULL, NULL, "trt:CreateProfileResponse");
	case SOAP_TYPE_PointerTo_trt__CreateProfile:
		return soap_in_PointerTo_trt__CreateProfile(soap, NULL, NULL, "trt:CreateProfile");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourcesResponse:
		return soap_in_PointerTo_trt__GetAudioSourcesResponse(soap, NULL, NULL, "trt:GetAudioSourcesResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSources:
		return soap_in_PointerTo_trt__GetAudioSources(soap, NULL, NULL, "trt:GetAudioSources");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourcesResponse:
		return soap_in_PointerTo_trt__GetVideoSourcesResponse(soap, NULL, NULL, "trt:GetVideoSourcesResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSources:
		return soap_in_PointerTo_trt__GetVideoSources(soap, NULL, NULL, "trt:GetVideoSources");
	case SOAP_TYPE_PointerTo_tds__SetZeroConfigurationResponse:
		return soap_in_PointerTo_tds__SetZeroConfigurationResponse(soap, NULL, NULL, "tds:SetZeroConfigurationResponse");
	case SOAP_TYPE_PointerTo_tds__SetZeroConfiguration:
		return soap_in_PointerTo_tds__SetZeroConfiguration(soap, NULL, NULL, "tds:SetZeroConfiguration");
	case SOAP_TYPE_PointerTo_tds__GetZeroConfigurationResponse:
		return soap_in_PointerTo_tds__GetZeroConfigurationResponse(soap, NULL, NULL, "tds:GetZeroConfigurationResponse");
	case SOAP_TYPE_PointerTo_tds__GetZeroConfiguration:
		return soap_in_PointerTo_tds__GetZeroConfiguration(soap, NULL, NULL, "tds:GetZeroConfiguration");
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGatewayResponse:
		return soap_in_PointerTo_tds__SetNetworkDefaultGatewayResponse(soap, NULL, NULL, "tds:SetNetworkDefaultGatewayResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGateway:
		return soap_in_PointerTo_tds__SetNetworkDefaultGateway(soap, NULL, NULL, "tds:SetNetworkDefaultGateway");
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGatewayResponse:
		return soap_in_PointerTo_tds__GetNetworkDefaultGatewayResponse(soap, NULL, NULL, "tds:GetNetworkDefaultGatewayResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGateway:
		return soap_in_PointerTo_tds__GetNetworkDefaultGateway(soap, NULL, NULL, "tds:GetNetworkDefaultGateway");
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfacesResponse:
		return soap_in_PointerTo_tds__SetNetworkInterfacesResponse(soap, NULL, NULL, "tds:SetNetworkInterfacesResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfaces:
		return soap_in_PointerTo_tds__SetNetworkInterfaces(soap, NULL, NULL, "tds:SetNetworkInterfaces");
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfacesResponse:
		return soap_in_PointerTo_tds__GetNetworkInterfacesResponse(soap, NULL, NULL, "tds:GetNetworkInterfacesResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfaces:
		return soap_in_PointerTo_tds__GetNetworkInterfaces(soap, NULL, NULL, "tds:GetNetworkInterfaces");
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNSResponse:
		return soap_in_PointerTo_tds__SetDynamicDNSResponse(soap, NULL, NULL, "tds:SetDynamicDNSResponse");
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNS:
		return soap_in_PointerTo_tds__SetDynamicDNS(soap, NULL, NULL, "tds:SetDynamicDNS");
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNSResponse:
		return soap_in_PointerTo_tds__GetDynamicDNSResponse(soap, NULL, NULL, "tds:GetDynamicDNSResponse");
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNS:
		return soap_in_PointerTo_tds__GetDynamicDNS(soap, NULL, NULL, "tds:GetDynamicDNS");
	case SOAP_TYPE_PointerTo_tds__SetNTPResponse:
		return soap_in_PointerTo_tds__SetNTPResponse(soap, NULL, NULL, "tds:SetNTPResponse");
	case SOAP_TYPE_PointerTo_tds__SetNTP:
		return soap_in_PointerTo_tds__SetNTP(soap, NULL, NULL, "tds:SetNTP");
	case SOAP_TYPE_PointerTo_tds__GetNTPResponse:
		return soap_in_PointerTo_tds__GetNTPResponse(soap, NULL, NULL, "tds:GetNTPResponse");
	case SOAP_TYPE_PointerTo_tds__GetNTP:
		return soap_in_PointerTo_tds__GetNTP(soap, NULL, NULL, "tds:GetNTP");
	case SOAP_TYPE_PointerTo_tds__SetDNSResponse:
		return soap_in_PointerTo_tds__SetDNSResponse(soap, NULL, NULL, "tds:SetDNSResponse");
	case SOAP_TYPE_PointerTo_tds__SetDNS:
		return soap_in_PointerTo_tds__SetDNS(soap, NULL, NULL, "tds:SetDNS");
	case SOAP_TYPE_PointerTo_tds__GetDNSResponse:
		return soap_in_PointerTo_tds__GetDNSResponse(soap, NULL, NULL, "tds:GetDNSResponse");
	case SOAP_TYPE_PointerTo_tds__GetDNS:
		return soap_in_PointerTo_tds__GetDNS(soap, NULL, NULL, "tds:GetDNS");
	case SOAP_TYPE_PointerTo_tds__SetHostnameResponse:
		return soap_in_PointerTo_tds__SetHostnameResponse(soap, NULL, NULL, "tds:SetHostnameResponse");
	case SOAP_TYPE_PointerTo_tds__SetHostname:
		return soap_in_PointerTo_tds__SetHostname(soap, NULL, NULL, "tds:SetHostname");
	case SOAP_TYPE_PointerTo_tds__GetHostnameResponse:
		return soap_in_PointerTo_tds__GetHostnameResponse(soap, NULL, NULL, "tds:GetHostnameResponse");
	case SOAP_TYPE_PointerTo_tds__GetHostname:
		return soap_in_PointerTo_tds__GetHostname(soap, NULL, NULL, "tds:GetHostname");
	case SOAP_TYPE_PointerTo_tds__GetCapabilitiesResponse:
		return soap_in_PointerTo_tds__GetCapabilitiesResponse(soap, NULL, NULL, "tds:GetCapabilitiesResponse");
	case SOAP_TYPE_PointerTo_tds__GetCapabilities:
		return soap_in_PointerTo_tds__GetCapabilities(soap, NULL, NULL, "tds:GetCapabilities");
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrlResponse:
		return soap_in_PointerTo_tds__GetWsdlUrlResponse(soap, NULL, NULL, "tds:GetWsdlUrlResponse");
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrl:
		return soap_in_PointerTo_tds__GetWsdlUrl(soap, NULL, NULL, "tds:GetWsdlUrl");
	case SOAP_TYPE_PointerTo_tds__SetUserResponse:
		return soap_in_PointerTo_tds__SetUserResponse(soap, NULL, NULL, "tds:SetUserResponse");
	case SOAP_TYPE_PointerTo_tds__SetUser:
		return soap_in_PointerTo_tds__SetUser(soap, NULL, NULL, "tds:SetUser");
	case SOAP_TYPE_PointerTo_tds__DeleteUsersResponse:
		return soap_in_PointerTo_tds__DeleteUsersResponse(soap, NULL, NULL, "tds:DeleteUsersResponse");
	case SOAP_TYPE_PointerTo_tds__DeleteUsers:
		return soap_in_PointerTo_tds__DeleteUsers(soap, NULL, NULL, "tds:DeleteUsers");
	case SOAP_TYPE_PointerTo_tds__CreateUsersResponse:
		return soap_in_PointerTo_tds__CreateUsersResponse(soap, NULL, NULL, "tds:CreateUsersResponse");
	case SOAP_TYPE_PointerTo_tds__CreateUsers:
		return soap_in_PointerTo_tds__CreateUsers(soap, NULL, NULL, "tds:CreateUsers");
	case SOAP_TYPE_PointerTo_tds__GetUsersResponse:
		return soap_in_PointerTo_tds__GetUsersResponse(soap, NULL, NULL, "tds:GetUsersResponse");
	case SOAP_TYPE_PointerTo_tds__GetUsers:
		return soap_in_PointerTo_tds__GetUsers(soap, NULL, NULL, "tds:GetUsers");
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryModeResponse:
		return soap_in_PointerTo_tds__SetDiscoveryModeResponse(soap, NULL, NULL, "tds:SetDiscoveryModeResponse");
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryMode:
		return soap_in_PointerTo_tds__SetDiscoveryMode(soap, NULL, NULL, "tds:SetDiscoveryMode");
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryModeResponse:
		return soap_in_PointerTo_tds__GetDiscoveryModeResponse(soap, NULL, NULL, "tds:GetDiscoveryModeResponse");
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryMode:
		return soap_in_PointerTo_tds__GetDiscoveryMode(soap, NULL, NULL, "tds:GetDiscoveryMode");
	case SOAP_TYPE_PointerTo_tds__RemoveScopesResponse:
		return soap_in_PointerTo_tds__RemoveScopesResponse(soap, NULL, NULL, "tds:RemoveScopesResponse");
	case SOAP_TYPE_PointerTo_tds__RemoveScopes:
		return soap_in_PointerTo_tds__RemoveScopes(soap, NULL, NULL, "tds:RemoveScopes");
	case SOAP_TYPE_PointerTo_tds__AddScopesResponse:
		return soap_in_PointerTo_tds__AddScopesResponse(soap, NULL, NULL, "tds:AddScopesResponse");
	case SOAP_TYPE_PointerTo_tds__AddScopes:
		return soap_in_PointerTo_tds__AddScopes(soap, NULL, NULL, "tds:AddScopes");
	case SOAP_TYPE_PointerTo_tds__SetScopesResponse:
		return soap_in_PointerTo_tds__SetScopesResponse(soap, NULL, NULL, "tds:SetScopesResponse");
	case SOAP_TYPE_PointerTo_tds__SetScopes:
		return soap_in_PointerTo_tds__SetScopes(soap, NULL, NULL, "tds:SetScopes");
	case SOAP_TYPE_PointerTo_tds__GetScopesResponse:
		return soap_in_PointerTo_tds__GetScopesResponse(soap, NULL, NULL, "tds:GetScopesResponse");
	case SOAP_TYPE_PointerTo_tds__GetScopes:
		return soap_in_PointerTo_tds__GetScopes(soap, NULL, NULL, "tds:GetScopes");
	case SOAP_TYPE_PointerTo_tds__SystemRebootResponse:
		return soap_in_PointerTo_tds__SystemRebootResponse(soap, NULL, NULL, "tds:SystemRebootResponse");
	case SOAP_TYPE_PointerTo_tds__SystemReboot:
		return soap_in_PointerTo_tds__SystemReboot(soap, NULL, NULL, "tds:SystemReboot");
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefaultResponse:
		return soap_in_PointerTo_tds__SetSystemFactoryDefaultResponse(soap, NULL, NULL, "tds:SetSystemFactoryDefaultResponse");
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefault:
		return soap_in_PointerTo_tds__SetSystemFactoryDefault(soap, NULL, NULL, "tds:SetSystemFactoryDefault");
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTimeResponse:
		return soap_in_PointerTo_tds__GetSystemDateAndTimeResponse(soap, NULL, NULL, "tds:GetSystemDateAndTimeResponse");
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTime:
		return soap_in_PointerTo_tds__GetSystemDateAndTime(soap, NULL, NULL, "tds:GetSystemDateAndTime");
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTimeResponse:
		return soap_in_PointerTo_tds__SetSystemDateAndTimeResponse(soap, NULL, NULL, "tds:SetSystemDateAndTimeResponse");
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTime:
		return soap_in_PointerTo_tds__SetSystemDateAndTime(soap, NULL, NULL, "tds:SetSystemDateAndTime");
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformationResponse:
		return soap_in_PointerTo_tds__GetDeviceInformationResponse(soap, NULL, NULL, "tds:GetDeviceInformationResponse");
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformation:
		return soap_in_PointerTo_tds__GetDeviceInformation(soap, NULL, NULL, "tds:GetDeviceInformation");
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		return soap_in_PointerTod__ProbeMatchesType(soap, NULL, NULL, "d:ProbeMatchesType");
	case SOAP_TYPE_PointerTod__ProbeType:
		return soap_in_PointerTod__ProbeType(soap, NULL, NULL, "d:ProbeType");
	case SOAP_TYPE_PointerTod__ByeType:
		return soap_in_PointerTod__ByeType(soap, NULL, NULL, "d:ByeType");
	case SOAP_TYPE_PointerTod__ResolveType:
		return soap_in_PointerTod__ResolveType(soap, NULL, NULL, "d:ResolveType");
	case SOAP_TYPE_PointerTod__HelloType:
		return soap_in_PointerTod__HelloType(soap, NULL, NULL, "d:HelloType");
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension:
		return soap_in_PointerTott__NetworkInterfaceExtension(soap, NULL, NULL, "tt:NetworkInterfaceExtension");
	case SOAP_TYPE_PointerTott__IPv4NetworkInterface:
		return soap_in_PointerTott__IPv4NetworkInterface(soap, NULL, NULL, "tt:IPv4NetworkInterface");
	case SOAP_TYPE_PointerTott__NetworkInterfaceLink:
		return soap_in_PointerTott__NetworkInterfaceLink(soap, NULL, NULL, "tt:NetworkInterfaceLink");
	case SOAP_TYPE_PointerTott__NetworkInterfaceInfo:
		return soap_in_PointerTott__NetworkInterfaceInfo(soap, NULL, NULL, "tt:NetworkInterfaceInfo");
	case SOAP_TYPE_PointerTott__MulticastConfiguration:
		return soap_in_PointerTott__MulticastConfiguration(soap, NULL, NULL, "tt:MulticastConfiguration");
	case SOAP_TYPE_PointerTott__H264Configuration:
		return soap_in_PointerTott__H264Configuration(soap, NULL, NULL, "tt:H264Configuration");
	case SOAP_TYPE_PointerTott__Mpeg4Configuration:
		return soap_in_PointerTott__Mpeg4Configuration(soap, NULL, NULL, "tt:Mpeg4Configuration");
	case SOAP_TYPE_PointerTott__VideoRateControl:
		return soap_in_PointerTott__VideoRateControl(soap, NULL, NULL, "tt:VideoRateControl");
	case SOAP_TYPE_PointerTott__IntRectangle:
		return soap_in_PointerTott__IntRectangle(soap, NULL, NULL, "tt:IntRectangle");
	case SOAP_TYPE_PointerTott__ImagingSettings:
		return soap_in_PointerTott__ImagingSettings(soap, NULL, NULL, "tt:ImagingSettings");
	case SOAP_TYPE_PointerTowsse__UsernameTokenType:
		return soap_in_PointerTowsse__UsernameTokenType(soap, NULL, NULL, "wsse:UsernameTokenType");
	case SOAP_TYPE_PointerTowsu__TimestampType:
		return soap_in_PointerTowsu__TimestampType(soap, NULL, NULL, "wsu:TimestampType");
	case SOAP_TYPE_PointerTowsse__PasswordString:
		return soap_in_PointerTowsse__PasswordString(soap, NULL, NULL, "wsse:PasswordString");
	case SOAP_TYPE_PointerTowsadis__EndpointReferenceType:
		return soap_in_PointerTowsadis__EndpointReferenceType(soap, NULL, NULL, "wsadis:EndpointReferenceType");
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		return soap_in_PointerTod__ProbeMatchType(soap, NULL, NULL, "d:ProbeMatchType");
	case SOAP_TYPE_PointerTounsignedInt:
		return soap_in_PointerTounsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_PointerTod__ScopesType:
		return soap_in_PointerTod__ScopesType(soap, NULL, NULL, "d:ScopesType");
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		return soap_in_PointerTowsa__EndpointReferenceType(soap, NULL, NULL, "wsa:EndpointReferenceType");
	case SOAP_TYPE_PointerTott__MediaUri:
		return soap_in_PointerTott__MediaUri(soap, NULL, NULL, "tt:MediaUri");
	case SOAP_TYPE_PointerTott__StreamSetup:
		return soap_in_PointerTott__StreamSetup(soap, NULL, NULL, "tt:StreamSetup");
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOptions:
		return soap_in_PointerTott__AudioEncoderConfigurationOptions(soap, NULL, NULL, "tt:AudioEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTott__AudioSourceConfigurationOptions:
		return soap_in_PointerTott__AudioSourceConfigurationOptions(soap, NULL, NULL, "tt:AudioSourceConfigurationOptions");
	case SOAP_TYPE_PointerTott__VideoEncoderConfigurationOptions:
		return soap_in_PointerTott__VideoEncoderConfigurationOptions(soap, NULL, NULL, "tt:VideoEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTott__VideoSourceConfigurationOptions:
		return soap_in_PointerTott__VideoSourceConfigurationOptions(soap, NULL, NULL, "tt:VideoSourceConfigurationOptions");
	case SOAP_TYPE_PointerTott__Profile:
		return soap_in_PointerTott__Profile(soap, NULL, NULL, "tt:Profile");
	case SOAP_TYPE_PointerTott__AudioSource:
		return soap_in_PointerTott__AudioSource(soap, NULL, NULL, "tt:AudioSource");
	case SOAP_TYPE_PointerTott__VideoSource:
		return soap_in_PointerTott__VideoSource(soap, NULL, NULL, "tt:VideoSource");
	case SOAP_TYPE_PointerTotrt__Capabilities:
		return soap_in_PointerTotrt__Capabilities(soap, NULL, NULL, "trt:Capabilities");
	case SOAP_TYPE_PointerTotrt__StreamingCapabilities:
		return soap_in_PointerTotrt__StreamingCapabilities(soap, NULL, NULL, "trt:StreamingCapabilities");
	case SOAP_TYPE_PointerTotrt__ProfileCapabilities:
		return soap_in_PointerTotrt__ProfileCapabilities(soap, NULL, NULL, "trt:ProfileCapabilities");
	case SOAP_TYPE_PointerTowsa__MetadataType:
		return soap_in_PointerTowsa__MetadataType(soap, NULL, NULL, "wsa:MetadataType");
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		return soap_in_PointerTowsa__ReferenceParametersType(soap, NULL, NULL, "wsa:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsa__AttributedURIType:
		return soap_in_PointerTowsa__AttributedURIType(soap, NULL, NULL, "wsa:AttributedURIType");
	case SOAP_TYPE_PointerTott__WhiteBalanceMode:
		return soap_in_PointerTott__WhiteBalanceMode(soap, NULL, NULL, "tt:WhiteBalanceMode");
	case SOAP_TYPE_PointerTott__ExposurePriority:
		return soap_in_PointerTott__ExposurePriority(soap, NULL, NULL, "tt:ExposurePriority");
	case SOAP_TYPE_PointerTott__ExposureMode:
		return soap_in_PointerTott__ExposureMode(soap, NULL, NULL, "tt:ExposureMode");
	case SOAP_TYPE_PointerTott__AutoFocusMode:
		return soap_in_PointerTott__AutoFocusMode(soap, NULL, NULL, "tt:AutoFocusMode");
	case SOAP_TYPE_PointerTott__WideDynamicMode:
		return soap_in_PointerTott__WideDynamicMode(soap, NULL, NULL, "tt:WideDynamicMode");
	case SOAP_TYPE_PointerTott__WhiteBalanceOptions:
		return soap_in_PointerTott__WhiteBalanceOptions(soap, NULL, NULL, "tt:WhiteBalanceOptions");
	case SOAP_TYPE_PointerTott__WideDynamicRangeOptions:
		return soap_in_PointerTott__WideDynamicRangeOptions(soap, NULL, NULL, "tt:WideDynamicRangeOptions");
	case SOAP_TYPE_PointerTott__FocusOptions:
		return soap_in_PointerTott__FocusOptions(soap, NULL, NULL, "tt:FocusOptions");
	case SOAP_TYPE_PointerTott__ExposureOptions:
		return soap_in_PointerTott__ExposureOptions(soap, NULL, NULL, "tt:ExposureOptions");
	case SOAP_TYPE_PointerTott__FloatRange:
		return soap_in_PointerTott__FloatRange(soap, NULL, NULL, "tt:FloatRange");
	case SOAP_TYPE_PointerTott__BacklightCompensationOptions:
		return soap_in_PointerTott__BacklightCompensationOptions(soap, NULL, NULL, "tt:BacklightCompensationOptions");
	case SOAP_TYPE_PointerTott__Rectangle:
		return soap_in_PointerTott__Rectangle(soap, NULL, NULL, "tt:Rectangle");
	case SOAP_TYPE_PointerTott__WhiteBalance:
		return soap_in_PointerTott__WhiteBalance(soap, NULL, NULL, "tt:WhiteBalance");
	case SOAP_TYPE_PointerTott__WideDynamicRange:
		return soap_in_PointerTott__WideDynamicRange(soap, NULL, NULL, "tt:WideDynamicRange");
	case SOAP_TYPE_PointerTott__IrCutFilterMode:
		return soap_in_PointerTott__IrCutFilterMode(soap, NULL, NULL, "tt:IrCutFilterMode");
	case SOAP_TYPE_PointerTott__FocusConfiguration:
		return soap_in_PointerTott__FocusConfiguration(soap, NULL, NULL, "tt:FocusConfiguration");
	case SOAP_TYPE_PointerTott__Exposure:
		return soap_in_PointerTott__Exposure(soap, NULL, NULL, "tt:Exposure");
	case SOAP_TYPE_PointerTofloat:
		return soap_in_PointerTofloat(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_PointerTott__BacklightCompensation:
		return soap_in_PointerTott__BacklightCompensation(soap, NULL, NULL, "tt:BacklightCompensation");
	case SOAP_TYPE_PointerTott__Date:
		return soap_in_PointerTott__Date(soap, NULL, NULL, "tt:Date");
	case SOAP_TYPE_PointerTott__Time:
		return soap_in_PointerTott__Time(soap, NULL, NULL, "tt:Time");
	case SOAP_TYPE_PointerTott__OnvifVersion:
		return soap_in_PointerTott__OnvifVersion(soap, NULL, NULL, "tt:OnvifVersion");
	case SOAP_TYPE_PointerTott__RealTimeStreamingCapabilities:
		return soap_in_PointerTott__RealTimeStreamingCapabilities(soap, NULL, NULL, "tt:RealTimeStreamingCapabilities");
	case SOAP_TYPE_PointerTott__SecurityCapabilities:
		return soap_in_PointerTott__SecurityCapabilities(soap, NULL, NULL, "tt:SecurityCapabilities");
	case SOAP_TYPE_PointerTott__IOCapabilities:
		return soap_in_PointerTott__IOCapabilities(soap, NULL, NULL, "tt:IOCapabilities");
	case SOAP_TYPE_PointerTott__SystemCapabilities:
		return soap_in_PointerTott__SystemCapabilities(soap, NULL, NULL, "tt:SystemCapabilities");
	case SOAP_TYPE_PointerTott__NetworkCapabilities:
		return soap_in_PointerTott__NetworkCapabilities(soap, NULL, NULL, "tt:NetworkCapabilities");
	case SOAP_TYPE_PointerTott__AnalyticsDeviceCapabilities:
		return soap_in_PointerTott__AnalyticsDeviceCapabilities(soap, NULL, NULL, "tt:AnalyticsDeviceCapabilities");
	case SOAP_TYPE_PointerTott__ReceiverCapabilities:
		return soap_in_PointerTott__ReceiverCapabilities(soap, NULL, NULL, "tt:ReceiverCapabilities");
	case SOAP_TYPE_PointerTott__ReplayCapabilities:
		return soap_in_PointerTott__ReplayCapabilities(soap, NULL, NULL, "tt:ReplayCapabilities");
	case SOAP_TYPE_PointerTott__SearchCapabilities:
		return soap_in_PointerTott__SearchCapabilities(soap, NULL, NULL, "tt:SearchCapabilities");
	case SOAP_TYPE_PointerTott__RecordingCapabilities:
		return soap_in_PointerTott__RecordingCapabilities(soap, NULL, NULL, "tt:RecordingCapabilities");
	case SOAP_TYPE_PointerTott__DisplayCapabilities:
		return soap_in_PointerTott__DisplayCapabilities(soap, NULL, NULL, "tt:DisplayCapabilities");
	case SOAP_TYPE_PointerTott__DeviceIOCapabilities:
		return soap_in_PointerTott__DeviceIOCapabilities(soap, NULL, NULL, "tt:DeviceIOCapabilities");
	case SOAP_TYPE_PointerTott__CapabilitiesExtension:
		return soap_in_PointerTott__CapabilitiesExtension(soap, NULL, NULL, "tt:CapabilitiesExtension");
	case SOAP_TYPE_PointerTott__PTZCapabilities:
		return soap_in_PointerTott__PTZCapabilities(soap, NULL, NULL, "tt:PTZCapabilities");
	case SOAP_TYPE_PointerTott__MediaCapabilities:
		return soap_in_PointerTott__MediaCapabilities(soap, NULL, NULL, "tt:MediaCapabilities");
	case SOAP_TYPE_PointerTott__ImagingCapabilities:
		return soap_in_PointerTott__ImagingCapabilities(soap, NULL, NULL, "tt:ImagingCapabilities");
	case SOAP_TYPE_PointerTott__EventCapabilities:
		return soap_in_PointerTott__EventCapabilities(soap, NULL, NULL, "tt:EventCapabilities");
	case SOAP_TYPE_PointerTott__DeviceCapabilities:
		return soap_in_PointerTott__DeviceCapabilities(soap, NULL, NULL, "tt:DeviceCapabilities");
	case SOAP_TYPE_PointerTott__AnalyticsCapabilities:
		return soap_in_PointerTott__AnalyticsCapabilities(soap, NULL, NULL, "tt:AnalyticsCapabilities");
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfigurationExtension:
		return soap_in_PointerTott__NetworkInterfaceSetConfigurationExtension(soap, NULL, NULL, "tt:NetworkInterfaceSetConfigurationExtension");
	case SOAP_TYPE_PointerTott__IPv4NetworkInterfaceSetConfiguration:
		return soap_in_PointerTott__IPv4NetworkInterfaceSetConfiguration(soap, NULL, NULL, "tt:IPv4NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_PointerTott__PrefixedIPv4Address:
		return soap_in_PointerTott__PrefixedIPv4Address(soap, NULL, NULL, "tt:PrefixedIPv4Address");
	case SOAP_TYPE_PointerTott__IPv4Configuration:
		return soap_in_PointerTott__IPv4Configuration(soap, NULL, NULL, "tt:IPv4Configuration");
	case SOAP_TYPE_PointerTott__NetworkInterfaceConnectionSetting:
		return soap_in_PointerTott__NetworkInterfaceConnectionSetting(soap, NULL, NULL, "tt:NetworkInterfaceConnectionSetting");
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension2:
		return soap_in_PointerTott__NetworkInterfaceExtension2(soap, NULL, NULL, "tt:NetworkInterfaceExtension2");
	case SOAP_TYPE_PointerTott__Dot3Configuration:
		return soap_in_PointerTott__Dot3Configuration(soap, NULL, NULL, "tt:Dot3Configuration");
	case SOAP_TYPE_PointerTott__Transport:
		return soap_in_PointerTott__Transport(soap, NULL, NULL, "tt:Transport");
	case SOAP_TYPE_PointerTott__IntList:
		return soap_in_PointerTott__IntList(soap, NULL, NULL, "tt:IntList");
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOption:
		return soap_in_PointerTott__AudioEncoderConfigurationOption(soap, NULL, NULL, "tt:AudioEncoderConfigurationOption");
	case SOAP_TYPE_PointerTott__H264Profile:
		return soap_in_PointerTott__H264Profile(soap, NULL, NULL, "tt:H264Profile");
	case SOAP_TYPE_PointerTott__Mpeg4Profile:
		return soap_in_PointerTott__Mpeg4Profile(soap, NULL, NULL, "tt:Mpeg4Profile");
	case SOAP_TYPE_PointerTott__VideoResolution:
		return soap_in_PointerTott__VideoResolution(soap, NULL, NULL, "tt:VideoResolution");
	case SOAP_TYPE_PointerTott__H264Options:
		return soap_in_PointerTott__H264Options(soap, NULL, NULL, "tt:H264Options");
	case SOAP_TYPE_PointerTott__Mpeg4Options:
		return soap_in_PointerTott__Mpeg4Options(soap, NULL, NULL, "tt:Mpeg4Options");
	case SOAP_TYPE_PointerTott__JpegOptions:
		return soap_in_PointerTott__JpegOptions(soap, NULL, NULL, "tt:JpegOptions");
	case SOAP_TYPE_PointerTott__ReferenceToken:
		return soap_in_PointerTott__ReferenceToken(soap, NULL, NULL, "tt:ReferenceToken");
	case SOAP_TYPE_PointerTott__IntRectangleRange:
		return soap_in_PointerTott__IntRectangleRange(soap, NULL, NULL, "tt:IntRectangleRange");
	case SOAP_TYPE_PointerToxsd__boolean:
		return soap_in_PointerToxsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerTott__AudioEncoderConfiguration:
		return soap_in_PointerTott__AudioEncoderConfiguration(soap, NULL, NULL, "tt:AudioEncoderConfiguration");
	case SOAP_TYPE_PointerTott__VideoEncoderConfiguration:
		return soap_in_PointerTott__VideoEncoderConfiguration(soap, NULL, NULL, "tt:VideoEncoderConfiguration");
	case SOAP_TYPE_PointerTott__AudioSourceConfiguration:
		return soap_in_PointerTott__AudioSourceConfiguration(soap, NULL, NULL, "tt:AudioSourceConfiguration");
	case SOAP_TYPE_PointerTott__VideoSourceConfiguration:
		return soap_in_PointerTott__VideoSourceConfiguration(soap, NULL, NULL, "tt:VideoSourceConfiguration");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerTott__IntRange:
		return soap_in_PointerTott__IntRange(soap, NULL, NULL, "tt:IntRange");
	case SOAP_TYPE_PointerTott__NetworkZeroConfiguration:
		return soap_in_PointerTott__NetworkZeroConfiguration(soap, NULL, NULL, "tt:NetworkZeroConfiguration");
	case SOAP_TYPE_PointerTott__IPv4Address:
		return soap_in_PointerTott__IPv4Address(soap, NULL, NULL, "tt:IPv4Address");
	case SOAP_TYPE_PointerTott__NetworkGateway:
		return soap_in_PointerTott__NetworkGateway(soap, NULL, NULL, "tt:NetworkGateway");
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfiguration:
		return soap_in_PointerTott__NetworkInterfaceSetConfiguration(soap, NULL, NULL, "tt:NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_PointerTott__NetworkInterface:
		return soap_in_PointerTott__NetworkInterface(soap, NULL, NULL, "tt:NetworkInterface");
	case SOAP_TYPE_PointerTott__DNSName:
		return soap_in_PointerTott__DNSName(soap, NULL, NULL, "tt:DNSName");
	case SOAP_TYPE_PointerTott__DynamicDNSInformation:
		return soap_in_PointerTott__DynamicDNSInformation(soap, NULL, NULL, "tt:DynamicDNSInformation");
	case SOAP_TYPE_PointerTott__NetworkHost:
		return soap_in_PointerTott__NetworkHost(soap, NULL, NULL, "tt:NetworkHost");
	case SOAP_TYPE_PointerTott__NTPInformation:
		return soap_in_PointerTott__NTPInformation(soap, NULL, NULL, "tt:NTPInformation");
	case SOAP_TYPE_PointerTott__IPAddress:
		return soap_in_PointerTott__IPAddress(soap, NULL, NULL, "tt:IPAddress");
	case SOAP_TYPE_PointerToxsd__token:
		return soap_in_PointerToxsd__token(soap, NULL, NULL, "xsd:token");
	case SOAP_TYPE_PointerTott__DNSInformation:
		return soap_in_PointerTott__DNSInformation(soap, NULL, NULL, "tt:DNSInformation");
	case SOAP_TYPE_PointerTott__HostnameInformation:
		return soap_in_PointerTott__HostnameInformation(soap, NULL, NULL, "tt:HostnameInformation");
	case SOAP_TYPE_PointerTott__Capabilities:
		return soap_in_PointerTott__Capabilities(soap, NULL, NULL, "tt:Capabilities");
	case SOAP_TYPE_PointerTott__CapabilityCategory:
		return soap_in_PointerTott__CapabilityCategory(soap, NULL, NULL, "tt:CapabilityCategory");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTott__User:
		return soap_in_PointerTott__User(soap, NULL, NULL, "tt:User");
	case SOAP_TYPE_PointerToxsd__anyURI:
		return soap_in_PointerToxsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
	case SOAP_TYPE_PointerTott__Scope:
		return soap_in_PointerTott__Scope(soap, NULL, NULL, "tt:Scope");
	case SOAP_TYPE_PointerTott__SystemDateTime:
		return soap_in_PointerTott__SystemDateTime(soap, NULL, NULL, "tt:SystemDateTime");
	case SOAP_TYPE_PointerTott__DateTime:
		return soap_in_PointerTott__DateTime(soap, NULL, NULL, "tt:DateTime");
	case SOAP_TYPE_PointerTott__TimeZone:
		return soap_in_PointerTott__TimeZone(soap, NULL, NULL, "tt:TimeZone");
	case SOAP_TYPE_PointerTowsadis__ServiceNameType:
		return soap_in_PointerTowsadis__ServiceNameType(soap, NULL, NULL, "wsadis:ServiceNameType");
	case SOAP_TYPE_PointerTowsadis__AttributedQName:
		return soap_in_PointerTowsadis__AttributedQName(soap, NULL, NULL, "wsadis:AttributedQName");
	case SOAP_TYPE_PointerTowsadis__ReferenceParametersType:
		return soap_in_PointerTowsadis__ReferenceParametersType(soap, NULL, NULL, "wsadis:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsadis__ReferencePropertiesType:
		return soap_in_PointerTowsadis__ReferencePropertiesType(soap, NULL, NULL, "wsadis:ReferencePropertiesType");
	case SOAP_TYPE_PointerTowsadis__AttributedURI:
		return soap_in_PointerTowsadis__AttributedURI(soap, NULL, NULL, "wsadis:AttributedURI");
	case SOAP_TYPE_tt__Domain:
	{	char **s;
		s = soap_in_tt__Domain(soap, NULL, NULL, "tt:Domain");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__DNSName:
	{	char **s;
		s = soap_in_tt__DNSName(soap, NULL, NULL, "tt:DNSName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__HwAddress:
	{	char **s;
		s = soap_in_tt__HwAddress(soap, NULL, NULL, "tt:HwAddress");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__IPv4Address:
	{	char **s;
		s = soap_in_tt__IPv4Address(soap, NULL, NULL, "tt:IPv4Address");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__Name:
	{	char **s;
		s = soap_in_tt__Name(soap, NULL, NULL, "tt:Name");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__ReferenceToken:
	{	char **s;
		s = soap_in_tt__ReferenceToken(soap, NULL, NULL, "tt:ReferenceToken");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_d__UriListType:
	{	char **s;
		s = soap_in_d__UriListType(soap, NULL, NULL, "d:UriListType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_d__QNameListType:
	{	char **s;
		s = soap_in_d__QNameListType(soap, NULL, NULL, "d:QNameListType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_wsa__RelationshipTypeOpenEnum:
	{	char **s;
		s = soap_in_wsa__RelationshipTypeOpenEnum(soap, NULL, NULL, "wsa:RelationshipTypeOpenEnum");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__token:
	{	char **s;
		s = soap_in_xsd__token(soap, NULL, NULL, "xsd:token");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__duration:
	{	char **s;
		s = soap_in_xsd__duration(soap, NULL, NULL, "xsd:duration");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__NCName:
	{	char **s;
		s = soap_in_xsd__NCName(soap, NULL, NULL, "xsd:NCName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IANA-IfTypes"))
		{	*type = SOAP_TYPE_tt__IANA_IfTypes;
			return soap_in_tt__IANA_IfTypes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:tTimestampFault"))
		{	*type = SOAP_TYPE_wsu__tTimestampFault;
			return soap_in_wsu__tTimestampFault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:FaultcodeEnum"))
		{	*type = SOAP_TYPE_wsse__FaultcodeEnum;
			return soap_in_wsse__FaultcodeEnum(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:FaultCodeType"))
		{	*type = SOAP_TYPE_d__FaultCodeType;
			return soap_in_d__FaultCodeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RelationshipType"))
		{	*type = SOAP_TYPE_wsa__RelationshipType;
			return soap_in_wsa__RelationshipType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IrCutFilterMode"))
		{	*type = SOAP_TYPE_tt__IrCutFilterMode;
			return soap_in_tt__IrCutFilterMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WhiteBalanceMode"))
		{	*type = SOAP_TYPE_tt__WhiteBalanceMode;
			return soap_in_tt__WhiteBalanceMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Enabled"))
		{	*type = SOAP_TYPE_tt__Enabled;
			return soap_in_tt__Enabled(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ExposureMode"))
		{	*type = SOAP_TYPE_tt__ExposureMode;
			return soap_in_tt__ExposureMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ExposurePriority"))
		{	*type = SOAP_TYPE_tt__ExposurePriority;
			return soap_in_tt__ExposurePriority(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:BacklightCompensationMode"))
		{	*type = SOAP_TYPE_tt__BacklightCompensationMode;
			return soap_in_tt__BacklightCompensationMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WideDynamicMode"))
		{	*type = SOAP_TYPE_tt__WideDynamicMode;
			return soap_in_tt__WideDynamicMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AutoFocusMode"))
		{	*type = SOAP_TYPE_tt__AutoFocusMode;
			return soap_in_tt__AutoFocusMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:UserLevel"))
		{	*type = SOAP_TYPE_tt__UserLevel;
			return soap_in_tt__UserLevel(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SetDateTimeType"))
		{	*type = SOAP_TYPE_tt__SetDateTimeType;
			return soap_in_tt__SetDateTimeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:FactoryDefaultType"))
		{	*type = SOAP_TYPE_tt__FactoryDefaultType;
			return soap_in_tt__FactoryDefaultType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:CapabilityCategory"))
		{	*type = SOAP_TYPE_tt__CapabilityCategory;
			return soap_in_tt__CapabilityCategory(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DynamicDNSType"))
		{	*type = SOAP_TYPE_tt__DynamicDNSType;
			return soap_in_tt__DynamicDNSType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPType"))
		{	*type = SOAP_TYPE_tt__IPType;
			return soap_in_tt__IPType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkHostType"))
		{	*type = SOAP_TYPE_tt__NetworkHostType;
			return soap_in_tt__NetworkHostType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkProtocolType"))
		{	*type = SOAP_TYPE_tt__NetworkProtocolType;
			return soap_in_tt__NetworkProtocolType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Duplex"))
		{	*type = SOAP_TYPE_tt__Duplex;
			return soap_in_tt__Duplex(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DiscoveryMode"))
		{	*type = SOAP_TYPE_tt__DiscoveryMode;
			return soap_in_tt__DiscoveryMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ScopeDefinition"))
		{	*type = SOAP_TYPE_tt__ScopeDefinition;
			return soap_in_tt__ScopeDefinition(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:TransportProtocol"))
		{	*type = SOAP_TYPE_tt__TransportProtocol;
			return soap_in_tt__TransportProtocol(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:StreamType"))
		{	*type = SOAP_TYPE_tt__StreamType;
			return soap_in_tt__StreamType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoding"))
		{	*type = SOAP_TYPE_tt__AudioEncoding;
			return soap_in_tt__AudioEncoding(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:H264Profile"))
		{	*type = SOAP_TYPE_tt__H264Profile;
			return soap_in_tt__H264Profile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Mpeg4Profile"))
		{	*type = SOAP_TYPE_tt__Mpeg4Profile;
			return soap_in_tt__Mpeg4Profile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoEncoding"))
		{	*type = SOAP_TYPE_tt__VideoEncoding;
			return soap_in_tt__VideoEncoding(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:TimestampType"))
		{	*type = SOAP_TYPE_wsu__TimestampType;
			return soap_in_wsu__TimestampType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:SecurityHeaderType"))
		{	*type = SOAP_TYPE_wsse__SecurityHeaderType;
			return soap_in_wsse__SecurityHeaderType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:UsernameTokenType"))
		{	*type = SOAP_TYPE_wsse__UsernameTokenType;
			return soap_in_wsse__UsernameTokenType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:PasswordString"))
		{	*type = SOAP_TYPE_wsse__PasswordString;
			return soap_in_wsse__PasswordString(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:AppSequenceType"))
		{	*type = SOAP_TYPE_d__AppSequenceType;
			return soap_in_d__AppSequenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ScopesType"))
		{	*type = SOAP_TYPE_d__ScopesType;
			return soap_in_d__ScopesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ResolveType"))
		{	*type = SOAP_TYPE_d__ResolveType;
			return soap_in_d__ResolveType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatchType"))
		{	*type = SOAP_TYPE_d__ProbeMatchType;
			return soap_in_d__ProbeMatchType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatchesType"))
		{	*type = SOAP_TYPE_d__ProbeMatchesType;
			return soap_in_d__ProbeMatchesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeType"))
		{	*type = SOAP_TYPE_d__ProbeType;
			return soap_in_d__ProbeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ByeType"))
		{	*type = SOAP_TYPE_d__ByeType;
			return soap_in_d__ByeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:HelloType"))
		{	*type = SOAP_TYPE_d__HelloType;
			return soap_in_d__HelloType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:StreamingCapabilities"))
		{	*type = SOAP_TYPE_trt__StreamingCapabilities;
			return soap_in_trt__StreamingCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:ProfileCapabilities"))
		{	*type = SOAP_TYPE_trt__ProfileCapabilities;
			return soap_in_trt__ProfileCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:Capabilities"))
		{	*type = SOAP_TYPE_trt__Capabilities;
			return soap_in_trt__Capabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:AttributedURIType"))
		{	*type = SOAP_TYPE_wsa__AttributedURIType;
			return soap_in_wsa__AttributedURIType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RelatesToType"))
		{	*type = SOAP_TYPE_wsa__RelatesToType;
			return soap_in_wsa__RelatesToType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:MetadataType"))
		{	*type = SOAP_TYPE_wsa__MetadataType;
			return soap_in_wsa__MetadataType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReferenceParametersType"))
		{	*type = SOAP_TYPE_wsa__ReferenceParametersType;
			return soap_in_wsa__ReferenceParametersType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:EndpointReferenceType"))
		{	*type = SOAP_TYPE_wsa__EndpointReferenceType;
			return soap_in_wsa__EndpointReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Rectangle"))
		{	*type = SOAP_TYPE_tt__Rectangle;
			return soap_in_tt__Rectangle(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WhiteBalance"))
		{	*type = SOAP_TYPE_tt__WhiteBalance;
			return soap_in_tt__WhiteBalance(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WhiteBalanceOptions"))
		{	*type = SOAP_TYPE_tt__WhiteBalanceOptions;
			return soap_in_tt__WhiteBalanceOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ExposureOptions"))
		{	*type = SOAP_TYPE_tt__ExposureOptions;
			return soap_in_tt__ExposureOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:FocusOptions"))
		{	*type = SOAP_TYPE_tt__FocusOptions;
			return soap_in_tt__FocusOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:BacklightCompensationOptions"))
		{	*type = SOAP_TYPE_tt__BacklightCompensationOptions;
			return soap_in_tt__BacklightCompensationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WideDynamicRangeOptions"))
		{	*type = SOAP_TYPE_tt__WideDynamicRangeOptions;
			return soap_in_tt__WideDynamicRangeOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ImagingOptions"))
		{	*type = SOAP_TYPE_tt__ImagingOptions;
			return soap_in_tt__ImagingOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:BacklightCompensation"))
		{	*type = SOAP_TYPE_tt__BacklightCompensation;
			return soap_in_tt__BacklightCompensation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WideDynamicRange"))
		{	*type = SOAP_TYPE_tt__WideDynamicRange;
			return soap_in_tt__WideDynamicRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Exposure"))
		{	*type = SOAP_TYPE_tt__Exposure;
			return soap_in_tt__Exposure(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ImagingSettings"))
		{	*type = SOAP_TYPE_tt__ImagingSettings;
			return soap_in_tt__ImagingSettings(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:FocusConfiguration"))
		{	*type = SOAP_TYPE_tt__FocusConfiguration;
			return soap_in_tt__FocusConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:User"))
		{	*type = SOAP_TYPE_tt__User;
			return soap_in_tt__User(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:TimeZone"))
		{	*type = SOAP_TYPE_tt__TimeZone;
			return soap_in_tt__TimeZone(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Time"))
		{	*type = SOAP_TYPE_tt__Time;
			return soap_in_tt__Time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Date"))
		{	*type = SOAP_TYPE_tt__Date;
			return soap_in_tt__Date(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DateTime"))
		{	*type = SOAP_TYPE_tt__DateTime;
			return soap_in_tt__DateTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SystemDateTime"))
		{	*type = SOAP_TYPE_tt__SystemDateTime;
			return soap_in_tt__SystemDateTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AnalyticsDeviceCapabilities"))
		{	*type = SOAP_TYPE_tt__AnalyticsDeviceCapabilities;
			return soap_in_tt__AnalyticsDeviceCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ReceiverCapabilities"))
		{	*type = SOAP_TYPE_tt__ReceiverCapabilities;
			return soap_in_tt__ReceiverCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ReplayCapabilities"))
		{	*type = SOAP_TYPE_tt__ReplayCapabilities;
			return soap_in_tt__ReplayCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SearchCapabilities"))
		{	*type = SOAP_TYPE_tt__SearchCapabilities;
			return soap_in_tt__SearchCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RecordingCapabilities"))
		{	*type = SOAP_TYPE_tt__RecordingCapabilities;
			return soap_in_tt__RecordingCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DisplayCapabilities"))
		{	*type = SOAP_TYPE_tt__DisplayCapabilities;
			return soap_in_tt__DisplayCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DeviceIOCapabilities"))
		{	*type = SOAP_TYPE_tt__DeviceIOCapabilities;
			return soap_in_tt__DeviceIOCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZCapabilities"))
		{	*type = SOAP_TYPE_tt__PTZCapabilities;
			return soap_in_tt__PTZCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ImagingCapabilities"))
		{	*type = SOAP_TYPE_tt__ImagingCapabilities;
			return soap_in_tt__ImagingCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:OnvifVersion"))
		{	*type = SOAP_TYPE_tt__OnvifVersion;
			return soap_in_tt__OnvifVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SystemCapabilities"))
		{	*type = SOAP_TYPE_tt__SystemCapabilities;
			return soap_in_tt__SystemCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SecurityCapabilities"))
		{	*type = SOAP_TYPE_tt__SecurityCapabilities;
			return soap_in_tt__SecurityCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkCapabilities"))
		{	*type = SOAP_TYPE_tt__NetworkCapabilities;
			return soap_in_tt__NetworkCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ProfileCapabilities"))
		{	*type = SOAP_TYPE_tt__ProfileCapabilities;
			return soap_in_tt__ProfileCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RealTimeStreamingCapabilities"))
		{	*type = SOAP_TYPE_tt__RealTimeStreamingCapabilities;
			return soap_in_tt__RealTimeStreamingCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MediaCapabilities"))
		{	*type = SOAP_TYPE_tt__MediaCapabilities;
			return soap_in_tt__MediaCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IOCapabilities"))
		{	*type = SOAP_TYPE_tt__IOCapabilities;
			return soap_in_tt__IOCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:EventCapabilities"))
		{	*type = SOAP_TYPE_tt__EventCapabilities;
			return soap_in_tt__EventCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DeviceCapabilities"))
		{	*type = SOAP_TYPE_tt__DeviceCapabilities;
			return soap_in_tt__DeviceCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AnalyticsCapabilities"))
		{	*type = SOAP_TYPE_tt__AnalyticsCapabilities;
			return soap_in_tt__AnalyticsCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:CapabilitiesExtension"))
		{	*type = SOAP_TYPE_tt__CapabilitiesExtension;
			return soap_in_tt__CapabilitiesExtension(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Capabilities"))
		{	*type = SOAP_TYPE_tt__Capabilities;
			return soap_in_tt__Capabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkZeroConfiguration"))
		{	*type = SOAP_TYPE_tt__NetworkZeroConfiguration;
			return soap_in_tt__NetworkZeroConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkGateway"))
		{	*type = SOAP_TYPE_tt__NetworkGateway;
			return soap_in_tt__NetworkGateway(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPv4NetworkInterfaceSetConfiguration"))
		{	*type = SOAP_TYPE_tt__IPv4NetworkInterfaceSetConfiguration;
			return soap_in_tt__IPv4NetworkInterfaceSetConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceSetConfigurationExtension"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceSetConfigurationExtension;
			return soap_in_tt__NetworkInterfaceSetConfigurationExtension(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceSetConfiguration"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceSetConfiguration;
			return soap_in_tt__NetworkInterfaceSetConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DynamicDNSInformation"))
		{	*type = SOAP_TYPE_tt__DynamicDNSInformation;
			return soap_in_tt__DynamicDNSInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NTPInformation"))
		{	*type = SOAP_TYPE_tt__NTPInformation;
			return soap_in_tt__NTPInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DNSInformation"))
		{	*type = SOAP_TYPE_tt__DNSInformation;
			return soap_in_tt__DNSInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:HostnameInformation"))
		{	*type = SOAP_TYPE_tt__HostnameInformation;
			return soap_in_tt__HostnameInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PrefixedIPv4Address"))
		{	*type = SOAP_TYPE_tt__PrefixedIPv4Address;
			return soap_in_tt__PrefixedIPv4Address(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPAddress"))
		{	*type = SOAP_TYPE_tt__IPAddress;
			return soap_in_tt__IPAddress(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkHost"))
		{	*type = SOAP_TYPE_tt__NetworkHost;
			return soap_in_tt__NetworkHost(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkProtocol"))
		{	*type = SOAP_TYPE_tt__NetworkProtocol;
			return soap_in_tt__NetworkProtocol(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPv4Configuration"))
		{	*type = SOAP_TYPE_tt__IPv4Configuration;
			return soap_in_tt__IPv4Configuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPv4NetworkInterface"))
		{	*type = SOAP_TYPE_tt__IPv4NetworkInterface;
			return soap_in_tt__IPv4NetworkInterface(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceInfo"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceInfo;
			return soap_in_tt__NetworkInterfaceInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceConnectionSetting"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceConnectionSetting;
			return soap_in_tt__NetworkInterfaceConnectionSetting(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceLink"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceLink;
			return soap_in_tt__NetworkInterfaceLink(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceExtension2"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceExtension2;
			return soap_in_tt__NetworkInterfaceExtension2(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Dot3Configuration"))
		{	*type = SOAP_TYPE_tt__Dot3Configuration;
			return soap_in_tt__Dot3Configuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceExtension"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceExtension;
			return soap_in_tt__NetworkInterfaceExtension(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterface"))
		{	*type = SOAP_TYPE_tt__NetworkInterface;
			return soap_in_tt__NetworkInterface(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Scope"))
		{	*type = SOAP_TYPE_tt__Scope;
			return soap_in_tt__Scope(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MediaUri"))
		{	*type = SOAP_TYPE_tt__MediaUri;
			return soap_in_tt__MediaUri(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Transport"))
		{	*type = SOAP_TYPE_tt__Transport;
			return soap_in_tt__Transport(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:StreamSetup"))
		{	*type = SOAP_TYPE_tt__StreamSetup;
			return soap_in_tt__StreamSetup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MulticastConfiguration"))
		{	*type = SOAP_TYPE_tt__MulticastConfiguration;
			return soap_in_tt__MulticastConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoderConfigurationOption"))
		{	*type = SOAP_TYPE_tt__AudioEncoderConfigurationOption;
			return soap_in_tt__AudioEncoderConfigurationOption(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoderConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__AudioEncoderConfigurationOptions;
			return soap_in_tt__AudioEncoderConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoderConfiguration"))
		{	*type = SOAP_TYPE_tt__AudioEncoderConfiguration;
			return soap_in_tt__AudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioSourceConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__AudioSourceConfigurationOptions;
			return soap_in_tt__AudioSourceConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioSourceConfiguration"))
		{	*type = SOAP_TYPE_tt__AudioSourceConfiguration;
			return soap_in_tt__AudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:H264Options"))
		{	*type = SOAP_TYPE_tt__H264Options;
			return soap_in_tt__H264Options(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Mpeg4Options"))
		{	*type = SOAP_TYPE_tt__Mpeg4Options;
			return soap_in_tt__Mpeg4Options(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:JpegOptions"))
		{	*type = SOAP_TYPE_tt__JpegOptions;
			return soap_in_tt__JpegOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoEncoderConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__VideoEncoderConfigurationOptions;
			return soap_in_tt__VideoEncoderConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:H264Configuration"))
		{	*type = SOAP_TYPE_tt__H264Configuration;
			return soap_in_tt__H264Configuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Mpeg4Configuration"))
		{	*type = SOAP_TYPE_tt__Mpeg4Configuration;
			return soap_in_tt__Mpeg4Configuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoRateControl"))
		{	*type = SOAP_TYPE_tt__VideoRateControl;
			return soap_in_tt__VideoRateControl(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoResolution"))
		{	*type = SOAP_TYPE_tt__VideoResolution;
			return soap_in_tt__VideoResolution(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoEncoderConfiguration"))
		{	*type = SOAP_TYPE_tt__VideoEncoderConfiguration;
			return soap_in_tt__VideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoSourceConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__VideoSourceConfigurationOptions;
			return soap_in_tt__VideoSourceConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoSourceConfiguration"))
		{	*type = SOAP_TYPE_tt__VideoSourceConfiguration;
			return soap_in_tt__VideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ConfigurationEntity"))
		{	*type = SOAP_TYPE_tt__ConfigurationEntity;
			return soap_in_tt__ConfigurationEntity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Profile"))
		{	*type = SOAP_TYPE_tt__Profile;
			return soap_in_tt__Profile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioSource"))
		{	*type = SOAP_TYPE_tt__AudioSource;
			return soap_in_tt__AudioSource(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoSource"))
		{	*type = SOAP_TYPE_tt__VideoSource;
			return soap_in_tt__VideoSource(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IntList"))
		{	*type = SOAP_TYPE_tt__IntList;
			return soap_in_tt__IntList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:FloatRange"))
		{	*type = SOAP_TYPE_tt__FloatRange;
			return soap_in_tt__FloatRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IntRange"))
		{	*type = SOAP_TYPE_tt__IntRange;
			return soap_in_tt__IntRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IntRectangleRange"))
		{	*type = SOAP_TYPE_tt__IntRectangleRange;
			return soap_in_tt__IntRectangleRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IntRectangle"))
		{	*type = SOAP_TYPE_tt__IntRectangle;
			return soap_in_tt__IntRectangle(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DeviceEntity"))
		{	*type = SOAP_TYPE_tt__DeviceEntity;
			return soap_in_tt__DeviceEntity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:AttributedURI"))
		{	*type = SOAP_TYPE_wsadis__AttributedURI;
			return soap_in_wsadis__AttributedURI(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:AttributedQName"))
		{	*type = SOAP_TYPE_wsadis__AttributedQName;
			return soap_in_wsadis__AttributedQName(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:Relationship"))
		{	*type = SOAP_TYPE_wsadis__Relationship;
			return soap_in_wsadis__Relationship(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:ServiceNameType"))
		{	*type = SOAP_TYPE_wsadis__ServiceNameType;
			return soap_in_wsadis__ServiceNameType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:ReferenceParametersType"))
		{	*type = SOAP_TYPE_wsadis__ReferenceParametersType;
			return soap_in_wsadis__ReferenceParametersType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:ReferencePropertiesType"))
		{	*type = SOAP_TYPE_wsadis__ReferencePropertiesType;
			return soap_in_wsadis__ReferencePropertiesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:EndpointReferenceType"))
		{	*type = SOAP_TYPE_wsadis__EndpointReferenceType;
			return soap_in_wsadis__EndpointReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Domain"))
		{	char **s;
			*type = SOAP_TYPE_tt__Domain;
			s = soap_in_tt__Domain(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:DNSName"))
		{	char **s;
			*type = SOAP_TYPE_tt__DNSName;
			s = soap_in_tt__DNSName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:HwAddress"))
		{	char **s;
			*type = SOAP_TYPE_tt__HwAddress;
			s = soap_in_tt__HwAddress(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:IPv4Address"))
		{	char **s;
			*type = SOAP_TYPE_tt__IPv4Address;
			s = soap_in_tt__IPv4Address(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:Name"))
		{	char **s;
			*type = SOAP_TYPE_tt__Name;
			s = soap_in_tt__Name(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:ReferenceToken"))
		{	char **s;
			*type = SOAP_TYPE_tt__ReferenceToken;
			s = soap_in_tt__ReferenceToken(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:UriListType"))
		{	char **s;
			*type = SOAP_TYPE_d__UriListType;
			s = soap_in_d__UriListType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:QNameListType"))
		{	char **s;
			*type = SOAP_TYPE_d__QNameListType;
			s = soap_in_d__QNameListType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa:RelationshipTypeOpenEnum"))
		{	char **s;
			*type = SOAP_TYPE_wsa__RelationshipTypeOpenEnum;
			s = soap_in_wsa__RelationshipTypeOpenEnum(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:token"))
		{	char **s;
			*type = SOAP_TYPE_xsd__token;
			s = soap_in_xsd__token(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:duration"))
		{	char **s;
			*type = SOAP_TYPE_xsd__duration;
			s = soap_in_xsd__duration(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:NCName"))
		{	char **s;
			*type = SOAP_TYPE_xsd__NCName;
			s = soap_in_xsd__NCName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "d:MetadataVersion"))
		{	*type = SOAP_TYPE__d__MetadataVersion;
			return soap_in__d__MetadataVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:Timestamp"))
		{	*type = SOAP_TYPE__wsu__Timestamp;
			return soap_in__wsu__Timestamp(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:Password"))
		{	*type = SOAP_TYPE__wsse__Password;
			return soap_in__wsse__Password(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:Security"))
		{	*type = SOAP_TYPE__wsse__Security;
			return soap_in__wsse__Security(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:UsernameToken"))
		{	*type = SOAP_TYPE__wsse__UsernameToken;
			return soap_in__wsse__UsernameToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:AppSequence"))
		{	*type = SOAP_TYPE__d__AppSequence;
			return soap_in__d__AppSequence(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Scopes"))
		{	*type = SOAP_TYPE__d__Scopes;
			return soap_in__d__Scopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Resolve"))
		{	*type = SOAP_TYPE__d__Resolve;
			return soap_in__d__Resolve(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ByeResponse"))
		{	*type = SOAP_TYPE__d__ByeResponse;
			return soap_in__d__ByeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Bye"))
		{	*type = SOAP_TYPE__d__Bye;
			return soap_in__d__Bye(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatches"))
		{	*type = SOAP_TYPE__d__ProbeMatches;
			return soap_in__d__ProbeMatches(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Probe"))
		{	*type = SOAP_TYPE__d__Probe;
			return soap_in__d__Probe(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:HelloResponse"))
		{	*type = SOAP_TYPE__d__HelloResponse;
			return soap_in__d__HelloResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Hello"))
		{	*type = SOAP_TYPE__d__Hello;
			return soap_in__d__Hello(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:Capabilities"))
		{	*type = SOAP_TYPE__trt__Capabilities;
			return soap_in__trt__Capabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:Action"))
		{	*type = SOAP_TYPE__wsa__Action;
			return soap_in__wsa__Action(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:To"))
		{	*type = SOAP_TYPE__wsa__To;
			return soap_in__wsa__To(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:FaultTo"))
		{	*type = SOAP_TYPE__wsa__FaultTo;
			return soap_in__wsa__FaultTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:From"))
		{	*type = SOAP_TYPE__wsa__From;
			return soap_in__wsa__From(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReplyTo"))
		{	*type = SOAP_TYPE__wsa__ReplyTo;
			return soap_in__wsa__ReplyTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RelatesTo"))
		{	*type = SOAP_TYPE__wsa__RelatesTo;
			return soap_in__wsa__RelatesTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:MessageID"))
		{	*type = SOAP_TYPE__wsa__MessageID;
			return soap_in__wsa__MessageID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:Metadata"))
		{	*type = SOAP_TYPE__wsa__Metadata;
			return soap_in__wsa__Metadata(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:EndpointReference"))
		{	*type = SOAP_TYPE__wsa__EndpointReference;
			return soap_in__wsa__EndpointReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__tt__AudioEncoderConfiguration;
			return soap_in__tt__AudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__tt__VideoEncoderConfiguration;
			return soap_in__tt__VideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioSourceConfiguration"))
		{	*type = SOAP_TYPE__tt__AudioSourceConfiguration;
			return soap_in__tt__AudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoSourceConfiguration"))
		{	*type = SOAP_TYPE__tt__VideoSourceConfiguration;
			return soap_in__tt__VideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:FaultTo"))
		{	*type = SOAP_TYPE__wsadis__FaultTo;
			return soap_in__wsadis__FaultTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:ReplyTo"))
		{	*type = SOAP_TYPE__wsadis__ReplyTo;
			return soap_in__wsadis__ReplyTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:From"))
		{	*type = SOAP_TYPE__wsadis__From;
			return soap_in__wsadis__From(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:Action"))
		{	*type = SOAP_TYPE__wsadis__Action;
			return soap_in__wsadis__Action(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:To"))
		{	*type = SOAP_TYPE__wsadis__To;
			return soap_in__wsadis__To(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:RelatesTo"))
		{	*type = SOAP_TYPE__wsadis__RelatesTo;
			return soap_in__wsadis__RelatesTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:MessageID"))
		{	*type = SOAP_TYPE__wsadis__MessageID;
			return soap_in__wsadis__MessageID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:EndpointReference"))
		{	*type = SOAP_TYPE__wsadis__EndpointReference;
			return soap_in__wsadis__EndpointReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetSnapshotUriResponse"))
		{	*type = SOAP_TYPE__trt__GetSnapshotUriResponse;
			return soap_in__trt__GetSnapshotUriResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetSnapshotUri"))
		{	*type = SOAP_TYPE__trt__GetSnapshotUri;
			return soap_in__trt__GetSnapshotUri(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetStreamUriResponse"))
		{	*type = SOAP_TYPE__trt__GetStreamUriResponse;
			return soap_in__trt__GetStreamUriResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetStreamUri"))
		{	*type = SOAP_TYPE__trt__GetStreamUri;
			return soap_in__trt__GetStreamUri(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse;
			return soap_in__trt__GetAudioEncoderConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions;
			return soap_in__trt__GetAudioEncoderConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse;
			return soap_in__trt__GetAudioSourceConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurationOptions;
			return soap_in__trt__GetAudioSourceConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse;
			return soap_in__trt__GetVideoEncoderConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions;
			return soap_in__trt__GetVideoEncoderConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse;
			return soap_in__trt__GetVideoSourceConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurationOptions;
			return soap_in__trt__GetVideoSourceConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetAudioSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetAudioSourceConfigurationResponse;
			return soap_in__trt__SetAudioSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetAudioSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__SetAudioSourceConfiguration;
			return soap_in__trt__SetAudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetAudioEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse;
			return soap_in__trt__SetAudioEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetAudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__SetAudioEncoderConfiguration;
			return soap_in__trt__SetAudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetVideoSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetVideoSourceConfigurationResponse;
			return soap_in__trt__SetVideoSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetVideoSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__SetVideoSourceConfiguration;
			return soap_in__trt__SetVideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetVideoEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse;
			return soap_in__trt__SetVideoEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetVideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__SetVideoEncoderConfiguration;
			return soap_in__trt__SetVideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleAudioSourceConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse;
			return soap_in__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleAudioSourceConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations;
			return soap_in__trt__GetCompatibleAudioSourceConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleAudioEncoderConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse;
			return soap_in__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleAudioEncoderConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations;
			return soap_in__trt__GetCompatibleAudioEncoderConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleVideoSourceConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse;
			return soap_in__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleVideoSourceConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations;
			return soap_in__trt__GetCompatibleVideoSourceConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleVideoEncoderConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse;
			return soap_in__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleVideoEncoderConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations;
			return soap_in__trt__GetCompatibleVideoEncoderConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse;
			return soap_in__trt__GetAudioEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfiguration;
			return soap_in__trt__GetAudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurationResponse;
			return soap_in__trt__GetAudioSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfiguration;
			return soap_in__trt__GetAudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse;
			return soap_in__trt__GetVideoEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfiguration;
			return soap_in__trt__GetVideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurationResponse;
			return soap_in__trt__GetVideoSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfiguration;
			return soap_in__trt__GetVideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse;
			return soap_in__trt__GetAudioSourceConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurations"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurations;
			return soap_in__trt__GetAudioSourceConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse;
			return soap_in__trt__GetAudioEncoderConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurations"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurations;
			return soap_in__trt__GetAudioEncoderConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse;
			return soap_in__trt__GetVideoSourceConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurations"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurations;
			return soap_in__trt__GetVideoSourceConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse;
			return soap_in__trt__GetVideoEncoderConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurations"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurations;
			return soap_in__trt__GetVideoEncoderConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:DeleteProfileResponse"))
		{	*type = SOAP_TYPE__trt__DeleteProfileResponse;
			return soap_in__trt__DeleteProfileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:DeleteProfile"))
		{	*type = SOAP_TYPE__trt__DeleteProfile;
			return soap_in__trt__DeleteProfile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveAudioSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse;
			return soap_in__trt__RemoveAudioSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveAudioSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveAudioSourceConfiguration;
			return soap_in__trt__RemoveAudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddAudioSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddAudioSourceConfigurationResponse;
			return soap_in__trt__AddAudioSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddAudioSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__AddAudioSourceConfiguration;
			return soap_in__trt__AddAudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveAudioEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse;
			return soap_in__trt__RemoveAudioEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveAudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveAudioEncoderConfiguration;
			return soap_in__trt__RemoveAudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddAudioEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse;
			return soap_in__trt__AddAudioEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddAudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__AddAudioEncoderConfiguration;
			return soap_in__trt__AddAudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveVideoSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse;
			return soap_in__trt__RemoveVideoSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveVideoSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveVideoSourceConfiguration;
			return soap_in__trt__RemoveVideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddVideoSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddVideoSourceConfigurationResponse;
			return soap_in__trt__AddVideoSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddVideoSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__AddVideoSourceConfiguration;
			return soap_in__trt__AddVideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveVideoEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse;
			return soap_in__trt__RemoveVideoEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveVideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveVideoEncoderConfiguration;
			return soap_in__trt__RemoveVideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddVideoEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse;
			return soap_in__trt__AddVideoEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddVideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__AddVideoEncoderConfiguration;
			return soap_in__trt__AddVideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetProfilesResponse"))
		{	*type = SOAP_TYPE__trt__GetProfilesResponse;
			return soap_in__trt__GetProfilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetProfiles"))
		{	*type = SOAP_TYPE__trt__GetProfiles;
			return soap_in__trt__GetProfiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetProfileResponse"))
		{	*type = SOAP_TYPE__trt__GetProfileResponse;
			return soap_in__trt__GetProfileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetProfile"))
		{	*type = SOAP_TYPE__trt__GetProfile;
			return soap_in__trt__GetProfile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:CreateProfileResponse"))
		{	*type = SOAP_TYPE__trt__CreateProfileResponse;
			return soap_in__trt__CreateProfileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:CreateProfile"))
		{	*type = SOAP_TYPE__trt__CreateProfile;
			return soap_in__trt__CreateProfile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourcesResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioSourcesResponse;
			return soap_in__trt__GetAudioSourcesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSources"))
		{	*type = SOAP_TYPE__trt__GetAudioSources;
			return soap_in__trt__GetAudioSources(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourcesResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoSourcesResponse;
			return soap_in__trt__GetVideoSourcesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSources"))
		{	*type = SOAP_TYPE__trt__GetVideoSources;
			return soap_in__trt__GetVideoSources(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetServiceCapabilitiesResponse"))
		{	*type = SOAP_TYPE__trt__GetServiceCapabilitiesResponse;
			return soap_in__trt__GetServiceCapabilitiesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetServiceCapabilities"))
		{	*type = SOAP_TYPE__trt__GetServiceCapabilities;
			return soap_in__trt__GetServiceCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetZeroConfigurationResponse"))
		{	*type = SOAP_TYPE__tds__SetZeroConfigurationResponse;
			return soap_in__tds__SetZeroConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetZeroConfiguration"))
		{	*type = SOAP_TYPE__tds__SetZeroConfiguration;
			return soap_in__tds__SetZeroConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetZeroConfigurationResponse"))
		{	*type = SOAP_TYPE__tds__GetZeroConfigurationResponse;
			return soap_in__tds__GetZeroConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetZeroConfiguration"))
		{	*type = SOAP_TYPE__tds__GetZeroConfiguration;
			return soap_in__tds__GetZeroConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkDefaultGatewayResponse"))
		{	*type = SOAP_TYPE__tds__SetNetworkDefaultGatewayResponse;
			return soap_in__tds__SetNetworkDefaultGatewayResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkDefaultGateway"))
		{	*type = SOAP_TYPE__tds__SetNetworkDefaultGateway;
			return soap_in__tds__SetNetworkDefaultGateway(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkDefaultGatewayResponse"))
		{	*type = SOAP_TYPE__tds__GetNetworkDefaultGatewayResponse;
			return soap_in__tds__GetNetworkDefaultGatewayResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkDefaultGateway"))
		{	*type = SOAP_TYPE__tds__GetNetworkDefaultGateway;
			return soap_in__tds__GetNetworkDefaultGateway(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkInterfacesResponse"))
		{	*type = SOAP_TYPE__tds__SetNetworkInterfacesResponse;
			return soap_in__tds__SetNetworkInterfacesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkInterfaces"))
		{	*type = SOAP_TYPE__tds__SetNetworkInterfaces;
			return soap_in__tds__SetNetworkInterfaces(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkInterfacesResponse"))
		{	*type = SOAP_TYPE__tds__GetNetworkInterfacesResponse;
			return soap_in__tds__GetNetworkInterfacesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkInterfaces"))
		{	*type = SOAP_TYPE__tds__GetNetworkInterfaces;
			return soap_in__tds__GetNetworkInterfaces(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDynamicDNSResponse"))
		{	*type = SOAP_TYPE__tds__SetDynamicDNSResponse;
			return soap_in__tds__SetDynamicDNSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDynamicDNS"))
		{	*type = SOAP_TYPE__tds__SetDynamicDNS;
			return soap_in__tds__SetDynamicDNS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDynamicDNSResponse"))
		{	*type = SOAP_TYPE__tds__GetDynamicDNSResponse;
			return soap_in__tds__GetDynamicDNSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDynamicDNS"))
		{	*type = SOAP_TYPE__tds__GetDynamicDNS;
			return soap_in__tds__GetDynamicDNS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNTPResponse"))
		{	*type = SOAP_TYPE__tds__SetNTPResponse;
			return soap_in__tds__SetNTPResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNTP"))
		{	*type = SOAP_TYPE__tds__SetNTP;
			return soap_in__tds__SetNTP(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNTPResponse"))
		{	*type = SOAP_TYPE__tds__GetNTPResponse;
			return soap_in__tds__GetNTPResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNTP"))
		{	*type = SOAP_TYPE__tds__GetNTP;
			return soap_in__tds__GetNTP(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDNSResponse"))
		{	*type = SOAP_TYPE__tds__SetDNSResponse;
			return soap_in__tds__SetDNSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDNS"))
		{	*type = SOAP_TYPE__tds__SetDNS;
			return soap_in__tds__SetDNS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDNSResponse"))
		{	*type = SOAP_TYPE__tds__GetDNSResponse;
			return soap_in__tds__GetDNSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDNS"))
		{	*type = SOAP_TYPE__tds__GetDNS;
			return soap_in__tds__GetDNS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetHostnameResponse"))
		{	*type = SOAP_TYPE__tds__SetHostnameResponse;
			return soap_in__tds__SetHostnameResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetHostname"))
		{	*type = SOAP_TYPE__tds__SetHostname;
			return soap_in__tds__SetHostname(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetHostnameResponse"))
		{	*type = SOAP_TYPE__tds__GetHostnameResponse;
			return soap_in__tds__GetHostnameResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetHostname"))
		{	*type = SOAP_TYPE__tds__GetHostname;
			return soap_in__tds__GetHostname(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetCapabilitiesResponse"))
		{	*type = SOAP_TYPE__tds__GetCapabilitiesResponse;
			return soap_in__tds__GetCapabilitiesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetCapabilities"))
		{	*type = SOAP_TYPE__tds__GetCapabilities;
			return soap_in__tds__GetCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetWsdlUrlResponse"))
		{	*type = SOAP_TYPE__tds__GetWsdlUrlResponse;
			return soap_in__tds__GetWsdlUrlResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetWsdlUrl"))
		{	*type = SOAP_TYPE__tds__GetWsdlUrl;
			return soap_in__tds__GetWsdlUrl(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetUserResponse"))
		{	*type = SOAP_TYPE__tds__SetUserResponse;
			return soap_in__tds__SetUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetUser"))
		{	*type = SOAP_TYPE__tds__SetUser;
			return soap_in__tds__SetUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:DeleteUsersResponse"))
		{	*type = SOAP_TYPE__tds__DeleteUsersResponse;
			return soap_in__tds__DeleteUsersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:DeleteUsers"))
		{	*type = SOAP_TYPE__tds__DeleteUsers;
			return soap_in__tds__DeleteUsers(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:CreateUsersResponse"))
		{	*type = SOAP_TYPE__tds__CreateUsersResponse;
			return soap_in__tds__CreateUsersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:CreateUsers"))
		{	*type = SOAP_TYPE__tds__CreateUsers;
			return soap_in__tds__CreateUsers(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetUsersResponse"))
		{	*type = SOAP_TYPE__tds__GetUsersResponse;
			return soap_in__tds__GetUsersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetUsers"))
		{	*type = SOAP_TYPE__tds__GetUsers;
			return soap_in__tds__GetUsers(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDiscoveryModeResponse"))
		{	*type = SOAP_TYPE__tds__SetDiscoveryModeResponse;
			return soap_in__tds__SetDiscoveryModeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDiscoveryMode"))
		{	*type = SOAP_TYPE__tds__SetDiscoveryMode;
			return soap_in__tds__SetDiscoveryMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDiscoveryModeResponse"))
		{	*type = SOAP_TYPE__tds__GetDiscoveryModeResponse;
			return soap_in__tds__GetDiscoveryModeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDiscoveryMode"))
		{	*type = SOAP_TYPE__tds__GetDiscoveryMode;
			return soap_in__tds__GetDiscoveryMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:RemoveScopesResponse"))
		{	*type = SOAP_TYPE__tds__RemoveScopesResponse;
			return soap_in__tds__RemoveScopesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:RemoveScopes"))
		{	*type = SOAP_TYPE__tds__RemoveScopes;
			return soap_in__tds__RemoveScopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:AddScopesResponse"))
		{	*type = SOAP_TYPE__tds__AddScopesResponse;
			return soap_in__tds__AddScopesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:AddScopes"))
		{	*type = SOAP_TYPE__tds__AddScopes;
			return soap_in__tds__AddScopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetScopesResponse"))
		{	*type = SOAP_TYPE__tds__SetScopesResponse;
			return soap_in__tds__SetScopesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetScopes"))
		{	*type = SOAP_TYPE__tds__SetScopes;
			return soap_in__tds__SetScopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetScopesResponse"))
		{	*type = SOAP_TYPE__tds__GetScopesResponse;
			return soap_in__tds__GetScopesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetScopes"))
		{	*type = SOAP_TYPE__tds__GetScopes;
			return soap_in__tds__GetScopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SystemRebootResponse"))
		{	*type = SOAP_TYPE__tds__SystemRebootResponse;
			return soap_in__tds__SystemRebootResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SystemReboot"))
		{	*type = SOAP_TYPE__tds__SystemReboot;
			return soap_in__tds__SystemReboot(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetSystemFactoryDefaultResponse"))
		{	*type = SOAP_TYPE__tds__SetSystemFactoryDefaultResponse;
			return soap_in__tds__SetSystemFactoryDefaultResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetSystemFactoryDefault"))
		{	*type = SOAP_TYPE__tds__SetSystemFactoryDefault;
			return soap_in__tds__SetSystemFactoryDefault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetSystemDateAndTimeResponse"))
		{	*type = SOAP_TYPE__tds__GetSystemDateAndTimeResponse;
			return soap_in__tds__GetSystemDateAndTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetSystemDateAndTime"))
		{	*type = SOAP_TYPE__tds__GetSystemDateAndTime;
			return soap_in__tds__GetSystemDateAndTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetSystemDateAndTimeResponse"))
		{	*type = SOAP_TYPE__tds__SetSystemDateAndTimeResponse;
			return soap_in__tds__SetSystemDateAndTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetSystemDateAndTime"))
		{	*type = SOAP_TYPE__tds__SetSystemDateAndTime;
			return soap_in__tds__SetSystemDateAndTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDeviceInformationResponse"))
		{	*type = SOAP_TYPE__tds__GetDeviceInformationResponse;
			return soap_in__tds__GetDeviceInformationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDeviceInformation"))
		{	*type = SOAP_TYPE__tds__GetDeviceInformation;
			return soap_in__tds__GetDeviceInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:Created"))
		{	char **s;
			*type = SOAP_TYPE__wsu__Created;
			s = soap_in__wsu__Created(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsu:Id"))
		{	char **s;
			*type = SOAP_TYPE__wsu__Id;
			s = soap_in__wsu__Id(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:XAddrs"))
		{	char **s;
			*type = SOAP_TYPE__d__XAddrs;
			s = soap_in__d__XAddrs(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:Types"))
		{	char **s;
			*type = SOAP_TYPE__d__Types;
			s = soap_in__d__Types(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_tt__IANA_IfTypes:
		return soap_out_tt__IANA_IfTypes(soap, tag, id, (const int *)ptr, "tt:IANA-IfTypes");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE__d__MetadataVersion:
		return soap_out__d__MetadataVersion(soap, "d:MetadataVersion", id, (const unsigned int *)ptr, NULL);
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_wsu__tTimestampFault:
		return soap_out_wsu__tTimestampFault(soap, tag, id, (const enum wsu__tTimestampFault *)ptr, "wsu:tTimestampFault");
	case SOAP_TYPE_wsse__FaultcodeEnum:
		return soap_out_wsse__FaultcodeEnum(soap, tag, id, (const enum wsse__FaultcodeEnum *)ptr, "wsse:FaultcodeEnum");
	case SOAP_TYPE_d__FaultCodeType:
		return soap_out_d__FaultCodeType(soap, tag, id, (const enum d__FaultCodeType *)ptr, "d:FaultCodeType");
	case SOAP_TYPE_wsa__RelationshipType:
		return soap_out_wsa__RelationshipType(soap, tag, id, (const enum wsa__RelationshipType *)ptr, "wsa:RelationshipType");
	case SOAP_TYPE_tt__IrCutFilterMode:
		return soap_out_tt__IrCutFilterMode(soap, tag, id, (const enum tt__IrCutFilterMode *)ptr, "tt:IrCutFilterMode");
	case SOAP_TYPE_tt__WhiteBalanceMode:
		return soap_out_tt__WhiteBalanceMode(soap, tag, id, (const enum tt__WhiteBalanceMode *)ptr, "tt:WhiteBalanceMode");
	case SOAP_TYPE_tt__Enabled:
		return soap_out_tt__Enabled(soap, tag, id, (const enum tt__Enabled *)ptr, "tt:Enabled");
	case SOAP_TYPE_tt__ExposureMode:
		return soap_out_tt__ExposureMode(soap, tag, id, (const enum tt__ExposureMode *)ptr, "tt:ExposureMode");
	case SOAP_TYPE_tt__ExposurePriority:
		return soap_out_tt__ExposurePriority(soap, tag, id, (const enum tt__ExposurePriority *)ptr, "tt:ExposurePriority");
	case SOAP_TYPE_tt__BacklightCompensationMode:
		return soap_out_tt__BacklightCompensationMode(soap, tag, id, (const enum tt__BacklightCompensationMode *)ptr, "tt:BacklightCompensationMode");
	case SOAP_TYPE_tt__WideDynamicMode:
		return soap_out_tt__WideDynamicMode(soap, tag, id, (const enum tt__WideDynamicMode *)ptr, "tt:WideDynamicMode");
	case SOAP_TYPE_tt__AutoFocusMode:
		return soap_out_tt__AutoFocusMode(soap, tag, id, (const enum tt__AutoFocusMode *)ptr, "tt:AutoFocusMode");
	case SOAP_TYPE_tt__UserLevel:
		return soap_out_tt__UserLevel(soap, tag, id, (const enum tt__UserLevel *)ptr, "tt:UserLevel");
	case SOAP_TYPE_tt__SetDateTimeType:
		return soap_out_tt__SetDateTimeType(soap, tag, id, (const enum tt__SetDateTimeType *)ptr, "tt:SetDateTimeType");
	case SOAP_TYPE_tt__FactoryDefaultType:
		return soap_out_tt__FactoryDefaultType(soap, tag, id, (const enum tt__FactoryDefaultType *)ptr, "tt:FactoryDefaultType");
	case SOAP_TYPE_tt__CapabilityCategory:
		return soap_out_tt__CapabilityCategory(soap, tag, id, (const enum tt__CapabilityCategory *)ptr, "tt:CapabilityCategory");
	case SOAP_TYPE_tt__DynamicDNSType:
		return soap_out_tt__DynamicDNSType(soap, tag, id, (const enum tt__DynamicDNSType *)ptr, "tt:DynamicDNSType");
	case SOAP_TYPE_tt__IPType:
		return soap_out_tt__IPType(soap, tag, id, (const enum tt__IPType *)ptr, "tt:IPType");
	case SOAP_TYPE_tt__NetworkHostType:
		return soap_out_tt__NetworkHostType(soap, tag, id, (const enum tt__NetworkHostType *)ptr, "tt:NetworkHostType");
	case SOAP_TYPE_tt__NetworkProtocolType:
		return soap_out_tt__NetworkProtocolType(soap, tag, id, (const enum tt__NetworkProtocolType *)ptr, "tt:NetworkProtocolType");
	case SOAP_TYPE_tt__Duplex:
		return soap_out_tt__Duplex(soap, tag, id, (const enum tt__Duplex *)ptr, "tt:Duplex");
	case SOAP_TYPE_tt__DiscoveryMode:
		return soap_out_tt__DiscoveryMode(soap, tag, id, (const enum tt__DiscoveryMode *)ptr, "tt:DiscoveryMode");
	case SOAP_TYPE_tt__ScopeDefinition:
		return soap_out_tt__ScopeDefinition(soap, tag, id, (const enum tt__ScopeDefinition *)ptr, "tt:ScopeDefinition");
	case SOAP_TYPE_tt__TransportProtocol:
		return soap_out_tt__TransportProtocol(soap, tag, id, (const enum tt__TransportProtocol *)ptr, "tt:TransportProtocol");
	case SOAP_TYPE_tt__StreamType:
		return soap_out_tt__StreamType(soap, tag, id, (const enum tt__StreamType *)ptr, "tt:StreamType");
	case SOAP_TYPE_tt__AudioEncoding:
		return soap_out_tt__AudioEncoding(soap, tag, id, (const enum tt__AudioEncoding *)ptr, "tt:AudioEncoding");
	case SOAP_TYPE_tt__H264Profile:
		return soap_out_tt__H264Profile(soap, tag, id, (const enum tt__H264Profile *)ptr, "tt:H264Profile");
	case SOAP_TYPE_tt__Mpeg4Profile:
		return soap_out_tt__Mpeg4Profile(soap, tag, id, (const enum tt__Mpeg4Profile *)ptr, "tt:Mpeg4Profile");
	case SOAP_TYPE_tt__VideoEncoding:
		return soap_out_tt__VideoEncoding(soap, tag, id, (const enum tt__VideoEncoding *)ptr, "tt:VideoEncoding");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const enum xsd__boolean *)ptr, "xsd:boolean");
	case SOAP_TYPE__wsu__Timestamp:
		return soap_out__wsu__Timestamp(soap, "wsu:Timestamp", id, (const struct wsu__TimestampType *)ptr, NULL);
	case SOAP_TYPE__wsse__Password:
		return soap_out__wsse__Password(soap, "wsse:Password", id, (const struct wsse__PasswordString *)ptr, NULL);
	case SOAP_TYPE__wsse__Security:
		return soap_out__wsse__Security(soap, "wsse:Security", id, (const struct wsse__SecurityHeaderType *)ptr, NULL);
	case SOAP_TYPE__wsse__UsernameToken:
		return soap_out__wsse__UsernameToken(soap, "wsse:UsernameToken", id, (const struct wsse__UsernameTokenType *)ptr, NULL);
	case SOAP_TYPE__d__AppSequence:
		return soap_out__d__AppSequence(soap, "d:AppSequence", id, (const struct d__AppSequenceType *)ptr, NULL);
	case SOAP_TYPE__d__Scopes:
		return soap_out__d__Scopes(soap, "d:Scopes", id, (const struct d__ScopesType *)ptr, NULL);
	case SOAP_TYPE__d__Resolve:
		return soap_out__d__Resolve(soap, "d:Resolve", id, (const struct d__ResolveType *)ptr, NULL);
	case SOAP_TYPE__d__ByeResponse:
		return soap_out__d__ByeResponse(soap, "d:ByeResponse", id, (const struct d__ResolveType *)ptr, NULL);
	case SOAP_TYPE__d__Bye:
		return soap_out__d__Bye(soap, "d:Bye", id, (const struct d__ByeType *)ptr, NULL);
	case SOAP_TYPE__d__ProbeMatches:
		return soap_out__d__ProbeMatches(soap, "d:ProbeMatches", id, (const struct d__ProbeMatchesType *)ptr, NULL);
	case SOAP_TYPE__d__Probe:
		return soap_out__d__Probe(soap, "d:Probe", id, (const struct d__ProbeType *)ptr, NULL);
	case SOAP_TYPE__d__HelloResponse:
		return soap_out__d__HelloResponse(soap, "d:HelloResponse", id, (const struct d__ResolveType *)ptr, NULL);
	case SOAP_TYPE__d__Hello:
		return soap_out__d__Hello(soap, "d:Hello", id, (const struct d__HelloType *)ptr, NULL);
	case SOAP_TYPE__trt__Capabilities:
		return soap_out__trt__Capabilities(soap, "trt:Capabilities", id, (const struct trt__Capabilities *)ptr, NULL);
	case SOAP_TYPE__wsa__Action:
		return soap_out__wsa__Action(soap, "wsa:Action", id, (const struct wsa__AttributedURIType *)ptr, NULL);
	case SOAP_TYPE__wsa__To:
		return soap_out__wsa__To(soap, "wsa:To", id, (const struct wsa__AttributedURIType *)ptr, NULL);
	case SOAP_TYPE__wsa__FaultTo:
		return soap_out__wsa__FaultTo(soap, "wsa:FaultTo", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__From:
		return soap_out__wsa__From(soap, "wsa:From", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__ReplyTo:
		return soap_out__wsa__ReplyTo(soap, "wsa:ReplyTo", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__RelatesTo:
		return soap_out__wsa__RelatesTo(soap, "wsa:RelatesTo", id, (const struct wsa__RelatesToType *)ptr, NULL);
	case SOAP_TYPE__wsa__MessageID:
		return soap_out__wsa__MessageID(soap, "wsa:MessageID", id, (const struct wsa__AttributedURIType *)ptr, NULL);
	case SOAP_TYPE__wsa__Metadata:
		return soap_out__wsa__Metadata(soap, "wsa:Metadata", id, (const struct wsa__MetadataType *)ptr, NULL);
	case SOAP_TYPE__wsa__EndpointReference:
		return soap_out__wsa__EndpointReference(soap, "wsa:EndpointReference", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__tt__AudioEncoderConfiguration:
		return soap_out__tt__AudioEncoderConfiguration(soap, "tt:AudioEncoderConfiguration", id, (const struct tt__AudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__tt__VideoEncoderConfiguration:
		return soap_out__tt__VideoEncoderConfiguration(soap, "tt:VideoEncoderConfiguration", id, (const struct tt__VideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__tt__AudioSourceConfiguration:
		return soap_out__tt__AudioSourceConfiguration(soap, "tt:AudioSourceConfiguration", id, (const struct tt__AudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__tt__VideoSourceConfiguration:
		return soap_out__tt__VideoSourceConfiguration(soap, "tt:VideoSourceConfiguration", id, (const struct tt__VideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__wsadis__FaultTo:
		return soap_out__wsadis__FaultTo(soap, "wsadis:FaultTo", id, (const struct wsadis__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsadis__ReplyTo:
		return soap_out__wsadis__ReplyTo(soap, "wsadis:ReplyTo", id, (const struct wsadis__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsadis__From:
		return soap_out__wsadis__From(soap, "wsadis:From", id, (const struct wsadis__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsadis__Action:
		return soap_out__wsadis__Action(soap, "wsadis:Action", id, (const struct wsadis__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsadis__To:
		return soap_out__wsadis__To(soap, "wsadis:To", id, (const struct wsadis__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsadis__RelatesTo:
		return soap_out__wsadis__RelatesTo(soap, "wsadis:RelatesTo", id, (const struct wsadis__Relationship *)ptr, NULL);
	case SOAP_TYPE__wsadis__MessageID:
		return soap_out__wsadis__MessageID(soap, "wsadis:MessageID", id, (const struct wsadis__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsadis__EndpointReference:
		return soap_out__wsadis__EndpointReference(soap, "wsadis:EndpointReference", id, (const struct wsadis__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE_wsu__TimestampType:
		return soap_out_wsu__TimestampType(soap, tag, id, (const struct wsu__TimestampType *)ptr, "wsu:TimestampType");
	case SOAP_TYPE_wsse__SecurityHeaderType:
		return soap_out_wsse__SecurityHeaderType(soap, tag, id, (const struct wsse__SecurityHeaderType *)ptr, "wsse:SecurityHeaderType");
	case SOAP_TYPE_wsse__UsernameTokenType:
		return soap_out_wsse__UsernameTokenType(soap, tag, id, (const struct wsse__UsernameTokenType *)ptr, "wsse:UsernameTokenType");
	case SOAP_TYPE_wsse__PasswordString:
		return soap_out_wsse__PasswordString(soap, tag, id, (const struct wsse__PasswordString *)ptr, "wsse:PasswordString");
	case SOAP_TYPE_d__AppSequenceType:
		return soap_out_d__AppSequenceType(soap, tag, id, (const struct d__AppSequenceType *)ptr, "d:AppSequenceType");
	case SOAP_TYPE_d__ScopesType:
		return soap_out_d__ScopesType(soap, tag, id, (const struct d__ScopesType *)ptr, "d:ScopesType");
	case SOAP_TYPE_d__ResolveType:
		return soap_out_d__ResolveType(soap, tag, id, (const struct d__ResolveType *)ptr, "d:ResolveType");
	case SOAP_TYPE_d__ProbeMatchType:
		return soap_out_d__ProbeMatchType(soap, tag, id, (const struct d__ProbeMatchType *)ptr, "d:ProbeMatchType");
	case SOAP_TYPE_d__ProbeMatchesType:
		return soap_out_d__ProbeMatchesType(soap, tag, id, (const struct d__ProbeMatchesType *)ptr, "d:ProbeMatchesType");
	case SOAP_TYPE_d__ProbeType:
		return soap_out_d__ProbeType(soap, tag, id, (const struct d__ProbeType *)ptr, "d:ProbeType");
	case SOAP_TYPE_d__ByeType:
		return soap_out_d__ByeType(soap, tag, id, (const struct d__ByeType *)ptr, "d:ByeType");
	case SOAP_TYPE_d__HelloType:
		return soap_out_d__HelloType(soap, tag, id, (const struct d__HelloType *)ptr, "d:HelloType");
	case SOAP_TYPE__trt__GetSnapshotUriResponse:
		return soap_out__trt__GetSnapshotUriResponse(soap, "trt:GetSnapshotUriResponse", id, (const struct _trt__GetSnapshotUriResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetSnapshotUri:
		return soap_out__trt__GetSnapshotUri(soap, "trt:GetSnapshotUri", id, (const struct _trt__GetSnapshotUri *)ptr, NULL);
	case SOAP_TYPE__trt__GetStreamUriResponse:
		return soap_out__trt__GetStreamUriResponse(soap, "trt:GetStreamUriResponse", id, (const struct _trt__GetStreamUriResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetStreamUri:
		return soap_out__trt__GetStreamUri(soap, "trt:GetStreamUri", id, (const struct _trt__GetStreamUri *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse:
		return soap_out__trt__GetAudioEncoderConfigurationOptionsResponse(soap, "trt:GetAudioEncoderConfigurationOptionsResponse", id, (const struct _trt__GetAudioEncoderConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions:
		return soap_out__trt__GetAudioEncoderConfigurationOptions(soap, "trt:GetAudioEncoderConfigurationOptions", id, (const struct _trt__GetAudioEncoderConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse:
		return soap_out__trt__GetAudioSourceConfigurationOptionsResponse(soap, "trt:GetAudioSourceConfigurationOptionsResponse", id, (const struct _trt__GetAudioSourceConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurationOptions:
		return soap_out__trt__GetAudioSourceConfigurationOptions(soap, "trt:GetAudioSourceConfigurationOptions", id, (const struct _trt__GetAudioSourceConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse:
		return soap_out__trt__GetVideoEncoderConfigurationOptionsResponse(soap, "trt:GetVideoEncoderConfigurationOptionsResponse", id, (const struct _trt__GetVideoEncoderConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions:
		return soap_out__trt__GetVideoEncoderConfigurationOptions(soap, "trt:GetVideoEncoderConfigurationOptions", id, (const struct _trt__GetVideoEncoderConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse:
		return soap_out__trt__GetVideoSourceConfigurationOptionsResponse(soap, "trt:GetVideoSourceConfigurationOptionsResponse", id, (const struct _trt__GetVideoSourceConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurationOptions:
		return soap_out__trt__GetVideoSourceConfigurationOptions(soap, "trt:GetVideoSourceConfigurationOptions", id, (const struct _trt__GetVideoSourceConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__SetAudioSourceConfigurationResponse:
		return soap_out__trt__SetAudioSourceConfigurationResponse(soap, "trt:SetAudioSourceConfigurationResponse", id, (const struct _trt__SetAudioSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetAudioSourceConfiguration:
		return soap_out__trt__SetAudioSourceConfiguration(soap, "trt:SetAudioSourceConfiguration", id, (const struct _trt__SetAudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse:
		return soap_out__trt__SetAudioEncoderConfigurationResponse(soap, "trt:SetAudioEncoderConfigurationResponse", id, (const struct _trt__SetAudioEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetAudioEncoderConfiguration:
		return soap_out__trt__SetAudioEncoderConfiguration(soap, "trt:SetAudioEncoderConfiguration", id, (const struct _trt__SetAudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__SetVideoSourceConfigurationResponse:
		return soap_out__trt__SetVideoSourceConfigurationResponse(soap, "trt:SetVideoSourceConfigurationResponse", id, (const struct _trt__SetVideoSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetVideoSourceConfiguration:
		return soap_out__trt__SetVideoSourceConfiguration(soap, "trt:SetVideoSourceConfiguration", id, (const struct _trt__SetVideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse:
		return soap_out__trt__SetVideoEncoderConfigurationResponse(soap, "trt:SetVideoEncoderConfigurationResponse", id, (const struct _trt__SetVideoEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetVideoEncoderConfiguration:
		return soap_out__trt__SetVideoEncoderConfiguration(soap, "trt:SetVideoEncoderConfiguration", id, (const struct _trt__SetVideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse:
		return soap_out__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, "trt:GetCompatibleAudioSourceConfigurationsResponse", id, (const struct _trt__GetCompatibleAudioSourceConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations:
		return soap_out__trt__GetCompatibleAudioSourceConfigurations(soap, "trt:GetCompatibleAudioSourceConfigurations", id, (const struct _trt__GetCompatibleAudioSourceConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse:
		return soap_out__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, "trt:GetCompatibleAudioEncoderConfigurationsResponse", id, (const struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations:
		return soap_out__trt__GetCompatibleAudioEncoderConfigurations(soap, "trt:GetCompatibleAudioEncoderConfigurations", id, (const struct _trt__GetCompatibleAudioEncoderConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse:
		return soap_out__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, "trt:GetCompatibleVideoSourceConfigurationsResponse", id, (const struct _trt__GetCompatibleVideoSourceConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations:
		return soap_out__trt__GetCompatibleVideoSourceConfigurations(soap, "trt:GetCompatibleVideoSourceConfigurations", id, (const struct _trt__GetCompatibleVideoSourceConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse:
		return soap_out__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, "trt:GetCompatibleVideoEncoderConfigurationsResponse", id, (const struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations:
		return soap_out__trt__GetCompatibleVideoEncoderConfigurations(soap, "trt:GetCompatibleVideoEncoderConfigurations", id, (const struct _trt__GetCompatibleVideoEncoderConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse:
		return soap_out__trt__GetAudioEncoderConfigurationResponse(soap, "trt:GetAudioEncoderConfigurationResponse", id, (const struct _trt__GetAudioEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfiguration:
		return soap_out__trt__GetAudioEncoderConfiguration(soap, "trt:GetAudioEncoderConfiguration", id, (const struct _trt__GetAudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurationResponse:
		return soap_out__trt__GetAudioSourceConfigurationResponse(soap, "trt:GetAudioSourceConfigurationResponse", id, (const struct _trt__GetAudioSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfiguration:
		return soap_out__trt__GetAudioSourceConfiguration(soap, "trt:GetAudioSourceConfiguration", id, (const struct _trt__GetAudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse:
		return soap_out__trt__GetVideoEncoderConfigurationResponse(soap, "trt:GetVideoEncoderConfigurationResponse", id, (const struct _trt__GetVideoEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfiguration:
		return soap_out__trt__GetVideoEncoderConfiguration(soap, "trt:GetVideoEncoderConfiguration", id, (const struct _trt__GetVideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurationResponse:
		return soap_out__trt__GetVideoSourceConfigurationResponse(soap, "trt:GetVideoSourceConfigurationResponse", id, (const struct _trt__GetVideoSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfiguration:
		return soap_out__trt__GetVideoSourceConfiguration(soap, "trt:GetVideoSourceConfiguration", id, (const struct _trt__GetVideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse:
		return soap_out__trt__GetAudioSourceConfigurationsResponse(soap, "trt:GetAudioSourceConfigurationsResponse", id, (const struct _trt__GetAudioSourceConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurations:
		return soap_out__trt__GetAudioSourceConfigurations(soap, "trt:GetAudioSourceConfigurations", id, (const struct _trt__GetAudioSourceConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse:
		return soap_out__trt__GetAudioEncoderConfigurationsResponse(soap, "trt:GetAudioEncoderConfigurationsResponse", id, (const struct _trt__GetAudioEncoderConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurations:
		return soap_out__trt__GetAudioEncoderConfigurations(soap, "trt:GetAudioEncoderConfigurations", id, (const struct _trt__GetAudioEncoderConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse:
		return soap_out__trt__GetVideoSourceConfigurationsResponse(soap, "trt:GetVideoSourceConfigurationsResponse", id, (const struct _trt__GetVideoSourceConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurations:
		return soap_out__trt__GetVideoSourceConfigurations(soap, "trt:GetVideoSourceConfigurations", id, (const struct _trt__GetVideoSourceConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse:
		return soap_out__trt__GetVideoEncoderConfigurationsResponse(soap, "trt:GetVideoEncoderConfigurationsResponse", id, (const struct _trt__GetVideoEncoderConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurations:
		return soap_out__trt__GetVideoEncoderConfigurations(soap, "trt:GetVideoEncoderConfigurations", id, (const struct _trt__GetVideoEncoderConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__DeleteProfileResponse:
		return soap_out__trt__DeleteProfileResponse(soap, "trt:DeleteProfileResponse", id, (const struct _trt__DeleteProfileResponse *)ptr, NULL);
	case SOAP_TYPE__trt__DeleteProfile:
		return soap_out__trt__DeleteProfile(soap, "trt:DeleteProfile", id, (const struct _trt__DeleteProfile *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse:
		return soap_out__trt__RemoveAudioSourceConfigurationResponse(soap, "trt:RemoveAudioSourceConfigurationResponse", id, (const struct _trt__RemoveAudioSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveAudioSourceConfiguration:
		return soap_out__trt__RemoveAudioSourceConfiguration(soap, "trt:RemoveAudioSourceConfiguration", id, (const struct _trt__RemoveAudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddAudioSourceConfigurationResponse:
		return soap_out__trt__AddAudioSourceConfigurationResponse(soap, "trt:AddAudioSourceConfigurationResponse", id, (const struct _trt__AddAudioSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddAudioSourceConfiguration:
		return soap_out__trt__AddAudioSourceConfiguration(soap, "trt:AddAudioSourceConfiguration", id, (const struct _trt__AddAudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse:
		return soap_out__trt__RemoveAudioEncoderConfigurationResponse(soap, "trt:RemoveAudioEncoderConfigurationResponse", id, (const struct _trt__RemoveAudioEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveAudioEncoderConfiguration:
		return soap_out__trt__RemoveAudioEncoderConfiguration(soap, "trt:RemoveAudioEncoderConfiguration", id, (const struct _trt__RemoveAudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse:
		return soap_out__trt__AddAudioEncoderConfigurationResponse(soap, "trt:AddAudioEncoderConfigurationResponse", id, (const struct _trt__AddAudioEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddAudioEncoderConfiguration:
		return soap_out__trt__AddAudioEncoderConfiguration(soap, "trt:AddAudioEncoderConfiguration", id, (const struct _trt__AddAudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse:
		return soap_out__trt__RemoveVideoSourceConfigurationResponse(soap, "trt:RemoveVideoSourceConfigurationResponse", id, (const struct _trt__RemoveVideoSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveVideoSourceConfiguration:
		return soap_out__trt__RemoveVideoSourceConfiguration(soap, "trt:RemoveVideoSourceConfiguration", id, (const struct _trt__RemoveVideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddVideoSourceConfigurationResponse:
		return soap_out__trt__AddVideoSourceConfigurationResponse(soap, "trt:AddVideoSourceConfigurationResponse", id, (const struct _trt__AddVideoSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddVideoSourceConfiguration:
		return soap_out__trt__AddVideoSourceConfiguration(soap, "trt:AddVideoSourceConfiguration", id, (const struct _trt__AddVideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse:
		return soap_out__trt__RemoveVideoEncoderConfigurationResponse(soap, "trt:RemoveVideoEncoderConfigurationResponse", id, (const struct _trt__RemoveVideoEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveVideoEncoderConfiguration:
		return soap_out__trt__RemoveVideoEncoderConfiguration(soap, "trt:RemoveVideoEncoderConfiguration", id, (const struct _trt__RemoveVideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse:
		return soap_out__trt__AddVideoEncoderConfigurationResponse(soap, "trt:AddVideoEncoderConfigurationResponse", id, (const struct _trt__AddVideoEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddVideoEncoderConfiguration:
		return soap_out__trt__AddVideoEncoderConfiguration(soap, "trt:AddVideoEncoderConfiguration", id, (const struct _trt__AddVideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetProfilesResponse:
		return soap_out__trt__GetProfilesResponse(soap, "trt:GetProfilesResponse", id, (const struct _trt__GetProfilesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetProfiles:
		return soap_out__trt__GetProfiles(soap, "trt:GetProfiles", id, (const struct _trt__GetProfiles *)ptr, NULL);
	case SOAP_TYPE__trt__GetProfileResponse:
		return soap_out__trt__GetProfileResponse(soap, "trt:GetProfileResponse", id, (const struct _trt__GetProfileResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetProfile:
		return soap_out__trt__GetProfile(soap, "trt:GetProfile", id, (const struct _trt__GetProfile *)ptr, NULL);
	case SOAP_TYPE__trt__CreateProfileResponse:
		return soap_out__trt__CreateProfileResponse(soap, "trt:CreateProfileResponse", id, (const struct _trt__CreateProfileResponse *)ptr, NULL);
	case SOAP_TYPE__trt__CreateProfile:
		return soap_out__trt__CreateProfile(soap, "trt:CreateProfile", id, (const struct _trt__CreateProfile *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourcesResponse:
		return soap_out__trt__GetAudioSourcesResponse(soap, "trt:GetAudioSourcesResponse", id, (const struct _trt__GetAudioSourcesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSources:
		return soap_out__trt__GetAudioSources(soap, "trt:GetAudioSources", id, (const struct _trt__GetAudioSources *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourcesResponse:
		return soap_out__trt__GetVideoSourcesResponse(soap, "trt:GetVideoSourcesResponse", id, (const struct _trt__GetVideoSourcesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSources:
		return soap_out__trt__GetVideoSources(soap, "trt:GetVideoSources", id, (const struct _trt__GetVideoSources *)ptr, NULL);
	case SOAP_TYPE__trt__GetServiceCapabilitiesResponse:
		return soap_out__trt__GetServiceCapabilitiesResponse(soap, "trt:GetServiceCapabilitiesResponse", id, (const struct _trt__GetServiceCapabilitiesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetServiceCapabilities:
		return soap_out__trt__GetServiceCapabilities(soap, "trt:GetServiceCapabilities", id, (const struct _trt__GetServiceCapabilities *)ptr, NULL);
	case SOAP_TYPE_trt__StreamingCapabilities:
		return soap_out_trt__StreamingCapabilities(soap, tag, id, (const struct trt__StreamingCapabilities *)ptr, "trt:StreamingCapabilities");
	case SOAP_TYPE_trt__ProfileCapabilities:
		return soap_out_trt__ProfileCapabilities(soap, tag, id, (const struct trt__ProfileCapabilities *)ptr, "trt:ProfileCapabilities");
	case SOAP_TYPE_trt__Capabilities:
		return soap_out_trt__Capabilities(soap, tag, id, (const struct trt__Capabilities *)ptr, "trt:Capabilities");
	case SOAP_TYPE_wsa__AttributedURIType:
		return soap_out_wsa__AttributedURIType(soap, tag, id, (const struct wsa__AttributedURIType *)ptr, "wsa:AttributedURIType");
	case SOAP_TYPE_wsa__RelatesToType:
		return soap_out_wsa__RelatesToType(soap, tag, id, (const struct wsa__RelatesToType *)ptr, "wsa:RelatesToType");
	case SOAP_TYPE_wsa__MetadataType:
		return soap_out_wsa__MetadataType(soap, tag, id, (const struct wsa__MetadataType *)ptr, "wsa:MetadataType");
	case SOAP_TYPE_wsa__ReferenceParametersType:
		return soap_out_wsa__ReferenceParametersType(soap, tag, id, (const struct wsa__ReferenceParametersType *)ptr, "wsa:ReferenceParametersType");
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return soap_out_wsa__EndpointReferenceType(soap, tag, id, (const struct wsa__EndpointReferenceType *)ptr, "wsa:EndpointReferenceType");
	case SOAP_TYPE_tt__Rectangle:
		return soap_out_tt__Rectangle(soap, tag, id, (const struct tt__Rectangle *)ptr, "tt:Rectangle");
	case SOAP_TYPE_tt__WhiteBalance:
		return soap_out_tt__WhiteBalance(soap, tag, id, (const struct tt__WhiteBalance *)ptr, "tt:WhiteBalance");
	case SOAP_TYPE_tt__WhiteBalanceOptions:
		return soap_out_tt__WhiteBalanceOptions(soap, tag, id, (const struct tt__WhiteBalanceOptions *)ptr, "tt:WhiteBalanceOptions");
	case SOAP_TYPE_tt__ExposureOptions:
		return soap_out_tt__ExposureOptions(soap, tag, id, (const struct tt__ExposureOptions *)ptr, "tt:ExposureOptions");
	case SOAP_TYPE_tt__FocusOptions:
		return soap_out_tt__FocusOptions(soap, tag, id, (const struct tt__FocusOptions *)ptr, "tt:FocusOptions");
	case SOAP_TYPE_tt__BacklightCompensationOptions:
		return soap_out_tt__BacklightCompensationOptions(soap, tag, id, (const struct tt__BacklightCompensationOptions *)ptr, "tt:BacklightCompensationOptions");
	case SOAP_TYPE_tt__WideDynamicRangeOptions:
		return soap_out_tt__WideDynamicRangeOptions(soap, tag, id, (const struct tt__WideDynamicRangeOptions *)ptr, "tt:WideDynamicRangeOptions");
	case SOAP_TYPE_tt__ImagingOptions:
		return soap_out_tt__ImagingOptions(soap, tag, id, (const struct tt__ImagingOptions *)ptr, "tt:ImagingOptions");
	case SOAP_TYPE_tt__BacklightCompensation:
		return soap_out_tt__BacklightCompensation(soap, tag, id, (const struct tt__BacklightCompensation *)ptr, "tt:BacklightCompensation");
	case SOAP_TYPE_tt__WideDynamicRange:
		return soap_out_tt__WideDynamicRange(soap, tag, id, (const struct tt__WideDynamicRange *)ptr, "tt:WideDynamicRange");
	case SOAP_TYPE_tt__Exposure:
		return soap_out_tt__Exposure(soap, tag, id, (const struct tt__Exposure *)ptr, "tt:Exposure");
	case SOAP_TYPE_tt__ImagingSettings:
		return soap_out_tt__ImagingSettings(soap, tag, id, (const struct tt__ImagingSettings *)ptr, "tt:ImagingSettings");
	case SOAP_TYPE_tt__FocusConfiguration:
		return soap_out_tt__FocusConfiguration(soap, tag, id, (const struct tt__FocusConfiguration *)ptr, "tt:FocusConfiguration");
	case SOAP_TYPE_tt__User:
		return soap_out_tt__User(soap, tag, id, (const struct tt__User *)ptr, "tt:User");
	case SOAP_TYPE_tt__TimeZone:
		return soap_out_tt__TimeZone(soap, tag, id, (const struct tt__TimeZone *)ptr, "tt:TimeZone");
	case SOAP_TYPE_tt__Time:
		return soap_out_tt__Time(soap, tag, id, (const struct tt__Time *)ptr, "tt:Time");
	case SOAP_TYPE_tt__Date:
		return soap_out_tt__Date(soap, tag, id, (const struct tt__Date *)ptr, "tt:Date");
	case SOAP_TYPE_tt__DateTime:
		return soap_out_tt__DateTime(soap, tag, id, (const struct tt__DateTime *)ptr, "tt:DateTime");
	case SOAP_TYPE_tt__SystemDateTime:
		return soap_out_tt__SystemDateTime(soap, tag, id, (const struct tt__SystemDateTime *)ptr, "tt:SystemDateTime");
	case SOAP_TYPE_tt__AnalyticsDeviceCapabilities:
		return soap_out_tt__AnalyticsDeviceCapabilities(soap, tag, id, (const struct tt__AnalyticsDeviceCapabilities *)ptr, "tt:AnalyticsDeviceCapabilities");
	case SOAP_TYPE_tt__ReceiverCapabilities:
		return soap_out_tt__ReceiverCapabilities(soap, tag, id, (const struct tt__ReceiverCapabilities *)ptr, "tt:ReceiverCapabilities");
	case SOAP_TYPE_tt__ReplayCapabilities:
		return soap_out_tt__ReplayCapabilities(soap, tag, id, (const struct tt__ReplayCapabilities *)ptr, "tt:ReplayCapabilities");
	case SOAP_TYPE_tt__SearchCapabilities:
		return soap_out_tt__SearchCapabilities(soap, tag, id, (const struct tt__SearchCapabilities *)ptr, "tt:SearchCapabilities");
	case SOAP_TYPE_tt__RecordingCapabilities:
		return soap_out_tt__RecordingCapabilities(soap, tag, id, (const struct tt__RecordingCapabilities *)ptr, "tt:RecordingCapabilities");
	case SOAP_TYPE_tt__DisplayCapabilities:
		return soap_out_tt__DisplayCapabilities(soap, tag, id, (const struct tt__DisplayCapabilities *)ptr, "tt:DisplayCapabilities");
	case SOAP_TYPE_tt__DeviceIOCapabilities:
		return soap_out_tt__DeviceIOCapabilities(soap, tag, id, (const struct tt__DeviceIOCapabilities *)ptr, "tt:DeviceIOCapabilities");
	case SOAP_TYPE_tt__PTZCapabilities:
		return soap_out_tt__PTZCapabilities(soap, tag, id, (const struct tt__PTZCapabilities *)ptr, "tt:PTZCapabilities");
	case SOAP_TYPE_tt__ImagingCapabilities:
		return soap_out_tt__ImagingCapabilities(soap, tag, id, (const struct tt__ImagingCapabilities *)ptr, "tt:ImagingCapabilities");
	case SOAP_TYPE_tt__OnvifVersion:
		return soap_out_tt__OnvifVersion(soap, tag, id, (const struct tt__OnvifVersion *)ptr, "tt:OnvifVersion");
	case SOAP_TYPE_tt__SystemCapabilities:
		return soap_out_tt__SystemCapabilities(soap, tag, id, (const struct tt__SystemCapabilities *)ptr, "tt:SystemCapabilities");
	case SOAP_TYPE_tt__SecurityCapabilities:
		return soap_out_tt__SecurityCapabilities(soap, tag, id, (const struct tt__SecurityCapabilities *)ptr, "tt:SecurityCapabilities");
	case SOAP_TYPE_tt__NetworkCapabilities:
		return soap_out_tt__NetworkCapabilities(soap, tag, id, (const struct tt__NetworkCapabilities *)ptr, "tt:NetworkCapabilities");
	case SOAP_TYPE_tt__ProfileCapabilities:
		return soap_out_tt__ProfileCapabilities(soap, tag, id, (const struct tt__ProfileCapabilities *)ptr, "tt:ProfileCapabilities");
	case SOAP_TYPE_tt__RealTimeStreamingCapabilities:
		return soap_out_tt__RealTimeStreamingCapabilities(soap, tag, id, (const struct tt__RealTimeStreamingCapabilities *)ptr, "tt:RealTimeStreamingCapabilities");
	case SOAP_TYPE_tt__MediaCapabilities:
		return soap_out_tt__MediaCapabilities(soap, tag, id, (const struct tt__MediaCapabilities *)ptr, "tt:MediaCapabilities");
	case SOAP_TYPE_tt__IOCapabilities:
		return soap_out_tt__IOCapabilities(soap, tag, id, (const struct tt__IOCapabilities *)ptr, "tt:IOCapabilities");
	case SOAP_TYPE_tt__EventCapabilities:
		return soap_out_tt__EventCapabilities(soap, tag, id, (const struct tt__EventCapabilities *)ptr, "tt:EventCapabilities");
	case SOAP_TYPE_tt__DeviceCapabilities:
		return soap_out_tt__DeviceCapabilities(soap, tag, id, (const struct tt__DeviceCapabilities *)ptr, "tt:DeviceCapabilities");
	case SOAP_TYPE_tt__AnalyticsCapabilities:
		return soap_out_tt__AnalyticsCapabilities(soap, tag, id, (const struct tt__AnalyticsCapabilities *)ptr, "tt:AnalyticsCapabilities");
	case SOAP_TYPE_tt__CapabilitiesExtension:
		return soap_out_tt__CapabilitiesExtension(soap, tag, id, (const struct tt__CapabilitiesExtension *)ptr, "tt:CapabilitiesExtension");
	case SOAP_TYPE_tt__Capabilities:
		return soap_out_tt__Capabilities(soap, tag, id, (const struct tt__Capabilities *)ptr, "tt:Capabilities");
	case SOAP_TYPE_tt__NetworkZeroConfiguration:
		return soap_out_tt__NetworkZeroConfiguration(soap, tag, id, (const struct tt__NetworkZeroConfiguration *)ptr, "tt:NetworkZeroConfiguration");
	case SOAP_TYPE_tt__NetworkGateway:
		return soap_out_tt__NetworkGateway(soap, tag, id, (const struct tt__NetworkGateway *)ptr, "tt:NetworkGateway");
	case SOAP_TYPE_tt__IPv4NetworkInterfaceSetConfiguration:
		return soap_out_tt__IPv4NetworkInterfaceSetConfiguration(soap, tag, id, (const struct tt__IPv4NetworkInterfaceSetConfiguration *)ptr, "tt:IPv4NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_tt__NetworkInterfaceSetConfigurationExtension:
		return soap_out_tt__NetworkInterfaceSetConfigurationExtension(soap, tag, id, (const struct tt__NetworkInterfaceSetConfigurationExtension *)ptr, "tt:NetworkInterfaceSetConfigurationExtension");
	case SOAP_TYPE_tt__NetworkInterfaceSetConfiguration:
		return soap_out_tt__NetworkInterfaceSetConfiguration(soap, tag, id, (const struct tt__NetworkInterfaceSetConfiguration *)ptr, "tt:NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_tt__DynamicDNSInformation:
		return soap_out_tt__DynamicDNSInformation(soap, tag, id, (const struct tt__DynamicDNSInformation *)ptr, "tt:DynamicDNSInformation");
	case SOAP_TYPE_tt__NTPInformation:
		return soap_out_tt__NTPInformation(soap, tag, id, (const struct tt__NTPInformation *)ptr, "tt:NTPInformation");
	case SOAP_TYPE_tt__DNSInformation:
		return soap_out_tt__DNSInformation(soap, tag, id, (const struct tt__DNSInformation *)ptr, "tt:DNSInformation");
	case SOAP_TYPE_tt__HostnameInformation:
		return soap_out_tt__HostnameInformation(soap, tag, id, (const struct tt__HostnameInformation *)ptr, "tt:HostnameInformation");
	case SOAP_TYPE_tt__PrefixedIPv4Address:
		return soap_out_tt__PrefixedIPv4Address(soap, tag, id, (const struct tt__PrefixedIPv4Address *)ptr, "tt:PrefixedIPv4Address");
	case SOAP_TYPE_tt__IPAddress:
		return soap_out_tt__IPAddress(soap, tag, id, (const struct tt__IPAddress *)ptr, "tt:IPAddress");
	case SOAP_TYPE_tt__NetworkHost:
		return soap_out_tt__NetworkHost(soap, tag, id, (const struct tt__NetworkHost *)ptr, "tt:NetworkHost");
	case SOAP_TYPE_tt__NetworkProtocol:
		return soap_out_tt__NetworkProtocol(soap, tag, id, (const struct tt__NetworkProtocol *)ptr, "tt:NetworkProtocol");
	case SOAP_TYPE_tt__IPv4Configuration:
		return soap_out_tt__IPv4Configuration(soap, tag, id, (const struct tt__IPv4Configuration *)ptr, "tt:IPv4Configuration");
	case SOAP_TYPE_tt__IPv4NetworkInterface:
		return soap_out_tt__IPv4NetworkInterface(soap, tag, id, (const struct tt__IPv4NetworkInterface *)ptr, "tt:IPv4NetworkInterface");
	case SOAP_TYPE_tt__NetworkInterfaceInfo:
		return soap_out_tt__NetworkInterfaceInfo(soap, tag, id, (const struct tt__NetworkInterfaceInfo *)ptr, "tt:NetworkInterfaceInfo");
	case SOAP_TYPE_tt__NetworkInterfaceConnectionSetting:
		return soap_out_tt__NetworkInterfaceConnectionSetting(soap, tag, id, (const struct tt__NetworkInterfaceConnectionSetting *)ptr, "tt:NetworkInterfaceConnectionSetting");
	case SOAP_TYPE_tt__NetworkInterfaceLink:
		return soap_out_tt__NetworkInterfaceLink(soap, tag, id, (const struct tt__NetworkInterfaceLink *)ptr, "tt:NetworkInterfaceLink");
	case SOAP_TYPE_tt__NetworkInterfaceExtension2:
		return soap_out_tt__NetworkInterfaceExtension2(soap, tag, id, (const struct tt__NetworkInterfaceExtension2 *)ptr, "tt:NetworkInterfaceExtension2");
	case SOAP_TYPE_tt__Dot3Configuration:
		return soap_out_tt__Dot3Configuration(soap, tag, id, (const struct tt__Dot3Configuration *)ptr, "tt:Dot3Configuration");
	case SOAP_TYPE_tt__NetworkInterfaceExtension:
		return soap_out_tt__NetworkInterfaceExtension(soap, tag, id, (const struct tt__NetworkInterfaceExtension *)ptr, "tt:NetworkInterfaceExtension");
	case SOAP_TYPE_tt__NetworkInterface:
		return soap_out_tt__NetworkInterface(soap, tag, id, (const struct tt__NetworkInterface *)ptr, "tt:NetworkInterface");
	case SOAP_TYPE_tt__Scope:
		return soap_out_tt__Scope(soap, tag, id, (const struct tt__Scope *)ptr, "tt:Scope");
	case SOAP_TYPE_tt__MediaUri:
		return soap_out_tt__MediaUri(soap, tag, id, (const struct tt__MediaUri *)ptr, "tt:MediaUri");
	case SOAP_TYPE_tt__Transport:
		return soap_out_tt__Transport(soap, tag, id, (const struct tt__Transport *)ptr, "tt:Transport");
	case SOAP_TYPE_tt__StreamSetup:
		return soap_out_tt__StreamSetup(soap, tag, id, (const struct tt__StreamSetup *)ptr, "tt:StreamSetup");
	case SOAP_TYPE_tt__MulticastConfiguration:
		return soap_out_tt__MulticastConfiguration(soap, tag, id, (const struct tt__MulticastConfiguration *)ptr, "tt:MulticastConfiguration");
	case SOAP_TYPE_tt__AudioEncoderConfigurationOption:
		return soap_out_tt__AudioEncoderConfigurationOption(soap, tag, id, (const struct tt__AudioEncoderConfigurationOption *)ptr, "tt:AudioEncoderConfigurationOption");
	case SOAP_TYPE_tt__AudioEncoderConfigurationOptions:
		return soap_out_tt__AudioEncoderConfigurationOptions(soap, tag, id, (const struct tt__AudioEncoderConfigurationOptions *)ptr, "tt:AudioEncoderConfigurationOptions");
	case SOAP_TYPE_tt__AudioEncoderConfiguration:
		return soap_out_tt__AudioEncoderConfiguration(soap, tag, id, (const struct tt__AudioEncoderConfiguration *)ptr, "tt:AudioEncoderConfiguration");
	case SOAP_TYPE_tt__AudioSourceConfigurationOptions:
		return soap_out_tt__AudioSourceConfigurationOptions(soap, tag, id, (const struct tt__AudioSourceConfigurationOptions *)ptr, "tt:AudioSourceConfigurationOptions");
	case SOAP_TYPE_tt__AudioSourceConfiguration:
		return soap_out_tt__AudioSourceConfiguration(soap, tag, id, (const struct tt__AudioSourceConfiguration *)ptr, "tt:AudioSourceConfiguration");
	case SOAP_TYPE_tt__H264Options:
		return soap_out_tt__H264Options(soap, tag, id, (const struct tt__H264Options *)ptr, "tt:H264Options");
	case SOAP_TYPE_tt__Mpeg4Options:
		return soap_out_tt__Mpeg4Options(soap, tag, id, (const struct tt__Mpeg4Options *)ptr, "tt:Mpeg4Options");
	case SOAP_TYPE_tt__JpegOptions:
		return soap_out_tt__JpegOptions(soap, tag, id, (const struct tt__JpegOptions *)ptr, "tt:JpegOptions");
	case SOAP_TYPE_tt__VideoEncoderConfigurationOptions:
		return soap_out_tt__VideoEncoderConfigurationOptions(soap, tag, id, (const struct tt__VideoEncoderConfigurationOptions *)ptr, "tt:VideoEncoderConfigurationOptions");
	case SOAP_TYPE_tt__H264Configuration:
		return soap_out_tt__H264Configuration(soap, tag, id, (const struct tt__H264Configuration *)ptr, "tt:H264Configuration");
	case SOAP_TYPE_tt__Mpeg4Configuration:
		return soap_out_tt__Mpeg4Configuration(soap, tag, id, (const struct tt__Mpeg4Configuration *)ptr, "tt:Mpeg4Configuration");
	case SOAP_TYPE_tt__VideoRateControl:
		return soap_out_tt__VideoRateControl(soap, tag, id, (const struct tt__VideoRateControl *)ptr, "tt:VideoRateControl");
	case SOAP_TYPE_tt__VideoResolution:
		return soap_out_tt__VideoResolution(soap, tag, id, (const struct tt__VideoResolution *)ptr, "tt:VideoResolution");
	case SOAP_TYPE_tt__VideoEncoderConfiguration:
		return soap_out_tt__VideoEncoderConfiguration(soap, tag, id, (const struct tt__VideoEncoderConfiguration *)ptr, "tt:VideoEncoderConfiguration");
	case SOAP_TYPE_tt__VideoSourceConfigurationOptions:
		return soap_out_tt__VideoSourceConfigurationOptions(soap, tag, id, (const struct tt__VideoSourceConfigurationOptions *)ptr, "tt:VideoSourceConfigurationOptions");
	case SOAP_TYPE_tt__VideoSourceConfiguration:
		return soap_out_tt__VideoSourceConfiguration(soap, tag, id, (const struct tt__VideoSourceConfiguration *)ptr, "tt:VideoSourceConfiguration");
	case SOAP_TYPE_tt__ConfigurationEntity:
		return soap_out_tt__ConfigurationEntity(soap, tag, id, (const struct tt__ConfigurationEntity *)ptr, "tt:ConfigurationEntity");
	case SOAP_TYPE_tt__Profile:
		return soap_out_tt__Profile(soap, tag, id, (const struct tt__Profile *)ptr, "tt:Profile");
	case SOAP_TYPE_tt__AudioSource:
		return soap_out_tt__AudioSource(soap, tag, id, (const struct tt__AudioSource *)ptr, "tt:AudioSource");
	case SOAP_TYPE_tt__VideoSource:
		return soap_out_tt__VideoSource(soap, tag, id, (const struct tt__VideoSource *)ptr, "tt:VideoSource");
	case SOAP_TYPE_tt__IntList:
		return soap_out_tt__IntList(soap, tag, id, (const struct tt__IntList *)ptr, "tt:IntList");
	case SOAP_TYPE_tt__FloatRange:
		return soap_out_tt__FloatRange(soap, tag, id, (const struct tt__FloatRange *)ptr, "tt:FloatRange");
	case SOAP_TYPE_tt__IntRange:
		return soap_out_tt__IntRange(soap, tag, id, (const struct tt__IntRange *)ptr, "tt:IntRange");
	case SOAP_TYPE_tt__IntRectangleRange:
		return soap_out_tt__IntRectangleRange(soap, tag, id, (const struct tt__IntRectangleRange *)ptr, "tt:IntRectangleRange");
	case SOAP_TYPE_tt__IntRectangle:
		return soap_out_tt__IntRectangle(soap, tag, id, (const struct tt__IntRectangle *)ptr, "tt:IntRectangle");
	case SOAP_TYPE_tt__DeviceEntity:
		return soap_out_tt__DeviceEntity(soap, tag, id, (const struct tt__DeviceEntity *)ptr, "tt:DeviceEntity");
	case SOAP_TYPE__tds__SetZeroConfigurationResponse:
		return soap_out__tds__SetZeroConfigurationResponse(soap, "tds:SetZeroConfigurationResponse", id, (const struct _tds__SetZeroConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetZeroConfiguration:
		return soap_out__tds__SetZeroConfiguration(soap, "tds:SetZeroConfiguration", id, (const struct _tds__SetZeroConfiguration *)ptr, NULL);
	case SOAP_TYPE__tds__GetZeroConfigurationResponse:
		return soap_out__tds__GetZeroConfigurationResponse(soap, "tds:GetZeroConfigurationResponse", id, (const struct _tds__GetZeroConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetZeroConfiguration:
		return soap_out__tds__GetZeroConfiguration(soap, "tds:GetZeroConfiguration", id, (const struct _tds__GetZeroConfiguration *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkDefaultGatewayResponse:
		return soap_out__tds__SetNetworkDefaultGatewayResponse(soap, "tds:SetNetworkDefaultGatewayResponse", id, (const struct _tds__SetNetworkDefaultGatewayResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkDefaultGateway:
		return soap_out__tds__SetNetworkDefaultGateway(soap, "tds:SetNetworkDefaultGateway", id, (const struct _tds__SetNetworkDefaultGateway *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkDefaultGatewayResponse:
		return soap_out__tds__GetNetworkDefaultGatewayResponse(soap, "tds:GetNetworkDefaultGatewayResponse", id, (const struct _tds__GetNetworkDefaultGatewayResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkDefaultGateway:
		return soap_out__tds__GetNetworkDefaultGateway(soap, "tds:GetNetworkDefaultGateway", id, (const struct _tds__GetNetworkDefaultGateway *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkInterfacesResponse:
		return soap_out__tds__SetNetworkInterfacesResponse(soap, "tds:SetNetworkInterfacesResponse", id, (const struct _tds__SetNetworkInterfacesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkInterfaces:
		return soap_out__tds__SetNetworkInterfaces(soap, "tds:SetNetworkInterfaces", id, (const struct _tds__SetNetworkInterfaces *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkInterfacesResponse:
		return soap_out__tds__GetNetworkInterfacesResponse(soap, "tds:GetNetworkInterfacesResponse", id, (const struct _tds__GetNetworkInterfacesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkInterfaces:
		return soap_out__tds__GetNetworkInterfaces(soap, "tds:GetNetworkInterfaces", id, (const struct _tds__GetNetworkInterfaces *)ptr, NULL);
	case SOAP_TYPE__tds__SetDynamicDNSResponse:
		return soap_out__tds__SetDynamicDNSResponse(soap, "tds:SetDynamicDNSResponse", id, (const struct _tds__SetDynamicDNSResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetDynamicDNS:
		return soap_out__tds__SetDynamicDNS(soap, "tds:SetDynamicDNS", id, (const struct _tds__SetDynamicDNS *)ptr, NULL);
	case SOAP_TYPE__tds__GetDynamicDNSResponse:
		return soap_out__tds__GetDynamicDNSResponse(soap, "tds:GetDynamicDNSResponse", id, (const struct _tds__GetDynamicDNSResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetDynamicDNS:
		return soap_out__tds__GetDynamicDNS(soap, "tds:GetDynamicDNS", id, (const struct _tds__GetDynamicDNS *)ptr, NULL);
	case SOAP_TYPE__tds__SetNTPResponse:
		return soap_out__tds__SetNTPResponse(soap, "tds:SetNTPResponse", id, (const struct _tds__SetNTPResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetNTP:
		return soap_out__tds__SetNTP(soap, "tds:SetNTP", id, (const struct _tds__SetNTP *)ptr, NULL);
	case SOAP_TYPE__tds__GetNTPResponse:
		return soap_out__tds__GetNTPResponse(soap, "tds:GetNTPResponse", id, (const struct _tds__GetNTPResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetNTP:
		return soap_out__tds__GetNTP(soap, "tds:GetNTP", id, (const struct _tds__GetNTP *)ptr, NULL);
	case SOAP_TYPE__tds__SetDNSResponse:
		return soap_out__tds__SetDNSResponse(soap, "tds:SetDNSResponse", id, (const struct _tds__SetDNSResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetDNS:
		return soap_out__tds__SetDNS(soap, "tds:SetDNS", id, (const struct _tds__SetDNS *)ptr, NULL);
	case SOAP_TYPE__tds__GetDNSResponse:
		return soap_out__tds__GetDNSResponse(soap, "tds:GetDNSResponse", id, (const struct _tds__GetDNSResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetDNS:
		return soap_out__tds__GetDNS(soap, "tds:GetDNS", id, (const struct _tds__GetDNS *)ptr, NULL);
	case SOAP_TYPE__tds__SetHostnameResponse:
		return soap_out__tds__SetHostnameResponse(soap, "tds:SetHostnameResponse", id, (const struct _tds__SetHostnameResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetHostname:
		return soap_out__tds__SetHostname(soap, "tds:SetHostname", id, (const struct _tds__SetHostname *)ptr, NULL);
	case SOAP_TYPE__tds__GetHostnameResponse:
		return soap_out__tds__GetHostnameResponse(soap, "tds:GetHostnameResponse", id, (const struct _tds__GetHostnameResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetHostname:
		return soap_out__tds__GetHostname(soap, "tds:GetHostname", id, (const struct _tds__GetHostname *)ptr, NULL);
	case SOAP_TYPE__tds__GetCapabilitiesResponse:
		return soap_out__tds__GetCapabilitiesResponse(soap, "tds:GetCapabilitiesResponse", id, (const struct _tds__GetCapabilitiesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetCapabilities:
		return soap_out__tds__GetCapabilities(soap, "tds:GetCapabilities", id, (const struct _tds__GetCapabilities *)ptr, NULL);
	case SOAP_TYPE__tds__GetWsdlUrlResponse:
		return soap_out__tds__GetWsdlUrlResponse(soap, "tds:GetWsdlUrlResponse", id, (const struct _tds__GetWsdlUrlResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetWsdlUrl:
		return soap_out__tds__GetWsdlUrl(soap, "tds:GetWsdlUrl", id, (const struct _tds__GetWsdlUrl *)ptr, NULL);
	case SOAP_TYPE__tds__SetUserResponse:
		return soap_out__tds__SetUserResponse(soap, "tds:SetUserResponse", id, (const struct _tds__SetUserResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetUser:
		return soap_out__tds__SetUser(soap, "tds:SetUser", id, (const struct _tds__SetUser *)ptr, NULL);
	case SOAP_TYPE__tds__DeleteUsersResponse:
		return soap_out__tds__DeleteUsersResponse(soap, "tds:DeleteUsersResponse", id, (const struct _tds__DeleteUsersResponse *)ptr, NULL);
	case SOAP_TYPE__tds__DeleteUsers:
		return soap_out__tds__DeleteUsers(soap, "tds:DeleteUsers", id, (const struct _tds__DeleteUsers *)ptr, NULL);
	case SOAP_TYPE__tds__CreateUsersResponse:
		return soap_out__tds__CreateUsersResponse(soap, "tds:CreateUsersResponse", id, (const struct _tds__CreateUsersResponse *)ptr, NULL);
	case SOAP_TYPE__tds__CreateUsers:
		return soap_out__tds__CreateUsers(soap, "tds:CreateUsers", id, (const struct _tds__CreateUsers *)ptr, NULL);
	case SOAP_TYPE__tds__GetUsersResponse:
		return soap_out__tds__GetUsersResponse(soap, "tds:GetUsersResponse", id, (const struct _tds__GetUsersResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetUsers:
		return soap_out__tds__GetUsers(soap, "tds:GetUsers", id, (const struct _tds__GetUsers *)ptr, NULL);
	case SOAP_TYPE__tds__SetDiscoveryModeResponse:
		return soap_out__tds__SetDiscoveryModeResponse(soap, "tds:SetDiscoveryModeResponse", id, (const struct _tds__SetDiscoveryModeResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetDiscoveryMode:
		return soap_out__tds__SetDiscoveryMode(soap, "tds:SetDiscoveryMode", id, (const struct _tds__SetDiscoveryMode *)ptr, NULL);
	case SOAP_TYPE__tds__GetDiscoveryModeResponse:
		return soap_out__tds__GetDiscoveryModeResponse(soap, "tds:GetDiscoveryModeResponse", id, (const struct _tds__GetDiscoveryModeResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetDiscoveryMode:
		return soap_out__tds__GetDiscoveryMode(soap, "tds:GetDiscoveryMode", id, (const struct _tds__GetDiscoveryMode *)ptr, NULL);
	case SOAP_TYPE__tds__RemoveScopesResponse:
		return soap_out__tds__RemoveScopesResponse(soap, "tds:RemoveScopesResponse", id, (const struct _tds__RemoveScopesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__RemoveScopes:
		return soap_out__tds__RemoveScopes(soap, "tds:RemoveScopes", id, (const struct _tds__RemoveScopes *)ptr, NULL);
	case SOAP_TYPE__tds__AddScopesResponse:
		return soap_out__tds__AddScopesResponse(soap, "tds:AddScopesResponse", id, (const struct _tds__AddScopesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__AddScopes:
		return soap_out__tds__AddScopes(soap, "tds:AddScopes", id, (const struct _tds__AddScopes *)ptr, NULL);
	case SOAP_TYPE__tds__SetScopesResponse:
		return soap_out__tds__SetScopesResponse(soap, "tds:SetScopesResponse", id, (const struct _tds__SetScopesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetScopes:
		return soap_out__tds__SetScopes(soap, "tds:SetScopes", id, (const struct _tds__SetScopes *)ptr, NULL);
	case SOAP_TYPE__tds__GetScopesResponse:
		return soap_out__tds__GetScopesResponse(soap, "tds:GetScopesResponse", id, (const struct _tds__GetScopesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetScopes:
		return soap_out__tds__GetScopes(soap, "tds:GetScopes", id, (const struct _tds__GetScopes *)ptr, NULL);
	case SOAP_TYPE__tds__SystemRebootResponse:
		return soap_out__tds__SystemRebootResponse(soap, "tds:SystemRebootResponse", id, (const struct _tds__SystemRebootResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SystemReboot:
		return soap_out__tds__SystemReboot(soap, "tds:SystemReboot", id, (const struct _tds__SystemReboot *)ptr, NULL);
	case SOAP_TYPE__tds__SetSystemFactoryDefaultResponse:
		return soap_out__tds__SetSystemFactoryDefaultResponse(soap, "tds:SetSystemFactoryDefaultResponse", id, (const struct _tds__SetSystemFactoryDefaultResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetSystemFactoryDefault:
		return soap_out__tds__SetSystemFactoryDefault(soap, "tds:SetSystemFactoryDefault", id, (const struct _tds__SetSystemFactoryDefault *)ptr, NULL);
	case SOAP_TYPE__tds__GetSystemDateAndTimeResponse:
		return soap_out__tds__GetSystemDateAndTimeResponse(soap, "tds:GetSystemDateAndTimeResponse", id, (const struct _tds__GetSystemDateAndTimeResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetSystemDateAndTime:
		return soap_out__tds__GetSystemDateAndTime(soap, "tds:GetSystemDateAndTime", id, (const struct _tds__GetSystemDateAndTime *)ptr, NULL);
	case SOAP_TYPE__tds__SetSystemDateAndTimeResponse:
		return soap_out__tds__SetSystemDateAndTimeResponse(soap, "tds:SetSystemDateAndTimeResponse", id, (const struct _tds__SetSystemDateAndTimeResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetSystemDateAndTime:
		return soap_out__tds__SetSystemDateAndTime(soap, "tds:SetSystemDateAndTime", id, (const struct _tds__SetSystemDateAndTime *)ptr, NULL);
	case SOAP_TYPE__tds__GetDeviceInformationResponse:
		return soap_out__tds__GetDeviceInformationResponse(soap, "tds:GetDeviceInformationResponse", id, (const struct _tds__GetDeviceInformationResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetDeviceInformation:
		return soap_out__tds__GetDeviceInformation(soap, "tds:GetDeviceInformation", id, (const struct _tds__GetDeviceInformation *)ptr, NULL);
	case SOAP_TYPE_wsadis__AttributedURI:
		return soap_out_wsadis__AttributedURI(soap, tag, id, (const struct wsadis__AttributedURI *)ptr, "wsadis:AttributedURI");
	case SOAP_TYPE_wsadis__AttributedQName:
		return soap_out_wsadis__AttributedQName(soap, tag, id, (const struct wsadis__AttributedQName *)ptr, "wsadis:AttributedQName");
	case SOAP_TYPE_wsadis__Relationship:
		return soap_out_wsadis__Relationship(soap, tag, id, (const struct wsadis__Relationship *)ptr, "wsadis:Relationship");
	case SOAP_TYPE_wsadis__ServiceNameType:
		return soap_out_wsadis__ServiceNameType(soap, tag, id, (const struct wsadis__ServiceNameType *)ptr, "wsadis:ServiceNameType");
	case SOAP_TYPE_wsadis__ReferenceParametersType:
		return soap_out_wsadis__ReferenceParametersType(soap, tag, id, (const struct wsadis__ReferenceParametersType *)ptr, "wsadis:ReferenceParametersType");
	case SOAP_TYPE_wsadis__ReferencePropertiesType:
		return soap_out_wsadis__ReferencePropertiesType(soap, tag, id, (const struct wsadis__ReferencePropertiesType *)ptr, "wsadis:ReferencePropertiesType");
	case SOAP_TYPE_wsadis__EndpointReferenceType:
		return soap_out_wsadis__EndpointReferenceType(soap, tag, id, (const struct wsadis__EndpointReferenceType *)ptr, "wsadis:EndpointReferenceType");
	case SOAP_TYPE_PointerTo_wsse__Security:
		return soap_out_PointerTo_wsse__Security(soap, tag, id, (struct wsse__SecurityHeaderType *const*)ptr, "wsse:Security");
	case SOAP_TYPE_PointerTo_d__AppSequence:
		return soap_out_PointerTo_d__AppSequence(soap, tag, id, (struct d__AppSequenceType *const*)ptr, "d:AppSequence");
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		return soap_out_PointerTo_wsa__FaultTo(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:FaultTo");
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		return soap_out_PointerTo_wsa__ReplyTo(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa__From:
		return soap_out_PointerTo_wsa__From(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:From");
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		return soap_out_PointerTo_wsa__RelatesTo(soap, tag, id, (struct wsa__RelatesToType *const*)ptr, "wsa:RelatesTo");
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUriResponse:
		return soap_out_PointerTo_trt__GetSnapshotUriResponse(soap, tag, id, (struct _trt__GetSnapshotUriResponse *const*)ptr, "trt:GetSnapshotUriResponse");
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUri:
		return soap_out_PointerTo_trt__GetSnapshotUri(soap, tag, id, (struct _trt__GetSnapshotUri *const*)ptr, "trt:GetSnapshotUri");
	case SOAP_TYPE_PointerTo_trt__GetStreamUriResponse:
		return soap_out_PointerTo_trt__GetStreamUriResponse(soap, tag, id, (struct _trt__GetStreamUriResponse *const*)ptr, "trt:GetStreamUriResponse");
	case SOAP_TYPE_PointerTo_trt__GetStreamUri:
		return soap_out_PointerTo_trt__GetStreamUri(soap, tag, id, (struct _trt__GetStreamUri *const*)ptr, "trt:GetStreamUri");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetAudioEncoderConfigurationOptionsResponse *const*)ptr, "trt:GetAudioEncoderConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptions:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, tag, id, (struct _trt__GetAudioEncoderConfigurationOptions *const*)ptr, "trt:GetAudioEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetAudioSourceConfigurationOptionsResponse *const*)ptr, "trt:GetAudioSourceConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptions:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, tag, id, (struct _trt__GetAudioSourceConfigurationOptions *const*)ptr, "trt:GetAudioSourceConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetVideoEncoderConfigurationOptionsResponse *const*)ptr, "trt:GetVideoEncoderConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptions:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, tag, id, (struct _trt__GetVideoEncoderConfigurationOptions *const*)ptr, "trt:GetVideoEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetVideoSourceConfigurationOptionsResponse *const*)ptr, "trt:GetVideoSourceConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptions:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, tag, id, (struct _trt__GetVideoSourceConfigurationOptions *const*)ptr, "trt:GetVideoSourceConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__SetAudioEncoderConfigurationResponse(soap, tag, id, (struct _trt__SetAudioEncoderConfigurationResponse *const*)ptr, "trt:SetAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfiguration:
		return soap_out_PointerTo_trt__SetAudioEncoderConfiguration(soap, tag, id, (struct _trt__SetAudioEncoderConfiguration *const*)ptr, "trt:SetAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfigurationResponse:
		return soap_out_PointerTo_trt__SetAudioSourceConfigurationResponse(soap, tag, id, (struct _trt__SetAudioSourceConfigurationResponse *const*)ptr, "trt:SetAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfiguration:
		return soap_out_PointerTo_trt__SetAudioSourceConfiguration(soap, tag, id, (struct _trt__SetAudioSourceConfiguration *const*)ptr, "trt:SetAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__SetVideoEncoderConfigurationResponse(soap, tag, id, (struct _trt__SetVideoEncoderConfigurationResponse *const*)ptr, "trt:SetVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfiguration:
		return soap_out_PointerTo_trt__SetVideoEncoderConfiguration(soap, tag, id, (struct _trt__SetVideoEncoderConfiguration *const*)ptr, "trt:SetVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfigurationResponse:
		return soap_out_PointerTo_trt__SetVideoSourceConfigurationResponse(soap, tag, id, (struct _trt__SetVideoSourceConfigurationResponse *const*)ptr, "trt:SetVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfiguration:
		return soap_out_PointerTo_trt__SetVideoSourceConfiguration(soap, tag, id, (struct _trt__SetVideoSourceConfiguration *const*)ptr, "trt:SetVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleAudioSourceConfigurationsResponse *const*)ptr, "trt:GetCompatibleAudioSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, tag, id, (struct _trt__GetCompatibleAudioSourceConfigurations *const*)ptr, "trt:GetCompatibleAudioSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *const*)ptr, "trt:GetCompatibleAudioEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, tag, id, (struct _trt__GetCompatibleAudioEncoderConfigurations *const*)ptr, "trt:GetCompatibleAudioEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleVideoSourceConfigurationsResponse *const*)ptr, "trt:GetCompatibleVideoSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, tag, id, (struct _trt__GetCompatibleVideoSourceConfigurations *const*)ptr, "trt:GetCompatibleVideoSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *const*)ptr, "trt:GetCompatibleVideoEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, tag, id, (struct _trt__GetCompatibleVideoEncoderConfigurations *const*)ptr, "trt:GetCompatibleVideoEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurationResponse(soap, tag, id, (struct _trt__GetAudioEncoderConfigurationResponse *const*)ptr, "trt:GetAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfiguration:
		return soap_out_PointerTo_trt__GetAudioEncoderConfiguration(soap, tag, id, (struct _trt__GetAudioEncoderConfiguration *const*)ptr, "trt:GetAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationResponse:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurationResponse(soap, tag, id, (struct _trt__GetAudioSourceConfigurationResponse *const*)ptr, "trt:GetAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfiguration:
		return soap_out_PointerTo_trt__GetAudioSourceConfiguration(soap, tag, id, (struct _trt__GetAudioSourceConfiguration *const*)ptr, "trt:GetAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurationResponse(soap, tag, id, (struct _trt__GetVideoEncoderConfigurationResponse *const*)ptr, "trt:GetVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfiguration:
		return soap_out_PointerTo_trt__GetVideoEncoderConfiguration(soap, tag, id, (struct _trt__GetVideoEncoderConfiguration *const*)ptr, "trt:GetVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationResponse:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurationResponse(soap, tag, id, (struct _trt__GetVideoSourceConfigurationResponse *const*)ptr, "trt:GetVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfiguration:
		return soap_out_PointerTo_trt__GetVideoSourceConfiguration(soap, tag, id, (struct _trt__GetVideoSourceConfiguration *const*)ptr, "trt:GetVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationsResponse:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurationsResponse(soap, tag, id, (struct _trt__GetAudioEncoderConfigurationsResponse *const*)ptr, "trt:GetAudioEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurations:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurations(soap, tag, id, (struct _trt__GetAudioEncoderConfigurations *const*)ptr, "trt:GetAudioEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationsResponse:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurationsResponse(soap, tag, id, (struct _trt__GetAudioSourceConfigurationsResponse *const*)ptr, "trt:GetAudioSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurations:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurations(soap, tag, id, (struct _trt__GetAudioSourceConfigurations *const*)ptr, "trt:GetAudioSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationsResponse:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurationsResponse(soap, tag, id, (struct _trt__GetVideoEncoderConfigurationsResponse *const*)ptr, "trt:GetVideoEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurations:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurations(soap, tag, id, (struct _trt__GetVideoEncoderConfigurations *const*)ptr, "trt:GetVideoEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationsResponse:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurationsResponse(soap, tag, id, (struct _trt__GetVideoSourceConfigurationsResponse *const*)ptr, "trt:GetVideoSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurations:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurations(soap, tag, id, (struct _trt__GetVideoSourceConfigurations *const*)ptr, "trt:GetVideoSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__DeleteProfileResponse:
		return soap_out_PointerTo_trt__DeleteProfileResponse(soap, tag, id, (struct _trt__DeleteProfileResponse *const*)ptr, "trt:DeleteProfileResponse");
	case SOAP_TYPE_PointerTo_trt__DeleteProfile:
		return soap_out_PointerTo_trt__DeleteProfile(soap, tag, id, (struct _trt__DeleteProfile *const*)ptr, "trt:DeleteProfile");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveAudioSourceConfigurationResponse(soap, tag, id, (struct _trt__RemoveAudioSourceConfigurationResponse *const*)ptr, "trt:RemoveAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfiguration:
		return soap_out_PointerTo_trt__RemoveAudioSourceConfiguration(soap, tag, id, (struct _trt__RemoveAudioSourceConfiguration *const*)ptr, "trt:RemoveAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveAudioEncoderConfigurationResponse(soap, tag, id, (struct _trt__RemoveAudioEncoderConfigurationResponse *const*)ptr, "trt:RemoveAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfiguration:
		return soap_out_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, tag, id, (struct _trt__RemoveAudioEncoderConfiguration *const*)ptr, "trt:RemoveAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveVideoSourceConfigurationResponse(soap, tag, id, (struct _trt__RemoveVideoSourceConfigurationResponse *const*)ptr, "trt:RemoveVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfiguration:
		return soap_out_PointerTo_trt__RemoveVideoSourceConfiguration(soap, tag, id, (struct _trt__RemoveVideoSourceConfiguration *const*)ptr, "trt:RemoveVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveVideoEncoderConfigurationResponse(soap, tag, id, (struct _trt__RemoveVideoEncoderConfigurationResponse *const*)ptr, "trt:RemoveVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfiguration:
		return soap_out_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, tag, id, (struct _trt__RemoveVideoEncoderConfiguration *const*)ptr, "trt:RemoveVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfigurationResponse:
		return soap_out_PointerTo_trt__AddAudioSourceConfigurationResponse(soap, tag, id, (struct _trt__AddAudioSourceConfigurationResponse *const*)ptr, "trt:AddAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfiguration:
		return soap_out_PointerTo_trt__AddAudioSourceConfiguration(soap, tag, id, (struct _trt__AddAudioSourceConfiguration *const*)ptr, "trt:AddAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__AddAudioEncoderConfigurationResponse(soap, tag, id, (struct _trt__AddAudioEncoderConfigurationResponse *const*)ptr, "trt:AddAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfiguration:
		return soap_out_PointerTo_trt__AddAudioEncoderConfiguration(soap, tag, id, (struct _trt__AddAudioEncoderConfiguration *const*)ptr, "trt:AddAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfigurationResponse:
		return soap_out_PointerTo_trt__AddVideoSourceConfigurationResponse(soap, tag, id, (struct _trt__AddVideoSourceConfigurationResponse *const*)ptr, "trt:AddVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfiguration:
		return soap_out_PointerTo_trt__AddVideoSourceConfiguration(soap, tag, id, (struct _trt__AddVideoSourceConfiguration *const*)ptr, "trt:AddVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__AddVideoEncoderConfigurationResponse(soap, tag, id, (struct _trt__AddVideoEncoderConfigurationResponse *const*)ptr, "trt:AddVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfiguration:
		return soap_out_PointerTo_trt__AddVideoEncoderConfiguration(soap, tag, id, (struct _trt__AddVideoEncoderConfiguration *const*)ptr, "trt:AddVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetProfilesResponse:
		return soap_out_PointerTo_trt__GetProfilesResponse(soap, tag, id, (struct _trt__GetProfilesResponse *const*)ptr, "trt:GetProfilesResponse");
	case SOAP_TYPE_PointerTo_trt__GetProfiles:
		return soap_out_PointerTo_trt__GetProfiles(soap, tag, id, (struct _trt__GetProfiles *const*)ptr, "trt:GetProfiles");
	case SOAP_TYPE_PointerTo_trt__GetProfileResponse:
		return soap_out_PointerTo_trt__GetProfileResponse(soap, tag, id, (struct _trt__GetProfileResponse *const*)ptr, "trt:GetProfileResponse");
	case SOAP_TYPE_PointerTo_trt__GetProfile:
		return soap_out_PointerTo_trt__GetProfile(soap, tag, id, (struct _trt__GetProfile *const*)ptr, "trt:GetProfile");
	case SOAP_TYPE_PointerTo_trt__CreateProfileResponse:
		return soap_out_PointerTo_trt__CreateProfileResponse(soap, tag, id, (struct _trt__CreateProfileResponse *const*)ptr, "trt:CreateProfileResponse");
	case SOAP_TYPE_PointerTo_trt__CreateProfile:
		return soap_out_PointerTo_trt__CreateProfile(soap, tag, id, (struct _trt__CreateProfile *const*)ptr, "trt:CreateProfile");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourcesResponse:
		return soap_out_PointerTo_trt__GetAudioSourcesResponse(soap, tag, id, (struct _trt__GetAudioSourcesResponse *const*)ptr, "trt:GetAudioSourcesResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSources:
		return soap_out_PointerTo_trt__GetAudioSources(soap, tag, id, (struct _trt__GetAudioSources *const*)ptr, "trt:GetAudioSources");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourcesResponse:
		return soap_out_PointerTo_trt__GetVideoSourcesResponse(soap, tag, id, (struct _trt__GetVideoSourcesResponse *const*)ptr, "trt:GetVideoSourcesResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSources:
		return soap_out_PointerTo_trt__GetVideoSources(soap, tag, id, (struct _trt__GetVideoSources *const*)ptr, "trt:GetVideoSources");
	case SOAP_TYPE_PointerTo_tds__SetZeroConfigurationResponse:
		return soap_out_PointerTo_tds__SetZeroConfigurationResponse(soap, tag, id, (struct _tds__SetZeroConfigurationResponse *const*)ptr, "tds:SetZeroConfigurationResponse");
	case SOAP_TYPE_PointerTo_tds__SetZeroConfiguration:
		return soap_out_PointerTo_tds__SetZeroConfiguration(soap, tag, id, (struct _tds__SetZeroConfiguration *const*)ptr, "tds:SetZeroConfiguration");
	case SOAP_TYPE_PointerTo_tds__GetZeroConfigurationResponse:
		return soap_out_PointerTo_tds__GetZeroConfigurationResponse(soap, tag, id, (struct _tds__GetZeroConfigurationResponse *const*)ptr, "tds:GetZeroConfigurationResponse");
	case SOAP_TYPE_PointerTo_tds__GetZeroConfiguration:
		return soap_out_PointerTo_tds__GetZeroConfiguration(soap, tag, id, (struct _tds__GetZeroConfiguration *const*)ptr, "tds:GetZeroConfiguration");
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGatewayResponse:
		return soap_out_PointerTo_tds__SetNetworkDefaultGatewayResponse(soap, tag, id, (struct _tds__SetNetworkDefaultGatewayResponse *const*)ptr, "tds:SetNetworkDefaultGatewayResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGateway:
		return soap_out_PointerTo_tds__SetNetworkDefaultGateway(soap, tag, id, (struct _tds__SetNetworkDefaultGateway *const*)ptr, "tds:SetNetworkDefaultGateway");
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGatewayResponse:
		return soap_out_PointerTo_tds__GetNetworkDefaultGatewayResponse(soap, tag, id, (struct _tds__GetNetworkDefaultGatewayResponse *const*)ptr, "tds:GetNetworkDefaultGatewayResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGateway:
		return soap_out_PointerTo_tds__GetNetworkDefaultGateway(soap, tag, id, (struct _tds__GetNetworkDefaultGateway *const*)ptr, "tds:GetNetworkDefaultGateway");
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfacesResponse:
		return soap_out_PointerTo_tds__SetNetworkInterfacesResponse(soap, tag, id, (struct _tds__SetNetworkInterfacesResponse *const*)ptr, "tds:SetNetworkInterfacesResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfaces:
		return soap_out_PointerTo_tds__SetNetworkInterfaces(soap, tag, id, (struct _tds__SetNetworkInterfaces *const*)ptr, "tds:SetNetworkInterfaces");
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfacesResponse:
		return soap_out_PointerTo_tds__GetNetworkInterfacesResponse(soap, tag, id, (struct _tds__GetNetworkInterfacesResponse *const*)ptr, "tds:GetNetworkInterfacesResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfaces:
		return soap_out_PointerTo_tds__GetNetworkInterfaces(soap, tag, id, (struct _tds__GetNetworkInterfaces *const*)ptr, "tds:GetNetworkInterfaces");
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNSResponse:
		return soap_out_PointerTo_tds__SetDynamicDNSResponse(soap, tag, id, (struct _tds__SetDynamicDNSResponse *const*)ptr, "tds:SetDynamicDNSResponse");
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNS:
		return soap_out_PointerTo_tds__SetDynamicDNS(soap, tag, id, (struct _tds__SetDynamicDNS *const*)ptr, "tds:SetDynamicDNS");
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNSResponse:
		return soap_out_PointerTo_tds__GetDynamicDNSResponse(soap, tag, id, (struct _tds__GetDynamicDNSResponse *const*)ptr, "tds:GetDynamicDNSResponse");
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNS:
		return soap_out_PointerTo_tds__GetDynamicDNS(soap, tag, id, (struct _tds__GetDynamicDNS *const*)ptr, "tds:GetDynamicDNS");
	case SOAP_TYPE_PointerTo_tds__SetNTPResponse:
		return soap_out_PointerTo_tds__SetNTPResponse(soap, tag, id, (struct _tds__SetNTPResponse *const*)ptr, "tds:SetNTPResponse");
	case SOAP_TYPE_PointerTo_tds__SetNTP:
		return soap_out_PointerTo_tds__SetNTP(soap, tag, id, (struct _tds__SetNTP *const*)ptr, "tds:SetNTP");
	case SOAP_TYPE_PointerTo_tds__GetNTPResponse:
		return soap_out_PointerTo_tds__GetNTPResponse(soap, tag, id, (struct _tds__GetNTPResponse *const*)ptr, "tds:GetNTPResponse");
	case SOAP_TYPE_PointerTo_tds__GetNTP:
		return soap_out_PointerTo_tds__GetNTP(soap, tag, id, (struct _tds__GetNTP *const*)ptr, "tds:GetNTP");
	case SOAP_TYPE_PointerTo_tds__SetDNSResponse:
		return soap_out_PointerTo_tds__SetDNSResponse(soap, tag, id, (struct _tds__SetDNSResponse *const*)ptr, "tds:SetDNSResponse");
	case SOAP_TYPE_PointerTo_tds__SetDNS:
		return soap_out_PointerTo_tds__SetDNS(soap, tag, id, (struct _tds__SetDNS *const*)ptr, "tds:SetDNS");
	case SOAP_TYPE_PointerTo_tds__GetDNSResponse:
		return soap_out_PointerTo_tds__GetDNSResponse(soap, tag, id, (struct _tds__GetDNSResponse *const*)ptr, "tds:GetDNSResponse");
	case SOAP_TYPE_PointerTo_tds__GetDNS:
		return soap_out_PointerTo_tds__GetDNS(soap, tag, id, (struct _tds__GetDNS *const*)ptr, "tds:GetDNS");
	case SOAP_TYPE_PointerTo_tds__SetHostnameResponse:
		return soap_out_PointerTo_tds__SetHostnameResponse(soap, tag, id, (struct _tds__SetHostnameResponse *const*)ptr, "tds:SetHostnameResponse");
	case SOAP_TYPE_PointerTo_tds__SetHostname:
		return soap_out_PointerTo_tds__SetHostname(soap, tag, id, (struct _tds__SetHostname *const*)ptr, "tds:SetHostname");
	case SOAP_TYPE_PointerTo_tds__GetHostnameResponse:
		return soap_out_PointerTo_tds__GetHostnameResponse(soap, tag, id, (struct _tds__GetHostnameResponse *const*)ptr, "tds:GetHostnameResponse");
	case SOAP_TYPE_PointerTo_tds__GetHostname:
		return soap_out_PointerTo_tds__GetHostname(soap, tag, id, (struct _tds__GetHostname *const*)ptr, "tds:GetHostname");
	case SOAP_TYPE_PointerTo_tds__GetCapabilitiesResponse:
		return soap_out_PointerTo_tds__GetCapabilitiesResponse(soap, tag, id, (struct _tds__GetCapabilitiesResponse *const*)ptr, "tds:GetCapabilitiesResponse");
	case SOAP_TYPE_PointerTo_tds__GetCapabilities:
		return soap_out_PointerTo_tds__GetCapabilities(soap, tag, id, (struct _tds__GetCapabilities *const*)ptr, "tds:GetCapabilities");
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrlResponse:
		return soap_out_PointerTo_tds__GetWsdlUrlResponse(soap, tag, id, (struct _tds__GetWsdlUrlResponse *const*)ptr, "tds:GetWsdlUrlResponse");
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrl:
		return soap_out_PointerTo_tds__GetWsdlUrl(soap, tag, id, (struct _tds__GetWsdlUrl *const*)ptr, "tds:GetWsdlUrl");
	case SOAP_TYPE_PointerTo_tds__SetUserResponse:
		return soap_out_PointerTo_tds__SetUserResponse(soap, tag, id, (struct _tds__SetUserResponse *const*)ptr, "tds:SetUserResponse");
	case SOAP_TYPE_PointerTo_tds__SetUser:
		return soap_out_PointerTo_tds__SetUser(soap, tag, id, (struct _tds__SetUser *const*)ptr, "tds:SetUser");
	case SOAP_TYPE_PointerTo_tds__DeleteUsersResponse:
		return soap_out_PointerTo_tds__DeleteUsersResponse(soap, tag, id, (struct _tds__DeleteUsersResponse *const*)ptr, "tds:DeleteUsersResponse");
	case SOAP_TYPE_PointerTo_tds__DeleteUsers:
		return soap_out_PointerTo_tds__DeleteUsers(soap, tag, id, (struct _tds__DeleteUsers *const*)ptr, "tds:DeleteUsers");
	case SOAP_TYPE_PointerTo_tds__CreateUsersResponse:
		return soap_out_PointerTo_tds__CreateUsersResponse(soap, tag, id, (struct _tds__CreateUsersResponse *const*)ptr, "tds:CreateUsersResponse");
	case SOAP_TYPE_PointerTo_tds__CreateUsers:
		return soap_out_PointerTo_tds__CreateUsers(soap, tag, id, (struct _tds__CreateUsers *const*)ptr, "tds:CreateUsers");
	case SOAP_TYPE_PointerTo_tds__GetUsersResponse:
		return soap_out_PointerTo_tds__GetUsersResponse(soap, tag, id, (struct _tds__GetUsersResponse *const*)ptr, "tds:GetUsersResponse");
	case SOAP_TYPE_PointerTo_tds__GetUsers:
		return soap_out_PointerTo_tds__GetUsers(soap, tag, id, (struct _tds__GetUsers *const*)ptr, "tds:GetUsers");
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryModeResponse:
		return soap_out_PointerTo_tds__SetDiscoveryModeResponse(soap, tag, id, (struct _tds__SetDiscoveryModeResponse *const*)ptr, "tds:SetDiscoveryModeResponse");
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryMode:
		return soap_out_PointerTo_tds__SetDiscoveryMode(soap, tag, id, (struct _tds__SetDiscoveryMode *const*)ptr, "tds:SetDiscoveryMode");
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryModeResponse:
		return soap_out_PointerTo_tds__GetDiscoveryModeResponse(soap, tag, id, (struct _tds__GetDiscoveryModeResponse *const*)ptr, "tds:GetDiscoveryModeResponse");
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryMode:
		return soap_out_PointerTo_tds__GetDiscoveryMode(soap, tag, id, (struct _tds__GetDiscoveryMode *const*)ptr, "tds:GetDiscoveryMode");
	case SOAP_TYPE_PointerTo_tds__RemoveScopesResponse:
		return soap_out_PointerTo_tds__RemoveScopesResponse(soap, tag, id, (struct _tds__RemoveScopesResponse *const*)ptr, "tds:RemoveScopesResponse");
	case SOAP_TYPE_PointerTo_tds__RemoveScopes:
		return soap_out_PointerTo_tds__RemoveScopes(soap, tag, id, (struct _tds__RemoveScopes *const*)ptr, "tds:RemoveScopes");
	case SOAP_TYPE_PointerTo_tds__AddScopesResponse:
		return soap_out_PointerTo_tds__AddScopesResponse(soap, tag, id, (struct _tds__AddScopesResponse *const*)ptr, "tds:AddScopesResponse");
	case SOAP_TYPE_PointerTo_tds__AddScopes:
		return soap_out_PointerTo_tds__AddScopes(soap, tag, id, (struct _tds__AddScopes *const*)ptr, "tds:AddScopes");
	case SOAP_TYPE_PointerTo_tds__SetScopesResponse:
		return soap_out_PointerTo_tds__SetScopesResponse(soap, tag, id, (struct _tds__SetScopesResponse *const*)ptr, "tds:SetScopesResponse");
	case SOAP_TYPE_PointerTo_tds__SetScopes:
		return soap_out_PointerTo_tds__SetScopes(soap, tag, id, (struct _tds__SetScopes *const*)ptr, "tds:SetScopes");
	case SOAP_TYPE_PointerTo_tds__GetScopesResponse:
		return soap_out_PointerTo_tds__GetScopesResponse(soap, tag, id, (struct _tds__GetScopesResponse *const*)ptr, "tds:GetScopesResponse");
	case SOAP_TYPE_PointerTo_tds__GetScopes:
		return soap_out_PointerTo_tds__GetScopes(soap, tag, id, (struct _tds__GetScopes *const*)ptr, "tds:GetScopes");
	case SOAP_TYPE_PointerTo_tds__SystemRebootResponse:
		return soap_out_PointerTo_tds__SystemRebootResponse(soap, tag, id, (struct _tds__SystemRebootResponse *const*)ptr, "tds:SystemRebootResponse");
	case SOAP_TYPE_PointerTo_tds__SystemReboot:
		return soap_out_PointerTo_tds__SystemReboot(soap, tag, id, (struct _tds__SystemReboot *const*)ptr, "tds:SystemReboot");
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefaultResponse:
		return soap_out_PointerTo_tds__SetSystemFactoryDefaultResponse(soap, tag, id, (struct _tds__SetSystemFactoryDefaultResponse *const*)ptr, "tds:SetSystemFactoryDefaultResponse");
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefault:
		return soap_out_PointerTo_tds__SetSystemFactoryDefault(soap, tag, id, (struct _tds__SetSystemFactoryDefault *const*)ptr, "tds:SetSystemFactoryDefault");
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTimeResponse:
		return soap_out_PointerTo_tds__GetSystemDateAndTimeResponse(soap, tag, id, (struct _tds__GetSystemDateAndTimeResponse *const*)ptr, "tds:GetSystemDateAndTimeResponse");
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTime:
		return soap_out_PointerTo_tds__GetSystemDateAndTime(soap, tag, id, (struct _tds__GetSystemDateAndTime *const*)ptr, "tds:GetSystemDateAndTime");
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTimeResponse:
		return soap_out_PointerTo_tds__SetSystemDateAndTimeResponse(soap, tag, id, (struct _tds__SetSystemDateAndTimeResponse *const*)ptr, "tds:SetSystemDateAndTimeResponse");
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTime:
		return soap_out_PointerTo_tds__SetSystemDateAndTime(soap, tag, id, (struct _tds__SetSystemDateAndTime *const*)ptr, "tds:SetSystemDateAndTime");
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformationResponse:
		return soap_out_PointerTo_tds__GetDeviceInformationResponse(soap, tag, id, (struct _tds__GetDeviceInformationResponse *const*)ptr, "tds:GetDeviceInformationResponse");
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformation:
		return soap_out_PointerTo_tds__GetDeviceInformation(soap, tag, id, (struct _tds__GetDeviceInformation *const*)ptr, "tds:GetDeviceInformation");
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		return soap_out_PointerTod__ProbeMatchesType(soap, tag, id, (struct d__ProbeMatchesType *const*)ptr, "d:ProbeMatchesType");
	case SOAP_TYPE_PointerTod__ProbeType:
		return soap_out_PointerTod__ProbeType(soap, tag, id, (struct d__ProbeType *const*)ptr, "d:ProbeType");
	case SOAP_TYPE_PointerTod__ByeType:
		return soap_out_PointerTod__ByeType(soap, tag, id, (struct d__ByeType *const*)ptr, "d:ByeType");
	case SOAP_TYPE_PointerTod__ResolveType:
		return soap_out_PointerTod__ResolveType(soap, tag, id, (struct d__ResolveType *const*)ptr, "d:ResolveType");
	case SOAP_TYPE_PointerTod__HelloType:
		return soap_out_PointerTod__HelloType(soap, tag, id, (struct d__HelloType *const*)ptr, "d:HelloType");
	case SOAP_TYPE__wsu__Created:
		return soap_out_string(soap, "wsu:Created", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsu__Id:
		return soap_out_string(soap, "wsu:Id", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__d__XAddrs:
		return soap_out_string(soap, "d:XAddrs", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__d__Types:
		return soap_out_string(soap, "d:Types", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension:
		return soap_out_PointerTott__NetworkInterfaceExtension(soap, tag, id, (struct tt__NetworkInterfaceExtension *const*)ptr, "tt:NetworkInterfaceExtension");
	case SOAP_TYPE_PointerTott__IPv4NetworkInterface:
		return soap_out_PointerTott__IPv4NetworkInterface(soap, tag, id, (struct tt__IPv4NetworkInterface *const*)ptr, "tt:IPv4NetworkInterface");
	case SOAP_TYPE_PointerTott__NetworkInterfaceLink:
		return soap_out_PointerTott__NetworkInterfaceLink(soap, tag, id, (struct tt__NetworkInterfaceLink *const*)ptr, "tt:NetworkInterfaceLink");
	case SOAP_TYPE_PointerTott__NetworkInterfaceInfo:
		return soap_out_PointerTott__NetworkInterfaceInfo(soap, tag, id, (struct tt__NetworkInterfaceInfo *const*)ptr, "tt:NetworkInterfaceInfo");
	case SOAP_TYPE_PointerTott__MulticastConfiguration:
		return soap_out_PointerTott__MulticastConfiguration(soap, tag, id, (struct tt__MulticastConfiguration *const*)ptr, "tt:MulticastConfiguration");
	case SOAP_TYPE_PointerTott__H264Configuration:
		return soap_out_PointerTott__H264Configuration(soap, tag, id, (struct tt__H264Configuration *const*)ptr, "tt:H264Configuration");
	case SOAP_TYPE_PointerTott__Mpeg4Configuration:
		return soap_out_PointerTott__Mpeg4Configuration(soap, tag, id, (struct tt__Mpeg4Configuration *const*)ptr, "tt:Mpeg4Configuration");
	case SOAP_TYPE_PointerTott__VideoRateControl:
		return soap_out_PointerTott__VideoRateControl(soap, tag, id, (struct tt__VideoRateControl *const*)ptr, "tt:VideoRateControl");
	case SOAP_TYPE_PointerTott__IntRectangle:
		return soap_out_PointerTott__IntRectangle(soap, tag, id, (struct tt__IntRectangle *const*)ptr, "tt:IntRectangle");
	case SOAP_TYPE_PointerTott__ImagingSettings:
		return soap_out_PointerTott__ImagingSettings(soap, tag, id, (struct tt__ImagingSettings *const*)ptr, "tt:ImagingSettings");
	case SOAP_TYPE_PointerTowsse__UsernameTokenType:
		return soap_out_PointerTowsse__UsernameTokenType(soap, tag, id, (struct wsse__UsernameTokenType *const*)ptr, "wsse:UsernameTokenType");
	case SOAP_TYPE_PointerTowsu__TimestampType:
		return soap_out_PointerTowsu__TimestampType(soap, tag, id, (struct wsu__TimestampType *const*)ptr, "wsu:TimestampType");
	case SOAP_TYPE_PointerTowsse__PasswordString:
		return soap_out_PointerTowsse__PasswordString(soap, tag, id, (struct wsse__PasswordString *const*)ptr, "wsse:PasswordString");
	case SOAP_TYPE_PointerTowsadis__EndpointReferenceType:
		return soap_out_PointerTowsadis__EndpointReferenceType(soap, tag, id, (struct wsadis__EndpointReferenceType *const*)ptr, "wsadis:EndpointReferenceType");
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		return soap_out_PointerTod__ProbeMatchType(soap, tag, id, (struct d__ProbeMatchType *const*)ptr, "d:ProbeMatchType");
	case SOAP_TYPE_PointerTounsignedInt:
		return soap_out_PointerTounsignedInt(soap, tag, id, (unsigned int *const*)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_PointerTod__ScopesType:
		return soap_out_PointerTod__ScopesType(soap, tag, id, (struct d__ScopesType *const*)ptr, "d:ScopesType");
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		return soap_out_PointerTowsa__EndpointReferenceType(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:EndpointReferenceType");
	case SOAP_TYPE_PointerTott__MediaUri:
		return soap_out_PointerTott__MediaUri(soap, tag, id, (struct tt__MediaUri *const*)ptr, "tt:MediaUri");
	case SOAP_TYPE_PointerTott__StreamSetup:
		return soap_out_PointerTott__StreamSetup(soap, tag, id, (struct tt__StreamSetup *const*)ptr, "tt:StreamSetup");
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOptions:
		return soap_out_PointerTott__AudioEncoderConfigurationOptions(soap, tag, id, (struct tt__AudioEncoderConfigurationOptions *const*)ptr, "tt:AudioEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTott__AudioSourceConfigurationOptions:
		return soap_out_PointerTott__AudioSourceConfigurationOptions(soap, tag, id, (struct tt__AudioSourceConfigurationOptions *const*)ptr, "tt:AudioSourceConfigurationOptions");
	case SOAP_TYPE_PointerTott__VideoEncoderConfigurationOptions:
		return soap_out_PointerTott__VideoEncoderConfigurationOptions(soap, tag, id, (struct tt__VideoEncoderConfigurationOptions *const*)ptr, "tt:VideoEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTott__VideoSourceConfigurationOptions:
		return soap_out_PointerTott__VideoSourceConfigurationOptions(soap, tag, id, (struct tt__VideoSourceConfigurationOptions *const*)ptr, "tt:VideoSourceConfigurationOptions");
	case SOAP_TYPE_PointerTott__Profile:
		return soap_out_PointerTott__Profile(soap, tag, id, (struct tt__Profile *const*)ptr, "tt:Profile");
	case SOAP_TYPE_PointerTott__AudioSource:
		return soap_out_PointerTott__AudioSource(soap, tag, id, (struct tt__AudioSource *const*)ptr, "tt:AudioSource");
	case SOAP_TYPE_PointerTott__VideoSource:
		return soap_out_PointerTott__VideoSource(soap, tag, id, (struct tt__VideoSource *const*)ptr, "tt:VideoSource");
	case SOAP_TYPE_PointerTotrt__Capabilities:
		return soap_out_PointerTotrt__Capabilities(soap, tag, id, (struct trt__Capabilities *const*)ptr, "trt:Capabilities");
	case SOAP_TYPE_PointerTotrt__StreamingCapabilities:
		return soap_out_PointerTotrt__StreamingCapabilities(soap, tag, id, (struct trt__StreamingCapabilities *const*)ptr, "trt:StreamingCapabilities");
	case SOAP_TYPE_PointerTotrt__ProfileCapabilities:
		return soap_out_PointerTotrt__ProfileCapabilities(soap, tag, id, (struct trt__ProfileCapabilities *const*)ptr, "trt:ProfileCapabilities");
	case SOAP_TYPE_PointerTowsa__MetadataType:
		return soap_out_PointerTowsa__MetadataType(soap, tag, id, (struct wsa__MetadataType *const*)ptr, "wsa:MetadataType");
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		return soap_out_PointerTowsa__ReferenceParametersType(soap, tag, id, (struct wsa__ReferenceParametersType *const*)ptr, "wsa:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsa__AttributedURIType:
		return soap_out_PointerTowsa__AttributedURIType(soap, tag, id, (struct wsa__AttributedURIType *const*)ptr, "wsa:AttributedURIType");
	case SOAP_TYPE_PointerTott__WhiteBalanceMode:
		return soap_out_PointerTott__WhiteBalanceMode(soap, tag, id, (enum tt__WhiteBalanceMode *const*)ptr, "tt:WhiteBalanceMode");
	case SOAP_TYPE_PointerTott__ExposurePriority:
		return soap_out_PointerTott__ExposurePriority(soap, tag, id, (enum tt__ExposurePriority *const*)ptr, "tt:ExposurePriority");
	case SOAP_TYPE_PointerTott__ExposureMode:
		return soap_out_PointerTott__ExposureMode(soap, tag, id, (enum tt__ExposureMode *const*)ptr, "tt:ExposureMode");
	case SOAP_TYPE_PointerTott__AutoFocusMode:
		return soap_out_PointerTott__AutoFocusMode(soap, tag, id, (enum tt__AutoFocusMode *const*)ptr, "tt:AutoFocusMode");
	case SOAP_TYPE_PointerTott__WideDynamicMode:
		return soap_out_PointerTott__WideDynamicMode(soap, tag, id, (enum tt__WideDynamicMode *const*)ptr, "tt:WideDynamicMode");
	case SOAP_TYPE_PointerTott__WhiteBalanceOptions:
		return soap_out_PointerTott__WhiteBalanceOptions(soap, tag, id, (struct tt__WhiteBalanceOptions *const*)ptr, "tt:WhiteBalanceOptions");
	case SOAP_TYPE_PointerTott__WideDynamicRangeOptions:
		return soap_out_PointerTott__WideDynamicRangeOptions(soap, tag, id, (struct tt__WideDynamicRangeOptions *const*)ptr, "tt:WideDynamicRangeOptions");
	case SOAP_TYPE_PointerTott__FocusOptions:
		return soap_out_PointerTott__FocusOptions(soap, tag, id, (struct tt__FocusOptions *const*)ptr, "tt:FocusOptions");
	case SOAP_TYPE_PointerTott__ExposureOptions:
		return soap_out_PointerTott__ExposureOptions(soap, tag, id, (struct tt__ExposureOptions *const*)ptr, "tt:ExposureOptions");
	case SOAP_TYPE_PointerTott__FloatRange:
		return soap_out_PointerTott__FloatRange(soap, tag, id, (struct tt__FloatRange *const*)ptr, "tt:FloatRange");
	case SOAP_TYPE_PointerTott__BacklightCompensationOptions:
		return soap_out_PointerTott__BacklightCompensationOptions(soap, tag, id, (struct tt__BacklightCompensationOptions *const*)ptr, "tt:BacklightCompensationOptions");
	case SOAP_TYPE_PointerTott__Rectangle:
		return soap_out_PointerTott__Rectangle(soap, tag, id, (struct tt__Rectangle *const*)ptr, "tt:Rectangle");
	case SOAP_TYPE_PointerTott__WhiteBalance:
		return soap_out_PointerTott__WhiteBalance(soap, tag, id, (struct tt__WhiteBalance *const*)ptr, "tt:WhiteBalance");
	case SOAP_TYPE_PointerTott__WideDynamicRange:
		return soap_out_PointerTott__WideDynamicRange(soap, tag, id, (struct tt__WideDynamicRange *const*)ptr, "tt:WideDynamicRange");
	case SOAP_TYPE_PointerTott__IrCutFilterMode:
		return soap_out_PointerTott__IrCutFilterMode(soap, tag, id, (enum tt__IrCutFilterMode *const*)ptr, "tt:IrCutFilterMode");
	case SOAP_TYPE_PointerTott__FocusConfiguration:
		return soap_out_PointerTott__FocusConfiguration(soap, tag, id, (struct tt__FocusConfiguration *const*)ptr, "tt:FocusConfiguration");
	case SOAP_TYPE_PointerTott__Exposure:
		return soap_out_PointerTott__Exposure(soap, tag, id, (struct tt__Exposure *const*)ptr, "tt:Exposure");
	case SOAP_TYPE_PointerTofloat:
		return soap_out_PointerTofloat(soap, tag, id, (float *const*)ptr, "xsd:float");
	case SOAP_TYPE_PointerTott__BacklightCompensation:
		return soap_out_PointerTott__BacklightCompensation(soap, tag, id, (struct tt__BacklightCompensation *const*)ptr, "tt:BacklightCompensation");
	case SOAP_TYPE_PointerTott__Date:
		return soap_out_PointerTott__Date(soap, tag, id, (struct tt__Date *const*)ptr, "tt:Date");
	case SOAP_TYPE_PointerTott__Time:
		return soap_out_PointerTott__Time(soap, tag, id, (struct tt__Time *const*)ptr, "tt:Time");
	case SOAP_TYPE_PointerTott__OnvifVersion:
		return soap_out_PointerTott__OnvifVersion(soap, tag, id, (struct tt__OnvifVersion *const*)ptr, "tt:OnvifVersion");
	case SOAP_TYPE_PointerTott__RealTimeStreamingCapabilities:
		return soap_out_PointerTott__RealTimeStreamingCapabilities(soap, tag, id, (struct tt__RealTimeStreamingCapabilities *const*)ptr, "tt:RealTimeStreamingCapabilities");
	case SOAP_TYPE_PointerTott__SecurityCapabilities:
		return soap_out_PointerTott__SecurityCapabilities(soap, tag, id, (struct tt__SecurityCapabilities *const*)ptr, "tt:SecurityCapabilities");
	case SOAP_TYPE_PointerTott__IOCapabilities:
		return soap_out_PointerTott__IOCapabilities(soap, tag, id, (struct tt__IOCapabilities *const*)ptr, "tt:IOCapabilities");
	case SOAP_TYPE_PointerTott__SystemCapabilities:
		return soap_out_PointerTott__SystemCapabilities(soap, tag, id, (struct tt__SystemCapabilities *const*)ptr, "tt:SystemCapabilities");
	case SOAP_TYPE_PointerTott__NetworkCapabilities:
		return soap_out_PointerTott__NetworkCapabilities(soap, tag, id, (struct tt__NetworkCapabilities *const*)ptr, "tt:NetworkCapabilities");
	case SOAP_TYPE_PointerTott__AnalyticsDeviceCapabilities:
		return soap_out_PointerTott__AnalyticsDeviceCapabilities(soap, tag, id, (struct tt__AnalyticsDeviceCapabilities *const*)ptr, "tt:AnalyticsDeviceCapabilities");
	case SOAP_TYPE_PointerTott__ReceiverCapabilities:
		return soap_out_PointerTott__ReceiverCapabilities(soap, tag, id, (struct tt__ReceiverCapabilities *const*)ptr, "tt:ReceiverCapabilities");
	case SOAP_TYPE_PointerTott__ReplayCapabilities:
		return soap_out_PointerTott__ReplayCapabilities(soap, tag, id, (struct tt__ReplayCapabilities *const*)ptr, "tt:ReplayCapabilities");
	case SOAP_TYPE_PointerTott__SearchCapabilities:
		return soap_out_PointerTott__SearchCapabilities(soap, tag, id, (struct tt__SearchCapabilities *const*)ptr, "tt:SearchCapabilities");
	case SOAP_TYPE_PointerTott__RecordingCapabilities:
		return soap_out_PointerTott__RecordingCapabilities(soap, tag, id, (struct tt__RecordingCapabilities *const*)ptr, "tt:RecordingCapabilities");
	case SOAP_TYPE_PointerTott__DisplayCapabilities:
		return soap_out_PointerTott__DisplayCapabilities(soap, tag, id, (struct tt__DisplayCapabilities *const*)ptr, "tt:DisplayCapabilities");
	case SOAP_TYPE_PointerTott__DeviceIOCapabilities:
		return soap_out_PointerTott__DeviceIOCapabilities(soap, tag, id, (struct tt__DeviceIOCapabilities *const*)ptr, "tt:DeviceIOCapabilities");
	case SOAP_TYPE_PointerTott__CapabilitiesExtension:
		return soap_out_PointerTott__CapabilitiesExtension(soap, tag, id, (struct tt__CapabilitiesExtension *const*)ptr, "tt:CapabilitiesExtension");
	case SOAP_TYPE_PointerTott__PTZCapabilities:
		return soap_out_PointerTott__PTZCapabilities(soap, tag, id, (struct tt__PTZCapabilities *const*)ptr, "tt:PTZCapabilities");
	case SOAP_TYPE_PointerTott__MediaCapabilities:
		return soap_out_PointerTott__MediaCapabilities(soap, tag, id, (struct tt__MediaCapabilities *const*)ptr, "tt:MediaCapabilities");
	case SOAP_TYPE_PointerTott__ImagingCapabilities:
		return soap_out_PointerTott__ImagingCapabilities(soap, tag, id, (struct tt__ImagingCapabilities *const*)ptr, "tt:ImagingCapabilities");
	case SOAP_TYPE_PointerTott__EventCapabilities:
		return soap_out_PointerTott__EventCapabilities(soap, tag, id, (struct tt__EventCapabilities *const*)ptr, "tt:EventCapabilities");
	case SOAP_TYPE_PointerTott__DeviceCapabilities:
		return soap_out_PointerTott__DeviceCapabilities(soap, tag, id, (struct tt__DeviceCapabilities *const*)ptr, "tt:DeviceCapabilities");
	case SOAP_TYPE_PointerTott__AnalyticsCapabilities:
		return soap_out_PointerTott__AnalyticsCapabilities(soap, tag, id, (struct tt__AnalyticsCapabilities *const*)ptr, "tt:AnalyticsCapabilities");
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfigurationExtension:
		return soap_out_PointerTott__NetworkInterfaceSetConfigurationExtension(soap, tag, id, (struct tt__NetworkInterfaceSetConfigurationExtension *const*)ptr, "tt:NetworkInterfaceSetConfigurationExtension");
	case SOAP_TYPE_PointerTott__IPv4NetworkInterfaceSetConfiguration:
		return soap_out_PointerTott__IPv4NetworkInterfaceSetConfiguration(soap, tag, id, (struct tt__IPv4NetworkInterfaceSetConfiguration *const*)ptr, "tt:IPv4NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_PointerTott__PrefixedIPv4Address:
		return soap_out_PointerTott__PrefixedIPv4Address(soap, tag, id, (struct tt__PrefixedIPv4Address *const*)ptr, "tt:PrefixedIPv4Address");
	case SOAP_TYPE_PointerTott__IPv4Configuration:
		return soap_out_PointerTott__IPv4Configuration(soap, tag, id, (struct tt__IPv4Configuration *const*)ptr, "tt:IPv4Configuration");
	case SOAP_TYPE_PointerTott__NetworkInterfaceConnectionSetting:
		return soap_out_PointerTott__NetworkInterfaceConnectionSetting(soap, tag, id, (struct tt__NetworkInterfaceConnectionSetting *const*)ptr, "tt:NetworkInterfaceConnectionSetting");
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension2:
		return soap_out_PointerTott__NetworkInterfaceExtension2(soap, tag, id, (struct tt__NetworkInterfaceExtension2 *const*)ptr, "tt:NetworkInterfaceExtension2");
	case SOAP_TYPE_PointerTott__Dot3Configuration:
		return soap_out_PointerTott__Dot3Configuration(soap, tag, id, (struct tt__Dot3Configuration *const*)ptr, "tt:Dot3Configuration");
	case SOAP_TYPE_PointerTott__Transport:
		return soap_out_PointerTott__Transport(soap, tag, id, (struct tt__Transport *const*)ptr, "tt:Transport");
	case SOAP_TYPE_PointerTott__IntList:
		return soap_out_PointerTott__IntList(soap, tag, id, (struct tt__IntList *const*)ptr, "tt:IntList");
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOption:
		return soap_out_PointerTott__AudioEncoderConfigurationOption(soap, tag, id, (struct tt__AudioEncoderConfigurationOption *const*)ptr, "tt:AudioEncoderConfigurationOption");
	case SOAP_TYPE_PointerTott__H264Profile:
		return soap_out_PointerTott__H264Profile(soap, tag, id, (enum tt__H264Profile *const*)ptr, "tt:H264Profile");
	case SOAP_TYPE_PointerTott__Mpeg4Profile:
		return soap_out_PointerTott__Mpeg4Profile(soap, tag, id, (enum tt__Mpeg4Profile *const*)ptr, "tt:Mpeg4Profile");
	case SOAP_TYPE_PointerTott__VideoResolution:
		return soap_out_PointerTott__VideoResolution(soap, tag, id, (struct tt__VideoResolution *const*)ptr, "tt:VideoResolution");
	case SOAP_TYPE_PointerTott__H264Options:
		return soap_out_PointerTott__H264Options(soap, tag, id, (struct tt__H264Options *const*)ptr, "tt:H264Options");
	case SOAP_TYPE_PointerTott__Mpeg4Options:
		return soap_out_PointerTott__Mpeg4Options(soap, tag, id, (struct tt__Mpeg4Options *const*)ptr, "tt:Mpeg4Options");
	case SOAP_TYPE_PointerTott__JpegOptions:
		return soap_out_PointerTott__JpegOptions(soap, tag, id, (struct tt__JpegOptions *const*)ptr, "tt:JpegOptions");
	case SOAP_TYPE_PointerTott__ReferenceToken:
		return soap_out_PointerTott__ReferenceToken(soap, tag, id, (char **const*)ptr, "tt:ReferenceToken");
	case SOAP_TYPE_PointerTott__IntRectangleRange:
		return soap_out_PointerTott__IntRectangleRange(soap, tag, id, (struct tt__IntRectangleRange *const*)ptr, "tt:IntRectangleRange");
	case SOAP_TYPE_PointerToxsd__boolean:
		return soap_out_PointerToxsd__boolean(soap, tag, id, (enum xsd__boolean *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerTott__AudioEncoderConfiguration:
		return soap_out_PointerTott__AudioEncoderConfiguration(soap, tag, id, (struct tt__AudioEncoderConfiguration *const*)ptr, "tt:AudioEncoderConfiguration");
	case SOAP_TYPE_PointerTott__VideoEncoderConfiguration:
		return soap_out_PointerTott__VideoEncoderConfiguration(soap, tag, id, (struct tt__VideoEncoderConfiguration *const*)ptr, "tt:VideoEncoderConfiguration");
	case SOAP_TYPE_PointerTott__AudioSourceConfiguration:
		return soap_out_PointerTott__AudioSourceConfiguration(soap, tag, id, (struct tt__AudioSourceConfiguration *const*)ptr, "tt:AudioSourceConfiguration");
	case SOAP_TYPE_PointerTott__VideoSourceConfiguration:
		return soap_out_PointerTott__VideoSourceConfiguration(soap, tag, id, (struct tt__VideoSourceConfiguration *const*)ptr, "tt:VideoSourceConfiguration");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerTott__IntRange:
		return soap_out_PointerTott__IntRange(soap, tag, id, (struct tt__IntRange *const*)ptr, "tt:IntRange");
	case SOAP_TYPE_PointerTott__NetworkZeroConfiguration:
		return soap_out_PointerTott__NetworkZeroConfiguration(soap, tag, id, (struct tt__NetworkZeroConfiguration *const*)ptr, "tt:NetworkZeroConfiguration");
	case SOAP_TYPE_PointerTott__IPv4Address:
		return soap_out_PointerTott__IPv4Address(soap, tag, id, (char **const*)ptr, "tt:IPv4Address");
	case SOAP_TYPE_PointerTott__NetworkGateway:
		return soap_out_PointerTott__NetworkGateway(soap, tag, id, (struct tt__NetworkGateway *const*)ptr, "tt:NetworkGateway");
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfiguration:
		return soap_out_PointerTott__NetworkInterfaceSetConfiguration(soap, tag, id, (struct tt__NetworkInterfaceSetConfiguration *const*)ptr, "tt:NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_PointerTott__NetworkInterface:
		return soap_out_PointerTott__NetworkInterface(soap, tag, id, (struct tt__NetworkInterface *const*)ptr, "tt:NetworkInterface");
	case SOAP_TYPE_PointerTott__DNSName:
		return soap_out_PointerTott__DNSName(soap, tag, id, (char **const*)ptr, "tt:DNSName");
	case SOAP_TYPE_PointerTott__DynamicDNSInformation:
		return soap_out_PointerTott__DynamicDNSInformation(soap, tag, id, (struct tt__DynamicDNSInformation *const*)ptr, "tt:DynamicDNSInformation");
	case SOAP_TYPE_PointerTott__NetworkHost:
		return soap_out_PointerTott__NetworkHost(soap, tag, id, (struct tt__NetworkHost *const*)ptr, "tt:NetworkHost");
	case SOAP_TYPE_PointerTott__NTPInformation:
		return soap_out_PointerTott__NTPInformation(soap, tag, id, (struct tt__NTPInformation *const*)ptr, "tt:NTPInformation");
	case SOAP_TYPE_PointerTott__IPAddress:
		return soap_out_PointerTott__IPAddress(soap, tag, id, (struct tt__IPAddress *const*)ptr, "tt:IPAddress");
	case SOAP_TYPE_PointerToxsd__token:
		return soap_out_PointerToxsd__token(soap, tag, id, (char **const*)ptr, "xsd:token");
	case SOAP_TYPE_PointerTott__DNSInformation:
		return soap_out_PointerTott__DNSInformation(soap, tag, id, (struct tt__DNSInformation *const*)ptr, "tt:DNSInformation");
	case SOAP_TYPE_PointerTott__HostnameInformation:
		return soap_out_PointerTott__HostnameInformation(soap, tag, id, (struct tt__HostnameInformation *const*)ptr, "tt:HostnameInformation");
	case SOAP_TYPE_PointerTott__Capabilities:
		return soap_out_PointerTott__Capabilities(soap, tag, id, (struct tt__Capabilities *const*)ptr, "tt:Capabilities");
	case SOAP_TYPE_PointerTott__CapabilityCategory:
		return soap_out_PointerTott__CapabilityCategory(soap, tag, id, (enum tt__CapabilityCategory *const*)ptr, "tt:CapabilityCategory");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTott__User:
		return soap_out_PointerTott__User(soap, tag, id, (struct tt__User *const*)ptr, "tt:User");
	case SOAP_TYPE_PointerToxsd__anyURI:
		return soap_out_PointerToxsd__anyURI(soap, tag, id, (char **const*)ptr, "xsd:anyURI");
	case SOAP_TYPE_PointerTott__Scope:
		return soap_out_PointerTott__Scope(soap, tag, id, (struct tt__Scope *const*)ptr, "tt:Scope");
	case SOAP_TYPE_PointerTott__SystemDateTime:
		return soap_out_PointerTott__SystemDateTime(soap, tag, id, (struct tt__SystemDateTime *const*)ptr, "tt:SystemDateTime");
	case SOAP_TYPE_PointerTott__DateTime:
		return soap_out_PointerTott__DateTime(soap, tag, id, (struct tt__DateTime *const*)ptr, "tt:DateTime");
	case SOAP_TYPE_PointerTott__TimeZone:
		return soap_out_PointerTott__TimeZone(soap, tag, id, (struct tt__TimeZone *const*)ptr, "tt:TimeZone");
	case SOAP_TYPE_PointerTowsadis__ServiceNameType:
		return soap_out_PointerTowsadis__ServiceNameType(soap, tag, id, (struct wsadis__ServiceNameType *const*)ptr, "wsadis:ServiceNameType");
	case SOAP_TYPE_PointerTowsadis__AttributedQName:
		return soap_out_PointerTowsadis__AttributedQName(soap, tag, id, (struct wsadis__AttributedQName *const*)ptr, "wsadis:AttributedQName");
	case SOAP_TYPE_PointerTowsadis__ReferenceParametersType:
		return soap_out_PointerTowsadis__ReferenceParametersType(soap, tag, id, (struct wsadis__ReferenceParametersType *const*)ptr, "wsadis:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsadis__ReferencePropertiesType:
		return soap_out_PointerTowsadis__ReferencePropertiesType(soap, tag, id, (struct wsadis__ReferencePropertiesType *const*)ptr, "wsadis:ReferencePropertiesType");
	case SOAP_TYPE_PointerTowsadis__AttributedURI:
		return soap_out_PointerTowsadis__AttributedURI(soap, tag, id, (struct wsadis__AttributedURI *const*)ptr, "wsadis:AttributedURI");
	case SOAP_TYPE_tt__Domain:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:Domain");
	case SOAP_TYPE_tt__DNSName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:DNSName");
	case SOAP_TYPE_tt__HwAddress:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:HwAddress");
	case SOAP_TYPE_tt__IPv4Address:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:IPv4Address");
	case SOAP_TYPE_tt__Name:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:Name");
	case SOAP_TYPE_tt__ReferenceToken:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:ReferenceToken");
	case SOAP_TYPE_d__UriListType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "d:UriListType");
	case SOAP_TYPE_d__QNameListType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "d:QNameListType");
	case SOAP_TYPE_wsa__RelationshipTypeOpenEnum:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "wsa:RelationshipTypeOpenEnum");
	case SOAP_TYPE_xsd__token:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:token");
	case SOAP_TYPE_xsd__duration:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:duration");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:anyURI");
	case SOAP_TYPE_xsd__NCName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:NCName");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE___trt__GetSnapshotUri:
		soap_serialize___trt__GetSnapshotUri(soap, (const struct __trt__GetSnapshotUri *)ptr);
		break;
	case SOAP_TYPE___trt__GetStreamUri:
		soap_serialize___trt__GetStreamUri(soap, (const struct __trt__GetStreamUri *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioEncoderConfigurationOptions:
		soap_serialize___trt__GetAudioEncoderConfigurationOptions(soap, (const struct __trt__GetAudioEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioSourceConfigurationOptions:
		soap_serialize___trt__GetAudioSourceConfigurationOptions(soap, (const struct __trt__GetAudioSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoEncoderConfigurationOptions:
		soap_serialize___trt__GetVideoEncoderConfigurationOptions(soap, (const struct __trt__GetVideoEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoSourceConfigurationOptions:
		soap_serialize___trt__GetVideoSourceConfigurationOptions(soap, (const struct __trt__GetVideoSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__SetAudioEncoderConfiguration:
		soap_serialize___trt__SetAudioEncoderConfiguration(soap, (const struct __trt__SetAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__SetAudioSourceConfiguration:
		soap_serialize___trt__SetAudioSourceConfiguration(soap, (const struct __trt__SetAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__SetVideoEncoderConfiguration:
		soap_serialize___trt__SetVideoEncoderConfiguration(soap, (const struct __trt__SetVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__SetVideoSourceConfiguration:
		soap_serialize___trt__SetVideoSourceConfiguration(soap, (const struct __trt__SetVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleAudioSourceConfigurations:
		soap_serialize___trt__GetCompatibleAudioSourceConfigurations(soap, (const struct __trt__GetCompatibleAudioSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleAudioEncoderConfigurations:
		soap_serialize___trt__GetCompatibleAudioEncoderConfigurations(soap, (const struct __trt__GetCompatibleAudioEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleVideoSourceConfigurations:
		soap_serialize___trt__GetCompatibleVideoSourceConfigurations(soap, (const struct __trt__GetCompatibleVideoSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleVideoEncoderConfigurations:
		soap_serialize___trt__GetCompatibleVideoEncoderConfigurations(soap, (const struct __trt__GetCompatibleVideoEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioEncoderConfiguration:
		soap_serialize___trt__GetAudioEncoderConfiguration(soap, (const struct __trt__GetAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioSourceConfiguration:
		soap_serialize___trt__GetAudioSourceConfiguration(soap, (const struct __trt__GetAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoEncoderConfiguration:
		soap_serialize___trt__GetVideoEncoderConfiguration(soap, (const struct __trt__GetVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoSourceConfiguration:
		soap_serialize___trt__GetVideoSourceConfiguration(soap, (const struct __trt__GetVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioEncoderConfigurations:
		soap_serialize___trt__GetAudioEncoderConfigurations(soap, (const struct __trt__GetAudioEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioSourceConfigurations:
		soap_serialize___trt__GetAudioSourceConfigurations(soap, (const struct __trt__GetAudioSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoEncoderConfigurations:
		soap_serialize___trt__GetVideoEncoderConfigurations(soap, (const struct __trt__GetVideoEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoSourceConfigurations:
		soap_serialize___trt__GetVideoSourceConfigurations(soap, (const struct __trt__GetVideoSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__DeleteProfile:
		soap_serialize___trt__DeleteProfile(soap, (const struct __trt__DeleteProfile *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveAudioSourceConfiguration:
		soap_serialize___trt__RemoveAudioSourceConfiguration(soap, (const struct __trt__RemoveAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveAudioEncoderConfiguration:
		soap_serialize___trt__RemoveAudioEncoderConfiguration(soap, (const struct __trt__RemoveAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveVideoSourceConfiguration:
		soap_serialize___trt__RemoveVideoSourceConfiguration(soap, (const struct __trt__RemoveVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveVideoEncoderConfiguration:
		soap_serialize___trt__RemoveVideoEncoderConfiguration(soap, (const struct __trt__RemoveVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddAudioSourceConfiguration:
		soap_serialize___trt__AddAudioSourceConfiguration(soap, (const struct __trt__AddAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddAudioEncoderConfiguration:
		soap_serialize___trt__AddAudioEncoderConfiguration(soap, (const struct __trt__AddAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddVideoSourceConfiguration:
		soap_serialize___trt__AddVideoSourceConfiguration(soap, (const struct __trt__AddVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddVideoEncoderConfiguration:
		soap_serialize___trt__AddVideoEncoderConfiguration(soap, (const struct __trt__AddVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetProfiles:
		soap_serialize___trt__GetProfiles(soap, (const struct __trt__GetProfiles *)ptr);
		break;
	case SOAP_TYPE___trt__GetProfile:
		soap_serialize___trt__GetProfile(soap, (const struct __trt__GetProfile *)ptr);
		break;
	case SOAP_TYPE___trt__CreateProfile:
		soap_serialize___trt__CreateProfile(soap, (const struct __trt__CreateProfile *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioSources:
		soap_serialize___trt__GetAudioSources(soap, (const struct __trt__GetAudioSources *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoSources:
		soap_serialize___trt__GetVideoSources(soap, (const struct __trt__GetVideoSources *)ptr);
		break;
	case SOAP_TYPE___tds__SetZeroConfiguration:
		soap_serialize___tds__SetZeroConfiguration(soap, (const struct __tds__SetZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE___tds__GetZeroConfiguration:
		soap_serialize___tds__GetZeroConfiguration(soap, (const struct __tds__GetZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE___tds__SetNetworkDefaultGateway:
		soap_serialize___tds__SetNetworkDefaultGateway(soap, (const struct __tds__SetNetworkDefaultGateway *)ptr);
		break;
	case SOAP_TYPE___tds__GetNetworkDefaultGateway:
		soap_serialize___tds__GetNetworkDefaultGateway(soap, (const struct __tds__GetNetworkDefaultGateway *)ptr);
		break;
	case SOAP_TYPE___tds__SetNetworkInterfaces:
		soap_serialize___tds__SetNetworkInterfaces(soap, (const struct __tds__SetNetworkInterfaces *)ptr);
		break;
	case SOAP_TYPE___tds__GetNetworkInterfaces:
		soap_serialize___tds__GetNetworkInterfaces(soap, (const struct __tds__GetNetworkInterfaces *)ptr);
		break;
	case SOAP_TYPE___tds__SetDynamicDNS:
		soap_serialize___tds__SetDynamicDNS(soap, (const struct __tds__SetDynamicDNS *)ptr);
		break;
	case SOAP_TYPE___tds__GetDynamicDNS:
		soap_serialize___tds__GetDynamicDNS(soap, (const struct __tds__GetDynamicDNS *)ptr);
		break;
	case SOAP_TYPE___tds__SetNTP:
		soap_serialize___tds__SetNTP(soap, (const struct __tds__SetNTP *)ptr);
		break;
	case SOAP_TYPE___tds__GetNTP:
		soap_serialize___tds__GetNTP(soap, (const struct __tds__GetNTP *)ptr);
		break;
	case SOAP_TYPE___tds__SetDNS:
		soap_serialize___tds__SetDNS(soap, (const struct __tds__SetDNS *)ptr);
		break;
	case SOAP_TYPE___tds__GetDNS:
		soap_serialize___tds__GetDNS(soap, (const struct __tds__GetDNS *)ptr);
		break;
	case SOAP_TYPE___tds__SetHostname:
		soap_serialize___tds__SetHostname(soap, (const struct __tds__SetHostname *)ptr);
		break;
	case SOAP_TYPE___tds__GetHostname:
		soap_serialize___tds__GetHostname(soap, (const struct __tds__GetHostname *)ptr);
		break;
	case SOAP_TYPE___tds__GetCapabilities:
		soap_serialize___tds__GetCapabilities(soap, (const struct __tds__GetCapabilities *)ptr);
		break;
	case SOAP_TYPE___tds__GetWsdlUrl:
		soap_serialize___tds__GetWsdlUrl(soap, (const struct __tds__GetWsdlUrl *)ptr);
		break;
	case SOAP_TYPE___tds__SetUser:
		soap_serialize___tds__SetUser(soap, (const struct __tds__SetUser *)ptr);
		break;
	case SOAP_TYPE___tds__DeleteUsers:
		soap_serialize___tds__DeleteUsers(soap, (const struct __tds__DeleteUsers *)ptr);
		break;
	case SOAP_TYPE___tds__CreateUsers:
		soap_serialize___tds__CreateUsers(soap, (const struct __tds__CreateUsers *)ptr);
		break;
	case SOAP_TYPE___tds__GetUsers:
		soap_serialize___tds__GetUsers(soap, (const struct __tds__GetUsers *)ptr);
		break;
	case SOAP_TYPE___tds__SetDiscoveryMode:
		soap_serialize___tds__SetDiscoveryMode(soap, (const struct __tds__SetDiscoveryMode *)ptr);
		break;
	case SOAP_TYPE___tds__GetDiscoveryMode:
		soap_serialize___tds__GetDiscoveryMode(soap, (const struct __tds__GetDiscoveryMode *)ptr);
		break;
	case SOAP_TYPE___tds__RemoveScopes:
		soap_serialize___tds__RemoveScopes(soap, (const struct __tds__RemoveScopes *)ptr);
		break;
	case SOAP_TYPE___tds__AddScopes:
		soap_serialize___tds__AddScopes(soap, (const struct __tds__AddScopes *)ptr);
		break;
	case SOAP_TYPE___tds__SetScopes:
		soap_serialize___tds__SetScopes(soap, (const struct __tds__SetScopes *)ptr);
		break;
	case SOAP_TYPE___tds__GetScopes:
		soap_serialize___tds__GetScopes(soap, (const struct __tds__GetScopes *)ptr);
		break;
	case SOAP_TYPE___tds__SystemReboot:
		soap_serialize___tds__SystemReboot(soap, (const struct __tds__SystemReboot *)ptr);
		break;
	case SOAP_TYPE___tds__SetSystemFactoryDefault:
		soap_serialize___tds__SetSystemFactoryDefault(soap, (const struct __tds__SetSystemFactoryDefault *)ptr);
		break;
	case SOAP_TYPE___tds__GetSystemDateAndTime:
		soap_serialize___tds__GetSystemDateAndTime(soap, (const struct __tds__GetSystemDateAndTime *)ptr);
		break;
	case SOAP_TYPE___tds__SetSystemDateAndTime:
		soap_serialize___tds__SetSystemDateAndTime(soap, (const struct __tds__SetSystemDateAndTime *)ptr);
		break;
	case SOAP_TYPE___tds__GetDeviceInformation:
		soap_serialize___tds__GetDeviceInformation(soap, (const struct __tds__GetDeviceInformation *)ptr);
		break;
	case SOAP_TYPE___d__Probe:
		soap_serialize___d__Probe(soap, (const struct __d__Probe *)ptr);
		break;
	case SOAP_TYPE___d__Bye:
		soap_serialize___d__Bye(soap, (const struct __d__Bye *)ptr);
		break;
	case SOAP_TYPE___d__Hello:
		soap_serialize___d__Hello(soap, (const struct __d__Hello *)ptr);
		break;
	case SOAP_TYPE__wsu__Timestamp:
		soap_serialize__wsu__Timestamp(soap, (const struct wsu__TimestampType *)ptr);
		break;
	case SOAP_TYPE__wsse__Password:
		soap_serialize__wsse__Password(soap, (const struct wsse__PasswordString *)ptr);
		break;
	case SOAP_TYPE__wsse__Security:
		soap_serialize__wsse__Security(soap, (const struct wsse__SecurityHeaderType *)ptr);
		break;
	case SOAP_TYPE__wsse__UsernameToken:
		soap_serialize__wsse__UsernameToken(soap, (const struct wsse__UsernameTokenType *)ptr);
		break;
	case SOAP_TYPE__d__AppSequence:
		soap_serialize__d__AppSequence(soap, (const struct d__AppSequenceType *)ptr);
		break;
	case SOAP_TYPE__d__Scopes:
		soap_serialize__d__Scopes(soap, (const struct d__ScopesType *)ptr);
		break;
	case SOAP_TYPE__d__Resolve:
		soap_serialize__d__Resolve(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE__d__ByeResponse:
		soap_serialize__d__ByeResponse(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE__d__Bye:
		soap_serialize__d__Bye(soap, (const struct d__ByeType *)ptr);
		break;
	case SOAP_TYPE__d__ProbeMatches:
		soap_serialize__d__ProbeMatches(soap, (const struct d__ProbeMatchesType *)ptr);
		break;
	case SOAP_TYPE__d__Probe:
		soap_serialize__d__Probe(soap, (const struct d__ProbeType *)ptr);
		break;
	case SOAP_TYPE__d__HelloResponse:
		soap_serialize__d__HelloResponse(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE__d__Hello:
		soap_serialize__d__Hello(soap, (const struct d__HelloType *)ptr);
		break;
	case SOAP_TYPE__trt__Capabilities:
		soap_serialize__trt__Capabilities(soap, (const struct trt__Capabilities *)ptr);
		break;
	case SOAP_TYPE__wsa__Action:
		soap_serialize__wsa__Action(soap, (const struct wsa__AttributedURIType *)ptr);
		break;
	case SOAP_TYPE__wsa__To:
		soap_serialize__wsa__To(soap, (const struct wsa__AttributedURIType *)ptr);
		break;
	case SOAP_TYPE__wsa__FaultTo:
		soap_serialize__wsa__FaultTo(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__From:
		soap_serialize__wsa__From(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__ReplyTo:
		soap_serialize__wsa__ReplyTo(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__RelatesTo:
		soap_serialize__wsa__RelatesTo(soap, (const struct wsa__RelatesToType *)ptr);
		break;
	case SOAP_TYPE__wsa__MessageID:
		soap_serialize__wsa__MessageID(soap, (const struct wsa__AttributedURIType *)ptr);
		break;
	case SOAP_TYPE__wsa__Metadata:
		soap_serialize__wsa__Metadata(soap, (const struct wsa__MetadataType *)ptr);
		break;
	case SOAP_TYPE__wsa__EndpointReference:
		soap_serialize__wsa__EndpointReference(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__tt__AudioEncoderConfiguration:
		soap_serialize__tt__AudioEncoderConfiguration(soap, (const struct tt__AudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__tt__VideoEncoderConfiguration:
		soap_serialize__tt__VideoEncoderConfiguration(soap, (const struct tt__VideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__tt__AudioSourceConfiguration:
		soap_serialize__tt__AudioSourceConfiguration(soap, (const struct tt__AudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__tt__VideoSourceConfiguration:
		soap_serialize__tt__VideoSourceConfiguration(soap, (const struct tt__VideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__wsadis__FaultTo:
		soap_serialize__wsadis__FaultTo(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsadis__ReplyTo:
		soap_serialize__wsadis__ReplyTo(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsadis__From:
		soap_serialize__wsadis__From(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsadis__Action:
		soap_serialize__wsadis__Action(soap, (const struct wsadis__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsadis__To:
		soap_serialize__wsadis__To(soap, (const struct wsadis__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsadis__RelatesTo:
		soap_serialize__wsadis__RelatesTo(soap, (const struct wsadis__Relationship *)ptr);
		break;
	case SOAP_TYPE__wsadis__MessageID:
		soap_serialize__wsadis__MessageID(soap, (const struct wsadis__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsadis__EndpointReference:
		soap_serialize__wsadis__EndpointReference(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_wsu__TimestampType:
		soap_serialize_wsu__TimestampType(soap, (const struct wsu__TimestampType *)ptr);
		break;
	case SOAP_TYPE_wsse__SecurityHeaderType:
		soap_serialize_wsse__SecurityHeaderType(soap, (const struct wsse__SecurityHeaderType *)ptr);
		break;
	case SOAP_TYPE_wsse__UsernameTokenType:
		soap_serialize_wsse__UsernameTokenType(soap, (const struct wsse__UsernameTokenType *)ptr);
		break;
	case SOAP_TYPE_wsse__PasswordString:
		soap_serialize_wsse__PasswordString(soap, (const struct wsse__PasswordString *)ptr);
		break;
	case SOAP_TYPE_d__AppSequenceType:
		soap_serialize_d__AppSequenceType(soap, (const struct d__AppSequenceType *)ptr);
		break;
	case SOAP_TYPE_d__ScopesType:
		soap_serialize_d__ScopesType(soap, (const struct d__ScopesType *)ptr);
		break;
	case SOAP_TYPE_d__ResolveType:
		soap_serialize_d__ResolveType(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeMatchType:
		soap_serialize_d__ProbeMatchType(soap, (const struct d__ProbeMatchType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeMatchesType:
		soap_serialize_d__ProbeMatchesType(soap, (const struct d__ProbeMatchesType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeType:
		soap_serialize_d__ProbeType(soap, (const struct d__ProbeType *)ptr);
		break;
	case SOAP_TYPE_d__ByeType:
		soap_serialize_d__ByeType(soap, (const struct d__ByeType *)ptr);
		break;
	case SOAP_TYPE_d__HelloType:
		soap_serialize_d__HelloType(soap, (const struct d__HelloType *)ptr);
		break;
	case SOAP_TYPE__trt__GetSnapshotUriResponse:
		soap_serialize__trt__GetSnapshotUriResponse(soap, (const struct _trt__GetSnapshotUriResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetSnapshotUri:
		soap_serialize__trt__GetSnapshotUri(soap, (const struct _trt__GetSnapshotUri *)ptr);
		break;
	case SOAP_TYPE__trt__GetStreamUriResponse:
		soap_serialize__trt__GetStreamUriResponse(soap, (const struct _trt__GetStreamUriResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetStreamUri:
		soap_serialize__trt__GetStreamUri(soap, (const struct _trt__GetStreamUri *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse:
		soap_serialize__trt__GetAudioEncoderConfigurationOptionsResponse(soap, (const struct _trt__GetAudioEncoderConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions:
		soap_serialize__trt__GetAudioEncoderConfigurationOptions(soap, (const struct _trt__GetAudioEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse:
		soap_serialize__trt__GetAudioSourceConfigurationOptionsResponse(soap, (const struct _trt__GetAudioSourceConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurationOptions:
		soap_serialize__trt__GetAudioSourceConfigurationOptions(soap, (const struct _trt__GetAudioSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse:
		soap_serialize__trt__GetVideoEncoderConfigurationOptionsResponse(soap, (const struct _trt__GetVideoEncoderConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions:
		soap_serialize__trt__GetVideoEncoderConfigurationOptions(soap, (const struct _trt__GetVideoEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse:
		soap_serialize__trt__GetVideoSourceConfigurationOptionsResponse(soap, (const struct _trt__GetVideoSourceConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurationOptions:
		soap_serialize__trt__GetVideoSourceConfigurationOptions(soap, (const struct _trt__GetVideoSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__SetAudioSourceConfigurationResponse:
		soap_serialize__trt__SetAudioSourceConfigurationResponse(soap, (const struct _trt__SetAudioSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetAudioSourceConfiguration:
		soap_serialize__trt__SetAudioSourceConfiguration(soap, (const struct _trt__SetAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse:
		soap_serialize__trt__SetAudioEncoderConfigurationResponse(soap, (const struct _trt__SetAudioEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetAudioEncoderConfiguration:
		soap_serialize__trt__SetAudioEncoderConfiguration(soap, (const struct _trt__SetAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__SetVideoSourceConfigurationResponse:
		soap_serialize__trt__SetVideoSourceConfigurationResponse(soap, (const struct _trt__SetVideoSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetVideoSourceConfiguration:
		soap_serialize__trt__SetVideoSourceConfiguration(soap, (const struct _trt__SetVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse:
		soap_serialize__trt__SetVideoEncoderConfigurationResponse(soap, (const struct _trt__SetVideoEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetVideoEncoderConfiguration:
		soap_serialize__trt__SetVideoEncoderConfiguration(soap, (const struct _trt__SetVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse:
		soap_serialize__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, (const struct _trt__GetCompatibleAudioSourceConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations:
		soap_serialize__trt__GetCompatibleAudioSourceConfigurations(soap, (const struct _trt__GetCompatibleAudioSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse:
		soap_serialize__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, (const struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations:
		soap_serialize__trt__GetCompatibleAudioEncoderConfigurations(soap, (const struct _trt__GetCompatibleAudioEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse:
		soap_serialize__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, (const struct _trt__GetCompatibleVideoSourceConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations:
		soap_serialize__trt__GetCompatibleVideoSourceConfigurations(soap, (const struct _trt__GetCompatibleVideoSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse:
		soap_serialize__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, (const struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations:
		soap_serialize__trt__GetCompatibleVideoEncoderConfigurations(soap, (const struct _trt__GetCompatibleVideoEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse:
		soap_serialize__trt__GetAudioEncoderConfigurationResponse(soap, (const struct _trt__GetAudioEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfiguration:
		soap_serialize__trt__GetAudioEncoderConfiguration(soap, (const struct _trt__GetAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurationResponse:
		soap_serialize__trt__GetAudioSourceConfigurationResponse(soap, (const struct _trt__GetAudioSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfiguration:
		soap_serialize__trt__GetAudioSourceConfiguration(soap, (const struct _trt__GetAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse:
		soap_serialize__trt__GetVideoEncoderConfigurationResponse(soap, (const struct _trt__GetVideoEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfiguration:
		soap_serialize__trt__GetVideoEncoderConfiguration(soap, (const struct _trt__GetVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurationResponse:
		soap_serialize__trt__GetVideoSourceConfigurationResponse(soap, (const struct _trt__GetVideoSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfiguration:
		soap_serialize__trt__GetVideoSourceConfiguration(soap, (const struct _trt__GetVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse:
		soap_serialize__trt__GetAudioSourceConfigurationsResponse(soap, (const struct _trt__GetAudioSourceConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurations:
		soap_serialize__trt__GetAudioSourceConfigurations(soap, (const struct _trt__GetAudioSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse:
		soap_serialize__trt__GetAudioEncoderConfigurationsResponse(soap, (const struct _trt__GetAudioEncoderConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurations:
		soap_serialize__trt__GetAudioEncoderConfigurations(soap, (const struct _trt__GetAudioEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse:
		soap_serialize__trt__GetVideoSourceConfigurationsResponse(soap, (const struct _trt__GetVideoSourceConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurations:
		soap_serialize__trt__GetVideoSourceConfigurations(soap, (const struct _trt__GetVideoSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse:
		soap_serialize__trt__GetVideoEncoderConfigurationsResponse(soap, (const struct _trt__GetVideoEncoderConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurations:
		soap_serialize__trt__GetVideoEncoderConfigurations(soap, (const struct _trt__GetVideoEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__DeleteProfileResponse:
		soap_serialize__trt__DeleteProfileResponse(soap, (const struct _trt__DeleteProfileResponse *)ptr);
		break;
	case SOAP_TYPE__trt__DeleteProfile:
		soap_serialize__trt__DeleteProfile(soap, (const struct _trt__DeleteProfile *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse:
		soap_serialize__trt__RemoveAudioSourceConfigurationResponse(soap, (const struct _trt__RemoveAudioSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveAudioSourceConfiguration:
		soap_serialize__trt__RemoveAudioSourceConfiguration(soap, (const struct _trt__RemoveAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddAudioSourceConfigurationResponse:
		soap_serialize__trt__AddAudioSourceConfigurationResponse(soap, (const struct _trt__AddAudioSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddAudioSourceConfiguration:
		soap_serialize__trt__AddAudioSourceConfiguration(soap, (const struct _trt__AddAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse:
		soap_serialize__trt__RemoveAudioEncoderConfigurationResponse(soap, (const struct _trt__RemoveAudioEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveAudioEncoderConfiguration:
		soap_serialize__trt__RemoveAudioEncoderConfiguration(soap, (const struct _trt__RemoveAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse:
		soap_serialize__trt__AddAudioEncoderConfigurationResponse(soap, (const struct _trt__AddAudioEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddAudioEncoderConfiguration:
		soap_serialize__trt__AddAudioEncoderConfiguration(soap, (const struct _trt__AddAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse:
		soap_serialize__trt__RemoveVideoSourceConfigurationResponse(soap, (const struct _trt__RemoveVideoSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveVideoSourceConfiguration:
		soap_serialize__trt__RemoveVideoSourceConfiguration(soap, (const struct _trt__RemoveVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddVideoSourceConfigurationResponse:
		soap_serialize__trt__AddVideoSourceConfigurationResponse(soap, (const struct _trt__AddVideoSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddVideoSourceConfiguration:
		soap_serialize__trt__AddVideoSourceConfiguration(soap, (const struct _trt__AddVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse:
		soap_serialize__trt__RemoveVideoEncoderConfigurationResponse(soap, (const struct _trt__RemoveVideoEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveVideoEncoderConfiguration:
		soap_serialize__trt__RemoveVideoEncoderConfiguration(soap, (const struct _trt__RemoveVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse:
		soap_serialize__trt__AddVideoEncoderConfigurationResponse(soap, (const struct _trt__AddVideoEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddVideoEncoderConfiguration:
		soap_serialize__trt__AddVideoEncoderConfiguration(soap, (const struct _trt__AddVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetProfilesResponse:
		soap_serialize__trt__GetProfilesResponse(soap, (const struct _trt__GetProfilesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetProfiles:
		soap_serialize__trt__GetProfiles(soap, (const struct _trt__GetProfiles *)ptr);
		break;
	case SOAP_TYPE__trt__GetProfileResponse:
		soap_serialize__trt__GetProfileResponse(soap, (const struct _trt__GetProfileResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetProfile:
		soap_serialize__trt__GetProfile(soap, (const struct _trt__GetProfile *)ptr);
		break;
	case SOAP_TYPE__trt__CreateProfileResponse:
		soap_serialize__trt__CreateProfileResponse(soap, (const struct _trt__CreateProfileResponse *)ptr);
		break;
	case SOAP_TYPE__trt__CreateProfile:
		soap_serialize__trt__CreateProfile(soap, (const struct _trt__CreateProfile *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourcesResponse:
		soap_serialize__trt__GetAudioSourcesResponse(soap, (const struct _trt__GetAudioSourcesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSources:
		soap_serialize__trt__GetAudioSources(soap, (const struct _trt__GetAudioSources *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourcesResponse:
		soap_serialize__trt__GetVideoSourcesResponse(soap, (const struct _trt__GetVideoSourcesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSources:
		soap_serialize__trt__GetVideoSources(soap, (const struct _trt__GetVideoSources *)ptr);
		break;
	case SOAP_TYPE__trt__GetServiceCapabilitiesResponse:
		soap_serialize__trt__GetServiceCapabilitiesResponse(soap, (const struct _trt__GetServiceCapabilitiesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetServiceCapabilities:
		soap_serialize__trt__GetServiceCapabilities(soap, (const struct _trt__GetServiceCapabilities *)ptr);
		break;
	case SOAP_TYPE_trt__StreamingCapabilities:
		soap_serialize_trt__StreamingCapabilities(soap, (const struct trt__StreamingCapabilities *)ptr);
		break;
	case SOAP_TYPE_trt__ProfileCapabilities:
		soap_serialize_trt__ProfileCapabilities(soap, (const struct trt__ProfileCapabilities *)ptr);
		break;
	case SOAP_TYPE_trt__Capabilities:
		soap_serialize_trt__Capabilities(soap, (const struct trt__Capabilities *)ptr);
		break;
	case SOAP_TYPE_wsa__AttributedURIType:
		soap_serialize_wsa__AttributedURIType(soap, (const struct wsa__AttributedURIType *)ptr);
		break;
	case SOAP_TYPE_wsa__RelatesToType:
		soap_serialize_wsa__RelatesToType(soap, (const struct wsa__RelatesToType *)ptr);
		break;
	case SOAP_TYPE_wsa__MetadataType:
		soap_serialize_wsa__MetadataType(soap, (const struct wsa__MetadataType *)ptr);
		break;
	case SOAP_TYPE_wsa__ReferenceParametersType:
		soap_serialize_wsa__ReferenceParametersType(soap, (const struct wsa__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE_wsa__EndpointReferenceType:
		soap_serialize_wsa__EndpointReferenceType(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_tt__Rectangle:
		soap_serialize_tt__Rectangle(soap, (const struct tt__Rectangle *)ptr);
		break;
	case SOAP_TYPE_tt__WhiteBalance:
		soap_serialize_tt__WhiteBalance(soap, (const struct tt__WhiteBalance *)ptr);
		break;
	case SOAP_TYPE_tt__WhiteBalanceOptions:
		soap_serialize_tt__WhiteBalanceOptions(soap, (const struct tt__WhiteBalanceOptions *)ptr);
		break;
	case SOAP_TYPE_tt__ExposureOptions:
		soap_serialize_tt__ExposureOptions(soap, (const struct tt__ExposureOptions *)ptr);
		break;
	case SOAP_TYPE_tt__FocusOptions:
		soap_serialize_tt__FocusOptions(soap, (const struct tt__FocusOptions *)ptr);
		break;
	case SOAP_TYPE_tt__BacklightCompensationOptions:
		soap_serialize_tt__BacklightCompensationOptions(soap, (const struct tt__BacklightCompensationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__WideDynamicRangeOptions:
		soap_serialize_tt__WideDynamicRangeOptions(soap, (const struct tt__WideDynamicRangeOptions *)ptr);
		break;
	case SOAP_TYPE_tt__ImagingOptions:
		soap_serialize_tt__ImagingOptions(soap, (const struct tt__ImagingOptions *)ptr);
		break;
	case SOAP_TYPE_tt__BacklightCompensation:
		soap_serialize_tt__BacklightCompensation(soap, (const struct tt__BacklightCompensation *)ptr);
		break;
	case SOAP_TYPE_tt__WideDynamicRange:
		soap_serialize_tt__WideDynamicRange(soap, (const struct tt__WideDynamicRange *)ptr);
		break;
	case SOAP_TYPE_tt__Exposure:
		soap_serialize_tt__Exposure(soap, (const struct tt__Exposure *)ptr);
		break;
	case SOAP_TYPE_tt__ImagingSettings:
		soap_serialize_tt__ImagingSettings(soap, (const struct tt__ImagingSettings *)ptr);
		break;
	case SOAP_TYPE_tt__FocusConfiguration:
		soap_serialize_tt__FocusConfiguration(soap, (const struct tt__FocusConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__User:
		soap_serialize_tt__User(soap, (const struct tt__User *)ptr);
		break;
	case SOAP_TYPE_tt__TimeZone:
		soap_serialize_tt__TimeZone(soap, (const struct tt__TimeZone *)ptr);
		break;
	case SOAP_TYPE_tt__Time:
		soap_serialize_tt__Time(soap, (const struct tt__Time *)ptr);
		break;
	case SOAP_TYPE_tt__Date:
		soap_serialize_tt__Date(soap, (const struct tt__Date *)ptr);
		break;
	case SOAP_TYPE_tt__DateTime:
		soap_serialize_tt__DateTime(soap, (const struct tt__DateTime *)ptr);
		break;
	case SOAP_TYPE_tt__SystemDateTime:
		soap_serialize_tt__SystemDateTime(soap, (const struct tt__SystemDateTime *)ptr);
		break;
	case SOAP_TYPE_tt__AnalyticsDeviceCapabilities:
		soap_serialize_tt__AnalyticsDeviceCapabilities(soap, (const struct tt__AnalyticsDeviceCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__ReceiverCapabilities:
		soap_serialize_tt__ReceiverCapabilities(soap, (const struct tt__ReceiverCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__ReplayCapabilities:
		soap_serialize_tt__ReplayCapabilities(soap, (const struct tt__ReplayCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__SearchCapabilities:
		soap_serialize_tt__SearchCapabilities(soap, (const struct tt__SearchCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__RecordingCapabilities:
		soap_serialize_tt__RecordingCapabilities(soap, (const struct tt__RecordingCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__DisplayCapabilities:
		soap_serialize_tt__DisplayCapabilities(soap, (const struct tt__DisplayCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__DeviceIOCapabilities:
		soap_serialize_tt__DeviceIOCapabilities(soap, (const struct tt__DeviceIOCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__PTZCapabilities:
		soap_serialize_tt__PTZCapabilities(soap, (const struct tt__PTZCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__ImagingCapabilities:
		soap_serialize_tt__ImagingCapabilities(soap, (const struct tt__ImagingCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__OnvifVersion:
		soap_serialize_tt__OnvifVersion(soap, (const struct tt__OnvifVersion *)ptr);
		break;
	case SOAP_TYPE_tt__SystemCapabilities:
		soap_serialize_tt__SystemCapabilities(soap, (const struct tt__SystemCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__SecurityCapabilities:
		soap_serialize_tt__SecurityCapabilities(soap, (const struct tt__SecurityCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkCapabilities:
		soap_serialize_tt__NetworkCapabilities(soap, (const struct tt__NetworkCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__ProfileCapabilities:
		soap_serialize_tt__ProfileCapabilities(soap, (const struct tt__ProfileCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__RealTimeStreamingCapabilities:
		soap_serialize_tt__RealTimeStreamingCapabilities(soap, (const struct tt__RealTimeStreamingCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__MediaCapabilities:
		soap_serialize_tt__MediaCapabilities(soap, (const struct tt__MediaCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__IOCapabilities:
		soap_serialize_tt__IOCapabilities(soap, (const struct tt__IOCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__EventCapabilities:
		soap_serialize_tt__EventCapabilities(soap, (const struct tt__EventCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__DeviceCapabilities:
		soap_serialize_tt__DeviceCapabilities(soap, (const struct tt__DeviceCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__AnalyticsCapabilities:
		soap_serialize_tt__AnalyticsCapabilities(soap, (const struct tt__AnalyticsCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__CapabilitiesExtension:
		soap_serialize_tt__CapabilitiesExtension(soap, (const struct tt__CapabilitiesExtension *)ptr);
		break;
	case SOAP_TYPE_tt__Capabilities:
		soap_serialize_tt__Capabilities(soap, (const struct tt__Capabilities *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkZeroConfiguration:
		soap_serialize_tt__NetworkZeroConfiguration(soap, (const struct tt__NetworkZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkGateway:
		soap_serialize_tt__NetworkGateway(soap, (const struct tt__NetworkGateway *)ptr);
		break;
	case SOAP_TYPE_tt__IPv4NetworkInterfaceSetConfiguration:
		soap_serialize_tt__IPv4NetworkInterfaceSetConfiguration(soap, (const struct tt__IPv4NetworkInterfaceSetConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceSetConfigurationExtension:
		soap_serialize_tt__NetworkInterfaceSetConfigurationExtension(soap, (const struct tt__NetworkInterfaceSetConfigurationExtension *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceSetConfiguration:
		soap_serialize_tt__NetworkInterfaceSetConfiguration(soap, (const struct tt__NetworkInterfaceSetConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__DynamicDNSInformation:
		soap_serialize_tt__DynamicDNSInformation(soap, (const struct tt__DynamicDNSInformation *)ptr);
		break;
	case SOAP_TYPE_tt__NTPInformation:
		soap_serialize_tt__NTPInformation(soap, (const struct tt__NTPInformation *)ptr);
		break;
	case SOAP_TYPE_tt__DNSInformation:
		soap_serialize_tt__DNSInformation(soap, (const struct tt__DNSInformation *)ptr);
		break;
	case SOAP_TYPE_tt__HostnameInformation:
		soap_serialize_tt__HostnameInformation(soap, (const struct tt__HostnameInformation *)ptr);
		break;
	case SOAP_TYPE_tt__PrefixedIPv4Address:
		soap_serialize_tt__PrefixedIPv4Address(soap, (const struct tt__PrefixedIPv4Address *)ptr);
		break;
	case SOAP_TYPE_tt__IPAddress:
		soap_serialize_tt__IPAddress(soap, (const struct tt__IPAddress *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkHost:
		soap_serialize_tt__NetworkHost(soap, (const struct tt__NetworkHost *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkProtocol:
		soap_serialize_tt__NetworkProtocol(soap, (const struct tt__NetworkProtocol *)ptr);
		break;
	case SOAP_TYPE_tt__IPv4Configuration:
		soap_serialize_tt__IPv4Configuration(soap, (const struct tt__IPv4Configuration *)ptr);
		break;
	case SOAP_TYPE_tt__IPv4NetworkInterface:
		soap_serialize_tt__IPv4NetworkInterface(soap, (const struct tt__IPv4NetworkInterface *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceInfo:
		soap_serialize_tt__NetworkInterfaceInfo(soap, (const struct tt__NetworkInterfaceInfo *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceConnectionSetting:
		soap_serialize_tt__NetworkInterfaceConnectionSetting(soap, (const struct tt__NetworkInterfaceConnectionSetting *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceLink:
		soap_serialize_tt__NetworkInterfaceLink(soap, (const struct tt__NetworkInterfaceLink *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceExtension2:
		soap_serialize_tt__NetworkInterfaceExtension2(soap, (const struct tt__NetworkInterfaceExtension2 *)ptr);
		break;
	case SOAP_TYPE_tt__Dot3Configuration:
		soap_serialize_tt__Dot3Configuration(soap, (const struct tt__Dot3Configuration *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceExtension:
		soap_serialize_tt__NetworkInterfaceExtension(soap, (const struct tt__NetworkInterfaceExtension *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterface:
		soap_serialize_tt__NetworkInterface(soap, (const struct tt__NetworkInterface *)ptr);
		break;
	case SOAP_TYPE_tt__Scope:
		soap_serialize_tt__Scope(soap, (const struct tt__Scope *)ptr);
		break;
	case SOAP_TYPE_tt__MediaUri:
		soap_serialize_tt__MediaUri(soap, (const struct tt__MediaUri *)ptr);
		break;
	case SOAP_TYPE_tt__Transport:
		soap_serialize_tt__Transport(soap, (const struct tt__Transport *)ptr);
		break;
	case SOAP_TYPE_tt__StreamSetup:
		soap_serialize_tt__StreamSetup(soap, (const struct tt__StreamSetup *)ptr);
		break;
	case SOAP_TYPE_tt__MulticastConfiguration:
		soap_serialize_tt__MulticastConfiguration(soap, (const struct tt__MulticastConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__AudioEncoderConfigurationOption:
		soap_serialize_tt__AudioEncoderConfigurationOption(soap, (const struct tt__AudioEncoderConfigurationOption *)ptr);
		break;
	case SOAP_TYPE_tt__AudioEncoderConfigurationOptions:
		soap_serialize_tt__AudioEncoderConfigurationOptions(soap, (const struct tt__AudioEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__AudioEncoderConfiguration:
		soap_serialize_tt__AudioEncoderConfiguration(soap, (const struct tt__AudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__AudioSourceConfigurationOptions:
		soap_serialize_tt__AudioSourceConfigurationOptions(soap, (const struct tt__AudioSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__AudioSourceConfiguration:
		soap_serialize_tt__AudioSourceConfiguration(soap, (const struct tt__AudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__H264Options:
		soap_serialize_tt__H264Options(soap, (const struct tt__H264Options *)ptr);
		break;
	case SOAP_TYPE_tt__Mpeg4Options:
		soap_serialize_tt__Mpeg4Options(soap, (const struct tt__Mpeg4Options *)ptr);
		break;
	case SOAP_TYPE_tt__JpegOptions:
		soap_serialize_tt__JpegOptions(soap, (const struct tt__JpegOptions *)ptr);
		break;
	case SOAP_TYPE_tt__VideoEncoderConfigurationOptions:
		soap_serialize_tt__VideoEncoderConfigurationOptions(soap, (const struct tt__VideoEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__H264Configuration:
		soap_serialize_tt__H264Configuration(soap, (const struct tt__H264Configuration *)ptr);
		break;
	case SOAP_TYPE_tt__Mpeg4Configuration:
		soap_serialize_tt__Mpeg4Configuration(soap, (const struct tt__Mpeg4Configuration *)ptr);
		break;
	case SOAP_TYPE_tt__VideoRateControl:
		soap_serialize_tt__VideoRateControl(soap, (const struct tt__VideoRateControl *)ptr);
		break;
	case SOAP_TYPE_tt__VideoResolution:
		soap_serialize_tt__VideoResolution(soap, (const struct tt__VideoResolution *)ptr);
		break;
	case SOAP_TYPE_tt__VideoEncoderConfiguration:
		soap_serialize_tt__VideoEncoderConfiguration(soap, (const struct tt__VideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__VideoSourceConfigurationOptions:
		soap_serialize_tt__VideoSourceConfigurationOptions(soap, (const struct tt__VideoSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__VideoSourceConfiguration:
		soap_serialize_tt__VideoSourceConfiguration(soap, (const struct tt__VideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__ConfigurationEntity:
		soap_serialize_tt__ConfigurationEntity(soap, (const struct tt__ConfigurationEntity *)ptr);
		break;
	case SOAP_TYPE_tt__Profile:
		soap_serialize_tt__Profile(soap, (const struct tt__Profile *)ptr);
		break;
	case SOAP_TYPE_tt__AudioSource:
		soap_serialize_tt__AudioSource(soap, (const struct tt__AudioSource *)ptr);
		break;
	case SOAP_TYPE_tt__VideoSource:
		soap_serialize_tt__VideoSource(soap, (const struct tt__VideoSource *)ptr);
		break;
	case SOAP_TYPE_tt__IntList:
		soap_serialize_tt__IntList(soap, (const struct tt__IntList *)ptr);
		break;
	case SOAP_TYPE_tt__FloatRange:
		soap_serialize_tt__FloatRange(soap, (const struct tt__FloatRange *)ptr);
		break;
	case SOAP_TYPE_tt__IntRange:
		soap_serialize_tt__IntRange(soap, (const struct tt__IntRange *)ptr);
		break;
	case SOAP_TYPE_tt__IntRectangleRange:
		soap_serialize_tt__IntRectangleRange(soap, (const struct tt__IntRectangleRange *)ptr);
		break;
	case SOAP_TYPE_tt__IntRectangle:
		soap_serialize_tt__IntRectangle(soap, (const struct tt__IntRectangle *)ptr);
		break;
	case SOAP_TYPE_tt__DeviceEntity:
		soap_serialize_tt__DeviceEntity(soap, (const struct tt__DeviceEntity *)ptr);
		break;
	case SOAP_TYPE__tds__SetZeroConfigurationResponse:
		soap_serialize__tds__SetZeroConfigurationResponse(soap, (const struct _tds__SetZeroConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetZeroConfiguration:
		soap_serialize__tds__SetZeroConfiguration(soap, (const struct _tds__SetZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE__tds__GetZeroConfigurationResponse:
		soap_serialize__tds__GetZeroConfigurationResponse(soap, (const struct _tds__GetZeroConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetZeroConfiguration:
		soap_serialize__tds__GetZeroConfiguration(soap, (const struct _tds__GetZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkDefaultGatewayResponse:
		soap_serialize__tds__SetNetworkDefaultGatewayResponse(soap, (const struct _tds__SetNetworkDefaultGatewayResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkDefaultGateway:
		soap_serialize__tds__SetNetworkDefaultGateway(soap, (const struct _tds__SetNetworkDefaultGateway *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkDefaultGatewayResponse:
		soap_serialize__tds__GetNetworkDefaultGatewayResponse(soap, (const struct _tds__GetNetworkDefaultGatewayResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkDefaultGateway:
		soap_serialize__tds__GetNetworkDefaultGateway(soap, (const struct _tds__GetNetworkDefaultGateway *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkInterfacesResponse:
		soap_serialize__tds__SetNetworkInterfacesResponse(soap, (const struct _tds__SetNetworkInterfacesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkInterfaces:
		soap_serialize__tds__SetNetworkInterfaces(soap, (const struct _tds__SetNetworkInterfaces *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkInterfacesResponse:
		soap_serialize__tds__GetNetworkInterfacesResponse(soap, (const struct _tds__GetNetworkInterfacesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkInterfaces:
		soap_serialize__tds__GetNetworkInterfaces(soap, (const struct _tds__GetNetworkInterfaces *)ptr);
		break;
	case SOAP_TYPE__tds__SetDynamicDNSResponse:
		soap_serialize__tds__SetDynamicDNSResponse(soap, (const struct _tds__SetDynamicDNSResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetDynamicDNS:
		soap_serialize__tds__SetDynamicDNS(soap, (const struct _tds__SetDynamicDNS *)ptr);
		break;
	case SOAP_TYPE__tds__GetDynamicDNSResponse:
		soap_serialize__tds__GetDynamicDNSResponse(soap, (const struct _tds__GetDynamicDNSResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetDynamicDNS:
		soap_serialize__tds__GetDynamicDNS(soap, (const struct _tds__GetDynamicDNS *)ptr);
		break;
	case SOAP_TYPE__tds__SetNTPResponse:
		soap_serialize__tds__SetNTPResponse(soap, (const struct _tds__SetNTPResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetNTP:
		soap_serialize__tds__SetNTP(soap, (const struct _tds__SetNTP *)ptr);
		break;
	case SOAP_TYPE__tds__GetNTPResponse:
		soap_serialize__tds__GetNTPResponse(soap, (const struct _tds__GetNTPResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetNTP:
		soap_serialize__tds__GetNTP(soap, (const struct _tds__GetNTP *)ptr);
		break;
	case SOAP_TYPE__tds__SetDNSResponse:
		soap_serialize__tds__SetDNSResponse(soap, (const struct _tds__SetDNSResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetDNS:
		soap_serialize__tds__SetDNS(soap, (const struct _tds__SetDNS *)ptr);
		break;
	case SOAP_TYPE__tds__GetDNSResponse:
		soap_serialize__tds__GetDNSResponse(soap, (const struct _tds__GetDNSResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetDNS:
		soap_serialize__tds__GetDNS(soap, (const struct _tds__GetDNS *)ptr);
		break;
	case SOAP_TYPE__tds__SetHostnameResponse:
		soap_serialize__tds__SetHostnameResponse(soap, (const struct _tds__SetHostnameResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetHostname:
		soap_serialize__tds__SetHostname(soap, (const struct _tds__SetHostname *)ptr);
		break;
	case SOAP_TYPE__tds__GetHostnameResponse:
		soap_serialize__tds__GetHostnameResponse(soap, (const struct _tds__GetHostnameResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetHostname:
		soap_serialize__tds__GetHostname(soap, (const struct _tds__GetHostname *)ptr);
		break;
	case SOAP_TYPE__tds__GetCapabilitiesResponse:
		soap_serialize__tds__GetCapabilitiesResponse(soap, (const struct _tds__GetCapabilitiesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetCapabilities:
		soap_serialize__tds__GetCapabilities(soap, (const struct _tds__GetCapabilities *)ptr);
		break;
	case SOAP_TYPE__tds__GetWsdlUrlResponse:
		soap_serialize__tds__GetWsdlUrlResponse(soap, (const struct _tds__GetWsdlUrlResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetWsdlUrl:
		soap_serialize__tds__GetWsdlUrl(soap, (const struct _tds__GetWsdlUrl *)ptr);
		break;
	case SOAP_TYPE__tds__SetUserResponse:
		soap_serialize__tds__SetUserResponse(soap, (const struct _tds__SetUserResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetUser:
		soap_serialize__tds__SetUser(soap, (const struct _tds__SetUser *)ptr);
		break;
	case SOAP_TYPE__tds__DeleteUsersResponse:
		soap_serialize__tds__DeleteUsersResponse(soap, (const struct _tds__DeleteUsersResponse *)ptr);
		break;
	case SOAP_TYPE__tds__DeleteUsers:
		soap_serialize__tds__DeleteUsers(soap, (const struct _tds__DeleteUsers *)ptr);
		break;
	case SOAP_TYPE__tds__CreateUsersResponse:
		soap_serialize__tds__CreateUsersResponse(soap, (const struct _tds__CreateUsersResponse *)ptr);
		break;
	case SOAP_TYPE__tds__CreateUsers:
		soap_serialize__tds__CreateUsers(soap, (const struct _tds__CreateUsers *)ptr);
		break;
	case SOAP_TYPE__tds__GetUsersResponse:
		soap_serialize__tds__GetUsersResponse(soap, (const struct _tds__GetUsersResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetUsers:
		soap_serialize__tds__GetUsers(soap, (const struct _tds__GetUsers *)ptr);
		break;
	case SOAP_TYPE__tds__SetDiscoveryModeResponse:
		soap_serialize__tds__SetDiscoveryModeResponse(soap, (const struct _tds__SetDiscoveryModeResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetDiscoveryMode:
		soap_serialize__tds__SetDiscoveryMode(soap, (const struct _tds__SetDiscoveryMode *)ptr);
		break;
	case SOAP_TYPE__tds__GetDiscoveryModeResponse:
		soap_serialize__tds__GetDiscoveryModeResponse(soap, (const struct _tds__GetDiscoveryModeResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetDiscoveryMode:
		soap_serialize__tds__GetDiscoveryMode(soap, (const struct _tds__GetDiscoveryMode *)ptr);
		break;
	case SOAP_TYPE__tds__RemoveScopesResponse:
		soap_serialize__tds__RemoveScopesResponse(soap, (const struct _tds__RemoveScopesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__RemoveScopes:
		soap_serialize__tds__RemoveScopes(soap, (const struct _tds__RemoveScopes *)ptr);
		break;
	case SOAP_TYPE__tds__AddScopesResponse:
		soap_serialize__tds__AddScopesResponse(soap, (const struct _tds__AddScopesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__AddScopes:
		soap_serialize__tds__AddScopes(soap, (const struct _tds__AddScopes *)ptr);
		break;
	case SOAP_TYPE__tds__SetScopesResponse:
		soap_serialize__tds__SetScopesResponse(soap, (const struct _tds__SetScopesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetScopes:
		soap_serialize__tds__SetScopes(soap, (const struct _tds__SetScopes *)ptr);
		break;
	case SOAP_TYPE__tds__GetScopesResponse:
		soap_serialize__tds__GetScopesResponse(soap, (const struct _tds__GetScopesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetScopes:
		soap_serialize__tds__GetScopes(soap, (const struct _tds__GetScopes *)ptr);
		break;
	case SOAP_TYPE__tds__SystemRebootResponse:
		soap_serialize__tds__SystemRebootResponse(soap, (const struct _tds__SystemRebootResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SystemReboot:
		soap_serialize__tds__SystemReboot(soap, (const struct _tds__SystemReboot *)ptr);
		break;
	case SOAP_TYPE__tds__SetSystemFactoryDefaultResponse:
		soap_serialize__tds__SetSystemFactoryDefaultResponse(soap, (const struct _tds__SetSystemFactoryDefaultResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetSystemFactoryDefault:
		soap_serialize__tds__SetSystemFactoryDefault(soap, (const struct _tds__SetSystemFactoryDefault *)ptr);
		break;
	case SOAP_TYPE__tds__GetSystemDateAndTimeResponse:
		soap_serialize__tds__GetSystemDateAndTimeResponse(soap, (const struct _tds__GetSystemDateAndTimeResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetSystemDateAndTime:
		soap_serialize__tds__GetSystemDateAndTime(soap, (const struct _tds__GetSystemDateAndTime *)ptr);
		break;
	case SOAP_TYPE__tds__SetSystemDateAndTimeResponse:
		soap_serialize__tds__SetSystemDateAndTimeResponse(soap, (const struct _tds__SetSystemDateAndTimeResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetSystemDateAndTime:
		soap_serialize__tds__SetSystemDateAndTime(soap, (const struct _tds__SetSystemDateAndTime *)ptr);
		break;
	case SOAP_TYPE__tds__GetDeviceInformationResponse:
		soap_serialize__tds__GetDeviceInformationResponse(soap, (const struct _tds__GetDeviceInformationResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetDeviceInformation:
		soap_serialize__tds__GetDeviceInformation(soap, (const struct _tds__GetDeviceInformation *)ptr);
		break;
	case SOAP_TYPE_wsadis__AttributedURI:
		soap_serialize_wsadis__AttributedURI(soap, (const struct wsadis__AttributedURI *)ptr);
		break;
	case SOAP_TYPE_wsadis__AttributedQName:
		soap_serialize_wsadis__AttributedQName(soap, (const struct wsadis__AttributedQName *)ptr);
		break;
	case SOAP_TYPE_wsadis__Relationship:
		soap_serialize_wsadis__Relationship(soap, (const struct wsadis__Relationship *)ptr);
		break;
	case SOAP_TYPE_wsadis__ServiceNameType:
		soap_serialize_wsadis__ServiceNameType(soap, (const struct wsadis__ServiceNameType *)ptr);
		break;
	case SOAP_TYPE_wsadis__ReferenceParametersType:
		soap_serialize_wsadis__ReferenceParametersType(soap, (const struct wsadis__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE_wsadis__ReferencePropertiesType:
		soap_serialize_wsadis__ReferencePropertiesType(soap, (const struct wsadis__ReferencePropertiesType *)ptr);
		break;
	case SOAP_TYPE_wsadis__EndpointReferenceType:
		soap_serialize_wsadis__EndpointReferenceType(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__Security:
		soap_serialize_PointerTo_wsse__Security(soap, (struct wsse__SecurityHeaderType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_d__AppSequence:
		soap_serialize_PointerTo_d__AppSequence(soap, (struct d__AppSequenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		soap_serialize_PointerTo_wsa__FaultTo(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		soap_serialize_PointerTo_wsa__ReplyTo(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__From:
		soap_serialize_PointerTo_wsa__From(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		soap_serialize_PointerTo_wsa__RelatesTo(soap, (struct wsa__RelatesToType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUriResponse:
		soap_serialize_PointerTo_trt__GetSnapshotUriResponse(soap, (struct _trt__GetSnapshotUriResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUri:
		soap_serialize_PointerTo_trt__GetSnapshotUri(soap, (struct _trt__GetSnapshotUri *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetStreamUriResponse:
		soap_serialize_PointerTo_trt__GetStreamUriResponse(soap, (struct _trt__GetStreamUriResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetStreamUri:
		soap_serialize_PointerTo_trt__GetStreamUri(soap, (struct _trt__GetStreamUri *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse(soap, (struct _trt__GetAudioEncoderConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptions:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, (struct _trt__GetAudioEncoderConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse(soap, (struct _trt__GetAudioSourceConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptions:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, (struct _trt__GetAudioSourceConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse(soap, (struct _trt__GetVideoEncoderConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptions:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, (struct _trt__GetVideoEncoderConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse(soap, (struct _trt__GetVideoSourceConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptions:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, (struct _trt__GetVideoSourceConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__SetAudioEncoderConfigurationResponse(soap, (struct _trt__SetAudioEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfiguration:
		soap_serialize_PointerTo_trt__SetAudioEncoderConfiguration(soap, (struct _trt__SetAudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__SetAudioSourceConfigurationResponse(soap, (struct _trt__SetAudioSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfiguration:
		soap_serialize_PointerTo_trt__SetAudioSourceConfiguration(soap, (struct _trt__SetAudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__SetVideoEncoderConfigurationResponse(soap, (struct _trt__SetVideoEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfiguration:
		soap_serialize_PointerTo_trt__SetVideoEncoderConfiguration(soap, (struct _trt__SetVideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__SetVideoSourceConfigurationResponse(soap, (struct _trt__SetVideoSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfiguration:
		soap_serialize_PointerTo_trt__SetVideoSourceConfiguration(soap, (struct _trt__SetVideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse(soap, (struct _trt__GetCompatibleAudioSourceConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, (struct _trt__GetCompatibleAudioSourceConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, (struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, (struct _trt__GetCompatibleAudioEncoderConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse(soap, (struct _trt__GetCompatibleVideoSourceConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, (struct _trt__GetCompatibleVideoSourceConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, (struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, (struct _trt__GetCompatibleVideoEncoderConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationResponse(soap, (struct _trt__GetAudioEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfiguration:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfiguration(soap, (struct _trt__GetAudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurationResponse(soap, (struct _trt__GetAudioSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfiguration:
		soap_serialize_PointerTo_trt__GetAudioSourceConfiguration(soap, (struct _trt__GetAudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationResponse(soap, (struct _trt__GetVideoEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfiguration:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfiguration(soap, (struct _trt__GetVideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurationResponse(soap, (struct _trt__GetVideoSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfiguration:
		soap_serialize_PointerTo_trt__GetVideoSourceConfiguration(soap, (struct _trt__GetVideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationsResponse(soap, (struct _trt__GetAudioEncoderConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurations:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurations(soap, (struct _trt__GetAudioEncoderConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurationsResponse(soap, (struct _trt__GetAudioSourceConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurations:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurations(soap, (struct _trt__GetAudioSourceConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationsResponse(soap, (struct _trt__GetVideoEncoderConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurations:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurations(soap, (struct _trt__GetVideoEncoderConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurationsResponse(soap, (struct _trt__GetVideoSourceConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurations:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurations(soap, (struct _trt__GetVideoSourceConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__DeleteProfileResponse:
		soap_serialize_PointerTo_trt__DeleteProfileResponse(soap, (struct _trt__DeleteProfileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__DeleteProfile:
		soap_serialize_PointerTo_trt__DeleteProfile(soap, (struct _trt__DeleteProfile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveAudioSourceConfigurationResponse(soap, (struct _trt__RemoveAudioSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfiguration:
		soap_serialize_PointerTo_trt__RemoveAudioSourceConfiguration(soap, (struct _trt__RemoveAudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveAudioEncoderConfigurationResponse(soap, (struct _trt__RemoveAudioEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfiguration:
		soap_serialize_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, (struct _trt__RemoveAudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveVideoSourceConfigurationResponse(soap, (struct _trt__RemoveVideoSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfiguration:
		soap_serialize_PointerTo_trt__RemoveVideoSourceConfiguration(soap, (struct _trt__RemoveVideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveVideoEncoderConfigurationResponse(soap, (struct _trt__RemoveVideoEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfiguration:
		soap_serialize_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, (struct _trt__RemoveVideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__AddAudioSourceConfigurationResponse(soap, (struct _trt__AddAudioSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfiguration:
		soap_serialize_PointerTo_trt__AddAudioSourceConfiguration(soap, (struct _trt__AddAudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__AddAudioEncoderConfigurationResponse(soap, (struct _trt__AddAudioEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfiguration:
		soap_serialize_PointerTo_trt__AddAudioEncoderConfiguration(soap, (struct _trt__AddAudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__AddVideoSourceConfigurationResponse(soap, (struct _trt__AddVideoSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfiguration:
		soap_serialize_PointerTo_trt__AddVideoSourceConfiguration(soap, (struct _trt__AddVideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__AddVideoEncoderConfigurationResponse(soap, (struct _trt__AddVideoEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfiguration:
		soap_serialize_PointerTo_trt__AddVideoEncoderConfiguration(soap, (struct _trt__AddVideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetProfilesResponse:
		soap_serialize_PointerTo_trt__GetProfilesResponse(soap, (struct _trt__GetProfilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetProfiles:
		soap_serialize_PointerTo_trt__GetProfiles(soap, (struct _trt__GetProfiles *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetProfileResponse:
		soap_serialize_PointerTo_trt__GetProfileResponse(soap, (struct _trt__GetProfileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetProfile:
		soap_serialize_PointerTo_trt__GetProfile(soap, (struct _trt__GetProfile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__CreateProfileResponse:
		soap_serialize_PointerTo_trt__CreateProfileResponse(soap, (struct _trt__CreateProfileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__CreateProfile:
		soap_serialize_PointerTo_trt__CreateProfile(soap, (struct _trt__CreateProfile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourcesResponse:
		soap_serialize_PointerTo_trt__GetAudioSourcesResponse(soap, (struct _trt__GetAudioSourcesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSources:
		soap_serialize_PointerTo_trt__GetAudioSources(soap, (struct _trt__GetAudioSources *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourcesResponse:
		soap_serialize_PointerTo_trt__GetVideoSourcesResponse(soap, (struct _trt__GetVideoSourcesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSources:
		soap_serialize_PointerTo_trt__GetVideoSources(soap, (struct _trt__GetVideoSources *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetZeroConfigurationResponse:
		soap_serialize_PointerTo_tds__SetZeroConfigurationResponse(soap, (struct _tds__SetZeroConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetZeroConfiguration:
		soap_serialize_PointerTo_tds__SetZeroConfiguration(soap, (struct _tds__SetZeroConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetZeroConfigurationResponse:
		soap_serialize_PointerTo_tds__GetZeroConfigurationResponse(soap, (struct _tds__GetZeroConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetZeroConfiguration:
		soap_serialize_PointerTo_tds__GetZeroConfiguration(soap, (struct _tds__GetZeroConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGatewayResponse:
		soap_serialize_PointerTo_tds__SetNetworkDefaultGatewayResponse(soap, (struct _tds__SetNetworkDefaultGatewayResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGateway:
		soap_serialize_PointerTo_tds__SetNetworkDefaultGateway(soap, (struct _tds__SetNetworkDefaultGateway *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGatewayResponse:
		soap_serialize_PointerTo_tds__GetNetworkDefaultGatewayResponse(soap, (struct _tds__GetNetworkDefaultGatewayResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGateway:
		soap_serialize_PointerTo_tds__GetNetworkDefaultGateway(soap, (struct _tds__GetNetworkDefaultGateway *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfacesResponse:
		soap_serialize_PointerTo_tds__SetNetworkInterfacesResponse(soap, (struct _tds__SetNetworkInterfacesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfaces:
		soap_serialize_PointerTo_tds__SetNetworkInterfaces(soap, (struct _tds__SetNetworkInterfaces *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfacesResponse:
		soap_serialize_PointerTo_tds__GetNetworkInterfacesResponse(soap, (struct _tds__GetNetworkInterfacesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfaces:
		soap_serialize_PointerTo_tds__GetNetworkInterfaces(soap, (struct _tds__GetNetworkInterfaces *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNSResponse:
		soap_serialize_PointerTo_tds__SetDynamicDNSResponse(soap, (struct _tds__SetDynamicDNSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNS:
		soap_serialize_PointerTo_tds__SetDynamicDNS(soap, (struct _tds__SetDynamicDNS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNSResponse:
		soap_serialize_PointerTo_tds__GetDynamicDNSResponse(soap, (struct _tds__GetDynamicDNSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNS:
		soap_serialize_PointerTo_tds__GetDynamicDNS(soap, (struct _tds__GetDynamicDNS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNTPResponse:
		soap_serialize_PointerTo_tds__SetNTPResponse(soap, (struct _tds__SetNTPResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNTP:
		soap_serialize_PointerTo_tds__SetNTP(soap, (struct _tds__SetNTP *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNTPResponse:
		soap_serialize_PointerTo_tds__GetNTPResponse(soap, (struct _tds__GetNTPResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNTP:
		soap_serialize_PointerTo_tds__GetNTP(soap, (struct _tds__GetNTP *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDNSResponse:
		soap_serialize_PointerTo_tds__SetDNSResponse(soap, (struct _tds__SetDNSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDNS:
		soap_serialize_PointerTo_tds__SetDNS(soap, (struct _tds__SetDNS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDNSResponse:
		soap_serialize_PointerTo_tds__GetDNSResponse(soap, (struct _tds__GetDNSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDNS:
		soap_serialize_PointerTo_tds__GetDNS(soap, (struct _tds__GetDNS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetHostnameResponse:
		soap_serialize_PointerTo_tds__SetHostnameResponse(soap, (struct _tds__SetHostnameResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetHostname:
		soap_serialize_PointerTo_tds__SetHostname(soap, (struct _tds__SetHostname *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetHostnameResponse:
		soap_serialize_PointerTo_tds__GetHostnameResponse(soap, (struct _tds__GetHostnameResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetHostname:
		soap_serialize_PointerTo_tds__GetHostname(soap, (struct _tds__GetHostname *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetCapabilitiesResponse:
		soap_serialize_PointerTo_tds__GetCapabilitiesResponse(soap, (struct _tds__GetCapabilitiesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetCapabilities:
		soap_serialize_PointerTo_tds__GetCapabilities(soap, (struct _tds__GetCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrlResponse:
		soap_serialize_PointerTo_tds__GetWsdlUrlResponse(soap, (struct _tds__GetWsdlUrlResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrl:
		soap_serialize_PointerTo_tds__GetWsdlUrl(soap, (struct _tds__GetWsdlUrl *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetUserResponse:
		soap_serialize_PointerTo_tds__SetUserResponse(soap, (struct _tds__SetUserResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetUser:
		soap_serialize_PointerTo_tds__SetUser(soap, (struct _tds__SetUser *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__DeleteUsersResponse:
		soap_serialize_PointerTo_tds__DeleteUsersResponse(soap, (struct _tds__DeleteUsersResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__DeleteUsers:
		soap_serialize_PointerTo_tds__DeleteUsers(soap, (struct _tds__DeleteUsers *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__CreateUsersResponse:
		soap_serialize_PointerTo_tds__CreateUsersResponse(soap, (struct _tds__CreateUsersResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__CreateUsers:
		soap_serialize_PointerTo_tds__CreateUsers(soap, (struct _tds__CreateUsers *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetUsersResponse:
		soap_serialize_PointerTo_tds__GetUsersResponse(soap, (struct _tds__GetUsersResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetUsers:
		soap_serialize_PointerTo_tds__GetUsers(soap, (struct _tds__GetUsers *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryModeResponse:
		soap_serialize_PointerTo_tds__SetDiscoveryModeResponse(soap, (struct _tds__SetDiscoveryModeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryMode:
		soap_serialize_PointerTo_tds__SetDiscoveryMode(soap, (struct _tds__SetDiscoveryMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryModeResponse:
		soap_serialize_PointerTo_tds__GetDiscoveryModeResponse(soap, (struct _tds__GetDiscoveryModeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryMode:
		soap_serialize_PointerTo_tds__GetDiscoveryMode(soap, (struct _tds__GetDiscoveryMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__RemoveScopesResponse:
		soap_serialize_PointerTo_tds__RemoveScopesResponse(soap, (struct _tds__RemoveScopesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__RemoveScopes:
		soap_serialize_PointerTo_tds__RemoveScopes(soap, (struct _tds__RemoveScopes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__AddScopesResponse:
		soap_serialize_PointerTo_tds__AddScopesResponse(soap, (struct _tds__AddScopesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__AddScopes:
		soap_serialize_PointerTo_tds__AddScopes(soap, (struct _tds__AddScopes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetScopesResponse:
		soap_serialize_PointerTo_tds__SetScopesResponse(soap, (struct _tds__SetScopesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetScopes:
		soap_serialize_PointerTo_tds__SetScopes(soap, (struct _tds__SetScopes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetScopesResponse:
		soap_serialize_PointerTo_tds__GetScopesResponse(soap, (struct _tds__GetScopesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetScopes:
		soap_serialize_PointerTo_tds__GetScopes(soap, (struct _tds__GetScopes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SystemRebootResponse:
		soap_serialize_PointerTo_tds__SystemRebootResponse(soap, (struct _tds__SystemRebootResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SystemReboot:
		soap_serialize_PointerTo_tds__SystemReboot(soap, (struct _tds__SystemReboot *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefaultResponse:
		soap_serialize_PointerTo_tds__SetSystemFactoryDefaultResponse(soap, (struct _tds__SetSystemFactoryDefaultResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefault:
		soap_serialize_PointerTo_tds__SetSystemFactoryDefault(soap, (struct _tds__SetSystemFactoryDefault *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTimeResponse:
		soap_serialize_PointerTo_tds__GetSystemDateAndTimeResponse(soap, (struct _tds__GetSystemDateAndTimeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTime:
		soap_serialize_PointerTo_tds__GetSystemDateAndTime(soap, (struct _tds__GetSystemDateAndTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTimeResponse:
		soap_serialize_PointerTo_tds__SetSystemDateAndTimeResponse(soap, (struct _tds__SetSystemDateAndTimeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTime:
		soap_serialize_PointerTo_tds__SetSystemDateAndTime(soap, (struct _tds__SetSystemDateAndTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformationResponse:
		soap_serialize_PointerTo_tds__GetDeviceInformationResponse(soap, (struct _tds__GetDeviceInformationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformation:
		soap_serialize_PointerTo_tds__GetDeviceInformation(soap, (struct _tds__GetDeviceInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		soap_serialize_PointerTod__ProbeMatchesType(soap, (struct d__ProbeMatchesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeType:
		soap_serialize_PointerTod__ProbeType(soap, (struct d__ProbeType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ByeType:
		soap_serialize_PointerTod__ByeType(soap, (struct d__ByeType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ResolveType:
		soap_serialize_PointerTod__ResolveType(soap, (struct d__ResolveType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__HelloType:
		soap_serialize_PointerTod__HelloType(soap, (struct d__HelloType *const*)ptr);
		break;
	case SOAP_TYPE__wsu__Created:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsu__Id:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__d__XAddrs:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__d__Types:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension:
		soap_serialize_PointerTott__NetworkInterfaceExtension(soap, (struct tt__NetworkInterfaceExtension *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPv4NetworkInterface:
		soap_serialize_PointerTott__IPv4NetworkInterface(soap, (struct tt__IPv4NetworkInterface *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceLink:
		soap_serialize_PointerTott__NetworkInterfaceLink(soap, (struct tt__NetworkInterfaceLink *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceInfo:
		soap_serialize_PointerTott__NetworkInterfaceInfo(soap, (struct tt__NetworkInterfaceInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MulticastConfiguration:
		soap_serialize_PointerTott__MulticastConfiguration(soap, (struct tt__MulticastConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__H264Configuration:
		soap_serialize_PointerTott__H264Configuration(soap, (struct tt__H264Configuration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Mpeg4Configuration:
		soap_serialize_PointerTott__Mpeg4Configuration(soap, (struct tt__Mpeg4Configuration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoRateControl:
		soap_serialize_PointerTott__VideoRateControl(soap, (struct tt__VideoRateControl *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IntRectangle:
		soap_serialize_PointerTott__IntRectangle(soap, (struct tt__IntRectangle *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ImagingSettings:
		soap_serialize_PointerTott__ImagingSettings(soap, (struct tt__ImagingSettings *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsse__UsernameTokenType:
		soap_serialize_PointerTowsse__UsernameTokenType(soap, (struct wsse__UsernameTokenType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsu__TimestampType:
		soap_serialize_PointerTowsu__TimestampType(soap, (struct wsu__TimestampType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsse__PasswordString:
		soap_serialize_PointerTowsse__PasswordString(soap, (struct wsse__PasswordString *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__EndpointReferenceType:
		soap_serialize_PointerTowsadis__EndpointReferenceType(soap, (struct wsadis__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		soap_serialize_PointerTod__ProbeMatchType(soap, (struct d__ProbeMatchType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedInt:
		soap_serialize_PointerTounsignedInt(soap, (unsigned int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ScopesType:
		soap_serialize_PointerTod__ScopesType(soap, (struct d__ScopesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		soap_serialize_PointerTowsa__EndpointReferenceType(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MediaUri:
		soap_serialize_PointerTott__MediaUri(soap, (struct tt__MediaUri *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__StreamSetup:
		soap_serialize_PointerTott__StreamSetup(soap, (struct tt__StreamSetup *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOptions:
		soap_serialize_PointerTott__AudioEncoderConfigurationOptions(soap, (struct tt__AudioEncoderConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioSourceConfigurationOptions:
		soap_serialize_PointerTott__AudioSourceConfigurationOptions(soap, (struct tt__AudioSourceConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoEncoderConfigurationOptions:
		soap_serialize_PointerTott__VideoEncoderConfigurationOptions(soap, (struct tt__VideoEncoderConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoSourceConfigurationOptions:
		soap_serialize_PointerTott__VideoSourceConfigurationOptions(soap, (struct tt__VideoSourceConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Profile:
		soap_serialize_PointerTott__Profile(soap, (struct tt__Profile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioSource:
		soap_serialize_PointerTott__AudioSource(soap, (struct tt__AudioSource *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoSource:
		soap_serialize_PointerTott__VideoSource(soap, (struct tt__VideoSource *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotrt__Capabilities:
		soap_serialize_PointerTotrt__Capabilities(soap, (struct trt__Capabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotrt__StreamingCapabilities:
		soap_serialize_PointerTotrt__StreamingCapabilities(soap, (struct trt__StreamingCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotrt__ProfileCapabilities:
		soap_serialize_PointerTotrt__ProfileCapabilities(soap, (struct trt__ProfileCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__MetadataType:
		soap_serialize_PointerTowsa__MetadataType(soap, (struct wsa__MetadataType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		soap_serialize_PointerTowsa__ReferenceParametersType(soap, (struct wsa__ReferenceParametersType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__AttributedURIType:
		soap_serialize_PointerTowsa__AttributedURIType(soap, (struct wsa__AttributedURIType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WhiteBalanceMode:
		soap_serialize_PointerTott__WhiteBalanceMode(soap, (enum tt__WhiteBalanceMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ExposurePriority:
		soap_serialize_PointerTott__ExposurePriority(soap, (enum tt__ExposurePriority *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ExposureMode:
		soap_serialize_PointerTott__ExposureMode(soap, (enum tt__ExposureMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AutoFocusMode:
		soap_serialize_PointerTott__AutoFocusMode(soap, (enum tt__AutoFocusMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WideDynamicMode:
		soap_serialize_PointerTott__WideDynamicMode(soap, (enum tt__WideDynamicMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WhiteBalanceOptions:
		soap_serialize_PointerTott__WhiteBalanceOptions(soap, (struct tt__WhiteBalanceOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WideDynamicRangeOptions:
		soap_serialize_PointerTott__WideDynamicRangeOptions(soap, (struct tt__WideDynamicRangeOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__FocusOptions:
		soap_serialize_PointerTott__FocusOptions(soap, (struct tt__FocusOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ExposureOptions:
		soap_serialize_PointerTott__ExposureOptions(soap, (struct tt__ExposureOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__FloatRange:
		soap_serialize_PointerTott__FloatRange(soap, (struct tt__FloatRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__BacklightCompensationOptions:
		soap_serialize_PointerTott__BacklightCompensationOptions(soap, (struct tt__BacklightCompensationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Rectangle:
		soap_serialize_PointerTott__Rectangle(soap, (struct tt__Rectangle *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WhiteBalance:
		soap_serialize_PointerTott__WhiteBalance(soap, (struct tt__WhiteBalance *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WideDynamicRange:
		soap_serialize_PointerTott__WideDynamicRange(soap, (struct tt__WideDynamicRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IrCutFilterMode:
		soap_serialize_PointerTott__IrCutFilterMode(soap, (enum tt__IrCutFilterMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__FocusConfiguration:
		soap_serialize_PointerTott__FocusConfiguration(soap, (struct tt__FocusConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Exposure:
		soap_serialize_PointerTott__Exposure(soap, (struct tt__Exposure *const*)ptr);
		break;
	case SOAP_TYPE_PointerTofloat:
		soap_serialize_PointerTofloat(soap, (float *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__BacklightCompensation:
		soap_serialize_PointerTott__BacklightCompensation(soap, (struct tt__BacklightCompensation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Date:
		soap_serialize_PointerTott__Date(soap, (struct tt__Date *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Time:
		soap_serialize_PointerTott__Time(soap, (struct tt__Time *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__OnvifVersion:
		soap_serialize_PointerTott__OnvifVersion(soap, (struct tt__OnvifVersion *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__RealTimeStreamingCapabilities:
		soap_serialize_PointerTott__RealTimeStreamingCapabilities(soap, (struct tt__RealTimeStreamingCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SecurityCapabilities:
		soap_serialize_PointerTott__SecurityCapabilities(soap, (struct tt__SecurityCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IOCapabilities:
		soap_serialize_PointerTott__IOCapabilities(soap, (struct tt__IOCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SystemCapabilities:
		soap_serialize_PointerTott__SystemCapabilities(soap, (struct tt__SystemCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkCapabilities:
		soap_serialize_PointerTott__NetworkCapabilities(soap, (struct tt__NetworkCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AnalyticsDeviceCapabilities:
		soap_serialize_PointerTott__AnalyticsDeviceCapabilities(soap, (struct tt__AnalyticsDeviceCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ReceiverCapabilities:
		soap_serialize_PointerTott__ReceiverCapabilities(soap, (struct tt__ReceiverCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ReplayCapabilities:
		soap_serialize_PointerTott__ReplayCapabilities(soap, (struct tt__ReplayCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SearchCapabilities:
		soap_serialize_PointerTott__SearchCapabilities(soap, (struct tt__SearchCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__RecordingCapabilities:
		soap_serialize_PointerTott__RecordingCapabilities(soap, (struct tt__RecordingCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DisplayCapabilities:
		soap_serialize_PointerTott__DisplayCapabilities(soap, (struct tt__DisplayCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DeviceIOCapabilities:
		soap_serialize_PointerTott__DeviceIOCapabilities(soap, (struct tt__DeviceIOCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__CapabilitiesExtension:
		soap_serialize_PointerTott__CapabilitiesExtension(soap, (struct tt__CapabilitiesExtension *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZCapabilities:
		soap_serialize_PointerTott__PTZCapabilities(soap, (struct tt__PTZCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MediaCapabilities:
		soap_serialize_PointerTott__MediaCapabilities(soap, (struct tt__MediaCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ImagingCapabilities:
		soap_serialize_PointerTott__ImagingCapabilities(soap, (struct tt__ImagingCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__EventCapabilities:
		soap_serialize_PointerTott__EventCapabilities(soap, (struct tt__EventCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DeviceCapabilities:
		soap_serialize_PointerTott__DeviceCapabilities(soap, (struct tt__DeviceCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AnalyticsCapabilities:
		soap_serialize_PointerTott__AnalyticsCapabilities(soap, (struct tt__AnalyticsCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfigurationExtension:
		soap_serialize_PointerTott__NetworkInterfaceSetConfigurationExtension(soap, (struct tt__NetworkInterfaceSetConfigurationExtension *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPv4NetworkInterfaceSetConfiguration:
		soap_serialize_PointerTott__IPv4NetworkInterfaceSetConfiguration(soap, (struct tt__IPv4NetworkInterfaceSetConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PrefixedIPv4Address:
		soap_serialize_PointerTott__PrefixedIPv4Address(soap, (struct tt__PrefixedIPv4Address *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPv4Configuration:
		soap_serialize_PointerTott__IPv4Configuration(soap, (struct tt__IPv4Configuration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceConnectionSetting:
		soap_serialize_PointerTott__NetworkInterfaceConnectionSetting(soap, (struct tt__NetworkInterfaceConnectionSetting *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension2:
		soap_serialize_PointerTott__NetworkInterfaceExtension2(soap, (struct tt__NetworkInterfaceExtension2 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Dot3Configuration:
		soap_serialize_PointerTott__Dot3Configuration(soap, (struct tt__Dot3Configuration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Transport:
		soap_serialize_PointerTott__Transport(soap, (struct tt__Transport *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IntList:
		soap_serialize_PointerTott__IntList(soap, (struct tt__IntList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOption:
		soap_serialize_PointerTott__AudioEncoderConfigurationOption(soap, (struct tt__AudioEncoderConfigurationOption *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__H264Profile:
		soap_serialize_PointerTott__H264Profile(soap, (enum tt__H264Profile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Mpeg4Profile:
		soap_serialize_PointerTott__Mpeg4Profile(soap, (enum tt__Mpeg4Profile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoResolution:
		soap_serialize_PointerTott__VideoResolution(soap, (struct tt__VideoResolution *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__H264Options:
		soap_serialize_PointerTott__H264Options(soap, (struct tt__H264Options *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Mpeg4Options:
		soap_serialize_PointerTott__Mpeg4Options(soap, (struct tt__Mpeg4Options *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__JpegOptions:
		soap_serialize_PointerTott__JpegOptions(soap, (struct tt__JpegOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ReferenceToken:
		soap_serialize_PointerTott__ReferenceToken(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IntRectangleRange:
		soap_serialize_PointerTott__IntRectangleRange(soap, (struct tt__IntRectangleRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__boolean:
		soap_serialize_PointerToxsd__boolean(soap, (enum xsd__boolean *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioEncoderConfiguration:
		soap_serialize_PointerTott__AudioEncoderConfiguration(soap, (struct tt__AudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoEncoderConfiguration:
		soap_serialize_PointerTott__VideoEncoderConfiguration(soap, (struct tt__VideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioSourceConfiguration:
		soap_serialize_PointerTott__AudioSourceConfiguration(soap, (struct tt__AudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoSourceConfiguration:
		soap_serialize_PointerTott__VideoSourceConfiguration(soap, (struct tt__VideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IntRange:
		soap_serialize_PointerTott__IntRange(soap, (struct tt__IntRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkZeroConfiguration:
		soap_serialize_PointerTott__NetworkZeroConfiguration(soap, (struct tt__NetworkZeroConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPv4Address:
		soap_serialize_PointerTott__IPv4Address(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkGateway:
		soap_serialize_PointerTott__NetworkGateway(soap, (struct tt__NetworkGateway *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfiguration:
		soap_serialize_PointerTott__NetworkInterfaceSetConfiguration(soap, (struct tt__NetworkInterfaceSetConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterface:
		soap_serialize_PointerTott__NetworkInterface(soap, (struct tt__NetworkInterface *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DNSName:
		soap_serialize_PointerTott__DNSName(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DynamicDNSInformation:
		soap_serialize_PointerTott__DynamicDNSInformation(soap, (struct tt__DynamicDNSInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkHost:
		soap_serialize_PointerTott__NetworkHost(soap, (struct tt__NetworkHost *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NTPInformation:
		soap_serialize_PointerTott__NTPInformation(soap, (struct tt__NTPInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPAddress:
		soap_serialize_PointerTott__IPAddress(soap, (struct tt__IPAddress *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__token:
		soap_serialize_PointerToxsd__token(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DNSInformation:
		soap_serialize_PointerTott__DNSInformation(soap, (struct tt__DNSInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__HostnameInformation:
		soap_serialize_PointerTott__HostnameInformation(soap, (struct tt__HostnameInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Capabilities:
		soap_serialize_PointerTott__Capabilities(soap, (struct tt__Capabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__CapabilityCategory:
		soap_serialize_PointerTott__CapabilityCategory(soap, (enum tt__CapabilityCategory *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__User:
		soap_serialize_PointerTott__User(soap, (struct tt__User *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__anyURI:
		soap_serialize_PointerToxsd__anyURI(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Scope:
		soap_serialize_PointerTott__Scope(soap, (struct tt__Scope *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SystemDateTime:
		soap_serialize_PointerTott__SystemDateTime(soap, (struct tt__SystemDateTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DateTime:
		soap_serialize_PointerTott__DateTime(soap, (struct tt__DateTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__TimeZone:
		soap_serialize_PointerTott__TimeZone(soap, (struct tt__TimeZone *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__ServiceNameType:
		soap_serialize_PointerTowsadis__ServiceNameType(soap, (struct wsadis__ServiceNameType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__AttributedQName:
		soap_serialize_PointerTowsadis__AttributedQName(soap, (struct wsadis__AttributedQName *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__ReferenceParametersType:
		soap_serialize_PointerTowsadis__ReferenceParametersType(soap, (struct wsadis__ReferenceParametersType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__ReferencePropertiesType:
		soap_serialize_PointerTowsadis__ReferencePropertiesType(soap, (struct wsadis__ReferencePropertiesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__AttributedURI:
		soap_serialize_PointerTowsadis__AttributedURI(soap, (struct wsadis__AttributedURI *const*)ptr);
		break;
	case SOAP_TYPE_tt__Domain:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__DNSName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__HwAddress:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__IPv4Address:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__Name:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__ReferenceToken:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_d__UriListType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_d__QNameListType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_wsa__RelationshipTypeOpenEnum:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__token:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__duration:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__NCName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__IANA_IfTypes(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_tt__IANA_IfTypes);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_tt__IANA_IfTypes(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_tt__IANA_IfTypes);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__IANA_IfTypes(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__IANA_IfTypes);
	if (soap_out_tt__IANA_IfTypes(soap, tag?tag:"tt:IANA-IfTypes", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_tt__IANA_IfTypes(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__IANA_IfTypes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{	float *p;
	p = soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag?tag:"float", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{	unsigned int *p;
	p = soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag?tag:"unsignedInt", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsu__tTimestampFault
	*a = SOAP_DEFAULT_wsu__tTimestampFault;
#else
	*a = (enum wsu__tTimestampFault)0;
#endif
}

static const struct soap_code_map soap_codes_wsu__tTimestampFault[] =
{	{ (long)wsu__MessageExpired, "wsu:MessageExpired" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsu__tTimestampFault2s(struct soap *soap, enum wsu__tTimestampFault n)
{	const char *s = soap_code_str(soap_codes_wsu__tTimestampFault, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsu__tTimestampFault(struct soap *soap, const char *tag, int id, const enum wsu__tTimestampFault *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsu__tTimestampFault), type) || soap_send(soap, soap_wsu__tTimestampFault2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsu__tTimestampFault(struct soap *soap, const char *s, enum wsu__tTimestampFault *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsu__tTimestampFault, t);
	if (map)
		*a = (enum wsu__tTimestampFault)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsu__tTimestampFault)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_in_wsu__tTimestampFault(struct soap *soap, const char *tag, enum wsu__tTimestampFault *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsu__tTimestampFault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsu__tTimestampFault, sizeof(enum wsu__tTimestampFault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsu__tTimestampFault(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsu__tTimestampFault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsu__tTimestampFault, 0, sizeof(enum wsu__tTimestampFault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsu__tTimestampFault(struct soap *soap, const enum wsu__tTimestampFault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsu__tTimestampFault);
	if (soap_out_wsu__tTimestampFault(soap, tag?tag:"wsu:tTimestampFault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_get_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsu__tTimestampFault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsse__FaultcodeEnum
	*a = SOAP_DEFAULT_wsse__FaultcodeEnum;
#else
	*a = (enum wsse__FaultcodeEnum)0;
#endif
}

static const struct soap_code_map soap_codes_wsse__FaultcodeEnum[] =
{	{ (long)wsse__UnsupportedSecurityToken, "wsse:UnsupportedSecurityToken" },
	{ (long)wsse__UnsupportedAlgorithm, "wsse:UnsupportedAlgorithm" },
	{ (long)wsse__InvalidSecurity, "wsse:InvalidSecurity" },
	{ (long)wsse__InvalidSecurityToken, "wsse:InvalidSecurityToken" },
	{ (long)wsse__FailedAuthentication, "wsse:FailedAuthentication" },
	{ (long)wsse__FailedCheck, "wsse:FailedCheck" },
	{ (long)wsse__SecurityTokenUnavailable, "wsse:SecurityTokenUnavailable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsse__FaultcodeEnum2s(struct soap *soap, enum wsse__FaultcodeEnum n)
{	const char *s = soap_code_str(soap_codes_wsse__FaultcodeEnum, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsse__FaultcodeEnum(struct soap *soap, const char *tag, int id, const enum wsse__FaultcodeEnum *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsse__FaultcodeEnum), type) || soap_send(soap, soap_wsse__FaultcodeEnum2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsse__FaultcodeEnum(struct soap *soap, const char *s, enum wsse__FaultcodeEnum *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsse__FaultcodeEnum, t);
	if (map)
		*a = (enum wsse__FaultcodeEnum)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 6)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsse__FaultcodeEnum)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_in_wsse__FaultcodeEnum(struct soap *soap, const char *tag, enum wsse__FaultcodeEnum *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsse__FaultcodeEnum *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsse__FaultcodeEnum, sizeof(enum wsse__FaultcodeEnum), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsse__FaultcodeEnum(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsse__FaultcodeEnum *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsse__FaultcodeEnum, 0, sizeof(enum wsse__FaultcodeEnum), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsse__FaultcodeEnum(struct soap *soap, const enum wsse__FaultcodeEnum *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsse__FaultcodeEnum);
	if (soap_out_wsse__FaultcodeEnum(soap, tag?tag:"wsse:FaultcodeEnum", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_get_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsse__FaultcodeEnum(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__FaultCodeType(struct soap *soap, enum d__FaultCodeType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_d__FaultCodeType
	*a = SOAP_DEFAULT_d__FaultCodeType;
#else
	*a = (enum d__FaultCodeType)0;
#endif
}

static const struct soap_code_map soap_codes_d__FaultCodeType[] =
{	{ (long)d__MatchingRuleNotSupported, "d:MatchingRuleNotSupported" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_d__FaultCodeType2s(struct soap *soap, enum d__FaultCodeType n)
{	const char *s = soap_code_str(soap_codes_d__FaultCodeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__FaultCodeType(struct soap *soap, const char *tag, int id, const enum d__FaultCodeType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__FaultCodeType), type) || soap_send(soap, soap_d__FaultCodeType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2d__FaultCodeType(struct soap *soap, const char *s, enum d__FaultCodeType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_d__FaultCodeType, t);
	if (map)
		*a = (enum d__FaultCodeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum d__FaultCodeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum d__FaultCodeType * SOAP_FMAC4 soap_in_d__FaultCodeType(struct soap *soap, const char *tag, enum d__FaultCodeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum d__FaultCodeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__FaultCodeType, sizeof(enum d__FaultCodeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2d__FaultCodeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum d__FaultCodeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__FaultCodeType, 0, sizeof(enum d__FaultCodeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__FaultCodeType(struct soap *soap, const enum d__FaultCodeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__FaultCodeType);
	if (soap_out_d__FaultCodeType(soap, tag?tag:"d:FaultCodeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum d__FaultCodeType * SOAP_FMAC4 soap_get_d__FaultCodeType(struct soap *soap, enum d__FaultCodeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__FaultCodeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__RelationshipType(struct soap *soap, enum wsa__RelationshipType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsa__RelationshipType
	*a = SOAP_DEFAULT_wsa__RelationshipType;
#else
	*a = (enum wsa__RelationshipType)0;
#endif
}

static const struct soap_code_map soap_codes_wsa__RelationshipType[] =
{	{ (long)http___x002f_x002fwww_x002ew3_x002eorg_x002f2005_x002f08_x002faddressing_x002freply, "http://www.w3.org/2005/08/addressing/reply" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsa__RelationshipType2s(struct soap *soap, enum wsa__RelationshipType n)
{	const char *s = soap_code_str(soap_codes_wsa__RelationshipType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__RelationshipType(struct soap *soap, const char *tag, int id, const enum wsa__RelationshipType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__RelationshipType), type) || soap_send(soap, soap_wsa__RelationshipType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsa__RelationshipType(struct soap *soap, const char *s, enum wsa__RelationshipType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_wsa__RelationshipType, s);
	if (map)
		*a = (enum wsa__RelationshipType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsa__RelationshipType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsa__RelationshipType * SOAP_FMAC4 soap_in_wsa__RelationshipType(struct soap *soap, const char *tag, enum wsa__RelationshipType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsa__RelationshipType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__RelationshipType, sizeof(enum wsa__RelationshipType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsa__RelationshipType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsa__RelationshipType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__RelationshipType, 0, sizeof(enum wsa__RelationshipType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__RelationshipType(struct soap *soap, const enum wsa__RelationshipType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__RelationshipType);
	if (soap_out_wsa__RelationshipType(soap, tag?tag:"wsa:RelationshipType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsa__RelationshipType * SOAP_FMAC4 soap_get_wsa__RelationshipType(struct soap *soap, enum wsa__RelationshipType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__RelationshipType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__IrCutFilterMode(struct soap *soap, enum tt__IrCutFilterMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__IrCutFilterMode
	*a = SOAP_DEFAULT_tt__IrCutFilterMode;
#else
	*a = (enum tt__IrCutFilterMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__IrCutFilterMode[] =
{	{ (long)ON__, "ON" },
	{ (long)OFF__, "OFF" },
	{ (long)AUTO___, "AUTO" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__IrCutFilterMode2s(struct soap *soap, enum tt__IrCutFilterMode n)
{	const char *s = soap_code_str(soap_codes_tt__IrCutFilterMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__IrCutFilterMode(struct soap *soap, const char *tag, int id, const enum tt__IrCutFilterMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__IrCutFilterMode), type) || soap_send(soap, soap_tt__IrCutFilterMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__IrCutFilterMode(struct soap *soap, const char *s, enum tt__IrCutFilterMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__IrCutFilterMode, s);
	if (map)
		*a = (enum tt__IrCutFilterMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__IrCutFilterMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__IrCutFilterMode * SOAP_FMAC4 soap_in_tt__IrCutFilterMode(struct soap *soap, const char *tag, enum tt__IrCutFilterMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__IrCutFilterMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__IrCutFilterMode, sizeof(enum tt__IrCutFilterMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__IrCutFilterMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__IrCutFilterMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__IrCutFilterMode, 0, sizeof(enum tt__IrCutFilterMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__IrCutFilterMode(struct soap *soap, const enum tt__IrCutFilterMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__IrCutFilterMode);
	if (soap_out_tt__IrCutFilterMode(soap, tag?tag:"tt:IrCutFilterMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__IrCutFilterMode * SOAP_FMAC4 soap_get_tt__IrCutFilterMode(struct soap *soap, enum tt__IrCutFilterMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__IrCutFilterMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__WhiteBalanceMode(struct soap *soap, enum tt__WhiteBalanceMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__WhiteBalanceMode
	*a = SOAP_DEFAULT_tt__WhiteBalanceMode;
#else
	*a = (enum tt__WhiteBalanceMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__WhiteBalanceMode[] =
{	{ (long)AUTO__, "AUTO" },
	{ (long)MANUAL__, "MANUAL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__WhiteBalanceMode2s(struct soap *soap, enum tt__WhiteBalanceMode n)
{	const char *s = soap_code_str(soap_codes_tt__WhiteBalanceMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__WhiteBalanceMode(struct soap *soap, const char *tag, int id, const enum tt__WhiteBalanceMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__WhiteBalanceMode), type) || soap_send(soap, soap_tt__WhiteBalanceMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__WhiteBalanceMode(struct soap *soap, const char *s, enum tt__WhiteBalanceMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__WhiteBalanceMode, s);
	if (map)
		*a = (enum tt__WhiteBalanceMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__WhiteBalanceMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__WhiteBalanceMode * SOAP_FMAC4 soap_in_tt__WhiteBalanceMode(struct soap *soap, const char *tag, enum tt__WhiteBalanceMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__WhiteBalanceMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__WhiteBalanceMode, sizeof(enum tt__WhiteBalanceMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__WhiteBalanceMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__WhiteBalanceMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__WhiteBalanceMode, 0, sizeof(enum tt__WhiteBalanceMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__WhiteBalanceMode(struct soap *soap, const enum tt__WhiteBalanceMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__WhiteBalanceMode);
	if (soap_out_tt__WhiteBalanceMode(soap, tag?tag:"tt:WhiteBalanceMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__WhiteBalanceMode * SOAP_FMAC4 soap_get_tt__WhiteBalanceMode(struct soap *soap, enum tt__WhiteBalanceMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__WhiteBalanceMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__Enabled(struct soap *soap, enum tt__Enabled *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__Enabled
	*a = SOAP_DEFAULT_tt__Enabled;
#else
	*a = (enum tt__Enabled)0;
#endif
}

static const struct soap_code_map soap_codes_tt__Enabled[] =
{	{ (long)ENABLED, "ENABLED" },
	{ (long)DISABLED, "DISABLED" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__Enabled2s(struct soap *soap, enum tt__Enabled n)
{	const char *s = soap_code_str(soap_codes_tt__Enabled, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__Enabled(struct soap *soap, const char *tag, int id, const enum tt__Enabled *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__Enabled), type) || soap_send(soap, soap_tt__Enabled2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__Enabled(struct soap *soap, const char *s, enum tt__Enabled *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__Enabled, s);
	if (map)
		*a = (enum tt__Enabled)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__Enabled)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__Enabled * SOAP_FMAC4 soap_in_tt__Enabled(struct soap *soap, const char *tag, enum tt__Enabled *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__Enabled *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__Enabled, sizeof(enum tt__Enabled), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__Enabled(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__Enabled *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__Enabled, 0, sizeof(enum tt__Enabled), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__Enabled(struct soap *soap, const enum tt__Enabled *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__Enabled);
	if (soap_out_tt__Enabled(soap, tag?tag:"tt:Enabled", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__Enabled * SOAP_FMAC4 soap_get_tt__Enabled(struct soap *soap, enum tt__Enabled *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__Enabled(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__ExposureMode(struct soap *soap, enum tt__ExposureMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__ExposureMode
	*a = SOAP_DEFAULT_tt__ExposureMode;
#else
	*a = (enum tt__ExposureMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__ExposureMode[] =
{	{ (long)AUTO_, "AUTO" },
	{ (long)MANUAL_, "MANUAL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__ExposureMode2s(struct soap *soap, enum tt__ExposureMode n)
{	const char *s = soap_code_str(soap_codes_tt__ExposureMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__ExposureMode(struct soap *soap, const char *tag, int id, const enum tt__ExposureMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__ExposureMode), type) || soap_send(soap, soap_tt__ExposureMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__ExposureMode(struct soap *soap, const char *s, enum tt__ExposureMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__ExposureMode, s);
	if (map)
		*a = (enum tt__ExposureMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__ExposureMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__ExposureMode * SOAP_FMAC4 soap_in_tt__ExposureMode(struct soap *soap, const char *tag, enum tt__ExposureMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__ExposureMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__ExposureMode, sizeof(enum tt__ExposureMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__ExposureMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__ExposureMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__ExposureMode, 0, sizeof(enum tt__ExposureMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__ExposureMode(struct soap *soap, const enum tt__ExposureMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__ExposureMode);
	if (soap_out_tt__ExposureMode(soap, tag?tag:"tt:ExposureMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__ExposureMode * SOAP_FMAC4 soap_get_tt__ExposureMode(struct soap *soap, enum tt__ExposureMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__ExposureMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__ExposurePriority(struct soap *soap, enum tt__ExposurePriority *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__ExposurePriority
	*a = SOAP_DEFAULT_tt__ExposurePriority;
#else
	*a = (enum tt__ExposurePriority)0;
#endif
}

static const struct soap_code_map soap_codes_tt__ExposurePriority[] =
{	{ (long)LowNoise, "LowNoise" },
	{ (long)FrameRate, "FrameRate" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__ExposurePriority2s(struct soap *soap, enum tt__ExposurePriority n)
{	const char *s = soap_code_str(soap_codes_tt__ExposurePriority, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__ExposurePriority(struct soap *soap, const char *tag, int id, const enum tt__ExposurePriority *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__ExposurePriority), type) || soap_send(soap, soap_tt__ExposurePriority2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__ExposurePriority(struct soap *soap, const char *s, enum tt__ExposurePriority *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__ExposurePriority, s);
	if (map)
		*a = (enum tt__ExposurePriority)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__ExposurePriority)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__ExposurePriority * SOAP_FMAC4 soap_in_tt__ExposurePriority(struct soap *soap, const char *tag, enum tt__ExposurePriority *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__ExposurePriority *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__ExposurePriority, sizeof(enum tt__ExposurePriority), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__ExposurePriority(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__ExposurePriority *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__ExposurePriority, 0, sizeof(enum tt__ExposurePriority), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__ExposurePriority(struct soap *soap, const enum tt__ExposurePriority *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__ExposurePriority);
	if (soap_out_tt__ExposurePriority(soap, tag?tag:"tt:ExposurePriority", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__ExposurePriority * SOAP_FMAC4 soap_get_tt__ExposurePriority(struct soap *soap, enum tt__ExposurePriority *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__ExposurePriority(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__BacklightCompensationMode(struct soap *soap, enum tt__BacklightCompensationMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__BacklightCompensationMode
	*a = SOAP_DEFAULT_tt__BacklightCompensationMode;
#else
	*a = (enum tt__BacklightCompensationMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__BacklightCompensationMode[] =
{	{ (long)OFF_, "OFF" },
	{ (long)ON_, "ON" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__BacklightCompensationMode2s(struct soap *soap, enum tt__BacklightCompensationMode n)
{	const char *s = soap_code_str(soap_codes_tt__BacklightCompensationMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__BacklightCompensationMode(struct soap *soap, const char *tag, int id, const enum tt__BacklightCompensationMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__BacklightCompensationMode), type) || soap_send(soap, soap_tt__BacklightCompensationMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__BacklightCompensationMode(struct soap *soap, const char *s, enum tt__BacklightCompensationMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__BacklightCompensationMode, s);
	if (map)
		*a = (enum tt__BacklightCompensationMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__BacklightCompensationMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__BacklightCompensationMode * SOAP_FMAC4 soap_in_tt__BacklightCompensationMode(struct soap *soap, const char *tag, enum tt__BacklightCompensationMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__BacklightCompensationMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__BacklightCompensationMode, sizeof(enum tt__BacklightCompensationMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__BacklightCompensationMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__BacklightCompensationMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__BacklightCompensationMode, 0, sizeof(enum tt__BacklightCompensationMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__BacklightCompensationMode(struct soap *soap, const enum tt__BacklightCompensationMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__BacklightCompensationMode);
	if (soap_out_tt__BacklightCompensationMode(soap, tag?tag:"tt:BacklightCompensationMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__BacklightCompensationMode * SOAP_FMAC4 soap_get_tt__BacklightCompensationMode(struct soap *soap, enum tt__BacklightCompensationMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__BacklightCompensationMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__WideDynamicMode(struct soap *soap, enum tt__WideDynamicMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__WideDynamicMode
	*a = SOAP_DEFAULT_tt__WideDynamicMode;
#else
	*a = (enum tt__WideDynamicMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__WideDynamicMode[] =
{	{ (long)OFF, "OFF" },
	{ (long)ON, "ON" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__WideDynamicMode2s(struct soap *soap, enum tt__WideDynamicMode n)
{	const char *s = soap_code_str(soap_codes_tt__WideDynamicMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__WideDynamicMode(struct soap *soap, const char *tag, int id, const enum tt__WideDynamicMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__WideDynamicMode), type) || soap_send(soap, soap_tt__WideDynamicMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__WideDynamicMode(struct soap *soap, const char *s, enum tt__WideDynamicMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__WideDynamicMode, s);
	if (map)
		*a = (enum tt__WideDynamicMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__WideDynamicMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__WideDynamicMode * SOAP_FMAC4 soap_in_tt__WideDynamicMode(struct soap *soap, const char *tag, enum tt__WideDynamicMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__WideDynamicMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__WideDynamicMode, sizeof(enum tt__WideDynamicMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__WideDynamicMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__WideDynamicMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__WideDynamicMode, 0, sizeof(enum tt__WideDynamicMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__WideDynamicMode(struct soap *soap, const enum tt__WideDynamicMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__WideDynamicMode);
	if (soap_out_tt__WideDynamicMode(soap, tag?tag:"tt:WideDynamicMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__WideDynamicMode * SOAP_FMAC4 soap_get_tt__WideDynamicMode(struct soap *soap, enum tt__WideDynamicMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__WideDynamicMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__AutoFocusMode(struct soap *soap, enum tt__AutoFocusMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__AutoFocusMode
	*a = SOAP_DEFAULT_tt__AutoFocusMode;
#else
	*a = (enum tt__AutoFocusMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__AutoFocusMode[] =
{	{ (long)AUTO, "AUTO" },
	{ (long)MANUAL, "MANUAL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__AutoFocusMode2s(struct soap *soap, enum tt__AutoFocusMode n)
{	const char *s = soap_code_str(soap_codes_tt__AutoFocusMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__AutoFocusMode(struct soap *soap, const char *tag, int id, const enum tt__AutoFocusMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__AutoFocusMode), type) || soap_send(soap, soap_tt__AutoFocusMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__AutoFocusMode(struct soap *soap, const char *s, enum tt__AutoFocusMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__AutoFocusMode, s);
	if (map)
		*a = (enum tt__AutoFocusMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__AutoFocusMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__AutoFocusMode * SOAP_FMAC4 soap_in_tt__AutoFocusMode(struct soap *soap, const char *tag, enum tt__AutoFocusMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__AutoFocusMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__AutoFocusMode, sizeof(enum tt__AutoFocusMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__AutoFocusMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__AutoFocusMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__AutoFocusMode, 0, sizeof(enum tt__AutoFocusMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__AutoFocusMode(struct soap *soap, const enum tt__AutoFocusMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__AutoFocusMode);
	if (soap_out_tt__AutoFocusMode(soap, tag?tag:"tt:AutoFocusMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__AutoFocusMode * SOAP_FMAC4 soap_get_tt__AutoFocusMode(struct soap *soap, enum tt__AutoFocusMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__AutoFocusMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__UserLevel(struct soap *soap, enum tt__UserLevel *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__UserLevel
	*a = SOAP_DEFAULT_tt__UserLevel;
#else
	*a = (enum tt__UserLevel)0;
#endif
}

static const struct soap_code_map soap_codes_tt__UserLevel[] =
{	{ (long)Administrator, "Administrator" },
	{ (long)Operator, "Operator" },
	{ (long)User, "User" },
	{ (long)Anonymous, "Anonymous" },
	{ (long)Extended_, "Extended" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__UserLevel2s(struct soap *soap, enum tt__UserLevel n)
{	const char *s = soap_code_str(soap_codes_tt__UserLevel, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__UserLevel(struct soap *soap, const char *tag, int id, const enum tt__UserLevel *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__UserLevel), type) || soap_send(soap, soap_tt__UserLevel2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__UserLevel(struct soap *soap, const char *s, enum tt__UserLevel *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__UserLevel, s);
	if (map)
		*a = (enum tt__UserLevel)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 4)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__UserLevel)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__UserLevel * SOAP_FMAC4 soap_in_tt__UserLevel(struct soap *soap, const char *tag, enum tt__UserLevel *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__UserLevel *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__UserLevel, sizeof(enum tt__UserLevel), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__UserLevel(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__UserLevel *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__UserLevel, 0, sizeof(enum tt__UserLevel), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__UserLevel(struct soap *soap, const enum tt__UserLevel *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__UserLevel);
	if (soap_out_tt__UserLevel(soap, tag?tag:"tt:UserLevel", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__UserLevel * SOAP_FMAC4 soap_get_tt__UserLevel(struct soap *soap, enum tt__UserLevel *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__UserLevel(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__SetDateTimeType(struct soap *soap, enum tt__SetDateTimeType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__SetDateTimeType
	*a = SOAP_DEFAULT_tt__SetDateTimeType;
#else
	*a = (enum tt__SetDateTimeType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__SetDateTimeType[] =
{	{ (long)Manual, "Manual" },
	{ (long)NTP, "NTP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__SetDateTimeType2s(struct soap *soap, enum tt__SetDateTimeType n)
{	const char *s = soap_code_str(soap_codes_tt__SetDateTimeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__SetDateTimeType(struct soap *soap, const char *tag, int id, const enum tt__SetDateTimeType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__SetDateTimeType), type) || soap_send(soap, soap_tt__SetDateTimeType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__SetDateTimeType(struct soap *soap, const char *s, enum tt__SetDateTimeType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__SetDateTimeType, s);
	if (map)
		*a = (enum tt__SetDateTimeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__SetDateTimeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__SetDateTimeType * SOAP_FMAC4 soap_in_tt__SetDateTimeType(struct soap *soap, const char *tag, enum tt__SetDateTimeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__SetDateTimeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__SetDateTimeType, sizeof(enum tt__SetDateTimeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__SetDateTimeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__SetDateTimeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__SetDateTimeType, 0, sizeof(enum tt__SetDateTimeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__SetDateTimeType(struct soap *soap, const enum tt__SetDateTimeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__SetDateTimeType);
	if (soap_out_tt__SetDateTimeType(soap, tag?tag:"tt:SetDateTimeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__SetDateTimeType * SOAP_FMAC4 soap_get_tt__SetDateTimeType(struct soap *soap, enum tt__SetDateTimeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__SetDateTimeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__FactoryDefaultType(struct soap *soap, enum tt__FactoryDefaultType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__FactoryDefaultType
	*a = SOAP_DEFAULT_tt__FactoryDefaultType;
#else
	*a = (enum tt__FactoryDefaultType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__FactoryDefaultType[] =
{	{ (long)Hard, "Hard" },
	{ (long)Soft, "Soft" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__FactoryDefaultType2s(struct soap *soap, enum tt__FactoryDefaultType n)
{	const char *s = soap_code_str(soap_codes_tt__FactoryDefaultType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__FactoryDefaultType(struct soap *soap, const char *tag, int id, const enum tt__FactoryDefaultType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__FactoryDefaultType), type) || soap_send(soap, soap_tt__FactoryDefaultType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__FactoryDefaultType(struct soap *soap, const char *s, enum tt__FactoryDefaultType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__FactoryDefaultType, s);
	if (map)
		*a = (enum tt__FactoryDefaultType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__FactoryDefaultType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__FactoryDefaultType * SOAP_FMAC4 soap_in_tt__FactoryDefaultType(struct soap *soap, const char *tag, enum tt__FactoryDefaultType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__FactoryDefaultType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__FactoryDefaultType, sizeof(enum tt__FactoryDefaultType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__FactoryDefaultType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__FactoryDefaultType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__FactoryDefaultType, 0, sizeof(enum tt__FactoryDefaultType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__FactoryDefaultType(struct soap *soap, const enum tt__FactoryDefaultType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__FactoryDefaultType);
	if (soap_out_tt__FactoryDefaultType(soap, tag?tag:"tt:FactoryDefaultType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__FactoryDefaultType * SOAP_FMAC4 soap_get_tt__FactoryDefaultType(struct soap *soap, enum tt__FactoryDefaultType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__FactoryDefaultType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__CapabilityCategory(struct soap *soap, enum tt__CapabilityCategory *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__CapabilityCategory
	*a = SOAP_DEFAULT_tt__CapabilityCategory;
#else
	*a = (enum tt__CapabilityCategory)0;
#endif
}

static const struct soap_code_map soap_codes_tt__CapabilityCategory[] =
{	{ (long)All, "All" },
	{ (long)Analytics, "Analytics" },
	{ (long)Device, "Device" },
	{ (long)Events, "Events" },
	{ (long)Imaging, "Imaging" },
	{ (long)Media, "Media" },
	{ (long)PTZ, "PTZ" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__CapabilityCategory2s(struct soap *soap, enum tt__CapabilityCategory n)
{	const char *s = soap_code_str(soap_codes_tt__CapabilityCategory, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__CapabilityCategory(struct soap *soap, const char *tag, int id, const enum tt__CapabilityCategory *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__CapabilityCategory), type) || soap_send(soap, soap_tt__CapabilityCategory2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__CapabilityCategory(struct soap *soap, const char *s, enum tt__CapabilityCategory *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__CapabilityCategory, s);
	if (map)
		*a = (enum tt__CapabilityCategory)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 6)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__CapabilityCategory)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__CapabilityCategory * SOAP_FMAC4 soap_in_tt__CapabilityCategory(struct soap *soap, const char *tag, enum tt__CapabilityCategory *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__CapabilityCategory *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__CapabilityCategory, sizeof(enum tt__CapabilityCategory), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__CapabilityCategory(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__CapabilityCategory *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__CapabilityCategory, 0, sizeof(enum tt__CapabilityCategory), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__CapabilityCategory(struct soap *soap, const enum tt__CapabilityCategory *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__CapabilityCategory);
	if (soap_out_tt__CapabilityCategory(soap, tag?tag:"tt:CapabilityCategory", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__CapabilityCategory * SOAP_FMAC4 soap_get_tt__CapabilityCategory(struct soap *soap, enum tt__CapabilityCategory *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__CapabilityCategory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__DynamicDNSType(struct soap *soap, enum tt__DynamicDNSType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__DynamicDNSType
	*a = SOAP_DEFAULT_tt__DynamicDNSType;
#else
	*a = (enum tt__DynamicDNSType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__DynamicDNSType[] =
{	{ (long)NoUpdate, "NoUpdate" },
	{ (long)ClientUpdates, "ClientUpdates" },
	{ (long)ServerUpdates, "ServerUpdates" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__DynamicDNSType2s(struct soap *soap, enum tt__DynamicDNSType n)
{	const char *s = soap_code_str(soap_codes_tt__DynamicDNSType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__DynamicDNSType(struct soap *soap, const char *tag, int id, const enum tt__DynamicDNSType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__DynamicDNSType), type) || soap_send(soap, soap_tt__DynamicDNSType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__DynamicDNSType(struct soap *soap, const char *s, enum tt__DynamicDNSType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__DynamicDNSType, s);
	if (map)
		*a = (enum tt__DynamicDNSType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__DynamicDNSType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__DynamicDNSType * SOAP_FMAC4 soap_in_tt__DynamicDNSType(struct soap *soap, const char *tag, enum tt__DynamicDNSType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__DynamicDNSType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__DynamicDNSType, sizeof(enum tt__DynamicDNSType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__DynamicDNSType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__DynamicDNSType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__DynamicDNSType, 0, sizeof(enum tt__DynamicDNSType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__DynamicDNSType(struct soap *soap, const enum tt__DynamicDNSType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__DynamicDNSType);
	if (soap_out_tt__DynamicDNSType(soap, tag?tag:"tt:DynamicDNSType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__DynamicDNSType * SOAP_FMAC4 soap_get_tt__DynamicDNSType(struct soap *soap, enum tt__DynamicDNSType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__DynamicDNSType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__IPType(struct soap *soap, enum tt__IPType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__IPType
	*a = SOAP_DEFAULT_tt__IPType;
#else
	*a = (enum tt__IPType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__IPType[] =
{	{ (long)IPv4_, "IPv4" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__IPType2s(struct soap *soap, enum tt__IPType n)
{	const char *s = soap_code_str(soap_codes_tt__IPType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__IPType(struct soap *soap, const char *tag, int id, const enum tt__IPType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__IPType), type) || soap_send(soap, soap_tt__IPType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__IPType(struct soap *soap, const char *s, enum tt__IPType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__IPType, s);
	if (map)
		*a = (enum tt__IPType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__IPType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__IPType * SOAP_FMAC4 soap_in_tt__IPType(struct soap *soap, const char *tag, enum tt__IPType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__IPType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__IPType, sizeof(enum tt__IPType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__IPType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__IPType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__IPType, 0, sizeof(enum tt__IPType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__IPType(struct soap *soap, const enum tt__IPType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__IPType);
	if (soap_out_tt__IPType(soap, tag?tag:"tt:IPType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__IPType * SOAP_FMAC4 soap_get_tt__IPType(struct soap *soap, enum tt__IPType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__IPType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__NetworkHostType(struct soap *soap, enum tt__NetworkHostType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__NetworkHostType
	*a = SOAP_DEFAULT_tt__NetworkHostType;
#else
	*a = (enum tt__NetworkHostType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__NetworkHostType[] =
{	{ (long)IPv4, "IPv4" },
	{ (long)DNS, "DNS" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__NetworkHostType2s(struct soap *soap, enum tt__NetworkHostType n)
{	const char *s = soap_code_str(soap_codes_tt__NetworkHostType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__NetworkHostType(struct soap *soap, const char *tag, int id, const enum tt__NetworkHostType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__NetworkHostType), type) || soap_send(soap, soap_tt__NetworkHostType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__NetworkHostType(struct soap *soap, const char *s, enum tt__NetworkHostType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__NetworkHostType, s);
	if (map)
		*a = (enum tt__NetworkHostType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__NetworkHostType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__NetworkHostType * SOAP_FMAC4 soap_in_tt__NetworkHostType(struct soap *soap, const char *tag, enum tt__NetworkHostType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__NetworkHostType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__NetworkHostType, sizeof(enum tt__NetworkHostType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__NetworkHostType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__NetworkHostType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__NetworkHostType, 0, sizeof(enum tt__NetworkHostType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__NetworkHostType(struct soap *soap, const enum tt__NetworkHostType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__NetworkHostType);
	if (soap_out_tt__NetworkHostType(soap, tag?tag:"tt:NetworkHostType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__NetworkHostType * SOAP_FMAC4 soap_get_tt__NetworkHostType(struct soap *soap, enum tt__NetworkHostType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__NetworkHostType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__NetworkProtocolType(struct soap *soap, enum tt__NetworkProtocolType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__NetworkProtocolType
	*a = SOAP_DEFAULT_tt__NetworkProtocolType;
#else
	*a = (enum tt__NetworkProtocolType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__NetworkProtocolType[] =
{	{ (long)HTTP_, "HTTP" },
	{ (long)HTTPS, "HTTPS" },
	{ (long)RTSP_, "RTSP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__NetworkProtocolType2s(struct soap *soap, enum tt__NetworkProtocolType n)
{	const char *s = soap_code_str(soap_codes_tt__NetworkProtocolType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__NetworkProtocolType(struct soap *soap, const char *tag, int id, const enum tt__NetworkProtocolType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__NetworkProtocolType), type) || soap_send(soap, soap_tt__NetworkProtocolType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__NetworkProtocolType(struct soap *soap, const char *s, enum tt__NetworkProtocolType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__NetworkProtocolType, s);
	if (map)
		*a = (enum tt__NetworkProtocolType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__NetworkProtocolType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__NetworkProtocolType * SOAP_FMAC4 soap_in_tt__NetworkProtocolType(struct soap *soap, const char *tag, enum tt__NetworkProtocolType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__NetworkProtocolType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__NetworkProtocolType, sizeof(enum tt__NetworkProtocolType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__NetworkProtocolType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__NetworkProtocolType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__NetworkProtocolType, 0, sizeof(enum tt__NetworkProtocolType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__NetworkProtocolType(struct soap *soap, const enum tt__NetworkProtocolType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__NetworkProtocolType);
	if (soap_out_tt__NetworkProtocolType(soap, tag?tag:"tt:NetworkProtocolType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__NetworkProtocolType * SOAP_FMAC4 soap_get_tt__NetworkProtocolType(struct soap *soap, enum tt__NetworkProtocolType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__NetworkProtocolType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__Duplex(struct soap *soap, enum tt__Duplex *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__Duplex
	*a = SOAP_DEFAULT_tt__Duplex;
#else
	*a = (enum tt__Duplex)0;
#endif
}

static const struct soap_code_map soap_codes_tt__Duplex[] =
{	{ (long)Full, "Full" },
	{ (long)Half, "Half" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__Duplex2s(struct soap *soap, enum tt__Duplex n)
{	const char *s = soap_code_str(soap_codes_tt__Duplex, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__Duplex(struct soap *soap, const char *tag, int id, const enum tt__Duplex *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__Duplex), type) || soap_send(soap, soap_tt__Duplex2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__Duplex(struct soap *soap, const char *s, enum tt__Duplex *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__Duplex, s);
	if (map)
		*a = (enum tt__Duplex)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__Duplex)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__Duplex * SOAP_FMAC4 soap_in_tt__Duplex(struct soap *soap, const char *tag, enum tt__Duplex *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__Duplex *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__Duplex, sizeof(enum tt__Duplex), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__Duplex(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__Duplex *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__Duplex, 0, sizeof(enum tt__Duplex), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__Duplex(struct soap *soap, const enum tt__Duplex *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__Duplex);
	if (soap_out_tt__Duplex(soap, tag?tag:"tt:Duplex", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__Duplex * SOAP_FMAC4 soap_get_tt__Duplex(struct soap *soap, enum tt__Duplex *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__Duplex(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__DiscoveryMode(struct soap *soap, enum tt__DiscoveryMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__DiscoveryMode
	*a = SOAP_DEFAULT_tt__DiscoveryMode;
#else
	*a = (enum tt__DiscoveryMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__DiscoveryMode[] =
{	{ (long)Discoverable, "Discoverable" },
	{ (long)NonDiscoverable, "NonDiscoverable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__DiscoveryMode2s(struct soap *soap, enum tt__DiscoveryMode n)
{	const char *s = soap_code_str(soap_codes_tt__DiscoveryMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__DiscoveryMode(struct soap *soap, const char *tag, int id, const enum tt__DiscoveryMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__DiscoveryMode), type) || soap_send(soap, soap_tt__DiscoveryMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__DiscoveryMode(struct soap *soap, const char *s, enum tt__DiscoveryMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__DiscoveryMode, s);
	if (map)
		*a = (enum tt__DiscoveryMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__DiscoveryMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__DiscoveryMode * SOAP_FMAC4 soap_in_tt__DiscoveryMode(struct soap *soap, const char *tag, enum tt__DiscoveryMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__DiscoveryMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__DiscoveryMode, sizeof(enum tt__DiscoveryMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__DiscoveryMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__DiscoveryMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__DiscoveryMode, 0, sizeof(enum tt__DiscoveryMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__DiscoveryMode(struct soap *soap, const enum tt__DiscoveryMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__DiscoveryMode);
	if (soap_out_tt__DiscoveryMode(soap, tag?tag:"tt:DiscoveryMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__DiscoveryMode * SOAP_FMAC4 soap_get_tt__DiscoveryMode(struct soap *soap, enum tt__DiscoveryMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__DiscoveryMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__ScopeDefinition(struct soap *soap, enum tt__ScopeDefinition *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__ScopeDefinition
	*a = SOAP_DEFAULT_tt__ScopeDefinition;
#else
	*a = (enum tt__ScopeDefinition)0;
#endif
}

static const struct soap_code_map soap_codes_tt__ScopeDefinition[] =
{	{ (long)Fixed, "Fixed" },
	{ (long)Configurable, "Configurable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__ScopeDefinition2s(struct soap *soap, enum tt__ScopeDefinition n)
{	const char *s = soap_code_str(soap_codes_tt__ScopeDefinition, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__ScopeDefinition(struct soap *soap, const char *tag, int id, const enum tt__ScopeDefinition *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__ScopeDefinition), type) || soap_send(soap, soap_tt__ScopeDefinition2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__ScopeDefinition(struct soap *soap, const char *s, enum tt__ScopeDefinition *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__ScopeDefinition, s);
	if (map)
		*a = (enum tt__ScopeDefinition)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__ScopeDefinition)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__ScopeDefinition * SOAP_FMAC4 soap_in_tt__ScopeDefinition(struct soap *soap, const char *tag, enum tt__ScopeDefinition *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__ScopeDefinition *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__ScopeDefinition, sizeof(enum tt__ScopeDefinition), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__ScopeDefinition(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__ScopeDefinition *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__ScopeDefinition, 0, sizeof(enum tt__ScopeDefinition), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__ScopeDefinition(struct soap *soap, const enum tt__ScopeDefinition *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__ScopeDefinition);
	if (soap_out_tt__ScopeDefinition(soap, tag?tag:"tt:ScopeDefinition", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__ScopeDefinition * SOAP_FMAC4 soap_get_tt__ScopeDefinition(struct soap *soap, enum tt__ScopeDefinition *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__ScopeDefinition(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__TransportProtocol(struct soap *soap, enum tt__TransportProtocol *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__TransportProtocol
	*a = SOAP_DEFAULT_tt__TransportProtocol;
#else
	*a = (enum tt__TransportProtocol)0;
#endif
}

static const struct soap_code_map soap_codes_tt__TransportProtocol[] =
{	{ (long)UDP, "UDP" },
	{ (long)TCP, "TCP" },
	{ (long)RTSP, "RTSP" },
	{ (long)HTTP, "HTTP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__TransportProtocol2s(struct soap *soap, enum tt__TransportProtocol n)
{	const char *s = soap_code_str(soap_codes_tt__TransportProtocol, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__TransportProtocol(struct soap *soap, const char *tag, int id, const enum tt__TransportProtocol *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__TransportProtocol), type) || soap_send(soap, soap_tt__TransportProtocol2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__TransportProtocol(struct soap *soap, const char *s, enum tt__TransportProtocol *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__TransportProtocol, s);
	if (map)
		*a = (enum tt__TransportProtocol)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__TransportProtocol)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__TransportProtocol * SOAP_FMAC4 soap_in_tt__TransportProtocol(struct soap *soap, const char *tag, enum tt__TransportProtocol *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__TransportProtocol *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__TransportProtocol, sizeof(enum tt__TransportProtocol), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__TransportProtocol(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__TransportProtocol *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__TransportProtocol, 0, sizeof(enum tt__TransportProtocol), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__TransportProtocol(struct soap *soap, const enum tt__TransportProtocol *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__TransportProtocol);
	if (soap_out_tt__TransportProtocol(soap, tag?tag:"tt:TransportProtocol", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__TransportProtocol * SOAP_FMAC4 soap_get_tt__TransportProtocol(struct soap *soap, enum tt__TransportProtocol *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__TransportProtocol(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__StreamType(struct soap *soap, enum tt__StreamType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__StreamType
	*a = SOAP_DEFAULT_tt__StreamType;
#else
	*a = (enum tt__StreamType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__StreamType[] =
{	{ (long)RTP_Unicast, "RTP-Unicast" },
	{ (long)RTP_Multicast, "RTP-Multicast" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__StreamType2s(struct soap *soap, enum tt__StreamType n)
{	const char *s = soap_code_str(soap_codes_tt__StreamType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__StreamType(struct soap *soap, const char *tag, int id, const enum tt__StreamType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__StreamType), type) || soap_send(soap, soap_tt__StreamType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__StreamType(struct soap *soap, const char *s, enum tt__StreamType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__StreamType, s);
	if (map)
		*a = (enum tt__StreamType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__StreamType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__StreamType * SOAP_FMAC4 soap_in_tt__StreamType(struct soap *soap, const char *tag, enum tt__StreamType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__StreamType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__StreamType, sizeof(enum tt__StreamType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__StreamType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__StreamType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__StreamType, 0, sizeof(enum tt__StreamType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__StreamType(struct soap *soap, const enum tt__StreamType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__StreamType);
	if (soap_out_tt__StreamType(soap, tag?tag:"tt:StreamType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__StreamType * SOAP_FMAC4 soap_get_tt__StreamType(struct soap *soap, enum tt__StreamType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__StreamType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__AudioEncoding(struct soap *soap, enum tt__AudioEncoding *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__AudioEncoding
	*a = SOAP_DEFAULT_tt__AudioEncoding;
#else
	*a = (enum tt__AudioEncoding)0;
#endif
}

static const struct soap_code_map soap_codes_tt__AudioEncoding[] =
{	{ (long)G711, "G711" },
	{ (long)G726, "G726" },
	{ (long)AAC, "AAC" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__AudioEncoding2s(struct soap *soap, enum tt__AudioEncoding n)
{	const char *s = soap_code_str(soap_codes_tt__AudioEncoding, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__AudioEncoding(struct soap *soap, const char *tag, int id, const enum tt__AudioEncoding *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__AudioEncoding), type) || soap_send(soap, soap_tt__AudioEncoding2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__AudioEncoding(struct soap *soap, const char *s, enum tt__AudioEncoding *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__AudioEncoding, s);
	if (map)
		*a = (enum tt__AudioEncoding)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__AudioEncoding)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__AudioEncoding * SOAP_FMAC4 soap_in_tt__AudioEncoding(struct soap *soap, const char *tag, enum tt__AudioEncoding *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__AudioEncoding *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__AudioEncoding, sizeof(enum tt__AudioEncoding), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__AudioEncoding(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__AudioEncoding *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__AudioEncoding, 0, sizeof(enum tt__AudioEncoding), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__AudioEncoding(struct soap *soap, const enum tt__AudioEncoding *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__AudioEncoding);
	if (soap_out_tt__AudioEncoding(soap, tag?tag:"tt:AudioEncoding", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__AudioEncoding * SOAP_FMAC4 soap_get_tt__AudioEncoding(struct soap *soap, enum tt__AudioEncoding *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__AudioEncoding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__H264Profile(struct soap *soap, enum tt__H264Profile *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__H264Profile
	*a = SOAP_DEFAULT_tt__H264Profile;
#else
	*a = (enum tt__H264Profile)0;
#endif
}

static const struct soap_code_map soap_codes_tt__H264Profile[] =
{	{ (long)Baseline, "Baseline" },
	{ (long)Main, "Main" },
	{ (long)Extended, "Extended" },
	{ (long)High, "High" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__H264Profile2s(struct soap *soap, enum tt__H264Profile n)
{	const char *s = soap_code_str(soap_codes_tt__H264Profile, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__H264Profile(struct soap *soap, const char *tag, int id, const enum tt__H264Profile *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__H264Profile), type) || soap_send(soap, soap_tt__H264Profile2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__H264Profile(struct soap *soap, const char *s, enum tt__H264Profile *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__H264Profile, s);
	if (map)
		*a = (enum tt__H264Profile)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__H264Profile)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__H264Profile * SOAP_FMAC4 soap_in_tt__H264Profile(struct soap *soap, const char *tag, enum tt__H264Profile *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__H264Profile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__H264Profile, sizeof(enum tt__H264Profile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__H264Profile(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__H264Profile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__H264Profile, 0, sizeof(enum tt__H264Profile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__H264Profile(struct soap *soap, const enum tt__H264Profile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__H264Profile);
	if (soap_out_tt__H264Profile(soap, tag?tag:"tt:H264Profile", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__H264Profile * SOAP_FMAC4 soap_get_tt__H264Profile(struct soap *soap, enum tt__H264Profile *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__H264Profile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__Mpeg4Profile(struct soap *soap, enum tt__Mpeg4Profile *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__Mpeg4Profile
	*a = SOAP_DEFAULT_tt__Mpeg4Profile;
#else
	*a = (enum tt__Mpeg4Profile)0;
#endif
}

static const struct soap_code_map soap_codes_tt__Mpeg4Profile[] =
{	{ (long)SP, "SP" },
	{ (long)ASP, "ASP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__Mpeg4Profile2s(struct soap *soap, enum tt__Mpeg4Profile n)
{	const char *s = soap_code_str(soap_codes_tt__Mpeg4Profile, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__Mpeg4Profile(struct soap *soap, const char *tag, int id, const enum tt__Mpeg4Profile *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__Mpeg4Profile), type) || soap_send(soap, soap_tt__Mpeg4Profile2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__Mpeg4Profile(struct soap *soap, const char *s, enum tt__Mpeg4Profile *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__Mpeg4Profile, s);
	if (map)
		*a = (enum tt__Mpeg4Profile)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__Mpeg4Profile)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__Mpeg4Profile * SOAP_FMAC4 soap_in_tt__Mpeg4Profile(struct soap *soap, const char *tag, enum tt__Mpeg4Profile *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__Mpeg4Profile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__Mpeg4Profile, sizeof(enum tt__Mpeg4Profile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__Mpeg4Profile(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__Mpeg4Profile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__Mpeg4Profile, 0, sizeof(enum tt__Mpeg4Profile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__Mpeg4Profile(struct soap *soap, const enum tt__Mpeg4Profile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__Mpeg4Profile);
	if (soap_out_tt__Mpeg4Profile(soap, tag?tag:"tt:Mpeg4Profile", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__Mpeg4Profile * SOAP_FMAC4 soap_get_tt__Mpeg4Profile(struct soap *soap, enum tt__Mpeg4Profile *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__Mpeg4Profile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__VideoEncoding(struct soap *soap, enum tt__VideoEncoding *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__VideoEncoding
	*a = SOAP_DEFAULT_tt__VideoEncoding;
#else
	*a = (enum tt__VideoEncoding)0;
#endif
}

static const struct soap_code_map soap_codes_tt__VideoEncoding[] =
{	{ (long)JPEG, "JPEG" },
	{ (long)MPEG4, "MPEG4" },
	{ (long)H264, "H264" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__VideoEncoding2s(struct soap *soap, enum tt__VideoEncoding n)
{	const char *s = soap_code_str(soap_codes_tt__VideoEncoding, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__VideoEncoding(struct soap *soap, const char *tag, int id, const enum tt__VideoEncoding *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__VideoEncoding), type) || soap_send(soap, soap_tt__VideoEncoding2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__VideoEncoding(struct soap *soap, const char *s, enum tt__VideoEncoding *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__VideoEncoding, s);
	if (map)
		*a = (enum tt__VideoEncoding)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__VideoEncoding)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__VideoEncoding * SOAP_FMAC4 soap_in_tt__VideoEncoding(struct soap *soap, const char *tag, enum tt__VideoEncoding *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__VideoEncoding *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__VideoEncoding, sizeof(enum tt__VideoEncoding), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__VideoEncoding(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__VideoEncoding *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__VideoEncoding, 0, sizeof(enum tt__VideoEncoding), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__VideoEncoding(struct soap *soap, const enum tt__VideoEncoding *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__VideoEncoding);
	if (soap_out_tt__VideoEncoding(soap, tag?tag:"tt:VideoEncoding", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__VideoEncoding * SOAP_FMAC4 soap_get_tt__VideoEncoding(struct soap *soap, enum tt__VideoEncoding *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__VideoEncoding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean(struct soap *soap, enum xsd__boolean *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_xsd__boolean
	*a = SOAP_DEFAULT_xsd__boolean;
#else
	*a = (enum xsd__boolean)0;
#endif
}

static const struct soap_code_map soap_codes_xsd__boolean[] =
{	{ (long)false_, "false" },
	{ (long)true_, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean2s(struct soap *soap, enum xsd__boolean n)
{
	(void)soap; /* appease -Wall -Werror */
return soap_code_str(soap_codes_xsd__boolean, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const enum xsd__boolean *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean), type) || soap_send(soap, soap_xsd__boolean2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean(struct soap *soap, const char *s, enum xsd__boolean *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_xsd__boolean, s);
	if (map)
		*a = (enum xsd__boolean)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum xsd__boolean)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, enum xsd__boolean *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum xsd__boolean *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(enum xsd__boolean), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xsd__boolean(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum xsd__boolean *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__boolean, 0, sizeof(enum xsd__boolean), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const enum xsd__boolean *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag?tag:"xsd:boolean", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, enum xsd__boolean *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
//	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
//		return soap->error;
//	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap->lang)
                soap_set_attr(soap, "xml:lang", soap->lang);
        if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->__any, ""))
                return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag_fault = 1;
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__wsa__MessageID(soap, &a->wsa__MessageID);
	a->wsa__RelatesTo = NULL;
	a->wsa__From = NULL;
	a->wsa__ReplyTo = NULL;
	a->wsa__FaultTo = NULL;
	soap_default__wsa__To(soap, &a->wsa__To);
	soap_default__wsa__Action(soap, &a->wsa__Action);
	a->d__AppSequence = NULL;
	a->wsse__Security = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__wsa__MessageID(soap, &a->wsa__MessageID);
	soap_serialize_PointerTo_wsa__RelatesTo(soap, &a->wsa__RelatesTo);
	soap_serialize_PointerTo_wsa__From(soap, &a->wsa__From);
	soap_serialize_PointerTo_wsa__ReplyTo(soap, &a->wsa__ReplyTo);
	soap_serialize_PointerTo_wsa__FaultTo(soap, &a->wsa__FaultTo);
	soap_serialize__wsa__To(soap, &a->wsa__To);
	soap_serialize__wsa__Action(soap, &a->wsa__Action);
	soap_serialize_PointerTo_d__AppSequence(soap, &a->d__AppSequence);
	soap_serialize_PointerTo_wsse__Security(soap, &a->wsse__Security);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	if (soap_out__wsa__MessageID(soap, "wsa:MessageID", -1, &a->wsa__MessageID, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa__RelatesTo(soap, "wsa:RelatesTo", -1, &a->wsa__RelatesTo, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa__From(soap, "wsa:From", -1, &a->wsa__From, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa__ReplyTo(soap, "wsa:ReplyTo", -1, &a->wsa__ReplyTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa__FaultTo(soap, "wsa:FaultTo", -1, &a->wsa__FaultTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa__To(soap, "wsa:To", -1, &a->wsa__To, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa__Action(soap, "wsa:Action", -1, &a->wsa__Action, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_d__AppSequence(soap, "d:AppSequence", -1, &a->d__AppSequence, ""))
		return soap->error;
	soap->mustUnderstand = 0;
	if (soap_out_PointerTo_wsse__Security(soap, "wsse:Security", -1, &a->wsse__Security, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	size_t soap_flag_wsa__MessageID = 1;
	size_t soap_flag_wsa__RelatesTo = 1;
	size_t soap_flag_wsa__From = 1;
	size_t soap_flag_wsa__ReplyTo = 1;
	size_t soap_flag_wsa__FaultTo = 1;
	size_t soap_flag_wsa__To = 1;
	size_t soap_flag_wsa__Action = 1;
	size_t soap_flag_d__AppSequence = 1;
	size_t soap_flag_wsse__Security = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__MessageID && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__MessageID(soap, "wsa:MessageID", &a->wsa__MessageID, ""))
				{	soap_flag_wsa__MessageID--;
					continue;
				}
			if (soap_flag_wsa__RelatesTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__RelatesTo(soap, "wsa:RelatesTo", &a->wsa__RelatesTo, ""))
				{	soap_flag_wsa__RelatesTo--;
					continue;
				}
			if (soap_flag_wsa__From && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__From(soap, "wsa:From", &a->wsa__From, ""))
				{	soap_flag_wsa__From--;
					continue;
				}
			if (soap_flag_wsa__ReplyTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__ReplyTo(soap, "wsa:ReplyTo", &a->wsa__ReplyTo, ""))
				{	soap_flag_wsa__ReplyTo--;
					continue;
				}
			if (soap_flag_wsa__FaultTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__FaultTo(soap, "wsa:FaultTo", &a->wsa__FaultTo, ""))
				{	soap_flag_wsa__FaultTo--;
					continue;
				}
			if (soap_flag_wsa__To && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__To(soap, "wsa:To", &a->wsa__To, ""))
				{	soap_flag_wsa__To--;
					continue;
				}
			if (soap_flag_wsa__Action && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__Action(soap, "wsa:Action", &a->wsa__Action, ""))
				{	soap_flag_wsa__Action--;
					continue;
				}
			if (soap_flag_d__AppSequence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_d__AppSequence(soap, "d:AppSequence", &a->d__AppSequence, ""))
				{	soap_flag_d__AppSequence--;
					continue;
				}
			if (soap_flag_wsse__Security && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__Security(soap, "wsse:Security", &a->wsse__Security, ""))
				{	soap_flag_wsse__Security--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetSnapshotUri(struct soap *soap, struct __trt__GetSnapshotUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetSnapshotUri = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetSnapshotUri(struct soap *soap, const struct __trt__GetSnapshotUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetSnapshotUri(soap, &a->trt__GetSnapshotUri);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetSnapshotUri(struct soap *soap, const char *tag, int id, const struct __trt__GetSnapshotUri *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetSnapshotUri(soap, "trt:GetSnapshotUri", -1, &a->trt__GetSnapshotUri, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetSnapshotUri * SOAP_FMAC4 soap_in___trt__GetSnapshotUri(struct soap *soap, const char *tag, struct __trt__GetSnapshotUri *a, const char *type)
{
	size_t soap_flag_trt__GetSnapshotUri = 1;
	short soap_flag;
	a = (struct __trt__GetSnapshotUri *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetSnapshotUri, sizeof(struct __trt__GetSnapshotUri), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetSnapshotUri(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetSnapshotUri && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetSnapshotUri(soap, "trt:GetSnapshotUri", &a->trt__GetSnapshotUri, ""))
				{	soap_flag_trt__GetSnapshotUri--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetSnapshotUri(struct soap *soap, const struct __trt__GetSnapshotUri *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetSnapshotUri(soap, tag?tag:"-trt:GetSnapshotUri", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetSnapshotUri * SOAP_FMAC4 soap_get___trt__GetSnapshotUri(struct soap *soap, struct __trt__GetSnapshotUri *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetSnapshotUri(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetStreamUri(struct soap *soap, struct __trt__GetStreamUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetStreamUri = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetStreamUri(struct soap *soap, const struct __trt__GetStreamUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetStreamUri(soap, &a->trt__GetStreamUri);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetStreamUri(struct soap *soap, const char *tag, int id, const struct __trt__GetStreamUri *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetStreamUri(soap, "trt:GetStreamUri", -1, &a->trt__GetStreamUri, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetStreamUri * SOAP_FMAC4 soap_in___trt__GetStreamUri(struct soap *soap, const char *tag, struct __trt__GetStreamUri *a, const char *type)
{
	size_t soap_flag_trt__GetStreamUri = 1;
	short soap_flag;
	a = (struct __trt__GetStreamUri *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetStreamUri, sizeof(struct __trt__GetStreamUri), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetStreamUri(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetStreamUri && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetStreamUri(soap, "trt:GetStreamUri", &a->trt__GetStreamUri, ""))
				{	soap_flag_trt__GetStreamUri--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetStreamUri(struct soap *soap, const struct __trt__GetStreamUri *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetStreamUri(soap, tag?tag:"-trt:GetStreamUri", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetStreamUri * SOAP_FMAC4 soap_get___trt__GetStreamUri(struct soap *soap, struct __trt__GetStreamUri *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetStreamUri(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, struct __trt__GetAudioEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioEncoderConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const struct __trt__GetAudioEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, &a->trt__GetAudioEncoderConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioEncoderConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, "trt:GetAudioEncoderConfigurationOptions", -1, &a->trt__GetAudioEncoderConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetAudioEncoderConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetAudioEncoderConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetAudioEncoderConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioEncoderConfigurationOptions, sizeof(struct __trt__GetAudioEncoderConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioEncoderConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioEncoderConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, "trt:GetAudioEncoderConfigurationOptions", &a->trt__GetAudioEncoderConfigurationOptions, ""))
				{	soap_flag_trt__GetAudioEncoderConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const struct __trt__GetAudioEncoderConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioEncoderConfigurationOptions(soap, tag?tag:"-trt:GetAudioEncoderConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, struct __trt__GetAudioEncoderConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioEncoderConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioSourceConfigurationOptions(struct soap *soap, struct __trt__GetAudioSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioSourceConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioSourceConfigurationOptions(struct soap *soap, const struct __trt__GetAudioSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, &a->trt__GetAudioSourceConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioSourceConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioSourceConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, "trt:GetAudioSourceConfigurationOptions", -1, &a->trt__GetAudioSourceConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetAudioSourceConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetAudioSourceConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetAudioSourceConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetAudioSourceConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioSourceConfigurationOptions, sizeof(struct __trt__GetAudioSourceConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioSourceConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioSourceConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, "trt:GetAudioSourceConfigurationOptions", &a->trt__GetAudioSourceConfigurationOptions, ""))
				{	soap_flag_trt__GetAudioSourceConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioSourceConfigurationOptions(struct soap *soap, const struct __trt__GetAudioSourceConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioSourceConfigurationOptions(soap, tag?tag:"-trt:GetAudioSourceConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetAudioSourceConfigurationOptions(struct soap *soap, struct __trt__GetAudioSourceConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioSourceConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, struct __trt__GetVideoEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoEncoderConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const struct __trt__GetVideoEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, &a->trt__GetVideoEncoderConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoEncoderConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, "trt:GetVideoEncoderConfigurationOptions", -1, &a->trt__GetVideoEncoderConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetVideoEncoderConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetVideoEncoderConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetVideoEncoderConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoEncoderConfigurationOptions, sizeof(struct __trt__GetVideoEncoderConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoEncoderConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoEncoderConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, "trt:GetVideoEncoderConfigurationOptions", &a->trt__GetVideoEncoderConfigurationOptions, ""))
				{	soap_flag_trt__GetVideoEncoderConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const struct __trt__GetVideoEncoderConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoEncoderConfigurationOptions(soap, tag?tag:"-trt:GetVideoEncoderConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, struct __trt__GetVideoEncoderConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoEncoderConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoSourceConfigurationOptions(struct soap *soap, struct __trt__GetVideoSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoSourceConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoSourceConfigurationOptions(struct soap *soap, const struct __trt__GetVideoSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, &a->trt__GetVideoSourceConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoSourceConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoSourceConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, "trt:GetVideoSourceConfigurationOptions", -1, &a->trt__GetVideoSourceConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetVideoSourceConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetVideoSourceConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetVideoSourceConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetVideoSourceConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoSourceConfigurationOptions, sizeof(struct __trt__GetVideoSourceConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoSourceConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoSourceConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, "trt:GetVideoSourceConfigurationOptions", &a->trt__GetVideoSourceConfigurationOptions, ""))
				{	soap_flag_trt__GetVideoSourceConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoSourceConfigurationOptions(struct soap *soap, const struct __trt__GetVideoSourceConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoSourceConfigurationOptions(soap, tag?tag:"-trt:GetVideoSourceConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetVideoSourceConfigurationOptions(struct soap *soap, struct __trt__GetVideoSourceConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoSourceConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetAudioEncoderConfiguration(struct soap *soap, struct __trt__SetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetAudioEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetAudioEncoderConfiguration(struct soap *soap, const struct __trt__SetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetAudioEncoderConfiguration(soap, &a->trt__SetAudioEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetAudioEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetAudioEncoderConfiguration(soap, "trt:SetAudioEncoderConfiguration", -1, &a->trt__SetAudioEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetAudioEncoderConfiguration * SOAP_FMAC4 soap_in___trt__SetAudioEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__SetAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetAudioEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetAudioEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetAudioEncoderConfiguration, sizeof(struct __trt__SetAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetAudioEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetAudioEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetAudioEncoderConfiguration(soap, "trt:SetAudioEncoderConfiguration", &a->trt__SetAudioEncoderConfiguration, ""))
				{	soap_flag_trt__SetAudioEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetAudioEncoderConfiguration(struct soap *soap, const struct __trt__SetAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetAudioEncoderConfiguration(soap, tag?tag:"-trt:SetAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetAudioEncoderConfiguration * SOAP_FMAC4 soap_get___trt__SetAudioEncoderConfiguration(struct soap *soap, struct __trt__SetAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetAudioSourceConfiguration(struct soap *soap, struct __trt__SetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetAudioSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetAudioSourceConfiguration(struct soap *soap, const struct __trt__SetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetAudioSourceConfiguration(soap, &a->trt__SetAudioSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetAudioSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetAudioSourceConfiguration(soap, "trt:SetAudioSourceConfiguration", -1, &a->trt__SetAudioSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetAudioSourceConfiguration * SOAP_FMAC4 soap_in___trt__SetAudioSourceConfiguration(struct soap *soap, const char *tag, struct __trt__SetAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetAudioSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetAudioSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetAudioSourceConfiguration, sizeof(struct __trt__SetAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetAudioSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetAudioSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetAudioSourceConfiguration(soap, "trt:SetAudioSourceConfiguration", &a->trt__SetAudioSourceConfiguration, ""))
				{	soap_flag_trt__SetAudioSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetAudioSourceConfiguration(struct soap *soap, const struct __trt__SetAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetAudioSourceConfiguration(soap, tag?tag:"-trt:SetAudioSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetAudioSourceConfiguration * SOAP_FMAC4 soap_get___trt__SetAudioSourceConfiguration(struct soap *soap, struct __trt__SetAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetVideoEncoderConfiguration(struct soap *soap, struct __trt__SetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetVideoEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetVideoEncoderConfiguration(struct soap *soap, const struct __trt__SetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetVideoEncoderConfiguration(soap, &a->trt__SetVideoEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetVideoEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetVideoEncoderConfiguration(soap, "trt:SetVideoEncoderConfiguration", -1, &a->trt__SetVideoEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetVideoEncoderConfiguration * SOAP_FMAC4 soap_in___trt__SetVideoEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__SetVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetVideoEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetVideoEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetVideoEncoderConfiguration, sizeof(struct __trt__SetVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetVideoEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetVideoEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetVideoEncoderConfiguration(soap, "trt:SetVideoEncoderConfiguration", &a->trt__SetVideoEncoderConfiguration, ""))
				{	soap_flag_trt__SetVideoEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetVideoEncoderConfiguration(struct soap *soap, const struct __trt__SetVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetVideoEncoderConfiguration(soap, tag?tag:"-trt:SetVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetVideoEncoderConfiguration * SOAP_FMAC4 soap_get___trt__SetVideoEncoderConfiguration(struct soap *soap, struct __trt__SetVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetVideoSourceConfiguration(struct soap *soap, struct __trt__SetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetVideoSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetVideoSourceConfiguration(struct soap *soap, const struct __trt__SetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetVideoSourceConfiguration(soap, &a->trt__SetVideoSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetVideoSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetVideoSourceConfiguration(soap, "trt:SetVideoSourceConfiguration", -1, &a->trt__SetVideoSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetVideoSourceConfiguration * SOAP_FMAC4 soap_in___trt__SetVideoSourceConfiguration(struct soap *soap, const char *tag, struct __trt__SetVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetVideoSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetVideoSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetVideoSourceConfiguration, sizeof(struct __trt__SetVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetVideoSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetVideoSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetVideoSourceConfiguration(soap, "trt:SetVideoSourceConfiguration", &a->trt__SetVideoSourceConfiguration, ""))
				{	soap_flag_trt__SetVideoSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetVideoSourceConfiguration(struct soap *soap, const struct __trt__SetVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetVideoSourceConfiguration(soap, tag?tag:"-trt:SetVideoSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetVideoSourceConfiguration * SOAP_FMAC4 soap_get___trt__SetVideoSourceConfiguration(struct soap *soap, struct __trt__SetVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, struct __trt__GetCompatibleAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleAudioSourceConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const struct __trt__GetCompatibleAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, &a->trt__GetCompatibleAudioSourceConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleAudioSourceConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, "trt:GetCompatibleAudioSourceConfigurations", -1, &a->trt__GetCompatibleAudioSourceConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleAudioSourceConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleAudioSourceConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleAudioSourceConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleAudioSourceConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleAudioSourceConfigurations, sizeof(struct __trt__GetCompatibleAudioSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleAudioSourceConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleAudioSourceConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, "trt:GetCompatibleAudioSourceConfigurations", &a->trt__GetCompatibleAudioSourceConfigurations, ""))
				{	soap_flag_trt__GetCompatibleAudioSourceConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const struct __trt__GetCompatibleAudioSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleAudioSourceConfigurations(soap, tag?tag:"-trt:GetCompatibleAudioSourceConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleAudioSourceConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, struct __trt__GetCompatibleAudioSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleAudioSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, struct __trt__GetCompatibleAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleAudioEncoderConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const struct __trt__GetCompatibleAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, &a->trt__GetCompatibleAudioEncoderConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleAudioEncoderConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, "trt:GetCompatibleAudioEncoderConfigurations", -1, &a->trt__GetCompatibleAudioEncoderConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleAudioEncoderConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleAudioEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleAudioEncoderConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleAudioEncoderConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleAudioEncoderConfigurations, sizeof(struct __trt__GetCompatibleAudioEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleAudioEncoderConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleAudioEncoderConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, "trt:GetCompatibleAudioEncoderConfigurations", &a->trt__GetCompatibleAudioEncoderConfigurations, ""))
				{	soap_flag_trt__GetCompatibleAudioEncoderConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const struct __trt__GetCompatibleAudioEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleAudioEncoderConfigurations(soap, tag?tag:"-trt:GetCompatibleAudioEncoderConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleAudioEncoderConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, struct __trt__GetCompatibleAudioEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleAudioEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, struct __trt__GetCompatibleVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleVideoSourceConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const struct __trt__GetCompatibleVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, &a->trt__GetCompatibleVideoSourceConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleVideoSourceConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, "trt:GetCompatibleVideoSourceConfigurations", -1, &a->trt__GetCompatibleVideoSourceConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleVideoSourceConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleVideoSourceConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleVideoSourceConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleVideoSourceConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleVideoSourceConfigurations, sizeof(struct __trt__GetCompatibleVideoSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleVideoSourceConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleVideoSourceConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, "trt:GetCompatibleVideoSourceConfigurations", &a->trt__GetCompatibleVideoSourceConfigurations, ""))
				{	soap_flag_trt__GetCompatibleVideoSourceConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const struct __trt__GetCompatibleVideoSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleVideoSourceConfigurations(soap, tag?tag:"-trt:GetCompatibleVideoSourceConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleVideoSourceConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, struct __trt__GetCompatibleVideoSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleVideoSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, struct __trt__GetCompatibleVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleVideoEncoderConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const struct __trt__GetCompatibleVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, &a->trt__GetCompatibleVideoEncoderConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleVideoEncoderConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, "trt:GetCompatibleVideoEncoderConfigurations", -1, &a->trt__GetCompatibleVideoEncoderConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleVideoEncoderConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleVideoEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleVideoEncoderConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleVideoEncoderConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleVideoEncoderConfigurations, sizeof(struct __trt__GetCompatibleVideoEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleVideoEncoderConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleVideoEncoderConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, "trt:GetCompatibleVideoEncoderConfigurations", &a->trt__GetCompatibleVideoEncoderConfigurations, ""))
				{	soap_flag_trt__GetCompatibleVideoEncoderConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const struct __trt__GetCompatibleVideoEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleVideoEncoderConfigurations(soap, tag?tag:"-trt:GetCompatibleVideoEncoderConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleVideoEncoderConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, struct __trt__GetCompatibleVideoEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleVideoEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioEncoderConfiguration(struct soap *soap, struct __trt__GetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioEncoderConfiguration(struct soap *soap, const struct __trt__GetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioEncoderConfiguration(soap, &a->trt__GetAudioEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioEncoderConfiguration(soap, "trt:GetAudioEncoderConfiguration", -1, &a->trt__GetAudioEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfiguration * SOAP_FMAC4 soap_in___trt__GetAudioEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__GetAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetAudioEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetAudioEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioEncoderConfiguration, sizeof(struct __trt__GetAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioEncoderConfiguration(soap, "trt:GetAudioEncoderConfiguration", &a->trt__GetAudioEncoderConfiguration, ""))
				{	soap_flag_trt__GetAudioEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioEncoderConfiguration(struct soap *soap, const struct __trt__GetAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioEncoderConfiguration(soap, tag?tag:"-trt:GetAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfiguration * SOAP_FMAC4 soap_get___trt__GetAudioEncoderConfiguration(struct soap *soap, struct __trt__GetAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioSourceConfiguration(struct soap *soap, struct __trt__GetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioSourceConfiguration(struct soap *soap, const struct __trt__GetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioSourceConfiguration(soap, &a->trt__GetAudioSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioSourceConfiguration(soap, "trt:GetAudioSourceConfiguration", -1, &a->trt__GetAudioSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfiguration * SOAP_FMAC4 soap_in___trt__GetAudioSourceConfiguration(struct soap *soap, const char *tag, struct __trt__GetAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetAudioSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetAudioSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioSourceConfiguration, sizeof(struct __trt__GetAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioSourceConfiguration(soap, "trt:GetAudioSourceConfiguration", &a->trt__GetAudioSourceConfiguration, ""))
				{	soap_flag_trt__GetAudioSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioSourceConfiguration(struct soap *soap, const struct __trt__GetAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioSourceConfiguration(soap, tag?tag:"-trt:GetAudioSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfiguration * SOAP_FMAC4 soap_get___trt__GetAudioSourceConfiguration(struct soap *soap, struct __trt__GetAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoEncoderConfiguration(struct soap *soap, struct __trt__GetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoEncoderConfiguration(struct soap *soap, const struct __trt__GetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoEncoderConfiguration(soap, &a->trt__GetVideoEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoEncoderConfiguration(soap, "trt:GetVideoEncoderConfiguration", -1, &a->trt__GetVideoEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfiguration * SOAP_FMAC4 soap_in___trt__GetVideoEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__GetVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetVideoEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetVideoEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoEncoderConfiguration, sizeof(struct __trt__GetVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoEncoderConfiguration(soap, "trt:GetVideoEncoderConfiguration", &a->trt__GetVideoEncoderConfiguration, ""))
				{	soap_flag_trt__GetVideoEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoEncoderConfiguration(struct soap *soap, const struct __trt__GetVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoEncoderConfiguration(soap, tag?tag:"-trt:GetVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfiguration * SOAP_FMAC4 soap_get___trt__GetVideoEncoderConfiguration(struct soap *soap, struct __trt__GetVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoSourceConfiguration(struct soap *soap, struct __trt__GetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoSourceConfiguration(struct soap *soap, const struct __trt__GetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoSourceConfiguration(soap, &a->trt__GetVideoSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoSourceConfiguration(soap, "trt:GetVideoSourceConfiguration", -1, &a->trt__GetVideoSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfiguration * SOAP_FMAC4 soap_in___trt__GetVideoSourceConfiguration(struct soap *soap, const char *tag, struct __trt__GetVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetVideoSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetVideoSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoSourceConfiguration, sizeof(struct __trt__GetVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoSourceConfiguration(soap, "trt:GetVideoSourceConfiguration", &a->trt__GetVideoSourceConfiguration, ""))
				{	soap_flag_trt__GetVideoSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoSourceConfiguration(struct soap *soap, const struct __trt__GetVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoSourceConfiguration(soap, tag?tag:"-trt:GetVideoSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfiguration * SOAP_FMAC4 soap_get___trt__GetVideoSourceConfiguration(struct soap *soap, struct __trt__GetVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioEncoderConfigurations(struct soap *soap, struct __trt__GetAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioEncoderConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioEncoderConfigurations(struct soap *soap, const struct __trt__GetAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioEncoderConfigurations(soap, &a->trt__GetAudioEncoderConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioEncoderConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioEncoderConfigurations(soap, "trt:GetAudioEncoderConfigurations", -1, &a->trt__GetAudioEncoderConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfigurations * SOAP_FMAC4 soap_in___trt__GetAudioEncoderConfigurations(struct soap *soap, const char *tag, struct __trt__GetAudioEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetAudioEncoderConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetAudioEncoderConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioEncoderConfigurations, sizeof(struct __trt__GetAudioEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioEncoderConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioEncoderConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioEncoderConfigurations(soap, "trt:GetAudioEncoderConfigurations", &a->trt__GetAudioEncoderConfigurations, ""))
				{	soap_flag_trt__GetAudioEncoderConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioEncoderConfigurations(struct soap *soap, const struct __trt__GetAudioEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioEncoderConfigurations(soap, tag?tag:"-trt:GetAudioEncoderConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfigurations * SOAP_FMAC4 soap_get___trt__GetAudioEncoderConfigurations(struct soap *soap, struct __trt__GetAudioEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioSourceConfigurations(struct soap *soap, struct __trt__GetAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioSourceConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioSourceConfigurations(struct soap *soap, const struct __trt__GetAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioSourceConfigurations(soap, &a->trt__GetAudioSourceConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioSourceConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioSourceConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioSourceConfigurations(soap, "trt:GetAudioSourceConfigurations", -1, &a->trt__GetAudioSourceConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfigurations * SOAP_FMAC4 soap_in___trt__GetAudioSourceConfigurations(struct soap *soap, const char *tag, struct __trt__GetAudioSourceConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetAudioSourceConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetAudioSourceConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioSourceConfigurations, sizeof(struct __trt__GetAudioSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioSourceConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioSourceConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioSourceConfigurations(soap, "trt:GetAudioSourceConfigurations", &a->trt__GetAudioSourceConfigurations, ""))
				{	soap_flag_trt__GetAudioSourceConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioSourceConfigurations(struct soap *soap, const struct __trt__GetAudioSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioSourceConfigurations(soap, tag?tag:"-trt:GetAudioSourceConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfigurations * SOAP_FMAC4 soap_get___trt__GetAudioSourceConfigurations(struct soap *soap, struct __trt__GetAudioSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoEncoderConfigurations(struct soap *soap, struct __trt__GetVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoEncoderConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoEncoderConfigurations(struct soap *soap, const struct __trt__GetVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoEncoderConfigurations(soap, &a->trt__GetVideoEncoderConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoEncoderConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoEncoderConfigurations(soap, "trt:GetVideoEncoderConfigurations", -1, &a->trt__GetVideoEncoderConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfigurations * SOAP_FMAC4 soap_in___trt__GetVideoEncoderConfigurations(struct soap *soap, const char *tag, struct __trt__GetVideoEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetVideoEncoderConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetVideoEncoderConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoEncoderConfigurations, sizeof(struct __trt__GetVideoEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoEncoderConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoEncoderConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoEncoderConfigurations(soap, "trt:GetVideoEncoderConfigurations", &a->trt__GetVideoEncoderConfigurations, ""))
				{	soap_flag_trt__GetVideoEncoderConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoEncoderConfigurations(struct soap *soap, const struct __trt__GetVideoEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoEncoderConfigurations(soap, tag?tag:"-trt:GetVideoEncoderConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfigurations * SOAP_FMAC4 soap_get___trt__GetVideoEncoderConfigurations(struct soap *soap, struct __trt__GetVideoEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoSourceConfigurations(struct soap *soap, struct __trt__GetVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoSourceConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoSourceConfigurations(struct soap *soap, const struct __trt__GetVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoSourceConfigurations(soap, &a->trt__GetVideoSourceConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoSourceConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoSourceConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoSourceConfigurations(soap, "trt:GetVideoSourceConfigurations", -1, &a->trt__GetVideoSourceConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfigurations * SOAP_FMAC4 soap_in___trt__GetVideoSourceConfigurations(struct soap *soap, const char *tag, struct __trt__GetVideoSourceConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetVideoSourceConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetVideoSourceConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoSourceConfigurations, sizeof(struct __trt__GetVideoSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoSourceConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoSourceConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoSourceConfigurations(soap, "trt:GetVideoSourceConfigurations", &a->trt__GetVideoSourceConfigurations, ""))
				{	soap_flag_trt__GetVideoSourceConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoSourceConfigurations(struct soap *soap, const struct __trt__GetVideoSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoSourceConfigurations(soap, tag?tag:"-trt:GetVideoSourceConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfigurations * SOAP_FMAC4 soap_get___trt__GetVideoSourceConfigurations(struct soap *soap, struct __trt__GetVideoSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__DeleteProfile(struct soap *soap, struct __trt__DeleteProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__DeleteProfile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__DeleteProfile(struct soap *soap, const struct __trt__DeleteProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__DeleteProfile(soap, &a->trt__DeleteProfile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__DeleteProfile(struct soap *soap, const char *tag, int id, const struct __trt__DeleteProfile *a, const char *type)
{
	if (soap_out_PointerTo_trt__DeleteProfile(soap, "trt:DeleteProfile", -1, &a->trt__DeleteProfile, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__DeleteProfile * SOAP_FMAC4 soap_in___trt__DeleteProfile(struct soap *soap, const char *tag, struct __trt__DeleteProfile *a, const char *type)
{
	size_t soap_flag_trt__DeleteProfile = 1;
	short soap_flag;
	a = (struct __trt__DeleteProfile *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__DeleteProfile, sizeof(struct __trt__DeleteProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__DeleteProfile(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__DeleteProfile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__DeleteProfile(soap, "trt:DeleteProfile", &a->trt__DeleteProfile, ""))
				{	soap_flag_trt__DeleteProfile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__DeleteProfile(struct soap *soap, const struct __trt__DeleteProfile *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__DeleteProfile(soap, tag?tag:"-trt:DeleteProfile", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__DeleteProfile * SOAP_FMAC4 soap_get___trt__DeleteProfile(struct soap *soap, struct __trt__DeleteProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__DeleteProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveAudioSourceConfiguration(struct soap *soap, struct __trt__RemoveAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveAudioSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveAudioSourceConfiguration(struct soap *soap, const struct __trt__RemoveAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveAudioSourceConfiguration(soap, &a->trt__RemoveAudioSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveAudioSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveAudioSourceConfiguration(soap, "trt:RemoveAudioSourceConfiguration", -1, &a->trt__RemoveAudioSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveAudioSourceConfiguration * SOAP_FMAC4 soap_in___trt__RemoveAudioSourceConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveAudioSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveAudioSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveAudioSourceConfiguration, sizeof(struct __trt__RemoveAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveAudioSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveAudioSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveAudioSourceConfiguration(soap, "trt:RemoveAudioSourceConfiguration", &a->trt__RemoveAudioSourceConfiguration, ""))
				{	soap_flag_trt__RemoveAudioSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveAudioSourceConfiguration(struct soap *soap, const struct __trt__RemoveAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveAudioSourceConfiguration(soap, tag?tag:"-trt:RemoveAudioSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveAudioSourceConfiguration * SOAP_FMAC4 soap_get___trt__RemoveAudioSourceConfiguration(struct soap *soap, struct __trt__RemoveAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveAudioEncoderConfiguration(struct soap *soap, struct __trt__RemoveAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveAudioEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveAudioEncoderConfiguration(struct soap *soap, const struct __trt__RemoveAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, &a->trt__RemoveAudioEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveAudioEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, "trt:RemoveAudioEncoderConfiguration", -1, &a->trt__RemoveAudioEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveAudioEncoderConfiguration * SOAP_FMAC4 soap_in___trt__RemoveAudioEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveAudioEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveAudioEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveAudioEncoderConfiguration, sizeof(struct __trt__RemoveAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveAudioEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveAudioEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, "trt:RemoveAudioEncoderConfiguration", &a->trt__RemoveAudioEncoderConfiguration, ""))
				{	soap_flag_trt__RemoveAudioEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveAudioEncoderConfiguration(struct soap *soap, const struct __trt__RemoveAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveAudioEncoderConfiguration(soap, tag?tag:"-trt:RemoveAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveAudioEncoderConfiguration * SOAP_FMAC4 soap_get___trt__RemoveAudioEncoderConfiguration(struct soap *soap, struct __trt__RemoveAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveVideoSourceConfiguration(struct soap *soap, struct __trt__RemoveVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveVideoSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveVideoSourceConfiguration(struct soap *soap, const struct __trt__RemoveVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveVideoSourceConfiguration(soap, &a->trt__RemoveVideoSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveVideoSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveVideoSourceConfiguration(soap, "trt:RemoveVideoSourceConfiguration", -1, &a->trt__RemoveVideoSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveVideoSourceConfiguration * SOAP_FMAC4 soap_in___trt__RemoveVideoSourceConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveVideoSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveVideoSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveVideoSourceConfiguration, sizeof(struct __trt__RemoveVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveVideoSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveVideoSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveVideoSourceConfiguration(soap, "trt:RemoveVideoSourceConfiguration", &a->trt__RemoveVideoSourceConfiguration, ""))
				{	soap_flag_trt__RemoveVideoSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveVideoSourceConfiguration(struct soap *soap, const struct __trt__RemoveVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveVideoSourceConfiguration(soap, tag?tag:"-trt:RemoveVideoSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveVideoSourceConfiguration * SOAP_FMAC4 soap_get___trt__RemoveVideoSourceConfiguration(struct soap *soap, struct __trt__RemoveVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveVideoEncoderConfiguration(struct soap *soap, struct __trt__RemoveVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveVideoEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveVideoEncoderConfiguration(struct soap *soap, const struct __trt__RemoveVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, &a->trt__RemoveVideoEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveVideoEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, "trt:RemoveVideoEncoderConfiguration", -1, &a->trt__RemoveVideoEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveVideoEncoderConfiguration * SOAP_FMAC4 soap_in___trt__RemoveVideoEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveVideoEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveVideoEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveVideoEncoderConfiguration, sizeof(struct __trt__RemoveVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveVideoEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveVideoEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, "trt:RemoveVideoEncoderConfiguration", &a->trt__RemoveVideoEncoderConfiguration, ""))
				{	soap_flag_trt__RemoveVideoEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveVideoEncoderConfiguration(struct soap *soap, const struct __trt__RemoveVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveVideoEncoderConfiguration(soap, tag?tag:"-trt:RemoveVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveVideoEncoderConfiguration * SOAP_FMAC4 soap_get___trt__RemoveVideoEncoderConfiguration(struct soap *soap, struct __trt__RemoveVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddAudioSourceConfiguration(struct soap *soap, struct __trt__AddAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddAudioSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddAudioSourceConfiguration(struct soap *soap, const struct __trt__AddAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddAudioSourceConfiguration(soap, &a->trt__AddAudioSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddAudioSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddAudioSourceConfiguration(soap, "trt:AddAudioSourceConfiguration", -1, &a->trt__AddAudioSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddAudioSourceConfiguration * SOAP_FMAC4 soap_in___trt__AddAudioSourceConfiguration(struct soap *soap, const char *tag, struct __trt__AddAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddAudioSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddAudioSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddAudioSourceConfiguration, sizeof(struct __trt__AddAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddAudioSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddAudioSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddAudioSourceConfiguration(soap, "trt:AddAudioSourceConfiguration", &a->trt__AddAudioSourceConfiguration, ""))
				{	soap_flag_trt__AddAudioSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddAudioSourceConfiguration(struct soap *soap, const struct __trt__AddAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddAudioSourceConfiguration(soap, tag?tag:"-trt:AddAudioSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddAudioSourceConfiguration * SOAP_FMAC4 soap_get___trt__AddAudioSourceConfiguration(struct soap *soap, struct __trt__AddAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddAudioEncoderConfiguration(struct soap *soap, struct __trt__AddAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddAudioEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddAudioEncoderConfiguration(struct soap *soap, const struct __trt__AddAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddAudioEncoderConfiguration(soap, &a->trt__AddAudioEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddAudioEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddAudioEncoderConfiguration(soap, "trt:AddAudioEncoderConfiguration", -1, &a->trt__AddAudioEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddAudioEncoderConfiguration * SOAP_FMAC4 soap_in___trt__AddAudioEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__AddAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddAudioEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddAudioEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddAudioEncoderConfiguration, sizeof(struct __trt__AddAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddAudioEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddAudioEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddAudioEncoderConfiguration(soap, "trt:AddAudioEncoderConfiguration", &a->trt__AddAudioEncoderConfiguration, ""))
				{	soap_flag_trt__AddAudioEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddAudioEncoderConfiguration(struct soap *soap, const struct __trt__AddAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddAudioEncoderConfiguration(soap, tag?tag:"-trt:AddAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddAudioEncoderConfiguration * SOAP_FMAC4 soap_get___trt__AddAudioEncoderConfiguration(struct soap *soap, struct __trt__AddAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddVideoSourceConfiguration(struct soap *soap, struct __trt__AddVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddVideoSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddVideoSourceConfiguration(struct soap *soap, const struct __trt__AddVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddVideoSourceConfiguration(soap, &a->trt__AddVideoSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddVideoSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddVideoSourceConfiguration(soap, "trt:AddVideoSourceConfiguration", -1, &a->trt__AddVideoSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddVideoSourceConfiguration * SOAP_FMAC4 soap_in___trt__AddVideoSourceConfiguration(struct soap *soap, const char *tag, struct __trt__AddVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddVideoSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddVideoSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddVideoSourceConfiguration, sizeof(struct __trt__AddVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddVideoSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddVideoSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddVideoSourceConfiguration(soap, "trt:AddVideoSourceConfiguration", &a->trt__AddVideoSourceConfiguration, ""))
				{	soap_flag_trt__AddVideoSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddVideoSourceConfiguration(struct soap *soap, const struct __trt__AddVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddVideoSourceConfiguration(soap, tag?tag:"-trt:AddVideoSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddVideoSourceConfiguration * SOAP_FMAC4 soap_get___trt__AddVideoSourceConfiguration(struct soap *soap, struct __trt__AddVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddVideoEncoderConfiguration(struct soap *soap, struct __trt__AddVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddVideoEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddVideoEncoderConfiguration(struct soap *soap, const struct __trt__AddVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddVideoEncoderConfiguration(soap, &a->trt__AddVideoEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddVideoEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddVideoEncoderConfiguration(soap, "trt:AddVideoEncoderConfiguration", -1, &a->trt__AddVideoEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddVideoEncoderConfiguration * SOAP_FMAC4 soap_in___trt__AddVideoEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__AddVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddVideoEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddVideoEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddVideoEncoderConfiguration, sizeof(struct __trt__AddVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddVideoEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddVideoEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddVideoEncoderConfiguration(soap, "trt:AddVideoEncoderConfiguration", &a->trt__AddVideoEncoderConfiguration, ""))
				{	soap_flag_trt__AddVideoEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddVideoEncoderConfiguration(struct soap *soap, const struct __trt__AddVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddVideoEncoderConfiguration(soap, tag?tag:"-trt:AddVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddVideoEncoderConfiguration * SOAP_FMAC4 soap_get___trt__AddVideoEncoderConfiguration(struct soap *soap, struct __trt__AddVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetProfiles(struct soap *soap, struct __trt__GetProfiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetProfiles = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetProfiles(struct soap *soap, const struct __trt__GetProfiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetProfiles(soap, &a->trt__GetProfiles);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetProfiles(struct soap *soap, const char *tag, int id, const struct __trt__GetProfiles *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetProfiles(soap, "trt:GetProfiles", -1, &a->trt__GetProfiles, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetProfiles * SOAP_FMAC4 soap_in___trt__GetProfiles(struct soap *soap, const char *tag, struct __trt__GetProfiles *a, const char *type)
{
	size_t soap_flag_trt__GetProfiles = 1;
	short soap_flag;
	a = (struct __trt__GetProfiles *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetProfiles, sizeof(struct __trt__GetProfiles), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetProfiles(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetProfiles && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetProfiles(soap, "trt:GetProfiles", &a->trt__GetProfiles, ""))
				{	soap_flag_trt__GetProfiles--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetProfiles(struct soap *soap, const struct __trt__GetProfiles *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetProfiles(soap, tag?tag:"-trt:GetProfiles", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetProfiles * SOAP_FMAC4 soap_get___trt__GetProfiles(struct soap *soap, struct __trt__GetProfiles *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetProfiles(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetProfile(struct soap *soap, struct __trt__GetProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetProfile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetProfile(struct soap *soap, const struct __trt__GetProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetProfile(soap, &a->trt__GetProfile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetProfile(struct soap *soap, const char *tag, int id, const struct __trt__GetProfile *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetProfile(soap, "trt:GetProfile", -1, &a->trt__GetProfile, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetProfile * SOAP_FMAC4 soap_in___trt__GetProfile(struct soap *soap, const char *tag, struct __trt__GetProfile *a, const char *type)
{
	size_t soap_flag_trt__GetProfile = 1;
	short soap_flag;
	a = (struct __trt__GetProfile *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetProfile, sizeof(struct __trt__GetProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetProfile(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetProfile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetProfile(soap, "trt:GetProfile", &a->trt__GetProfile, ""))
				{	soap_flag_trt__GetProfile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetProfile(struct soap *soap, const struct __trt__GetProfile *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetProfile(soap, tag?tag:"-trt:GetProfile", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetProfile * SOAP_FMAC4 soap_get___trt__GetProfile(struct soap *soap, struct __trt__GetProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__CreateProfile(struct soap *soap, struct __trt__CreateProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__CreateProfile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__CreateProfile(struct soap *soap, const struct __trt__CreateProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__CreateProfile(soap, &a->trt__CreateProfile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__CreateProfile(struct soap *soap, const char *tag, int id, const struct __trt__CreateProfile *a, const char *type)
{
	if (soap_out_PointerTo_trt__CreateProfile(soap, "trt:CreateProfile", -1, &a->trt__CreateProfile, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__CreateProfile * SOAP_FMAC4 soap_in___trt__CreateProfile(struct soap *soap, const char *tag, struct __trt__CreateProfile *a, const char *type)
{
	size_t soap_flag_trt__CreateProfile = 1;
	short soap_flag;
	a = (struct __trt__CreateProfile *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__CreateProfile, sizeof(struct __trt__CreateProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__CreateProfile(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__CreateProfile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__CreateProfile(soap, "trt:CreateProfile", &a->trt__CreateProfile, ""))
				{	soap_flag_trt__CreateProfile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__CreateProfile(struct soap *soap, const struct __trt__CreateProfile *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__CreateProfile(soap, tag?tag:"-trt:CreateProfile", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__CreateProfile * SOAP_FMAC4 soap_get___trt__CreateProfile(struct soap *soap, struct __trt__CreateProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__CreateProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioSources(struct soap *soap, struct __trt__GetAudioSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioSources = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioSources(struct soap *soap, const struct __trt__GetAudioSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioSources(soap, &a->trt__GetAudioSources);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioSources(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioSources *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioSources(soap, "trt:GetAudioSources", -1, &a->trt__GetAudioSources, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSources * SOAP_FMAC4 soap_in___trt__GetAudioSources(struct soap *soap, const char *tag, struct __trt__GetAudioSources *a, const char *type)
{
	size_t soap_flag_trt__GetAudioSources = 1;
	short soap_flag;
	a = (struct __trt__GetAudioSources *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioSources, sizeof(struct __trt__GetAudioSources), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioSources(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioSources && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioSources(soap, "trt:GetAudioSources", &a->trt__GetAudioSources, ""))
				{	soap_flag_trt__GetAudioSources--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioSources(struct soap *soap, const struct __trt__GetAudioSources *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioSources(soap, tag?tag:"-trt:GetAudioSources", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSources * SOAP_FMAC4 soap_get___trt__GetAudioSources(struct soap *soap, struct __trt__GetAudioSources *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioSources(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoSources(struct soap *soap, struct __trt__GetVideoSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoSources = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoSources(struct soap *soap, const struct __trt__GetVideoSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoSources(soap, &a->trt__GetVideoSources);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoSources(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoSources *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoSources(soap, "trt:GetVideoSources", -1, &a->trt__GetVideoSources, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSources * SOAP_FMAC4 soap_in___trt__GetVideoSources(struct soap *soap, const char *tag, struct __trt__GetVideoSources *a, const char *type)
{
	size_t soap_flag_trt__GetVideoSources = 1;
	short soap_flag;
	a = (struct __trt__GetVideoSources *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoSources, sizeof(struct __trt__GetVideoSources), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoSources(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoSources && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoSources(soap, "trt:GetVideoSources", &a->trt__GetVideoSources, ""))
				{	soap_flag_trt__GetVideoSources--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoSources(struct soap *soap, const struct __trt__GetVideoSources *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoSources(soap, tag?tag:"-trt:GetVideoSources", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSources * SOAP_FMAC4 soap_get___trt__GetVideoSources(struct soap *soap, struct __trt__GetVideoSources *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoSources(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetZeroConfiguration(struct soap *soap, struct __tds__SetZeroConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetZeroConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetZeroConfiguration(struct soap *soap, const struct __tds__SetZeroConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetZeroConfiguration(soap, &a->tds__SetZeroConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetZeroConfiguration(struct soap *soap, const char *tag, int id, const struct __tds__SetZeroConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetZeroConfiguration(soap, "tds:SetZeroConfiguration", -1, &a->tds__SetZeroConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetZeroConfiguration * SOAP_FMAC4 soap_in___tds__SetZeroConfiguration(struct soap *soap, const char *tag, struct __tds__SetZeroConfiguration *a, const char *type)
{
	size_t soap_flag_tds__SetZeroConfiguration = 1;
	short soap_flag;
	a = (struct __tds__SetZeroConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetZeroConfiguration, sizeof(struct __tds__SetZeroConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetZeroConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetZeroConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetZeroConfiguration(soap, "tds:SetZeroConfiguration", &a->tds__SetZeroConfiguration, ""))
				{	soap_flag_tds__SetZeroConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetZeroConfiguration(struct soap *soap, const struct __tds__SetZeroConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetZeroConfiguration(soap, tag?tag:"-tds:SetZeroConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetZeroConfiguration * SOAP_FMAC4 soap_get___tds__SetZeroConfiguration(struct soap *soap, struct __tds__SetZeroConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetZeroConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetZeroConfiguration(struct soap *soap, struct __tds__GetZeroConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetZeroConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetZeroConfiguration(struct soap *soap, const struct __tds__GetZeroConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetZeroConfiguration(soap, &a->tds__GetZeroConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetZeroConfiguration(struct soap *soap, const char *tag, int id, const struct __tds__GetZeroConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetZeroConfiguration(soap, "tds:GetZeroConfiguration", -1, &a->tds__GetZeroConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetZeroConfiguration * SOAP_FMAC4 soap_in___tds__GetZeroConfiguration(struct soap *soap, const char *tag, struct __tds__GetZeroConfiguration *a, const char *type)
{
	size_t soap_flag_tds__GetZeroConfiguration = 1;
	short soap_flag;
	a = (struct __tds__GetZeroConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetZeroConfiguration, sizeof(struct __tds__GetZeroConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetZeroConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetZeroConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetZeroConfiguration(soap, "tds:GetZeroConfiguration", &a->tds__GetZeroConfiguration, ""))
				{	soap_flag_tds__GetZeroConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetZeroConfiguration(struct soap *soap, const struct __tds__GetZeroConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetZeroConfiguration(soap, tag?tag:"-tds:GetZeroConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetZeroConfiguration * SOAP_FMAC4 soap_get___tds__GetZeroConfiguration(struct soap *soap, struct __tds__GetZeroConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetZeroConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetNetworkDefaultGateway(struct soap *soap, struct __tds__SetNetworkDefaultGateway *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetNetworkDefaultGateway = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetNetworkDefaultGateway(struct soap *soap, const struct __tds__SetNetworkDefaultGateway *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetNetworkDefaultGateway(soap, &a->tds__SetNetworkDefaultGateway);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetNetworkDefaultGateway(struct soap *soap, const char *tag, int id, const struct __tds__SetNetworkDefaultGateway *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetNetworkDefaultGateway(soap, "tds:SetNetworkDefaultGateway", -1, &a->tds__SetNetworkDefaultGateway, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkDefaultGateway * SOAP_FMAC4 soap_in___tds__SetNetworkDefaultGateway(struct soap *soap, const char *tag, struct __tds__SetNetworkDefaultGateway *a, const char *type)
{
	size_t soap_flag_tds__SetNetworkDefaultGateway = 1;
	short soap_flag;
	a = (struct __tds__SetNetworkDefaultGateway *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetNetworkDefaultGateway, sizeof(struct __tds__SetNetworkDefaultGateway), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetNetworkDefaultGateway(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetNetworkDefaultGateway && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetNetworkDefaultGateway(soap, "tds:SetNetworkDefaultGateway", &a->tds__SetNetworkDefaultGateway, ""))
				{	soap_flag_tds__SetNetworkDefaultGateway--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetNetworkDefaultGateway(struct soap *soap, const struct __tds__SetNetworkDefaultGateway *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetNetworkDefaultGateway(soap, tag?tag:"-tds:SetNetworkDefaultGateway", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkDefaultGateway * SOAP_FMAC4 soap_get___tds__SetNetworkDefaultGateway(struct soap *soap, struct __tds__SetNetworkDefaultGateway *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetNetworkDefaultGateway(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetNetworkDefaultGateway(struct soap *soap, struct __tds__GetNetworkDefaultGateway *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetNetworkDefaultGateway = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetNetworkDefaultGateway(struct soap *soap, const struct __tds__GetNetworkDefaultGateway *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetNetworkDefaultGateway(soap, &a->tds__GetNetworkDefaultGateway);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetNetworkDefaultGateway(struct soap *soap, const char *tag, int id, const struct __tds__GetNetworkDefaultGateway *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetNetworkDefaultGateway(soap, "tds:GetNetworkDefaultGateway", -1, &a->tds__GetNetworkDefaultGateway, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkDefaultGateway * SOAP_FMAC4 soap_in___tds__GetNetworkDefaultGateway(struct soap *soap, const char *tag, struct __tds__GetNetworkDefaultGateway *a, const char *type)
{
	size_t soap_flag_tds__GetNetworkDefaultGateway = 1;
	short soap_flag;
	a = (struct __tds__GetNetworkDefaultGateway *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetNetworkDefaultGateway, sizeof(struct __tds__GetNetworkDefaultGateway), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetNetworkDefaultGateway(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetNetworkDefaultGateway && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetNetworkDefaultGateway(soap, "tds:GetNetworkDefaultGateway", &a->tds__GetNetworkDefaultGateway, ""))
				{	soap_flag_tds__GetNetworkDefaultGateway--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetNetworkDefaultGateway(struct soap *soap, const struct __tds__GetNetworkDefaultGateway *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetNetworkDefaultGateway(soap, tag?tag:"-tds:GetNetworkDefaultGateway", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkDefaultGateway * SOAP_FMAC4 soap_get___tds__GetNetworkDefaultGateway(struct soap *soap, struct __tds__GetNetworkDefaultGateway *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetNetworkDefaultGateway(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetNetworkInterfaces(struct soap *soap, struct __tds__SetNetworkInterfaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetNetworkInterfaces = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetNetworkInterfaces(struct soap *soap, const struct __tds__SetNetworkInterfaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetNetworkInterfaces(soap, &a->tds__SetNetworkInterfaces);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetNetworkInterfaces(struct soap *soap, const char *tag, int id, const struct __tds__SetNetworkInterfaces *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetNetworkInterfaces(soap, "tds:SetNetworkInterfaces", -1, &a->tds__SetNetworkInterfaces, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkInterfaces * SOAP_FMAC4 soap_in___tds__SetNetworkInterfaces(struct soap *soap, const char *tag, struct __tds__SetNetworkInterfaces *a, const char *type)
{
	size_t soap_flag_tds__SetNetworkInterfaces = 1;
	short soap_flag;
	a = (struct __tds__SetNetworkInterfaces *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetNetworkInterfaces, sizeof(struct __tds__SetNetworkInterfaces), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetNetworkInterfaces(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetNetworkInterfaces && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetNetworkInterfaces(soap, "tds:SetNetworkInterfaces", &a->tds__SetNetworkInterfaces, ""))
				{	soap_flag_tds__SetNetworkInterfaces--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetNetworkInterfaces(struct soap *soap, const struct __tds__SetNetworkInterfaces *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetNetworkInterfaces(soap, tag?tag:"-tds:SetNetworkInterfaces", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkInterfaces * SOAP_FMAC4 soap_get___tds__SetNetworkInterfaces(struct soap *soap, struct __tds__SetNetworkInterfaces *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetNetworkInterfaces(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetNetworkInterfaces(struct soap *soap, struct __tds__GetNetworkInterfaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetNetworkInterfaces = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetNetworkInterfaces(struct soap *soap, const struct __tds__GetNetworkInterfaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetNetworkInterfaces(soap, &a->tds__GetNetworkInterfaces);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetNetworkInterfaces(struct soap *soap, const char *tag, int id, const struct __tds__GetNetworkInterfaces *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetNetworkInterfaces(soap, "tds:GetNetworkInterfaces", -1, &a->tds__GetNetworkInterfaces, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkInterfaces * SOAP_FMAC4 soap_in___tds__GetNetworkInterfaces(struct soap *soap, const char *tag, struct __tds__GetNetworkInterfaces *a, const char *type)
{
	size_t soap_flag_tds__GetNetworkInterfaces = 1;
	short soap_flag;
	a = (struct __tds__GetNetworkInterfaces *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetNetworkInterfaces, sizeof(struct __tds__GetNetworkInterfaces), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetNetworkInterfaces(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetNetworkInterfaces && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetNetworkInterfaces(soap, "tds:GetNetworkInterfaces", &a->tds__GetNetworkInterfaces, ""))
				{	soap_flag_tds__GetNetworkInterfaces--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetNetworkInterfaces(struct soap *soap, const struct __tds__GetNetworkInterfaces *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetNetworkInterfaces(soap, tag?tag:"-tds:GetNetworkInterfaces", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkInterfaces * SOAP_FMAC4 soap_get___tds__GetNetworkInterfaces(struct soap *soap, struct __tds__GetNetworkInterfaces *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetNetworkInterfaces(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetDynamicDNS(struct soap *soap, struct __tds__SetDynamicDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetDynamicDNS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetDynamicDNS(struct soap *soap, const struct __tds__SetDynamicDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetDynamicDNS(soap, &a->tds__SetDynamicDNS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetDynamicDNS(struct soap *soap, const char *tag, int id, const struct __tds__SetDynamicDNS *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetDynamicDNS(soap, "tds:SetDynamicDNS", -1, &a->tds__SetDynamicDNS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDynamicDNS * SOAP_FMAC4 soap_in___tds__SetDynamicDNS(struct soap *soap, const char *tag, struct __tds__SetDynamicDNS *a, const char *type)
{
	size_t soap_flag_tds__SetDynamicDNS = 1;
	short soap_flag;
	a = (struct __tds__SetDynamicDNS *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetDynamicDNS, sizeof(struct __tds__SetDynamicDNS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetDynamicDNS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetDynamicDNS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetDynamicDNS(soap, "tds:SetDynamicDNS", &a->tds__SetDynamicDNS, ""))
				{	soap_flag_tds__SetDynamicDNS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetDynamicDNS(struct soap *soap, const struct __tds__SetDynamicDNS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetDynamicDNS(soap, tag?tag:"-tds:SetDynamicDNS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDynamicDNS * SOAP_FMAC4 soap_get___tds__SetDynamicDNS(struct soap *soap, struct __tds__SetDynamicDNS *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetDynamicDNS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetDynamicDNS(struct soap *soap, struct __tds__GetDynamicDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetDynamicDNS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetDynamicDNS(struct soap *soap, const struct __tds__GetDynamicDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetDynamicDNS(soap, &a->tds__GetDynamicDNS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetDynamicDNS(struct soap *soap, const char *tag, int id, const struct __tds__GetDynamicDNS *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetDynamicDNS(soap, "tds:GetDynamicDNS", -1, &a->tds__GetDynamicDNS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDynamicDNS * SOAP_FMAC4 soap_in___tds__GetDynamicDNS(struct soap *soap, const char *tag, struct __tds__GetDynamicDNS *a, const char *type)
{
	size_t soap_flag_tds__GetDynamicDNS = 1;
	short soap_flag;
	a = (struct __tds__GetDynamicDNS *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetDynamicDNS, sizeof(struct __tds__GetDynamicDNS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetDynamicDNS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetDynamicDNS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetDynamicDNS(soap, "tds:GetDynamicDNS", &a->tds__GetDynamicDNS, ""))
				{	soap_flag_tds__GetDynamicDNS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetDynamicDNS(struct soap *soap, const struct __tds__GetDynamicDNS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetDynamicDNS(soap, tag?tag:"-tds:GetDynamicDNS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDynamicDNS * SOAP_FMAC4 soap_get___tds__GetDynamicDNS(struct soap *soap, struct __tds__GetDynamicDNS *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetDynamicDNS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetNTP(struct soap *soap, struct __tds__SetNTP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetNTP = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetNTP(struct soap *soap, const struct __tds__SetNTP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetNTP(soap, &a->tds__SetNTP);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetNTP(struct soap *soap, const char *tag, int id, const struct __tds__SetNTP *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetNTP(soap, "tds:SetNTP", -1, &a->tds__SetNTP, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNTP * SOAP_FMAC4 soap_in___tds__SetNTP(struct soap *soap, const char *tag, struct __tds__SetNTP *a, const char *type)
{
	size_t soap_flag_tds__SetNTP = 1;
	short soap_flag;
	a = (struct __tds__SetNTP *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetNTP, sizeof(struct __tds__SetNTP), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetNTP(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetNTP && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetNTP(soap, "tds:SetNTP", &a->tds__SetNTP, ""))
				{	soap_flag_tds__SetNTP--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetNTP(struct soap *soap, const struct __tds__SetNTP *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetNTP(soap, tag?tag:"-tds:SetNTP", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNTP * SOAP_FMAC4 soap_get___tds__SetNTP(struct soap *soap, struct __tds__SetNTP *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetNTP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetNTP(struct soap *soap, struct __tds__GetNTP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetNTP = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetNTP(struct soap *soap, const struct __tds__GetNTP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetNTP(soap, &a->tds__GetNTP);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetNTP(struct soap *soap, const char *tag, int id, const struct __tds__GetNTP *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetNTP(soap, "tds:GetNTP", -1, &a->tds__GetNTP, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNTP * SOAP_FMAC4 soap_in___tds__GetNTP(struct soap *soap, const char *tag, struct __tds__GetNTP *a, const char *type)
{
	size_t soap_flag_tds__GetNTP = 1;
	short soap_flag;
	a = (struct __tds__GetNTP *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetNTP, sizeof(struct __tds__GetNTP), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetNTP(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetNTP && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetNTP(soap, "tds:GetNTP", &a->tds__GetNTP, ""))
				{	soap_flag_tds__GetNTP--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetNTP(struct soap *soap, const struct __tds__GetNTP *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetNTP(soap, tag?tag:"-tds:GetNTP", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNTP * SOAP_FMAC4 soap_get___tds__GetNTP(struct soap *soap, struct __tds__GetNTP *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetNTP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetDNS(struct soap *soap, struct __tds__SetDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetDNS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetDNS(struct soap *soap, const struct __tds__SetDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetDNS(soap, &a->tds__SetDNS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetDNS(struct soap *soap, const char *tag, int id, const struct __tds__SetDNS *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetDNS(soap, "tds:SetDNS", -1, &a->tds__SetDNS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDNS * SOAP_FMAC4 soap_in___tds__SetDNS(struct soap *soap, const char *tag, struct __tds__SetDNS *a, const char *type)
{
	size_t soap_flag_tds__SetDNS = 1;
	short soap_flag;
	a = (struct __tds__SetDNS *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetDNS, sizeof(struct __tds__SetDNS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetDNS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetDNS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetDNS(soap, "tds:SetDNS", &a->tds__SetDNS, ""))
				{	soap_flag_tds__SetDNS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetDNS(struct soap *soap, const struct __tds__SetDNS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetDNS(soap, tag?tag:"-tds:SetDNS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDNS * SOAP_FMAC4 soap_get___tds__SetDNS(struct soap *soap, struct __tds__SetDNS *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetDNS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetDNS(struct soap *soap, struct __tds__GetDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetDNS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetDNS(struct soap *soap, const struct __tds__GetDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetDNS(soap, &a->tds__GetDNS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetDNS(struct soap *soap, const char *tag, int id, const struct __tds__GetDNS *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetDNS(soap, "tds:GetDNS", -1, &a->tds__GetDNS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDNS * SOAP_FMAC4 soap_in___tds__GetDNS(struct soap *soap, const char *tag, struct __tds__GetDNS *a, const char *type)
{
	size_t soap_flag_tds__GetDNS = 1;
	short soap_flag;
	a = (struct __tds__GetDNS *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetDNS, sizeof(struct __tds__GetDNS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetDNS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetDNS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetDNS(soap, "tds:GetDNS", &a->tds__GetDNS, ""))
				{	soap_flag_tds__GetDNS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetDNS(struct soap *soap, const struct __tds__GetDNS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetDNS(soap, tag?tag:"-tds:GetDNS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDNS * SOAP_FMAC4 soap_get___tds__GetDNS(struct soap *soap, struct __tds__GetDNS *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetDNS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetHostname(struct soap *soap, struct __tds__SetHostname *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetHostname = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetHostname(struct soap *soap, const struct __tds__SetHostname *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetHostname(soap, &a->tds__SetHostname);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetHostname(struct soap *soap, const char *tag, int id, const struct __tds__SetHostname *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetHostname(soap, "tds:SetHostname", -1, &a->tds__SetHostname, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetHostname * SOAP_FMAC4 soap_in___tds__SetHostname(struct soap *soap, const char *tag, struct __tds__SetHostname *a, const char *type)
{
	size_t soap_flag_tds__SetHostname = 1;
	short soap_flag;
	a = (struct __tds__SetHostname *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetHostname, sizeof(struct __tds__SetHostname), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetHostname(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetHostname && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetHostname(soap, "tds:SetHostname", &a->tds__SetHostname, ""))
				{	soap_flag_tds__SetHostname--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetHostname(struct soap *soap, const struct __tds__SetHostname *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetHostname(soap, tag?tag:"-tds:SetHostname", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetHostname * SOAP_FMAC4 soap_get___tds__SetHostname(struct soap *soap, struct __tds__SetHostname *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetHostname(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetHostname(struct soap *soap, struct __tds__GetHostname *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetHostname = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetHostname(struct soap *soap, const struct __tds__GetHostname *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetHostname(soap, &a->tds__GetHostname);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetHostname(struct soap *soap, const char *tag, int id, const struct __tds__GetHostname *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetHostname(soap, "tds:GetHostname", -1, &a->tds__GetHostname, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetHostname * SOAP_FMAC4 soap_in___tds__GetHostname(struct soap *soap, const char *tag, struct __tds__GetHostname *a, const char *type)
{
	size_t soap_flag_tds__GetHostname = 1;
	short soap_flag;
	a = (struct __tds__GetHostname *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetHostname, sizeof(struct __tds__GetHostname), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetHostname(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetHostname && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetHostname(soap, "tds:GetHostname", &a->tds__GetHostname, ""))
				{	soap_flag_tds__GetHostname--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetHostname(struct soap *soap, const struct __tds__GetHostname *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetHostname(soap, tag?tag:"-tds:GetHostname", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetHostname * SOAP_FMAC4 soap_get___tds__GetHostname(struct soap *soap, struct __tds__GetHostname *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetHostname(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetCapabilities(struct soap *soap, struct __tds__GetCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetCapabilities = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetCapabilities(struct soap *soap, const struct __tds__GetCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetCapabilities(soap, &a->tds__GetCapabilities);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetCapabilities(struct soap *soap, const char *tag, int id, const struct __tds__GetCapabilities *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetCapabilities(soap, "tds:GetCapabilities", -1, &a->tds__GetCapabilities, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetCapabilities * SOAP_FMAC4 soap_in___tds__GetCapabilities(struct soap *soap, const char *tag, struct __tds__GetCapabilities *a, const char *type)
{
	size_t soap_flag_tds__GetCapabilities = 1;
	short soap_flag;
	a = (struct __tds__GetCapabilities *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetCapabilities, sizeof(struct __tds__GetCapabilities), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetCapabilities(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetCapabilities && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetCapabilities(soap, "tds:GetCapabilities", &a->tds__GetCapabilities, ""))
				{	soap_flag_tds__GetCapabilities--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetCapabilities(struct soap *soap, const struct __tds__GetCapabilities *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetCapabilities(soap, tag?tag:"-tds:GetCapabilities", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetCapabilities * SOAP_FMAC4 soap_get___tds__GetCapabilities(struct soap *soap, struct __tds__GetCapabilities *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetCapabilities(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetWsdlUrl(struct soap *soap, struct __tds__GetWsdlUrl *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetWsdlUrl = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetWsdlUrl(struct soap *soap, const struct __tds__GetWsdlUrl *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetWsdlUrl(soap, &a->tds__GetWsdlUrl);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetWsdlUrl(struct soap *soap, const char *tag, int id, const struct __tds__GetWsdlUrl *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetWsdlUrl(soap, "tds:GetWsdlUrl", -1, &a->tds__GetWsdlUrl, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetWsdlUrl * SOAP_FMAC4 soap_in___tds__GetWsdlUrl(struct soap *soap, const char *tag, struct __tds__GetWsdlUrl *a, const char *type)
{
	size_t soap_flag_tds__GetWsdlUrl = 1;
	short soap_flag;
	a = (struct __tds__GetWsdlUrl *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetWsdlUrl, sizeof(struct __tds__GetWsdlUrl), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetWsdlUrl(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetWsdlUrl && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetWsdlUrl(soap, "tds:GetWsdlUrl", &a->tds__GetWsdlUrl, ""))
				{	soap_flag_tds__GetWsdlUrl--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetWsdlUrl(struct soap *soap, const struct __tds__GetWsdlUrl *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetWsdlUrl(soap, tag?tag:"-tds:GetWsdlUrl", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetWsdlUrl * SOAP_FMAC4 soap_get___tds__GetWsdlUrl(struct soap *soap, struct __tds__GetWsdlUrl *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetWsdlUrl(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetUser(struct soap *soap, struct __tds__SetUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetUser = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetUser(struct soap *soap, const struct __tds__SetUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetUser(soap, &a->tds__SetUser);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetUser(struct soap *soap, const char *tag, int id, const struct __tds__SetUser *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetUser(soap, "tds:SetUser", -1, &a->tds__SetUser, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetUser * SOAP_FMAC4 soap_in___tds__SetUser(struct soap *soap, const char *tag, struct __tds__SetUser *a, const char *type)
{
	size_t soap_flag_tds__SetUser = 1;
	short soap_flag;
	a = (struct __tds__SetUser *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetUser, sizeof(struct __tds__SetUser), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetUser(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetUser && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetUser(soap, "tds:SetUser", &a->tds__SetUser, ""))
				{	soap_flag_tds__SetUser--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetUser(struct soap *soap, const struct __tds__SetUser *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetUser(soap, tag?tag:"-tds:SetUser", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetUser * SOAP_FMAC4 soap_get___tds__SetUser(struct soap *soap, struct __tds__SetUser *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetUser(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__DeleteUsers(struct soap *soap, struct __tds__DeleteUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__DeleteUsers = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__DeleteUsers(struct soap *soap, const struct __tds__DeleteUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__DeleteUsers(soap, &a->tds__DeleteUsers);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__DeleteUsers(struct soap *soap, const char *tag, int id, const struct __tds__DeleteUsers *a, const char *type)
{
	if (soap_out_PointerTo_tds__DeleteUsers(soap, "tds:DeleteUsers", -1, &a->tds__DeleteUsers, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__DeleteUsers * SOAP_FMAC4 soap_in___tds__DeleteUsers(struct soap *soap, const char *tag, struct __tds__DeleteUsers *a, const char *type)
{
	size_t soap_flag_tds__DeleteUsers = 1;
	short soap_flag;
	a = (struct __tds__DeleteUsers *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__DeleteUsers, sizeof(struct __tds__DeleteUsers), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__DeleteUsers(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__DeleteUsers && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__DeleteUsers(soap, "tds:DeleteUsers", &a->tds__DeleteUsers, ""))
				{	soap_flag_tds__DeleteUsers--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__DeleteUsers(struct soap *soap, const struct __tds__DeleteUsers *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__DeleteUsers(soap, tag?tag:"-tds:DeleteUsers", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__DeleteUsers * SOAP_FMAC4 soap_get___tds__DeleteUsers(struct soap *soap, struct __tds__DeleteUsers *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__DeleteUsers(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__CreateUsers(struct soap *soap, struct __tds__CreateUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__CreateUsers = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__CreateUsers(struct soap *soap, const struct __tds__CreateUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__CreateUsers(soap, &a->tds__CreateUsers);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__CreateUsers(struct soap *soap, const char *tag, int id, const struct __tds__CreateUsers *a, const char *type)
{
	if (soap_out_PointerTo_tds__CreateUsers(soap, "tds:CreateUsers", -1, &a->tds__CreateUsers, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__CreateUsers * SOAP_FMAC4 soap_in___tds__CreateUsers(struct soap *soap, const char *tag, struct __tds__CreateUsers *a, const char *type)
{
	size_t soap_flag_tds__CreateUsers = 1;
	short soap_flag;
	a = (struct __tds__CreateUsers *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__CreateUsers, sizeof(struct __tds__CreateUsers), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__CreateUsers(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__CreateUsers && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__CreateUsers(soap, "tds:CreateUsers", &a->tds__CreateUsers, ""))
				{	soap_flag_tds__CreateUsers--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__CreateUsers(struct soap *soap, const struct __tds__CreateUsers *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__CreateUsers(soap, tag?tag:"-tds:CreateUsers", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__CreateUsers * SOAP_FMAC4 soap_get___tds__CreateUsers(struct soap *soap, struct __tds__CreateUsers *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__CreateUsers(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetUsers(struct soap *soap, struct __tds__GetUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetUsers = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetUsers(struct soap *soap, const struct __tds__GetUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetUsers(soap, &a->tds__GetUsers);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetUsers(struct soap *soap, const char *tag, int id, const struct __tds__GetUsers *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetUsers(soap, "tds:GetUsers", -1, &a->tds__GetUsers, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetUsers * SOAP_FMAC4 soap_in___tds__GetUsers(struct soap *soap, const char *tag, struct __tds__GetUsers *a, const char *type)
{
	size_t soap_flag_tds__GetUsers = 1;
	short soap_flag;
	a = (struct __tds__GetUsers *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetUsers, sizeof(struct __tds__GetUsers), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetUsers(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetUsers && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetUsers(soap, "tds:GetUsers", &a->tds__GetUsers, ""))
				{	soap_flag_tds__GetUsers--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetUsers(struct soap *soap, const struct __tds__GetUsers *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetUsers(soap, tag?tag:"-tds:GetUsers", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetUsers * SOAP_FMAC4 soap_get___tds__GetUsers(struct soap *soap, struct __tds__GetUsers *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetUsers(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetDiscoveryMode(struct soap *soap, struct __tds__SetDiscoveryMode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetDiscoveryMode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetDiscoveryMode(struct soap *soap, const struct __tds__SetDiscoveryMode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetDiscoveryMode(soap, &a->tds__SetDiscoveryMode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetDiscoveryMode(struct soap *soap, const char *tag, int id, const struct __tds__SetDiscoveryMode *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetDiscoveryMode(soap, "tds:SetDiscoveryMode", -1, &a->tds__SetDiscoveryMode, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDiscoveryMode * SOAP_FMAC4 soap_in___tds__SetDiscoveryMode(struct soap *soap, const char *tag, struct __tds__SetDiscoveryMode *a, const char *type)
{
	size_t soap_flag_tds__SetDiscoveryMode = 1;
	short soap_flag;
	a = (struct __tds__SetDiscoveryMode *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetDiscoveryMode, sizeof(struct __tds__SetDiscoveryMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetDiscoveryMode(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetDiscoveryMode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetDiscoveryMode(soap, "tds:SetDiscoveryMode", &a->tds__SetDiscoveryMode, ""))
				{	soap_flag_tds__SetDiscoveryMode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetDiscoveryMode(struct soap *soap, const struct __tds__SetDiscoveryMode *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetDiscoveryMode(soap, tag?tag:"-tds:SetDiscoveryMode", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDiscoveryMode * SOAP_FMAC4 soap_get___tds__SetDiscoveryMode(struct soap *soap, struct __tds__SetDiscoveryMode *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetDiscoveryMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetDiscoveryMode(struct soap *soap, struct __tds__GetDiscoveryMode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetDiscoveryMode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetDiscoveryMode(struct soap *soap, const struct __tds__GetDiscoveryMode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetDiscoveryMode(soap, &a->tds__GetDiscoveryMode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetDiscoveryMode(struct soap *soap, const char *tag, int id, const struct __tds__GetDiscoveryMode *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetDiscoveryMode(soap, "tds:GetDiscoveryMode", -1, &a->tds__GetDiscoveryMode, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDiscoveryMode * SOAP_FMAC4 soap_in___tds__GetDiscoveryMode(struct soap *soap, const char *tag, struct __tds__GetDiscoveryMode *a, const char *type)
{
	size_t soap_flag_tds__GetDiscoveryMode = 1;
	short soap_flag;
	a = (struct __tds__GetDiscoveryMode *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetDiscoveryMode, sizeof(struct __tds__GetDiscoveryMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetDiscoveryMode(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetDiscoveryMode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetDiscoveryMode(soap, "tds:GetDiscoveryMode", &a->tds__GetDiscoveryMode, ""))
				{	soap_flag_tds__GetDiscoveryMode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetDiscoveryMode(struct soap *soap, const struct __tds__GetDiscoveryMode *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetDiscoveryMode(soap, tag?tag:"-tds:GetDiscoveryMode", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDiscoveryMode * SOAP_FMAC4 soap_get___tds__GetDiscoveryMode(struct soap *soap, struct __tds__GetDiscoveryMode *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetDiscoveryMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__RemoveScopes(struct soap *soap, struct __tds__RemoveScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__RemoveScopes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__RemoveScopes(struct soap *soap, const struct __tds__RemoveScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__RemoveScopes(soap, &a->tds__RemoveScopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__RemoveScopes(struct soap *soap, const char *tag, int id, const struct __tds__RemoveScopes *a, const char *type)
{
	if (soap_out_PointerTo_tds__RemoveScopes(soap, "tds:RemoveScopes", -1, &a->tds__RemoveScopes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__RemoveScopes * SOAP_FMAC4 soap_in___tds__RemoveScopes(struct soap *soap, const char *tag, struct __tds__RemoveScopes *a, const char *type)
{
	size_t soap_flag_tds__RemoveScopes = 1;
	short soap_flag;
	a = (struct __tds__RemoveScopes *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__RemoveScopes, sizeof(struct __tds__RemoveScopes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__RemoveScopes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__RemoveScopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__RemoveScopes(soap, "tds:RemoveScopes", &a->tds__RemoveScopes, ""))
				{	soap_flag_tds__RemoveScopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__RemoveScopes(struct soap *soap, const struct __tds__RemoveScopes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__RemoveScopes(soap, tag?tag:"-tds:RemoveScopes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__RemoveScopes * SOAP_FMAC4 soap_get___tds__RemoveScopes(struct soap *soap, struct __tds__RemoveScopes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__RemoveScopes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__AddScopes(struct soap *soap, struct __tds__AddScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__AddScopes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__AddScopes(struct soap *soap, const struct __tds__AddScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__AddScopes(soap, &a->tds__AddScopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__AddScopes(struct soap *soap, const char *tag, int id, const struct __tds__AddScopes *a, const char *type)
{
	if (soap_out_PointerTo_tds__AddScopes(soap, "tds:AddScopes", -1, &a->tds__AddScopes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__AddScopes * SOAP_FMAC4 soap_in___tds__AddScopes(struct soap *soap, const char *tag, struct __tds__AddScopes *a, const char *type)
{
	size_t soap_flag_tds__AddScopes = 1;
	short soap_flag;
	a = (struct __tds__AddScopes *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__AddScopes, sizeof(struct __tds__AddScopes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__AddScopes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__AddScopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__AddScopes(soap, "tds:AddScopes", &a->tds__AddScopes, ""))
				{	soap_flag_tds__AddScopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__AddScopes(struct soap *soap, const struct __tds__AddScopes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__AddScopes(soap, tag?tag:"-tds:AddScopes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__AddScopes * SOAP_FMAC4 soap_get___tds__AddScopes(struct soap *soap, struct __tds__AddScopes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__AddScopes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetScopes(struct soap *soap, struct __tds__SetScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetScopes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetScopes(struct soap *soap, const struct __tds__SetScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetScopes(soap, &a->tds__SetScopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetScopes(struct soap *soap, const char *tag, int id, const struct __tds__SetScopes *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetScopes(soap, "tds:SetScopes", -1, &a->tds__SetScopes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetScopes * SOAP_FMAC4 soap_in___tds__SetScopes(struct soap *soap, const char *tag, struct __tds__SetScopes *a, const char *type)
{
	size_t soap_flag_tds__SetScopes = 1;
	short soap_flag;
	a = (struct __tds__SetScopes *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetScopes, sizeof(struct __tds__SetScopes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetScopes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetScopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetScopes(soap, "tds:SetScopes", &a->tds__SetScopes, ""))
				{	soap_flag_tds__SetScopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetScopes(struct soap *soap, const struct __tds__SetScopes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetScopes(soap, tag?tag:"-tds:SetScopes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetScopes * SOAP_FMAC4 soap_get___tds__SetScopes(struct soap *soap, struct __tds__SetScopes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetScopes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetScopes(struct soap *soap, struct __tds__GetScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetScopes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetScopes(struct soap *soap, const struct __tds__GetScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetScopes(soap, &a->tds__GetScopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetScopes(struct soap *soap, const char *tag, int id, const struct __tds__GetScopes *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetScopes(soap, "tds:GetScopes", -1, &a->tds__GetScopes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetScopes * SOAP_FMAC4 soap_in___tds__GetScopes(struct soap *soap, const char *tag, struct __tds__GetScopes *a, const char *type)
{
	size_t soap_flag_tds__GetScopes = 1;
	short soap_flag;
	a = (struct __tds__GetScopes *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetScopes, sizeof(struct __tds__GetScopes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetScopes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetScopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetScopes(soap, "tds:GetScopes", &a->tds__GetScopes, ""))
				{	soap_flag_tds__GetScopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetScopes(struct soap *soap, const struct __tds__GetScopes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetScopes(soap, tag?tag:"-tds:GetScopes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetScopes * SOAP_FMAC4 soap_get___tds__GetScopes(struct soap *soap, struct __tds__GetScopes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetScopes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SystemReboot(struct soap *soap, struct __tds__SystemReboot *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SystemReboot = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SystemReboot(struct soap *soap, const struct __tds__SystemReboot *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SystemReboot(soap, &a->tds__SystemReboot);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SystemReboot(struct soap *soap, const char *tag, int id, const struct __tds__SystemReboot *a, const char *type)
{
	if (soap_out_PointerTo_tds__SystemReboot(soap, "tds:SystemReboot", -1, &a->tds__SystemReboot, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SystemReboot * SOAP_FMAC4 soap_in___tds__SystemReboot(struct soap *soap, const char *tag, struct __tds__SystemReboot *a, const char *type)
{
	size_t soap_flag_tds__SystemReboot = 1;
	short soap_flag;
	a = (struct __tds__SystemReboot *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SystemReboot, sizeof(struct __tds__SystemReboot), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SystemReboot(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SystemReboot && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SystemReboot(soap, "tds:SystemReboot", &a->tds__SystemReboot, ""))
				{	soap_flag_tds__SystemReboot--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SystemReboot(struct soap *soap, const struct __tds__SystemReboot *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SystemReboot(soap, tag?tag:"-tds:SystemReboot", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SystemReboot * SOAP_FMAC4 soap_get___tds__SystemReboot(struct soap *soap, struct __tds__SystemReboot *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SystemReboot(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetSystemFactoryDefault(struct soap *soap, struct __tds__SetSystemFactoryDefault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetSystemFactoryDefault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetSystemFactoryDefault(struct soap *soap, const struct __tds__SetSystemFactoryDefault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetSystemFactoryDefault(soap, &a->tds__SetSystemFactoryDefault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetSystemFactoryDefault(struct soap *soap, const char *tag, int id, const struct __tds__SetSystemFactoryDefault *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetSystemFactoryDefault(soap, "tds:SetSystemFactoryDefault", -1, &a->tds__SetSystemFactoryDefault, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetSystemFactoryDefault * SOAP_FMAC4 soap_in___tds__SetSystemFactoryDefault(struct soap *soap, const char *tag, struct __tds__SetSystemFactoryDefault *a, const char *type)
{
	size_t soap_flag_tds__SetSystemFactoryDefault = 1;
	short soap_flag;
	a = (struct __tds__SetSystemFactoryDefault *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetSystemFactoryDefault, sizeof(struct __tds__SetSystemFactoryDefault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetSystemFactoryDefault(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetSystemFactoryDefault && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetSystemFactoryDefault(soap, "tds:SetSystemFactoryDefault", &a->tds__SetSystemFactoryDefault, ""))
				{	soap_flag_tds__SetSystemFactoryDefault--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetSystemFactoryDefault(struct soap *soap, const struct __tds__SetSystemFactoryDefault *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetSystemFactoryDefault(soap, tag?tag:"-tds:SetSystemFactoryDefault", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetSystemFactoryDefault * SOAP_FMAC4 soap_get___tds__SetSystemFactoryDefault(struct soap *soap, struct __tds__SetSystemFactoryDefault *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetSystemFactoryDefault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetSystemDateAndTime(struct soap *soap, struct __tds__GetSystemDateAndTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetSystemDateAndTime = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetSystemDateAndTime(struct soap *soap, const struct __tds__GetSystemDateAndTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetSystemDateAndTime(soap, &a->tds__GetSystemDateAndTime);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetSystemDateAndTime(struct soap *soap, const char *tag, int id, const struct __tds__GetSystemDateAndTime *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetSystemDateAndTime(soap, "tds:GetSystemDateAndTime", -1, &a->tds__GetSystemDateAndTime, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetSystemDateAndTime * SOAP_FMAC4 soap_in___tds__GetSystemDateAndTime(struct soap *soap, const char *tag, struct __tds__GetSystemDateAndTime *a, const char *type)
{
	size_t soap_flag_tds__GetSystemDateAndTime = 1;
	short soap_flag;
	a = (struct __tds__GetSystemDateAndTime *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetSystemDateAndTime, sizeof(struct __tds__GetSystemDateAndTime), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetSystemDateAndTime(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetSystemDateAndTime && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetSystemDateAndTime(soap, "tds:GetSystemDateAndTime", &a->tds__GetSystemDateAndTime, ""))
				{	soap_flag_tds__GetSystemDateAndTime--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetSystemDateAndTime(struct soap *soap, const struct __tds__GetSystemDateAndTime *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetSystemDateAndTime(soap, tag?tag:"-tds:GetSystemDateAndTime", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetSystemDateAndTime * SOAP_FMAC4 soap_get___tds__GetSystemDateAndTime(struct soap *soap, struct __tds__GetSystemDateAndTime *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetSystemDateAndTime(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetSystemDateAndTime(struct soap *soap, struct __tds__SetSystemDateAndTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetSystemDateAndTime = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetSystemDateAndTime(struct soap *soap, const struct __tds__SetSystemDateAndTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetSystemDateAndTime(soap, &a->tds__SetSystemDateAndTime);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetSystemDateAndTime(struct soap *soap, const char *tag, int id, const struct __tds__SetSystemDateAndTime *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetSystemDateAndTime(soap, "tds:SetSystemDateAndTime", -1, &a->tds__SetSystemDateAndTime, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetSystemDateAndTime * SOAP_FMAC4 soap_in___tds__SetSystemDateAndTime(struct soap *soap, const char *tag, struct __tds__SetSystemDateAndTime *a, const char *type)
{
	size_t soap_flag_tds__SetSystemDateAndTime = 1;
	short soap_flag;
	a = (struct __tds__SetSystemDateAndTime *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetSystemDateAndTime, sizeof(struct __tds__SetSystemDateAndTime), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetSystemDateAndTime(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetSystemDateAndTime && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetSystemDateAndTime(soap, "tds:SetSystemDateAndTime", &a->tds__SetSystemDateAndTime, ""))
				{	soap_flag_tds__SetSystemDateAndTime--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetSystemDateAndTime(struct soap *soap, const struct __tds__SetSystemDateAndTime *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetSystemDateAndTime(soap, tag?tag:"-tds:SetSystemDateAndTime", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetSystemDateAndTime * SOAP_FMAC4 soap_get___tds__SetSystemDateAndTime(struct soap *soap, struct __tds__SetSystemDateAndTime *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetSystemDateAndTime(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetDeviceInformation(struct soap *soap, struct __tds__GetDeviceInformation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetDeviceInformation = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetDeviceInformation(struct soap *soap, const struct __tds__GetDeviceInformation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetDeviceInformation(soap, &a->tds__GetDeviceInformation);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetDeviceInformation(struct soap *soap, const char *tag, int id, const struct __tds__GetDeviceInformation *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetDeviceInformation(soap, "tds:GetDeviceInformation", -1, &a->tds__GetDeviceInformation, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDeviceInformation * SOAP_FMAC4 soap_in___tds__GetDeviceInformation(struct soap *soap, const char *tag, struct __tds__GetDeviceInformation *a, const char *type)
{
	size_t soap_flag_tds__GetDeviceInformation = 1;
	short soap_flag;
	a = (struct __tds__GetDeviceInformation *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetDeviceInformation, sizeof(struct __tds__GetDeviceInformation), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetDeviceInformation(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetDeviceInformation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetDeviceInformation(soap, "tds:GetDeviceInformation", &a->tds__GetDeviceInformation, ""))
				{	soap_flag_tds__GetDeviceInformation--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetDeviceInformation(struct soap *soap, const struct __tds__GetDeviceInformation *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetDeviceInformation(soap, tag?tag:"-tds:GetDeviceInformation", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDeviceInformation * SOAP_FMAC4 soap_get___tds__GetDeviceInformation(struct soap *soap, struct __tds__GetDeviceInformation *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetDeviceInformation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Probe(struct soap *soap, struct __d__Probe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Probe = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Probe(struct soap *soap, const struct __d__Probe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__ProbeType(soap, &a->d__Probe);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Probe(struct soap *soap, const char *tag, int id, const struct __d__Probe *a, const char *type)
{
	if (soap_out_PointerTod__ProbeType(soap, "d:Probe", -1, &a->d__Probe, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Probe * SOAP_FMAC4 soap_in___d__Probe(struct soap *soap, const char *tag, struct __d__Probe *a, const char *type)
{
	size_t soap_flag_d__Probe = 1;
	short soap_flag;
	a = (struct __d__Probe *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Probe, sizeof(struct __d__Probe), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Probe(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Probe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ProbeType(soap, "d:Probe", &a->d__Probe, "d:ProbeType"))
				{	soap_flag_d__Probe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Probe(struct soap *soap, const struct __d__Probe *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Probe(soap, tag?tag:"-d:Probe", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Probe * SOAP_FMAC4 soap_get___d__Probe(struct soap *soap, struct __d__Probe *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Probe(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Bye(struct soap *soap, struct __d__Bye *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Bye = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Bye(struct soap *soap, const struct __d__Bye *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__ByeType(soap, &a->d__Bye);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Bye(struct soap *soap, const char *tag, int id, const struct __d__Bye *a, const char *type)
{
	if (soap_out_PointerTod__ByeType(soap, "d:Bye", -1, &a->d__Bye, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Bye * SOAP_FMAC4 soap_in___d__Bye(struct soap *soap, const char *tag, struct __d__Bye *a, const char *type)
{
	size_t soap_flag_d__Bye = 1;
	short soap_flag;
	a = (struct __d__Bye *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Bye, sizeof(struct __d__Bye), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Bye(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Bye && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ByeType(soap, "d:Bye", &a->d__Bye, "d:ByeType"))
				{	soap_flag_d__Bye--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Bye(struct soap *soap, const struct __d__Bye *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Bye(soap, tag?tag:"-d:Bye", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Bye * SOAP_FMAC4 soap_get___d__Bye(struct soap *soap, struct __d__Bye *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Bye(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Hello(struct soap *soap, struct __d__Hello *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Hello = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Hello(struct soap *soap, const struct __d__Hello *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__HelloType(soap, &a->d__Hello);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Hello(struct soap *soap, const char *tag, int id, const struct __d__Hello *a, const char *type)
{
	if (soap_out_PointerTod__HelloType(soap, "d:Hello", -1, &a->d__Hello, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Hello * SOAP_FMAC4 soap_in___d__Hello(struct soap *soap, const char *tag, struct __d__Hello *a, const char *type)
{
	size_t soap_flag_d__Hello = 1;
	short soap_flag;
	a = (struct __d__Hello *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Hello, sizeof(struct __d__Hello), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Hello(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Hello && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__HelloType(soap, "d:Hello", &a->d__Hello, "d:HelloType"))
				{	soap_flag_d__Hello--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Hello(struct soap *soap, const struct __d__Hello *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Hello(soap, tag?tag:"-d:Hello", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Hello * SOAP_FMAC4 soap_get___d__Hello(struct soap *soap, struct __d__Hello *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Hello(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsu__TimestampType(struct soap *soap, struct wsu__TimestampType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Id);
	soap_default_string(soap, &a->Created);
	soap_default_string(soap, &a->Expires);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsu__TimestampType(struct soap *soap, const struct wsu__TimestampType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Id);
	soap_serialize_string(soap, &a->Created);
	soap_serialize_string(soap, &a->Expires);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsu__TimestampType(struct soap *soap, const char *tag, int id, const struct wsu__TimestampType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsu__TimestampType), type))
		return soap->error;
	if (soap_out_string(soap, "wsu:Id", -1, &a->Id, ""))
		return soap->error;
	if (soap_out_string(soap, "wsu:Created", -1, &a->Created, ""))
		return soap->error;
	if (soap_out_string(soap, "wsu:Expires", -1, &a->Expires, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsu__TimestampType * SOAP_FMAC4 soap_in_wsu__TimestampType(struct soap *soap, const char *tag, struct wsu__TimestampType *a, const char *type)
{
	size_t soap_flag_Id = 1;
	size_t soap_flag_Created = 1;
	size_t soap_flag_Expires = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsu__TimestampType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsu__TimestampType, sizeof(struct wsu__TimestampType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsu__TimestampType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Id", &a->Id, "xsd:string"))
				{	soap_flag_Id--;
					continue;
				}
			if (soap_flag_Created && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Created", &a->Created, "xsd:string"))
				{	soap_flag_Created--;
					continue;
				}
			if (soap_flag_Expires && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Expires", &a->Expires, "xsd:string"))
				{	soap_flag_Expires--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsu__TimestampType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsu__TimestampType, 0, sizeof(struct wsu__TimestampType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Id > 0 || soap_flag_Created > 0 || soap_flag_Expires > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsu__TimestampType(struct soap *soap, const struct wsu__TimestampType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsu__TimestampType);
	if (soap_out_wsu__TimestampType(soap, tag?tag:"wsu:TimestampType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsu__TimestampType * SOAP_FMAC4 soap_get_wsu__TimestampType(struct soap *soap, struct wsu__TimestampType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsu__TimestampType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsse__SecurityHeaderType(struct soap *soap, struct wsse__SecurityHeaderType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsu__Timestamp = NULL;
	a->UsernameToken = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsse__SecurityHeaderType(struct soap *soap, const struct wsse__SecurityHeaderType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsu__TimestampType(soap, &a->wsu__Timestamp);
	soap_serialize_PointerTowsse__UsernameTokenType(soap, &a->UsernameToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsse__SecurityHeaderType(struct soap *soap, const char *tag, int id, const struct wsse__SecurityHeaderType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsse__SecurityHeaderType), type))
		return soap->error;
	if (soap_out_PointerTowsu__TimestampType(soap, "wsu:Timestamp", -1, &a->wsu__Timestamp, ""))
		return soap->error;
	if (soap_out_PointerTowsse__UsernameTokenType(soap, "wsse:UsernameToken", -1, &a->UsernameToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsse__SecurityHeaderType * SOAP_FMAC4 soap_in_wsse__SecurityHeaderType(struct soap *soap, const char *tag, struct wsse__SecurityHeaderType *a, const char *type)
{
	size_t soap_flag_wsu__Timestamp = 1;
	size_t soap_flag_UsernameToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsse__SecurityHeaderType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsse__SecurityHeaderType, sizeof(struct wsse__SecurityHeaderType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsse__SecurityHeaderType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsu__Timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsu__TimestampType(soap, "wsu:Timestamp", &a->wsu__Timestamp, "wsu:TimestampType"))
				{	soap_flag_wsu__Timestamp--;
					continue;
				}
			if (soap_flag_UsernameToken && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsse__UsernameTokenType(soap, "wsse:UsernameToken", &a->UsernameToken, "wsse:UsernameTokenType"))
				{	soap_flag_UsernameToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsse__SecurityHeaderType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsse__SecurityHeaderType, 0, sizeof(struct wsse__SecurityHeaderType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsse__SecurityHeaderType(struct soap *soap, const struct wsse__SecurityHeaderType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsse__SecurityHeaderType);
	if (soap_out_wsse__SecurityHeaderType(soap, tag?tag:"wsse:SecurityHeaderType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsse__SecurityHeaderType * SOAP_FMAC4 soap_get_wsse__SecurityHeaderType(struct soap *soap, struct wsse__SecurityHeaderType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsse__SecurityHeaderType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsse__UsernameTokenType(struct soap *soap, struct wsse__UsernameTokenType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Username);
	a->Password = NULL;
	soap_default_string(soap, &a->Nonce);
	soap_default_string(soap, &a->wsu__Created);
	soap_default_string(soap, &a->wsu__Id);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsse__UsernameTokenType(struct soap *soap, const struct wsse__UsernameTokenType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Username);
	soap_serialize_PointerTowsse__PasswordString(soap, &a->Password);
	soap_serialize_string(soap, &a->Nonce);
	soap_serialize_string(soap, &a->wsu__Created);
	soap_serialize_string(soap, &a->wsu__Id);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsse__UsernameTokenType(struct soap *soap, const char *tag, int id, const struct wsse__UsernameTokenType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsse__UsernameTokenType), type))
		return soap->error;
	if (soap_out_string(soap, "wsse:Username", -1, &a->Username, ""))
		return soap->error;
	if (soap_out_PointerTowsse__PasswordString(soap, "wsse:Password", -1, &a->Password, ""))
		return soap->error;
	if (soap_out_string(soap, "wsse:Nonce", -1, &a->Nonce, ""))
		return soap->error;
	if (soap_out_string(soap, "wsu:Created", -1, &a->wsu__Created, ""))
		return soap->error;
	if (soap_out_string(soap, "wsu:Id", -1, &a->wsu__Id, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsse__UsernameTokenType * SOAP_FMAC4 soap_in_wsse__UsernameTokenType(struct soap *soap, const char *tag, struct wsse__UsernameTokenType *a, const char *type)
{
	size_t soap_flag_Username = 1;
	size_t soap_flag_Password = 1;
	size_t soap_flag_Nonce = 1;
	size_t soap_flag_wsu__Created = 1;
	size_t soap_flag_wsu__Id = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsse__UsernameTokenType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsse__UsernameTokenType, sizeof(struct wsse__UsernameTokenType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsse__UsernameTokenType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsse:Username", &a->Username, "xsd:string"))
				{	soap_flag_Username--;
					continue;
				}
			if (soap_flag_Password && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsse__PasswordString(soap, "wsse:Password", &a->Password, "wsse:PasswordString"))
				{	soap_flag_Password--;
					continue;
				}
			if (soap_flag_Nonce && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsse:Nonce", &a->Nonce, "xsd:string"))
				{	soap_flag_Nonce--;
					continue;
				}
			if (soap_flag_wsu__Created && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Created", &a->wsu__Created, "xsd:string"))
				{	soap_flag_wsu__Created--;
					continue;
				}
			if (soap_flag_wsu__Id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Id", &a->wsu__Id, "xsd:string"))
				{	soap_flag_wsu__Id--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsse__UsernameTokenType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsse__UsernameTokenType, 0, sizeof(struct wsse__UsernameTokenType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Username > 0 || soap_flag_Password > 0 || soap_flag_Nonce > 0 || soap_flag_wsu__Id > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsse__UsernameTokenType(struct soap *soap, const struct wsse__UsernameTokenType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsse__UsernameTokenType);
	if (soap_out_wsse__UsernameTokenType(soap, tag?tag:"wsse:UsernameTokenType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsse__UsernameTokenType * SOAP_FMAC4 soap_get_wsse__UsernameTokenType(struct soap *soap, struct wsse__UsernameTokenType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsse__UsernameTokenType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsse__PasswordString(struct soap *soap, struct wsse__PasswordString *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default_string(soap, &a->Type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsse__PasswordString(struct soap *soap, const struct wsse__PasswordString *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsse__PasswordString(struct soap *soap, const char *tag, int id, const struct wsse__PasswordString *a, const char *type)
{
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type);
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsse__PasswordString * SOAP_FMAC4 soap_in_wsse__PasswordString(struct soap *soap, const char *tag, struct wsse__PasswordString *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsse__PasswordString *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsse__PasswordString, sizeof(struct wsse__PasswordString), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsse__PasswordString(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 0), &a->Type, -1, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, "wsse:PasswordString"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsse__PasswordString(struct soap *soap, const struct wsse__PasswordString *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsse__PasswordString);
	if (soap_out_wsse__PasswordString(soap, tag?tag:"wsse:PasswordString", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsse__PasswordString * SOAP_FMAC4 soap_get_wsse__PasswordString(struct soap *soap, struct wsse__PasswordString *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsse__PasswordString(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__AppSequenceType(struct soap *soap, struct d__AppSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_unsignedInt(soap, &a->InstanceId);
	soap_default_xsd__anyURI(soap, &a->SequenceId);
	soap_default_unsignedInt(soap, &a->MessageNumber);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__AppSequenceType(struct soap *soap, const struct d__AppSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__AppSequenceType(struct soap *soap, const char *tag, int id, const struct d__AppSequenceType *a, const char *type)
{
	soap_set_attr(soap, "InstanceId", soap_unsignedInt2s(soap, a->InstanceId));
	if (a->SequenceId)
		soap_set_attr(soap, "SequenceId", a->SequenceId);
	soap_set_attr(soap, "MessageNumber", soap_unsignedInt2s(soap, a->MessageNumber));
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__AppSequenceType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__AppSequenceType * SOAP_FMAC4 soap_in_d__AppSequenceType(struct soap *soap, const char *tag, struct d__AppSequenceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__AppSequenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__AppSequenceType, sizeof(struct d__AppSequenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__AppSequenceType(soap, a);
	if (soap_s2unsignedInt(soap, soap_attr_value(soap, "InstanceId", 1), &a->InstanceId))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "SequenceId", 0), &a->SequenceId, -1, -1))
		return NULL;
	if (soap_s2unsignedInt(soap, soap_attr_value(soap, "MessageNumber", 1), &a->MessageNumber))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__AppSequenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__AppSequenceType, 0, sizeof(struct d__AppSequenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__AppSequenceType(struct soap *soap, const struct d__AppSequenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__AppSequenceType);
	if (soap_out_d__AppSequenceType(soap, tag?tag:"d:AppSequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__AppSequenceType * SOAP_FMAC4 soap_get_d__AppSequenceType(struct soap *soap, struct d__AppSequenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__AppSequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ScopesType(struct soap *soap, struct d__ScopesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_d__UriListType(soap, &a->__item);
	soap_default_xsd__anyURI(soap, &a->MatchBy);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ScopesType(struct soap *soap, const struct d__ScopesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_d__UriListType(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ScopesType(struct soap *soap, const char *tag, int id, const struct d__ScopesType *a, const char *type)
{
	if (a->MatchBy)
		soap_set_attr(soap, "MatchBy", a->MatchBy);
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_d__UriListType(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct d__ScopesType * SOAP_FMAC4 soap_in_d__ScopesType(struct soap *soap, const char *tag, struct d__ScopesType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct d__ScopesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ScopesType, sizeof(struct d__ScopesType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_d__ScopesType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "MatchBy", 0), &a->MatchBy, -1, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_d__UriListType(soap, tag, &a->__item, "d:ScopesType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ScopesType(struct soap *soap, const struct d__ScopesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ScopesType);
	if (soap_out_d__ScopesType(soap, tag?tag:"d:ScopesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ScopesType * SOAP_FMAC4 soap_get_d__ScopesType(struct soap *soap, struct d__ScopesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ScopesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ResolveType(struct soap *soap, struct d__ResolveType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsadis__EndpointReference = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ResolveType(struct soap *soap, const struct d__ResolveType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsadis__EndpointReferenceType(soap, &a->wsadis__EndpointReference);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ResolveType(struct soap *soap, const char *tag, int id, const struct d__ResolveType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ResolveType), type))
		return soap->error;
	if (a->wsadis__EndpointReference)
		soap_element_result(soap, "wsadis:EndpointReference");
	if (soap_out_PointerTowsadis__EndpointReferenceType(soap, "wsadis:EndpointReference", -1, &a->wsadis__EndpointReference, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ResolveType * SOAP_FMAC4 soap_in_d__ResolveType(struct soap *soap, const char *tag, struct d__ResolveType *a, const char *type)
{
	size_t soap_flag_wsadis__EndpointReference = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ResolveType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ResolveType, sizeof(struct d__ResolveType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ResolveType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsadis__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsadis__EndpointReferenceType(soap, "wsadis:EndpointReference", &a->wsadis__EndpointReference, "wsadis:EndpointReferenceType"))
				{	soap_flag_wsadis__EndpointReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			soap_check_result(soap, "wsadis:EndpointReference");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ResolveType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ResolveType, 0, sizeof(struct d__ResolveType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsadis__EndpointReference > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ResolveType(struct soap *soap, const struct d__ResolveType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ResolveType);
	if (soap_out_d__ResolveType(soap, tag?tag:"d:ResolveType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ResolveType * SOAP_FMAC4 soap_get_d__ResolveType(struct soap *soap, struct d__ResolveType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ResolveType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ProbeMatchType(struct soap *soap, struct d__ProbeMatchType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	soap_default_d__UriListType(soap, &a->XAddrs);
	soap_default_unsignedInt(soap, &a->MetadataVersion);
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ProbeMatchType(struct soap *soap, const struct d__ProbeMatchType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &a->wsa__EndpointReference);
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
	soap_serialize_d__UriListType(soap, &a->XAddrs);
	soap_embedded(soap, &a->MetadataVersion, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ProbeMatchType(struct soap *soap, const char *tag, int id, const struct d__ProbeMatchType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ProbeMatchType), type))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, ""))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (soap_out_d__UriListType(soap, "d:XAddrs", -1, &a->XAddrs, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "d:MetadataVersion", -1, &a->MetadataVersion, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ProbeMatchType * SOAP_FMAC4 soap_in_d__ProbeMatchType(struct soap *soap, const char *tag, struct d__ProbeMatchType *a, const char *type)
{
	size_t soap_flag_wsa__EndpointReference = 1;
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	size_t soap_flag_XAddrs = 1;
	size_t soap_flag_MetadataVersion = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ProbeMatchType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ProbeMatchType, sizeof(struct d__ProbeMatchType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ProbeMatchType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__UriListType(soap, "d:XAddrs", &a->XAddrs, "d:UriListType"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "d:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ProbeMatchType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ProbeMatchType, 0, sizeof(struct d__ProbeMatchType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0 || soap_flag_MetadataVersion > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ProbeMatchType(struct soap *soap, const struct d__ProbeMatchType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ProbeMatchType);
	if (soap_out_d__ProbeMatchType(soap, tag?tag:"d:ProbeMatchType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeMatchType * SOAP_FMAC4 soap_get_d__ProbeMatchType(struct soap *soap, struct d__ProbeMatchType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ProbeMatchType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ProbeMatchesType(struct soap *soap, struct d__ProbeMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeProbeMatch = 0;
	a->ProbeMatch = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ProbeMatchesType(struct soap *soap, const struct d__ProbeMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->ProbeMatch)
	{	int i;
		for (i = 0; i < a->__sizeProbeMatch; i++)
		{
			soap_embedded(soap, a->ProbeMatch + i, SOAP_TYPE_d__ProbeMatchType);
			soap_serialize_d__ProbeMatchType(soap, a->ProbeMatch + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ProbeMatchesType(struct soap *soap, const char *tag, int id, const struct d__ProbeMatchesType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ProbeMatchesType), type))
		return soap->error;
	soap_element_result(soap, "-sizeProbeMatch");
	if (a->ProbeMatch)
	{	int i;
		for (i = 0; i < a->__sizeProbeMatch; i++)
			if (soap_out_d__ProbeMatchType(soap, "d:ProbeMatch", -1, a->ProbeMatch + i, ""))
				return soap->error;
	}
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ProbeMatchesType * SOAP_FMAC4 soap_in_d__ProbeMatchesType(struct soap *soap, const char *tag, struct d__ProbeMatchesType *a, const char *type)
{
	struct soap_blist *soap_blist_ProbeMatch = NULL;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ProbeMatchesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ProbeMatchesType, sizeof(struct d__ProbeMatchesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ProbeMatchesType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "d:ProbeMatch", 1, NULL))
			{	if (a->ProbeMatch == NULL)
				{	if (soap_blist_ProbeMatch == NULL)
						soap_blist_ProbeMatch = soap_new_block(soap);
					a->ProbeMatch = (struct d__ProbeMatchType *)soap_push_block(soap, soap_blist_ProbeMatch, sizeof(struct d__ProbeMatchType));
					if (a->ProbeMatch == NULL)
						return NULL;
					soap_default_d__ProbeMatchType(soap, a->ProbeMatch);
				}soap_revert(soap);
				if (soap_in_d__ProbeMatchType(soap, "d:ProbeMatch", a->ProbeMatch, "d:ProbeMatchType"))
				{	a->__sizeProbeMatch++;
					a->ProbeMatch = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeProbeMatch");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->ProbeMatch)
			soap_pop_block(soap, soap_blist_ProbeMatch);
		if (a->__sizeProbeMatch)
			a->ProbeMatch = (struct d__ProbeMatchType *)soap_save_block(soap, soap_blist_ProbeMatch, NULL, 1);
		else
		{	a->ProbeMatch = NULL;
			if (soap_blist_ProbeMatch)
				soap_end_block(soap, soap_blist_ProbeMatch);
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ProbeMatchesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ProbeMatchesType, 0, sizeof(struct d__ProbeMatchesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ProbeMatchesType(struct soap *soap, const struct d__ProbeMatchesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ProbeMatchesType);
	if (soap_out_d__ProbeMatchesType(soap, tag?tag:"d:ProbeMatchesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeMatchesType * SOAP_FMAC4 soap_get_d__ProbeMatchesType(struct soap *soap, struct d__ProbeMatchesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ProbeMatchesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ProbeType(struct soap *soap, struct d__ProbeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ProbeType(struct soap *soap, const struct d__ProbeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ProbeType(struct soap *soap, const char *tag, int id, const struct d__ProbeType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ProbeType), type))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ProbeType * SOAP_FMAC4 soap_in_d__ProbeType(struct soap *soap, const char *tag, struct d__ProbeType *a, const char *type)
{
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ProbeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ProbeType, sizeof(struct d__ProbeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ProbeType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ProbeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ProbeType, 0, sizeof(struct d__ProbeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ProbeType(struct soap *soap, const struct d__ProbeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ProbeType);
	if (soap_out_d__ProbeType(soap, tag?tag:"d:ProbeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeType * SOAP_FMAC4 soap_get_d__ProbeType(struct soap *soap, struct d__ProbeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ProbeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ByeType(struct soap *soap, struct d__ByeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	soap_default_d__UriListType(soap, &a->XAddrs);
	a->MetadataVersion = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ByeType(struct soap *soap, const struct d__ByeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &a->wsa__EndpointReference);
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
	soap_serialize_d__UriListType(soap, &a->XAddrs);
	soap_serialize_PointerTounsignedInt(soap, &a->MetadataVersion);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ByeType(struct soap *soap, const char *tag, int id, const struct d__ByeType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ByeType), type))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, ""))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (soap_out_d__UriListType(soap, "d:XAddrs", -1, &a->XAddrs, ""))
		return soap->error;
	if (soap_out_PointerTounsignedInt(soap, "d:MetadataVersion", -1, &a->MetadataVersion, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ByeType * SOAP_FMAC4 soap_in_d__ByeType(struct soap *soap, const char *tag, struct d__ByeType *a, const char *type)
{
	size_t soap_flag_wsa__EndpointReference = 1;
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	size_t soap_flag_XAddrs = 1;
	size_t soap_flag_MetadataVersion = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ByeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ByeType, sizeof(struct d__ByeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ByeType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__UriListType(soap, "d:XAddrs", &a->XAddrs, "d:UriListType"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedInt(soap, "d:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ByeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ByeType, 0, sizeof(struct d__ByeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ByeType(struct soap *soap, const struct d__ByeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ByeType);
	if (soap_out_d__ByeType(soap, tag?tag:"d:ByeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ByeType * SOAP_FMAC4 soap_get_d__ByeType(struct soap *soap, struct d__ByeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ByeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__HelloType(struct soap *soap, struct d__HelloType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	soap_default_d__UriListType(soap, &a->XAddrs);
	soap_default_unsignedInt(soap, &a->MetadataVersion);
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__HelloType(struct soap *soap, const struct d__HelloType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &a->wsa__EndpointReference);
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
	soap_serialize_d__UriListType(soap, &a->XAddrs);
	soap_embedded(soap, &a->MetadataVersion, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__HelloType(struct soap *soap, const char *tag, int id, const struct d__HelloType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__HelloType), type))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, ""))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (soap_out_d__UriListType(soap, "d:XAddrs", -1, &a->XAddrs, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "d:MetadataVersion", -1, &a->MetadataVersion, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__HelloType * SOAP_FMAC4 soap_in_d__HelloType(struct soap *soap, const char *tag, struct d__HelloType *a, const char *type)
{
	size_t soap_flag_wsa__EndpointReference = 1;
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	size_t soap_flag_XAddrs = 1;
	size_t soap_flag_MetadataVersion = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__HelloType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__HelloType, sizeof(struct d__HelloType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__HelloType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__UriListType(soap, "d:XAddrs", &a->XAddrs, "d:UriListType"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "d:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__HelloType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__HelloType, 0, sizeof(struct d__HelloType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0 || soap_flag_MetadataVersion > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__HelloType(struct soap *soap, const struct d__HelloType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__HelloType);
	if (soap_out_d__HelloType(soap, tag?tag:"d:HelloType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__HelloType * SOAP_FMAC4 soap_get_d__HelloType(struct soap *soap, struct d__HelloType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__HelloType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetSnapshotUriResponse(struct soap *soap, struct _trt__GetSnapshotUriResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->MediaUri = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetSnapshotUriResponse(struct soap *soap, const struct _trt__GetSnapshotUriResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__MediaUri(soap, &a->MediaUri);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetSnapshotUriResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetSnapshotUriResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetSnapshotUriResponse), type))
		return soap->error;
	if (a->MediaUri)
		soap_element_result(soap, "trt:MediaUri");
	if (soap_out_PointerTott__MediaUri(soap, "trt:MediaUri", -1, &a->MediaUri, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetSnapshotUriResponse * SOAP_FMAC4 soap_in__trt__GetSnapshotUriResponse(struct soap *soap, const char *tag, struct _trt__GetSnapshotUriResponse *a, const char *type)
{
	size_t soap_flag_MediaUri = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetSnapshotUriResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetSnapshotUriResponse, sizeof(struct _trt__GetSnapshotUriResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetSnapshotUriResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_MediaUri && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__MediaUri(soap, "trt:MediaUri", &a->MediaUri, "tt:MediaUri"))
				{	soap_flag_MediaUri--;
					continue;
				}
			soap_check_result(soap, "trt:MediaUri");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetSnapshotUriResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetSnapshotUriResponse, 0, sizeof(struct _trt__GetSnapshotUriResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_MediaUri > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetSnapshotUriResponse(struct soap *soap, const struct _trt__GetSnapshotUriResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetSnapshotUriResponse);
	if (soap_out__trt__GetSnapshotUriResponse(soap, tag?tag:"trt:GetSnapshotUriResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetSnapshotUriResponse * SOAP_FMAC4 soap_get__trt__GetSnapshotUriResponse(struct soap *soap, struct _trt__GetSnapshotUriResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetSnapshotUriResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetSnapshotUri(struct soap *soap, struct _trt__GetSnapshotUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetSnapshotUri(struct soap *soap, const struct _trt__GetSnapshotUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetSnapshotUri(struct soap *soap, const char *tag, int id, const struct _trt__GetSnapshotUri *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetSnapshotUri), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetSnapshotUri * SOAP_FMAC4 soap_in__trt__GetSnapshotUri(struct soap *soap, const char *tag, struct _trt__GetSnapshotUri *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetSnapshotUri *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetSnapshotUri, sizeof(struct _trt__GetSnapshotUri), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetSnapshotUri(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetSnapshotUri *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetSnapshotUri, 0, sizeof(struct _trt__GetSnapshotUri), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetSnapshotUri(struct soap *soap, const struct _trt__GetSnapshotUri *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetSnapshotUri);
	if (soap_out__trt__GetSnapshotUri(soap, tag?tag:"trt:GetSnapshotUri", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetSnapshotUri * SOAP_FMAC4 soap_get__trt__GetSnapshotUri(struct soap *soap, struct _trt__GetSnapshotUri *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetSnapshotUri(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetStreamUriResponse(struct soap *soap, struct _trt__GetStreamUriResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->MediaUri = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetStreamUriResponse(struct soap *soap, const struct _trt__GetStreamUriResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__MediaUri(soap, &a->MediaUri);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetStreamUriResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetStreamUriResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetStreamUriResponse), type))
		return soap->error;
	if (a->MediaUri)
		soap_element_result(soap, "trt:MediaUri");
	if (soap_out_PointerTott__MediaUri(soap, "trt:MediaUri", -1, &a->MediaUri, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetStreamUriResponse * SOAP_FMAC4 soap_in__trt__GetStreamUriResponse(struct soap *soap, const char *tag, struct _trt__GetStreamUriResponse *a, const char *type)
{
	size_t soap_flag_MediaUri = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetStreamUriResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetStreamUriResponse, sizeof(struct _trt__GetStreamUriResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetStreamUriResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_MediaUri && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__MediaUri(soap, "trt:MediaUri", &a->MediaUri, "tt:MediaUri"))
				{	soap_flag_MediaUri--;
					continue;
				}
			soap_check_result(soap, "trt:MediaUri");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetStreamUriResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetStreamUriResponse, 0, sizeof(struct _trt__GetStreamUriResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_MediaUri > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetStreamUriResponse(struct soap *soap, const struct _trt__GetStreamUriResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetStreamUriResponse);
	if (soap_out__trt__GetStreamUriResponse(soap, tag?tag:"trt:GetStreamUriResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetStreamUriResponse * SOAP_FMAC4 soap_get__trt__GetStreamUriResponse(struct soap *soap, struct _trt__GetStreamUriResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetStreamUriResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetStreamUri(struct soap *soap, struct _trt__GetStreamUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->StreamSetup = NULL;
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetStreamUri(struct soap *soap, const struct _trt__GetStreamUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__StreamSetup(soap, &a->StreamSetup);
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetStreamUri(struct soap *soap, const char *tag, int id, const struct _trt__GetStreamUri *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetStreamUri), type))
		return soap->error;
	if (soap_out_PointerTott__StreamSetup(soap, "trt:StreamSetup", -1, &a->StreamSetup, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetStreamUri * SOAP_FMAC4 soap_in__trt__GetStreamUri(struct soap *soap, const char *tag, struct _trt__GetStreamUri *a, const char *type)
{
	size_t soap_flag_StreamSetup = 1;
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetStreamUri *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetStreamUri, sizeof(struct _trt__GetStreamUri), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetStreamUri(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_StreamSetup && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__StreamSetup(soap, "trt:StreamSetup", &a->StreamSetup, "tt:StreamSetup"))
				{	soap_flag_StreamSetup--;
					continue;
				}
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetStreamUri *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetStreamUri, 0, sizeof(struct _trt__GetStreamUri), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_StreamSetup > 0 || soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetStreamUri(struct soap *soap, const struct _trt__GetStreamUri *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetStreamUri);
	if (soap_out__trt__GetStreamUri(soap, tag?tag:"trt:GetStreamUri", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetStreamUri * SOAP_FMAC4 soap_get__trt__GetStreamUri(struct soap *soap, struct _trt__GetStreamUri *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetStreamUri(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioEncoderConfigurationOptionsResponse(struct soap *soap, struct _trt__GetAudioEncoderConfigurationOptionsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioEncoderConfigurationOptionsResponse(struct soap *soap, const struct _trt__GetAudioEncoderConfigurationOptionsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__AudioEncoderConfigurationOptions(soap, &a->Options);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioEncoderConfigurationOptionsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioEncoderConfigurationOptionsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse), type))
		return soap->error;
	if (a->Options)
		soap_element_result(soap, "trt:Options");
	if (soap_out_PointerTott__AudioEncoderConfigurationOptions(soap, "trt:Options", -1, &a->Options, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurationOptionsResponse * SOAP_FMAC4 soap_in__trt__GetAudioEncoderConfigurationOptionsResponse(struct soap *soap, const char *tag, struct _trt__GetAudioEncoderConfigurationOptionsResponse *a, const char *type)
{
	size_t soap_flag_Options = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioEncoderConfigurationOptionsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse, sizeof(struct _trt__GetAudioEncoderConfigurationOptionsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioEncoderConfigurationOptionsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Options && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__AudioEncoderConfigurationOptions(soap, "trt:Options", &a->Options, "tt:AudioEncoderConfigurationOptions"))
				{	soap_flag_Options--;
					continue;
				}
			soap_check_result(soap, "trt:Options");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioEncoderConfigurationOptionsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse, 0, sizeof(struct _trt__GetAudioEncoderConfigurationOptionsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Options > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioEncoderConfigurationOptionsResponse(struct soap *soap, const struct _trt__GetAudioEncoderConfigurationOptionsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse);
	if (soap_out__trt__GetAudioEncoderConfigurationOptionsResponse(soap, tag?tag:"trt:GetAudioEncoderConfigurationOptionsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurationOptionsResponse * SOAP_FMAC4 soap_get__trt__GetAudioEncoderConfigurationOptionsResponse(struct soap *soap, struct _trt__GetAudioEncoderConfigurationOptionsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioEncoderConfigurationOptionsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioEncoderConfigurationOptions(struct soap *soap, struct _trt__GetAudioEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const struct _trt__GetAudioEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioEncoderConfigurationOptions *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurationOptions * SOAP_FMAC4 soap_in__trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const char *tag, struct _trt__GetAudioEncoderConfigurationOptions *a, const char *type)
{
	size_t soap_flag_ConfigurationToken = 1;
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioEncoderConfigurationOptions *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions, sizeof(struct _trt__GetAudioEncoderConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioEncoderConfigurationOptions(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioEncoderConfigurationOptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions, 0, sizeof(struct _trt__GetAudioEncoderConfigurationOptions), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const struct _trt__GetAudioEncoderConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions);
	if (soap_out__trt__GetAudioEncoderConfigurationOptions(soap, tag?tag:"trt:GetAudioEncoderConfigurationOptions", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurationOptions * SOAP_FMAC4 soap_get__trt__GetAudioEncoderConfigurationOptions(struct soap *soap, struct _trt__GetAudioEncoderConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioEncoderConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioSourceConfigurationOptionsResponse(struct soap *soap, struct _trt__GetAudioSourceConfigurationOptionsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioSourceConfigurationOptionsResponse(struct soap *soap, const struct _trt__GetAudioSourceConfigurationOptionsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__AudioSourceConfigurationOptions(soap, &a->Options);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioSourceConfigurationOptionsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioSourceConfigurationOptionsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse), type))
		return soap->error;
	if (a->Options)
		soap_element_result(soap, "trt:Options");
	if (soap_out_PointerTott__AudioSourceConfigurationOptions(soap, "trt:Options", -1, &a->Options, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurationOptionsResponse * SOAP_FMAC4 soap_in__trt__GetAudioSourceConfigurationOptionsResponse(struct soap *soap, const char *tag, struct _trt__GetAudioSourceConfigurationOptionsResponse *a, const char *type)
{
	size_t soap_flag_Options = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioSourceConfigurationOptionsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse, sizeof(struct _trt__GetAudioSourceConfigurationOptionsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioSourceConfigurationOptionsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Options && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__AudioSourceConfigurationOptions(soap, "trt:Options", &a->Options, "tt:AudioSourceConfigurationOptions"))
				{	soap_flag_Options--;
					continue;
				}
			soap_check_result(soap, "trt:Options");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioSourceConfigurationOptionsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse, 0, sizeof(struct _trt__GetAudioSourceConfigurationOptionsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Options > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioSourceConfigurationOptionsResponse(struct soap *soap, const struct _trt__GetAudioSourceConfigurationOptionsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse);
	if (soap_out__trt__GetAudioSourceConfigurationOptionsResponse(soap, tag?tag:"trt:GetAudioSourceConfigurationOptionsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurationOptionsResponse * SOAP_FMAC4 soap_get__trt__GetAudioSourceConfigurationOptionsResponse(struct soap *soap, struct _trt__GetAudioSourceConfigurationOptionsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioSourceConfigurationOptionsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioSourceConfigurationOptions(struct soap *soap, struct _trt__GetAudioSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioSourceConfigurationOptions(struct soap *soap, const struct _trt__GetAudioSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioSourceConfigurationOptions(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioSourceConfigurationOptions *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioSourceConfigurationOptions), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurationOptions * SOAP_FMAC4 soap_in__trt__GetAudioSourceConfigurationOptions(struct soap *soap, const char *tag, struct _trt__GetAudioSourceConfigurationOptions *a, const char *type)
{
	size_t soap_flag_ConfigurationToken = 1;
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioSourceConfigurationOptions *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioSourceConfigurationOptions, sizeof(struct _trt__GetAudioSourceConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioSourceConfigurationOptions(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioSourceConfigurationOptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioSourceConfigurationOptions, 0, sizeof(struct _trt__GetAudioSourceConfigurationOptions), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioSourceConfigurationOptions(struct soap *soap, const struct _trt__GetAudioSourceConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioSourceConfigurationOptions);
	if (soap_out__trt__GetAudioSourceConfigurationOptions(soap, tag?tag:"trt:GetAudioSourceConfigurationOptions", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurationOptions * SOAP_FMAC4 soap_get__trt__GetAudioSourceConfigurationOptions(struct soap *soap, struct _trt__GetAudioSourceConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioSourceConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoEncoderConfigurationOptionsResponse(struct soap *soap, struct _trt__GetVideoEncoderConfigurationOptionsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoEncoderConfigurationOptionsResponse(struct soap *soap, const struct _trt__GetVideoEncoderConfigurationOptionsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__VideoEncoderConfigurationOptions(soap, &a->Options);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoEncoderConfigurationOptionsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoEncoderConfigurationOptionsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse), type))
		return soap->error;
	if (a->Options)
		soap_element_result(soap, "trt:Options");
	if (soap_out_PointerTott__VideoEncoderConfigurationOptions(soap, "trt:Options", -1, &a->Options, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurationOptionsResponse * SOAP_FMAC4 soap_in__trt__GetVideoEncoderConfigurationOptionsResponse(struct soap *soap, const char *tag, struct _trt__GetVideoEncoderConfigurationOptionsResponse *a, const char *type)
{
	size_t soap_flag_Options = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoEncoderConfigurationOptionsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse, sizeof(struct _trt__GetVideoEncoderConfigurationOptionsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoEncoderConfigurationOptionsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Options && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__VideoEncoderConfigurationOptions(soap, "trt:Options", &a->Options, "tt:VideoEncoderConfigurationOptions"))
				{	soap_flag_Options--;
					continue;
				}
			soap_check_result(soap, "trt:Options");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoEncoderConfigurationOptionsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse, 0, sizeof(struct _trt__GetVideoEncoderConfigurationOptionsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Options > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoEncoderConfigurationOptionsResponse(struct soap *soap, const struct _trt__GetVideoEncoderConfigurationOptionsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse);
	if (soap_out__trt__GetVideoEncoderConfigurationOptionsResponse(soap, tag?tag:"trt:GetVideoEncoderConfigurationOptionsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurationOptionsResponse * SOAP_FMAC4 soap_get__trt__GetVideoEncoderConfigurationOptionsResponse(struct soap *soap, struct _trt__GetVideoEncoderConfigurationOptionsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoEncoderConfigurationOptionsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoEncoderConfigurationOptions(struct soap *soap, struct _trt__GetVideoEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const struct _trt__GetVideoEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoEncoderConfigurationOptions *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurationOptions * SOAP_FMAC4 soap_in__trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const char *tag, struct _trt__GetVideoEncoderConfigurationOptions *a, const char *type)
{
	size_t soap_flag_ConfigurationToken = 1;
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoEncoderConfigurationOptions *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions, sizeof(struct _trt__GetVideoEncoderConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoEncoderConfigurationOptions(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoEncoderConfigurationOptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions, 0, sizeof(struct _trt__GetVideoEncoderConfigurationOptions), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const struct _trt__GetVideoEncoderConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions);
	if (soap_out__trt__GetVideoEncoderConfigurationOptions(soap, tag?tag:"trt:GetVideoEncoderConfigurationOptions", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurationOptions * SOAP_FMAC4 soap_get__trt__GetVideoEncoderConfigurationOptions(struct soap *soap, struct _trt__GetVideoEncoderConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoEncoderConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoSourceConfigurationOptionsResponse(struct soap *soap, struct _trt__GetVideoSourceConfigurationOptionsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoSourceConfigurationOptionsResponse(struct soap *soap, const struct _trt__GetVideoSourceConfigurationOptionsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__VideoSourceConfigurationOptions(soap, &a->Options);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoSourceConfigurationOptionsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoSourceConfigurationOptionsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse), type))
		return soap->error;
	if (a->Options)
		soap_element_result(soap, "trt:Options");
	if (soap_out_PointerTott__VideoSourceConfigurationOptions(soap, "trt:Options", -1, &a->Options, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurationOptionsResponse * SOAP_FMAC4 soap_in__trt__GetVideoSourceConfigurationOptionsResponse(struct soap *soap, const char *tag, struct _trt__GetVideoSourceConfigurationOptionsResponse *a, const char *type)
{
	size_t soap_flag_Options = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoSourceConfigurationOptionsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse, sizeof(struct _trt__GetVideoSourceConfigurationOptionsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoSourceConfigurationOptionsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Options && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__VideoSourceConfigurationOptions(soap, "trt:Options", &a->Options, "tt:VideoSourceConfigurationOptions"))
				{	soap_flag_Options--;
					continue;
				}
			soap_check_result(soap, "trt:Options");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoSourceConfigurationOptionsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse, 0, sizeof(struct _trt__GetVideoSourceConfigurationOptionsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Options > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoSourceConfigurationOptionsResponse(struct soap *soap, const struct _trt__GetVideoSourceConfigurationOptionsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse);
	if (soap_out__trt__GetVideoSourceConfigurationOptionsResponse(soap, tag?tag:"trt:GetVideoSourceConfigurationOptionsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurationOptionsResponse * SOAP_FMAC4 soap_get__trt__GetVideoSourceConfigurationOptionsResponse(struct soap *soap, struct _trt__GetVideoSourceConfigurationOptionsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoSourceConfigurationOptionsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoSourceConfigurationOptions(struct soap *soap, struct _trt__GetVideoSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoSourceConfigurationOptions(struct soap *soap, const struct _trt__GetVideoSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoSourceConfigurationOptions(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoSourceConfigurationOptions *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoSourceConfigurationOptions), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurationOptions * SOAP_FMAC4 soap_in__trt__GetVideoSourceConfigurationOptions(struct soap *soap, const char *tag, struct _trt__GetVideoSourceConfigurationOptions *a, const char *type)
{
	size_t soap_flag_ConfigurationToken = 1;
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoSourceConfigurationOptions *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoSourceConfigurationOptions, sizeof(struct _trt__GetVideoSourceConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoSourceConfigurationOptions(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoSourceConfigurationOptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoSourceConfigurationOptions, 0, sizeof(struct _trt__GetVideoSourceConfigurationOptions), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoSourceConfigurationOptions(struct soap *soap, const struct _trt__GetVideoSourceConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoSourceConfigurationOptions);
	if (soap_out__trt__GetVideoSourceConfigurationOptions(soap, tag?tag:"trt:GetVideoSourceConfigurationOptions", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurationOptions * SOAP_FMAC4 soap_get__trt__GetVideoSourceConfigurationOptions(struct soap *soap, struct _trt__GetVideoSourceConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoSourceConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__SetAudioSourceConfigurationResponse(struct soap *soap, struct _trt__SetAudioSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__SetAudioSourceConfigurationResponse(struct soap *soap, const struct _trt__SetAudioSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__SetAudioSourceConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__SetAudioSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__SetAudioSourceConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__SetAudioSourceConfigurationResponse * SOAP_FMAC4 soap_in__trt__SetAudioSourceConfigurationResponse(struct soap *soap, const char *tag, struct _trt__SetAudioSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__SetAudioSourceConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__SetAudioSourceConfigurationResponse, sizeof(struct _trt__SetAudioSourceConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__SetAudioSourceConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__SetAudioSourceConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__SetAudioSourceConfigurationResponse, 0, sizeof(struct _trt__SetAudioSourceConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__SetAudioSourceConfigurationResponse(struct soap *soap, const struct _trt__SetAudioSourceConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__SetAudioSourceConfigurationResponse);
	if (soap_out__trt__SetAudioSourceConfigurationResponse(soap, tag?tag:"trt:SetAudioSourceConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__SetAudioSourceConfigurationResponse * SOAP_FMAC4 soap_get__trt__SetAudioSourceConfigurationResponse(struct soap *soap, struct _trt__SetAudioSourceConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__SetAudioSourceConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__SetAudioSourceConfiguration(struct soap *soap, struct _trt__SetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Configuration = NULL;
	soap_default_xsd__boolean(soap, &a->ForcePersistence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__SetAudioSourceConfiguration(struct soap *soap, const struct _trt__SetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__AudioSourceConfiguration(soap, &a->Configuration);
	soap_embedded(soap, &a->ForcePersistence, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__SetAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__SetAudioSourceConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__SetAudioSourceConfiguration), type))
		return soap->error;
	if (soap_out_PointerTott__AudioSourceConfiguration(soap, "trt:Configuration", -1, &a->Configuration, ""))
		return soap->error;
	if (soap_out_xsd__boolean(soap, "trt:ForcePersistence", -1, &a->ForcePersistence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__SetAudioSourceConfiguration * SOAP_FMAC4 soap_in__trt__SetAudioSourceConfiguration(struct soap *soap, const char *tag, struct _trt__SetAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_Configuration = 1;
	size_t soap_flag_ForcePersistence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__SetAudioSourceConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__SetAudioSourceConfiguration, sizeof(struct _trt__SetAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__SetAudioSourceConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Configuration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__AudioSourceConfiguration(soap, "trt:Configuration", &a->Configuration, "tt:AudioSourceConfiguration"))
				{	soap_flag_Configuration--;
					continue;
				}
			if (soap_flag_ForcePersistence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "trt:ForcePersistence", &a->ForcePersistence, "xsd:boolean"))
				{	soap_flag_ForcePersistence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__SetAudioSourceConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__SetAudioSourceConfiguration, 0, sizeof(struct _trt__SetAudioSourceConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Configuration > 0 || soap_flag_ForcePersistence > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__SetAudioSourceConfiguration(struct soap *soap, const struct _trt__SetAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__SetAudioSourceConfiguration);
	if (soap_out__trt__SetAudioSourceConfiguration(soap, tag?tag:"trt:SetAudioSourceConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__SetAudioSourceConfiguration * SOAP_FMAC4 soap_get__trt__SetAudioSourceConfiguration(struct soap *soap, struct _trt__SetAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__SetAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__SetAudioEncoderConfigurationResponse(struct soap *soap, struct _trt__SetAudioEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__SetAudioEncoderConfigurationResponse(struct soap *soap, const struct _trt__SetAudioEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__SetAudioEncoderConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__SetAudioEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__SetAudioEncoderConfigurationResponse * SOAP_FMAC4 soap_in__trt__SetAudioEncoderConfigurationResponse(struct soap *soap, const char *tag, struct _trt__SetAudioEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__SetAudioEncoderConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse, sizeof(struct _trt__SetAudioEncoderConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__SetAudioEncoderConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__SetAudioEncoderConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse, 0, sizeof(struct _trt__SetAudioEncoderConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__SetAudioEncoderConfigurationResponse(struct soap *soap, const struct _trt__SetAudioEncoderConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse);
	if (soap_out__trt__SetAudioEncoderConfigurationResponse(soap, tag?tag:"trt:SetAudioEncoderConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__SetAudioEncoderConfigurationResponse * SOAP_FMAC4 soap_get__trt__SetAudioEncoderConfigurationResponse(struct soap *soap, struct _trt__SetAudioEncoderConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__SetAudioEncoderConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__SetAudioEncoderConfiguration(struct soap *soap, struct _trt__SetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Configuration = NULL;
	soap_default_xsd__boolean(soap, &a->ForcePersistence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__SetAudioEncoderConfiguration(struct soap *soap, const struct _trt__SetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__AudioEncoderConfiguration(soap, &a->Configuration);
	soap_embedded(soap, &a->ForcePersistence, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__SetAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__SetAudioEncoderConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__SetAudioEncoderConfiguration), type))
		return soap->error;
	if (soap_out_PointerTott__AudioEncoderConfiguration(soap, "trt:Configuration", -1, &a->Configuration, ""))
		return soap->error;
	if (soap_out_xsd__boolean(soap, "trt:ForcePersistence", -1, &a->ForcePersistence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__SetAudioEncoderConfiguration * SOAP_FMAC4 soap_in__trt__SetAudioEncoderConfiguration(struct soap *soap, const char *tag, struct _trt__SetAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_Configuration = 1;
	size_t soap_flag_ForcePersistence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__SetAudioEncoderConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__SetAudioEncoderConfiguration, sizeof(struct _trt__SetAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__SetAudioEncoderConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Configuration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__AudioEncoderConfiguration(soap, "trt:Configuration", &a->Configuration, "tt:AudioEncoderConfiguration"))
				{	soap_flag_Configuration--;
					continue;
				}
			if (soap_flag_ForcePersistence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "trt:ForcePersistence", &a->ForcePersistence, "xsd:boolean"))
				{	soap_flag_ForcePersistence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__SetAudioEncoderConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__SetAudioEncoderConfiguration, 0, sizeof(struct _trt__SetAudioEncoderConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Configuration > 0 || soap_flag_ForcePersistence > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__SetAudioEncoderConfiguration(struct soap *soap, const struct _trt__SetAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__SetAudioEncoderConfiguration);
	if (soap_out__trt__SetAudioEncoderConfiguration(soap, tag?tag:"trt:SetAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__SetAudioEncoderConfiguration * SOAP_FMAC4 soap_get__trt__SetAudioEncoderConfiguration(struct soap *soap, struct _trt__SetAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__SetAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__SetVideoSourceConfigurationResponse(struct soap *soap, struct _trt__SetVideoSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__SetVideoSourceConfigurationResponse(struct soap *soap, const struct _trt__SetVideoSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__SetVideoSourceConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__SetVideoSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__SetVideoSourceConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__SetVideoSourceConfigurationResponse * SOAP_FMAC4 soap_in__trt__SetVideoSourceConfigurationResponse(struct soap *soap, const char *tag, struct _trt__SetVideoSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__SetVideoSourceConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__SetVideoSourceConfigurationResponse, sizeof(struct _trt__SetVideoSourceConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__SetVideoSourceConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__SetVideoSourceConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__SetVideoSourceConfigurationResponse, 0, sizeof(struct _trt__SetVideoSourceConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__SetVideoSourceConfigurationResponse(struct soap *soap, const struct _trt__SetVideoSourceConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__SetVideoSourceConfigurationResponse);
	if (soap_out__trt__SetVideoSourceConfigurationResponse(soap, tag?tag:"trt:SetVideoSourceConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__SetVideoSourceConfigurationResponse * SOAP_FMAC4 soap_get__trt__SetVideoSourceConfigurationResponse(struct soap *soap, struct _trt__SetVideoSourceConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__SetVideoSourceConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__SetVideoSourceConfiguration(struct soap *soap, struct _trt__SetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Configuration = NULL;
	soap_default_xsd__boolean(soap, &a->ForcePersistence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__SetVideoSourceConfiguration(struct soap *soap, const struct _trt__SetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__VideoSourceConfiguration(soap, &a->Configuration);
	soap_embedded(soap, &a->ForcePersistence, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__SetVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__SetVideoSourceConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__SetVideoSourceConfiguration), type))
		return soap->error;
	if (soap_out_PointerTott__VideoSourceConfiguration(soap, "trt:Configuration", -1, &a->Configuration, ""))
		return soap->error;
	if (soap_out_xsd__boolean(soap, "trt:ForcePersistence", -1, &a->ForcePersistence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__SetVideoSourceConfiguration * SOAP_FMAC4 soap_in__trt__SetVideoSourceConfiguration(struct soap *soap, const char *tag, struct _trt__SetVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_Configuration = 1;
	size_t soap_flag_ForcePersistence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__SetVideoSourceConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__SetVideoSourceConfiguration, sizeof(struct _trt__SetVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__SetVideoSourceConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Configuration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__VideoSourceConfiguration(soap, "trt:Configuration", &a->Configuration, "tt:VideoSourceConfiguration"))
				{	soap_flag_Configuration--;
					continue;
				}
			if (soap_flag_ForcePersistence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "trt:ForcePersistence", &a->ForcePersistence, "xsd:boolean"))
				{	soap_flag_ForcePersistence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__SetVideoSourceConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__SetVideoSourceConfiguration, 0, sizeof(struct _trt__SetVideoSourceConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Configuration > 0 || soap_flag_ForcePersistence > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__SetVideoSourceConfiguration(struct soap *soap, const struct _trt__SetVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__SetVideoSourceConfiguration);
	if (soap_out__trt__SetVideoSourceConfiguration(soap, tag?tag:"trt:SetVideoSourceConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__SetVideoSourceConfiguration * SOAP_FMAC4 soap_get__trt__SetVideoSourceConfiguration(struct soap *soap, struct _trt__SetVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__SetVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__SetVideoEncoderConfigurationResponse(struct soap *soap, struct _trt__SetVideoEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__SetVideoEncoderConfigurationResponse(struct soap *soap, const struct _trt__SetVideoEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__SetVideoEncoderConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__SetVideoEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__SetVideoEncoderConfigurationResponse * SOAP_FMAC4 soap_in__trt__SetVideoEncoderConfigurationResponse(struct soap *soap, const char *tag, struct _trt__SetVideoEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__SetVideoEncoderConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse, sizeof(struct _trt__SetVideoEncoderConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__SetVideoEncoderConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__SetVideoEncoderConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse, 0, sizeof(struct _trt__SetVideoEncoderConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__SetVideoEncoderConfigurationResponse(struct soap *soap, const struct _trt__SetVideoEncoderConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse);
	if (soap_out__trt__SetVideoEncoderConfigurationResponse(soap, tag?tag:"trt:SetVideoEncoderConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__SetVideoEncoderConfigurationResponse * SOAP_FMAC4 soap_get__trt__SetVideoEncoderConfigurationResponse(struct soap *soap, struct _trt__SetVideoEncoderConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__SetVideoEncoderConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__SetVideoEncoderConfiguration(struct soap *soap, struct _trt__SetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Configuration = NULL;
	soap_default_xsd__boolean(soap, &a->ForcePersistence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__SetVideoEncoderConfiguration(struct soap *soap, const struct _trt__SetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__VideoEncoderConfiguration(soap, &a->Configuration);
	soap_embedded(soap, &a->ForcePersistence, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__SetVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__SetVideoEncoderConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__SetVideoEncoderConfiguration), type))
		return soap->error;
	if (soap_out_PointerTott__VideoEncoderConfiguration(soap, "trt:Configuration", -1, &a->Configuration, ""))
		return soap->error;
	if (soap_out_xsd__boolean(soap, "trt:ForcePersistence", -1, &a->ForcePersistence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__SetVideoEncoderConfiguration * SOAP_FMAC4 soap_in__trt__SetVideoEncoderConfiguration(struct soap *soap, const char *tag, struct _trt__SetVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_Configuration = 1;
	size_t soap_flag_ForcePersistence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__SetVideoEncoderConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__SetVideoEncoderConfiguration, sizeof(struct _trt__SetVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__SetVideoEncoderConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Configuration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__VideoEncoderConfiguration(soap, "trt:Configuration", &a->Configuration, "tt:VideoEncoderConfiguration"))
				{	soap_flag_Configuration--;
					continue;
				}
			if (soap_flag_ForcePersistence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "trt:ForcePersistence", &a->ForcePersistence, "xsd:boolean"))
				{	soap_flag_ForcePersistence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__SetVideoEncoderConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__SetVideoEncoderConfiguration, 0, sizeof(struct _trt__SetVideoEncoderConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Configuration > 0 || soap_flag_ForcePersistence > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__SetVideoEncoderConfiguration(struct soap *soap, const struct _trt__SetVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__SetVideoEncoderConfiguration);
	if (soap_out__trt__SetVideoEncoderConfiguration(soap, tag?tag:"trt:SetVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__SetVideoEncoderConfiguration * SOAP_FMAC4 soap_get__trt__SetVideoEncoderConfiguration(struct soap *soap, struct _trt__SetVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__SetVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetCompatibleAudioSourceConfigurationsResponse(struct soap *soap, struct _trt__GetCompatibleAudioSourceConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeConfigurations = 0;
	a->Configurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetCompatibleAudioSourceConfigurationsResponse(struct soap *soap, const struct _trt__GetCompatibleAudioSourceConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
		{
			soap_embedded(soap, a->Configurations + i, SOAP_TYPE_tt__AudioSourceConfiguration);
			soap_serialize_tt__AudioSourceConfiguration(soap, a->Configurations + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetCompatibleAudioSourceConfigurationsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetCompatibleAudioSourceConfigurationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeConfigurations");
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
			if (soap_out_tt__AudioSourceConfiguration(soap, "trt:Configurations", -1, a->Configurations + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetCompatibleAudioSourceConfigurationsResponse * SOAP_FMAC4 soap_in__trt__GetCompatibleAudioSourceConfigurationsResponse(struct soap *soap, const char *tag, struct _trt__GetCompatibleAudioSourceConfigurationsResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Configurations = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetCompatibleAudioSourceConfigurationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse, sizeof(struct _trt__GetCompatibleAudioSourceConfigurationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Configurations", 1, NULL))
			{	if (a->Configurations == NULL)
				{	if (soap_blist_Configurations == NULL)
						soap_blist_Configurations = soap_new_block(soap);
					a->Configurations = (struct tt__AudioSourceConfiguration *)soap_push_block(soap, soap_blist_Configurations, sizeof(struct tt__AudioSourceConfiguration));
					if (a->Configurations == NULL)
						return NULL;
					soap_default_tt__AudioSourceConfiguration(soap, a->Configurations);
				}soap_revert(soap);
				if (soap_in_tt__AudioSourceConfiguration(soap, "trt:Configurations", a->Configurations, "tt:AudioSourceConfiguration"))
				{	a->__sizeConfigurations++;
					a->Configurations = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeConfigurations");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Configurations)
			soap_pop_block(soap, soap_blist_Configurations);
		if (a->__sizeConfigurations)
			a->Configurations = (struct tt__AudioSourceConfiguration *)soap_save_block(soap, soap_blist_Configurations, NULL, 1);
		else
		{	a->Configurations = NULL;
			if (soap_blist_Configurations)
				soap_end_block(soap, soap_blist_Configurations);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetCompatibleAudioSourceConfigurationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse, 0, sizeof(struct _trt__GetCompatibleAudioSourceConfigurationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetCompatibleAudioSourceConfigurationsResponse(struct soap *soap, const struct _trt__GetCompatibleAudioSourceConfigurationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse);
	if (soap_out__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, tag?tag:"trt:GetCompatibleAudioSourceConfigurationsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetCompatibleAudioSourceConfigurationsResponse * SOAP_FMAC4 soap_get__trt__GetCompatibleAudioSourceConfigurationsResponse(struct soap *soap, struct _trt__GetCompatibleAudioSourceConfigurationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, struct _trt__GetCompatibleAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const struct _trt__GetCompatibleAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const char *tag, int id, const struct _trt__GetCompatibleAudioSourceConfigurations *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetCompatibleAudioSourceConfigurations * SOAP_FMAC4 soap_in__trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const char *tag, struct _trt__GetCompatibleAudioSourceConfigurations *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetCompatibleAudioSourceConfigurations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations, sizeof(struct _trt__GetCompatibleAudioSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetCompatibleAudioSourceConfigurations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetCompatibleAudioSourceConfigurations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations, 0, sizeof(struct _trt__GetCompatibleAudioSourceConfigurations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const struct _trt__GetCompatibleAudioSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations);
	if (soap_out__trt__GetCompatibleAudioSourceConfigurations(soap, tag?tag:"trt:GetCompatibleAudioSourceConfigurations", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetCompatibleAudioSourceConfigurations * SOAP_FMAC4 soap_get__trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, struct _trt__GetCompatibleAudioSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetCompatibleAudioSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetCompatibleAudioEncoderConfigurationsResponse(struct soap *soap, struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeConfigurations = 0;
	a->Configurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetCompatibleAudioEncoderConfigurationsResponse(struct soap *soap, const struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
		{
			soap_embedded(soap, a->Configurations + i, SOAP_TYPE_tt__AudioEncoderConfiguration);
			soap_serialize_tt__AudioEncoderConfiguration(soap, a->Configurations + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetCompatibleAudioEncoderConfigurationsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeConfigurations");
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
			if (soap_out_tt__AudioEncoderConfiguration(soap, "trt:Configurations", -1, a->Configurations + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetCompatibleAudioEncoderConfigurationsResponse * SOAP_FMAC4 soap_in__trt__GetCompatibleAudioEncoderConfigurationsResponse(struct soap *soap, const char *tag, struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Configurations = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse, sizeof(struct _trt__GetCompatibleAudioEncoderConfigurationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Configurations", 1, NULL))
			{	if (a->Configurations == NULL)
				{	if (soap_blist_Configurations == NULL)
						soap_blist_Configurations = soap_new_block(soap);
					a->Configurations = (struct tt__AudioEncoderConfiguration *)soap_push_block(soap, soap_blist_Configurations, sizeof(struct tt__AudioEncoderConfiguration));
					if (a->Configurations == NULL)
						return NULL;
					soap_default_tt__AudioEncoderConfiguration(soap, a->Configurations);
				}soap_revert(soap);
				if (soap_in_tt__AudioEncoderConfiguration(soap, "trt:Configurations", a->Configurations, "tt:AudioEncoderConfiguration"))
				{	a->__sizeConfigurations++;
					a->Configurations = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeConfigurations");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Configurations)
			soap_pop_block(soap, soap_blist_Configurations);
		if (a->__sizeConfigurations)
			a->Configurations = (struct tt__AudioEncoderConfiguration *)soap_save_block(soap, soap_blist_Configurations, NULL, 1);
		else
		{	a->Configurations = NULL;
			if (soap_blist_Configurations)
				soap_end_block(soap, soap_blist_Configurations);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse, 0, sizeof(struct _trt__GetCompatibleAudioEncoderConfigurationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetCompatibleAudioEncoderConfigurationsResponse(struct soap *soap, const struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse);
	if (soap_out__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, tag?tag:"trt:GetCompatibleAudioEncoderConfigurationsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetCompatibleAudioEncoderConfigurationsResponse * SOAP_FMAC4 soap_get__trt__GetCompatibleAudioEncoderConfigurationsResponse(struct soap *soap, struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, struct _trt__GetCompatibleAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const struct _trt__GetCompatibleAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct _trt__GetCompatibleAudioEncoderConfigurations *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetCompatibleAudioEncoderConfigurations * SOAP_FMAC4 soap_in__trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const char *tag, struct _trt__GetCompatibleAudioEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetCompatibleAudioEncoderConfigurations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations, sizeof(struct _trt__GetCompatibleAudioEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetCompatibleAudioEncoderConfigurations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetCompatibleAudioEncoderConfigurations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations, 0, sizeof(struct _trt__GetCompatibleAudioEncoderConfigurations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const struct _trt__GetCompatibleAudioEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations);
	if (soap_out__trt__GetCompatibleAudioEncoderConfigurations(soap, tag?tag:"trt:GetCompatibleAudioEncoderConfigurations", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetCompatibleAudioEncoderConfigurations * SOAP_FMAC4 soap_get__trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, struct _trt__GetCompatibleAudioEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetCompatibleAudioEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetCompatibleVideoSourceConfigurationsResponse(struct soap *soap, struct _trt__GetCompatibleVideoSourceConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeConfigurations = 0;
	a->Configurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetCompatibleVideoSourceConfigurationsResponse(struct soap *soap, const struct _trt__GetCompatibleVideoSourceConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
		{
			soap_embedded(soap, a->Configurations + i, SOAP_TYPE_tt__VideoSourceConfiguration);
			soap_serialize_tt__VideoSourceConfiguration(soap, a->Configurations + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetCompatibleVideoSourceConfigurationsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetCompatibleVideoSourceConfigurationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeConfigurations");
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
			if (soap_out_tt__VideoSourceConfiguration(soap, "trt:Configurations", -1, a->Configurations + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetCompatibleVideoSourceConfigurationsResponse * SOAP_FMAC4 soap_in__trt__GetCompatibleVideoSourceConfigurationsResponse(struct soap *soap, const char *tag, struct _trt__GetCompatibleVideoSourceConfigurationsResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Configurations = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetCompatibleVideoSourceConfigurationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse, sizeof(struct _trt__GetCompatibleVideoSourceConfigurationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Configurations", 1, NULL))
			{	if (a->Configurations == NULL)
				{	if (soap_blist_Configurations == NULL)
						soap_blist_Configurations = soap_new_block(soap);
					a->Configurations = (struct tt__VideoSourceConfiguration *)soap_push_block(soap, soap_blist_Configurations, sizeof(struct tt__VideoSourceConfiguration));
					if (a->Configurations == NULL)
						return NULL;
					soap_default_tt__VideoSourceConfiguration(soap, a->Configurations);
				}soap_revert(soap);
				if (soap_in_tt__VideoSourceConfiguration(soap, "trt:Configurations", a->Configurations, "tt:VideoSourceConfiguration"))
				{	a->__sizeConfigurations++;
					a->Configurations = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeConfigurations");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Configurations)
			soap_pop_block(soap, soap_blist_Configurations);
		if (a->__sizeConfigurations)
			a->Configurations = (struct tt__VideoSourceConfiguration *)soap_save_block(soap, soap_blist_Configurations, NULL, 1);
		else
		{	a->Configurations = NULL;
			if (soap_blist_Configurations)
				soap_end_block(soap, soap_blist_Configurations);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetCompatibleVideoSourceConfigurationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse, 0, sizeof(struct _trt__GetCompatibleVideoSourceConfigurationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetCompatibleVideoSourceConfigurationsResponse(struct soap *soap, const struct _trt__GetCompatibleVideoSourceConfigurationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse);
	if (soap_out__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, tag?tag:"trt:GetCompatibleVideoSourceConfigurationsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetCompatibleVideoSourceConfigurationsResponse * SOAP_FMAC4 soap_get__trt__GetCompatibleVideoSourceConfigurationsResponse(struct soap *soap, struct _trt__GetCompatibleVideoSourceConfigurationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, struct _trt__GetCompatibleVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const struct _trt__GetCompatibleVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const char *tag, int id, const struct _trt__GetCompatibleVideoSourceConfigurations *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetCompatibleVideoSourceConfigurations * SOAP_FMAC4 soap_in__trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const char *tag, struct _trt__GetCompatibleVideoSourceConfigurations *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetCompatibleVideoSourceConfigurations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations, sizeof(struct _trt__GetCompatibleVideoSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetCompatibleVideoSourceConfigurations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetCompatibleVideoSourceConfigurations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations, 0, sizeof(struct _trt__GetCompatibleVideoSourceConfigurations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const struct _trt__GetCompatibleVideoSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations);
	if (soap_out__trt__GetCompatibleVideoSourceConfigurations(soap, tag?tag:"trt:GetCompatibleVideoSourceConfigurations", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetCompatibleVideoSourceConfigurations * SOAP_FMAC4 soap_get__trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, struct _trt__GetCompatibleVideoSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetCompatibleVideoSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetCompatibleVideoEncoderConfigurationsResponse(struct soap *soap, struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeConfigurations = 0;
	a->Configurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetCompatibleVideoEncoderConfigurationsResponse(struct soap *soap, const struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
		{
			soap_embedded(soap, a->Configurations + i, SOAP_TYPE_tt__VideoEncoderConfiguration);
			soap_serialize_tt__VideoEncoderConfiguration(soap, a->Configurations + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetCompatibleVideoEncoderConfigurationsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeConfigurations");
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
			if (soap_out_tt__VideoEncoderConfiguration(soap, "trt:Configurations", -1, a->Configurations + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetCompatibleVideoEncoderConfigurationsResponse * SOAP_FMAC4 soap_in__trt__GetCompatibleVideoEncoderConfigurationsResponse(struct soap *soap, const char *tag, struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Configurations = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse, sizeof(struct _trt__GetCompatibleVideoEncoderConfigurationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Configurations", 1, NULL))
			{	if (a->Configurations == NULL)
				{	if (soap_blist_Configurations == NULL)
						soap_blist_Configurations = soap_new_block(soap);
					a->Configurations = (struct tt__VideoEncoderConfiguration *)soap_push_block(soap, soap_blist_Configurations, sizeof(struct tt__VideoEncoderConfiguration));
					if (a->Configurations == NULL)
						return NULL;
					soap_default_tt__VideoEncoderConfiguration(soap, a->Configurations);
				}soap_revert(soap);
				if (soap_in_tt__VideoEncoderConfiguration(soap, "trt:Configurations", a->Configurations, "tt:VideoEncoderConfiguration"))
				{	a->__sizeConfigurations++;
					a->Configurations = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeConfigurations");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Configurations)
			soap_pop_block(soap, soap_blist_Configurations);
		if (a->__sizeConfigurations)
			a->Configurations = (struct tt__VideoEncoderConfiguration *)soap_save_block(soap, soap_blist_Configurations, NULL, 1);
		else
		{	a->Configurations = NULL;
			if (soap_blist_Configurations)
				soap_end_block(soap, soap_blist_Configurations);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse, 0, sizeof(struct _trt__GetCompatibleVideoEncoderConfigurationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetCompatibleVideoEncoderConfigurationsResponse(struct soap *soap, const struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse);
	if (soap_out__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, tag?tag:"trt:GetCompatibleVideoEncoderConfigurationsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetCompatibleVideoEncoderConfigurationsResponse * SOAP_FMAC4 soap_get__trt__GetCompatibleVideoEncoderConfigurationsResponse(struct soap *soap, struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, struct _trt__GetCompatibleVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const struct _trt__GetCompatibleVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct _trt__GetCompatibleVideoEncoderConfigurations *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetCompatibleVideoEncoderConfigurations * SOAP_FMAC4 soap_in__trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const char *tag, struct _trt__GetCompatibleVideoEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetCompatibleVideoEncoderConfigurations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations, sizeof(struct _trt__GetCompatibleVideoEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetCompatibleVideoEncoderConfigurations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetCompatibleVideoEncoderConfigurations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations, 0, sizeof(struct _trt__GetCompatibleVideoEncoderConfigurations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const struct _trt__GetCompatibleVideoEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations);
	if (soap_out__trt__GetCompatibleVideoEncoderConfigurations(soap, tag?tag:"trt:GetCompatibleVideoEncoderConfigurations", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetCompatibleVideoEncoderConfigurations * SOAP_FMAC4 soap_get__trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, struct _trt__GetCompatibleVideoEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetCompatibleVideoEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioEncoderConfigurationResponse(struct soap *soap, struct _trt__GetAudioEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Configuration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioEncoderConfigurationResponse(struct soap *soap, const struct _trt__GetAudioEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__AudioEncoderConfiguration(soap, &a->Configuration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioEncoderConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse), type))
		return soap->error;
	if (a->Configuration)
		soap_element_result(soap, "trt:Configuration");
	if (soap_out_PointerTott__AudioEncoderConfiguration(soap, "trt:Configuration", -1, &a->Configuration, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurationResponse * SOAP_FMAC4 soap_in__trt__GetAudioEncoderConfigurationResponse(struct soap *soap, const char *tag, struct _trt__GetAudioEncoderConfigurationResponse *a, const char *type)
{
	size_t soap_flag_Configuration = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioEncoderConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse, sizeof(struct _trt__GetAudioEncoderConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioEncoderConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Configuration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__AudioEncoderConfiguration(soap, "trt:Configuration", &a->Configuration, "tt:AudioEncoderConfiguration"))
				{	soap_flag_Configuration--;
					continue;
				}
			soap_check_result(soap, "trt:Configuration");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioEncoderConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse, 0, sizeof(struct _trt__GetAudioEncoderConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Configuration > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioEncoderConfigurationResponse(struct soap *soap, const struct _trt__GetAudioEncoderConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse);
	if (soap_out__trt__GetAudioEncoderConfigurationResponse(soap, tag?tag:"trt:GetAudioEncoderConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurationResponse * SOAP_FMAC4 soap_get__trt__GetAudioEncoderConfigurationResponse(struct soap *soap, struct _trt__GetAudioEncoderConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioEncoderConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioEncoderConfiguration(struct soap *soap, struct _trt__GetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioEncoderConfiguration(struct soap *soap, const struct _trt__GetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioEncoderConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioEncoderConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfiguration * SOAP_FMAC4 soap_in__trt__GetAudioEncoderConfiguration(struct soap *soap, const char *tag, struct _trt__GetAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_ConfigurationToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioEncoderConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioEncoderConfiguration, sizeof(struct _trt__GetAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioEncoderConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioEncoderConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioEncoderConfiguration, 0, sizeof(struct _trt__GetAudioEncoderConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ConfigurationToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioEncoderConfiguration(struct soap *soap, const struct _trt__GetAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioEncoderConfiguration);
	if (soap_out__trt__GetAudioEncoderConfiguration(soap, tag?tag:"trt:GetAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfiguration * SOAP_FMAC4 soap_get__trt__GetAudioEncoderConfiguration(struct soap *soap, struct _trt__GetAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioSourceConfigurationResponse(struct soap *soap, struct _trt__GetAudioSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Configuration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioSourceConfigurationResponse(struct soap *soap, const struct _trt__GetAudioSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__AudioSourceConfiguration(soap, &a->Configuration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioSourceConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioSourceConfigurationResponse), type))
		return soap->error;
	if (a->Configuration)
		soap_element_result(soap, "trt:Configuration");
	if (soap_out_PointerTott__AudioSourceConfiguration(soap, "trt:Configuration", -1, &a->Configuration, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurationResponse * SOAP_FMAC4 soap_in__trt__GetAudioSourceConfigurationResponse(struct soap *soap, const char *tag, struct _trt__GetAudioSourceConfigurationResponse *a, const char *type)
{
	size_t soap_flag_Configuration = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioSourceConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioSourceConfigurationResponse, sizeof(struct _trt__GetAudioSourceConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioSourceConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Configuration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__AudioSourceConfiguration(soap, "trt:Configuration", &a->Configuration, "tt:AudioSourceConfiguration"))
				{	soap_flag_Configuration--;
					continue;
				}
			soap_check_result(soap, "trt:Configuration");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioSourceConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioSourceConfigurationResponse, 0, sizeof(struct _trt__GetAudioSourceConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Configuration > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioSourceConfigurationResponse(struct soap *soap, const struct _trt__GetAudioSourceConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioSourceConfigurationResponse);
	if (soap_out__trt__GetAudioSourceConfigurationResponse(soap, tag?tag:"trt:GetAudioSourceConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurationResponse * SOAP_FMAC4 soap_get__trt__GetAudioSourceConfigurationResponse(struct soap *soap, struct _trt__GetAudioSourceConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioSourceConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioSourceConfiguration(struct soap *soap, struct _trt__GetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioSourceConfiguration(struct soap *soap, const struct _trt__GetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioSourceConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioSourceConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfiguration * SOAP_FMAC4 soap_in__trt__GetAudioSourceConfiguration(struct soap *soap, const char *tag, struct _trt__GetAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_ConfigurationToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioSourceConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioSourceConfiguration, sizeof(struct _trt__GetAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioSourceConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioSourceConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioSourceConfiguration, 0, sizeof(struct _trt__GetAudioSourceConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ConfigurationToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioSourceConfiguration(struct soap *soap, const struct _trt__GetAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioSourceConfiguration);
	if (soap_out__trt__GetAudioSourceConfiguration(soap, tag?tag:"trt:GetAudioSourceConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfiguration * SOAP_FMAC4 soap_get__trt__GetAudioSourceConfiguration(struct soap *soap, struct _trt__GetAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoEncoderConfigurationResponse(struct soap *soap, struct _trt__GetVideoEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Configuration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoEncoderConfigurationResponse(struct soap *soap, const struct _trt__GetVideoEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__VideoEncoderConfiguration(soap, &a->Configuration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoEncoderConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse), type))
		return soap->error;
	if (a->Configuration)
		soap_element_result(soap, "trt:Configuration");
	if (soap_out_PointerTott__VideoEncoderConfiguration(soap, "trt:Configuration", -1, &a->Configuration, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurationResponse * SOAP_FMAC4 soap_in__trt__GetVideoEncoderConfigurationResponse(struct soap *soap, const char *tag, struct _trt__GetVideoEncoderConfigurationResponse *a, const char *type)
{
	size_t soap_flag_Configuration = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoEncoderConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse, sizeof(struct _trt__GetVideoEncoderConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoEncoderConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Configuration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__VideoEncoderConfiguration(soap, "trt:Configuration", &a->Configuration, "tt:VideoEncoderConfiguration"))
				{	soap_flag_Configuration--;
					continue;
				}
			soap_check_result(soap, "trt:Configuration");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoEncoderConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse, 0, sizeof(struct _trt__GetVideoEncoderConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Configuration > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoEncoderConfigurationResponse(struct soap *soap, const struct _trt__GetVideoEncoderConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse);
	if (soap_out__trt__GetVideoEncoderConfigurationResponse(soap, tag?tag:"trt:GetVideoEncoderConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurationResponse * SOAP_FMAC4 soap_get__trt__GetVideoEncoderConfigurationResponse(struct soap *soap, struct _trt__GetVideoEncoderConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoEncoderConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoEncoderConfiguration(struct soap *soap, struct _trt__GetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoEncoderConfiguration(struct soap *soap, const struct _trt__GetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoEncoderConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoEncoderConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfiguration * SOAP_FMAC4 soap_in__trt__GetVideoEncoderConfiguration(struct soap *soap, const char *tag, struct _trt__GetVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_ConfigurationToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoEncoderConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoEncoderConfiguration, sizeof(struct _trt__GetVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoEncoderConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoEncoderConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoEncoderConfiguration, 0, sizeof(struct _trt__GetVideoEncoderConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ConfigurationToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoEncoderConfiguration(struct soap *soap, const struct _trt__GetVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoEncoderConfiguration);
	if (soap_out__trt__GetVideoEncoderConfiguration(soap, tag?tag:"trt:GetVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfiguration * SOAP_FMAC4 soap_get__trt__GetVideoEncoderConfiguration(struct soap *soap, struct _trt__GetVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoSourceConfigurationResponse(struct soap *soap, struct _trt__GetVideoSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Configuration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoSourceConfigurationResponse(struct soap *soap, const struct _trt__GetVideoSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__VideoSourceConfiguration(soap, &a->Configuration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoSourceConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoSourceConfigurationResponse), type))
		return soap->error;
	if (a->Configuration)
		soap_element_result(soap, "trt:Configuration");
	if (soap_out_PointerTott__VideoSourceConfiguration(soap, "trt:Configuration", -1, &a->Configuration, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurationResponse * SOAP_FMAC4 soap_in__trt__GetVideoSourceConfigurationResponse(struct soap *soap, const char *tag, struct _trt__GetVideoSourceConfigurationResponse *a, const char *type)
{
	size_t soap_flag_Configuration = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoSourceConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoSourceConfigurationResponse, sizeof(struct _trt__GetVideoSourceConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoSourceConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Configuration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__VideoSourceConfiguration(soap, "trt:Configuration", &a->Configuration, "tt:VideoSourceConfiguration"))
				{	soap_flag_Configuration--;
					continue;
				}
			soap_check_result(soap, "trt:Configuration");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoSourceConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoSourceConfigurationResponse, 0, sizeof(struct _trt__GetVideoSourceConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Configuration > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoSourceConfigurationResponse(struct soap *soap, const struct _trt__GetVideoSourceConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoSourceConfigurationResponse);
	if (soap_out__trt__GetVideoSourceConfigurationResponse(soap, tag?tag:"trt:GetVideoSourceConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurationResponse * SOAP_FMAC4 soap_get__trt__GetVideoSourceConfigurationResponse(struct soap *soap, struct _trt__GetVideoSourceConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoSourceConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoSourceConfiguration(struct soap *soap, struct _trt__GetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoSourceConfiguration(struct soap *soap, const struct _trt__GetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoSourceConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoSourceConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfiguration * SOAP_FMAC4 soap_in__trt__GetVideoSourceConfiguration(struct soap *soap, const char *tag, struct _trt__GetVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_ConfigurationToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoSourceConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoSourceConfiguration, sizeof(struct _trt__GetVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoSourceConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoSourceConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoSourceConfiguration, 0, sizeof(struct _trt__GetVideoSourceConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ConfigurationToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoSourceConfiguration(struct soap *soap, const struct _trt__GetVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoSourceConfiguration);
	if (soap_out__trt__GetVideoSourceConfiguration(soap, tag?tag:"trt:GetVideoSourceConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfiguration * SOAP_FMAC4 soap_get__trt__GetVideoSourceConfiguration(struct soap *soap, struct _trt__GetVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioSourceConfigurationsResponse(struct soap *soap, struct _trt__GetAudioSourceConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeConfigurations = 0;
	a->Configurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioSourceConfigurationsResponse(struct soap *soap, const struct _trt__GetAudioSourceConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
		{
			soap_embedded(soap, a->Configurations + i, SOAP_TYPE_tt__AudioSourceConfiguration);
			soap_serialize_tt__AudioSourceConfiguration(soap, a->Configurations + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioSourceConfigurationsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioSourceConfigurationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeConfigurations");
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
			if (soap_out_tt__AudioSourceConfiguration(soap, "trt:Configurations", -1, a->Configurations + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurationsResponse * SOAP_FMAC4 soap_in__trt__GetAudioSourceConfigurationsResponse(struct soap *soap, const char *tag, struct _trt__GetAudioSourceConfigurationsResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Configurations = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioSourceConfigurationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse, sizeof(struct _trt__GetAudioSourceConfigurationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioSourceConfigurationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Configurations", 1, NULL))
			{	if (a->Configurations == NULL)
				{	if (soap_blist_Configurations == NULL)
						soap_blist_Configurations = soap_new_block(soap);
					a->Configurations = (struct tt__AudioSourceConfiguration *)soap_push_block(soap, soap_blist_Configurations, sizeof(struct tt__AudioSourceConfiguration));
					if (a->Configurations == NULL)
						return NULL;
					soap_default_tt__AudioSourceConfiguration(soap, a->Configurations);
				}soap_revert(soap);
				if (soap_in_tt__AudioSourceConfiguration(soap, "trt:Configurations", a->Configurations, "tt:AudioSourceConfiguration"))
				{	a->__sizeConfigurations++;
					a->Configurations = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeConfigurations");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Configurations)
			soap_pop_block(soap, soap_blist_Configurations);
		if (a->__sizeConfigurations)
			a->Configurations = (struct tt__AudioSourceConfiguration *)soap_save_block(soap, soap_blist_Configurations, NULL, 1);
		else
		{	a->Configurations = NULL;
			if (soap_blist_Configurations)
				soap_end_block(soap, soap_blist_Configurations);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioSourceConfigurationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse, 0, sizeof(struct _trt__GetAudioSourceConfigurationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioSourceConfigurationsResponse(struct soap *soap, const struct _trt__GetAudioSourceConfigurationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse);
	if (soap_out__trt__GetAudioSourceConfigurationsResponse(soap, tag?tag:"trt:GetAudioSourceConfigurationsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurationsResponse * SOAP_FMAC4 soap_get__trt__GetAudioSourceConfigurationsResponse(struct soap *soap, struct _trt__GetAudioSourceConfigurationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioSourceConfigurationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioSourceConfigurations(struct soap *soap, struct _trt__GetAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioSourceConfigurations(struct soap *soap, const struct _trt__GetAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioSourceConfigurations(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioSourceConfigurations *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioSourceConfigurations), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurations * SOAP_FMAC4 soap_in__trt__GetAudioSourceConfigurations(struct soap *soap, const char *tag, struct _trt__GetAudioSourceConfigurations *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioSourceConfigurations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioSourceConfigurations, sizeof(struct _trt__GetAudioSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioSourceConfigurations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioSourceConfigurations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioSourceConfigurations, 0, sizeof(struct _trt__GetAudioSourceConfigurations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioSourceConfigurations(struct soap *soap, const struct _trt__GetAudioSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioSourceConfigurations);
	if (soap_out__trt__GetAudioSourceConfigurations(soap, tag?tag:"trt:GetAudioSourceConfigurations", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioSourceConfigurations * SOAP_FMAC4 soap_get__trt__GetAudioSourceConfigurations(struct soap *soap, struct _trt__GetAudioSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioEncoderConfigurationsResponse(struct soap *soap, struct _trt__GetAudioEncoderConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeConfigurations = 0;
	a->Configurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioEncoderConfigurationsResponse(struct soap *soap, const struct _trt__GetAudioEncoderConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
		{
			soap_embedded(soap, a->Configurations + i, SOAP_TYPE_tt__AudioEncoderConfiguration);
			soap_serialize_tt__AudioEncoderConfiguration(soap, a->Configurations + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioEncoderConfigurationsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioEncoderConfigurationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeConfigurations");
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
			if (soap_out_tt__AudioEncoderConfiguration(soap, "trt:Configurations", -1, a->Configurations + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurationsResponse * SOAP_FMAC4 soap_in__trt__GetAudioEncoderConfigurationsResponse(struct soap *soap, const char *tag, struct _trt__GetAudioEncoderConfigurationsResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Configurations = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioEncoderConfigurationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse, sizeof(struct _trt__GetAudioEncoderConfigurationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioEncoderConfigurationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Configurations", 1, NULL))
			{	if (a->Configurations == NULL)
				{	if (soap_blist_Configurations == NULL)
						soap_blist_Configurations = soap_new_block(soap);
					a->Configurations = (struct tt__AudioEncoderConfiguration *)soap_push_block(soap, soap_blist_Configurations, sizeof(struct tt__AudioEncoderConfiguration));
					if (a->Configurations == NULL)
						return NULL;
					soap_default_tt__AudioEncoderConfiguration(soap, a->Configurations);
				}soap_revert(soap);
				if (soap_in_tt__AudioEncoderConfiguration(soap, "trt:Configurations", a->Configurations, "tt:AudioEncoderConfiguration"))
				{	a->__sizeConfigurations++;
					a->Configurations = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeConfigurations");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Configurations)
			soap_pop_block(soap, soap_blist_Configurations);
		if (a->__sizeConfigurations)
			a->Configurations = (struct tt__AudioEncoderConfiguration *)soap_save_block(soap, soap_blist_Configurations, NULL, 1);
		else
		{	a->Configurations = NULL;
			if (soap_blist_Configurations)
				soap_end_block(soap, soap_blist_Configurations);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioEncoderConfigurationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse, 0, sizeof(struct _trt__GetAudioEncoderConfigurationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioEncoderConfigurationsResponse(struct soap *soap, const struct _trt__GetAudioEncoderConfigurationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse);
	if (soap_out__trt__GetAudioEncoderConfigurationsResponse(soap, tag?tag:"trt:GetAudioEncoderConfigurationsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurationsResponse * SOAP_FMAC4 soap_get__trt__GetAudioEncoderConfigurationsResponse(struct soap *soap, struct _trt__GetAudioEncoderConfigurationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioEncoderConfigurationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioEncoderConfigurations(struct soap *soap, struct _trt__GetAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioEncoderConfigurations(struct soap *soap, const struct _trt__GetAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioEncoderConfigurations *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurations), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurations * SOAP_FMAC4 soap_in__trt__GetAudioEncoderConfigurations(struct soap *soap, const char *tag, struct _trt__GetAudioEncoderConfigurations *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioEncoderConfigurations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioEncoderConfigurations, sizeof(struct _trt__GetAudioEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioEncoderConfigurations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioEncoderConfigurations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioEncoderConfigurations, 0, sizeof(struct _trt__GetAudioEncoderConfigurations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioEncoderConfigurations(struct soap *soap, const struct _trt__GetAudioEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioEncoderConfigurations);
	if (soap_out__trt__GetAudioEncoderConfigurations(soap, tag?tag:"trt:GetAudioEncoderConfigurations", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioEncoderConfigurations * SOAP_FMAC4 soap_get__trt__GetAudioEncoderConfigurations(struct soap *soap, struct _trt__GetAudioEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoSourceConfigurationsResponse(struct soap *soap, struct _trt__GetVideoSourceConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeConfigurations = 0;
	a->Configurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoSourceConfigurationsResponse(struct soap *soap, const struct _trt__GetVideoSourceConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
		{
			soap_embedded(soap, a->Configurations + i, SOAP_TYPE_tt__VideoSourceConfiguration);
			soap_serialize_tt__VideoSourceConfiguration(soap, a->Configurations + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoSourceConfigurationsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoSourceConfigurationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeConfigurations");
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
			if (soap_out_tt__VideoSourceConfiguration(soap, "trt:Configurations", -1, a->Configurations + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurationsResponse * SOAP_FMAC4 soap_in__trt__GetVideoSourceConfigurationsResponse(struct soap *soap, const char *tag, struct _trt__GetVideoSourceConfigurationsResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Configurations = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoSourceConfigurationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse, sizeof(struct _trt__GetVideoSourceConfigurationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoSourceConfigurationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Configurations", 1, NULL))
			{	if (a->Configurations == NULL)
				{	if (soap_blist_Configurations == NULL)
						soap_blist_Configurations = soap_new_block(soap);
					a->Configurations = (struct tt__VideoSourceConfiguration *)soap_push_block(soap, soap_blist_Configurations, sizeof(struct tt__VideoSourceConfiguration));
					if (a->Configurations == NULL)
						return NULL;
					soap_default_tt__VideoSourceConfiguration(soap, a->Configurations);
				}soap_revert(soap);
				if (soap_in_tt__VideoSourceConfiguration(soap, "trt:Configurations", a->Configurations, "tt:VideoSourceConfiguration"))
				{	a->__sizeConfigurations++;
					a->Configurations = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeConfigurations");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Configurations)
			soap_pop_block(soap, soap_blist_Configurations);
		if (a->__sizeConfigurations)
			a->Configurations = (struct tt__VideoSourceConfiguration *)soap_save_block(soap, soap_blist_Configurations, NULL, 1);
		else
		{	a->Configurations = NULL;
			if (soap_blist_Configurations)
				soap_end_block(soap, soap_blist_Configurations);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoSourceConfigurationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse, 0, sizeof(struct _trt__GetVideoSourceConfigurationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoSourceConfigurationsResponse(struct soap *soap, const struct _trt__GetVideoSourceConfigurationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse);
	if (soap_out__trt__GetVideoSourceConfigurationsResponse(soap, tag?tag:"trt:GetVideoSourceConfigurationsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurationsResponse * SOAP_FMAC4 soap_get__trt__GetVideoSourceConfigurationsResponse(struct soap *soap, struct _trt__GetVideoSourceConfigurationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoSourceConfigurationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoSourceConfigurations(struct soap *soap, struct _trt__GetVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoSourceConfigurations(struct soap *soap, const struct _trt__GetVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoSourceConfigurations(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoSourceConfigurations *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoSourceConfigurations), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurations * SOAP_FMAC4 soap_in__trt__GetVideoSourceConfigurations(struct soap *soap, const char *tag, struct _trt__GetVideoSourceConfigurations *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoSourceConfigurations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoSourceConfigurations, sizeof(struct _trt__GetVideoSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoSourceConfigurations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoSourceConfigurations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoSourceConfigurations, 0, sizeof(struct _trt__GetVideoSourceConfigurations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoSourceConfigurations(struct soap *soap, const struct _trt__GetVideoSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoSourceConfigurations);
	if (soap_out__trt__GetVideoSourceConfigurations(soap, tag?tag:"trt:GetVideoSourceConfigurations", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoSourceConfigurations * SOAP_FMAC4 soap_get__trt__GetVideoSourceConfigurations(struct soap *soap, struct _trt__GetVideoSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoEncoderConfigurationsResponse(struct soap *soap, struct _trt__GetVideoEncoderConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeConfigurations = 0;
	a->Configurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoEncoderConfigurationsResponse(struct soap *soap, const struct _trt__GetVideoEncoderConfigurationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
		{
			soap_embedded(soap, a->Configurations + i, SOAP_TYPE_tt__VideoEncoderConfiguration);
			soap_serialize_tt__VideoEncoderConfiguration(soap, a->Configurations + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoEncoderConfigurationsResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoEncoderConfigurationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeConfigurations");
	if (a->Configurations)
	{	int i;
		for (i = 0; i < a->__sizeConfigurations; i++)
			if (soap_out_tt__VideoEncoderConfiguration(soap, "trt:Configurations", -1, a->Configurations + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurationsResponse * SOAP_FMAC4 soap_in__trt__GetVideoEncoderConfigurationsResponse(struct soap *soap, const char *tag, struct _trt__GetVideoEncoderConfigurationsResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Configurations = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoEncoderConfigurationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse, sizeof(struct _trt__GetVideoEncoderConfigurationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoEncoderConfigurationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Configurations", 1, NULL))
			{	if (a->Configurations == NULL)
				{	if (soap_blist_Configurations == NULL)
						soap_blist_Configurations = soap_new_block(soap);
					a->Configurations = (struct tt__VideoEncoderConfiguration *)soap_push_block(soap, soap_blist_Configurations, sizeof(struct tt__VideoEncoderConfiguration));
					if (a->Configurations == NULL)
						return NULL;
					soap_default_tt__VideoEncoderConfiguration(soap, a->Configurations);
				}soap_revert(soap);
				if (soap_in_tt__VideoEncoderConfiguration(soap, "trt:Configurations", a->Configurations, "tt:VideoEncoderConfiguration"))
				{	a->__sizeConfigurations++;
					a->Configurations = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeConfigurations");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Configurations)
			soap_pop_block(soap, soap_blist_Configurations);
		if (a->__sizeConfigurations)
			a->Configurations = (struct tt__VideoEncoderConfiguration *)soap_save_block(soap, soap_blist_Configurations, NULL, 1);
		else
		{	a->Configurations = NULL;
			if (soap_blist_Configurations)
				soap_end_block(soap, soap_blist_Configurations);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoEncoderConfigurationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse, 0, sizeof(struct _trt__GetVideoEncoderConfigurationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoEncoderConfigurationsResponse(struct soap *soap, const struct _trt__GetVideoEncoderConfigurationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse);
	if (soap_out__trt__GetVideoEncoderConfigurationsResponse(soap, tag?tag:"trt:GetVideoEncoderConfigurationsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurationsResponse * SOAP_FMAC4 soap_get__trt__GetVideoEncoderConfigurationsResponse(struct soap *soap, struct _trt__GetVideoEncoderConfigurationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoEncoderConfigurationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoEncoderConfigurations(struct soap *soap, struct _trt__GetVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoEncoderConfigurations(struct soap *soap, const struct _trt__GetVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoEncoderConfigurations *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurations), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurations * SOAP_FMAC4 soap_in__trt__GetVideoEncoderConfigurations(struct soap *soap, const char *tag, struct _trt__GetVideoEncoderConfigurations *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoEncoderConfigurations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoEncoderConfigurations, sizeof(struct _trt__GetVideoEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoEncoderConfigurations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoEncoderConfigurations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoEncoderConfigurations, 0, sizeof(struct _trt__GetVideoEncoderConfigurations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoEncoderConfigurations(struct soap *soap, const struct _trt__GetVideoEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoEncoderConfigurations);
	if (soap_out__trt__GetVideoEncoderConfigurations(soap, tag?tag:"trt:GetVideoEncoderConfigurations", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoEncoderConfigurations * SOAP_FMAC4 soap_get__trt__GetVideoEncoderConfigurations(struct soap *soap, struct _trt__GetVideoEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__DeleteProfileResponse(struct soap *soap, struct _trt__DeleteProfileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__DeleteProfileResponse(struct soap *soap, const struct _trt__DeleteProfileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__DeleteProfileResponse(struct soap *soap, const char *tag, int id, const struct _trt__DeleteProfileResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__DeleteProfileResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__DeleteProfileResponse * SOAP_FMAC4 soap_in__trt__DeleteProfileResponse(struct soap *soap, const char *tag, struct _trt__DeleteProfileResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__DeleteProfileResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__DeleteProfileResponse, sizeof(struct _trt__DeleteProfileResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__DeleteProfileResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__DeleteProfileResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__DeleteProfileResponse, 0, sizeof(struct _trt__DeleteProfileResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__DeleteProfileResponse(struct soap *soap, const struct _trt__DeleteProfileResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__DeleteProfileResponse);
	if (soap_out__trt__DeleteProfileResponse(soap, tag?tag:"trt:DeleteProfileResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__DeleteProfileResponse * SOAP_FMAC4 soap_get__trt__DeleteProfileResponse(struct soap *soap, struct _trt__DeleteProfileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__DeleteProfileResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__DeleteProfile(struct soap *soap, struct _trt__DeleteProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__DeleteProfile(struct soap *soap, const struct _trt__DeleteProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__DeleteProfile(struct soap *soap, const char *tag, int id, const struct _trt__DeleteProfile *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__DeleteProfile), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__DeleteProfile * SOAP_FMAC4 soap_in__trt__DeleteProfile(struct soap *soap, const char *tag, struct _trt__DeleteProfile *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__DeleteProfile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__DeleteProfile, sizeof(struct _trt__DeleteProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__DeleteProfile(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__DeleteProfile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__DeleteProfile, 0, sizeof(struct _trt__DeleteProfile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__DeleteProfile(struct soap *soap, const struct _trt__DeleteProfile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__DeleteProfile);
	if (soap_out__trt__DeleteProfile(soap, tag?tag:"trt:DeleteProfile", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__DeleteProfile * SOAP_FMAC4 soap_get__trt__DeleteProfile(struct soap *soap, struct _trt__DeleteProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__DeleteProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__RemoveAudioSourceConfigurationResponse(struct soap *soap, struct _trt__RemoveAudioSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__RemoveAudioSourceConfigurationResponse(struct soap *soap, const struct _trt__RemoveAudioSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__RemoveAudioSourceConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__RemoveAudioSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__RemoveAudioSourceConfigurationResponse * SOAP_FMAC4 soap_in__trt__RemoveAudioSourceConfigurationResponse(struct soap *soap, const char *tag, struct _trt__RemoveAudioSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__RemoveAudioSourceConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse, sizeof(struct _trt__RemoveAudioSourceConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__RemoveAudioSourceConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__RemoveAudioSourceConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse, 0, sizeof(struct _trt__RemoveAudioSourceConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__RemoveAudioSourceConfigurationResponse(struct soap *soap, const struct _trt__RemoveAudioSourceConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse);
	if (soap_out__trt__RemoveAudioSourceConfigurationResponse(soap, tag?tag:"trt:RemoveAudioSourceConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__RemoveAudioSourceConfigurationResponse * SOAP_FMAC4 soap_get__trt__RemoveAudioSourceConfigurationResponse(struct soap *soap, struct _trt__RemoveAudioSourceConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__RemoveAudioSourceConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__RemoveAudioSourceConfiguration(struct soap *soap, struct _trt__RemoveAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__RemoveAudioSourceConfiguration(struct soap *soap, const struct _trt__RemoveAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__RemoveAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__RemoveAudioSourceConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__RemoveAudioSourceConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__RemoveAudioSourceConfiguration * SOAP_FMAC4 soap_in__trt__RemoveAudioSourceConfiguration(struct soap *soap, const char *tag, struct _trt__RemoveAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__RemoveAudioSourceConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__RemoveAudioSourceConfiguration, sizeof(struct _trt__RemoveAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__RemoveAudioSourceConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__RemoveAudioSourceConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__RemoveAudioSourceConfiguration, 0, sizeof(struct _trt__RemoveAudioSourceConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__RemoveAudioSourceConfiguration(struct soap *soap, const struct _trt__RemoveAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__RemoveAudioSourceConfiguration);
	if (soap_out__trt__RemoveAudioSourceConfiguration(soap, tag?tag:"trt:RemoveAudioSourceConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__RemoveAudioSourceConfiguration * SOAP_FMAC4 soap_get__trt__RemoveAudioSourceConfiguration(struct soap *soap, struct _trt__RemoveAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__RemoveAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__AddAudioSourceConfigurationResponse(struct soap *soap, struct _trt__AddAudioSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__AddAudioSourceConfigurationResponse(struct soap *soap, const struct _trt__AddAudioSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__AddAudioSourceConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__AddAudioSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__AddAudioSourceConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__AddAudioSourceConfigurationResponse * SOAP_FMAC4 soap_in__trt__AddAudioSourceConfigurationResponse(struct soap *soap, const char *tag, struct _trt__AddAudioSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__AddAudioSourceConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__AddAudioSourceConfigurationResponse, sizeof(struct _trt__AddAudioSourceConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__AddAudioSourceConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__AddAudioSourceConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__AddAudioSourceConfigurationResponse, 0, sizeof(struct _trt__AddAudioSourceConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__AddAudioSourceConfigurationResponse(struct soap *soap, const struct _trt__AddAudioSourceConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__AddAudioSourceConfigurationResponse);
	if (soap_out__trt__AddAudioSourceConfigurationResponse(soap, tag?tag:"trt:AddAudioSourceConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__AddAudioSourceConfigurationResponse * SOAP_FMAC4 soap_get__trt__AddAudioSourceConfigurationResponse(struct soap *soap, struct _trt__AddAudioSourceConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__AddAudioSourceConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__AddAudioSourceConfiguration(struct soap *soap, struct _trt__AddAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__AddAudioSourceConfiguration(struct soap *soap, const struct _trt__AddAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__AddAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__AddAudioSourceConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__AddAudioSourceConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__AddAudioSourceConfiguration * SOAP_FMAC4 soap_in__trt__AddAudioSourceConfiguration(struct soap *soap, const char *tag, struct _trt__AddAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	size_t soap_flag_ConfigurationToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__AddAudioSourceConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__AddAudioSourceConfiguration, sizeof(struct _trt__AddAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__AddAudioSourceConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__AddAudioSourceConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__AddAudioSourceConfiguration, 0, sizeof(struct _trt__AddAudioSourceConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0 || soap_flag_ConfigurationToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__AddAudioSourceConfiguration(struct soap *soap, const struct _trt__AddAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__AddAudioSourceConfiguration);
	if (soap_out__trt__AddAudioSourceConfiguration(soap, tag?tag:"trt:AddAudioSourceConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__AddAudioSourceConfiguration * SOAP_FMAC4 soap_get__trt__AddAudioSourceConfiguration(struct soap *soap, struct _trt__AddAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__AddAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__RemoveAudioEncoderConfigurationResponse(struct soap *soap, struct _trt__RemoveAudioEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__RemoveAudioEncoderConfigurationResponse(struct soap *soap, const struct _trt__RemoveAudioEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__RemoveAudioEncoderConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__RemoveAudioEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__RemoveAudioEncoderConfigurationResponse * SOAP_FMAC4 soap_in__trt__RemoveAudioEncoderConfigurationResponse(struct soap *soap, const char *tag, struct _trt__RemoveAudioEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__RemoveAudioEncoderConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse, sizeof(struct _trt__RemoveAudioEncoderConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__RemoveAudioEncoderConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__RemoveAudioEncoderConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse, 0, sizeof(struct _trt__RemoveAudioEncoderConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__RemoveAudioEncoderConfigurationResponse(struct soap *soap, const struct _trt__RemoveAudioEncoderConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse);
	if (soap_out__trt__RemoveAudioEncoderConfigurationResponse(soap, tag?tag:"trt:RemoveAudioEncoderConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__RemoveAudioEncoderConfigurationResponse * SOAP_FMAC4 soap_get__trt__RemoveAudioEncoderConfigurationResponse(struct soap *soap, struct _trt__RemoveAudioEncoderConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__RemoveAudioEncoderConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__RemoveAudioEncoderConfiguration(struct soap *soap, struct _trt__RemoveAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__RemoveAudioEncoderConfiguration(struct soap *soap, const struct _trt__RemoveAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__RemoveAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__RemoveAudioEncoderConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__RemoveAudioEncoderConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__RemoveAudioEncoderConfiguration * SOAP_FMAC4 soap_in__trt__RemoveAudioEncoderConfiguration(struct soap *soap, const char *tag, struct _trt__RemoveAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__RemoveAudioEncoderConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__RemoveAudioEncoderConfiguration, sizeof(struct _trt__RemoveAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__RemoveAudioEncoderConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__RemoveAudioEncoderConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__RemoveAudioEncoderConfiguration, 0, sizeof(struct _trt__RemoveAudioEncoderConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__RemoveAudioEncoderConfiguration(struct soap *soap, const struct _trt__RemoveAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__RemoveAudioEncoderConfiguration);
	if (soap_out__trt__RemoveAudioEncoderConfiguration(soap, tag?tag:"trt:RemoveAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__RemoveAudioEncoderConfiguration * SOAP_FMAC4 soap_get__trt__RemoveAudioEncoderConfiguration(struct soap *soap, struct _trt__RemoveAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__RemoveAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__AddAudioEncoderConfigurationResponse(struct soap *soap, struct _trt__AddAudioEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__AddAudioEncoderConfigurationResponse(struct soap *soap, const struct _trt__AddAudioEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__AddAudioEncoderConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__AddAudioEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__AddAudioEncoderConfigurationResponse * SOAP_FMAC4 soap_in__trt__AddAudioEncoderConfigurationResponse(struct soap *soap, const char *tag, struct _trt__AddAudioEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__AddAudioEncoderConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse, sizeof(struct _trt__AddAudioEncoderConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__AddAudioEncoderConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__AddAudioEncoderConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse, 0, sizeof(struct _trt__AddAudioEncoderConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__AddAudioEncoderConfigurationResponse(struct soap *soap, const struct _trt__AddAudioEncoderConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse);
	if (soap_out__trt__AddAudioEncoderConfigurationResponse(soap, tag?tag:"trt:AddAudioEncoderConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__AddAudioEncoderConfigurationResponse * SOAP_FMAC4 soap_get__trt__AddAudioEncoderConfigurationResponse(struct soap *soap, struct _trt__AddAudioEncoderConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__AddAudioEncoderConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__AddAudioEncoderConfiguration(struct soap *soap, struct _trt__AddAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__AddAudioEncoderConfiguration(struct soap *soap, const struct _trt__AddAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__AddAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__AddAudioEncoderConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__AddAudioEncoderConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__AddAudioEncoderConfiguration * SOAP_FMAC4 soap_in__trt__AddAudioEncoderConfiguration(struct soap *soap, const char *tag, struct _trt__AddAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	size_t soap_flag_ConfigurationToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__AddAudioEncoderConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__AddAudioEncoderConfiguration, sizeof(struct _trt__AddAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__AddAudioEncoderConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__AddAudioEncoderConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__AddAudioEncoderConfiguration, 0, sizeof(struct _trt__AddAudioEncoderConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0 || soap_flag_ConfigurationToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__AddAudioEncoderConfiguration(struct soap *soap, const struct _trt__AddAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__AddAudioEncoderConfiguration);
	if (soap_out__trt__AddAudioEncoderConfiguration(soap, tag?tag:"trt:AddAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__AddAudioEncoderConfiguration * SOAP_FMAC4 soap_get__trt__AddAudioEncoderConfiguration(struct soap *soap, struct _trt__AddAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__AddAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__RemoveVideoSourceConfigurationResponse(struct soap *soap, struct _trt__RemoveVideoSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__RemoveVideoSourceConfigurationResponse(struct soap *soap, const struct _trt__RemoveVideoSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__RemoveVideoSourceConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__RemoveVideoSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__RemoveVideoSourceConfigurationResponse * SOAP_FMAC4 soap_in__trt__RemoveVideoSourceConfigurationResponse(struct soap *soap, const char *tag, struct _trt__RemoveVideoSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__RemoveVideoSourceConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse, sizeof(struct _trt__RemoveVideoSourceConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__RemoveVideoSourceConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__RemoveVideoSourceConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse, 0, sizeof(struct _trt__RemoveVideoSourceConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__RemoveVideoSourceConfigurationResponse(struct soap *soap, const struct _trt__RemoveVideoSourceConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse);
	if (soap_out__trt__RemoveVideoSourceConfigurationResponse(soap, tag?tag:"trt:RemoveVideoSourceConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__RemoveVideoSourceConfigurationResponse * SOAP_FMAC4 soap_get__trt__RemoveVideoSourceConfigurationResponse(struct soap *soap, struct _trt__RemoveVideoSourceConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__RemoveVideoSourceConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__RemoveVideoSourceConfiguration(struct soap *soap, struct _trt__RemoveVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__RemoveVideoSourceConfiguration(struct soap *soap, const struct _trt__RemoveVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__RemoveVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__RemoveVideoSourceConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__RemoveVideoSourceConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__RemoveVideoSourceConfiguration * SOAP_FMAC4 soap_in__trt__RemoveVideoSourceConfiguration(struct soap *soap, const char *tag, struct _trt__RemoveVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__RemoveVideoSourceConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__RemoveVideoSourceConfiguration, sizeof(struct _trt__RemoveVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__RemoveVideoSourceConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__RemoveVideoSourceConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__RemoveVideoSourceConfiguration, 0, sizeof(struct _trt__RemoveVideoSourceConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__RemoveVideoSourceConfiguration(struct soap *soap, const struct _trt__RemoveVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__RemoveVideoSourceConfiguration);
	if (soap_out__trt__RemoveVideoSourceConfiguration(soap, tag?tag:"trt:RemoveVideoSourceConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__RemoveVideoSourceConfiguration * SOAP_FMAC4 soap_get__trt__RemoveVideoSourceConfiguration(struct soap *soap, struct _trt__RemoveVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__RemoveVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__AddVideoSourceConfigurationResponse(struct soap *soap, struct _trt__AddVideoSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__AddVideoSourceConfigurationResponse(struct soap *soap, const struct _trt__AddVideoSourceConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__AddVideoSourceConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__AddVideoSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__AddVideoSourceConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__AddVideoSourceConfigurationResponse * SOAP_FMAC4 soap_in__trt__AddVideoSourceConfigurationResponse(struct soap *soap, const char *tag, struct _trt__AddVideoSourceConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__AddVideoSourceConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__AddVideoSourceConfigurationResponse, sizeof(struct _trt__AddVideoSourceConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__AddVideoSourceConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__AddVideoSourceConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__AddVideoSourceConfigurationResponse, 0, sizeof(struct _trt__AddVideoSourceConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__AddVideoSourceConfigurationResponse(struct soap *soap, const struct _trt__AddVideoSourceConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__AddVideoSourceConfigurationResponse);
	if (soap_out__trt__AddVideoSourceConfigurationResponse(soap, tag?tag:"trt:AddVideoSourceConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__AddVideoSourceConfigurationResponse * SOAP_FMAC4 soap_get__trt__AddVideoSourceConfigurationResponse(struct soap *soap, struct _trt__AddVideoSourceConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__AddVideoSourceConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__AddVideoSourceConfiguration(struct soap *soap, struct _trt__AddVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__AddVideoSourceConfiguration(struct soap *soap, const struct _trt__AddVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__AddVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__AddVideoSourceConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__AddVideoSourceConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__AddVideoSourceConfiguration * SOAP_FMAC4 soap_in__trt__AddVideoSourceConfiguration(struct soap *soap, const char *tag, struct _trt__AddVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	size_t soap_flag_ConfigurationToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__AddVideoSourceConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__AddVideoSourceConfiguration, sizeof(struct _trt__AddVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__AddVideoSourceConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__AddVideoSourceConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__AddVideoSourceConfiguration, 0, sizeof(struct _trt__AddVideoSourceConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0 || soap_flag_ConfigurationToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__AddVideoSourceConfiguration(struct soap *soap, const struct _trt__AddVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__AddVideoSourceConfiguration);
	if (soap_out__trt__AddVideoSourceConfiguration(soap, tag?tag:"trt:AddVideoSourceConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__AddVideoSourceConfiguration * SOAP_FMAC4 soap_get__trt__AddVideoSourceConfiguration(struct soap *soap, struct _trt__AddVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__AddVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__RemoveVideoEncoderConfigurationResponse(struct soap *soap, struct _trt__RemoveVideoEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__RemoveVideoEncoderConfigurationResponse(struct soap *soap, const struct _trt__RemoveVideoEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__RemoveVideoEncoderConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__RemoveVideoEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__RemoveVideoEncoderConfigurationResponse * SOAP_FMAC4 soap_in__trt__RemoveVideoEncoderConfigurationResponse(struct soap *soap, const char *tag, struct _trt__RemoveVideoEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__RemoveVideoEncoderConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse, sizeof(struct _trt__RemoveVideoEncoderConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__RemoveVideoEncoderConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__RemoveVideoEncoderConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse, 0, sizeof(struct _trt__RemoveVideoEncoderConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__RemoveVideoEncoderConfigurationResponse(struct soap *soap, const struct _trt__RemoveVideoEncoderConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse);
	if (soap_out__trt__RemoveVideoEncoderConfigurationResponse(soap, tag?tag:"trt:RemoveVideoEncoderConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__RemoveVideoEncoderConfigurationResponse * SOAP_FMAC4 soap_get__trt__RemoveVideoEncoderConfigurationResponse(struct soap *soap, struct _trt__RemoveVideoEncoderConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__RemoveVideoEncoderConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__RemoveVideoEncoderConfiguration(struct soap *soap, struct _trt__RemoveVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__RemoveVideoEncoderConfiguration(struct soap *soap, const struct _trt__RemoveVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__RemoveVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__RemoveVideoEncoderConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__RemoveVideoEncoderConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__RemoveVideoEncoderConfiguration * SOAP_FMAC4 soap_in__trt__RemoveVideoEncoderConfiguration(struct soap *soap, const char *tag, struct _trt__RemoveVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__RemoveVideoEncoderConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__RemoveVideoEncoderConfiguration, sizeof(struct _trt__RemoveVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__RemoveVideoEncoderConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__RemoveVideoEncoderConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__RemoveVideoEncoderConfiguration, 0, sizeof(struct _trt__RemoveVideoEncoderConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__RemoveVideoEncoderConfiguration(struct soap *soap, const struct _trt__RemoveVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__RemoveVideoEncoderConfiguration);
	if (soap_out__trt__RemoveVideoEncoderConfiguration(soap, tag?tag:"trt:RemoveVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__RemoveVideoEncoderConfiguration * SOAP_FMAC4 soap_get__trt__RemoveVideoEncoderConfiguration(struct soap *soap, struct _trt__RemoveVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__RemoveVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__AddVideoEncoderConfigurationResponse(struct soap *soap, struct _trt__AddVideoEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__AddVideoEncoderConfigurationResponse(struct soap *soap, const struct _trt__AddVideoEncoderConfigurationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__AddVideoEncoderConfigurationResponse(struct soap *soap, const char *tag, int id, const struct _trt__AddVideoEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__AddVideoEncoderConfigurationResponse * SOAP_FMAC4 soap_in__trt__AddVideoEncoderConfigurationResponse(struct soap *soap, const char *tag, struct _trt__AddVideoEncoderConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__AddVideoEncoderConfigurationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse, sizeof(struct _trt__AddVideoEncoderConfigurationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__AddVideoEncoderConfigurationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__AddVideoEncoderConfigurationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse, 0, sizeof(struct _trt__AddVideoEncoderConfigurationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__AddVideoEncoderConfigurationResponse(struct soap *soap, const struct _trt__AddVideoEncoderConfigurationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse);
	if (soap_out__trt__AddVideoEncoderConfigurationResponse(soap, tag?tag:"trt:AddVideoEncoderConfigurationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__AddVideoEncoderConfigurationResponse * SOAP_FMAC4 soap_get__trt__AddVideoEncoderConfigurationResponse(struct soap *soap, struct _trt__AddVideoEncoderConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__AddVideoEncoderConfigurationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__AddVideoEncoderConfiguration(struct soap *soap, struct _trt__AddVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
	soap_default_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__AddVideoEncoderConfiguration(struct soap *soap, const struct _trt__AddVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
	soap_serialize_tt__ReferenceToken(soap, &a->ConfigurationToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__AddVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct _trt__AddVideoEncoderConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__AddVideoEncoderConfiguration), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ConfigurationToken", -1, &a->ConfigurationToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__AddVideoEncoderConfiguration * SOAP_FMAC4 soap_in__trt__AddVideoEncoderConfiguration(struct soap *soap, const char *tag, struct _trt__AddVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	size_t soap_flag_ConfigurationToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__AddVideoEncoderConfiguration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__AddVideoEncoderConfiguration, sizeof(struct _trt__AddVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__AddVideoEncoderConfiguration(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap_flag_ConfigurationToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ConfigurationToken", &a->ConfigurationToken, "tt:ReferenceToken"))
				{	soap_flag_ConfigurationToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__AddVideoEncoderConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__AddVideoEncoderConfiguration, 0, sizeof(struct _trt__AddVideoEncoderConfiguration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0 || soap_flag_ConfigurationToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__AddVideoEncoderConfiguration(struct soap *soap, const struct _trt__AddVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__AddVideoEncoderConfiguration);
	if (soap_out__trt__AddVideoEncoderConfiguration(soap, tag?tag:"trt:AddVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__AddVideoEncoderConfiguration * SOAP_FMAC4 soap_get__trt__AddVideoEncoderConfiguration(struct soap *soap, struct _trt__AddVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__AddVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetProfilesResponse(struct soap *soap, struct _trt__GetProfilesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeProfiles = 0;
	a->Profiles = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetProfilesResponse(struct soap *soap, const struct _trt__GetProfilesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Profiles)
	{	int i;
		for (i = 0; i < a->__sizeProfiles; i++)
		{
			soap_embedded(soap, a->Profiles + i, SOAP_TYPE_tt__Profile);
			soap_serialize_tt__Profile(soap, a->Profiles + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetProfilesResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetProfilesResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetProfilesResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeProfiles");
	if (a->Profiles)
	{	int i;
		for (i = 0; i < a->__sizeProfiles; i++)
			if (soap_out_tt__Profile(soap, "trt:Profiles", -1, a->Profiles + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetProfilesResponse * SOAP_FMAC4 soap_in__trt__GetProfilesResponse(struct soap *soap, const char *tag, struct _trt__GetProfilesResponse *a, const char *type)
{
	struct soap_blist *soap_blist_Profiles = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetProfilesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetProfilesResponse, sizeof(struct _trt__GetProfilesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetProfilesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:Profiles", 1, NULL))
			{	if (a->Profiles == NULL)
				{	if (soap_blist_Profiles == NULL)
						soap_blist_Profiles = soap_new_block(soap);
					a->Profiles = (struct tt__Profile *)soap_push_block(soap, soap_blist_Profiles, sizeof(struct tt__Profile));
					if (a->Profiles == NULL)
						return NULL;
					soap_default_tt__Profile(soap, a->Profiles);
				}soap_revert(soap);
				if (soap_in_tt__Profile(soap, "trt:Profiles", a->Profiles, "tt:Profile"))
				{	a->__sizeProfiles++;
					a->Profiles = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeProfiles");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Profiles)
			soap_pop_block(soap, soap_blist_Profiles);
		if (a->__sizeProfiles)
			a->Profiles = (struct tt__Profile *)soap_save_block(soap, soap_blist_Profiles, NULL, 1);
		else
		{	a->Profiles = NULL;
			if (soap_blist_Profiles)
				soap_end_block(soap, soap_blist_Profiles);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetProfilesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetProfilesResponse, 0, sizeof(struct _trt__GetProfilesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetProfilesResponse(struct soap *soap, const struct _trt__GetProfilesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetProfilesResponse);
	if (soap_out__trt__GetProfilesResponse(soap, tag?tag:"trt:GetProfilesResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetProfilesResponse * SOAP_FMAC4 soap_get__trt__GetProfilesResponse(struct soap *soap, struct _trt__GetProfilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetProfilesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetProfiles(struct soap *soap, struct _trt__GetProfiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetProfiles(struct soap *soap, const struct _trt__GetProfiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetProfiles(struct soap *soap, const char *tag, int id, const struct _trt__GetProfiles *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetProfiles), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetProfiles * SOAP_FMAC4 soap_in__trt__GetProfiles(struct soap *soap, const char *tag, struct _trt__GetProfiles *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetProfiles *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetProfiles, sizeof(struct _trt__GetProfiles), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetProfiles(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetProfiles *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetProfiles, 0, sizeof(struct _trt__GetProfiles), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetProfiles(struct soap *soap, const struct _trt__GetProfiles *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetProfiles);
	if (soap_out__trt__GetProfiles(soap, tag?tag:"trt:GetProfiles", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetProfiles * SOAP_FMAC4 soap_get__trt__GetProfiles(struct soap *soap, struct _trt__GetProfiles *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetProfiles(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetProfileResponse(struct soap *soap, struct _trt__GetProfileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Profile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetProfileResponse(struct soap *soap, const struct _trt__GetProfileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__Profile(soap, &a->Profile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetProfileResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetProfileResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetProfileResponse), type))
		return soap->error;
	if (a->Profile)
		soap_element_result(soap, "trt:Profile");
	if (soap_out_PointerTott__Profile(soap, "trt:Profile", -1, &a->Profile, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetProfileResponse * SOAP_FMAC4 soap_in__trt__GetProfileResponse(struct soap *soap, const char *tag, struct _trt__GetProfileResponse *a, const char *type)
{
	size_t soap_flag_Profile = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetProfileResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetProfileResponse, sizeof(struct _trt__GetProfileResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetProfileResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Profile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__Profile(soap, "trt:Profile", &a->Profile, "tt:Profile"))
				{	soap_flag_Profile--;
					continue;
				}
			soap_check_result(soap, "trt:Profile");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetProfileResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetProfileResponse, 0, sizeof(struct _trt__GetProfileResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Profile > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetProfileResponse(struct soap *soap, const struct _trt__GetProfileResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetProfileResponse);
	if (soap_out__trt__GetProfileResponse(soap, tag?tag:"trt:GetProfileResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetProfileResponse * SOAP_FMAC4 soap_get__trt__GetProfileResponse(struct soap *soap, struct _trt__GetProfileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetProfileResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetProfile(struct soap *soap, struct _trt__GetProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetProfile(struct soap *soap, const struct _trt__GetProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__ReferenceToken(soap, &a->ProfileToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetProfile(struct soap *soap, const char *tag, int id, const struct _trt__GetProfile *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetProfile), type))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:ProfileToken", -1, &a->ProfileToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetProfile * SOAP_FMAC4 soap_in__trt__GetProfile(struct soap *soap, const char *tag, struct _trt__GetProfile *a, const char *type)
{
	size_t soap_flag_ProfileToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetProfile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetProfile, sizeof(struct _trt__GetProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetProfile(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileToken && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:ProfileToken", &a->ProfileToken, "tt:ReferenceToken"))
				{	soap_flag_ProfileToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetProfile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetProfile, 0, sizeof(struct _trt__GetProfile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileToken > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetProfile(struct soap *soap, const struct _trt__GetProfile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetProfile);
	if (soap_out__trt__GetProfile(soap, tag?tag:"trt:GetProfile", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetProfile * SOAP_FMAC4 soap_get__trt__GetProfile(struct soap *soap, struct _trt__GetProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__CreateProfileResponse(struct soap *soap, struct _trt__CreateProfileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Profile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__CreateProfileResponse(struct soap *soap, const struct _trt__CreateProfileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTott__Profile(soap, &a->Profile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__CreateProfileResponse(struct soap *soap, const char *tag, int id, const struct _trt__CreateProfileResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__CreateProfileResponse), type))
		return soap->error;
	if (a->Profile)
		soap_element_result(soap, "trt:Profile");
	if (soap_out_PointerTott__Profile(soap, "trt:Profile", -1, &a->Profile, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__CreateProfileResponse * SOAP_FMAC4 soap_in__trt__CreateProfileResponse(struct soap *soap, const char *tag, struct _trt__CreateProfileResponse *a, const char *type)
{
	size_t soap_flag_Profile = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__CreateProfileResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__CreateProfileResponse, sizeof(struct _trt__CreateProfileResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__CreateProfileResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Profile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__Profile(soap, "trt:Profile", &a->Profile, "tt:Profile"))
				{	soap_flag_Profile--;
					continue;
				}
			soap_check_result(soap, "trt:Profile");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__CreateProfileResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__CreateProfileResponse, 0, sizeof(struct _trt__CreateProfileResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Profile > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__CreateProfileResponse(struct soap *soap, const struct _trt__CreateProfileResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__CreateProfileResponse);
	if (soap_out__trt__CreateProfileResponse(soap, tag?tag:"trt:CreateProfileResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__CreateProfileResponse * SOAP_FMAC4 soap_get__trt__CreateProfileResponse(struct soap *soap, struct _trt__CreateProfileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__CreateProfileResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__CreateProfile(struct soap *soap, struct _trt__CreateProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__Name(soap, &a->Name);
	soap_default_tt__ReferenceToken(soap, &a->Token);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__CreateProfile(struct soap *soap, const struct _trt__CreateProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_tt__Name(soap, &a->Name);
	soap_serialize_tt__ReferenceToken(soap, &a->Token);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__CreateProfile(struct soap *soap, const char *tag, int id, const struct _trt__CreateProfile *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__CreateProfile), type))
		return soap->error;
	if (soap_out_tt__Name(soap, "trt:Name", -1, &a->Name, ""))
		return soap->error;
	if (soap_out_tt__ReferenceToken(soap, "trt:Token", -1, &a->Token, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__CreateProfile * SOAP_FMAC4 soap_in__trt__CreateProfile(struct soap *soap, const char *tag, struct _trt__CreateProfile *a, const char *type)
{
	size_t soap_flag_Name = 1;
	size_t soap_flag_Token = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__CreateProfile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__CreateProfile, sizeof(struct _trt__CreateProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__CreateProfile(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__Name(soap, "trt:Name", &a->Name, "tt:Name"))
				{	soap_flag_Name--;
					continue;
				}
			if (soap_flag_Token && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_tt__ReferenceToken(soap, "trt:Token", &a->Token, "tt:ReferenceToken"))
				{	soap_flag_Token--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__CreateProfile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__CreateProfile, 0, sizeof(struct _trt__CreateProfile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Name > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__CreateProfile(struct soap *soap, const struct _trt__CreateProfile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__CreateProfile);
	if (soap_out__trt__CreateProfile(soap, tag?tag:"trt:CreateProfile", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__CreateProfile * SOAP_FMAC4 soap_get__trt__CreateProfile(struct soap *soap, struct _trt__CreateProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__CreateProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioSourcesResponse(struct soap *soap, struct _trt__GetAudioSourcesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeAudioSources = 0;
	a->AudioSources = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioSourcesResponse(struct soap *soap, const struct _trt__GetAudioSourcesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->AudioSources)
	{	int i;
		for (i = 0; i < a->__sizeAudioSources; i++)
		{
			soap_embedded(soap, a->AudioSources + i, SOAP_TYPE_tt__AudioSource);
			soap_serialize_tt__AudioSource(soap, a->AudioSources + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioSourcesResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioSourcesResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioSourcesResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeAudioSources");
	if (a->AudioSources)
	{	int i;
		for (i = 0; i < a->__sizeAudioSources; i++)
			if (soap_out_tt__AudioSource(soap, "trt:AudioSources", -1, a->AudioSources + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioSourcesResponse * SOAP_FMAC4 soap_in__trt__GetAudioSourcesResponse(struct soap *soap, const char *tag, struct _trt__GetAudioSourcesResponse *a, const char *type)
{
	struct soap_blist *soap_blist_AudioSources = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioSourcesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioSourcesResponse, sizeof(struct _trt__GetAudioSourcesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioSourcesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:AudioSources", 1, NULL))
			{	if (a->AudioSources == NULL)
				{	if (soap_blist_AudioSources == NULL)
						soap_blist_AudioSources = soap_new_block(soap);
					a->AudioSources = (struct tt__AudioSource *)soap_push_block(soap, soap_blist_AudioSources, sizeof(struct tt__AudioSource));
					if (a->AudioSources == NULL)
						return NULL;
					soap_default_tt__AudioSource(soap, a->AudioSources);
				}soap_revert(soap);
				if (soap_in_tt__AudioSource(soap, "trt:AudioSources", a->AudioSources, "tt:AudioSource"))
				{	a->__sizeAudioSources++;
					a->AudioSources = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeAudioSources");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->AudioSources)
			soap_pop_block(soap, soap_blist_AudioSources);
		if (a->__sizeAudioSources)
			a->AudioSources = (struct tt__AudioSource *)soap_save_block(soap, soap_blist_AudioSources, NULL, 1);
		else
		{	a->AudioSources = NULL;
			if (soap_blist_AudioSources)
				soap_end_block(soap, soap_blist_AudioSources);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioSourcesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioSourcesResponse, 0, sizeof(struct _trt__GetAudioSourcesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioSourcesResponse(struct soap *soap, const struct _trt__GetAudioSourcesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioSourcesResponse);
	if (soap_out__trt__GetAudioSourcesResponse(soap, tag?tag:"trt:GetAudioSourcesResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioSourcesResponse * SOAP_FMAC4 soap_get__trt__GetAudioSourcesResponse(struct soap *soap, struct _trt__GetAudioSourcesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioSourcesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetAudioSources(struct soap *soap, struct _trt__GetAudioSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetAudioSources(struct soap *soap, const struct _trt__GetAudioSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetAudioSources(struct soap *soap, const char *tag, int id, const struct _trt__GetAudioSources *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetAudioSources), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetAudioSources * SOAP_FMAC4 soap_in__trt__GetAudioSources(struct soap *soap, const char *tag, struct _trt__GetAudioSources *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetAudioSources *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetAudioSources, sizeof(struct _trt__GetAudioSources), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetAudioSources(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetAudioSources *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetAudioSources, 0, sizeof(struct _trt__GetAudioSources), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetAudioSources(struct soap *soap, const struct _trt__GetAudioSources *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetAudioSources);
	if (soap_out__trt__GetAudioSources(soap, tag?tag:"trt:GetAudioSources", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetAudioSources * SOAP_FMAC4 soap_get__trt__GetAudioSources(struct soap *soap, struct _trt__GetAudioSources *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetAudioSources(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoSourcesResponse(struct soap *soap, struct _trt__GetVideoSourcesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeVideoSources = 0;
	a->VideoSources = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoSourcesResponse(struct soap *soap, const struct _trt__GetVideoSourcesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->VideoSources)
	{	int i;
		for (i = 0; i < a->__sizeVideoSources; i++)
		{
			soap_embedded(soap, a->VideoSources + i, SOAP_TYPE_tt__VideoSource);
			soap_serialize_tt__VideoSource(soap, a->VideoSources + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoSourcesResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoSourcesResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoSourcesResponse), type))
		return soap->error;
	soap_element_result(soap, "-sizeVideoSources");
	if (a->VideoSources)
	{	int i;
		for (i = 0; i < a->__sizeVideoSources; i++)
			if (soap_out_tt__VideoSource(soap, "trt:VideoSources", -1, a->VideoSources + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoSourcesResponse * SOAP_FMAC4 soap_in__trt__GetVideoSourcesResponse(struct soap *soap, const char *tag, struct _trt__GetVideoSourcesResponse *a, const char *type)
{
	struct soap_blist *soap_blist_VideoSources = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoSourcesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoSourcesResponse, sizeof(struct _trt__GetVideoSourcesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoSourcesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "trt:VideoSources", 1, NULL))
			{	if (a->VideoSources == NULL)
				{	if (soap_blist_VideoSources == NULL)
						soap_blist_VideoSources = soap_new_block(soap);
					a->VideoSources = (struct tt__VideoSource *)soap_push_block(soap, soap_blist_VideoSources, sizeof(struct tt__VideoSource));
					if (a->VideoSources == NULL)
						return NULL;
					soap_default_tt__VideoSource(soap, a->VideoSources);
				}soap_revert(soap);
				if (soap_in_tt__VideoSource(soap, "trt:VideoSources", a->VideoSources, "tt:VideoSource"))
				{	a->__sizeVideoSources++;
					a->VideoSources = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeVideoSources");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->VideoSources)
			soap_pop_block(soap, soap_blist_VideoSources);
		if (a->__sizeVideoSources)
			a->VideoSources = (struct tt__VideoSource *)soap_save_block(soap, soap_blist_VideoSources, NULL, 1);
		else
		{	a->VideoSources = NULL;
			if (soap_blist_VideoSources)
				soap_end_block(soap, soap_blist_VideoSources);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoSourcesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoSourcesResponse, 0, sizeof(struct _trt__GetVideoSourcesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoSourcesResponse(struct soap *soap, const struct _trt__GetVideoSourcesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoSourcesResponse);
	if (soap_out__trt__GetVideoSourcesResponse(soap, tag?tag:"trt:GetVideoSourcesResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoSourcesResponse * SOAP_FMAC4 soap_get__trt__GetVideoSourcesResponse(struct soap *soap, struct _trt__GetVideoSourcesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoSourcesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetVideoSources(struct soap *soap, struct _trt__GetVideoSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetVideoSources(struct soap *soap, const struct _trt__GetVideoSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetVideoSources(struct soap *soap, const char *tag, int id, const struct _trt__GetVideoSources *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetVideoSources), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetVideoSources * SOAP_FMAC4 soap_in__trt__GetVideoSources(struct soap *soap, const char *tag, struct _trt__GetVideoSources *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetVideoSources *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetVideoSources, sizeof(struct _trt__GetVideoSources), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetVideoSources(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetVideoSources *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetVideoSources, 0, sizeof(struct _trt__GetVideoSources), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetVideoSources(struct soap *soap, const struct _trt__GetVideoSources *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetVideoSources);
	if (soap_out__trt__GetVideoSources(soap, tag?tag:"trt:GetVideoSources", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetVideoSources * SOAP_FMAC4 soap_get__trt__GetVideoSources(struct soap *soap, struct _trt__GetVideoSources *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetVideoSources(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetServiceCapabilitiesResponse(struct soap *soap, struct _trt__GetServiceCapabilitiesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Capabilities = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetServiceCapabilitiesResponse(struct soap *soap, const struct _trt__GetServiceCapabilitiesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTotrt__Capabilities(soap, &a->Capabilities);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetServiceCapabilitiesResponse(struct soap *soap, const char *tag, int id, const struct _trt__GetServiceCapabilitiesResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetServiceCapabilitiesResponse), type))
		return soap->error;
	if (soap_out_PointerTotrt__Capabilities(soap, "trt:Capabilities", -1, &a->Capabilities, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetServiceCapabilitiesResponse * SOAP_FMAC4 soap_in__trt__GetServiceCapabilitiesResponse(struct soap *soap, const char *tag, struct _trt__GetServiceCapabilitiesResponse *a, const char *type)
{
	size_t soap_flag_Capabilities = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetServiceCapabilitiesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetServiceCapabilitiesResponse, sizeof(struct _trt__GetServiceCapabilitiesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetServiceCapabilitiesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Capabilities && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotrt__Capabilities(soap, "trt:Capabilities", &a->Capabilities, "trt:Capabilities"))
				{	soap_flag_Capabilities--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetServiceCapabilitiesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetServiceCapabilitiesResponse, 0, sizeof(struct _trt__GetServiceCapabilitiesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Capabilities > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetServiceCapabilitiesResponse(struct soap *soap, const struct _trt__GetServiceCapabilitiesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetServiceCapabilitiesResponse);
	if (soap_out__trt__GetServiceCapabilitiesResponse(soap, tag?tag:"trt:GetServiceCapabilitiesResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetServiceCapabilitiesResponse * SOAP_FMAC4 soap_get__trt__GetServiceCapabilitiesResponse(struct soap *soap, struct _trt__GetServiceCapabilitiesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetServiceCapabilitiesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__trt__GetServiceCapabilities(struct soap *soap, struct _trt__GetServiceCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__trt__GetServiceCapabilities(struct soap *soap, const struct _trt__GetServiceCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__trt__GetServiceCapabilities(struct soap *soap, const char *tag, int id, const struct _trt__GetServiceCapabilities *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__trt__GetServiceCapabilities), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _trt__GetServiceCapabilities * SOAP_FMAC4 soap_in__trt__GetServiceCapabilities(struct soap *soap, const char *tag, struct _trt__GetServiceCapabilities *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _trt__GetServiceCapabilities *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__trt__GetServiceCapabilities, sizeof(struct _trt__GetServiceCapabilities), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__trt__GetServiceCapabilities(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _trt__GetServiceCapabilities *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__trt__GetServiceCapabilities, 0, sizeof(struct _trt__GetServiceCapabilities), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__trt__GetServiceCapabilities(struct soap *soap, const struct _trt__GetServiceCapabilities *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__trt__GetServiceCapabilities);
	if (soap_out__trt__GetServiceCapabilities(soap, tag?tag:"trt:GetServiceCapabilities", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _trt__GetServiceCapabilities * SOAP_FMAC4 soap_get__trt__GetServiceCapabilities(struct soap *soap, struct _trt__GetServiceCapabilities *p, const char *tag, const char *type)
{
	if ((p = soap_in__trt__GetServiceCapabilities(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_trt__StreamingCapabilities(struct soap *soap, struct trt__StreamingCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	a->RTPMulticast = NULL;
	a->RTP_USCORETCP = NULL;
	a->RTP_USCORERTSP_USCORETCP = NULL;
	a->NonAggregateControl = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_trt__StreamingCapabilities(struct soap *soap, const struct trt__StreamingCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_trt__StreamingCapabilities(struct soap *soap, const char *tag, int id, const struct trt__StreamingCapabilities *a, const char *type)
{
	if (a->RTPMulticast)
		soap_set_attr(soap, "RTPMulticast", soap_xsd__boolean2s(soap, *a->RTPMulticast));
	if (a->RTP_USCORETCP)
		soap_set_attr(soap, "RTP_TCP", soap_xsd__boolean2s(soap, *a->RTP_USCORETCP));
	if (a->RTP_USCORERTSP_USCORETCP)
		soap_set_attr(soap, "RTP_RTSP_TCP", soap_xsd__boolean2s(soap, *a->RTP_USCORERTSP_USCORETCP));
	if (a->NonAggregateControl)
		soap_set_attr(soap, "NonAggregateControl", soap_xsd__boolean2s(soap, *a->NonAggregateControl));
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_trt__StreamingCapabilities), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct trt__StreamingCapabilities * SOAP_FMAC4 soap_in_trt__StreamingCapabilities(struct soap *soap, const char *tag, struct trt__StreamingCapabilities *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct trt__StreamingCapabilities *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_trt__StreamingCapabilities, sizeof(struct trt__StreamingCapabilities), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_trt__StreamingCapabilities(soap, a);
	{	const char *t = soap_attr_value(soap, "RTPMulticast", 0);
		if (t)
		{
			if (!(a->RTPMulticast = (enum xsd__boolean *)soap_malloc(soap, sizeof(enum xsd__boolean))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2xsd__boolean(soap, t, a->RTPMulticast))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "RTP_TCP", 0);
		if (t)
		{
			if (!(a->RTP_USCORETCP = (enum xsd__boolean *)soap_malloc(soap, sizeof(enum xsd__boolean))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2xsd__boolean(soap, t, a->RTP_USCORETCP))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "RTP_RTSP_TCP", 0);
		if (t)
		{
			if (!(a->RTP_USCORERTSP_USCORETCP = (enum xsd__boolean *)soap_malloc(soap, sizeof(enum xsd__boolean))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2xsd__boolean(soap, t, a->RTP_USCORERTSP_USCORETCP))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "NonAggregateControl", 0);
		if (t)
		{
			if (!(a->NonAggregateControl = (enum xsd__boolean *)soap_malloc(soap, sizeof(enum xsd__boolean))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2xsd__boolean(soap, t, a->NonAggregateControl))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct trt__StreamingCapabilities *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_trt__StreamingCapabilities, 0, sizeof(struct trt__StreamingCapabilities), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_trt__StreamingCapabilities(struct soap *soap, const struct trt__StreamingCapabilities *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_trt__StreamingCapabilities);
	if (soap_out_trt__StreamingCapabilities(soap, tag?tag:"trt:StreamingCapabilities", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct trt__StreamingCapabilities * SOAP_FMAC4 soap_get_trt__StreamingCapabilities(struct soap *soap, struct trt__StreamingCapabilities *p, const char *tag, const char *type)
{
	if ((p = soap_in_trt__StreamingCapabilities(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_trt__ProfileCapabilities(struct soap *soap, struct trt__ProfileCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	a->MaximumNumberOfProfiles = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_trt__ProfileCapabilities(struct soap *soap, const struct trt__ProfileCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_trt__ProfileCapabilities(struct soap *soap, const char *tag, int id, const struct trt__ProfileCapabilities *a, const char *type)
{
	if (a->MaximumNumberOfProfiles)
		soap_set_attr(soap, "MaximumNumberOfProfiles", soap_int2s(soap, *a->MaximumNumberOfProfiles));
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_trt__ProfileCapabilities), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct trt__ProfileCapabilities * SOAP_FMAC4 soap_in_trt__ProfileCapabilities(struct soap *soap, const char *tag, struct trt__ProfileCapabilities *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct trt__ProfileCapabilities *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_trt__ProfileCapabilities, sizeof(struct trt__ProfileCapabilities), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_trt__ProfileCapabilities(soap, a);
	{	const char *t = soap_attr_value(soap, "MaximumNumberOfProfiles", 0);
		if (t)
		{
			if (!(a->MaximumNumberOfProfiles = (int *)soap_malloc(soap, sizeof(int))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2int(soap, t, a->MaximumNumberOfProfiles))
				return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct trt__ProfileCapabilities *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_trt__ProfileCapabilities, 0, sizeof(struct trt__ProfileCapabilities), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_trt__ProfileCapabilities(struct soap *soap, const struct trt__ProfileCapabilities *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_trt__ProfileCapabilities);
	if (soap_out_trt__ProfileCapabilities(soap, tag?tag:"trt:ProfileCapabilities", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct trt__ProfileCapabilities * SOAP_FMAC4 soap_get_trt__ProfileCapabilities(struct soap *soap, struct trt__ProfileCapabilities *p, const char *tag, const char *type)
{
	if ((p = soap_in_trt__ProfileCapabilities(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_trt__Capabilities(struct soap *soap, struct trt__Capabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ProfileCapabilities = NULL;
	a->StreamingCapabilities = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_trt__Capabilities(struct soap *soap, const struct trt__Capabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTotrt__ProfileCapabilities(soap, &a->ProfileCapabilities);
	soap_serialize_PointerTotrt__StreamingCapabilities(soap, &a->StreamingCapabilities);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_trt__Capabilities(struct soap *soap, const char *tag, int id, const struct trt__Capabilities *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_trt__Capabilities), type))
		return soap->error;
	if (soap_out_PointerTotrt__ProfileCapabilities(soap, "trt:ProfileCapabilities", -1, &a->ProfileCapabilities, ""))
		return soap->error;
	if (soap_out_PointerTotrt__StreamingCapabilities(soap, "trt:StreamingCapabilities", -1, &a->StreamingCapabilities, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct trt__Capabilities * SOAP_FMAC4 soap_in_trt__Capabilities(struct soap *soap, const char *tag, struct trt__Capabilities *a, const char *type)
{
	size_t soap_flag_ProfileCapabilities = 1;
	size_t soap_flag_StreamingCapabilities = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct trt__Capabilities *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_trt__Capabilities, sizeof(struct trt__Capabilities), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_trt__Capabilities(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProfileCapabilities && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotrt__ProfileCapabilities(soap, "trt:ProfileCapabilities", &a->ProfileCapabilities, "trt:ProfileCapabilities"))
				{	soap_flag_ProfileCapabilities--;
					continue;
				}
			if (soap_flag_StreamingCapabilities && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotrt__StreamingCapabilities(soap, "trt:StreamingCapabilities", &a->StreamingCapabilities, "trt:StreamingCapabilities"))
				{	soap_flag_StreamingCapabilities--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct trt__Capabilities *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_trt__Capabilities, 0, sizeof(struct trt__Capabilities), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProfileCapabilities > 0 || soap_flag_StreamingCapabilities > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_trt__Capabilities(struct soap *soap, const struct trt__Capabilities *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_trt__Capabilities);
	if (soap_out_trt__Capabilities(soap, tag?tag:"trt:Capabilities", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct trt__Capabilities * SOAP_FMAC4 soap_get_trt__Capabilities(struct soap *soap, struct trt__Capabilities *p, const char *tag, const char *type)
{
	if ((p = soap_in_trt__Capabilities(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__AttributedURIType(struct soap *soap, struct wsa__AttributedURIType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &a->__item);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__AttributedURIType(struct soap *soap, const struct wsa__AttributedURIType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__AttributedURIType(struct soap *soap, const char *tag, int id, const struct wsa__AttributedURIType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_xsd__anyURI(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsa__AttributedURIType * SOAP_FMAC4 soap_in_wsa__AttributedURIType(struct soap *soap, const char *tag, struct wsa__AttributedURIType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa__AttributedURIType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__AttributedURIType, sizeof(struct wsa__AttributedURIType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa__AttributedURIType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_xsd__anyURI(soap, tag, &a->__item, "wsa:AttributedURIType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__AttributedURIType(struct soap *soap, const struct wsa__AttributedURIType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__AttributedURIType);
	if (soap_out_wsa__AttributedURIType(soap, tag?tag:"wsa:AttributedURIType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__AttributedURIType * SOAP_FMAC4 soap_get_wsa__AttributedURIType(struct soap *soap, struct wsa__AttributedURIType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__AttributedURIType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__RelatesToType(struct soap *soap, struct wsa__RelatesToType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &a->__item);
	soap_default_wsa__RelationshipTypeOpenEnum(soap, &a->RelationshipType);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__RelatesToType(struct soap *soap, const struct wsa__RelatesToType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__RelatesToType(struct soap *soap, const char *tag, int id, const struct wsa__RelatesToType *a, const char *type)
{
	if (a->RelationshipType)
		soap_set_attr(soap, "RelationshipType", a->RelationshipType);
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_xsd__anyURI(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsa__RelatesToType * SOAP_FMAC4 soap_in_wsa__RelatesToType(struct soap *soap, const char *tag, struct wsa__RelatesToType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa__RelatesToType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__RelatesToType, sizeof(struct wsa__RelatesToType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa__RelatesToType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "RelationshipType", 0), &a->RelationshipType, -1, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_xsd__anyURI(soap, tag, &a->__item, "wsa:RelatesToType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__RelatesToType(struct soap *soap, const struct wsa__RelatesToType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__RelatesToType);
	if (soap_out_wsa__RelatesToType(soap, tag?tag:"wsa:RelatesToType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__RelatesToType * SOAP_FMAC4 soap_get_wsa__RelatesToType(struct soap *soap, struct wsa__RelatesToType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__RelatesToType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__MetadataType(struct soap *soap, struct wsa__MetadataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__MetadataType(struct soap *soap, const struct wsa__MetadataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__MetadataType(struct soap *soap, const char *tag, int id, const struct wsa__MetadataType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__MetadataType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa__MetadataType * SOAP_FMAC4 soap_in_wsa__MetadataType(struct soap *soap, const char *tag, struct wsa__MetadataType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa__MetadataType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__MetadataType, sizeof(struct wsa__MetadataType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa__MetadataType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa__MetadataType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__MetadataType, 0, sizeof(struct wsa__MetadataType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__MetadataType(struct soap *soap, const struct wsa__MetadataType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__MetadataType);
	if (soap_out_wsa__MetadataType(soap, tag?tag:"wsa:MetadataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__MetadataType * SOAP_FMAC4 soap_get_wsa__MetadataType(struct soap *soap, struct wsa__MetadataType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__MetadataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__ReferenceParametersType(struct soap *soap, struct wsa__ReferenceParametersType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__ReferenceParametersType(struct soap *soap, const struct wsa__ReferenceParametersType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__ReferenceParametersType(struct soap *soap, const char *tag, int id, const struct wsa__ReferenceParametersType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__ReferenceParametersType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa__ReferenceParametersType * SOAP_FMAC4 soap_in_wsa__ReferenceParametersType(struct soap *soap, const char *tag, struct wsa__ReferenceParametersType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa__ReferenceParametersType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__ReferenceParametersType, sizeof(struct wsa__ReferenceParametersType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa__ReferenceParametersType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa__ReferenceParametersType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__ReferenceParametersType, 0, sizeof(struct wsa__ReferenceParametersType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__ReferenceParametersType(struct soap *soap, const struct wsa__ReferenceParametersType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__ReferenceParametersType);
	if (soap_out_wsa__ReferenceParametersType(soap, tag?tag:"wsa:ReferenceParametersType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__ReferenceParametersType * SOAP_FMAC4 soap_get_wsa__ReferenceParametersType(struct soap *soap, struct wsa__ReferenceParametersType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__ReferenceParametersType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__EndpointReferenceType(struct soap *soap, struct wsa__EndpointReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Address = NULL;
	a->ReferenceParameters = NULL;
	a->Metadata = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__EndpointReferenceType(struct soap *soap, const struct wsa__EndpointReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__AttributedURIType(soap, &a->Address);
	soap_serialize_PointerTowsa__ReferenceParametersType(soap, &a->ReferenceParameters);
	soap_serialize_PointerTowsa__MetadataType(soap, &a->Metadata);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__EndpointReferenceType(struct soap *soap, const char *tag, int id, const struct wsa__EndpointReferenceType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__EndpointReferenceType), type))
		return soap->error;
	if (soap_out_PointerTowsa__AttributedURIType(soap, "wsa:Address", -1, &a->Address, ""))
		return soap->error;
	if (soap_out_PointerTowsa__ReferenceParametersType(soap, "wsa:ReferenceParameters", -1, &a->ReferenceParameters, ""))
		return soap->error;
	if (soap_out_PointerTowsa__MetadataType(soap, "wsa:Metadata", -1, &a->Metadata, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType * SOAP_FMAC4 soap_in_wsa__EndpointReferenceType(struct soap *soap, const char *tag, struct wsa__EndpointReferenceType *a, const char *type)
{
	size_t soap_flag_Address = 1;
	size_t soap_flag_ReferenceParameters = 1;
	size_t soap_flag_Metadata = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa__EndpointReferenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__EndpointReferenceType, sizeof(struct wsa__EndpointReferenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa__EndpointReferenceType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Address && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__AttributedURIType(soap, "wsa:Address", &a->Address, "wsa:AttributedURIType"))
				{	soap_flag_Address--;
					continue;
				}
			if (soap_flag_ReferenceParameters && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__ReferenceParametersType(soap, "wsa:ReferenceParameters", &a->ReferenceParameters, "wsa:ReferenceParametersType"))
				{	soap_flag_ReferenceParameters--;
					continue;
				}
			if (soap_flag_Metadata && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__MetadataType(soap, "wsa:Metadata", &a->Metadata, "wsa:MetadataType"))
				{	soap_flag_Metadata--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa__EndpointReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__EndpointReferenceType, 0, sizeof(struct wsa__EndpointReferenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Address > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__EndpointReferenceType(struct soap *soap, const struct wsa__EndpointReferenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__EndpointReferenceType);
	if (soap_out_wsa__EndpointReferenceType(soap, tag?tag:"wsa:EndpointReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType * SOAP_FMAC4 soap_get_wsa__EndpointReferenceType(struct soap *soap, struct wsa__EndpointReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__EndpointReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__Rectangle(struct soap *soap, struct tt__Rectangle *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->bottom = NULL;
	a->top = NULL;
	a->right = NULL;
	a->left = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_tt__Rectangle(struct soap *soap, const struct tt__Rectangle *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__Rectangle(struct soap *soap, const char *tag, int id, const struct tt__Rectangle *a, const char *type)
{
	if (a->bottom)
		soap_set_attr(soap, "bottom", soap_float2s(soap, *a->bottom));
	if (a->top)
		soap_set_attr(soap, "top", soap_float2s(soap, *a->top));
	if (a->right)
		soap_set_attr(soap, "right", soap_float2s(soap, *a->right));
	if (a->left)
		soap_set_attr(soap, "left", soap_float2s(soap, *a->left));
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__Rectangle), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct tt__Rectangle * SOAP_FMAC4 soap_in_tt__Rectangle(struct soap *soap, const char *tag, struct tt__Rectangle *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct tt__Rectangle *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__Rectangle, sizeof(struct tt__Rectangle), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_tt__Rectangle(soap, a);
	{	const char *t = soap_attr_value(soap, "bottom", 0);
		if (t)
		{
			if (!(a->bottom = (float *)soap_malloc(soap, sizeof(float))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2float(soap, t, a->bottom))
				return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "top", 0);
		if (t)
		{
			if (!(a->top = (float *)soap_malloc(soap, sizeof(float))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2float(soap, t, a->top))
				return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "right", 0);
		if (t)
		{
			if (!(a->right = (float *)soap_malloc(soap, sizeof(float))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2float(soap, t, a->right))
				return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	{	const char *t = soap_attr_value(soap, "left", 0);
		if (t)
		{
			if (!(a->left = (float *)soap_malloc(soap, sizeof(float))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2float(soap, t, a->left))
				return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct tt__Rectangle *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__Rectangle, 0, sizeof(struct tt__Rectangle), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__Rectangle(struct soap *soap, const struct tt__Rectangle *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__Rectangle);
	if (soap_out_tt__Rectangle(soap, tag?tag:"tt:Rectangle", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct tt__Rectangle * SOAP_FMAC4 soap_get_tt__Rectangle(struct soap *soap, struct tt__Rectangle *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__Rectangle(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__WhiteBalance(struct soap *soap, struct tt__WhiteBalance *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_tt__WhiteBalanceMode(soap, &a->Mode);
	soap_default_float(soap, &a->CrGain);
	soap_default_float(soap, &a->CbGain);
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_tt__WhiteBalance(struct soap *soap, const struct tt__WhiteBalance *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->Mode, SOAP_TYPE_tt__WhiteBalanceMode);
	soap_embedded(soap, &a->CrGain, SOAP_TYPE_float);
	soap_embedded(soap, &a->CbGain, SOAP_TYPE_float);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__WhiteBalance(struct soap *soap, const char *tag, int id, const struct tt__WhiteBalance *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__WhiteBalance), type))
		return soap->error;
	if (soap_out_tt__WhiteBalanceMode(soap, "tt:Mode", -1, &a->Mode, ""))
		return soap->error;
	if (soap_out_float(soap, "tt:CrGain", -1, &a->CrGain, ""))
		return soap->error;
	if (soap_out_float(soap, "tt:CbGain", -1, &a->CbGain, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct tt__WhiteBalance * SOAP_FMAC4 soap_in_tt__WhiteBalance(struct soap *soap, const char *tag, struct tt__WhiteBalance *a, const char *type)
{
	size_t soap_flag_Mode = 1;
	size_t soap_flag_CrGain = 1;
	size_t soap_flag_CbGain = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct tt__WhiteBalance *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__WhiteBalance, sizeof(struct tt__WhiteBalance), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_tt__WhiteBalance(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Mode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_tt__WhiteBalanceMode(soap, "tt:Mode", &a->Mode, "tt:WhiteBalanceMode"))
				{	soap_flag_Mode--;
					continue;
				}
			if (soap_flag_CrGain && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "tt:CrGain", &a->CrGain, "xsd:float"))
				{	soap_flag_CrGain--;
					continue;
				}
			if (soap_flag_CbGain && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_float(soap, "tt:CbGain", &a->CbGain, "xsd:float"))
				{	soap_flag_CbGain--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct tt__WhiteBalance *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__WhiteBalance, 0, sizeof(struct tt__WhiteBalance), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Mode > 0 || soap_flag_CrGain > 0 || soap_flag_CbGain > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__WhiteBalance(struct soap *soap, const struct tt__WhiteBalance *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__WhiteBalance);
	if (soap_out_tt__WhiteBalance(soap, tag?tag:"tt:WhiteBalance", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct tt__WhiteBalance * SOAP_FMAC4 soap_get_tt__WhiteBalance(struct soap *soap, struct tt__WhiteBalance *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__WhiteBalance(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__WhiteBalanceOptions(struct soap *soap, struct tt__WhiteBalanceOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeMode = 0;
	a->Mode = NULL;
	a->YrGain = NULL;
	a->YbGain = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_tt__WhiteBalanceOptions(struct soap *soap, const struct tt__WhiteBalanceOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Mode)
	{	int i;
		for (i = 0; i < a->__sizeMode; i++)
		{
			soap_embedded(soap, a->Mode + i, SOAP_TYPE_tt__WhiteBalanceMode);
		}
	}
	soap_serialize_PointerTott__FloatRange(soap, &a->YrGain);
	soap_serialize_PointerTott__FloatRange(soap, &a->YbGain);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__WhiteBalanceOptions(struct soap *soap, const char *tag, int id, const struct tt__WhiteBalanceOptions *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__WhiteBalanceOptions), type))
		return soap->error;
	if (a->Mode)
	{	int i;
		for (i = 0; i < a->__sizeMode; i++)
			if (soap_out_tt__WhiteBalanceMode(soap, "tt:Mode", -1, a->Mode + i, ""))
				return soap->error;
	}
	if (soap_out_PointerTott__FloatRange(soap, "tt:YrGain", -1, &a->YrGain, ""))
		return soap->error;
	if (soap_out_PointerTott__FloatRange(soap, "tt:YbGain", -1, &a->YbGain, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct tt__WhiteBalanceOptions * SOAP_FMAC4 soap_in_tt__WhiteBalanceOptions(struct soap *soap, const char *tag, struct tt__WhiteBalanceOptions *a, const char *type)
{
	struct soap_blist *soap_blist_Mode = NULL;
	size_t soap_flag_YrGain = 1;
	size_t soap_flag_YbGain = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct tt__WhiteBalanceOptions *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__WhiteBalanceOptions, sizeof(struct tt__WhiteBalanceOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_tt__WhiteBalanceOptions(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "tt:Mode", 1, NULL))
			{	if (a->Mode == NULL)
				{	if (soap_blist_Mode == NULL)
						soap_blist_Mode = soap_new_block(soap);
					a->Mode = (enum tt__WhiteBalanceMode *)soap_push_block(soap, soap_blist_Mode, sizeof(enum tt__WhiteBalanceMode));
					if (a->Mode == NULL)
						return NULL;
					soap_default_tt__WhiteBalanceMode(soap, a->Mode);
				}soap_revert(soap);
				if (soap_in_tt__WhiteBalanceMode(soap, "tt:Mode", a->Mode, "tt:WhiteBalanceMode"))
				{	a->__sizeMode++;
					a->Mode = NULL;
					continue;
				}
			}
			if (soap_flag_YrGain && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__FloatRange(soap, "tt:YrGain", &a->YrGain, "tt:FloatRange"))
				{	soap_flag_YrGain--;
					continue;
				}
			if (soap_flag_YbGain && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTott__FloatRange(soap, "tt:YbGain", &a->YbGain, "tt:FloatRange"))
				{	soap_flag_YbGain--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Mode)
			soap_pop_block(soap, soap_blist_Mode);
		if (a->__sizeMode)
			a->Mode = (enum tt__WhiteBalanceMode *)soap_save_block(soap, soap_blist_Mode, NULL, 1);
		else
		{	a->Mode = NULL;
			if (soap_blist_Mode)
				soap_end_block(soap, soap_blist_Mode);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct tt__WhiteBalanceOptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__WhiteBalanceOptions, 0, sizeof(struct tt__WhiteBalanceOptions), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->__sizeMode < 1 || soap_flag_YrGain > 0 || soap_flag_YbGain > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__WhiteBalanceOptions(struct soap *soap, const struct tt__WhiteBalanceOptions *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__WhiteBalanceOptions);
	if (soap_out_tt__WhiteBalanceOptions(soap, tag?tag:"tt:WhiteBalanceOptions", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct tt__WhiteBalanceOptions * SOAP_FMAC4 soap_get_tt__WhiteBalanceOptions(struct soap *soap, struct tt__WhiteBalanceOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__WhiteBalanceOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__ExposureOptions(struct soap *soap, struct tt__ExposureOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeMode = 0;
	a->Mode = NULL;
	a->__sizePriority = 0;
	a->Priority = NULL;
	a->MinExposureTime = NULL;
	a->MaxExposureTime = NULL;
	a->MinGain = NULL;
	a->MaxGain = NULL;
	a->MinIris = NULL;
	a->MaxIris = NULL;
	a->ExposureTime = NULL;
	a->Gain = NULL;
	a->Iris = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_tt__ExposureOptions(struct soap *soap, const struct tt__ExposureOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Mode)
	{	int i;
		for (i = 0; i < a->__sizeMode; i++)
		{
			soap_embedded(soap, a->Mode + i, SOAP_TYPE_tt__ExposureMode);
