/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: wireless_sm.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _WIRELESS_SM_H_
#define _WIRELESS_SM_H_

// A simple state machine that switches us between associated, and
// unassociated states.  If you add or change any of these, make sure
// to update wireless_sm_disp_state() or your debug information will
// be messed up.  ;)

#define UNASSOCIATED 0
#define ASSOCIATED   1
#define ACTIVE_SCAN  2    // There may be a passive scan later.
#define ASSOCIATING  3    // Attempting to associate
#define ASSOCIATION_TIMEOUT_S 4
#define STATIC_ASSOCIATION 5  // Associated to a network with static wep, or
                              // no keying.
#define PORT_DOWN    6        // The interface is down state.
#define NO_ENC_ASSOCIATION 7  
#define AUTH_RESTART       8  // Restart everything.
#define AUTH_STOPPED       9  // Stop answering requests.

struct wireless_state {
  int state;
  int flags;

  // Variables for external events that trigger state changes.
  int initialize;             // Reinit the wireless SM.
  int associated;             // Are we now associated?
  int port_active;            // Is this port operational?
  int ssid_change;            // Did we change SSIDs.
};

// Valid flags settings for wireless_state.
#define ZEROSONROAM      0x01

void wireless_sm_init(int, struct interface_data *);
void wireless_sm_deinit();
void wireless_sm_change_state(int, struct interface_data *);
void wireless_sm_dump_state();
int  wireless_sm_get_state();
void wireless_sm_do_state(struct interface_data *);
struct wireless_state *get_wireless_sm();

#endif
