/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _EVENT_CORE_H_
#define _EVENT_CORE_H_

// Priority values for event_core_register();
#define HIGH_PRIORITY    0
#define ANY_PRIORITY     1
#define LOW_PRIORITY     2

// Maximum number of event handlers we will register.
#define MAX_EVENTS       10

void event_core_init();
void event_core_deinit();
void event_core(struct interface_data *);
int event_core_register(int, int(*)(struct interface_data *, int), int, char *);
void event_core_deregister(int);
int event_core_locate(char *);
void event_core_reset_locate();

#endif
