/*******************************************************************
 *
 * License under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: eaptnc.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _EAPTNC_H_
#define _EAPTNC_H_

#include "profile.h"

/***************************************************************
 *
 *  The TNC Flags/Version byte looks similar to the Flags/Version byte in
 *  PEAP.  It's format is :
 *
 *  L M S R R V V V   --  (Each character is one bit.)
 *
 ***************************************************************/

#define TNC_VERSION_MASK     0x07
#define TNC_LENGTH_FLAG      0x80
#define TNC_MORE_FLAG        0x40
#define TNC_START_FLAG       0x20
#define TNC_RESERVED_FLAGS   0x18

#warning Define these correctly.
#define TNC_RESULT_SUCCESS 0
#define TNC_MORE_DATA      0

#define TNC_MAX_VERSION_SUPPORTED     1

int eaptnc_setup(struct generic_eap_data *);
int eaptnc_process(struct generic_eap_data *, uint8_t *, int, uint8_t *, int *);
int eaptnc_get_keys(struct interface_data *);
int eaptnc_cleanup(struct generic_eap_data *);
int eaptnc_failed(struct generic_eap_data *);

#endif
