/********************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 ********************************************************************/

#ifndef TLS_FUNCS_H
#define TLS_FUNCS_H

#include "eaptls.h"

#define TLS_SESSION_KEY_SIZE   128

typedef char (*phase2_call)(struct generic_eap_data *thisint, uint8_t *in, 
			    int in_size, char *out, int *out_size);

int tls_funcs_init(struct generic_eap_data *);
int tls_funcs_failed(struct generic_eap_data *);
int tls_funcs_cleanup(struct generic_eap_data *);
int tls_funcs_decode_packet(struct generic_eap_data *, char *, int, char *, 
			    int *, phase2_call, int);
int tls_funcs_build_ack(char *, int *);
int tls_funcs_load_random(struct generic_eap_data *, char *);
int tls_funcs_load_user_cert(struct generic_eap_data *, char *, char *, char *,
			     char *);
int tls_funcs_load_root_certs(struct generic_eap_data *, char *, char *, 
			      char *);
char *tls_funcs_gen_keyblock(struct generic_eap_data *);
int tls_funcs_PRF(uint8_t *, int, uint8_t *, int, uint8_t *, int, uint8_t *, int);
void tls_funcs_process_error();
#endif

