/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/


void netConfig::okayClicked()
{
    // Write data back to the structure.
}

void netConfig::populateWpaPsk(config_eap_method *eapMethod)
{
    struct config_wpa_psk *psk;
    
    psk = (struct config_wpa_psk *)eapMethod->method_data;
    txtKeyEdit->setText(QString(psk->key));
}

void netConfig::populateDot1X(config_eap_method *eapMethod)
{
    
}

QString *netConfig::getEncrType(uint8_t type)
{
    QString *result;
    
    switch (type)
    {
    case CRYPT_WEP40:
    case CRYPT_WEP104:
	result = new QString("WEP");
	break;
	
    case CRYPT_TKIP:
	result = new QString("TKIP");
	break;
	
    case CRYPT_CCMP:
	result = new QString("CCMP");
	break;
	
    default:
	return NULL;
	break;
    }
    
    return result;
}

void netConfig::setNetConfig(config_network *netConf)
{
    QString *temp;
    
    // Fill in with values needed to populate dialog.
    netNameEdit->setText(QString(netConf->name));

    if (netConf->identity != NULL)
    {
	identEdit->setText(QString(netConf->identity));
    }
    
    if (netConf->methods->method_num == WPA_PSK)
    {
	// Set group boxes
	wpaBox->setEnabled(true);
	dot1xBox->setEnabled(false);
	
	// Set radio buttons
	dot1xAuth->setChecked(false);
	wpaPskAuth->setChecked(true);
	
	populateWpaPsk(netConf->methods);
    }
    else
    {
	// Set group boxes
	wpaBox->setEnabled(false);
	dot1xBox->setEnabled(true);
	
	// Set radio buttons
	dot1xAuth->setChecked(true);
	wpaPskAuth->setChecked(false);
	
	populateDot1X(netConf->methods);
    }
    
    priorityBox->setValue(netConf->priority);
    
    if ((netConf->wpa_group_crypt == 0) && (netConf->wpa_pairwise_crypt == 0))
    {
	encrToUse->setCurrentText(QString("Auto"));
	pairKeyType->setEnabled(false);
	pairKeySetting->setEnabled(false);
	grpKeyType->setEnabled(false);
	grpKeySetting->setEnabled(false);
    }
    else
    {
	encrToUse->setCurrentText(QString("WPA/WPA2"));
	pairKeyType->setEnabled(true);
	pairKeySetting->setEnabled(true);
	grpKeyType->setEnabled(true);
	grpKeySetting->setEnabled(true);
	
	// Then set the values for pairwise and group keys.
	temp = getEncrType(netConf->wpa_group_crypt);
	if (temp != NULL)
	{
	    pairKeySetting->setCurrentText((*temp));
	    delete temp;
	}
	
	temp = getEncrType(netConf->wpa_pairwise_crypt);
	if (temp != NULL)
	{
	    grpKeySetting->setCurrentText((*temp));
	    delete temp;
	}
    }
    
    if (netConf->flags & CONFIG_NET_USE_TNC)
    {
	tncCheck->setChecked(true);
    }
    else
    {
	tncCheck->setChecked(false);
    }
}


void netConfig::pskSelected()
{
    dot1xBox->setEnabled(false);
    wpaBox->setEnabled(true);
}


void netConfig::dot1xSelected()
{
    dot1xBox->setEnabled(true);
    wpaBox->setEnabled(false);
}


void netConfig::encrSelected()
{
    if (encrToUse->currentText() == "Auto") 
    {
	// Disable the pairwise/group selection options.
	pairKeyType->setEnabled(false);
	pairKeySetting->setEnabled(false);
	grpKeyType->setEnabled(false);
	grpKeySetting->setEnabled(false);	
    }
    else
    {
	// Enable the pairwise/group selection options.
	pairKeyType->setEnabled(true);
	pairKeySetting->setEnabled(true);
	grpKeyType->setEnabled(true);
	grpKeySetting->setEnabled(true);
    }
}


void netConfig::eapBtnClicked()
{
    upwdDialog *ud;
    ttlsWnd *ttls;
    
    if (eapSelection->currentText() == "EAP-PEAP")
    {
	// Set up and call PEAP configuration.

    }
    
    if (eapSelection->currentText() == "EAP-TTLS")
    {
	// Set up and call TTLS configuration.
	ttls = new ttlsWnd;
	ttls->exec();
	delete ttls;
    }
    
    if (eapSelection->currentText() == "EAP-TLS")
    {
	// Set up and call TLS configuration.
    }
    
    if (eapSelection->currentText() == "LEAP")
    {
	// LEAP
	ud = new upwdDialog;
	ud->setCaption(QString("Enter your LEAP Password"));
	ud->exec();
	delete ud;
    }
    
    if (eapSelection->currentText() == "EAP-MS-CHAPv2")
    {
	// MS CHAP v2.
	ud = new upwdDialog;
	ud->setCaption(QString("Enter your MS-CHAPv2 Password"));
	ud->exec();
	delete ud;
    }
    
    if (eapSelection->currentText() == "EAP-MD5")
    {
	// EAP-MD5
	ud = new upwdDialog;
	ud->setCaption(QString("Enter your EAP-MD5 Password"));
	ud->exec();
	delete ud;
    }
    
    if (eapSelection->currentText() == "EAP-SIM")
    {
	// EAP-SIM
	ud = new upwdDialog;
	ud->setCaption(QString("(EAP-SIM) Enter your pin"));
	ud->pwdLabel->setText(QString("PIN : "));
	ud->exec();
	delete ud;
    }
    
    if (eapSelection->currentText() == "EAP-AKA")
    {
	// EAP-AKA
	ud = new upwdDialog;
	ud->setCaption(QString("(EAP-AKA) Enter your pin"));
	ud->pwdLabel->setText(QString("PIN : "));
	ud->exec();
	delete ud;
    }
    
    if (eapSelection->currentText() == "EAP-OTP")
    {
	// EAP-OTP  (Nothing to do...  Should never get here.)
    }
    
    if (eapSelection->currentText() == "EAP-GTC")
    {
	// EAP-GTC
    }
}


void netConfig::eapCheckHighlight()
{
    if (eapSelection->currentText() == "EAP-OTP")
    {
	configEapButton->setEnabled(false);
    }
    else
    {
	configEapButton->setEnabled(true);
    }
}
