
#ifndef __EXPORTS_H__
#define __EXPORTS_H__

#ifndef __ASSEMBLY__

#include <common.h>

/* These are declarations of exported functions available in C code */
unsigned long get_version(void);
int  getc(void);
int  tstc(void);
void putc(const char);
void puts(const char*);
int  printf(const char* fmt, ...);
void install_hdlr(int, interrupt_handler_t*, void*);
void free_hdlr(int);
void *malloc(size_t);
void free(void*);
void __udelay(unsigned long);
unsigned long get_timer(unsigned long);
int  vprintf(const char *, va_list);
void do_reset (void);
unsigned long simple_strtoul(const char *cp,char **endp,unsigned int base);
char *getenv (char *name);
int  setenv (char *varname, char *varvalue);
long simple_strtol(const char *cp,char **endp,unsigned int base);
int  strcmp(const char * cs,const char * ct);
int  ustrtoul(const char *cp, char **endp, unsigned int base);

#ifdef CONFIG_HAS_UID
void forceenv (char *varname, char *varvalue);
#endif

#if defined(CONFIG_CMD_I2C)
int i2c_write (uchar, uint, int , uchar* , int);
int i2c_read (uchar, uint, int , uchar* , int);
#endif
#include <spi.h>

/* A1 stand-alone demo exports goes here */
#include <linux/mtd/mtd.h>
#include <jffs2/load_kernel.h>
#include <command.h>
#include <asm/arch/serial.h>

//ISP start
#include <asm/arch/irq.h>

// -- R:20120606-01 @PCBA_TEST --
#include "hal.h"
#include "dosFS.h"		
int system_clk_init(void);
int device_clk_init(void);

//ISP start
void vic_disirq(IntrVector_E dev);
void vic_cleanirq(IntrVector_E dev);
void vic_enirq (IntrVector_E dev);
u32  reg_interrupt(INT_TYPE type, IntrVector_E source, ISR_FT ft);
void* memcpy(void*, const void*, size_t);
void* memset(void*, int, size_t);
int memcmp(const void * cs,const void * ct,size_t count);
unsigned int halSysGetDeviceClockSrc(unsigned int Fin, int DeviceID, unsigned int *divider);
unsigned int halGPIOGetPinData(int gpio, halGPIOPin_E nPin);
void halGPIOSetPinDir(int gpio, halGPIOPin_E nPin, bool_T b);
void halGPIOSetDBEnable(int gpio, halGPIOPin_E nPin, bool_T b);
void halGPIOSetInterrupt(int gpio, halGPIOPin_E nPin, bool_T b);
int isp_nand_read(loff_t offset, size_t size,u_char *buffer);
int isp_nand_write(loff_t offset, size_t size,u_char *buffer);
int isp_nand_erase(loff_t offset, size_t size);
/* End of A1 demo */

void app_startup(char * const *);

#endif    /* ifndef __ASSEMBLY__ */

enum {
	#define EXPORT_FUNC(x) XF_ ## x ,
	#include <_exports.h>
	#undef EXPORT_FUNC

	XF_MAX
};

#define XF_VERSION	6

#if defined(CONFIG_I386)
extern gd_t *global_data;
#endif

#endif	/* __EXPORTS_H__ */

