/*
 * (C) Copyright 2002 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 * Gary Jennejohn <gj@denx.de>
 * David Mueller <d.mueller@elsoft.ch>
 *
 * Configuation settings for the GUC UMVP2500 board.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/* |-------------------------------| 0x50000000     Remap to (0x0)
 * |  U-BOOT Code Data section     |
 * |  Cacheable Bufferable         |
 * |-------------------------------|----------------------------------
 * |  Heap Stack section           |
 * |  Cacheable Bufferable         |
 * |-------------------------------| 0x50800000
 * |-------------------------------| 0x50800000
 * |  **RamDisk                    |
 * |    loading address            |
 * |-------------------------------| 0x51800000
 * |  **Kernel Image               |
 * |    loading address            |
 * |-------------------------------| 0x52000000
 * |  **Memory Test Region         |
 * |-------------------------------| 0x55000000
 * |  **NAND Controller            |
 * |  Non Cacheable Bufferable     |
 * |-------------------------------| 0x56000000
 * |  **Network IC working area    |
 * |  Non Cacheable Bufferable     |
 * |-------------------------------| 0x57000000
 * |  ** DMA-able memory pool(64M) |
 * |  Non Cacheable Bufferable     |
 * |-------------------------------| 0x5b000000
 */



#ifndef __CONFIG_H
#define __CONFIG_H

#define BOOTLOADER_VER  "BOOTLOADER-500-V01.11"

/*------------------------------------------------------
 * High Level Configuration Options
 * (easy to change)
 */
#define CONFIG_ARM926EJS    /* This is an arm926ejs CPU core  */
#define CONFIG_ACTI         /* This is ACTi ASIC */

#define CONFIG_SKIP_LOWLEVEL_INIT
//#define CONFIG_A1_INIT_DDR            /* If need to do DDR initialization */
//#define CONFIG_A1_EARLY_SERIAL_INIT   /* If need to do early serial init for debugging */

/* Input clock of PLL */
/* the A1EVB has 225MHz input clock */
#define CONFIG_SYS_INPUT_CLOCK  12000000    /* input clock source for PLL1/PLL0, added by Ted */
#define CONFIG_SYS_CLK_FREQ     225000000   /* System default AHB clock */

#define CONFIG_SYS_HZ           1000    /* timer ticks per second */
//#define CONFIG_SYS_SDRAM_BASE 0x50000000
//#define CONFIG_SYS_INIT_SP_ADDR   (CONFIG_SYS_TEXT_BASE + 0x800000)
#define CONFIG_USE_IRQ
#define CONFIG_USE_FIQ

#define CONFIG_USE_ARCH_MEMSET
#define CONFIG_USE_ARCH_MEMCPY

/* A1 UART controller is NS16550 compatible */

/*
 * NS16550 Configuration
 */
#define CONFIG_SYS_NS16550
#define CONFIG_SYS_NS16550_SERIAL
#define CONFIG_SYS_NS16550_COM1     0x99d00000
#define CONFIG_SYS_NS16550_COM2     0x99e00000
#define CONFIG_SYS_NS16550_COM3     0x99f00000
#define CONFIG_SYS_NS16550_COM4     0x9a000000
#define CONFIG_SYS_NS16550_COM5     0x9a100000
#define CONFIG_SYS_NS16550_REG_SIZE -4
#define CONFIG_SYS_NS16550_CLK      (CONFIG_SYS_CLK_FREQ / 2)

/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1          1 /* we use SERIAL 1 on A1 */

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE
#define CONFIG_CONS_INDEX       1
#define CONFIG_BAUDRATE         115200
#define CONFIG_SYS_BAUDRATE_TABLE   { 9600, 19200, 38400, 57600, 115200 }


/************************************************************
 * Supported IP
 ************************************************************/
#define CONFIG_CODEC_HX8290     1
#define CONFIG_CODEC_HX9170     1
#define CONFIG_UAPC2700         1 /* LCD controller */

/*
 * Config ethernet
 */
#define CONFIG_SYS_RX_ETH_BUFFER    0x10
#define CONFIG_ETHADDR          00:a1:a1:a1:a1:a1
#define CONFIG_NETMASK          255.255.255.0
#define CONFIG_IPADDR           172.16.14.31
#define CONFIG_SERVERIP         172.16.14.15

///* env bootfile= */
#define CONFIG_UBOOTFILE    mtd_uboot.bin   /* U-Boot image on TFTP server */
#define CONFIG_BOOTFILE     Image           /* Kernel image on TFTP server */
#define CONFIG_RAMDISKFILE  ramdisk.gz      /* Ramdisk image on TFTP server */
#define CONFIG_FSFILE       rootfs.jffs2    /* U-Boot image on TFTP server */

/*
 * BOOTP options
 */
#define CONFIG_BOOTP_BOOTFILESIZE
#define CONFIG_BOOTP_BOOTPATH
#define CONFIG_BOOTP_GATEWAY
#define CONFIG_BOOTP_HOSTNAME


/*
 * I2C configuration
 */
#define CONFIG_DRIVER_ACTI_A1_I2C
#define CONFIG_HARD_I2C
#define CONFIG_SYS_I2C_SPEED    10000
#define CONFIG_SYS_I2C0_SLAVE   0x1A
#define CONFIG_SYS_I2C1_SLAVE   0x28
#define CONFIG_I2C_MULTI_BUS
#define CONFIG_CMD_I2C
/*
 * Command line configuration.
 */
#include <config_cmd_default.h>

#define CONFIG_CMD_CACHE



/*
 * Size of malloc() pool
 */
#define SZ_128K                     (128 << 10)
#define SZ_1M                       (1 << 20)
#define CONFIG_ENV_SIZE             SZ_128K     /* Environment variable */
#define CONFIG_SYS_MALLOC_LEN       (CONFIG_ENV_SIZE + SZ_1M)
#define CONFIG_SYS_GBL_DATA_SIZE    128 /* size in bytes reserved for initial data */

#define CONFIG_A1_TLB_ADDR          0x52a00000  /* where the TLB */
/*
 * Miscellaneous configurable options
 */
#define CONFIG_SYS_LONGHELP     /* undef to save memory */
#define CONFIG_SYS_PROMPT       "ACTi-A1 $ "       /* Monitor Command Prompt    */
#define CONFIG_SYS_CBSIZE       1024        /* Console I/O Buffer Size */
/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE       (CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
#define CONFIG_SYS_MAXARGS      16                  /* max number of command args   */
#define CONFIG_SYS_BARGSIZE     CONFIG_SYS_CBSIZE   /* Boot Argument Buffer Size    */

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS        1           /* we have 1 bank of DRAM */
#define PHYS_SDRAM_1                0x50000000  /* SDRAM Bank #1 */
//#define PHYS_SDRAM_1_SIZE         0x10000000  /* 256 MB */
#define PHYS_SDRAM_1_SIZE           0x08000000  /* 128 MB for Linux, another 128 is managed by a1_shamm */
#define CONFIG_SYS_LOAD_ADDR        0x58000000  /* default load address */
#define CONFIG_SYS_MEMTEST_START    0x54000000  /* memtest works on */
#define CONFIG_SYS_MEMTEST_END      0x55000000  /* 16 MB in DRAM */
#define CONFIG_A1_NAND_DMA_BUFFER   0x55000000
#define CONFIG_A1_NET_DMABADD       0x56000000  /* Network IC work area.*/
//#define CONFIG_HX8290_MEMPOOL_START   0x57000000  /* Start address of memory pool for HX8290 */
//#define CONFIG_HX8290_MEMPOOL_SIZE    0x1000000   /* Size of memory pool for HX8290. It's 16MB so far */

/*
 * For Linux kernel
 */
#define MACH_TYPE_ACTi_A1       0x859
#define LINUX_BOOT_PARAM_ADDR   (PHYS_SDRAM_1 + 0x100)
#define CONFIG_LOADADDR         CONFIG_SYS_LOAD_ADDR    /* default location for the tftp and bootm, ${ */

/*
 * Boot options.
 */

/* To define ATAGS for linux */
#define CONFIG_CMDLINE_TAG   1  /* enable passing of ATAGs  */
#define CONFIG_SETUP_MEMORY_TAGS 1
#define CONFIG_INITRD_TAG    1

/*
 * IRQ Handle
 */
#define CONFIG_USE_ISRNUM           32 /* Maximun supported ISR number  */


/*-----------------------------------------------------------------------
 * Stack sizes
 *
 * The stack sizes are set up in start.S using the settings below
 */
#define CONFIG_STACKSIZE            (1024 * 1024)   /* regular stack */
#ifdef CONFIG_USE_IRQ
#define CONFIG_STACKSIZE_IRQ        (4 * 1024)  /* IRQ stack */
#define CONFIG_STACKSIZE_FIQ        (4 * 1024)  /* FIQ stack */
#endif

/*
 * Un-comment it if you don't have NOR flash
 */
//#define CONFIG_SYS_NO_FLASH

/*
 * NOR flash selection
 */
#define CONFIG_JS28F_256M_29EWHA            /* A1EVB, 32MB, 128K */
//#define CONFIG_MX_29LV640EB                   /* A1FPGA, 8Mbits*8 */


/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */
#ifndef CONFIG_SYS_NO_FLASH
    #define CONFIG_SYS_FLASH_BASE           0x40000000
    #define CONFIG_SYS_MAX_FLASH_BANKS      1           /* max number of memory banks */
#endif

#ifdef  CONFIG_MX_29LV640EB
    #define PHYS_FLASH_SIZE                 0x00800000  /* 8MB */
    #define CONFIG_SYS_MAX_FLASH_SECT       (135)       /* max number of sectors on one chip */
#endif

#ifdef  CONFIG_JS28F_256M_29EWHA
    #define PHYS_FLASH_SIZE                 0x02000000  /* 32MB */
    #define CONFIG_SYS_MAX_FLASH_SECT       (256)       /* max number of sectors on one chip */
#endif

/* init_sequence */
#define CONFIG_ARCH_CPU_INIT        1
#define CONFIG_BOARD_EARLY_INIT_F   1
#define CONFIG_DISPLAY_CPUINFO      1   /* display cpu info (and speed) */

//#define CONFIG_ENV_IS_EMBEDDED

#define CONFIG_NAND_ACTI_A1
/*-----------------------------------------------------------------------
 * NAND-FLASH stuff
 *-----------------------------------------------------------------------
 */
//#define CONFIG_DOS_PARTITION  1
//#define CONFIG_CMD_EXT2       /* EXT2 Support         */
//#define CONFIG_CMD_FAT        /* FAT support          */
//#define CONFIG_CMD_JFFS2  /* JFFS2 Support        */
//#define CONFIG_JFFS2_NAND

#define CONFIG_SYS_SDMMC_BASE   0x90700000
//#define CONFIG_NAND_TYPE  ST512W3A

#define CONFIG_BOOTDELAY    3   /* boot prompt delay before autoboot */
#define CFG_A1_PART_ENV_NAME    "uboot-env"



#define CONFIG_CMD_NAND         // NAND support
#define CONFIG_SYS_NAND_BASE        0x90500000  /* NAND Controller */
#define CONFIG_SYS_MAX_NAND_DEVICE  1         /* Max number of NAND devices */
#define CONFIG_SYS_NAND_MAX_CHIPS   1

#ifdef CONFIG_CMD_NAND
    #undef  CONFIG_ENV_IS_IN_FLASH
    #define CONFIG_ENV_IS_IN_NAND       1   /* use NAND for environment vars */
    #define CONFIG_JFFS2_CMDLINE
    #define CONFIG_CMD_MTDPARTS     // MTD partition support
    #define CONFIG_MTD_PARTITIONS
    #define CONFIG_MTD_DEVICE
    #define CONFIG_NAND_ACTI_A1     /* turn on mtd/nand/acti_a1.c */
#endif
/**
 * Pre-configured help command
 */
#define CONFIG_PREBOOT  "echo;" \
    "echo ============================================================================;"\
    "echo Type \\\"run update-U\\\", flash uboot part with mtd_boot.bin;" \
    "echo Type \\\"run update-bootp1\\\", download and flash bootp image to bootp1 partition.. ;" \
    "echo Type \\\"run update-bootp2\\\", download and flash bootp image to bootp2 partition.. ;" \
    "echo Type \\\"run ramboot\\\" to tftp kernel, ramdisk image & boot.... ;" \
    "echo Type \\\"boot\\\" to run default bootcmd;" \
    "echo Type \\\"mtdparts\\\" to list pre-defined MTD partitions;" \
    "echo Type \\\"saveenv\\\" to save environment to \\\"u-boot-env\\\" partition;" \
    "echo Type \\\"help\\\" to print help menu;" \
    "echo ============================================================================;"\
    "echo"

#define MTDIDS_DEFAULT          "nand0=acti_nand"
#define MTDPARTS_DEFAULT        "mtdparts=acti_nand:1024k(uboot),128k(uboot-env),11264k(config),20480k(bootp1),20480k(bootp2),1024k(ispconf1),1024k(ispconf2),8192k(ispdata),-(rsvd)"

#define XMK_STR(x)  #x
#define MK_STR(x)   XMK_STR(x)

#define CONFIG_EXTRA_ENV_SETTINGS       \
        "ubootfile=" MK_STR(CONFIG_UBOOTFILE) "\0"  \
        "ramdiskfile=" MK_STR(CONFIG_RAMDISKFILE) "\0"  \
        "update-U=tftpboot $(loadaddr) $(ubootfile); nand erase uboot; nand write.e $(loadaddr) uboot $(filesize)\0"    \
        "bootdevice=0\0"\
        "ramdiskaddr=0x50800000\0"\
        "bootpfile=bootpImage.ub\0"\
        "update-bootp1=tftpboot $(loadaddr) $(bootpfile); nand erase bootp1; nand write $(loadaddr) bootp1 $(filesize)\0" \
        "update-bootp2=tftpboot $(loadaddr) $(bootpfile); nand erase bootp2; nand write $(loadaddr) bootp2 $(filesize)\0" \
        "nandboot=nand read $(loadaddr) bootp1 1400000; bootm\0"\
        "mtdids=nand0=acti_nand\0"\
        "mtdparts=mtdparts=acti_nand:1024k(uboot),128k(uboot-env),11264k(config),20480k(bootp1),20480k(bootp2),1024k(ispconf1),1024k(ispconf2),8192k(ispdata),-(rsvd)\0"\
        "bootcmd=run nandboot\0"    \
        ""

/* the env ramboot=  */
#define CONFIG_RAMBOOTCOMMAND   \
    "a1tag;"\
    "tftpboot $(ramdiskaddr) $(ramdiskfile);"\
    "tftpboot 50008000 $(bootfile);"\
    "go 50008000"

#undef MK_STR
#undef XMK_STR

/**************************************** For NAND SPL use only **************************************/
#define CONFIG_NAND_U_BOOT  0

///* NAND chip page size        */
//#define CONFIG_SYS_NAND_PAGE_SIZE 2048
//#define CONFIG_SYS_NAND_PAGE_SPARE_SIZE   64
///* NAND chip block size       */
//#define CONFIG_SYS_NAND_BLOCK_SIZE    (128 * 1024)
///* NAND chip page per block count  */
//#define CONFIG_SYS_NAND_PAGE_COUNT    64
///* Location of the bad-block label */
//#define CONFIG_SYS_NAND_BAD_BLOCK_POS 0

//#define CONFIG_SYS_NAND_U_BOOT_OFFS       (2 << 10)   /* Place uboot at block#0, page#1 */
//#define CONFIG_SYS_NAND_U_BOOT_DST        0x50000000      // SPL
//#define CONFIG_SYS_NAND_U_BOOT_DST    CONFIG_SYS_SDRAM_BASE           // SPL
//#define CONFIG_SYS_NAND_U_BOOT_START  CONFIG_SYS_NAND_U_BOOT_DST      // SPL
//#define CONFIG_SYS_NAND_U_BOOT_SIZE       (512 << 10) /* Size of RAM U-Boot image */
/*****************************************************************************************************/

#ifdef CONFIG_ENV_IS_IN_NAND
#define CONFIG_ENV_OFFSET       SZ_1M
#endif

#define CONFIG_CMD_BOOTD    //boot, bootd support
#define CONFIG_AUTO_COMPLETE
#define CONFIG_CMD_NET
#define CONFIG_CMD_PING
#define CONFIG_AUTOSCRIPT   // auto script on after image loading or download
#define CONFIG_CMD_AUTOSCRIPT   // enable command "source" to run autoscript

#undef CONFIG_CMD_DATE      /* We don't have RTC, comment out cmd_date support */
#undef CONFIG_CMD_ITEST
#undef CONFIG_CMD_FAT       /* No FAT support */
#undef CONFIG_CMD_XIMG      /* cmd "imgxstract" */
#undef CONFIG_CMD_LOADS     /* cmd "loads"  */
#undef CONFIG_CMD_LOADB     /* cmd "loady loadb"    */
#undef CONFIG_CMD_CONSOLE   /* cmd "coninfo" */
#undef CONFIG_CMD_NFS       /* cmd "nfs"    */
#undef CONFIG_CMD_DHCP      /* cmd "dhcp"   */
#undef CONFIG_CMD_EDITENV

#define CONFIG_MMC
#define CONFIG_CMD_MMC
////#define CONFIG_GENERIC_MMC
#define CONFIG_CMD_FAT      /* cmd fat related support */
#define CONFIG_DOS_PARTITION
#define CONFIG_ACTI_A1_MMC

/**** Start: modified from SDB, added by Ted for HW test code, ****/
#define CONFIG_SDB_HAL      // added by Ted for SDB driver
#define CONFIG_CMD_VCAP     // added by Ted for VCAP test
#define CONFIG_CMD_AUDIO    // added by Ted for audi test
/**** End: modified from SDB ****/

////#define DEBUG
///* Turn off NOR flash support */
//#define CONFIG_SYS_NO_FLASH
//
//#ifdef CONFIG_SYS_NO_FLASH
//#undef CONFIG_CMD_FLASH
#undef CONFIG_CMD_IMLS
//#endif

//// Add CPU_Turbo && FCS support
#define CONFIG_CMD_FCS


#define CONFIG_CMD_JPEGENC
#define CONFIG_CMD_H264ENC
#define CONFIG_CMD_JPEGENC_SELFTEST
#define CONFIG_CMD_H264ENC_SELFTEST

#define CONFIG_CMD_JPEGDEC
#define CONFIG_CMD_H264DEC
#define CONFIG_CMD_MPEG4DEC
#define CONFIG_CMD_JPEGDEC_SELFTEST
#define CONFIG_CMD_H264DEC_SELFTEST
#define CONFIG_CMD_MPEG4DEC_SELFTEST

//// Add saveenv support
#define CONFIG_CMD_SAVEENV
//
#define CONFIG_SYS_ALT_MEMTEST


#define CONFIG_CMD_ACTI

// lwip support
//#define CONFIG_SYS_LWIP

// Extra features for A1 platform
#define CONFIG_HAVE_DMA_MEMPOOL
#ifdef CONFIG_HAVE_DMA_MEMPOOL
    #define DMA_MEMPOOL_START   0x57000000
    #define DMA_MEMPOOL_SIZE    0x4000000
#endif
//#define CONFIG_A1_H264_FRAMESERVER
#ifdef CONFIG_A1_H264_FRAMESERVER
    #define CONFIG_HAVE_JSON_C
#endif

/* Test for USB support */
//#define CONFIG_CMD_USB
//#define CONFIG_EHCI_DCACHE
//#define CONFIG_USB_STORAGE
//#define CONFIG_USB_EHCI
//#define CONFIG_USB_EHCI_ACTI

/*TFTP */
#define CONFIG_TFTP_PORT
#define CONFIG_TFTP_TSIZE
#define CONFIG_CMD_TFTPPUT

/* Support for dynamic part */
//// Add dynpart support
#define CONFIG_NAND_DYNPART
#define CFG_NAND_DYNPART_MTD_KERNEL_NAME    "acti_nand"

/* We need it to retrieve ethaddr from NAND */
#define BOARD_LATE_INIT

/* To suppress console info printing */
#define CONFIG_SYS_CONSOLE_INFO_QUIET

#define CONFIG_SERIAL_MULTI
//// Add env.oob support
#define CONFIG_ENV_OFFSET_OOB

/* Turn on DHCP command */
#define CONFIG_CMD_DHCP

/* turn off autoload */
#define CONFIG_SYS_AUTOLOAD "n"

/* to support random mac addr generation */
#define CONFIG_RANDOM_MAC

/*to support ping-pong boot mechanism*/
#define CONFIG_PINGPONG_BOOT
///////////////////////////////////////////
/* To init MT9P031_1080P_30FPS */
//#define MT9P031_1080P_30FPS

#endif  /* __CONFIG_H */
