/*
 * Copyright (C) 2002     Manuel Novoa III
 * Copyright (C) 2000-2005 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#include <linux/ctype.h>


int strncasecmp(const char *s1, const char *s2, unsigned int n)
{
    int r = 0;

    while ( n
			&& ((s1 == s2) ||
				!(r = ((int)(__tolower(*((unsigned char *)s1))))
					- __tolower(*((unsigned char *)s2))))
			&& (--n, ++s2, *s1++));
	return r;
}
