/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include "mempool.h"


int  mempool_initialize(struct mem_pool* mp,
						unsigned char* start, unsigned int size,
						unsigned int verbose)
{
	mp->verbose = verbose;

	mp->priv.top     = start;
	mp->priv.reserve = 0;

	mp->base = start;
	mp->maximumBytes = size;
	mp->remainingBytes = size;

	INIT_LIST_HEAD(&mp->allocated_blocks);
	INIT_LIST_HEAD(&mp->free_blocks);

	extern int linear_mempool_malloc(struct mem_pool* mp,
									 unsigned int size, void** heap);
	extern int linear_mempool_free(struct mem_pool* mp, void* heap);
	mp->new_heap  = linear_mempool_malloc;
	mp->free_heap = linear_mempool_free;

	return 0;
}

void mempool_destroy(struct mem_pool* mp)
{
	// Nothing to do at this moment
}
