/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <json.h>

#include <loggy.h>

#include "h264-coder.h"


extern void* dma_memory_calloc(unsigned int size, unsigned int number);
#define calloc dma_memory_calloc


static void _create_coder_opts_from_object(struct json_object* properties,
										   struct h264_coder_opts* options);


int h264_coder_opts_create_from_json(struct json_object* json,
									 struct h264_coder_opts* opts)
{
	struct json_object* properties;

	if (json == NULL || opts == NULL) return -1;

	properties = json_object_object_get(json, "encoders");
	if (properties != NULL &&
		json_object_get_type(properties) == json_type_array)
	{
		properties = json_object_array_get_idx(properties, 0);
	} else {
		properties = json;
	}

	h264_coder_opts_copy_default(opts);
	_create_coder_opts_from_object(properties, opts);

	return 0;
}

static void _read_int_property(struct json_object* obj, char* field, int* val)
{
	struct json_object* property;

	property = json_object_object_get(obj, field);
	if (property != NULL &&
		json_object_get_type(property) == json_type_int)
	{
		*val = json_object_get_int(property);
		//printf("Property: %s = %d\n", field, *val);
	}
}

/*
static void _copy_str_property(struct json_object* obj,
							   char* field, char* dest, size_t max)
{
	struct json_object* property;

	property = json_object_object_get(obj, field);
	if (property != NULL &&
		json_object_get_type(property) == json_type_string)
	{
		strncpy(dest,
				json_object_get_string(property), max);
		//printf("Property: %s = %s\n", field, dest);
	}
}
*/

static void _get_json_array(struct json_object* obj, char* field,
							struct json_object** array);

static void _read_int_array_property(struct json_object* properties,
									 char* field, int size, unsigned int** val)
{
	int i;
	unsigned int* table;
	struct json_object* array;

	_get_json_array(properties, field, &array);
	if (array == NULL) return;
	if (json_object_array_length(array) != size) return;

	table = (unsigned int*)calloc(size, sizeof(unsigned int));
	if (table == NULL) return;

	for (i = 0; i < size; ++i) {
		struct json_object* object = json_object_array_get_idx(array, i);
		table[i] = json_object_get_int(object);
	}

	*val = table;
}

static void _create_coder_opts_from_object(struct json_object* properties,
										   struct h264_coder_opts* options)
{
	if (properties == NULL) return;

	//_copy_str_property(properties, "input", options->input, 255);
	//_copy_str_property(properties, "output", options->output, 255);
	//_read_int_property(properties, "lastPic", &options->lastPic);
	_read_int_property(properties, "inputWidth", &options->inputWidth);
	_read_int_property(properties, "inputHeight", &options->inputHeight);
	_read_int_property(properties, "outputWidth", &options->outputWidth);
	_read_int_property(properties, "outputHeight", &options->outputHeight);
	_read_int_property(properties, "xOffset", &options->xOffset);
	_read_int_property(properties, "yOffset", &options->yOffset);
	_read_int_property(properties, "inputRateNumer", &options->inputRateNumer);
	_read_int_property(properties, "inputRateDenom", &options->inputRateDenom);
	_read_int_property(properties, "level", &options->level);
	_read_int_property(properties, "hrdConformance", &options->hrdConformance);
	_read_int_property(properties, "cpbSize", &options->cpbSize);
	_read_int_property(properties, "intraPicRate", &options->intraPicRate);
	_read_int_property(properties, "constIntraPred", &options->constIntraPred);
	_read_int_property(properties, "disableDeblocking", &options->disableDeblocking);
	_read_int_property(properties, "mbPerSlice", &options->mbPerSlice);
	_read_int_property(properties, "qpHdr", &options->qpHdr);
	_read_int_property(properties, "qpMin", &options->qpMin);
	_read_int_property(properties, "qpMax", &options->qpMax);
	_read_int_property(properties, "bitPerSecond", &options->bitPerSecond);
	_read_int_property(properties, "picRc", &options->picRc);
	_read_int_property(properties, "mbRc", &options->mbRc);
	_read_int_property(properties, "picSkip", &options->picSkip);
	_read_int_property(properties, "rotation", &options->rotation);
	_read_int_property(properties, "inputFormat", &options->inputFormat);
	_read_int_property(properties, "chromaQpOffset", &options->chromaQpOffset);
	_read_int_property(properties, "trans8x8", &options->trans8x8);
	_read_int_property(properties, "enableCabac", &options->enableCabac);
	_read_int_property(properties, "cabacInitIdc", &options->cabacInitIdc);
	_read_int_property(properties, "quarterPixelMv", &options->quarterPixelMv);
	_read_int_property(properties, "sei", &options->sei);
	_read_int_property(properties, "byteStream", &options->byteStream);
	_read_int_property(properties, "videoStab", &options->videoStab);
	_read_int_property(properties, "intraQpDelta", &options->intraQpDelta);
	_read_int_property(properties, "fixedIntraQp", &options->fixedIntraQp);
	_read_int_property(properties, "mbQpAdjustment", &options->mbQpAdjustment);
	_read_int_property(properties, "mvOutput", &options->mvOutput);

	_read_int_array_property(properties, "intraPrevFavor",
							 52, &options->intraPrevFavor);
	_read_int_array_property(properties, "intra16Favor",
							 52, &options->intra16Favor);
	_read_int_array_property(properties, "interFavor",
							 52, &options->interFavor);
	_read_int_array_property(properties, "skipSadPenalty",
							 52, &options->skipSadPenalty);
	_read_int_array_property(properties, "diffMvPenalty",
							 52, &options->diffMvPenalty);
	_read_int_array_property(properties, "diffMvPenalty4p",
							 52, &options->diffMvPenalty4p);

	_read_int_property(properties, "attachParameterSet",
					   &options->attachParameterSet);
}

void h264_coder_opts_print(struct h264_coder_opts* options)
{
	//log4c_category_t* logger;
	//logger = log4c_category_get("com.acti.recoder.h264.options");
	unsigned int logger = VERBOSE_LEVEL_DEBUG;

	LOGGY_DEBUG(logger,
				"\nOptions of coder =\n"
				//"\tlastPic: %d\n"
				"\tinputWidth: %d\n"
				"\tinputHeight: %d\n"
				"\toutputWidth: %d\n"
				"\toutputHeight: %d\n"
				"\txOffset: %d\n"
				"\tyOffset: %d\n"
				"\tinputRateNumer: %d\n"
				"\tinputRateDenom: %d\n"
				"\tlevel: %d\n"
				"\thrdConformance: %d\n"
				"\tcpbSize: %d\n"
				"\tintraPicRate: %d\n"
				"\tconstIntraPred: %d\n"
				"\tdisableDeblocking: %d\n"
				"\tmbPerSlice: %d\n"
				"\tqpHdr: %d\n"
				"\tqpMin: %d\n"
				"\tqpMax: %d\n"
				"\tbitPerSecond: %d\n"
				"\tpicRc: %d\n"
				"\tmbRc: %d\n"
				"\tpicSkip: %d\n"
				"\trotation: %d\n"
				"\tchromaQpOffset: %d\n"
				"\ttrans8x8: %d\n"
				"\tenableCabac: %d\n"
				"\tcabacInitIdc: %d\n"
				"\tquarterPixelMv: %d\n"
				"\tsei: %d\n"
				"\tbyteStream: %d\n"
				"\tvideoStab: %d\n"
				"\tintraQpDelta: %d\n"
				"\tfixedIntraQp: %d\n"
				"\tmbQpAdjustment: %d\n"
				"\tmvOutput: %d\n"
				"\tattachParameterSet: %d\n",
				//options->lastPic,
				options->inputWidth,
				options->inputHeight,
				options->outputWidth,
				options->outputHeight,
				options->xOffset,
				options->yOffset,
				options->inputRateNumer,
				options->inputRateDenom,
				options->level,
				options->hrdConformance,
				options->cpbSize,
				options->intraPicRate,
				options->constIntraPred,
				options->disableDeblocking,
				options->mbPerSlice,
				options->qpHdr,
				options->qpMin,
				options->qpMax,
				options->bitPerSecond,
				options->picRc,
				options->mbRc,
				options->picSkip,
				options->rotation,
				options->chromaQpOffset,
				options->trans8x8,
				options->enableCabac,
				options->cabacInitIdc,
				options->quarterPixelMv,
				options->sei,
				options->byteStream,
				options->videoStab,
				options->intraQpDelta,
				options->fixedIntraQp,
				options->mbQpAdjustment,
				options->mvOutput,
				options->attachParameterSet);

	if (options->intraPrevFavor != NULL) {
		LOGGY_DEBUG(logger,
					"\nUsing custom Intra Prediction Previous 4x4 Mode Favor:\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u\n",
					options->intraPrevFavor[0], options->intraPrevFavor[1],
					options->intraPrevFavor[2], options->intraPrevFavor[3],
					options->intraPrevFavor[4], options->intraPrevFavor[5],
					options->intraPrevFavor[6], options->intraPrevFavor[7],
					options->intraPrevFavor[8], options->intraPrevFavor[9],
					options->intraPrevFavor[10], options->intraPrevFavor[11],
					options->intraPrevFavor[12], options->intraPrevFavor[13],
					options->intraPrevFavor[14], options->intraPrevFavor[15],
					options->intraPrevFavor[16], options->intraPrevFavor[17],
					options->intraPrevFavor[18], options->intraPrevFavor[19],
					options->intraPrevFavor[20], options->intraPrevFavor[21],
					options->intraPrevFavor[22], options->intraPrevFavor[23],
					options->intraPrevFavor[24], options->intraPrevFavor[25],
					options->intraPrevFavor[26], options->intraPrevFavor[27],
					options->intraPrevFavor[28], options->intraPrevFavor[29],
					options->intraPrevFavor[30], options->intraPrevFavor[31],
					options->intraPrevFavor[32], options->intraPrevFavor[33],
					options->intraPrevFavor[34], options->intraPrevFavor[35],
					options->intraPrevFavor[36], options->intraPrevFavor[37],
					options->intraPrevFavor[38], options->intraPrevFavor[39],
					options->intraPrevFavor[40], options->intraPrevFavor[41],
					options->intraPrevFavor[42], options->intraPrevFavor[43],
					options->intraPrevFavor[44], options->intraPrevFavor[45],
					options->intraPrevFavor[46], options->intraPrevFavor[47],
					options->intraPrevFavor[48], options->intraPrevFavor[49],
					options->intraPrevFavor[50], options->intraPrevFavor[51]);
	} else {
		LOGGY_DEBUG(logger,
					"Using default Intra Prediction Previous 4x4 Mode Favor\n");
	}

	if (options->intra16Favor != NULL) {
		LOGGY_DEBUG(logger,
					"\nUsing custom Intra Prediction Intra 16x16 Mode Favor:\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u\n",
					options->intra16Favor[0], options->intra16Favor[1],
					options->intra16Favor[2], options->intra16Favor[3],
					options->intra16Favor[4], options->intra16Favor[5],
					options->intra16Favor[6], options->intra16Favor[7],
					options->intra16Favor[8], options->intra16Favor[9],
					options->intra16Favor[10], options->intra16Favor[11],
					options->intra16Favor[12], options->intra16Favor[13],
					options->intra16Favor[14], options->intra16Favor[15],
					options->intra16Favor[16], options->intra16Favor[17],
					options->intra16Favor[18], options->intra16Favor[19],
					options->intra16Favor[20], options->intra16Favor[21],
					options->intra16Favor[22], options->intra16Favor[23],
					options->intra16Favor[24], options->intra16Favor[25],
					options->intra16Favor[26], options->intra16Favor[27],
					options->intra16Favor[28], options->intra16Favor[29],
					options->intra16Favor[30], options->intra16Favor[31],
					options->intra16Favor[32], options->intra16Favor[33],
					options->intra16Favor[34], options->intra16Favor[35],
					options->intra16Favor[36], options->intra16Favor[37],
					options->intra16Favor[38], options->intra16Favor[39],
					options->intra16Favor[40], options->intra16Favor[41],
					options->intra16Favor[42], options->intra16Favor[43],
					options->intra16Favor[44], options->intra16Favor[45],
					options->intra16Favor[46], options->intra16Favor[47],
					options->intra16Favor[48], options->intra16Favor[49],
					options->intra16Favor[50], options->intra16Favor[51]);
	} else {
		LOGGY_DEBUG(logger,
					"Using default Intra Prediction Intra 16x16 Mode Favor\n");
	}

	if (options->interFavor != NULL) {
		LOGGY_DEBUG(logger,
					"\nUsing custom Inter MB Mode Favor:\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u\n",
					options->interFavor[0], options->interFavor[1],
					options->interFavor[2], options->interFavor[3],
					options->interFavor[4], options->interFavor[5],
					options->interFavor[6], options->interFavor[7],
					options->interFavor[8], options->interFavor[9],
					options->interFavor[10], options->interFavor[11],
					options->interFavor[12], options->interFavor[13],
					options->interFavor[14], options->interFavor[15],
					options->interFavor[16], options->interFavor[17],
					options->interFavor[18], options->interFavor[19],
					options->interFavor[20], options->interFavor[21],
					options->interFavor[22], options->interFavor[23],
					options->interFavor[24], options->interFavor[25],
					options->interFavor[26], options->interFavor[27],
					options->interFavor[28], options->interFavor[29],
					options->interFavor[30], options->interFavor[31],
					options->interFavor[32], options->interFavor[33],
					options->interFavor[34], options->interFavor[35],
					options->interFavor[36], options->interFavor[37],
					options->interFavor[38], options->interFavor[39],
					options->interFavor[40], options->interFavor[41],
					options->interFavor[42], options->interFavor[43],
					options->interFavor[44], options->interFavor[45],
					options->interFavor[46], options->interFavor[47],
					options->interFavor[48], options->interFavor[49],
					options->interFavor[50], options->interFavor[51]);
	} else {
		LOGGY_DEBUG(logger, "Using default Inter MB Mode Favor\n");
	}

	if (options->skipSadPenalty != NULL) {
		LOGGY_DEBUG(logger,
					"\nUsing custom Skip Macroblock Mode Penalty:\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u\n",
					options->skipSadPenalty[0], options->skipSadPenalty[1],
					options->skipSadPenalty[2], options->skipSadPenalty[3],
					options->skipSadPenalty[4], options->skipSadPenalty[5],
					options->skipSadPenalty[6], options->skipSadPenalty[7],
					options->skipSadPenalty[8], options->skipSadPenalty[9],
					options->skipSadPenalty[10], options->skipSadPenalty[11],
					options->skipSadPenalty[12], options->skipSadPenalty[13],
					options->skipSadPenalty[14], options->skipSadPenalty[15],
					options->skipSadPenalty[16], options->skipSadPenalty[17],
					options->skipSadPenalty[18], options->skipSadPenalty[19],
					options->skipSadPenalty[20], options->skipSadPenalty[21],
					options->skipSadPenalty[22], options->skipSadPenalty[23],
					options->skipSadPenalty[24], options->skipSadPenalty[25],
					options->skipSadPenalty[26], options->skipSadPenalty[27],
					options->skipSadPenalty[28], options->skipSadPenalty[29],
					options->skipSadPenalty[30], options->skipSadPenalty[31],
					options->skipSadPenalty[32], options->skipSadPenalty[33],
					options->skipSadPenalty[34], options->skipSadPenalty[35],
					options->skipSadPenalty[36], options->skipSadPenalty[37],
					options->skipSadPenalty[38], options->skipSadPenalty[39],
					options->skipSadPenalty[40], options->skipSadPenalty[41],
					options->skipSadPenalty[42], options->skipSadPenalty[43],
					options->skipSadPenalty[44], options->skipSadPenalty[45],
					options->skipSadPenalty[46], options->skipSadPenalty[47],
					options->skipSadPenalty[48], options->skipSadPenalty[49],
					options->skipSadPenalty[50], options->skipSadPenalty[51]);
	} else {
		LOGGY_DEBUG(logger,
					"Using default Skip Macroblock Mode Penalty\n");
	}

	if (options->diffMvPenalty != NULL) {
		LOGGY_DEBUG(logger,
					"\nUsing custom Differential MV Penalty for 1p/qp ME:\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u\n",
					options->diffMvPenalty[0], options->diffMvPenalty[1],
					options->diffMvPenalty[2], options->diffMvPenalty[3],
					options->diffMvPenalty[4], options->diffMvPenalty[5],
					options->diffMvPenalty[6], options->diffMvPenalty[7],
					options->diffMvPenalty[8], options->diffMvPenalty[9],
					options->diffMvPenalty[10], options->diffMvPenalty[11],
					options->diffMvPenalty[12], options->diffMvPenalty[13],
					options->diffMvPenalty[14], options->diffMvPenalty[15],
					options->diffMvPenalty[16], options->diffMvPenalty[17],
					options->diffMvPenalty[18], options->diffMvPenalty[19],
					options->diffMvPenalty[20], options->diffMvPenalty[21],
					options->diffMvPenalty[22], options->diffMvPenalty[23],
					options->diffMvPenalty[24], options->diffMvPenalty[25],
					options->diffMvPenalty[26], options->diffMvPenalty[27],
					options->diffMvPenalty[28], options->diffMvPenalty[29],
					options->diffMvPenalty[30], options->diffMvPenalty[31],
					options->diffMvPenalty[32], options->diffMvPenalty[33],
					options->diffMvPenalty[34], options->diffMvPenalty[35],
					options->diffMvPenalty[36], options->diffMvPenalty[37],
					options->diffMvPenalty[38], options->diffMvPenalty[39],
					options->diffMvPenalty[40], options->diffMvPenalty[41],
					options->diffMvPenalty[42], options->diffMvPenalty[43],
					options->diffMvPenalty[44], options->diffMvPenalty[45],
					options->diffMvPenalty[46], options->diffMvPenalty[47],
					options->diffMvPenalty[48], options->diffMvPenalty[49],
					options->diffMvPenalty[50], options->diffMvPenalty[51]);
	} else {
		LOGGY_DEBUG(logger,
					"Using default Differential MV Penalty for 1p/qp ME\n");
	}

	if (options->diffMvPenalty4p != NULL) {
		LOGGY_DEBUG(logger,
					"\nUsing custom Differential MV Penalty for 4p ME:\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u, %u, %u, %u, %u, %u, %u, %u, %u,\n"
					"\t%u, %u\n",
					options->diffMvPenalty4p[0], options->diffMvPenalty4p[1],
					options->diffMvPenalty4p[2], options->diffMvPenalty4p[3],
					options->diffMvPenalty4p[4], options->diffMvPenalty4p[5],
					options->diffMvPenalty4p[6], options->diffMvPenalty4p[7],
					options->diffMvPenalty4p[8], options->diffMvPenalty4p[9],
					options->diffMvPenalty4p[10], options->diffMvPenalty4p[11],
					options->diffMvPenalty4p[12], options->diffMvPenalty4p[13],
					options->diffMvPenalty4p[14], options->diffMvPenalty4p[15],
					options->diffMvPenalty4p[16], options->diffMvPenalty4p[17],
					options->diffMvPenalty4p[18], options->diffMvPenalty4p[19],
					options->diffMvPenalty4p[20], options->diffMvPenalty4p[21],
					options->diffMvPenalty4p[22], options->diffMvPenalty4p[23],
					options->diffMvPenalty4p[24], options->diffMvPenalty4p[25],
					options->diffMvPenalty4p[26], options->diffMvPenalty4p[27],
					options->diffMvPenalty4p[28], options->diffMvPenalty4p[29],
					options->diffMvPenalty4p[30], options->diffMvPenalty4p[31],
					options->diffMvPenalty4p[32], options->diffMvPenalty4p[33],
					options->diffMvPenalty4p[34], options->diffMvPenalty4p[35],
					options->diffMvPenalty4p[36], options->diffMvPenalty4p[37],
					options->diffMvPenalty4p[38], options->diffMvPenalty4p[39],
					options->diffMvPenalty4p[40], options->diffMvPenalty4p[41],
					options->diffMvPenalty4p[42], options->diffMvPenalty4p[43],
					options->diffMvPenalty4p[44], options->diffMvPenalty4p[45],
					options->diffMvPenalty4p[46], options->diffMvPenalty4p[47],
					options->diffMvPenalty4p[48], options->diffMvPenalty4p[49],
					options->diffMvPenalty4p[50], options->diffMvPenalty4p[51]);
	} else {
		LOGGY_DEBUG(logger,
					"Using default Differential MV Penalty for 4p ME\n");
	}
}

/*
void h264_coder_md_print(int index, struct md_area* area)
{
	log4c_category_t* logger;

	logger = log4c_category_get("com.acti.recoder.h264.options");

	log4c_category_log(logger, LOG4C_PRIORITY_DEBUG,
					   "\nMotion detection[%d]:\n"
					   "enabled: %d\n"
					   "threshold: %d\n"
					   "sensitivity: %d\n"
					   "x: %d\n"
					   "y: %d\n"
					   "w: %d\n"
					   "h: %d\n",
					   area->index,
					   area->enabled,
					   area->threshold,
					   area->sensitivity,
					   area->x,
					   area->y,
					   area->w,
					   area->h);
}

void h264_md_area_create_from_json(int index, struct json_object* properties,
								   struct md_area* area)
{
	struct json_object* child;
	struct json_object* field;

	area->index = index;
	area->enabled = 0;

	child = json_object_object_get(properties, "motionDections");
	if (child == NULL) return;

	child = json_object_array_get_idx(child, index);
	if (child == NULL) return;

	_read_int_property(child, "enabled", &area->enabled);
	_read_int_property(child, "threshold", &area->threshold);
	_read_int_property(child, "sensitivity", &area->sensitivity);
	_read_int_property(child, "x", &area->x);
	_read_int_property(child, "y", &area->y);
	_read_int_property(child, "w", &area->w);
	_read_int_property(child, "h", &area->h);
}
*/

static void _get_json_array(struct json_object* obj, char* field,
							struct json_object** array)
{
	//log4c_category_t* logger;
	struct json_object* property;

	//logger = log4c_category_get("com.acti.json.helper");

	property = json_object_object_get(obj, field);
	if (property != NULL &&
		json_object_get_type(property) == json_type_array)
	{
		*array = property;
		//return 0;
	} else {
		*array = NULL;
	}

	//log4c_category_debug(logger,
	//					 "Property(%s) doesn't exist or belong to array");

	//return -1;
}

static void _read_uchar_property(struct json_object* obj, char* field,
								 unsigned char* val)
{
	//log4c_category_t* logger;
	struct json_object* property;

	//logger = log4c_category_get("com.acti.json.helper");

	property = json_object_object_get(obj, field);
	if (property != NULL &&
		json_object_get_type(property) == json_type_int)
	{
		*val = (unsigned char)json_object_get_int(property);
		//return 0;
	}

	//log4c_category_debug(logger,
	//					 "Property(%s) doesn't exist or belong to unsigned char");

	//return -1;
}

/*
int h264_mdtr_create_from_json(struct json_object* properties,
							   struct hx8290_h264_mdtr** mdtrs,
							   int* count)
{
	int i;
	int rc = -1;
	struct json_object* array;
	struct json_object* object;

	int frameWidth;
	int frameHeight;
	int wndX;
	int wndY;
	int wndWidth;
	int wndHeight;
	unsigned char threshold;
	unsigned char sensitivity;

	frameWidth = 0; frameHeight = 0;
	_read_int_property(properties, "outputWidth", &frameWidth);
	_read_int_property(properties, "outputHeight", &frameHeight);

	_get_json_array(properties, "motionDections", &array);
	if (array == NULL) return 0;
	if (json_object_array_length(array) == 0) return 0;

	*count = json_object_array_length(array);
	*mdtrs = (struct hx8290_h264_mdtr*)calloc(*count, sizeof(*mdtrs));
	if (*mdtrs == NULL) return -1;

	for (i = 0; i < json_object_array_length(array); ++i) {
		object = json_object_array_get_idx(array, i);

		wndX = 0; wndY = 0;
		wndWidth = 0; wndHeight = 0;
		threshold = 0; sensitivity = 0;

		_read_uchar_property(object, "threshold", &threshold);
		_read_uchar_property(object, "sensitivity", &sensitivity);
		_read_int_property(object, "x", &wndX);
		_read_int_property(object, "y", &wndY);
		_read_int_property(object, "w", &wndWidth);
		_read_int_property(object, "h", &wndHeight);

		mdtrs[i] = hx8290_h264_mdtr_new(frameWidth, frameHeight,
										wndX, wndY,
										wndWidth, wndHeight,
										threshold, sensitivity);
		if (mdtrs[i] == NULL) { rc = -1; break; }

		rc = hx8290_h264_mdtr_add_filter(mdtrs[i], "window-copier");
		if (rc != 0) break;

		rc = hx8290_h264_mdtr_add_filter(mdtrs[i], "window-threshold-filter");
		if (rc != 0) break;

		rc = hx8290_h264_mdtr_add_filter(mdtrs[i], "window-local-value-filter");
	}

	return rc;
}

void h264_mdtr_print(struct hx8290_h264_mdtr** mdtrs, int count)
{
	int i;
	struct hx8290_h264_mdtr* mdtr;

	log4c_category_t* logger;

	logger = log4c_category_get("com.acti.recoder.h264.options");

	for (i = 0; i < count; ++i) {
		mdtr = mdtrs[i];

		log4c_category_log(logger, LOG4C_PRIORITY_DEBUG,
						   "\nProperties of motion detector:\n"
						   "\tframe width: %d\n"
						   "\tframe height: %d\n"
						   "\twindow x: %d\n"
						   "\twindow y: %d\n"
						   "\twindow width: %d\n"
						   "\twindow height: %d\n"
						   "\tthreshold: %u\n"
						   "\tsensitivity: %u",
						   mdtr->frameWidth, mdtr->frameHeight,
						   mdtr->x, mdtr->y,
						   mdtr->windowWidth, mdtr->windowHeight,
						   mdtr->threshold, mdtr->sensitivity);
	}
}
*/
