/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

//#include <string.h>
#include <common.h>

#include "h264-coder.h"


static struct h264_coder_opts _prototype =
{
	//input:  { 0 },
	//output: { 0 },
	//lastPic: 100,
	inputWidth: H264_CODER_DEFAULT,
	inputHeight: H264_CODER_DEFAULT,
	outputWidth: H264_CODER_DEFAULT,
	outputHeight: H264_CODER_DEFAULT,
	xOffset: 0,
	yOffset: 0,
	inputRateNumer: 30,
	inputRateDenom: 1,
	level: 40,
	hrdConformance: 0,
	cpbSize: H264_CODER_DEFAULT,
	intraPicRate: 30,
	constIntraPred: 0,
	disableDeblocking: 0,
	mbPerSlice: 0,
	qpHdr: 26,
	qpMin: 10,
	qpMax: 51,
	bitPerSecond: 1000000,
	picRc: 1,
	mbRc: 1,
	picSkip: 0,
	rotation: 0,
	inputFormat: H264ENC_YUV420_PLANAR,
	chromaQpOffset: 2,
	trans8x8: 0,
	enableCabac: 0,
	cabacInitIdc :0,
	quarterPixelMv: H264_CODER_DEFAULT,
	sei: 0,
	byteStream: 1,
	videoStab: 0,
	intraQpDelta: -3,
	fixedIntraQp: 0,
	mbQpAdjustment: 0,
	mvOutput: 0,
	intraPrevFavor: NULL,
	intra16Favor: NULL,
	interFavor: NULL,
	skipSadPenalty: NULL,
	diffMvPenalty: NULL,
	diffMvPenalty4p: NULL,
	attachParameterSet: 0,
};


void h264_coder_opts_copy_default(struct h264_coder_opts* opts)
{
	if (opts == NULL) return;

	memcpy(opts, &_prototype, sizeof(_prototype));
}
