/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <config.h>

#include <loggy.h>
#include <mempool.h>


//extern void printf(const char *fmt, ...);


enum {
	MEMPOOL_START_ADDR = DMA_MEMPOOL_START,
	MAX_MEMPOOL_SIZE   = DMA_MEMPOOL_SIZE,
	MEMPOOL_END_ADDR   = MEMPOOL_START_ADDR + MAX_MEMPOOL_SIZE,
};


static struct mem_pool* _mp = NULL;
static struct mem_pool  _mp_storage;


void* memory_set(void *p, int c, unsigned int n);
void* memory_copy(void *dst, const void *src, unsigned int n);


void dma_memorypool_reset(void)
{
	mempool_initialize(&_mp_storage,
					   (unsigned char*)MEMPOOL_START_ADDR,
					   MAX_MEMPOOL_SIZE,
					   VERBOSE_LEVEL_NONE);
//					   VERBOSE_LEVEL_ERROR);
	_mp = &_mp_storage;
}

void dma_pool_info(void)
{
	struct list_head* pos;
	struct mem_block* entry;

	printf("\nAllocated blocks:\n");
	if (!list_empty(&_mp->allocated_blocks)) {
		list_for_each(pos, &_mp->allocated_blocks) {
			entry = list_entry(pos, struct mem_block, list);
			printf("\t[%u]: 0x%08x/%u\n",
				   entry->id, (unsigned int)entry, entry->size);
		}
	} else {
		printf("\tNone\n");
	}

	printf("Free blocks:\n");
	if (!list_empty(&_mp->free_blocks)) {
		list_for_each(pos, &_mp->free_blocks) {
			entry = list_entry(pos, struct mem_block, list);
			printf("\t[%u]: 0x%08x/%u\n",
				   entry->id, (unsigned int)entry, entry->size);
		}
	} else {
		printf("\tNone\n");
	}
}

void* dma_memory_alloc(unsigned int size)
{
	void* block = NULL;

	if (_mp == NULL) {
		dma_memorypool_reset();
	}

	if (_mp->new_heap(_mp, size, &block) != 0) {
		printf("dma_memory_alloc: "
			   "Failed to allocate DMA block(%u bytes)\n", size);
	}

	return block;
}

extern unsigned int strlen(const char* s);
extern char* strcpy(char* dest, const char* src);

char* dma_memory_strdup(const char* s)
{
	char* new;

	if ((s == NULL)	||
	    ((new = dma_memory_alloc(strlen(s) + 1)) == NULL) ) {
		return NULL;
	}

	strcpy(new, s);

	return new;
}

void* dma_memory_calloc(unsigned int size, unsigned int number)
{
	unsigned char* block;

	block = dma_memory_alloc(size * number);
	if (block == NULL) return NULL;
	memory_set(block, 0, size * number);

	return block;
}

void dma_memory_free(void* ptr)
{
	if (ptr == NULL) return;

	if (_mp == NULL) {
		printf("dma_memory_free: Memory pool is not initialized yet!?\n");
		return;
	}

	_mp->free_heap(_mp, ptr);
}

void* memory_set(void *p, int c, unsigned int n)
{
	char* pb = (char*)p;
	char* pbend = pb + n;

	while (pb != pbend) *pb++ = c;

	return p;
}

void* memory_copy(void *dst, const void *src, unsigned int n)
{
	void* ret = dst;

	while (n--) {
		*(char*)dst = *(char*)src;
		dst = (char*)dst + 1;
		src = (char*)src + 1;
	}

	return ret;
}

/*
static unsigned char* _pool = (void*)MEMPOOL_START_ADDR;
static unsigned char* _heap = NULL;
static unsigned int   _used = 0;


void dma_pool_info()
{
	extern void printf(const char *fmt, ...);

	printf("\nDMA memory pool information:\n");
	printf("Start address: 0x%08x\n", MEMPOOL_START_ADDR);
	printf("Maximum size:  0x%08x\n", MAX_MEMPOOL_SIZE);
}

void dma_memorypool_reset()
{
	_heap = NULL;
	_used = 0;
}

void* dma_memory_alloc(unsigned int size)
{
	unsigned char* block;

	if (_heap == NULL) {
		_heap = _pool;
		_used = 0;
	}

	if (_used + size + 0xff > MAX_MEMPOOL_SIZE) return NULL;

	block = _heap;
	_heap += size + 0xff;
	_used += size + 0xff;

	block = (unsigned char*)(((unsigned int)block + 0xff) & ~0xff);

	return block;
}

void* memory_set(void *p, int c, unsigned int n);

void* dma_memory_calloc(unsigned int size, unsigned int number)
{
	unsigned char* block;

	block = dma_memory_alloc(size * number);
	if (block == NULL) return NULL;
	memory_set(block, 0, size * number);

	return block;
}

void dma_memory_free(void* ptr)
{
}

void* memory_set(void *p, int c, unsigned int n)
{
	char* pb = (char*)p;
	char* pbend = pb + n;

	while (pb != pbend) *pb++ = c;

	return p;
}

void* memory_copy(void *dst, const void *src, unsigned int n)
{
	void* ret = dst;

	while (n--) {
		*(char*)dst = *(char*)src;
		dst = (char*)dst + 1;
		src = (char*)src + 1;
	}

	return ret;
}
*/
