#ifndef _HALVCAP_H_ 
#define _HALVCAP_H_

#define HAL_REG_VCAP_BASE                   0x90B00000
#define HAL_REG_VCAP_SYS_CTRL	            	(HAL_REG_VCAP_BASE + 0x0000)
#define HAL_REG_VCAP_CAP_CTRL               (HAL_REG_VCAP_BASE + 0x0004)
#define HAL_REG_VCAP_REG_UPDATE             (HAL_REG_VCAP_BASE + 0x0008)

#define HAL_REG_VCAP_INT_STS                (HAL_REG_VCAP_BASE + 0x0100)
#define HAL_REG_VCAP_INT_STS_CLR            (HAL_REG_VCAP_BASE + 0x0104)
#define HAL_REG_VCAP_INT_STS_RAW            (HAL_REG_VCAP_BASE + 0x0108)
#define HAL_REG_VCAP_INT_MASK_STS           (HAL_REG_VCAP_BASE + 0x010C)
#define HAL_REG_VCAP_INT_MASK_SET           (HAL_REG_VCAP_BASE + 0x0110)
#define HAL_REG_VCAP_INT_MASK_CLR           (HAL_REG_VCAP_BASE + 0x0114)
#define HAL_REG_VCAP_INT_PRI                (HAL_REG_VCAP_BASE + 0x0118)

#define HAL_REG_VCAP_SRC_VIF                (HAL_REG_VCAP_BASE + 0x0200)
#define HAL_REG_VCAP_SRC_SIZE               (HAL_REG_VCAP_BASE + 0x0204)
#define HAL_REG_VCAP_SRC_START              (HAL_REG_VCAP_BASE + 0x0208)
#define HAL_REG_VCAP_SRC_BLANK              (HAL_REG_VCAP_BASE + 0x020C)
#define HAL_REG_VCAP_VIF_EN	              (HAL_REG_VCAP_BASE + 0x0210)
#define HAL_REG_VCAP_SRC_CH_ID   	       (HAL_REG_VCAP_BASE + 0x0214)

#define HAL_REG_VCAP_CHm_VIF_STS(chn)       (HAL_REG_VCAP_BASE + 0x0224 + 0x04 * chn)


#define HAL_REG_VCAP_SRC_CLIP_CTRL          (HAL_REG_VCAP_BASE + 0x0300)
#define HAL_REG_VCAP_SRC_CLIP_START         (HAL_REG_VCAP_BASE + 0x0304)
#define HAL_REG_VCAP_SRC_CLIP_SIZE          (HAL_REG_VCAP_BASE + 0x0308)
 
#define HAL_REG_VCAP_CHm_CROP_OFFSET(chn)   (HAL_REG_VCAP_BASE + 0x0390 + 0x04 * chn)
#define HAL_REG_VCAP_CHm_CROP_SIZE(chn)     (HAL_REG_VCAP_BASE + 0x0380 + 0x04 * chn)

#define HAL_REG_VCAP_VLB_CTRL               (HAL_REG_VCAP_BASE + 0x0400)

/* chn : channel id */
#define HAL_REG_VCAP_CHm_DMA(chn)           (HAL_REG_VCAP_BASE + 0x0C00 + 0x04 * chn)

/* chn : channel id, fb : frame buffer id */
#define HAL_REG_VCAP_CHm_FBn_DESTY(chn,fb)  (HAL_REG_VCAP_BASE + 0x0C10 + 0x20 * chn + 0x04 * fb)
#define HAL_REG_VCAP_CHm_FBn_DESTC(chn,fb)  (HAL_REG_VCAP_BASE + 0x0C20 + 0x20 * chn + 0x04 * fb)

#define HAL_REG_VCAP_CHm_DEST_OWN(chn)      (HAL_REG_VCAP_BASE + 0x0C90 + 0x04 * chn)
#define HAL_REG_VCAP_CH0_DEST_OWN           HAL_REG_VCAP_CHm_DEST_OWN(0)
#define HAL_REG_VCAP_CH1_DEST_OWN           HAL_REG_VCAP_CHm_DEST_OWN(1)
#define HAL_REG_VCAP_CH2_DEST_OWN           HAL_REG_VCAP_CHm_DEST_OWN(2)
#define HAL_REG_VCAP_CH3_DEST_OWN           HAL_REG_VCAP_CHm_DEST_OWN(3)

extern int vcap_reset(void);
extern void cap_ctrl(unsigned short on_off);

/* For SRC_IF */

#define HV_ACTIVE_MODE 0x01 /* H/V active mode (progressive only) */

enum
{
	PROGRESSIVE = 0, /* Progressive format */
	INTERLACED,
};

enum
{
	INTERLEAVED = 0, 
	PARAL,
};

typedef enum 
{
	FB0 = 0,
	FB1,
	FB2,
	FB3
} fb_id_t;

typedef enum 
{
	CH0 = 0,
	CH1,
	CH2,
	CH3
} ch_id_t;

typedef struct src_if_s
{
	unsigned int vif_mode : 3;
	unsigned int reserved0:1;
	unsigned int vif_link_paral : 1;
	unsigned int vif_link_swap : 1;
	unsigned int vif_blank_chk : 1;
	unsigned int vif_ccir_ec : 1;
	unsigned int vif_vref_pol : 1;
	unsigned int vif_href_pol : 1;
	unsigned int vif_isp_gated : 1;
	unsigned int vif_ccir_chid : 1;
	unsigned int vif_pxl_swap : 2;
	unsigned int vif_ccir_skip : 2;
	unsigned int vif_en : 4;
	unsigned int vif_spare0 : 1;
	unsigned int vif_spare1 : 1;
	unsigned int vif_spare2 : 1;
	unsigned int vif_spare3 : 1;
	unsigned int vif_disglitch : 1;
	unsigned int vif_hact_min_mode : 1;
	unsigned int vif_vact_min_mode : 1;
	unsigned int vif_spare4 : 1;
	unsigned int vif_err_disable : 4;
} src_if_t; 

extern void set_src_if(src_if_t src_if);

/* SRC_SIZE */
typedef struct src_size_s
{
	unsigned int src_w : 13;
	unsigned int reserved1 : 3;
	unsigned int src_h : 13;
	unsigned int reserved2 : 3;
} src_size_t;

extern void set_src_size(src_size_t src_size);

/* SRC_START */
typedef struct src_start_s
{
	unsigned int src_hstart : 13;
	unsigned int reserved1 : 3;
	unsigned int src_vstart : 13;
	unsigned int reserved2 : 3;
} src_start_t;

extern void set_src_start(src_start_t src_start);

/* CLIP_SIZE */
typedef struct clip_size_s
{
	unsigned int swc_w : 12;
	unsigned int reserved1 : 4;
	unsigned int swc_h : 12;
	unsigned int reserved2 : 4;
} clip_size_t;

extern void set_clip_size(clip_size_t clip_size);

/* CLIP_START */
typedef struct clip_start_s
{
	unsigned int swc_x : 12;
	unsigned int reserved1 : 4;
	unsigned int swc_y : 12;
	unsigned int reserved2 : 4;
} clip_start_t;

extern void set_clip_start(clip_start_t clip_start);

/* CROP_SIZE */
typedef struct crop_size_s
{
	unsigned int crop_w : 12;
	unsigned int reserved1 : 4;
	unsigned int crop_h : 12;
	unsigned int reserved2 : 4;
} crop_size_t;

extern void set_crop_size(ch_id_t chn, crop_size_t crop_size);

/* CROP_OFFSET */
typedef struct crop_offset_s
{
	unsigned int crop_x : 13;
	unsigned int reserved1 : 3;
	unsigned int crop_y : 13;
	unsigned int reserved2 : 3;
} crop_offset_t;

extern void set_crop_offset(ch_id_t chn, crop_offset_t crop_offset);

/* SRC_BLANK */
typedef struct src_blank_s
{
	unsigned int hblank : 13;
	unsigned int reserved1 : 3;
	unsigned int vblank : 13;
	unsigned int reserved2 : 3;
} src_blank_t;
extern void set_src_blank(src_blank_t src_blank);

/* CH_DMA */
typedef struct chn_dma_s
{
	unsigned int fb0_en : 1;
	unsigned int fb1_en : 1;
	unsigned int fb2_en : 1;
	unsigned int fb3_en : 1;
	unsigned int wlen : 4;
	unsigned int dmaw_en : 1;
	unsigned int dmar_en : 1;
	unsigned int dmar_vlb : 1;
	unsigned int reserved1 : 5;
	unsigned int dmar_wm : 4;
	unsigned int rlen : 4;
	unsigned int reserved2 : 8;
} chn_dma_t;

typedef struct lb_ctrl_s
{
	unsigned int lb_en: 4;
	unsigned int gnt_tog: 1;
	unsigned int uv_swap: 1;
	unsigned int fid_swap: 1;
	unsigned int vif_err_en: 1;
	unsigned int fid_filter: 2;
	unsigned int reserved0: 2;
	unsigned int lb_mode: 2;
	unsigned int reserved1: 18;
}lb_ctrl_t;

extern void set_channel_dma(ch_id_t chn, chn_dma_t);

/* Y buffer */
extern void set_ybuf_addr(ch_id_t chn, fb_id_t fb, unsigned int addr);
/* UV buffer */
extern void set_uvbuf_addr(ch_id_t chn, fb_id_t fb, unsigned int addr);

/* REG_UPDATE */
typedef struct reg_up_s
{
	unsigned int upd_reg : 8;
	unsigned int reserved1 : 8;
	unsigned int upd_mod : 2;
	unsigned int reserved2 : 2;
	unsigned int upd_force : 1;
	unsigned int reserved3 : 11;
} reg_up_t;

typedef enum 
{
	low_pri = 0,
	high_pri,
} int_pri_t;
extern void reg_update(void);

/* Bits of event for per channel */
#define FM_START_INT(chn)		chn*2
#define FM_END_INT(chn)		1 + chn*2
#define FD_INT(chn)				8 + chn*4
#define FRAME_LOST_INT(chn)	9 + chn*4
#define AXI_ERR_INT(chn)		10 + chn*4
#define VIF_ERR_INT(chn)		11 + chn*4

extern unsigned int query_int_sts(void);
extern void write_int_sts_clr(unsigned short bit);
extern unsigned int query_int_mask_sts(void);
extern void unmask_int(unsigned short bit);
extern void mask_all_int(void);
extern void set_int_pri(unsigned short bit, int_pri_t priority);
extern void set_buf_own(ch_id_t chn, fb_id_t fb);
extern short get_buf_own_value(ch_id_t chn, fb_id_t fb);

//////////////////////////////////////////////////////////////////////////////////
//// porting Linux driver by Ted
//////////////////////////////////////////////////////////////////////////////////
#define a1_writel(a, b)				HAL_SETREG(b, a)
#define writel(a, b)					HAL_SETREG(b, a)
#define	KDUMP(x...)					do { } while (0)

#define A1_REG_VCAP_BASE				HAL_REG_VCAP_BASE

#define A1_REG_VCAP_SYS_CTRL			A1_REG_VCAP_BASE + 0x0000
#define A1_REG_VCAP_CAP_CTRL			A1_REG_VCAP_BASE + 0x0004
#define A1_REG_VCAP_REG_UPDATE		A1_REG_VCAP_BASE + 0x0008
#define A1_REG_VCAP_REG_UPD_TIE1		A1_REG_VCAP_BASE + 0x000C

#define A1_REG_VCAP_OSG_WIN_EN_SEL	A1_REG_VCAP_BASE + 0x0020

#define A1_REG_VCAP_INT_STS			A1_REG_VCAP_BASE + 0x0100
#define A1_REG_VCAP_INT_STS_CLR		A1_REG_VCAP_BASE + 0x0104
#define A1_REG_VCAP_INT_STS_RAW		A1_REG_VCAP_BASE + 0x0108
#define A1_REG_VCAP_INT_MASK_STS		A1_REG_VCAP_BASE + 0x010C
#define A1_REG_VCAP_INT_MASK_SET		A1_REG_VCAP_BASE + 0x0110
#define A1_REG_VCAP_INT_MASK_CLR		A1_REG_VCAP_BASE + 0x0114
#define A1_REG_VCAP_INT_PRI			A1_REG_VCAP_BASE + 0x0118
#define A1_REG_VCAP_SRC_VIF			A1_REG_VCAP_BASE + 0x0200
#define A1_REG_VCAP_SRC_SIZE			A1_REG_VCAP_BASE + 0x0204
#define A1_REG_VCAP_SRC_START			A1_REG_VCAP_BASE + 0x0208
#define A1_REG_VCAP_SRC_BLANK			A1_REG_VCAP_BASE + 0x020C

#define A1_REG_SRC_CLIP_CTRL			A1_REG_VCAP_BASE + 0x0300
#define A1_REG_VCAP_SRC_CLIP_START	A1_REG_VCAP_BASE + 0x0304
#define A1_REG_VCAP_SRC_CLIP_SIZE	A1_REG_VCAP_BASE + 0x0308

#define A1_REG_VCAP_CHm_CROP_SIZE(chn)       	A1_REG_VCAP_BASE + 0x0380+ 0x04*chn
#define A1_REG_VCAP_CHm_CROP_OFFSET(chn)		A1_REG_VCAP_BASE + 0x0390 + 0x04*chn
#define A1_REG_VCAP_CHm_BORDER_COLOR(chn)		A1_REG_VCAP_BASE + 0x03A4 + 0x04*chn

#define A1_REG_VCAP_LINE_BUF_CTL		A1_REG_VCAP_BASE + 0x0520
#define A1_REG_VCAP_DI_CTL			A1_REG_VCAP_BASE + 0x0600



/* chn : channel id */
#define A1_REG_VCAP_CHm_DMA(chn)					A1_REG_VCAP_BASE + 0x0C00 + 0x04*chn
/* chn : channel id, fb : frame buffer id */
#define A1_REG_VCAP_CHm_FBn_DESTY(chn,fb)		A1_REG_VCAP_BASE + 0x0C10 + 0x20*chn + 0x04*fb
#define A1_REG_VCAP_CHm_FBn_DESTC(chn,fb)		A1_REG_VCAP_BASE + 0x0C20 + 0x20*chn + 0x04*fb

#define A1_REG_VCAP_CHm_DEST_OWN(chn)			A1_REG_VCAP_BASE + 0x0C90 +	0x04*chn

#define A1_REG_VCAP_SC_CTRL						A1_REG_VCAP_BASE + 0x0700
#define A1_REG_VCAP_CHm_SC_Y(chn)				A1_REG_VCAP_BASE + 0x0710 + chn*8
#define A1_REG_VCAP_CHm_SC_X(chn)				A1_REG_VCAP_BASE + 0x0714 + chn*8


/* OSD related */
#define A1_REG_OSDFONT							A1_REG_VCAP_BASE +0x0B00
#define A1_REG_OSDDISP							A1_REG_VCAP_BASE +0x0B04
#define A1_REG_OSD_EN							A1_REG_VCAP_BASE + 0x0B08
#define A1_REG_OSDCOR(win)					A1_REG_VCAP_BASE + 0x0B0C + 0x04*win
#define A1_REG_OSD_WSIZE(win)					A1_REG_VCAP_BASE + 0x0B2C + 0x04*win
#define A1_REG_OSD_FSIZE(win)					A1_REG_VCAP_BASE + 0x0B4C + 0x04*win
#define A1_REG_CHm_OSD_WOFFSETn(chn, win)	A1_REG_VCAP_BASE + 0x0B6C + 0x20*chn +  0x04*win
#define A1_REG_OSDDISABLE 					A1_REG_VCAP_BASE +0x0BF0

#define CH_WIN_BIT(chn, win)					( 1 << (chn*8 + win) )

/* OSG related */
/* for OSG window n */
#define  A1_REG_OSG_WIN_COR(n)	A1_REG_VCAP_BASE + 0xA00 + n*0x04
#define  A1_REG_OSG_WIN_SRC(n)	A1_REG_VCAP_BASE + 0xA20 + n*0x04
#define  A1_REG_OSG_WIN_SIZE(n)	A1_REG_VCAP_BASE + 0xA40 + n*0x04

/* Window n start point X/Y for Channel m */
#define  A1_REG_CHm_OSG_WOFFSETn(m, n) A1_REG_VCAP_BASE + 0xA60 + 0x20*m + 0x04*n

/* m = channel 0 ~ 3 ; specify order of win 0 ~ 7 */
#define  A1_REG_CHm_OSG_WIN_ORDER(m)	A1_REG_VCAP_BASE + 0xAE0 +0x04*m

/* Enable/Disable some OSG windows on specific channel */
#define  A1_REG_OSG_WIN_EN(m)	A1_REG_VCAP_BASE + 0xAF0 + 0x04*m

/* Enable/Disable OSG function on specific channel */
//#define  A1_REG_OSG_EN A1_REG_VCAP_BASE + 0xAF4

/* palette related */
#define  A1_REG_PALETTE_COLOR(n)	A1_REG_VCAP_BASE + 0x0800 + n*0x04

/* Mask related */
#define  A1_REG_MSKEN						A1_REG_VCAP_BASE + 0x0840
#define  A1_REG_MSKDISABLE				A1_REG_VCAP_BASE + 0x096C

#define  A1_REG_MSK_MODE					A1_REG_VCAP_BASE + 0x0844
#define  A1_REG_CHmMSKCOR(chn)			A1_REG_VCAP_BASE + 0x0848 + 0x04*chn
#define  A1_REG_CHmMSKn_START(chn,n)	A1_REG_VCAP_BASE + 0x0858 + 0x40*chn + 0x08*n
#define  A1_REG_CHmMSKn_END(chn,n)		A1_REG_VCAP_BASE + 0x085C + 0x40*chn + 0x08*n
#define  A1_REG_CHmSCRAMBLE_TAB(chn)	A1_REG_VCAP_BASE + 0x0958 + 0x04*chn
#define  A1_REG_MSK_BYPASS				A1_REG_VCAP_BASE + 0x0968

/* FRC related */
#define  A1_REG_FRC_CTL(chn)				A1_REG_VCAP_BASE + 0x0500 + 0x04*chn

/* interrupt related bits */
#define A1_INT_CH0FM_START				0x00000001
#define A1_INT_CH0FM_END					0x00000002
#define A1_INT_CH1FM_START				0x00000004

#define FONT_NUM	256 /* 0x1800/24 */

typedef struct osg_win_cor_s
{
	int win_id;
	unsigned int key_cr : 8;
	unsigned int key_cb : 8;
	unsigned int key_y : 8;
	//Window 0 color key portion: Transparency level
	unsigned int colorkey_trans : 2;		//00: 25% (Normal), 01: 50%, 10: 75%, 11: 100%
	unsigned int colorkey_en : 1;
	unsigned int reserved0 : 1;
	//non-color key portion:Transparency level
	unsigned int noncolorkey_trans : 2;	//	00: 0% (Normal), 01: 25%, 10: 50%, 11: 75%
	unsigned int reserved1 : 2;
}osg_win_cor_t;

typedef struct osg_dma_buf_s
{
	int buf_id;
	unsigned int	buf_phy; /* dma buffer physical address */
	//int	buf_virt; /* dma buffer user virtual address */
}osg_dma_buf_t;

typedef struct osg_win_src_s
{
	int win_id;
	unsigned int win_src; /* Memory source image start address */
}osg_win_src_t;

typedef struct osg_win_size_s
{
	int win_id;
	unsigned short win_w ; /* width of OSG window, < 12 bits */
	unsigned short win_h ; /* height of OSG window, < 12 bits */
}osg_win_size_t;

typedef struct osg_win_pos_s
{
	int chn;
	int win_id;
	unsigned int x_pos : 12; /* x-axis position of OSG window */
	unsigned int reserved0 : 4;
	unsigned int y_pos : 12;
	unsigned int reserved1 : 4;
}osg_win_pos_t;

typedef struct osg_win_en_s
{
	int chn;
	int win_id;
	int en;
}osg_win_en_t;

/*********************************************************************************************/
typedef struct osdfont_s
{
	unsigned int data ;
	unsigned int addr;
}osdfont_t;


typedef struct osd_win_en_s
{
	int chn;
	int win_id;
	unsigned short en;
}osd_win_en_t;

typedef struct osd_win_cor_s
{
	int win_id;
	//Forground Transparency level -
	unsigned int fgColor : 3;		//00: 0% (Normal), 01: 25%, 10: 50%, 11: 75%
	//Background Transparency level -
	unsigned int bgColor : 3;		//00: 0% (Normal), 01: 50%, 10: 75%, 11: 100%
	unsigned int fgtrans : 2;
	unsigned int bgtrans : 2;
	unsigned int reserved : 22;
}osd_win_cor_t;

typedef struct osd_win_font_s
{
	int win_id;
	/* The start address in Display RAM to put font index */
	unsigned short	Start;  /* 0 ~ 0x1FF */
	/* string length of str[] */
	unsigned int numChar;
  unsigned short *font_idx_p;
  //unsigned short offset;
}osd_win_font_t;

typedef struct osd_win_str_s
{
	int win_id;
	/* The start address in Display RAM to put font index */
	unsigned short	Start;  /* 0 ~ 0x1FF */
	/* string length of str[] */
	unsigned int numChar;
  	unsigned char str[FONT_NUM];
}osd_win_str_t;

typedef struct pos_s
{
	unsigned short x_pos ; /* position of OSD window */
	unsigned short y_pos ;
}vcap_pos_t;

typedef struct size_s
{
	unsigned short w ;
	unsigned short h ;
}vcap_size_t;

typedef struct osd_win_size_s
{
	int win_id;
	/* Window horizontal character number */
	unsigned short HDim ;// max 6bits
	/* Window vertical character number */
	unsigned short VDim ; // max 6bits
}osd_win_size_t;

typedef struct osd_win_pos_s
{
	int chn;
	int win_id;
	unsigned short x_pos ; /* position of OSD window */
	unsigned short y_pos ;
}osd_win_pos_t;

typedef struct osd_font_size_s
{
	int win_id;
	/* font width (7~ 12) of the window 0~7 */
	unsigned int font_w : 4;
	/* font height (7~ 24) of the window 0~7 */
	unsigned int font_h : 5;
	unsigned int reserved : 23;
	/* font column space of the window 0~7 */
	unsigned short fspace_col ;  //maxi 4 bits
	/* font row space of the window 0~7 */
	unsigned short fspace_row ; //maxi 4 bits
}osd_font_size_t;

/**********************************************************************************************/
typedef struct scaler_s
{
	int chn;
	int en;
	int src_w;
	int src_h;
	int out_w;
	int out_h;
} scaler_t;

/**********************************************************************************************/
typedef struct msken_s
{
	int chn;
	int win_id;
	int en;
}msken_t;

typedef struct msk_mode_s
{
	int chn;
	int win_id; /* 0~ 7 */
	short mode;		//0: use 16 Palette color for mask
						//1: use pixel rendering method for mask
}msk_mode_t;


typedef struct msk_color_s
{
	int chn;
	int win_id; /* 0~ 7 */
	int palette_idx; /* 0~ 7 */

}msk_color_t;

typedef struct msk_dim_s
{
	int chn;
	int win_id; /* 0~ 7 */
	unsigned int x_pos : 13;
	unsigned int y_pos : 13;
	unsigned int reserved0 : 6;
	unsigned short x_width ; //maxi 13 bits
	unsigned short y_end ; //maxi 13 bits
}msk_dim_t;

typedef struct scramble_usrkey_s
{
	int chn;
	unsigned long int user_key;
	unsigned int scramble_key;
}scramble_usrkey_t;

typedef struct msk_win_s
{
	int en; 	// 0: use 16 Palette color for mask
				//1: use pixel rendering method for mask
	int mode;
	int palette_id; /* 0~ 7 */
	unsigned int x_pos;
	unsigned int y_pos;
	unsigned int x_width; //maxi 13 bits
	unsigned int y_end; //maxi 13 bits
}msk_win_t;

typedef struct msk_setting_s
{
	int chn;
   unsigned long int user_key;
   unsigned int scramble_key;
   struct msk_win_s win[8];
}msk_settings_t;

typedef struct osd_palette_s
{
	unsigned char  index;
	unsigned char  Y;
	unsigned char  Cb;
	unsigned char  Cr;
}osd_palette_t;

/********************************************************************************************/

extern void store_osdfont2fontRAM(void);

/********************************************************************************************/
typedef struct
{
	int osd_horizontal_width;
	int osd_vertical_height ;
	int foreground_color;
	int background_color;
	int foreground_transparency;
	int background_transparency ;
	char *osd_str;
	int font_row_space;
	int font_column_space;
} osd_properties_t;

typedef struct
{
	int key_cr ;
	int key_cb ;
	int key_y;
	int colorkey_trans ; //100%
	int colorkey_en; //1 : enable
	int noncolorkey_trans ;//0x03; //75%
	int win_w ;
	int win_h ;
	char *osg_file_name;
} osg_properties_t;

/********************************************************************************************/
/********************************************************************************************/
typedef struct _a1_sdb_vcap_options
{
	unsigned int src_w;
	unsigned int src_h;
	unsigned int ch_w[4];
	unsigned int ch_h[4];
	unsigned int scaler[4];
	unsigned int fps[4];
	unsigned int bitPerSecond[4];
}a1_sdb_vcap_options;

#endif
