/*
 * internal header file
 */

/* Status :													*/
/* 	(1) only FAT12 and FAT16 is implemented 				*/
/*	(2) only one partition is supposed and datum is written	*/
/*		to the first partition only							*/

#ifndef __dosFSi_h_
#define __dosFSi_h_

#include "sys.h"

EXTERN_C_BEGIN


#include "dosFS.h"

#define DOS_EOF		((char) 26)

#define DOS_FAT_BITS_12				12
#define DOS_FAT_BITS_16				16
#define DOS_FAT_BITS_32				32

/* size in byte */
#define DOS_BYTES_PER_SEC			512
#define DOS_DIR_ENTRY_SIZE			32
#define DOS_FAT16_ENTRY_SIZE		2
#define DOS_FAT32_ENTRY_SIZE		4


#define DOS_FEC_FREE					0
//#define DOS_F12EC_RESERVED				0x0ff6
//#define DOS_F12EC_LAST_CLUSTER_IN_FILE	0x0ff8
//#define DOS_F16EC_RESERVED				0xfff6
#define DOS_F12EC_LAST_CLUSTER_IN_FILE	0xfff
#define DOS_F16EC_LAST_CLUSTER_IN_FILE	0xffff
#define DOS_F32EC_LAST_CLUSTER_IN_FILE	0xfffffff
/* FXXEC means FATXX Entry code which is the content of */
/* the FAT entries; if the n-th FAT entry contains: 	*/
/*	DOS_FXXEC_FREE: the n-th cluster is now not used	*/
/*	DOS_FXXEC_RESERVED: the n-th cluster is reserved	*/
/*	DOS_FXXEC_LASTER_CLUSTER_IN_FILE : the n-th 		*/
/*		cluster is the last cluster of a specific		*/
/*		file											*/
/*														*/
/*		(XX : 12, 16, 32)								*/


#define DOS_BAD_FAT_ENTRY_NUM		(-1)
/* bad fat entry number means a non-existing cluster in media */

/* DOS_FA : file attribute field of the directory entry */
	/*
		M             L
		S 6 5 4 3 2 1 S
		B             B
		| | | | | | | |
		| | | | | | | +-- 1 = read only (RO)
		| | | | | | +---- 1 = hidden file (HF)
		| | | | | +------ 1 = system file (SF)
		| | | | +-------- 1 = volume name (VN)
		| | | +---------- 1 = subdirectory (SD)
		| | +------------ 1 = archive bit (AB)
		| +-------------- (reserved)
		+---------------- (reserved)
	*/
#define DOS_FA_RO		0x01
#define DOS_FA_HF		0x02
#define DOS_FA_SF		0x04
#define DOS_FA_VN		0x08
#define DOS_FA_SD		0x10
#define DOS_FA_AB		0x20



enum dosMediaFormat_E
{
	doscMediaUnformatted = 1,
	doscMediaFormatted = 2
};
typedef enum dosMediaFormat_E dosMediaFormat_E;



/*
 * FAT cache
 */
typedef struct dosFATCache_S
{
	unsigned char cacheBuf[DOS_BYTES_PER_SEC];
	int nFATSector;
	bool_T isDirty;
	bool_T isValid;
	
} dosFATCache_S;



/*
 * Data cache
 */
//#define DOS_CACHE_SIZE_SECTORS	2
#define DOS_CACHE_SIZE_SECTORS	2
#define DOS_DATA_CACHE_SIZE	(DOS_BYTES_PER_SEC * DOS_CACHE_SIZE_SECTORS)
typedef struct dosDataCache_S
{
	unsigned char cacheBuf[DOS_DATA_CACHE_SIZE];
	int nStartSector;
	bool_T isDirty;
	bool_T isValid;
} dosDataCache_S;



/*
 * master boot sector structure
 */
/* 0x000 ~ 0x1FFF : master boot sector */
typedef struct dosMBS_S
{
	/* 0x000 ~ 0x1BD : boot command (not in use), fill 0's */


	/* below: partition-1 information */

	/* 0x1BE : boot Id, 1-byte long */
	unsigned char p1BootId;

	/* 0x1BF : start head number, 1-byte long */
	unsigned char p1StartHeadNum;

	/* 0x1C0 : start sector number, 1-byte long */
	unsigned char p1StartSectorNum;

	/* 0x1C1 : start cylinder number, 1-byte long */
	unsigned char p1StartCylinderNum;

	/* 0x1C2 : system Id, 1-byte long */
	unsigned char p1SystemId;

	/* 0x1C3 : end head number, 1-byte long */
	unsigned char p1EndHeadNum;

	/* 0x1C4 : end sector number, 1-byte long */
	unsigned char p1EndSectorNum;

	/* 0x1C5 : end cylinder number, 1-byte long */
	unsigned char p1EndCylinderNum;

	/* 0x1C6 ~ 0x1C9 : start logical sector number, 4-byte long */
	unsigned int p1StartLogSectorNum;

	/* 0x1CA ~ 0x1CD : partition size in sectors, 4-byte long */
	unsigned int p1Size;

	/* below: partition 2 information (not in use) */
	/* 0x1CE ~ 0x1DD : fill 0's */

	/* below: partition 3 information (not in use) */
	/* 0x1DE ~ 0x1ED : fill 0's */

	/* below: partition 4 information (not in use) */
	/* 0x1EE ~ 0x1FD : fill 0's */

	/* 0x1FE ~ 0x1FF : fixed data (signature) : 0xAA 0x55 */
	unsigned char fixedData[2];
} dosMBS_S;



/*
 * partition boot sector structure
 */
typedef struct dosPBS_S
{
	/* boot sector information below */

	/* 0x000~0x002 : jump command, 3-byte long */
	unsigned char jumpCmd[3];

	/* 0x003~0x00A : manufactures's name and version, ASCII, 8-byte long */
	char manufacture[8];

	/* 0x00B~0x00C : number of bytes per sector, 2-byte long */
	unsigned short bytesPerSector;

	/* 0x00D : number of sectors per cluster (allocation unit) : 1-byte long */
	unsigned char sectorsPerCluster;

	/* 0x00E~0x00F : number of reserved sectors, 2-byte long */
	unsigned short numReservedSectors;

	/* 0x010 : number of FATs, 1-byte long */
	unsigned char  numFATs;

	/* 0x011~0x012 : number of root directory entries, 2-byte long */
	unsigned short numEntriesInRD;

	/* 0x013~0x014 : number of sectors in the volume, 2-byte long */
	unsigned short numSectorsInVolume;

	/* 0x015 : Id byte, 1-byte long */
	unsigned char  mediaDescriptor;

	/* 0x016~0x017 : number of FAT sectors, 2-byte long */
	//unsigned short sectorsPerFAT;	// 
	unsigned int sectorsPerFAT;		//Change from "short" to "int" on 2006.06.27.
									//This datatype is not so important.
									//16 bits is needed for this
									//variable in FAT12/16. 32 bits is needed in
									//FAT32.

	/* 0x018~0x019 : number of sectors per track, 2-byte long */
	unsigned short sectorsPerTrack;

	/* 0x01A~0x01B : number of heads, 2-byte long */
	unsigned short numRWHeads;

	/* 0x01C~0x01F : number of hidden sectors, 4-byte long */
	unsigned int numHiddenSectors;

	/* * * * */

	/* 0x020~0x023 : total number of partition sectors, 4-byte long */
	unsigned int nNumPartSecs; /* 0 */

	/* 0x024 : physical drive number, 1-byte long */
	unsigned char nPhyDriveNum; /* 0 */

	/* 0x025 : reserved, 1-byte long */
	unsigned char reserved_1; /* 0 */

	/* 0x026 : extended boot record signatures, 1-byte long */
	unsigned char extBootRecSignature; /* 0 */

	/* 0x027~0x02A : volume Id, 4-byte long */
	unsigned int volumeId; /* 0 */

	/* 0x02B~0x035 : volume label, ASCII, 11-byte long */
	char volumeLabel[11]; /* 0 */

	/* 0x036~0x03D : file system type, ASCII, 8-byte long */
	char fileSystemType[8];

	/* 0x03E~0x1FD : reserved (IPL code area) */

	/* 0x1FE~0x1FF : fixed data (signature), 2-byte long */
	unsigned char fixedData[2];

	/* boot sector information above */



	/* derived information below */

	unsigned short fatSystem;
	unsigned int bytesPerCluster;
	unsigned int nFATStartSector;
	unsigned int nRDStartSector16;	//FAT12/16 only
	unsigned int nRDStartCluster32;	//FAT32 only
	unsigned int nDataStartSector;

	unsigned int numLogEntriesPerFAT;
	unsigned int numPhyEntriesPerFAT;

	unsigned int numFreeFATEntries;
	
	/* FAT cache */
	dosFATCache_S	FATCache;
} dosPBS_S;



/*
 * boot sector structure
 */
typedef struct dosBS_S
{
	bool_T bValid;	/* whether the structure is valid or not */
	bool_T bMBS;	/* indicating whether MBS exists or not */
	dosMBS_S mbs;	/* master boot sector */
	dosPBS_S p1bs;	/* patition-1 boot sector */

	dosMediaIORoutine_S io;

	dosDataCache_S DataCache; /* used for probe file */
} dosBS_S;



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * NOTE:
 * 
 * The first 8 fields of dosFile_S and dosDirIter_S should
 * be identical. dosReadFile() depends on these 8 fields
 * only. This makes dosReadFile() function could be
 * applied to iterate files on one directory opened.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * structure for "file open for read and write"
 */
typedef struct dosFile_S
{
	dosDataCache_S DataCache; /* used for file read */

	dosBS_S *pBS;

	int nFileSize;
	int nBytesPerCluster;
	int nFilePtrPos;
	int nFileHeadCluster;	/* the 0th cluster used by the file */
	int nFileNThCluster;	/* the nth cluster used by the file, n is the "rank" */
	int nClusterRank;		/* indicates what "n" is */
							/* The nFileNThCluster represents the cluster where */
							/* the nFilePtrPos is in. And nFilePtrPos represents */
							/* the actually position to do read/write. */



	bool_T bIsInRootDir;	/* the opened file is in root directory or not */
	int nDECluster;			/* DE : directory entry */
	int nDESector;
	int nDEOffset;
	/* 
		if bUnderRootDir is true, (nDESector, nDEOffset) is used to
			identify the location of the file's directory entry 

		if bUnderRootDir is false, (nDECluster, nDEOffset) is used to
			identify the location of the file's directory entry
	*/
	unsigned char dirEntry[32];

	void *temp;		//added by ted
} dosFile_S;


/*
 * structure for "dir open for iter"
 */
typedef struct dosDirIter_S
{
	dosDataCache_S DataCache; /* used for file read */

	dosBS_S *pBS;

	int nFileSize;
	int nBytesPerCluster;
	int nFilePtrPos;
	int nFileHeadCluster;	/* the 0th cluster used by the file */
	int nFileNThCluster;	/* the nth cluster used by the file, n is the "rank" */
	int nClusterRank;		/* indicates what "n" is */
							/* The nFileNThCluster represents the cluster where */
							/* the nFilePtrPos is in. And nFilePtrPos represents */
							/* the actually position to do read/write. */
} dosDirIter_S;

typedef struct dosIter_S
{
	bool_T bIterRD16;

	dosBS_S *pBS;

	dosDirIter_S *pDir;
	
	/*
	(1) If bIterRD16 is  TRUE, pDir is not used.
		This is the case that the file system is FAT12 or FAT16 and
		the iteration is on the root directory.

	(2) If bIterRD16 is FALSE, pDir is used.
		This is the case one of the followings:
		(2.1) file system is FAT32
		(2.2) file system is FAT12/16 but the iteration is on a
			sub-directory
	*/

	dosIterType_E nIterType;
	int nNumRDEntriesPerCluster;

	int nNextRDEntryIdx;	/* next RD entry going to be read */
} dosIter_S;




typedef void (*dosBufEncode_FT) (unsigned char *, unsigned int, unsigned int);
typedef void (*dosBufDecode_FT) (unsigned char *, unsigned int, unsigned int *);



/* dosGVars.c */
bool_T dosGVarsInit_i(void);



/* dosFAT.c */
void dosFATCacheFlush_i(dosBS_S *);
bool_T dosFATIsNilFEC_i(dosBS_S *, int nFATEntryCode);
bool_T dosFATIsFreeFEC_i(dosBS_S *, int nFATEntryCode);
bool_T dosFATIsReservedFEC_i(dosBS_S *, int nFATEntryCode);
int dosFATGetFEC_i(dosBS_S *, int nNThEntry);
int dosFATGetNextCluster_i(dosBS_S *, int nCurrent);
int dosFATGetLatestCluster_i(
				dosBS_S *,			/* I */
				int nCurrent,			/* I */
				int *pnRelativeIdx);	/* O */
bool_T dosFATUpdateClusterEntry_i(dosBS_S *, int nCurrent, int value);


int dosFATGetFreeCluster_i(dosBS_S *);
	/* get a free cluster and engage it */

void dosFATRecycleFileClusters_i(dosBS_S *, int nFirstCluster);
	/* release clusters used for a specific file whose first cluster
		is nFirstCluster */

void dosFATCountFreeEntries_i(dosBS_S *);



/* dosFmt.c */
bool_T dosSetFmtInfo_i(dosBS_S *pBS, unsigned int nSize);
void setBootSector(unsigned int *buffer);


/* dosAccess.c */
dosMediaFormat_E dosReadMediaBootSector_i(dosBS_Id);

int dosTranClusterToAbsSector_i(dosBS_S *pBS, int nCluster);
int dosTranAbsSectorToCluster_i(dosBS_S *pBS, int nSector);

	/* access the DATA area of DOS */
bool_T dosReadDOSDAClusterNByte_i(
				dosBS_Id,
				dosDataCache_S *pCache,
				unsigned int nCluster,
				unsigned int nOffset,
				unsigned int nBytes,
				unsigned char *pBuf);

void dosFlushCache_i(dosBS_Id, dosDataCache_S *pCache);

	/* access the DATA area of DOS */
bool_T dosWriteDOSDAClusterNByte_i(
				dosBS_Id,
				dosDataCache_S *pCache,
				unsigned int nCluster,
				unsigned int nOffset,
				unsigned int nBytes,
				unsigned char *pBuf);

	/* access the DATA area of DOS */
bool_T dosWriteDOSDAClusterNByte_Flush_i(
				dosBS_Id,
				dosDataCache_S *pCache,
				unsigned int nCluster,
				unsigned int nOffset,
				unsigned int nBytes,
				unsigned char *pBuf);

	/* access the DATA area of DOS */
void dosWriteDOSDAClusterBlank_i(
				dosBS_Id,
				unsigned int nCluster);

	/* access the physical FAT sector */
bool_T dosWriteMediaFATSector_i(
				dosBS_Id,
				unsigned int nSector);

	/* access the physical FAT sector */
bool_T dosReadMediaFATSector_i(
				dosBS_Id,
				unsigned int nSector);

	/* access the physical sector */
bool_T dosWriteMediaSectorNByte_i(
				dosBS_Id,
				unsigned int nSector,
				unsigned int nOffset,
				unsigned int nSize,
				unsigned char *pBuf);

	/* access the physical sector */
bool_T dosReadMediaSectorNByte_i(
				dosBS_Id,
				unsigned int nSector,
				unsigned int nOffset,
				unsigned int nSize,
				unsigned char *pBuf);

	/* access the physical sector */
bool_T dosWriteMediaSectorBlank_i(
				dosBS_Id,
				unsigned int nSector);



/* global variables */
extern dosBufEncode_FT dosvEncodeBufRoutine_g;
extern dosBufDecode_FT dosvDecodeBufRoutine_g;
extern bool_T dosvIsLittleEndianMachine_g;

EXTERN_C_END

#endif

