#ifndef _dosFS_h_
#define _dosFS_h_

#include "sys.h"

EXTERN_C_BEGIN


#define DOS_SEEK_CUR	1
#define DOS_SEEK_END	2
#define DOS_SEEK_SET	3



typedef unsigned int (*dosMediaGetCapacity_FT) (void);

typedef bool_T (*dosMediaReadNSector_FT) (unsigned int /* start sector */,
										unsigned int /* sector number*/,
										void * /* buffer address */);

typedef bool_T (*dosMediaWriteNSector_FT) (unsigned int /* start sector */,
										unsigned int /* sector number*/,
										void * /* buffer address */);

typedef bool_T (*dosMediaUninstall_FT)(void);


typedef struct dosMediaIORoutine_S
{
	dosMediaGetCapacity_FT getCapacity;
	dosMediaReadNSector_FT readNSector;
	dosMediaWriteNSector_FT writeNSector;
	dosMediaUninstall_FT uninstall;
} dosMediaIORoutine_S;

typedef struct dosIterInfo_S
{
	char *szName;
	bool_T isDir;
	unsigned int nSize;
} dosIterInfo_S;

enum dosIterType_E
{
	doscIterFileOnly	= 1,
	doscIterDirOnly		= 2,
	doscIterBoth		= 3
};
typedef enum dosIterType_E dosIterType_E;


typedef struct dosBS_S		* dosBS_Id;
typedef struct dosFile_S	* dosFile_Id;
typedef struct dosIter_S	* dosIter_Id;


#define DOS_NULL_FILE_ID	((dosFile_Id) 0)
#define DOS_NULL_ITER_ID 	((dosIter_Id) 0)


/* exposed APIs */

void dosFSInitInMain(void);

bool_T dosFormatMedia(dosMediaIORoutine_S);
dosBS_Id dosInstallMedia(dosMediaIORoutine_S);
bool_T dosUninstallMedia(dosBS_Id);

dosMediaIORoutine_S dosGetIORoutine(dosBS_Id);

char * dosGetMediaFS(dosBS_Id);
unsigned int dosGetMediaCapacity(dosBS_Id);
unsigned int dosGetMediaDataStorage(dosBS_Id);
unsigned int dosGetMediaFreeDataStorage(dosBS_Id);

bool_T dosIsValidPath(char *szName);
char * dosBeautyFileName(char *szWorkDir, char *szUserSpecifyPath);

int dosFileSize(dosBS_Id, char *szName);
bool_T dosFileExist(dosBS_Id, char *szName, bool_T bDirectory);
bool_T dosCreateFile(dosBS_Id, char *szName, bool_T bDirectory);
bool_T dosUnlinkFile(dosBS_Id, char *szName);
bool_T dosUnlinkDir(dosBS_Id, char *szName);

dosFile_Id dosOpenFile(dosBS_Id, char *szName);
void dosCloseFile(dosFile_Id);
int dosWriteFile(dosFile_Id, char *buffer, int nSize);
int dosReadFile(dosFile_Id, int nSize, char *buffer);
int dosFileSeek(dosFile_Id, int offset, int origin);
int dosFileTell(dosFile_Id);
bool_T dosFileEOF(dosFile_Id);

dosIter_Id dosStartToIterFile(dosBS_Id, char *szName, dosIterType_E nIterType);
dosIterInfo_S * dosIterOneFile(dosIter_Id);
void dosStopIterFile(dosIter_Id);


EXTERN_C_END

#endif /* _dosFS_h_ */

