/*------------------------------------------------------------------------------
--                                                                            --
--       This software is confidential and proprietary and may be used        --
--        only as expressly authorized by a licensing agreement from          --
--                                                                            --
--                            Hantro Products Oy.                             --
--                                                                            --
--                   (C) COPYRIGHT 2006 HANTRO PRODUCTS OY                    --
--                            ALL RIGHTS RESERVED                             --
--                                                                            --
--                 The entire notice above must be reproduced                 --
--                  on all copies and should not be removed.                  --
--                                                                            --
--------------------------------------------------------------------------------
--
--  Description : Debug Trace funtions
--
------------------------------------------------------------------------------
--
--  Version control information, please leave untouched.
--
--  $RCSfile: jpegasicdbgtrace.c,v $
--  $Revision: 1.2 $
--  $Date: 2008/05/08 14:11:52 $
--
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
    1. Include headers
------------------------------------------------------------------------------*/
#include "dwl.h"
#include "jpegregdrv.h"
#include "jpegasicdbgtrace.h"
#include "basetype.h"
#include "jpegdeccontainer.h"


//extern int halUARTPrintf(const char *szFormat, ...);
extern void printf(const char *fmt, ...);


void HexDumpJPEGTables(u32* regBase, JpegDecContainer* pJpegDecCont)
{
    u32 i, j = 0;
    u32 amountOfParam = 0;
    u32 count = 0;
    //u32 tableWord = 0;
    //u32 tableWord2 = 0;
    //u8 tableByte[8] = { 0 };
    //u32 *pTables = NULL;
	u8* pTables = NULL;

    /* pointer to table memory */
    pTables = (u8*)pJpegDecCont->frame.pTableBase.virtualAddress;

    /* calculate amount of table variables */
    /* qp */
    amountOfParam = (pJpegDecCont->info.amountOfQTables * 64);
    /* huffman */
    for(i = 0; i < 16; i++)
    {
        /* ac tables */
        amountOfParam += pJpegDecCont->vlc.acTable0.bits[i];
        amountOfParam += pJpegDecCont->vlc.acTable1.bits[i];
        /* dc tables */
        amountOfParam += pJpegDecCont->vlc.dcTable0.bits[i];
        amountOfParam += pJpegDecCont->vlc.dcTable1.bits[i];
    }

    /* round up to 64-bit memory */
    if((JPEGDEC_TABLE_SIZE % 8) != 0)
    {
        do
        {
            count++;
        }
        while(((JPEGDEC_TABLE_SIZE + count) % 8) != 0);
    }

	printf("MSB\t<---->\tLSB\r\n");

    /* write data to trace */
    for(i = 0; i < ((JPEGDEC_TABLE_SIZE + count) / 4); i++)
    {
/*
        tableByte[0] = pTables[7];
        tableByte[1] = pTables[6];
        tableByte[2] = pTables[5];
        tableByte[3] = pTables[4];
        tableByte[4] = pTables[3];
        tableByte[5] = pTables[2];
        tableByte[6] = pTables[1];
        tableByte[7] = pTables[0];
*/
		pTables += 8;
        i++;

        if(i >= (JPEGDEC_TABLE_SIZE / 4))
        {
/*
            tableByte[0] = 0;
            tableByte[1] = 0;
            tableByte[2] = 0;
            tableByte[3] = 0;
*/
        }

        if(i < (JPEGDEC_TABLE_SIZE / 4))
        {
			printf("%02x %02x %02x %02x %02x %02x %02x %02x",
						  pTables[7], pTables[6],
						  pTables[5], pTables[4],
						  pTables[3], pTables[2],
						  pTables[1], pTables[0]);

            if((i) % 1 == 0)
            {
                printf("\r\n");
            }
        }
        else
        {
			printf("%02x %02x %02x %02x",
						  pTables[3], pTables[2],
						  pTables[1], pTables[0]);

            for(j = 0; j < count; j++)
            {
                printf("00 ");
                i++;
            }
        }
    }
    printf("\r\n");
}

#if 0

extern int halUARTPrintf(const char *szFormat, ...);


void HexDumpJPEGTables(u32* regBase, JpegDecContainer* pJpegDecCont)
{
    u32 i, j = 0;
    u32 amountOfParam = 0;
    u32 count = 0;
    u32 tableWord = 0;
    u32 tableWord2 = 0;
    u8 tableByte[8] = { 0 };
    u32 *pTables = NULL;

    /* pointer to table memory */
    pTables = pJpegDecCont->frame.pTableBase.virtualAddress;

    /* calculate amount of table variables */
    /* qp */
    amountOfParam = (pJpegDecCont->info.amountOfQTables * 64);
    /* huffman */
    for(i = 0; i < 16; i++)
    {
        /* ac tables */
        amountOfParam += pJpegDecCont->vlc.acTable0.bits[i];
        amountOfParam += pJpegDecCont->vlc.acTable1.bits[i];
        /* dc tables */
        amountOfParam += pJpegDecCont->vlc.dcTable0.bits[i];
        amountOfParam += pJpegDecCont->vlc.dcTable1.bits[i];
    }

    /* round up to 64-bit memory */
    if((JPEGDEC_TABLE_SIZE % 8) != 0)
    {
        do
        {
            count++;
        }
        while(((JPEGDEC_TABLE_SIZE + count) % 8) != 0);
    }

	halUARTPrintf("MSB\t<---->\tLSB\r\n");

    /* write data to trace */
    for(i = 0; i < ((JPEGDEC_TABLE_SIZE + count) / 4); i++)
    {
        tableWord = pTables[i];
        tableWord2 = pTables[i + 1];

        tableByte[0] = ((tableWord & 0xFF000000) >> 24);
        tableByte[1] = ((tableWord & 0x00FF0000) >> 16);
        tableByte[2] = ((tableWord & 0x0000FF00) >> 8);
        tableByte[3] = ((tableWord & 0x000000FF) >> 0);
        tableByte[4] = ((tableWord2 & 0xFF000000) >> 24);
        tableByte[5] = ((tableWord2 & 0x00FF0000) >> 16);
        tableByte[6] = ((tableWord2 & 0x0000FF00) >> 8);
        tableByte[7] = ((tableWord2 & 0x000000FF) >> 0);
        i++;

        if(i >= (JPEGDEC_TABLE_SIZE / 4))
        {
            tableByte[4] = 0;
            tableByte[5] = 0;
            tableByte[6] = 0;
            tableByte[7] = 0;

        }

        if(i < (JPEGDEC_TABLE_SIZE / 4))
        {
			halUARTPrintf("%02x %02x %02x %02x %02x %02x %02x %02x",
						  tableByte[0], tableByte[1],
						  tableByte[2], tableByte[3],
						  tableByte[4], tableByte[5],
						  tableByte[6], tableByte[7]);

            if((i) % 1 == 0)
            {
                halUARTPrintf("\r\n");
            }
        }
        else
        {
			halUARTPrintf("%02x %02x %02x %02x",
						  tableByte[0], tableByte[1],
						  tableByte[2], tableByte[3]);

            for(j = 0; j < count; j++)
            {
                halUARTPrintf("00 ");
                i++;
            }
        }
    }
    halUARTPrintf("\r\n");
}
#endif /* 0 */
