/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#ifndef HX9170_REGS_H_INCLUDED
#define HX9170_REGS_H_INCLUDED


#define HX9170_REG_BASE 0x99300000

#define HX9170_IRQ_BIT  (0x1 << 9)

enum HX9170_REG_ADDR
{
	HX9170_REG_ID              = (HX9170_REG_BASE + 0x0000),
	HX9170_REG_DEC_IRQ         = (HX9170_REG_BASE + 0x0004),
	HX9170_REG_DEC_CONF        = (HX9170_REG_BASE + 0x0008),
	HX9170_REG_SYNTH_CFG       = (HX9170_REG_BASE + 0x00C8),
	HX9170_REG_SYNTH_CFG_2     = (HX9170_REG_BASE + 0x00D8),
	HX9170_REG_FUSE_CFG        = (HX9170_REG_BASE + 0x00E4),
	HX9170_REG_PP_IRQ          = (HX9170_REG_BASE + 0x00F0),
	HX9170_REG_PP_CONF         = (HX9170_REG_BASE + 0x00F4),
	HX9170_REG_PP_FUSE_CFG     = (HX9170_REG_BASE + 0x018C),
	HX9170_REG_PP_SYNTH_CFG    = (HX9170_REG_BASE + 0x0190),
};


#endif /* HX9170_REGS_H_INCLUDED */
