/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#ifndef HX8290_REGS_H_INCLUDED
#define HX8290_REGS_H_INCLUDED


#define HX8290_REG_BASE 0x99200000

#define HX8290_IRQ_BIT  (0x1 << 8)

enum HX8290_REG_ADDR
{
	HX8290_REG_ID              = (HX8290_REG_BASE + 0x00),
	HX8290_REG_IRQ             = (HX8290_REG_BASE + 0x04),
	HX8290_REG_DEV_CFG         = (HX8290_REG_BASE + 0x08),
	HX8290_REG_TEST            = (HX8290_REG_BASE + 0x0C),
	HX8290_REG_INT_INTERVAL    = (HX8290_REG_BASE + 0x10),
	HX8290_REG_OUTPUT_DATA     = (HX8290_REG_BASE + 0x14),
	HX8290_REG_OUTPUT_CTRL     = (HX8290_REG_BASE + 0x18),
	HX8290_REG_REF_PIC_LUM     = (HX8290_REG_BASE + 0x1C),
	HX8290_REG_REF_PIC_CHR     = (HX8290_REG_BASE + 0x20),
	HX8290_REG_NEW_PIC_LUM     = (HX8290_REG_BASE + 0x24),
    HX8290_REG_ENC_COMM_CTRL_1 = (HX8290_REG_BASE + 0x38),
    HX8290_REG_ENCODER_CONFIG  = (HX8290_REG_BASE + 0xFC)
};

enum HX8290_IRQ_REG_FIELD_MASK
{
	HX8290_IRQ_REG_INTERVAL    = (0x1 << 8),
	HX8290_IRQ_REG_MEM_TEST    = (0x1 << 7),
	HX8290_IRQ_REG_IRQ_TEST    = (0x1 << 6),
	HX8290_IRQ_REG_STREAM_FULL = (0x1 << 5),
	HX8290_IRQ_REG_REST        = (0x1 << 4),
	HX8290_IRQ_REG_ERROR       = (0x1 << 3),
	HX8290_IRQ_REG_FRAME_OK    = (0x1 << 2),
	HX8290_IRQ_REG_INT_DISABLE = (0x1 << 1),
	HX8290_IRQ_REG_HINT        = 0x1
};

enum HX8290_TEST_REG_FIELD_MASK
{
	HX8290_TEST_REG_COUNTER  = 0xF0000000,
	HX8290_TEST_REG_DATA_LEN = 0x001FFFF8,
	HX8290_TEST_REG_TEST_MEM = (0x1 << 2),
	HX8290_TEST_REG_TEST_REG = (0x1 << 1),
	HX8290_TEST_REG_TEST_IRQ = 0x1
};


#endif /* HX8290_REGS_H_INCLUDED */
