/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>

#include <json.h>


static char* _pattern =
	"{ \"foo\": \"bar\", "
	"\"baz\": 3 }";


int do_json_test3(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	struct json_object* object;
	struct json_object* property;


	printf("Input pattern: %s\n", _pattern);

	object = json_tokener_parse(_pattern);

	property = json_object_object_get(object, "foo");
	if (property != NULL &&
		json_object_get_type(property) == json_type_string)
	{
		printf("Value of foo: %s\n", json_object_get_string(property));
	} else {
		printf("Failed to find property: foo\n");
	}

	property = json_object_object_get(object, "baz");
	if (property != NULL &&
		json_object_get_type(property) == json_type_int)
	{
		printf("Value of baz: %d\n", json_object_get_int(property));
	} else {
		printf("Failed to find property: baz\n");
	}

	json_object_put(object);

	extern void dma_pool_info(void);
	dma_pool_info();

	return 0;
}


U_BOOT_CMD (
	json_test3, CONFIG_SYS_MAXARGS, 0, do_json_test3,
	"json_test3 - Selftest for json-c",
	"\n"
	"	- json_test3"
);
