/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>

#include <json.h>


int do_json_test1(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	//int i;
	json_object* my_string;
	json_object* my_int;
	//json_object* my_array;

	my_string = json_object_new_string("foo");
	printf("my_string=%s\n", json_object_get_string(my_string));
	//printf("my_string.to_string()=%s\n", json_object_to_json_string(my_string));
	json_object_put(my_string);

	my_int = json_object_new_int(9);
	printf("my_int=%d\n", json_object_get_int(my_int));
	//printf("my_int.to_string()=%s\n", json_object_to_json_string(my_int));
	json_object_put(my_int);

/*
	my_array = json_object_new_array();
	json_object_array_add(my_array, json_object_new_int(1));
	json_object_array_add(my_array, json_object_new_int(2));
	json_object_array_add(my_array, json_object_new_int(3));
	json_object_array_put_idx(my_array, 4, json_object_new_int(5));
	printf("my_array=\n");
	for (i = 0; i < json_object_array_length(my_array); i++) {
		json_object *obj = json_object_array_get_idx(my_array, i);
		printf("\t[%d]=%d\n", i, json_object_get_int(obj));
		//printf("\t[%d]=%s\n", i, json_object_to_json_string(obj));
	}
	//printf("my_array.to_string()=%s\n", json_object_to_json_string(my_array));
*/

	//json_object_put(my_string);
	//json_object_put(my_int);
	//json_object_put(my_object);
	//json_object_put(my_array);

	extern void dma_pool_info(void);
	dma_pool_info();

	return 0;
}


U_BOOT_CMD (
	json_test1, CONFIG_SYS_MAXARGS, 0, do_json_test1,
	"json_test1 - Selftest for json-c",
	"\n"
	"	- json_test1"
);
