/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>

#include <codec/hx9170/include/jpegdecapi.h>


extern void  dma_memorypool_reset(void);
extern void* dma_memory_alloc(unsigned int size);
extern unsigned char colorbar_jpeg[];
extern unsigned int colorbar_jpeg_size;


enum _properties {
	FRAME_WIDTH  = 128,
	FRAME_HEIGHT = 96,

	LUMA_SIZE = FRAME_WIDTH * FRAME_HEIGHT,
	CHROMA_SIZE = FRAME_WIDTH * FRAME_HEIGHT / 4,
	PIC_SIZE = FRAME_WIDTH * FRAME_HEIGHT * 3 / 2,
};


int do_jpegdec_selftest(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int i;

	JpegDecRet rc = JPEGDEC_ERROR;

	JpegDecInst      decoder;
	JpegDecInput     decIn;
	JpegDecOutput    decOut;
	JpegDecImageInfo imageInfo;

	unsigned char* input;
	unsigned char* output;

	memset(&decoder,   0, sizeof(decoder));
	memset(&imageInfo, 0, sizeof(imageInfo));
	memset(&decIn,     0, sizeof(decIn));
	memset(&decOut,    0, sizeof(decOut));

	dma_memorypool_reset();

	//extern void dma_pool_info();
	//dma_pool_info();

	input = dma_memory_alloc(colorbar_jpeg_size);
	if (input == NULL) {
		rc = JPEGDEC_ERROR;
		printf("Failed to allocate memory block for JPEG frame\n");
		goto error;
	}
	memcpy(input, colorbar_jpeg, colorbar_jpeg_size);

	output = dma_memory_alloc(PIC_SIZE);
	if (output == NULL) {
		rc = JPEGDEC_ERROR;
		printf("Failed to allocate memory block for output buffer\n");
		goto error;
	}

	/* Jpeg initialization */
	rc = JpegDecInit(&decoder);
	if (rc != JPEGDEC_OK) {
		printf("Failed to initialize JPEG decoder\n");
		goto error;
	}

	/* Pointer to the input JPEG */
	decIn.streamBuffer.pVirtualAddress = (void*)input;
	decIn.streamBuffer.busAddress = (unsigned int)input;
	decIn.streamLength = colorbar_jpeg_size; /* JPEG length in bytes */
	decIn.bufferSize = 0; /* input buffering (0 == not used) */

	/* Get image information of the JPEG image */
	rc = JpegDecGetImageInfo(decoder, &decIn, &imageInfo);
	if (rc != JPEGDEC_OK) {
		printf("Failed to get information of JPEG frame\n");
		goto failed;
	}

	/* Luma Bus */
	decIn.pictureBufferY.pVirtualAddress = (void*)output;
	decIn.pictureBufferY.busAddress = (unsigned int)decIn.pictureBufferY.pVirtualAddress;

	/* Chroma Bus */
	decIn.pictureBufferCbCr.pVirtualAddress = (void*)(output + LUMA_SIZE);
	decIn.pictureBufferCbCr.busAddress = (unsigned int)decIn.pictureBufferCbCr.pVirtualAddress;

	/* Decode JPEG */
	rc = JpegDecDecode(decoder, &decIn, &decOut);
	if (rc == JPEGDEC_FRAME_READY) {
		printf("JPEG frame is decoded to 0x%08x, %u bytes\n",
			   (unsigned int)output, PIC_SIZE);
		rc = JPEGDEC_OK;
	}

failed:
	/* Release JPEG Decoder */
	JpegDecRelease(decoder);

error:
	if (rc != JPEGDEC_OK) {
		printf("Failed to decode a JPEG frame\n");
	}

	return 0;
}


U_BOOT_CMD(
	jpegdec_selftest,	CONFIG_SYS_MAXARGS,	1,	do_jpegdec_selftest,
	"Perform selftest of JPEG decoder",
	"\n"
	"	-To decode a built-in color bar"
);
