/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>


#include "hal.h"

static short SSM2603_master_config[] =
{
	0x0f, 0x000,
	0x00, 0x13f,
	0x02, 0x15f,
	0x04, 0x01d,
	0x05, 0x000,
	0x06, 0x000,
	0x07, 0x042, // master
	0x08, 0x00c,	// 8K
	0x09, 0x001,
	0x12, 0x0f9,
};

static short SSM2603_slave_config[] =
{
	0x0f, 0x000,
	0x00, 0x13f,
	0x02, 0x15f,
	0x04, 0x01d,
	0x05, 0x000,
	0x06, 0x000,
	0x07, 0x002, //slave
	0x08, 0x00c,	// 8K
	0x09, 0x001,
	0x12, 0x0f9,
};

void SSM2603_i2c_write(unsigned char addr,unsigned short data)
{
	i2cPacketFmt_t packet;
	unsigned char lb_data;

	lb_data = (unsigned char)(data & 0xff);
	addr = (addr << 1) | ((data >> 8) & 0x1);

	packet.nSlaveAddr = 0x1a;
	packet.nId = halcI2C0;
	packet.subAddrLen = 1;
	packet.dataLen = 1;
	packet.subAddr = &addr; packet.data = &lb_data;
#if 0
	printf("Write TW2865 0x%02X = 0x%04X \n\r", addr, data);
#endif
	halGenericI2CWrite(packet);
}

unsigned short SSM2603_i2c_read(unsigned char addr)
{
	unsigned char lb_data[2];
	unsigned short data;
	i2cPacketFmt_t packet;

	addr = addr << 1;

	packet.nSlaveAddr = 0x1a;
	packet.nId = halcI2C0;
	packet.subAddrLen = 1;
	packet.dataLen = 2;
	packet.subAddr = &addr; packet.data = lb_data;
	halGenericI2CRead(packet);

	data = (lb_data[1] << 8) + lb_data[0];
	return data;
}

void SSM2603_read_reg(void)
{
	unsigned char i;
	unsigned short data;

	/* Init I2C bus */
	halI2CEnable(halcI2C0, PLL_GetAPBClock(CONFIG_SYS_INPUT_CLOCK));

	printf("   00    01    02    03    04    05    06    07    08    09    0a    0b    0c    0d    0e    0f    10    11    12\n\r");
	for (i=0; i <= 0x12; i++)
	{
		data = SSM2603_i2c_read(i);
		printf("0x%03X ", data);
	}
	printf("\n\r");
}

void SSM2603_init(bool_T bMaster)
{
	int i;
	unsigned short data;

	/* Init I2C bus */
	halI2CEnable(halcI2C0, PLL_GetAPBClock(CONFIG_SYS_INPUT_CLOCK));

	if(bMaster == TRUE)
	{
		for (i=0; i < (sizeof(SSM2603_master_config)/2); i+=2)
			SSM2603_i2c_write(SSM2603_master_config[i], SSM2603_master_config[i+1]);

		printf("Set SSM2603 to master mode \n\r");
	}
	else
	{
		for (i=0; i < (sizeof(SSM2603_slave_config)/2); i+=2)
			SSM2603_i2c_write(SSM2603_slave_config[i], SSM2603_slave_config[i+1]);

		printf("Set SSM2603 to slave mode \n\r");
	}
}

int sdbTestSSM2603_I2S_Setup(bool_T bMaster)
{
	halDAISetting_S daiSetting;
	unsigned int nCodecCLK;

	halDAIResetFIFO();

	daiSetting.bStereo = FALSE;
	daiSetting.nSamplingRate = 8000;
	daiSetting.nDataProtocol = halcDAII2SMode;
	daiSetting.nTXFIFOThreshold = 20;
	daiSetting.nRXFIFOThreshold = 4;
	daiSetting.bMaster = bMaster;

	if (halDAIIsBusy())
		halDAIDisable(halcDAITXRX);

	if (!halDAISetup(&daiSetting, CONFIG_SYS_INPUT_CLOCK, &nCodecCLK))
	{
		printf("config I2S failed ...\r\n");
		return FALSE;
	}

	printf("config I2S to %s done ...\r\n", bMaster == TRUE ? "master" : "slave");
	return TRUE;
}

int do_audio(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int nRxRegValue, nRxCount;
	unsigned short test;

	halI2CEnable(halcI2C0, PLL_GetAPBClock(CONFIG_SYS_INPUT_CLOCK));

	SSM2603_init(TRUE);					// set SSM to master mode
	sdbTestSSM2603_I2S_Setup(FALSE);	// set I2S to slave mode

	halDAIEnable(halcDAITXRX);

	/* transmit/receive data */
	printf("Press any key to exit\n\r");
	while (1)
	{
		if(serial_tstc() == 1)	// if get key pressed
			break;
		nRxRegValue = HAL_GETREG8(HAL_REG_I2S_rx_fifo_flag);
		nRxCount = HAL_GETREG8(HAL_REG_I2S_rx_fifo_cntr);

		if (!(nRxRegValue & 1) && (nRxCount >=2))
		{
			/* receiver's fifo is not empty */

			/* one right channel sample is retrieved */
			test = (unsigned short)(HAL_GETREG32(HAL_REG_I2S_rx_data));

			/* send out one dual-chanel (left and right) data */
			HAL_SETREG32(HAL_REG_I2S_tx_right_data, test);
			/* send out one dual-chanel (left and right) data */
			HAL_SETREG32(HAL_REG_I2S_tx_left_data, test);
		}
	}
	halDAIDisable(halcDAITXRX);
	printf("done\n\r");

	return TRUE;
}

U_BOOT_CMD(
	audio,	1,	1,	do_audio,
	"Loopback SSM2603 audio codec in/out from I2S interface",
	"\n"
);
