//  ***************************************************************************
// 
//   Copyright (c) 2009  Evatronix SA 
//
//  ***************************************************************************
//
//   Please review the terms of the license agreement before using     
//   this file. If you are not an authorized user, please destroy this 
//   source code file and notify Evatronix SA immediately that you     
//   inadvertently received an unauthorized copy.                      
//
//  ***************************************************************************
/// @file           nf_setup.h
/// @brief          Driver configuration file.
/// @version        $Revision: 1.4 $
/// @author         Piotr Sroka
/// @date           $Date: 2010-04-16 08:03:30 $
//  ***************************************************************************

#ifndef SETUP_H
#define SETUP_H
//#define IOWR_32NF   writel
//#define IORD_32NF   readl   
#define DMA_TRANSFER_MODE

/** indirect buffer is a buffer
  which will mediate in every DMA data transmission */
#define USE_INDIRECT_BUFFER         1
/** if it is 1 then driver copy data to indirect buffer
 * if it is 0 then user has to copy data manually
 *option is usefull only if USE_INDIRECT_BUFFER is active */
#define COPY_DATA_TO_IB             1
/** if this option is 1 
 * then in nf_ctrl_initialize function, 
 * controller registers start address will be set to NF_CONTROLLER_ADDRESS*/
#define NF_USE_DEFAULT_SFR_ADDRESS  0
/** system process idle macro, if no operating system it do nothing */
#define OS_PROCES_IDLE_STATE()      do{}while(0)
/** NAND flash domain clock in hertz */
#define NF_SYTEM_CLK_HZ             30000000
/** driver debug level it can be 0 or 1 */
#define DEBUG_LEVEL                 1
/** maximum page size */
#define NF_MAX_PAGE_SIZE            4096
/** maximum spare area */
#define NF_MAX_SPARE_AREA_SIZE      224
/** this option defines if bad block management is supported or no */
#define BBM_SUPPORT                 1
/** it defines how many addresses of bad blocks per each nand flash device 
 * will be stored in RAM*/
#define BBT_COUNT_BB_IN_RAM         20
/**  block address where BBT will be saved */
#define BBT_BLOCK_NUMBER            0x0uL
/**  block address where BBT copy will be saved */
#define BBT_COPY_BLOCK_NUMBER       0x1uL
/**
 *  ECC algorothm type
 *  1 - hamming
 *  4 - BCH4
 *  8 - BCH8
 *  16 - BCH16
 *  216 - BCH 2-16 (software configurable correction factor).
 *  this settings must be according to hardware configuration 
 * */
//#define NF_ECC_ALGORITHM            4
#define NF_ECC_ALGORITHM            216
#endif
