#include <config.h>
#include <common.h>
#include <asm/arch/hardware.h>
#include <asm/sizes.h>
#include <asm/io.h>
#include "hal.h"


int system_power_init(void)
{
	char clk_gate_str[16 * 32];

	//decoder
	halSysSetDeviceClkGate(halcGateH9170ACLK, 0);
	// LCD
	halSysSetDeviceClkGate(halcGateLCDCLK, 0);
	//USB
	halSysSetDeviceClkGate(halcGateUSBUCLK, 0);
	halSysSetDeviceClkGate(halcGateUSBHCLK, 0);
	//

	//Print clock gating information
	strcpy(clk_gate_str, "\0");
	halSysGetDeviceClkGateStr(clk_gate_str);
	printf("System %s clocks are gated\n\r", clk_gate_str);

	return 0;
}

int system_clk_init(void)
{
	char *s;
	unsigned int cpu = 1;
	unsigned pll0 = 70;//PMU_PLL0_MAX_DIVIDER;
	unsigned pll1 = 33;//PMU_PLL1_MAX_DIVIDER;

	if ((s = getenv ("cpu")) != NULL)
	{
		cpu = simple_strtoul (s, NULL, 10);
		if(cpu > 1)
			cpu = 1;
	}
	if ((s = getenv ("pll0")) != NULL)
	{
		pll0 = simple_strtoul (s, NULL, 10);
		if(pll0 != 70)
		{
			setenv("pll0","70");
			pll0 = 70;
			saveenv();
		}
			
/*		if(pll0 > PMU_PLL0_MAX_DIVIDER)
			pll0 = PMU_PLL0_MAX_DIVIDER;
		if(pll0 < PMU_PLL0_MIN_DIVIDER)
			pll0 = PMU_PLL0_MIN_DIVIDER;*/
	}
	if ((s = getenv ("pll1")) != NULL)
	{
		pll1 = simple_strtoul (s, NULL, 10);
		if(pll1 > PMU_PLL1_MAX_DIVIDER)
			pll1 = PMU_PLL1_MAX_DIVIDER;
		if(pll1 < PMU_PLL1_MIN_DIVIDER)
			pll1 = PMU_PLL1_MIN_DIVIDER;
	}
	/* PLL0 */
	PLL0_FCS(CONFIG_SYS_INPUT_CLOCK, 0, pll0, 1);

	/* PLL1 */
	PLL1_FCS(CONFIG_SYS_INPUT_CLOCK, 0, pll1, 1);

	serial_init(); // re-init uart

	/* CPU turbo */
	CPU_SetTurbo(cpu);	// set CPU = 2 * AHB

	printf("System clock: AHB = %dKHz, CPU = %dKHz, DDR2 = %dKHz\n\r", PLL_GetAHBClock(CONFIG_SYS_INPUT_CLOCK) / 1000,
			CPU_GetTurbo() == 1 ? PLL_GetAHBClock(CONFIG_SYS_INPUT_CLOCK) * 2 / 1000 : PLL_GetAHBClock(CONFIG_SYS_INPUT_CLOCK) / 1000 ,
			PLL_GetFout(1, CONFIG_SYS_INPUT_CLOCK)/1000	);


	return 0;
}

/* some devices need to be set to special clock */
int device_clk_init(void)
{
	unsigned int cpu_clk, ahb_clk, clk;
	unsigned int divider, new_divider, isp_clk = (ISP_MAX_CLK/1000/1000);
	char *s;


	/* setup SDC clock to 50MHz */
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SDC, &divider);
	new_divider = (clk * divider) / (50 * 1000 * 1000);

	if(((clk * divider) / new_divider) > (50 * 1000 * 1000 / 100 * 105)) // 5%
		new_divider++;
	clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SDC, new_divider);
	printf("SDC clk src=%d KHz(by divide %d)\n\r", clk/1000, new_divider);

	/* setup ISP clock */
	if ((s = getenv ("isp")) != NULL)
	{
		isp_clk = simple_strtoul (s, NULL, 10);
		if(isp_clk > (ISP_MAX_CLK/1000/1000))
			isp_clk = (ISP_MAX_CLK/1000/1000);
		if(isp_clk < (ISP_MIN_CLK/1000/1000))
			isp_clk = (ISP_MIN_CLK/1000/1000);
	}
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_ISP, &divider);
	new_divider = (clk * divider) / (isp_clk * 1000 * 1000);

	if(((clk * divider) / new_divider) > (isp_clk * 1000 * 1000 / 100 * 105)) // 5%
		new_divider++;

	clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_ISP, new_divider);
	printf("ISP clk src=%d KHz(by divide %d)\n\r", clk/1000, new_divider);
	return 0;

}

/* some devices should be inited here, including pin mux */
int system_device_init(void)
{
	/* GPIO3 bit 28 pin mux for power LED */
	halSysSetMultiFunctionalPin(HAL_MFP_GPIO_AP_POWER);
	/* turn on power LED */

	halGPIOSetPinDir(3, 28, 1); 	/* 1: output. 0: input */
	halGPIOSetPinData(3, 28, 1);

	/* GPIO3 bit 27 pin mux for PCBA test ,26 for ISP calibration*/
	halSysSetMultiFunctionalPin(HAL_MFP_GPIO_AP_TESTPIN);
	halGPIOSetPinDir(3, 27, 0); 	/* 1: output. 0: input */
	halGPIOSetInterrupt(3,27,0); 	/*1" enable . 0:disable*/
	halGPIOSetDBEnable(3,27,1);
	halGPIOSetPinDir(3, 26, 0); 	/* 1: output. 0: input */
	halGPIOSetInterrupt(3,26,0); 	/*1" enable . 0:disable*/
	halGPIOSetDBEnable(3,26,1);


}

