#include <common.h>
#include <asm/io.h>
#include <asm/arch/hardware.h>

/*
 * Reset the cpu by setting up the watchdog timer and let it time out
 */
void reset_cpu (ulong addr)
{
	__A1_writel(0x10, (A1_WDT_BASE + WDT_ReloadR));
	__A1_writel(WDT_RELOAD_MAGIC, (A1_WDT_BASE + WDT_RestartR));
	__A1_writel(0xf, (A1_WDT_BASE + WDT_ClrR));
	while(1)
		/* NOP */;
	/* Never reached */
}
