#include <common.h>
#include <asm/arch/hardware.h>
#include <asm/arch/vic.h>

REG_ISR_S registeredISR[N_IRQS];	//Registered ISR control struct.

int FCSIntrOccur_IRQ;
int FCSIntrOccur_FIQ;

/*----------------------------------------------
 *
 */
u32 reg_interrupt(INT_TYPE type, IntrVector_E source, ISR_FT ft)
{
	soc_trace();
	if (source > N_IRQS)
		return -1;

	registeredISR[source].type = type;
	registeredISR[source].pISR = ft;

	return 0;
}

void unregister_interrupt(IntrVector_E source)
{
	if (source < N_IRQS) {
		registeredISR[source].type = USE_IRQ;
		registeredISR[source].pISR = NULL;
	}
}
static void default_isr(void *data)
{
	soc_trace();
}

int arch_interrupt_init (void )
{
	int i;

	soc_trace();
	for (i = 0; i < N_IRQS; i++)
		reg_interrupt(USE_IRQ, i, (ISR_FT)default_isr);

	return 0;
}

#ifdef CONFIG_USE_IRQ
#warning "CONFIG_USE_IRQ defined ....."
void do_irq (struct pt_regs *pt_regs)
{
	int i = 0;

	//Get Interrupt trigger number.
	i = vic_queryirq();

	if (registeredISR[i].pISR != NULL)
		registeredISR[i].pISR();

	FCSIntrOccur_IRQ = 1;
}

#endif

#ifdef CONFIG_USE_FIQ
void do_fiq (struct pt_regs *pt_regs)
{
	FCSIntrOccur_FIQ = 1;
}

#endif
