#include <common.h>
#include <exports.h>
#include <linux/mtd/mtd.h>
#include <jffs2/load_kernel.h>
#include <command.h>

struct mtd_info *mtd;

int Hello_A1 (int argc, char * const argv[])
{
	int i;

	/* Welcome message */
	printf (">>> %s!!!\n", __FUNCTION__);

	/* Try to get the MTD handle, first.
	 * We only have one MTD device, pass index with 0 
	 */
	mtd = get_mtd_device(NULL, 0);

	/* Now you get the MTD handle, you can retrieve every elements of mtd_info
	 * Refer to "include/linux/mtd/mtd.h" for more description
	 */
	if (!mtd) {
		printf("Unable to get MTD device handle\n");
		return (-1);
	}

	/* An example of command,
	 * Do nand read from offset 0, len 0x800 to memory address 0x57000000
	 */
	run_command("nand read 57000000 0 800", 0);

	/* Another example of command,
	 * Do nand read from partition name "uboot", with len 0x2000 to memory 0x59000000
	 */
	run_command("nand read 59000000 uboot 2000", 0);

	/* For nand write */
	run_command("nand write 59000000 ispconf1 800", 0);

	return (0);
}
