/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

// Get/Set Registers
#define HAL_GETREG8(r)    (*((volatile unsigned char  *)(r)))
#define HAL_GETREG16(r)	  (*((volatile unsigned short *)(r)))
#define HAL_GETREG32(r)	  (*((volatile unsigned int   *)(r)))
#define HAL_SETREG8(r,v)  (*((volatile unsigned char  *)(r)) = ((unsigned char) (v)))
#define HAL_SETREG16(r,v) (*((volatile unsigned short *)(r)) = ((unsigned short)(v)))
#define HAL_SETREG32(r,v) (*((volatile unsigned int   *)(r)) = ((unsigned int)  (v)))


enum {
	GUC_DEV_PANEL = 0,
	ACTI_DVI_FB   = 1,
};

static unsigned int _panel_width  = 0;
static unsigned int _panel_height = 0;


void uapc2700_enable(void)
{
	// Enable LCD controller
	HAL_SETREG32(0x90900014, 0x00000003);
}

void uapc2700_disable(void)
{
	// Disable LCD controller
	HAL_SETREG32(0x90900014, 0x00000000);
}

void uapc2700_pause(unsigned int pause)
{
	unsigned int val;

	val = HAL_GETREG32(0x90900014);
	if (pause) {
		HAL_SETREG32(0x90900014, val & ~0x2);
	} else {
		HAL_SETREG32(0x90900014, val | 0x2);
	}
}

static void _init_guc_dev_panel(void)
{
	HAL_SETREG32(0x9900000c, 0x0aaabfff);
	HAL_SETREG32(0x99000010, 0x000000ff);
	HAL_SETREG32(0x99000020, 0x00000000);

	uapc2700_disable();

	// Horizontal Timing1
	HAL_SETREG32(0x90900000, 3146527);

	//Horizontal Timing2
	HAL_SETREG32(0x90900004, 5767208);

	// Vertical Timing1
	HAL_SETREG32(0x90900008, 197087);

	// Vertical Timing2
	HAL_SETREG32(0x9090000c, 1900557);

	// input image type
	HAL_SETREG32(0x90900010, 0x00001000);

	// Timing Control
	HAL_SETREG32(0x90900018, 0x00000460);

	// Panel border color
	HAL_SETREG32(0x9090004c, 0x00000000);

	// Up Sampling Parameters
	HAL_SETREG32(0x90900064, 0x00012326);

	uapc2700_enable();

	_panel_width  = 800;
	_panel_height = 480;
}

static void _init_acti_fb_panel(void)
{
	HAL_SETREG32(0x9900000c, 0x0aaabfff);
	HAL_SETREG32(0x99000010, 0x000000ff);
	HAL_SETREG32(0x99000020, 0x00000000);

	uapc2700_disable();

	// Horizontal Timing1
	HAL_SETREG32(0x90900000, (49 << 16) + (1280 - 1));

	//Horizontal Timing2
	HAL_SETREG32(0x90900004, (0 << 16) + 0);
	//HAL_SETREG32(0x90900004, (0 << 16) + 40);

	// Vertical Timing1
	HAL_SETREG32(0x90900008, (3 << 16) + (1024 - 1));

	// Vertical Timing2
	HAL_SETREG32(0x9090000c, (0 << 16) + 0);
	//HAL_SETREG32(0x9090000c, (0 << 16) + 13);

	// input image type
	HAL_SETREG32(0x90900010, 0x00001000);

	// Timing Control
	HAL_SETREG32(0x90900018, 0x00000460);

	// Panel border color
	HAL_SETREG32(0x9090004c, 0x00000000);

	// Up Sampling Parameters
	HAL_SETREG32(0x90900064, 0x00012326);

	uapc2700_enable();

	_panel_width  = 1280;
	_panel_height = 1024;
}

void uapc2700_init(unsigned int panel)
{
	switch (panel) {
	case GUC_DEV_PANEL:
		_init_guc_dev_panel();
		break;
	case ACTI_DVI_FB:
		_init_acti_fb_panel();
		break;
	}
}

void uapc2700_set_display(unsigned int width, unsigned height)
//void uapc2700_set_display(unsigned int width, unsigned height,
//						  unsigned int x, unsigned y)
{
	unsigned int w, h;

	w = (width > _panel_width)   ? _panel_width : width;
	h = (height > _panel_height) ? _panel_height : height;

	// Image crop size
	HAL_SETREG32(0x9090003c, (h << 16) + w);

	// Image start position
	//HAL_SETREG32(0x90900040, 0);
	HAL_SETREG32(0x90900040,
				 (((_panel_height - h) / 2) << 16) +
				  (_panel_width - w) / 2);

	// Image stride width
	HAL_SETREG32(0x90900044, width);
}

void uapc2700_set_fb(unsigned char* fb, unsigned int width, unsigned height)
{
	//uapc2700_pause(1);

	// Base address of image
	HAL_SETREG32(0x9090001c, fb);

	// Base address of image
	HAL_SETREG32(0x90900020, fb + width * height);

	//uapc2700_pause(0);
}
