/*
 * Driver for Blackfin on-chip SDH controller
 *
 * Copyright (c) 2008 Analog Devices Inc.
 *
 * Licensed under the GPL-2 or later.
 */

#include <common.h>
#include <malloc.h>
#include <part.h>
#include <mmc.h>

#include <asm/io.h>
#include <asm/errno.h>
#include <asm/arch/hardware.h>

//#include "a1_halSD.c"
//#include "halSD.c"
#include "sdcard.h"
extern int SD_CLK_RATE;
extern struct card_handle cardhandle;

/* support 3.2-3.3V and 3.3-3.4V */
#define CONFIG_SYS_MMC_OP_COND		0x00300000
#define MMC_DEFAULT_RCA		1
static unsigned int mmc_rca;
static int mmc_card_is_sd;
static block_dev_desc_t mmc_blkdev;
struct mmc_cid cid;
static __u32 csd[4];
static uchar spec_ver;

static unsigned long	a1_mmc_bread(int dev, unsigned long start, lbaint_t blkcnt, void *buffer);
static unsigned long	a1_mmc_bwrite(int dev, unsigned long start, lbaint_t blkcnt, const void *buffer);

#define get_bits(resp, start, size)					\
	({								\
		const int __size = size;				\
		const uint32_t __mask = (__size < 32 ? 1 << __size : 0) - 1;	\
		const int32_t __off = 3 - ((start) / 32);			\
		const int32_t __shft = (start) & 31;			\
		uint32_t __res;						\
									\
		__res = resp[__off] >> __shft;				\
		if (__size + __shft > 32)				\
			__res |= resp[__off-1] << ((32 - __shft) % 32);	\
		__res & __mask;						\
	})


block_dev_desc_t *mmc_get_dev(int dev)
{
	return (block_dev_desc_t *) &mmc_blkdev;
}

#define UNSTUFF_BITS(resp,start,size)					\
	({								\
		const int __size = size;				\
		const uint32_t __mask = (__size < 32 ? 1 << __size : 0) - 1;	\
		const int32_t __off = 3 - ((start) / 32);			\
		const int32_t __shft = (start) & 31;			\
		uint32_t __res;						\
									\
		__res = resp[__off] >> __shft;				\
		if (__size + __shft > 32)				\
			__res |= resp[__off-1] << ((32 - __shft) % 32);	\
		__res & __mask;						\
	})
/*
 * Given the decoded CSD structure, decode the raw CID to our CID structure.
 */
static void mmc_decode_cid(uint32_t * resp)
{
	if (IF_TYPE_SD == mmc_blkdev.if_type) {
		/*
		 * SD doesn't currently have a version field so we will
		 * have to assume we can parse this.
		 */
		sprintf((char *)mmc_blkdev.vendor,
			"Man %02x OEM %c%c \"%c%c%c%c%c\" Date %02u/%04u",
			UNSTUFF_BITS(resp, 120, 8), UNSTUFF_BITS(resp, 112, 8),
			UNSTUFF_BITS(resp, 104, 8), UNSTUFF_BITS(resp, 96, 8),
			UNSTUFF_BITS(resp, 88, 8), UNSTUFF_BITS(resp, 80, 8),
			UNSTUFF_BITS(resp, 72, 8), UNSTUFF_BITS(resp, 64, 8),
			UNSTUFF_BITS(resp, 8, 4), UNSTUFF_BITS(resp, 12,
							       8) + 2000);
		sprintf((char *)mmc_blkdev.revision, "%d.%d",
			UNSTUFF_BITS(resp, 60, 4), UNSTUFF_BITS(resp, 56, 4));
		sprintf((char *)mmc_blkdev.product, "%u",
			UNSTUFF_BITS(resp, 24, 32));
	} else {
		/*
		 * The selection of the format here is based upon published
		 * specs from sandisk and from what people have reported.
		 */
		switch (spec_ver) {
		case 0:	/* MMC v1.0 - v1.2 */
		case 1:	/* MMC v1.4 */
			sprintf((char *)mmc_blkdev.vendor,
				"Man %02x%02x%02x \"%c%c%c%c%c%c%c\" Date %02u/%04u",
				UNSTUFF_BITS(resp, 120, 8), UNSTUFF_BITS(resp,
									 112,
									 8),
				UNSTUFF_BITS(resp, 104, 8), UNSTUFF_BITS(resp,
									 96, 8),
				UNSTUFF_BITS(resp, 88, 8), UNSTUFF_BITS(resp,
									80, 8),
				UNSTUFF_BITS(resp, 72, 8), UNSTUFF_BITS(resp,
									64, 8),
				UNSTUFF_BITS(resp, 56, 8), UNSTUFF_BITS(resp,
									48, 8),
				UNSTUFF_BITS(resp, 12, 4), UNSTUFF_BITS(resp, 8,
									4) +
				1997);
			sprintf((char *)mmc_blkdev.revision, "%d.%d",
				UNSTUFF_BITS(resp, 44, 4), UNSTUFF_BITS(resp,
									40, 4));
			sprintf((char *)mmc_blkdev.product, "%u",
				UNSTUFF_BITS(resp, 16, 24));
			break;

		case 2:	/* MMC v2.0 - v2.2 */
		case 3:	/* MMC v3.1 - v3.3 */
		case 4:	/* MMC v4 */
			sprintf((char *)mmc_blkdev.vendor,
				"Man %02x OEM %04x \"%c%c%c%c%c%c\" Date %02u/%04u",
				UNSTUFF_BITS(resp, 120, 8), UNSTUFF_BITS(resp,
									 104,
									 16),
				UNSTUFF_BITS(resp, 96, 8), UNSTUFF_BITS(resp,
									88, 8),
				UNSTUFF_BITS(resp, 80, 8), UNSTUFF_BITS(resp,
									72, 8),
				UNSTUFF_BITS(resp, 64, 8), UNSTUFF_BITS(resp,
									56, 8),
				UNSTUFF_BITS(resp, 12, 4), UNSTUFF_BITS(resp, 8,
									4) +
				1997);
			sprintf((char *)mmc_blkdev.product, "%u",
				UNSTUFF_BITS(resp, 16, 32));
			sprintf((char *)mmc_blkdev.revision, "N/A");
			break;

		default:
			printf("MMC card has unknown MMCA version %d\n",
			       spec_ver);
			break;
		}
	}
	printf("%s card.\nVendor: %s\nProduct: %s\nRevision: %s\n",
	       (IF_TYPE_SD == mmc_blkdev.if_type) ? "SD" : "MMC", mmc_blkdev.vendor,
	       mmc_blkdev.product, mmc_blkdev.revision);
}

/*
 * Given a 128-bit response, decode to our card CSD structure.
 */
static void mmc_decode_csd(uint32_t * resp)
{
	unsigned int mult, csd_struct;

	if (IF_TYPE_SD == mmc_blkdev.if_type) {
		csd_struct = UNSTUFF_BITS(resp, 126, 2);
		if (csd_struct != 0) {
			printf("SD: unrecognised CSD structure version %d\n",
			       csd_struct);
			return;
		}
	} else {
		/*
		 * We only understand CSD structure v1.1 and v1.2.
		 * v1.2 has extra information in bits 15, 11 and 10.
		 */
		csd_struct = UNSTUFF_BITS(resp, 126, 2);
		if (csd_struct != 1 && csd_struct != 2) {
			printf("MMC: unrecognised CSD structure version %d\n",
			       csd_struct);
			return;
		}

		spec_ver = UNSTUFF_BITS(resp, 122, 4);
		mmc_blkdev.if_type = IF_TYPE_MMC;
	}

	mult = 1 << (UNSTUFF_BITS(resp, 47, 3) + 2);
	mmc_blkdev.lba = (1 + UNSTUFF_BITS(resp, 62, 12)) * mult;
	mmc_blkdev.blksz = 1 << UNSTUFF_BITS(resp, 80, 4);

	/* FIXME: The following just makes assumes that's the partition type -- should really read it */
	mmc_blkdev.part_type = PART_TYPE_DOS;
	mmc_blkdev.dev = 0;
	mmc_blkdev.lun = 0;
	mmc_blkdev.type = DEV_TYPE_HARDDISK;
	mmc_blkdev.removable = 0;
	mmc_blkdev.block_read = a1_mmc_bread;
	mmc_blkdev.block_write = a1_mmc_bwrite;

	printf("Detected: %lu blocks of %lu bytes (%luMB) ",
		mmc_blkdev.lba,
		mmc_blkdev.blksz,
		mmc_blkdev.lba * mmc_blkdev.blksz / (1024 * 1024));
}


static int
mmc_cmd(unsigned long cmd, unsigned long arg, void *resp, unsigned long flags)
{
	unsigned int sdh_cmd;
	unsigned int status;
	int ret = 0;
	sdh_cmd = 0;
	unsigned long *response = resp;
	sdh_cmd |= cmd;

	
	return ret;
}

static int
mmc_acmd(unsigned long cmd, unsigned long arg, void *resp, unsigned long flags)
{
	unsigned long aresp[4];
	int ret = 0;

//	ret = a1_mmc_cmd(MMC_CMD_APP_CMD, 0, aresp,
//		      MMC_RSP_PRESENT);
//	if (ret)
//		return ret;
//
//	if ((aresp[0] & (ILLEGAL_COMMAND | APP_CMD)) != APP_CMD)
//		return -ENODEV;
	ret = mmc_cmd(cmd, arg, resp, flags);
	return ret;
}

static unsigned long
a1_mmc_bread(int dev, unsigned long start, lbaint_t blkcnt, void *buffer)
{
	if (blkcnt == 0)
		return 0;

	//debug("mmc_bread: dev %d, start %d, blkcnt %d\n", dev, start, blkcnt);
	if (halSDReadNSector(start, blkcnt, buffer))
		return blkcnt;
	else
		return 0;
}

static unsigned long
a1_mmc_bwrite(int dev, unsigned long start, lbaint_t blkcnt, const void *buffer)
{
	if (blkcnt == 0)
		return 0;

	//debug("mmc_bwrite: dev %d, start %lx, blkcnt %lx\n", dev, start, blkcnt);

	if (halSDWriteNSector(start, blkcnt, buffer))
		return blkcnt;
	else
		return 0;
}

static void mmc_parse_cid(struct mmc_cid *cid, unsigned long *resp)
{
	cid->mid = resp[0] >> 24;
	cid->oid = (resp[0] >> 8) & 0xffff;
	cid->pnm[0] = resp[0];
	cid->pnm[1] = resp[1] >> 24;
	cid->pnm[2] = resp[1] >> 16;
	cid->pnm[3] = resp[1] >> 8;
	cid->pnm[4] = resp[1];
	cid->pnm[5] = resp[2] >> 24;
	cid->pnm[6] = 0;
	cid->prv = resp[2] >> 16;
	cid->psn = (resp[2] << 16) | (resp[3] >> 16);
	cid->mdt = resp[3] >> 8;
}

static void sd_parse_cid(struct mmc_cid *cid, unsigned long *resp)
{
	cid->mid = resp[0] >> 24;
	cid->oid = (resp[0] >> 8) & 0xffff;
	cid->pnm[0] = resp[0];
	cid->pnm[1] = resp[1] >> 24;
	cid->pnm[2] = resp[1] >> 16;
	cid->pnm[3] = resp[1] >> 8;
	cid->pnm[4] = resp[1];
	cid->pnm[5] = 0;
	cid->pnm[6] = 0;
	cid->prv = resp[2] >> 24;
	cid->psn = (resp[2] << 8) | (resp[3] >> 24);
	cid->mdt = (resp[3] >> 8) & 0x0fff;
}

static void mmc_dump_cid(const struct mmc_cid *cid)
{
	printf("CID information:\n");
	printf("Manufacturer ID:       %02X\n", cid->mid);
	printf("OEM/Application ID:    %04X\n", cid->oid);
	printf("Product name:          %s\n", cid->pnm);
	printf("Product Revision:      %u.%u\n",
	       cid->prv >> 4, cid->prv & 0x0f);
	printf("Product Serial Number: %lu\n", cid->psn);
	printf("Manufacturing Date:    %02u/%02u\n",
	       cid->mdt >> 4, cid->mdt & 0x0f);
}

static void mmc_dump_csd(__u32 *csd)
{
	printf("CSD information:\n");
	printf("CSD structure version:   1.%u\n", get_bits(csd, 126, 2));
	printf("Card command classes:    %03x\n", get_bits(csd, 84, 12));
	printf("Max trans speed: %s\n", (get_bits(csd, 96, 8) == 0x32) ? "25MHz" : "50MHz");
	printf("Read block length:       %d\n", 1 << get_bits(csd, 80, 4));
	printf("Write block length:      %u\n", 1 << get_bits(csd, 22, 4));
	printf("Card capacity:		%u bytes\n",
	       (get_bits(csd, 62, 12) + 1) * (1 << (get_bits(csd, 47, 3) + 2)) *
	       (1 << get_bits(csd, 80, 4)));
	putc('\n');
}



int mmc_legacy_init(int verbose)
{
	int ret;
	unsigned int max_blksz;

	SD_CLK_RATE = (CONFIG_SYS_CLK_FREQ / 2 / 1000000);
	/* Initialize sdh controller */
	cardhandle.CLK_DIV = 1;
	if(SdInit())
		cardhandle.sd_ready = 1;
	else
		cardhandle.sd_ready = 0;

//	sd_parse_cid(&cid, cardhandle.CID); 
	memcpy(&csd, cardhandle.CSD, 16);


	mmc_blkdev.if_type = IF_TYPE_MMC;
	mmc_blkdev.part_type = PART_TYPE_DOS;

#if 1
	mmc_decode_csd(&csd);
	mmc_decode_cid(&cardhandle.CID);
	/* fill in device description */

	mmc_blkdev.lun = 0;
	mmc_blkdev.type = 0;

//	mmc_blkdev.blksz = 1 << ((csd[1] >> 16) & 0xf);
//	mmc_blkdev.lba = lldiv(mmc->capacity, mmc->read_bl_len);

//	sprintf(mmc_blkdev.vendor, "Man %06x Snr %08x", cid[0] >> 8,
//			(cid[2] << 8) | (cid[3] >> 24));
//	sprintf(mmc_blkdev.product, "%c%c%c%c%c", cid[0] & 0xff,
//			(cid[1] >> 24), (cid[1] >> 16) & 0xff,
//			(cid[1] >> 8) & 0xff, cid[1] & 0xff);
//	sprintf(mmc_blkdev.revision, "%d.%d", cid[2] >> 28,
//			(cid[2] >> 24) & 0xf);
//	init_part(&mmc_blkdev);
#else

	mmc_dump_cid(&cid);
	printf("-------------------------------------------------------------------------\n");
	mmc_dump_csd(csd);
	printf("-------------------------------------------------------------------------\n");

	mmc_blkdev.dev = 0;
	mmc_blkdev.lun = 0;
	mmc_blkdev.type = 0;

	sprintf(mmc_blkdev.vendor,
		"Man %02x%04x Snr %08lx",
		cid.mid, cid.oid, cid.psn);
	strncpy(mmc_blkdev.product, cid.pnm,
		sizeof(mmc_blkdev.product));
	sprintf(mmc_blkdev.revision, "%x %x",
		cid.prv >> 4, cid.prv & 0x0f);

	max_blksz = 1 << get_bits(csd, 80, 4);

//	mmc_blkdev.blksz = 512;
	mmc_blkdev.blksz = max_blksz;
	mmc_blkdev.removable = 0;
	mmc_blkdev.lba = (get_bits(csd, 62, 12) + 1) * (1 << (get_bits(csd, 47, 3) + 2));

	mmc_blkdev.block_read = a1_mmc_bread;
	mmc_blkdev.block_write = a1_mmc_bwrite;
#endif
	fat_register_device(&mmc_blkdev, 1);
	return 0;
}

