/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <asm/arch/vic.h>

extern unsigned int GET_APBCLOCK();


#define TimerCnt2 2
static volatile unsigned int _tick = 0;

static unsigned int _interval = 0;


static void timer2_isr(void)
{
	vic_cleanirq(tmr2_intr);

	++_tick;
}

void timer2_start(unsigned int interval/* in ms */)
{
	/* disable timer (counter) interrupts */
	vic_disirq(tmr2_intr);

	/* register timer service routines */
	reg_interrupt(USE_IRQ, tmr2_intr, timer2_isr);

	/* Setup .... */
	_tick = 0;
	_interval = interval;
	EnableTimer(TimerCnt2, 0 , 0, GET_APBCLOCK() * interval / 1000);

	/* clear pending interrupts and start it */
	vic_cleanirq(tmr2_intr);
	vic_enirq(tmr2_intr);
}

void timer2_stop()
{
	DisableTimer(TimerCnt2);
	unregister_interrupt(tmr2_intr);
}

unsigned int timer2_now()
{
	return _tick;
}

unsigned int timer2_interval()
{
	return _interval;
}
