/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>


#include "hal.h"

#define halGetTicks					get_ticks
#define halTimerEnable				EnableTimer
#define halUARTSetBaudRate(x,y,z)	serial_init()
#define HAL_TICKS_PER_SEC			1000

#define halcTimer1Cnt1				0


int do_sys(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int cpu_clk, ahb_clk, clk;
	unsigned int divider;

	if (argc == 3)
	{
		if((!sysStrToN(argv[2], &divider)) || (divider <=0))
		{
			printf("divider should >= 1 \n\r");
			return (FALSE);
		}
		if(strcmp("h8290", argv[1]) == 0)
			clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_H8290, divider);
		else if(strcmp("vcap", argv[1]) == 0)
			clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_VCAP, divider);
		else if(strcmp("sdc", argv[1]) == 0)
			clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SDC, divider);
		else if(strcmp("i2s", argv[1]) == 0)
			clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_I2S, divider);
		else if(strcmp("isp", argv[1]) == 0)
			clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_ISP, divider);
		else if(strcmp("sensor_out", argv[1]) == 0)
			clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SENSOR, divider);
		else if(strcmp("sensor_div", argv[1]) == 0)
			clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SENSOR_DIV, divider);
		else if(strcmp("nand", argv[1]) == 0)
			clk = halSysSetDeviceClockDivider(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_NAND, divider);
		else
		{
			printf("Can not support %s. Can only supoort h8290/vcap/sdc/i2s/sensor_out/nand \n\r", argv[1]);
			return (FALSE);
		}
		printf("Change %s to %dKHz(by divid %d) \n\r", argv[1], clk/1000 , divider);
	}

	ahb_clk = PLL_GetAHBClock(CONFIG_SYS_INPUT_CLOCK);
	cpu_clk = ahb_clk * (CPU_GetTurbo() == 1 ? 2 : 1);
	printf("ASIC mode : CPU clock=%dKHz, system clock=%dKHz \n\r", cpu_clk/1000, ahb_clk/1000);

	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_VCAP, &divider);
	printf("VCAP clk src=%dKHz(by divide %d)\n\r", clk/1000, divider);
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_ISP, &divider);
	printf("ISP clk src=%dKHz(by divide %d) \n\r", clk/1000, divider);
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SENSOR, &divider);
	printf("sensor out clk src=%dKHz(by divide %d)\n\r", clk/1000, divider);
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SENSOR_DIV, &divider);
	printf("sensor div clk src=%dKHz(by divide %d)\n\r", clk/1000, divider);
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_H8290, &divider);
	printf("H8290 clk src=%dKHz(by divide %d)\n\r", clk/1000, divider);
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_H9170, &divider);
	printf("H9170 clk src=%dKHz(by divide %d)\n\r", clk/1000, divider);
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SDC, &divider);
	printf("SDC clk src=%d KHz(by divide %d)\n\r", clk/1000, divider);
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_NAND, &divider);
	printf("NAND clk src=%d KHz(by divide %d)\n\r", clk/1000, divider);
	clk = halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_I2S, &divider);
	printf("I2S clk src=%d KHz(by divide %d)\n\r", clk/1000, divider);

	return TRUE;
}

int do_cpu(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int turbo = 0, count = 0, result;
	unsigned long long ticks_1, ticks_2;

	if (argc == 1)
	{
		printf("\rCPU Turbo %s\n\r", (CPU_GetTurbo()  == 1) ? "on" : "off");
		return TRUE;
	}

	/* change CPU turbo mode */
	turbo = simple_strtoul(argv[1], NULL, 10);

	if((turbo != 0) &&(turbo != 1))
	{
		printf("turbo should be 0 or 1\n\r");
		return (FALSE);
	}
	if(CPU_SetTurbo(turbo) == 0)
	{
		printf("CPU change mode failed\n\r");
		return FALSE;
	}
	printf("CPU turbo mode change  to %s\n\r", (CPU_GetTurbo() == 1) ? "on" : "off");

#if 1 // test only
#if 0
	/* do performance test to check the CPU mode is changed or not */
	count = simple_strtoul(argv[2], NULL, 10);
	if(count > 0)
	{
		printf("Doing performance testing(loop=%d)....Please Wait....\n\r", count);
		ticks_1 = get_ticks();
		result = CPU_PerformaceTest(count);
		ticks_2 = get_ticks();
		printf("cpu change&performace test done and take %ld ticks \n\r", ticks_2 - ticks_1);
	}
#else
	/* do performance test to check the CPU mode is changed or not */
	count = simple_strtoul(argv[2], NULL, 10);
	if(count > 0)
	{
		timer2_start(10);				// 10 ms
		printf("Doing performance testing(loop=%d)....Please Wait....\n\r", count);
		ticks_1 = timer2_now();
		result = CPU_PerformaceTest(count);
		ticks_2 = timer2_now();
		printf("performace test done and take %ld ms \n\r", (ticks_2 - ticks_1) * 10);
		timer2_stop();
	}
#endif
#endif
	return TRUE;
}

#if 1 // testing only
int do_pll0_fcs(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int count, reg, Fout, Fin, NR, NO, NF;
	int ticks_1, ticks_2, test_time, i;

	unsigned int test_nf_table[] ={74, 45, 30};
	unsigned int test_time_table[] = {42, 69, 103};

	Fin = CONFIG_SYS_INPUT_CLOCK;

	if (argc != 2) {
		printf("Usage:\n\t%s%s", cmdtp->usage, cmdtp->help);
		return (FALSE);
	}

	if(!sysStrToN(argv[1], &count))
	{
		printf("count error \n\r");
		return (FALSE);
	}

	CPU_SetTurbo(1);	// set CPU = 2 * AHB
	NR = 0; NO =1;
	while(count-- > 0)
	{
		for(i = 0; i < (sizeof(test_nf_table)/4);i++)
		{
			NF = test_nf_table[i];
			PLL0_FCS(Fin, NR, NF, NO);

			serial_init(); // re-init uart
			device_clk_init();

			reg = PLL_GetFCS(0, &NR, &NF, &NO);
			Fout = PLL_GetFout(0, Fin);
			printf("\n\r\r%d = %d*(%d(NR)+1)*(%d(NF)+1)/(1<<%d(N0)): pll0_reg=0x%08x AHB=%d APB=%d\n\r", Fout, Fin, NR, NF, NO, reg, PLL_GetAHBClock(Fin), PLL_GetAPBClock(Fin));
			/* do performance test to check changing PLL is OK or not */
			timer2_start(10);				// 10 ms
			ticks_1 = timer2_now();
			CPU_PerformaceTest(8000000);
			ticks_2 = timer2_now();
			test_time = (ticks_2 - ticks_1);
			timer2_stop();

			if((test_time == test_time_table[i]) || (test_time == (test_time_table[i] +1)) || (test_time == (test_time_table[i]-1)))
			{
				printf("performace test done and take %ld ms, but expect test time is %d ms\n\r", test_time * 10, test_time_table[i] * 10);
			}
			else
			{
				printf("performace test done and take %ld ms, but expect test time is %d ms\n\r", test_time * 10, test_time_table[i] * 10);
				printf("TEST FAILED!!!!\n");
				printf("TEST FAILED!!!!\n");
				printf("TEST FAILED!!!!\n");
				printf("TEST FAILED!!!!\n");
				printf("TEST FAILED!!!!\n");
				return (FALSE);
			}

			udelay_masked(100);
		}
	}
	return (TRUE);
}

int do_pll1_fcs(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)

{
	unsigned int count, reg, Fout, Fin, NR, NO, NF;
	int ticks_1, ticks_2, test_time, i;

	unsigned int test_nf_table[] ={62, 46, 27};
	unsigned int test_time_table[] = {111, 124, 157};

	Fin = CONFIG_SYS_INPUT_CLOCK;

	if (argc != 2) {
		printf("Usage:\n\t%s%s", cmdtp->usage, cmdtp->help);
		return (FALSE);
	}

	if(!sysStrToN(argv[1], &count))
	{
		printf("count error \n\r");
		return (FALSE);
	}

	CPU_SetTurbo(1);	// set CPU = 2 * AHB
	NR = 0; NO =1;
	while(count-- > 0)
	{
		for(i = 0; i < (sizeof(test_nf_table)/4);i++)
		{
			NF = test_nf_table[i];
			PLL1_FCS(Fin, NR, NF, NO);

			reg = PLL_GetFCS(1, &NR, &NF, &NO);
			Fout = PLL_GetFout(1, Fin);
			printf("\n\r\r%d = %d*(%d(NR)+1)*(%d(NF)+1)/(1<<%d(N0)): pll0_reg=0x%08x AHB=%d APB=%d\n\r", Fout, Fin, NR, NF, NO, reg, PLL_GetAHBClock(Fin), PLL_GetAPBClock(Fin));
			/* do performance test to check changing PLL is OK or not */
			timer2_start(10);				// 10 ms
			ticks_1 = timer2_now();
			Mem_PerformanceTest(1000);
			ticks_2 = timer2_now();
			test_time = (ticks_2 - ticks_1);
			timer2_stop();

			if((test_time == test_time_table[i]) || (test_time == (test_time_table[i] +1)) || (test_time == (test_time_table[i]-1)))
			{
				printf("performace test done and take %ld ms, but expect test time is %d ms\n\r", test_time * 10, test_time_table[i] * 10);
			}
			else
			{
				printf("performace test done and take %ld ms, but expect test time is %d ms\n\r", test_time * 10, test_time_table[i] * 10);
				printf("TEST FAILED!!!!\n");
				printf("TEST FAILED!!!!\n");
				printf("TEST FAILED!!!!\n");
				printf("TEST FAILED!!!!\n");
				printf("TEST FAILED!!!!\n");
				return (FALSE);
			}
		}
	}
	return (TRUE);
}


U_BOOT_CMD(
	pll0_fcs, 2, 2,	do_pll0_fcs,
	"test pll0 FCS",
	"[count]\n"
);


U_BOOT_CMD(
	pll1_fcs, 2, 2,	do_pll1_fcs,
	"test pll0 FCS",
	"[count]\n"
);

#endif

int do_pll0(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int Fin, NR, NF, NO, Fout, reg;

	Fin = CONFIG_SYS_INPUT_CLOCK;

	if (argc == 1)
	{
		reg = PLL_GetFCS(0, &NR, &NF, &NO);
		Fout = PLL_GetFout(0, Fin);
		printf("\r%d = %d*(%d(NR)+1)*(%d(NF)+1)/(1<<%d(N0)): pll0_reg=0x%08x AHB=%d APB=%d\n\r", Fout, Fin, NR, NF, NO, reg, PLL_GetAHBClock(Fin), PLL_GetAPBClock(Fin));
		return TRUE;
	}

	if (argc != 4) {
		printf("Usage:\n\t%s%s", cmdtp->usage, cmdtp->help);
		return (FALSE);
	}

	if((!sysStrToN(argv[1], &NR)) || (!sysStrToN(argv[2], &NF)) || (!sysStrToN(argv[3], &NO)))
	{
		printf("NR/NF/NO error \n\r");
		return (FALSE);
	}

	PLL0_FCS(Fin, NR, NF, NO);

	serial_init(); // re-init uart
//	halTimerEnable(halcTimer1Cnt1, 0, 0, halSysGetDeviceClockSrc(Fin, HAL_MFP_TMR, NULL)/HAL_TICKS_PER_SEC);
//	printf("\rRe-init UART & Timer Clock\n\r");

	reg = PLL_GetFCS(0, &NR, &NF, &NO);
	Fout = PLL_GetFout(0, Fin);
	printf("\r%d = %d*(%d(NR)+1)*(%d(NF)+1)/(1<<%d(N0)): pll0_reg=0x%08x AHB=%d APB=%d\n\r", Fout, Fin, NR, NF, NO, reg, PLL_GetAHBClock(Fin), PLL_GetAPBClock(Fin));

//	printf("\rRe-init device clks\n\r");
	device_clk_init();

#if 1 // test only
	unsigned long long ticks_1, ticks_2, count = 8000000;
	/* do performance test to check changing PLL is OK or not */
	timer2_start(10);				// 10 ms
	printf("Doing performance testing(loop=%d)....Please Wait....\n\r", count);
	ticks_1 = timer2_now();
	CPU_PerformaceTest(count);
	ticks_2 = timer2_now();
	printf("performace test done and take %ld ms \n\r", (ticks_2 - ticks_1) * 10);
	timer2_stop();
#endif

	return (TRUE);
}

int do_pll1(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)

{
	unsigned int Fin, NR, NF, NO, Fout, reg;

	Fin = CONFIG_SYS_INPUT_CLOCK;

	if (argc == 1)
	{
		reg = PLL_GetFCS(1, &NR, &NF, &NO);
		Fout = PLL_GetFout(1, Fin);
		printf("\r%d = %d*(%d(NR)+1)*(%d(NF)+1)/(1<<%d(N0)): pll1_reg=0x%08x DDR=%d 8290=%d\n\r", Fout, Fin, NR, NF, NO, reg, Fout, Fout);
		return TRUE;
	}

	if (argc != 4) {
		printf("Usage:\n%s\n", cmdtp->usage);
		return FALSE;
	}

	if((!sysStrToN(argv[1], &NR)) || (!sysStrToN(argv[2], &NF)) || (!sysStrToN(argv[3], &NO)))
	{
		printf("Fin/NR/NF/NO error \n\r");
		return (FALSE);
	}

	PLL1_FCS(Fin, NR, NF, NO); // PLL 1 is used for DDR

	reg = PLL_GetFCS(1, &NR, &NF, &NO);
	Fout = PLL_GetFout(1, Fin);
	printf("\r%d = %d*(%d(NR)+1)*(%d(NF)+1)/(1<<%d(N0)): pll1_reg=0x%08x DDR=%d 8290=%d\n\r", Fout, Fin, NR, NF, NO, reg, Fout, Fout);

	printf("\rRe-init device clks\n\r");
	device_clk_init();


#if 1 // test only
	unsigned long long ticks_1, ticks_2, count = 1000;
	/* do performance test to check changing PLL is OK or not */
	timer2_start(10);				// 10 ms
	printf("Doing performance testing(loop=%d)....Please Wait....\n\r", count);
	ticks_1 = timer2_now();
	Mem_PerformanceTest(count);
	ticks_2 = timer2_now();
	printf("performace test done and take %ld ms \n\r", (ticks_2 - ticks_1) * 10);
	timer2_stop();
#endif

	return (TRUE);
}


U_BOOT_CMD(
	sys, 3,	1,	do_sys,
	"get/configure device clock",
	"[device_name(h8290/vcap/sdc/i2s/sensor_out/sensor_div)] [divider]\n"
);

U_BOOT_CMD(
	cpu, 3,	1,	do_cpu,
	"configure cpu turbo mode",
	"[0/1]\n"
	"	- cpu [0/1] [performance_test_count]\n"
);

U_BOOT_CMD(
	pll0, 4, 1,	do_pll0,
	"get/configure pll 0 clock",
	"[NR] [NF] [NO]\n"
);

U_BOOT_CMD(
	pll1, 4, 1,	do_pll1,
	"get/configure pll 1 clock",
	"[NR] [NF] [NO]\n"
);
