/*
 * (C) Copyright 2010
 * Texas Instruments Incorporated, <www.ti.com>
 * Steve Sakoman  <steve@sakoman.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/hardware.h>
#include <nand.h>

extern void __A1_WriteSerial(const char *);

DECLARE_GLOBAL_DATA_PTR;

extern int get_nand_env_oob(nand_info_t *nand, unsigned long *result);
extern nand_info_t nand_info[CONFIG_SYS_MAX_NAND_DEVICE];
#ifdef CONFIG_ENV_OFFSET_OOB
extern unsigned long nand_env_oob_offset;
extern int saveenv(void);
#endif 

#ifdef MT9P031_1080P_30FPS
extern void ISP_init();
extern void MT9P031_1080P_30FPS_init();
#endif

/**
 * @brief board_init
 *
 * @return 0
 */
int board_init(void)
{
	gd->bd->bi_arch_number = MACH_TYPE_ACTi_A1;
	gd->bd->bi_boot_params = LINUX_BOOT_PARAM_ADDR; /* boot param addr */

	return 0;
}

/*------------------------------------------------------------------
 * Set DRAM info
 */
inline int dram_init (void)
{
	gd->bd->bi_dram[0].start = PHYS_SDRAM_1;
	gd->bd->bi_dram[0].size  = PHYS_SDRAM_1_SIZE;
	return 0;
}

/*
 * If soc-specific initialization needed, implement here
 *
 */
int cpu_eth_init(bd_t *bis)
{
	FTrace("enter");
	return 0;
}

/**
 * @brief misc_init_r - Configure Panda board specific configurations
 * such as power configurations, ethernet initialization as phase2 of
 * boot sequence
 *
 * @return 0
 */
int misc_init_r(void)
{
	FTrace("enter");
	return 0;
}

#ifdef CONFIG_GENERIC_MMC
int board_mmc_init(bd_t *bis)
{
	FTrace("enter");
//	omap_mmc_init(0);
	return 0;
}
#endif

/**
 * Function to pre-processing of OOB mark
 */

#ifdef CONFIG_ENV_OFFSET_OOB
int update_env_oob(void)
{
	int ret;
	ulong addr;
	nand_info_t *nand = &nand_info[0];
	size_t dummy_size;
	struct mtd_oob_ops ops;
	uint32_t oob_buf[ENV_OFFSET_SIZE/sizeof(uint32_t)];
	char **	env_part = malloc(128);

	env_part[0] = &CFG_A1_PART_ENV_NAME;

	if (arg_off_size(1, env_part, nand, &addr,
			 &dummy_size) < 0) {
		printf("Offset or partition name expected\n");
		return 1;
	}

	if (nand->oobavail < ENV_OFFSET_SIZE) {
		printf("Insufficient available OOB bytes:\n"
		       "%d OOB bytes available but %d required for "
		       "env.oob support\n",
		       nand->oobavail, ENV_OFFSET_SIZE);
		return 1;
	}

	if ((addr & (nand->erasesize - 1)) != 0) {
		printf("Environment offset must be block-aligned\n");
		return 1;
	}

	ops.datbuf = NULL;
	ops.mode = MTD_OOB_AUTO;
	ops.ooboffs = 0;
	ops.ooblen = ENV_OFFSET_SIZE;
	ops.oobbuf = (void *) oob_buf;

	oob_buf[0] = ENV_OOB_MARKER;
	oob_buf[1] = addr / nand->erasesize;

	ret = nand->write_oob(nand, ENV_OFFSET_SIZE, &ops);
	if (ret) {
		printf("Error writing OOB block 0\n");
		return ret;
	}

	ret = get_nand_env_oob(nand, &nand_env_oob_offset);
	if (ret) {
		printf("Error reading env offset in OOB\n");
		return ret;
	}

	if (addr != nand_env_oob_offset) {
		printf("Verification of env offset in OOB failed: "
		       "0x%08lx expected but got 0x%08lx\n",
		       addr, nand_env_oob_offset);
		return 1;
	}
}
#endif 

#define XMK_STR(x)	#x
#define MK_STR(x)	XMK_STR(x)

void version_checking_update(void)
{
#ifdef CONFIG_A1_FW_VERSION
	char *s = NULL;
	int res = -1;
	char oldenv[256];
	char p_ipaddr[32], p_ethaddr[32], p_serverip[32];

	uchar fw_version_string[64] = {
		MK_STR(CONFIG_A1_FW_VERSION)"\0" };

	if (s = getenv("revision"))
		if(!strcmp(s, fw_version_string))
			return;

	printf ("\n\n >>> Save and update \"revision\" : %s\n", fw_version_string);
	//////////////////////////////////////////////////////////////////////////
	/* Reservce old user-environment setting, only ipaddr, ethaddr, serverip */
	if (s = getenv("ipaddr"))	strcpy(p_ipaddr, s);
	if (s = getenv("ethaddr"))	strcpy(p_ethaddr, s);
	if (s = getenv("serverip"))	strcpy(p_serverip, s);

	set_default_env();
	//////////////////////////////////////////////////////////////////////////
	setenv ("revision", fw_version_string);
	if (p_ipaddr[0])	setenv ("ipaddr", p_ipaddr);
	if (p_ethaddr[0]) 	setenv ("ethaddr", p_ethaddr);
	if (p_serverip[0])	setenv ("serverip", p_serverip);
	saveenv();
#endif
}

#ifdef CONFIG_RANDOM_MAC
static unsigned long int next = 1;

unsigned long rand(void)
{
    next = next * 1103515245 + 12345;
    return next;
}

void srand(unsigned long seed)
{
    next = seed;
}

int etheraddr_random_gen(void)
{
	ulong timer_tick;
	char ethaddr[18];
    unsigned long ethaddr_low, ethaddr_high;

	timer_tick = get_timer_raw();

	srand(timer_tick);

    ethaddr_high = (rand() & 0x000f) | 0x0010; // setting the most significant 2 bytes of the address to meet ACTi's random mac address format
    ethaddr_low = rand();

    sprintf(ethaddr, "%02lx:%02lx:%02lx:%02lx:%02lx:%02lx\0",
	ethaddr_high >> 8, ethaddr_high & 0xff,
	ethaddr_low >> 24, (ethaddr_low >> 16) & 0xff,
	(ethaddr_low >> 8) & 0xff, ethaddr_low & 0xff);

    printf("random mac=%s\n", ethaddr);
	setenv("ethaddr", ethaddr);
	saveenv();
}
#endif

#ifdef BOARD_LATE_INIT
int board_late_init(void)
{

#ifdef CONFIG_CMDLINE_TAG
		char temp[256];
		char *mtdparts = getenv("mtdparts");
#endif

#ifdef CONFIG_ENV_OFFSET_OOB
	int ret;
	
	ret = get_nand_env_oob(&nand_info[0], &nand_env_oob_offset);
	if (ret) {
		struct mtd_info * mtd = &nand_info[0];
		struct nand_chip * chip = (struct nand_chip *) mtd->priv;


//		printf("Error reading env offset in OOB\n");
		printf("Can not find env offset in block0, try to rebuild it & re-configure MTD tables.....\n");

		// scan bbt first
		if (!(chip->options & NAND_BBT_SCANNED)) {
			chip->options |= NAND_BBT_SCANNED;
			chip->scan_bbt(mtd);
		}

		// invoke dynpart, dynpart will also update mtdparts variable,
		// and get correct partition location for environment
		nand_create_mtd_dynpart(&nand_info[0]);

		// invoke nand env.oob set, initialize variable "nand_env_oob_offset"
		update_env_oob();


		// get old Uboot environment settings. But this will reset mtdparts
		env_relocate_spec();	//added by Ted

		// After relocate environment, re-do dynpart to update mtdparts variable
		nand_create_mtd_dynpart(&nand_info[0]);


#ifdef CONFIG_CMDLINE_TAG
		mtdparts = getenv("mtdparts");
//		sprintf(temp, "root=0100 initrd=0x50800000,24M mem=128M console=ttyS0 %s", mtdparts);
		sprintf(temp, "root=0100 console=ttyS0 user_dbug=8 %s,-(rsvd)", mtdparts);
		setenv("bootargs", temp);
#endif
		// saveenv
		saveenv();
	}
#endif

//	version_checking_update();

//#ifdef MT9P031_1080P_30FPS
//	ISP_init();
//	MT9P031_1080P_30FPS_init ();
//#endif
}
#endif
#ifdef CONFIG_CMD_NAND
unsigned int dynpart_size[] = {
    0x100000, 0x20000, 0xB00000, 0x1400000, 0x1400000, 0x100000, 0x100000, 0x800000, 0 };
char *dynpart_names[] = {
    "uboot", "uboot-env", "config", "bootp1", "bootp2", "ispconf1", "ispconf2", "ispdata", NULL };
#endif

/*************************************************************************************************/
//#if defined (CONFIG_SETUP_MEMORY_TAGS) || \
//    defined (CONFIG_CMDLINE_TAG) || \
//    defined (CONFIG_INITRD_TAG) || \
//    defined (CONFIG_SERIAL_TAG) || \
//    defined (CONFIG_REVISION_TAG)
//static void setup_start_tag (bd_t *bd);
//
//# ifdef CONFIG_SETUP_MEMORY_TAGS
//static void setup_memory_tags (bd_t *bd);
//# endif
//static void setup_commandline_tag (bd_t *bd, char *commandline);
//
//# ifdef CONFIG_INITRD_TAG
//static void setup_initrd_tag (bd_t *bd, ulong initrd_start,
//			      ulong initrd_end);
//# endif
//static void setup_end_tag (bd_t *bd);
//
//static struct tag *params;
//#endif /* CONFIG_SETUP_MEMORY_TAGS || CONFIG_CMDLINE_TAG || CONFIG_INITRD_TAG */

int do_a1_tags(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	bd_t	*bd = gd->bd;
	char	*s;
	int	machid = bd->bi_arch_number;
	ulong rd_start, rd_size;

	extern struct tag *params;

#ifdef CONFIG_CMDLINE_TAG
	char temp[256];
	char *mtdparts = getenv("mtdparts");
//		sprintf(temp, "root=0100 initrd=0x50800000,24M mem=128M console=ttyS0 %s", mtdparts);
	sprintf(temp, "root=0100 console=ttyS0 user_debug=8 %s,-(rsvd)", mtdparts);
	setenv("bootargs", temp);
	char *commandline = getenv ("bootargs");
#endif

	if ((flag != 0) && (flag != BOOTM_STATE_OS_GO))
		return 1;

	s = getenv ("machid");
	if (s) {
		machid = simple_strtoul (s, NULL, 16);
		printf ("Using machid 0x%x from environment\n", machid);
	}


#if defined (CONFIG_SETUP_MEMORY_TAGS) || \
    defined (CONFIG_CMDLINE_TAG) || \
    defined (CONFIG_INITRD_TAG) || \
    defined (CONFIG_SERIAL_TAG) || \
    defined (CONFIG_REVISION_TAG)
	setup_start_tag (bd);
#ifdef CONFIG_SERIAL_TAG
	setup_serial_tag (&params);
#endif
#ifdef CONFIG_REVISION_TAG
	setup_revision_tag (&params);
#endif
#ifdef CONFIG_SETUP_MEMORY_TAGS
	setup_memory_tags (bd);	// for mem=128M
#endif
#ifdef CONFIG_CMDLINE_TAG
	setup_commandline_tag (bd, commandline);	// command line will overwrite the memory tags
#endif
#ifdef CONFIG_INITRD_TAG
//	setup_initrd_tag (bd, images->rd_start, images->rd_end);
	s = getenv ("ramdiskaddr");
	if (s) {
		rd_start = simple_strtoul (s, NULL, 16);
	}
	rd_size = 24*1024*1024;
	printf ("Using 0x%08x 0x%08x from environment as initrd \n", rd_start, rd_size);
	setup_initrd_tag (bd, rd_start, rd_start + rd_size  );
#endif
#ifdef CONFIG_ACTI
	setup_A1_macaddr_tag (bd);
#endif
	setup_end_tag (bd);
#endif

	return 1;
}

int do_a1_tags_old(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	bd_t	*bd = gd->bd;
	char	*s;
	int	machid = bd->bi_arch_number;

#ifdef CONFIG_CMDLINE_TAG

	char temp[256];
	char *mtdparts = getenv("mtdparts");
//	sprintf(temp, "root=0100 initrd=0x50800000,24M mem=128M console=ttyS0 %s", mtdparts);
//	sprintf(temp, "root=0100 console=ttyS0 %s", mtdparts);
	sprintf(temp, "root=0100 initrd=0x50800000,24M console=ttyS0 %s", mtdparts);
	setenv("bootargs", temp);

	char *commandline = getenv ("bootargs");
#endif

	s = getenv ("machid");
	if (s) {
		machid = simple_strtoul (s, NULL, 16);
		printf ("Using machid 0x%x from environment\n", machid);
	}

#if defined (CONFIG_SETUP_MEMORY_TAGS) || \
    defined (CONFIG_CMDLINE_TAG) || \
    defined (CONFIG_INITRD_TAG) || \
    defined (CONFIG_SERIAL_TAG) || \
    defined (CONFIG_REVISION_TAG)
	setup_start_tag (bd);
#ifdef CONFIG_SERIAL_TAG
	setup_serial_tag (&params);
#endif
#ifdef CONFIG_REVISION_TAG
	setup_revision_tag (&params);
#endif
#ifdef CONFIG_SETUP_MEMORY_TAGS
	setup_memory_tags (bd);
#endif
#ifdef CONFIG_CMDLINE_TAG
	setup_commandline_tag (bd, commandline);
#endif

//#ifdef CONFIG_INITRD_TAG
//	if (images->rd_start && images->rd_end)
//		setup_initrd_tag (bd, images->rd_start, images->rd_end);
//#endif
#ifdef CONFIG_ACTI
	setup_A1_macaddr_tag (bd);
#endif
	setup_end_tag (bd);
#endif

	printf (":A1 ATAG Done\n");
	return 0;
}

U_BOOT_CMD(
	a1tag, 1, 1, do_a1_tags,
	"Preparing ATAG for linux",
	"\n"
);
