#ifndef __A1_VIC_H__
#define __A1_VIC_H__
#include <asm/types.h>
#include <asm/arch/irq.h>

void vic_init(void);
void vic_enirq(IntrVector_E);
void vic_disirq(IntrVector_E);
void vic_cleanirq(IntrVector_E);
u32  vic_queryirq(void);
u32  reg_interrupt(INT_TYPE type, IntrVector_E source, ISR_FT ft);
void unregister_interrupt(IntrVector_E source);

typedef  volatile const u32 ro_reg32;
typedef  volatile u32   reg32;
#define Reserve(a,b)		PAD##a[b]

typedef struct _VIC1CON{
  ro_reg32	VIC1IRQStatusR;		/*IRQ status register*/
  ro_reg32	VIC1FIQStatusR;		/*FIQ status register*/
  ro_reg32	VIC1RawIntrR;		/*Raw interrupt status register*/	
  reg32		VIC1IntSelectR;		/*Interrupt select register*/	
  reg32		VIC1IntEnableR;		/*Interrupt enable register*/
  reg32		VIC1IntEnClearR;	/*Interrupt enable clear register*/
  reg32		VIC1SoftIntR;		/*Software interrupt register*/
  reg32		VIC1SoftIntclearR;	/*Software interrupt clear register*/
  reg32		VIC1ProtectionR;	/*Protection enable register*/
  reg32		VIC1SenseR;			/*Interrupt sense register (interrupt detector)*/
  reg32		VIC1BothEdgeR;		/*Interrupt both edges register (interrupt detector)*/
  reg32		VIC1EventR;			/*Interrupt event register (interrupt detector)*/
  u8		Reserve(0,0x8);
  reg32		VIC1EdgeClrR;		/*Edge-triggered interrupt clear register (interrupt detector)*/				
}VIC1CON,*pVIC1CON;

#endif /* __A1_VIC_H__ */
