#ifndef __A1_I2C_H__
#define __A1_I2C_H__

#define A1_I2C0_BASE	0x99500000
#define A1_I2C1_BASE	0x99600000
#define A1_I2C2_BASE	0x99700000

#define I2C_BUS_MAX	3
#define I2C_TIMEOUT	10

/* Definition for Register offset */
#define ENABLE_REG		(0x0 << 2)
#define	CONTROL_REG		(0x4 << 2)
#define DATA_REG		(0x8 << 2)
#define STATUS_REG		(0x9 << 2)
#define PSCALE_LO_REG	(0xC << 2)
#define PSCALE_HI_REG	(0xD << 2)

/* Definition for control bit */
#define IIC_ENABLE	1
#define IIC_DISABLE 0
#define IIC_WRITE	0
#define IIC_READ	1
#define IIC_CTRL_ACK	(1 << 0)
#define IIC_CTRL_IF		(1 << 1)
#define IIC_CTRL_START	(1 << 2)
#define IIC_CTRL_STOP	(1 << 3)

typedef struct _A1_i2c {
	u32 base;
	u32 init;
	u32 speed;
	u32	slaveaddr;
}A1_i2c;
#endif /* __A1_I2C_H__ */
