/*
 *  linux/include/asm-arm/arch-umvp/dma.h
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_DMA_H
#define __ASM_ARCH_DMA_H

#define MAX_DMA_ADDRESS		0xffffffff

#define MAX_DMA_CHANNELS	0

/*---------- above : don't modify at all ----------*/


typedef void (*umvp_dmap_intr_cb)(unsigned long);


enum umvp_dmap_transf_type
{
	/* source_to_destination */
	memory_to_memory = 0,
	memory_to_peripheral,
	peripheral_to_memory
};

enum umvp_dmap_peripheral_type
{
	memory = 0, 
	umvp_sd,
	umvp_sm,
	umvp_dai_tx,
	umvp_dai_rx,
};

enum umvp_dmap_transf_width
{
	transf_width_byte = 0,
	transf_width_halfword,
	transf_width_word,
};

enum umvp_dmap_transf_mode
{
	transf_mode_sigle = 0,
	transf_mode_src_burst,
	transf_mode_dst_burst,
	transf_mode_both_burst,
};



typedef enum umvp_dmap_transf_type		umvp_dmap_transf_type;
typedef enum umvp_dmap_peripheral_type	umvp_dmap_peripheral_type;
typedef enum umvp_dmap_transf_width		umvp_dmap_transf_width;
typedef enum umvp_dmap_transf_mode		umvp_dmap_transf_mode;

struct umvp_dmap_params
{
	umvp_dmap_transf_type transf_type;
	umvp_dmap_peripheral_type peripheral_type;
	umvp_dmap_transf_width transf_width;
	umvp_dmap_transf_mode  transf_mode;

	int src_addr_inc;	/* 0:not incremental;  otherwise: incremental */
	int dst_addr_inc;	/* 0:not incremental;  otherwise: incremental */
	int transf_bytes;

	unsigned int src_addr_phy;	/* source address (physical) */
	unsigned int dst_addr_phy;	/* dest.  address (physical) */
};

int umvp_dmap_request_some_channel(int chn, umvp_dmap_intr_cb cbf, unsigned long data);
int umvp_dmap_request_channel(umvp_dmap_intr_cb f, unsigned long data);
	/*
	 * argument f:
	 *    The callback function for the while that an interrupt
	 *    occurs at the dma channel assigned by this function.
	 *
	 * return value:
	 * -1 : no free DMA channel is available
	 * otherwise : return the DMA channel number
	 */

void umvp_dmap_release_channel(int nChannel);
	/*
	 * release the channel specified by the argument 'nChannel', which
	 * is returned by umvp_dmap_request_channel()
	 */

int umvp_dmap_start(int channel, struct umvp_dmap_params *params);
	/*
	 * return value:
	 *    0 : success to start a channel
	 *    otherwise : fail to start the specified channel
	 */

void umvp_dmap_stop(int channel);
	/*
	 * force to stop DMA's activation
	 */
	
int umvp_dmap_is_busy(int n);
	/*
	 * return value:
	 *    0 : channel n isn't busy
	 *    otherwise : channel n is busy
	 */

#endif /* _ASM_ARCH_DMA_H */

