/*
 *  linux/include/asm-arm/arch-umvp/time.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <asm/system.h>
#include <asm/arch/platform.h>


#define HAL_SETREG(r,v) (*((volatile unsigned int *)(r))=((unsigned int)(v)))
#define HAL_SETREG32(r,v) (*((volatile unsigned long *)(r))=((unsigned long)(v)))
#define HAL_GETREG(r)		(*((volatile unsigned int   *) (r)))
#define HAL_GETREG32(r) (*((volatile unsigned long *)(r)))

#define HAL_REG_SYS_BASE 				(IO_ADDRESS(UMVP_SYSTEM_BASE))
#define HAL_REG_SYS_ModeSts 			(HAL_REG_SYS_BASE+0x1C)
#define HAL_REG_LCD_BASE 				(IO_ADDRESS(UMVP_LCD_BASE))
#define HAL_REG_LCD_BaseR 				(HAL_REG_LCD_BASE+0x18)
#define HAL_REG_LCD_DOutR 				(HAL_REG_LCD_BASE+0x0C)
#define HAL_REG_LCD_BCOLORR 			(HAL_REG_LCD_BASE+0x44)
#define HAL_REG_LCD_HALIGNR 			(HAL_REG_LCD_BASE+0x3C)
#define HAL_REG_LCD_VALIGNR 			(HAL_REG_LCD_BASE+0x40)
#define HAL_REG_LCD_IFormR 				(HAL_REG_LCD_BASE+0x08)
#define HAL_REG_LCD_HCtrlR 				(HAL_REG_LCD_BASE+0x00)
#define HAL_REG_LCD_VCtrlR 				(HAL_REG_LCD_BASE+0x04)
#define HAL_REG_LCD_TCtrlR 				(HAL_REG_LCD_BASE+0x10)
#define HAL_REG_LCD_GPIOVR 				(HAL_REG_LCD_BASE+0x34)

#define PANEL_DATAIMAGE_VGA		1
#define PANEL_SHARP_LCY99037A	0
#define PANEL_CASIO_COM16T1151	0

#if PANEL_DATAIMAGE_VGA
	#define HAL_PANEL_WIDTH  640
	#define HAL_PANEL_HEIGHT 480
	#define HSizeParam		 0x3232793f
	#define VSizeParam		 0x0000b5df
	#define TimingCtrl		 0x00000460
	#define GPIOValue		 0x00000000
#endif

#if PANEL_SHARP_LCY99037A
	#define HAL_PANEL_WIDTH  320
	#define HAL_PANEL_HEIGHT 240
	#define HSizeParam		 0x33313a9f
	#define VSizeParam		 0x022010ef
	#define TimingCtrl		 0x00000460
	#define GPIOValue		 0x00000004
#endif

#if PANEL_CASIO_COM16T1151
	#define HAL_PANEL_WIDTH  120
	#define HAL_PANEL_HEIGHT 90
	#define HSizeParam		 0x0b5c0ab0
	#define VSizeParam		 0x000002ef
	#define TimingCtrl		 0x00000460
	#define GPIOValue		 0x00000004
#endif

#define halLCDDisable(void)				(HAL_SETREG(HAL_REG_LCD_DOutR, 0))
#define halLCDSetFrameDataStartAddr(x)	(HAL_SETREG(HAL_REG_LCD_BaseR, x))
#define halLCDEnable(void)				(HAL_SETREG(HAL_REG_LCD_DOutR, 1))

enum halDisplay_E
{
	halcTV 	= 1,
	halcLCD = 2,
	halcVGA = 3
	
};
typedef enum halDisplay_E halDisplay_E;
enum halLCDInputFormat_E
{
	halcLCDInputFormat_YCbYCr422	= 0,
	halcLCDInputFormat_YCrYCb422,
	halcLCDInputFormat_CbYCrY422,
	halcLCDInputFormat_CrYCbY422,

	halcLCDInputFormat_RGB1bpp,		/* need to provide a color pallet */
	halcLCDInputFormat_RGB2bpp,
	halcLCDInputFormat_RGB4bpp,
	halcLCDInputFormat_RGB8bpp,

	halcLCDInputFormat_RGB16bpp,	/* (R,G,B) = (5b,6b,5b) */
	halcLCDInputFormat_BGR16bpp,	/* (B,G,R) = (5b,6b,5b) */

	halcLCDInputFormat_RGB24bpp,	/* (R,G,B) = (8b,8b,8b) */
	halcLCDInputFormat_BGR24bpp		/* (B,G,R) = (8b,8b,8b) */
};

void halLCDSetBoder(unsigned int nBW, unsigned nBH, unsigned char nR, unsigned char nG, unsigned char nB);
void halLCDSetInputFormat(unsigned int bSysLittleEndian, enum halLCDInputFormat_E nFmt);
void halSysSelDisplay(halDisplay_E nDisplay);
void halLCDInit(void);
