# (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED
#
# All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
# Redistribution and use in source and binary forms, with or without modification,
# are strictly prohibited.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
UBOOT_OUTPUT = $(SANDBOX)/uboot
_NCPU ?= 1

uboot-build: output
	@if [ ! -d "$(UBOOT_OUTPUT)" ]; then \
		mkdir $(UBOOT_OUTPUT); \
	fi
	@printf "Making uboot\n"

	@if [ ! -f "$(UBOOT_PATH)/$(UBOOT_VERSION)/include/configs/$(A1_UBOOT_CONFIG).h" ]; then \
		printf "\n"; \
		printf "No \"$(A1_UBOOT_CONFIG)\" config file\n"; \
		printf "Check A1_UBOOT_CONFIG setting in config.cache file\n"; \
		printf "\n"; \
		exit; \
	fi
	@pushd $(UBOOT_PATH)/$(UBOOT_VERSION) ; \
	make -e TOOL_PATH=$(A1_UBOOT_TOOLCHAIN_HOME) CROSS_COMPILE=arm-elf- ARCH=arm $(A1_UBOOT_CONFIG)_config; \
	make -e TOOL_PATH=$(A1_UBOOT_TOOLCHAIN_HOME) CROSS_COMPILE=arm-elf- ARCH=arm -j$(_NCPU); \
	popd
	cp $(UBOOT_PATH)/$(UBOOT_VERSION)/u-boot.bin $(UBOOT_OUTPUT)
	cp $(UBOOT_PATH)/$(UBOOT_VERSION)/u-boot $(UBOOT_OUTPUT)
	cp $(UBOOT_PATH)/$(UBOOT_VERSION)/u-boot $(UBOOT_OUTPUT)/u-boot.elf

	@if [ -f $(SANDBOX)/bLoader-128k.bin ]; then \
		echo "cat $(SANDBOX)/bLoader-128k.bin $(UBOOT_OUTPUT)/u-boot.bin > $(SANDBOX)/mtd_uboot.bin";	\
		cat $(SANDBOX)/bLoader-128k.bin $(UBOOT_OUTPUT)/u-boot.bin > $(SANDBOX)/mtd_uboot.bin;	\
		padzero2_page_size.sh $(SANDBOX)/mtd_uboot.bin; \
	fi
#	@if [ -f  "$(UBOOT_PATH)/$(UBOOT_VERSION)/nand_spl/u-boot-spl.bin" ]; then \
#		cp $(UBOOT_PATH)/$(UBOOT_VERSION)/nand_spl/u-boot-spl.bin $(UBOOT_OUTPUT); \
#	fi
#	@if [ -f  "$(UBOOT_PATH)/$(UBOOT_VERSION)/u-boot-nand.bin" ]; then \
#		cp $(UBOOT_PATH)/$(UBOOT_VERSION)/u-boot-nand.bin $(UBOOT_OUTPUT); \
#	fi
	@if [ ! -f "$(BUILD_TOPDIR)/build/host/bin/mkimage" ]; then \
		cp $(UBOOT_PATH)/$(UBOOT_VERSION)/tools/mkimage $(BUILD_TOPDIR)/build/host/bin;	\
	fi

uboot-clean:
	@printf "Cleaning uboot\n"
	@make -e TOOL_PATH=$(A1_UBOOT_TOOLCHAIN_HOME) CROSS_COMPILE=arm-elf- -C $(UBOOT_PATH)/$(UBOOT_VERSION) distclean
	@rm -rf $(UBOOT_OUTPUT)

.PHONY: uboot-build uboot-clean
