# (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED
#
# All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
# Redistribution and use in source and binary forms, with or without modification,
# are strictly prohibited.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


SHELL = /bin/bash


all: sdb-toolchain-install crx-tools-install host-tools-install

sdb-toolchain-install: toolchain/ARM-ELF-CXT-VERSION

crx-tools-install: toolchain/ARM-CXT-VERSION

host-tools-install: host/bin/genext2fs

toolchain/ARM-ELF-CXT-VERSION:
	@pushd toolchain; \
	tar -jxvf $$(ls arm-elf-*.bz2); \
	printf "%s\n" $$(ls arm-elf/lib/gcc/arm-elf) >> ARM-ELF-CXT-VERSION; \
	popd

toolchain/ARM-CXT-VERSION:
	@pushd toolchain; \
	for dir in $$(ls *.bz2 | grep arm-\[0-9\]*q\[1-4\]); do \
		if [ -e $$dir ]; then \
			tar -jxvf $$dir; \
		fi; \
	done; \
	for dir in $$(ls | grep arm-\[0-9\]*q\[1-4\]); do \
		if [ -d $$dir ]; then \
			mv $$dir arm; \
			printf "%s\n" $$dir >> ARM-CXT-VERSION; \
			break; \
		fi; \
	done; \
	popd

host/bin/genext2fs:
	@pushd host; \
	tar -zxvf genext2fs-1.4.1.tar.gz; \
	cd genext2fs-1.4.1; ./configure; make; \
	install genext2fs ../bin; \
	cd ..; rm -rf genext2fs-1.4.1; \
	popd

.PHONY: all sdb-toolchain-install crx-tools-install host-tools-install
