# (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED
#
# All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
# Redistribution and use in source and binary forms, with or without modification,
# are strictly prohibited.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


root-fs-target: root-fs-build
	@printf "Creating root file system for target\n"
	@make -C $(BUILD_TOPDIR)/usr/root.fs RAMDISK_SIZE=$(RAMDISK_SIZE) target

publish-ramdisk:
	@printf "Creating RAM disk for target root fs\n"
	@make -C $(BUILD_TOPDIR)/usr/root.fs RAMDISK_SIZE=$(RAMDISK_SIZE) publish-rootfs-ext2-ramdisk

bootpImage:
	@printf "Creating bootpImage\n"
	@if [ -f $(BUILD_TOPDIR)/kernel/linux/arch/arm/boot/bootpImage ]; then \
			rm -f $(BUILD_TOPDIR)/kernel/linux/arch/arm/boot/bootpImage ;\
			rm -f $(BUILD_TOPDIR)/kernel/linux/arch/arm/boot/bootp/*.o;\
	fi
	@make -C $(BUILD_TOPDIR)/kernel/linux bootpImage INITRD=$(BUILD_TOPDIR)/$(SANDBOX)/ramdisk.gz
	@cp -f $(BUILD_TOPDIR)/kernel/linux/arch/arm/boot/bootpImage $(BUILD_TOPDIR)/$(SANDBOX)/
	@printf "Creating U-BOOT bootpImage.ub\n"
	@mkimage -A arm -O linux -T kernel -C none -a 0x58000000 -e 0x58000040 -d $(BUILD_TOPDIR)/$(SANDBOX)/bootpImage $(BUILD_TOPDIR)/$(SANDBOX)/bootpImage.ub
	padzero2_page_size.sh $(BUILD_TOPDIR)/$(SANDBOX)/bootpImage.ub

root-fs-target-bamboo: root-fs-build
	@printf "Creating root file system for target\n"
	@make -C $(BUILD_TOPDIR)/usr/root.fs \
		  RAMDISK_SIZE=$(RAMDISK_SIZE) target

strip-modules: DESTINATION = $(SANDBOX)/target
strip-modules:
	@if [ $(STRIP_MODULES) = no ]; then \
		printf "Skip modules stripping stage\n"; \
	else \
		printf "Stripping all modules\n"; \
		$(CROSS_COMPILE)strip -d $(DESTINATION)/lib/modules/*.ko ;\
	fi

strip-gcc-libs: DESTINATION = $(SANDBOX)/target
strip-gcc-libs:
	@$(CROSS_COMPILE)strip -s $(DESTINATION)/lib/*.so

strip-apps: DESTINATION = $(SANDBOX)/target
strip-apps:
	@rm -f $(DESTINATION)/lib/*.a
	@rm -f $(DESTINATION)/usr/lib/*.a
	@rm -f $(DESTINATION)/usr/lib/*.la
	@rm -f $(DESTINATION)/usr/bin/*-config
	@rm -rf $(DESTINATION)/usr/lib/pkgconfig
	@rm -rf $(DESTINATION)/usr/man
	@rm -rf $(DESTINATION)/usr/include
	@rm -rf $(DESTINATION)/usr/share/man
	@rm -rf $(DESTINATION)/usr/share/sounds
	@rm -rf $(DESTINATION)/usr/share/terminfo
	@rm -rf $(DESTINATION)/usr/share/info
	@rm -rf $(DESTINATION)/usr/share/tabset
	@rm -rf $(DESTINATION)/usr/share/aclocal
#	@rm -rf $(DESTINATION)/usr/share/alsa
# Remove specific files here
	@if [ -e $(DESTINATION)/usr/sbin/alsaconf ]; 	then rm -f $(DESTINATION)/usr/sbin/alsaconf; fi
	@if [ -e $(DESTINATION)/usr/sbin/flash_info ]; 	then rm -f $(DESTINATION)/usr/sbin/flash_info; fi
	@if [ -e $(DESTINATION)/usr/sbin/flash_lock ]; 	then rm -f $(DESTINATION)/usr/sbin/flash_lock; fi
	@if [ -e $(DESTINATION)/usr/sbin/flash_unlock ];then rm -f $(DESTINATION)/usr/sbin/flash_unlock; fi
	@if [ -e $(DESTINATION)/usr/bin/strace-graph ]; then rm -f $(DESTINATION)/usr/bin/strace-graph; fi
# end of remove section
	@$(CROSS_COMPILE)strip -s $(DESTINATION)/usr/lib/*.so
	@$(CROSS_COMPILE)strip -s $(DESTINATION)/usr/bin/*
	@$(CROSS_COMPILE)strip -s $(DESTINATION)/usr/sbin/*
#	@$(CROSS_COMPILE)strip -s $(DESTINATION)/usr/local/bin/*

check-configure-file:
	@if [ ! -e "config.cache" ]; then \
		printf "\tconfig.cache doesn't exist. \n"; \
		printf "\tPlease execute 'make configure' in order to configure the project.\n"; \
		exit 1; \
	fi

sandbox-install-all:
	@if [ -d "sandbox" ]; then \
		make -C sandbox CROSS_COMPILE=$(CROSS_COMPILE) OPTIMIZATION_LEVEL=$(OPTIMIZATION_LEVEL) install; \
	fi


install-staging: check-configure-file kernel-modules-install packages-install workspace-only-install sandbox-install-all

firmware-build: install-staging root-fs-target strip-modules strip-gcc-libs strip-apps publish-ramdisk bootpImage

firmware-build-bamboo: install-staging root-fs-target-bamboo strip-modules strip-gcc-libs strip-apps publish-ramdisk

.PHONY: check-configure-file install-staging strip-modules strip-gcc-libs strip-apps root-fs-target firmware-build publish-ramdisk sandbox-install-all
