/*
 * =====================================================================================
 *
 *       Filename:  ddr.h
 *
 *    Description:  MCTL Register Definition
 *
 *					Refer to "DesignWare Cores DDR2/3-Lite/mDDR SDRAM memory Controller 
 *								Databook, Version 2.00a", Chapter 6.3 
 *
 *        Version:  1.0
 *        Created:  06/09/11 14:39:02
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  YOUR NAME (), 
 *        Company:  
 *
 * =====================================================================================
 */

#define DDR_CTRL_BASE		0x90D00000
#define SYSTEM_REG_BASE		0x99000000

#define DDR2_INIT_STATUS_OFFSET	0xF004
#define SYSTEM_REG_DDR2_INIT_STS	(SYSTEM_REG_BASE + DDR2_INIT_STATUS_OFFSET)
#define DDR2_INIT_STS_BUSY	0x00000001

#define CFG_DDR_DSIZE	DCR_DSIZE_1Gb	/* configurable */

#define CFG_DDR_BL		TPR3_BL4		/* configurable */
#define CFG_DDR_CL		TPR3_CL(5)		/* configurable */
#define CFG_DDR_CWL		TPR3_CWL(4)		/* configurable */
#define CFG_DDR_WR		TPR3_WR(3)		/* configurable */
#define CFG_DDR_AL		TPR3_AL(0)		/* configurable */

#define CFG_DRR_TRR		DRR_TRR(53)		/* configurable */
#define CFG_DRR_TRP		DRR_TRP(27800)	/* configurable */
#define CFG_DRR_TRB		DRR_TRB(8)		/* configurable */

/* 
 * =====================================================================================
 * CCR:	Controller Configuration Register
 *
 * =====================================================================================
 */
#define CCR_HOST_EN		(1 << 2)	/* Host Enable */
#define CCR_DTT_EN		(1 << 30)	/* Data Training Trigger */
#define CCR_INIT_EN		(1 << 31)	/* Initializtion Trigger */

/* 
 * =====================================================================================
 * DCR:	DRAM Coniguration Register
 *
 * DRAM Chip Density Definition 
 * =====================================================================================
 */
#define DCR_DSIZE_64Mb	(0 << 4)	
#define DCR_DSIZE_128Mb	(1 << 4)
#define DCR_DSIZE_256Mb	(2 << 4)
#define DCR_DSIZE_512Mb	(3 << 4)
#define DCR_DSIZE_1Gb	(4 << 4)
#define DCR_DSIZE_2Gb	(5 << 4)
#define DCR_DSIZE_4Gb	(6 << 4)
#define DCR_DSIZE_8Gb	(7 << 4)

/* 
 * =====================================================================================
 * TPR3: SDRAM Timing Parameters Register 3
 *
 * TPR0-2 wiil be automatically set by data training
 * =====================================================================================
 */

/* BL[1:0],	DDR Burst Length */
#define	TPR3_BL2	0	/* Burst Length of 2 */
#define	TPR3_BL4	1	/* Burst Length of 4 */
#define	TPR3_BL8	2	/* Burst Length of 8 */
#define	TPR3_BL16	3	/* Burst Length of 16 */

#define TPR3_CL(v)	(v << 3)	/* CL[6:3],	DDR CAS Latency */
#define TPR3_CWL(v)	(v << 7)	/* CWL[10:7], DDR CAS Write Latency */
#define TPR3_WR(v)	(v << 11)	/* WR[14:11], DDR Write Recovery	*/
#define TPR3_AL(v)	(v << 15)	/* AL[18:15], DDR Posted CAS Additive Latency */

/* 
 * =====================================================================================
 * DRR:	DRAM Refresh Register
 *
 * =====================================================================================
 */
#define DRR_TRR(v)	(v << 0)	/* TRR[7:0], Refresh-to-Refresh */
#define DRR_TRP(v)	(v << 8)	/* TRP[23:8], Refresh Period */
#define DRR_TRB(v)	(v << 24)	/* TRB[27:24], Refresh Burst */

/*
 * =====================================================================================
 * DDR Init Values to be Programmed
 * =====================================================================================
 */
#define MCTL_CCR_INIT_VALUE		(CCR_INIT_EN | CCR_HOST_EN)
#define MCTL_CCR_TRAIN_VALUE	(CCR_DTT_EN | CCR_HOST_EN)

#define MCTL_DCR_DEFAULT	0x01020188

#define MCTL_DCR_VALUE		(MCTL_DCR_DEFAULT | CFG_DDR_DSIZE)
#define MCTL_TPR3_VALUE		(CFG_DDR_AL | CFG_DDR_WR | CFG_DDR_CWL | CFG_DDR_CL | CFG_DDR_BL)        
#define MCTL_DRR_VALUE		(CFG_DRR_TRR | CFG_DRR_TRP | CFG_DRR_TRB)

/*
 * =====================================================================================
 * All Register Definition and Offset
 * =====================================================================================
 */

#define MCTL_CCR		(DDR_CTRL_BASE + (0x00 << 2))
#define MCTL_DCR		(DDR_CTRL_BASE + (0x01 << 2))
#define MCTL_IOCR		(DDR_CTRL_BASE + (0x02 << 2))
#define MCTL_CSR		(DDR_CTRL_BASE + (0x03 << 2))
#define MCTL_DRR		(DDR_CTRL_BASE + (0x04 << 2))

#define MCTL_TPR0		(DDR_CTRL_BASE + (0x05 << 2))
#define MCTL_TPR1		(DDR_CTRL_BASE + (0x06 << 2))
#define MCTL_TPR2		(DDR_CTRL_BASE + (0x07 << 2))

#define MCTL_DLLCR		(DDR_CTRL_BASE + (0x08 << 2))

#define MCTL_DLLCR0		(DDR_CTRL_BASE + (0x09 << 2))
#define MCTL_DLLCR1		(DDR_CTRL_BASE + (0x0A << 2))
#define MCTL_DLLCR2		(DDR_CTRL_BASE + (0x0B << 2))
#define MCTL_DLLCR3		(DDR_CTRL_BASE + (0x0C << 2))
#define MCTL_DLLCR4		(DDR_CTRL_BASE + (0x0D << 2))
#define MCTL_DLLCR5		(DDR_CTRL_BASE + (0x0E << 2))
#define MCTL_DLLCR6		(DDR_CTRL_BASE + (0x0F << 2))
#define MCTL_DLLCR7		(DDR_CTRL_BASE + (0x10 << 2))
#define MCTL_DLLCR8		(DDR_CTRL_BASE + (0x11 << 2))
#define MCTL_DLLCR9		(DDR_CTRL_BASE + (0x12 << 2))

#define MCTL_RSLR0		(DDR_CTRL_BASE + (0x13 << 2))
#define MCTL_RSLR1		(DDR_CTRL_BASE + (0x14 << 2))
#define MCTL_RSLR2		(DDR_CTRL_BASE + (0x15 << 2))
#define MCTL_RSLR3		(DDR_CTRL_BASE + (0x16 << 2))

#define MCTL_RDGR0		(DDR_CTRL_BASE + (0x17 << 2))
#define MCTL_RDGR1		(DDR_CTRL_BASE + (0x18 << 2))
#define MCTL_RDGR2		(DDR_CTRL_BASE + (0x19 << 2))
#define MCTL_RDGR3		(DDR_CTRL_BASE + (0x1A << 2))

#define MCTL_DQTR0		(DDR_CTRL_BASE + (0x1B << 2))
#define MCTL_DQTR1		(DDR_CTRL_BASE + (0x1C << 2))
#define MCTL_DQTR2		(DDR_CTRL_BASE + (0x1D << 2))
#define MCTL_DQTR3		(DDR_CTRL_BASE + (0x1E << 2))
#define MCTL_DQTR4		(DDR_CTRL_BASE + (0x1F << 2))
#define MCTL_DQTR5		(DDR_CTRL_BASE + (0x20 << 2))
#define MCTL_DQTR6		(DDR_CTRL_BASE + (0x21 << 2))
#define MCTL_DQTR7		(DDR_CTRL_BASE + (0x22 << 2))
#define MCTL_DQTR8		(DDR_CTRL_BASE + (0x23 << 2))

#define MCTL_DQSTR		(DDR_CTRL_BASE + (0x24 << 2))
#define MCTL_DQSBTR		(DDR_CTRL_BASE + (0x25 << 2))
#define MCTL_ODTCR		(DDR_CTRL_BASE + (0x26 << 2))

#define MCTL_DTR0		(DDR_CTRL_BASE + (0x27 << 2))	
#define MCTL_DTR1		(DDR_CTRL_BASE + (0x28 << 2))

#define MCTL_DTAR		(DDR_CTRL_BASE + (0x29 << 2))

#define MCTL_ZQCR0		(DDR_CTRL_BASE + (0x2A << 2))
#define MCTL_ZQCR1		(DDR_CTRL_BASE + (0x2B << 2))
#define MCTL_ZQCR2		(DDR_CTRL_BASE + (0x2C << 2))

#define MCTL_ZQSR		(DDR_CTRL_BASE + (0x2D << 2))
#define MCTL_TPR3		(DDR_CTRL_BASE + (0x2E << 2))
#define MCTL_ALPMR		(DDR_CTRL_BASE + (0x2F << 2))

#define MCTL_MR			(DDR_CTRL_BASE + (0x7C << 2))
#define MCTL_EMR		(DDR_CTRL_BASE + (0x7D << 2))
#define MCTL_EMR2		(DDR_CTRL_BASE + (0x7E << 2))
#define MCTL_EMR3		(DDR_CTRL_BASE + (0x7F << 2))
