/*
 * ALSA SoC I2S (McBSP) Audio Layer for UMVP I2S
 * Author:      Betta Lin, <Betta.Lin@acti.com>
 * Copyright:   (C) 2010 ACTI, Inc., 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef _UMVP_I2S_H
#define _UMVP_I2S_H

#include <mach/platform2500.h> /* For  UMVP2500_APBCLOCK */
#include <mach/hardware.h> /* For IO_ADDRESS */

/* UMVP DAI registers offset */
#define DAI_MODE		0x0
#define DAI_RX_CTRL		0x4
#define DAI_TX_CTRL 		0x8
#define DAI_WLEN               	0xC
#define DAI_WPOS              	0x10
#define DAI_SLOT              	0x14
#define DAI_TX_FIFO_LTH       	0x18
#define DAI_RX_FIFO_GTH       	0x1C
#define DAI_CLOCK             	0x20
#define DAI_INIT              	0x24
#define DAI_TX_FIFO_FLAG      	0x28
#define DAI_TX_LEFT_DATA      	0x2C
#define DAI_TX_RIGHT_DATA     	0x30
#define DAI_RX_FIFO_FLAG      	0x34
#define DAI_RX_DATA           	0x38
#define DAI_TX_FIFO_CNTR      	0x3C
#define DAI_RX_FIFO_CNTR      	0x40
#define DAI_CLOCKOUT_CTRL				0x4C
#define DAI_CLOCKOUT_DIV				0x50		

/* private div controll ID */

#define UMVP_CODEC_CLK_DIV_ON 0
#define UMVP_CODEC_CLK_DIV_OFF 1

extern struct snd_soc_dai umvp_i2s_dai;

#endif
