/*
 * i2c-umvp.c
 *
 * Copyright (C) 2009 Peter Lee @ GUC co.
 *
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/isa.h>
#include <linux/i2c.h>
#include <linux/i2c-algo-guc.h>

#include <asm/io.h>
#include <asm/irq.h>

#include <mach/umvp_i2c.h>
#include <mach/i2c-algo-guc.h>


//#define guc_offset(x)	((x)/(4))
//static int clock = 0x18; //betta
//static struct i2c_umvp *i2c; //betta m

struct i2c_adapter *adap[3];
struct i2c_algo_guc_data  *guc_adap[3];
#if 0
/* move to mach/umvp_i2c.h*/
struct i2c_umvp {
	struct i2c_adapter	 adap;
	struct i2c_algo_pcf_data algo;
	u32 			 *base;	
};
#endif

static void i2c_umvp_setbyte(void *data, int ctl, int val)
{
	u32	address, UMVP_I2C_BASE = 0;
	int bus_id = (int) data;
	if (bus_id == 0)     UMVP_I2C_BASE = IO_ADDRESS(UMVP_I2C0_BASE);
	else if (bus_id == 1)UMVP_I2C_BASE = IO_ADDRESS(UMVP_I2C1_BASE);
	else if(bus_id == 2) UMVP_I2C_BASE = IO_ADDRESS(UMVP_I2C2_BASE);

	//printk(KERN_INFO "*****i2c_umvp_setbyte*****\n");
	if (ctl) {
		address = UMVP_I2C_BASE +guc_offset(UMVP_I2C_CTRL);
		//printk("i2c_umvp_setbyte:i2c->base+UMVP_I2C1_CTRL=%8p\n", address);
	} else {
		address = UMVP_I2C_BASE + guc_offset(UMVP_I2C_DATR);
		//printk("i2c_umvp_setbyte:i2c->base+UMVP_I2C1_DATR=%8p\n", address);
	}
	//printk(KERN_INFO "%s: Write %p 0x%02X\n", i2c->adap.name,	address, val);
	writel(val, address);
	
}

static int i2c_umvp_getbyte(void *data, int ctl)
{
	int 	val;
	u32	address, UMVP_I2C_BASE = 0;
	int bus_id = (int) data;
	if (bus_id == 0)     UMVP_I2C_BASE = IO_ADDRESS(UMVP_I2C0_BASE);
	else if (bus_id == 1)UMVP_I2C_BASE = IO_ADDRESS(UMVP_I2C1_BASE);
	else if(bus_id == 2) UMVP_I2C_BASE = IO_ADDRESS(UMVP_I2C2_BASE);


	//printk(KERN_INFO "*****i2c_umvp_getbyte*****\n");
	if (ctl) {
		address = UMVP_I2C_BASE + guc_offset(UMVP_I2C_CTRL);
		//printk("i2c_umvp_getbyte:i2c->base+UMVP_I2C1_CTRL=%8p\n", address);
	} else {
		address = UMVP_I2C_BASE + guc_offset(UMVP_I2C_DATR);
		//printk("i2c_umvp_getbyte:i2c->base+UMVP_I2C1_DATR=%8p\n", address);
	}
	val = readl(address);
	//printk(KERN_INFO "%s: Read %p 0x%02X\n", i2c->adap.name,address, val);
	return (val);
}

#if 0 //betta m

static void i2c_umvp_waitforint(void *data)
{
}

static struct i2c_algo_guc_data i2c_umvp_algo = {
	.gucset		= i2c_umvp_setbyte,
	.gucget		= i2c_umvp_getbyte,
	//.guc_getclock	= i2c_umvp_getclock, //betta m
	.guc_waitforint	= i2c_umvp_waitforint,
};


static struct i2c_adapter i2c_umvp_adap = {
	.owner		= THIS_MODULE,
	.class		= I2C_CLASS_HWMON | I2C_CLASS_TV_ANALOG | I2C_CLASS_TV_DIGITAL,
	.algo_data	= &i2c_umvp_algo,
	.name		= "umvp-i2c-adapter",
};
#endif


static int __init i2c_umvp_init(void)
{
	int ret, i;
	
#if 0
	printk("i2c_kmalloc \n");
	i2c = kmalloc(sizeof(struct i2c_umvp), GFP_KERNEL | GFP_ATOMIC);
	if (!i2c) {
		ret = -ENOMEM;for (i=0; i<3; i++)
		printk("fail i2c_kmalloc\n");
		return ret;
	}
	i2c->adap = i2c_umvp_adap;
	i2c->base = (unsigned int *)IO_ADDRESS(UMVP_I2C1_BASE);
	printk("i2c_base:0x%8p\n", i2c->base);
#endif
	
	guc_init_umvp();
	for (i=0; i<3; i++)
	{
		adap[i] = kzalloc(sizeof(struct i2c_adapter), GFP_KERNEL);
		if (!adap[i]) return -1;	
		
		guc_adap[i] = kzalloc(sizeof(struct i2c_algo_guc_data), GFP_KERNEL);
		if (!guc_adap[i]) return -1;	
		guc_adap[i]->gucset = i2c_umvp_setbyte;
		guc_adap[i]->gucget = i2c_umvp_getbyte;

		adap[i]->owner = THIS_MODULE;
	//snprintf(adap->name, sizeof(adap->name), "i2c-gpio%d", pdev->id);
		adap[i]->algo_data = guc_adap[i];
		adap[i]->class = I2C_CLASS_HWMON | I2C_CLASS_TV_ANALOG | I2C_CLASS_TV_DIGITAL | I2C_CLASS_SPD;

		ret = i2c_umvp_add_bus(adap[i]);
		guc_adap[i]->data = (void *) adap[i]->nr;
	}
	return ret;
//	return i2c_umvp_add_bus(&i2c_umvp_adap);
}

static void __exit i2c_umvp_exit(void)
{
	int i;
	//i2c_del_adapter(&i2c->adap);
	for (i=0; i<3; i++)
	{
		i2c_del_adapter(adap[i]);
		if (adap[i]) kfree(adap[i]);
		if (guc_adap[i]) kfree(guc_adap[i]);
	}
}

MODULE_DESCRIPTION("GUC UMVP I2C bus driver");
MODULE_LICENSE("GPL");
MODULE_ALIAS("platform:umvp-i2c");

module_init(i2c_umvp_init);
module_exit(i2c_umvp_exit);

