/*
 * arch/arm/mach-umvp/include/mach/irqs.h
 *
 *  Copyright (C) 2009 Global Unichip Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

#ifdef CONFIG_MACH_UMVP2500
#include <mach/platform2500.h>
#endif

#define FIQ_START							32

#define IRQ_VFE_COMPLETE                INT_VFE_COMPLETE
#define IRQ_TIMERINT0                   INT_TIMERINT0
#define IRQ_TIMERINT1                   INT_TIMERINT1
#define IRQ_TIMERINT2                   INT_TIMERINT2
#define IRQ_UARTINT0                    INT_UARTINT0
#define IRQ_UARTINT1                    INT_UARTINT1

#define IRQMASK_VFE_COMPLETE            INTMASK_VFE_COMPLETE
#define IRQMASK_TIMERINT0               INTMASK_TIMERINT0
#define IRQMASK_TIMERINT1               INTMASK_TIMERINT1
#define IRQMASK_TIMERINT2               INTMASK_TIMERINT2
#define IRQMASK_UARTINT0                INTMASK_UARTINT0
#define IRQMASK_UARTINT1                INTMASK_UARTINT1

/*
 *  *  * VIC Register (VA)
 *   *   */
#define VIC_SENSE_VA                    (IO_ADDRESS(UMVP_VIC_BASE)+UMVP_VIC_SENSE_OFFSET)
#define VIC_EVENT_VA                    (IO_ADDRESS(UMVP_VIC_BASE)+UMVP_VIC_EVENT_OFFSET)
#define VIC_BOTH_EDGE_VA                (IO_ADDRESS(UMVP_VIC_BASE)+UMVP_VIC_BOTH_EDGE_OFFSET)
#define VIC_EDGE_CLEAR_VA               (IO_ADDRESS(UMVP_VIC_BASE)+UMVP_VIC_EDGE_CLEAR_OFFSET)

#define IRQ_SET_LEVEL_TRIGGER(irq_no)   *((volatile unsigned long*)VIC_SENSE_VA) |= 1 << (irq_no)
#define IRQ_SET_EDGE_TRIGGER(irq_no)    *((volatile unsigned long*)VIC_SENSE_VA) &= ~(1 << (irq_no))
#define IRQ_SET_RISING_EDGE(irq_no)     *((volatile unsigned long*)VIC_EVENT_VA) |= 1 << (irq_no)
#define IRQ_SET_FALLING_EDGE(irq_no)    *((volatile unsigned long*)VIC_EVENT_VA) &= ~(1 << (irq_no))
#define IRQ_SET_HIGH_LEVEL(irq_no)      *((volatile unsigned long*)VIC_EVENT_VA) |= 1 << (irq_no)
#define IRQ_SET_LOW_LEVEL(irq_no)       *((volatile unsigned long*)VIC_EVENT_VA) &= ~(1 << (irq_no))
#define IRQ_SET_BOTH_EDGE(irq_no)       *((volatile unsigned long*)VIC_BOTH_EDGE_VA) |= 1 << (irq_no)
#define IRQ_SET_SINGLE_EDGE(irq_no)     *((volatile unsigned long*)VIC_BOTH_EDGE_VA) &= ~(1 << (irq_no))
#define IRQ_EDGE_CLEAR(irq_no)          *((volatile unsigned long*)VIC_EDGE_CLEAR_VA) |= 1 << (irq_no)

#if 0
#define NR_IRQS                         (MAXIRQNUM + 1)
#else
#define NR_A1_IRQS                      (MAXIRQNUM + 1)
#define NR_A1_FIQS							32
#define NR_IRQS                         (NR_A1_FIQS + NR_A1_IRQS)
#endif


typedef enum vic_intr_trig_mode_E
{
    vicc_edge_activeFalling = 0,
    vicc_edge_activeRaising = 1,
    vicc_edge_activeBoth    = 2,
    vicc_level_activeHigh   = 3,
    vicc_level_activeLow    = 4
} vic_intr_trig_mode_E;

void vic_set_intr_trigger(int irqnr, vic_intr_trig_mode_E);
void vic_clear_intr(int irqnr);

#endif
